/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import kafka.admin.balancer.ClusterRebalanceCommand$;
import kafka.admin.balancer.ClusterRebalanceCommandOptions;
import kafka.common.AdminCommandFailedException;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBalancerStatusResult;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusResult;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.SystemTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00046\u0001\u0001\u0006I!\f\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0011\u0019Y\u0004\u0001)A\u0005q!9A\b\u0001b\u0001\n\u00039\u0004BB\u001f\u0001A\u0003%\u0001\bC\u0004?\u0001\u0001\u0007I\u0011A \t\u000f1\u0003\u0001\u0019!C\u0001\u001b\"11\u000b\u0001Q!\n\u0001CQ\u0001\u0016\u0001\u0005\u0002UCQ!\u0019\u0001\u0005\n\tDQ\u0001 \u0001\u0005\u0002UCa!a\u0001\u0001\t\u0003)\u0006bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\u0007\u0003+\u0001A\u0011A+\t\r\u0005e\u0001\u0001\"\u0001V\u0011\u0019\ti\u0002\u0001C\u0001+\"9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0002bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u0019\ti\u0006\u0001C\u0001+\"9\u0011\u0011\r\u0001\u0005\n\u0005\r$aG\"mkN$XM\u001d*fE\u0006d\u0017M\\2f\u0007>lW.\u00198e)\u0016\u001cHO\u0003\u0002\u001b7\u0005A!-\u00197b]\u000e,'O\u0003\u0002\u001d;\u0005)\u0011\rZ7j]*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00023\u0005y!m\\8ugR\u0014\u0018\r]*feZ,'/F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003mC:<'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012aa\u0015;sS:<\u0017\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:!\u00035\u0019WO\u001d:f]R$\u0016.\\3NgV\t\u0001\b\u0005\u0002#s%\u0011!h\t\u0002\u0005\u0019>tw-\u0001\bdkJ\u0014XM\u001c;US6,Wj\u001d\u0011\u0002\u0015A\u0014XM\u001e+j[\u0016l5/A\u0006qe\u00164H+[7f\u001bN\u0004\u0013a\u0004;fgR\fE-\\5o\u00072LWM\u001c;\u0016\u0003\u0001\u0003\"!\u0011&\u000e\u0003\tS!\u0001H\"\u000b\u0005\u0011+\u0015aB2mS\u0016tGo\u001d\u0006\u0003=\u0019S!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO&\u00111J\u0011\u0002\u0010\u001b>\u001c7.\u00113nS:\u001cE.[3oi\u0006\u0019B/Z:u\u0003\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011a*\u0015\t\u0003E=K!\u0001U\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b%&\t\t\u00111\u0001A\u0003\rAH%M\u0001\u0011i\u0016\u001cH/\u00113nS:\u001cE.[3oi\u0002\nQa]3u+B$\u0012A\u0014\u0015\u0003\u0017]\u0003\"\u0001W0\u000e\u0003eS!AW.\u0002\u0007\u0005\u0004\u0018N\u0003\u0002];\u00069!.\u001e9ji\u0016\u0014(B\u00010I\u0003\u0015QWO\\5u\u0013\t\u0001\u0017L\u0001\u0006CK\u001a|'/Z#bG\"\f!B];o\u0007>lW.\u00198e)\u0011\u0019WN\u001d;\u0011\u0005\u0011\\gBA3j!\t17%D\u0001h\u0015\tAw$\u0001\u0004=e>|GOP\u0005\u0003U\u000e\na\u0001\u0015:fI\u00164\u0017B\u0001\u001bm\u0015\tQ7\u0005C\u0003o\u0019\u0001\u0007q.\u0001\u0003be\u001e\u001c\bc\u0001\u0012qG&\u0011\u0011o\t\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006g2\u0001\r\u0001Q\u0001\u0010[>\u001c7.\u00113nS:\u001cE.[3oi\")Q\u000f\u0004a\u0001m\u0006A\"-\u00197b]\u000e,'oQ8n[\u0006tGm\u00149fe\u0006$\u0018n\u001c8\u0011\t\t:\u0018PT\u0005\u0003q\u000e\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0005S\u0018BA>C\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\f!\u0003^3ti\u000e{W.\\1oI>\u0003H/[8og\"\u0012QB \t\u00031~L1!!\u0001Z\u0005\u0011!Vm\u001d;\u0002QQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3CC2\fgnY3s'R\fG/^:TS6\u0004H.Z*uCR,8/Z:)\u00059q\u0018\u0001I1tg\u0016\u0014Ho\u0015;biV\u001cH+\u001f9f!J|\u0007/\u001a:msJ+\u0007o\u001c:uK\u0012$2ATA\u0006\u0011\u001d\tia\u0004a\u0001\u0003\u001f\t\u0001c\u001d;biV\u001cHk\u001c,bY&$\u0017\r^3\u0011\u0007\u0005\u000b\t\"C\u0002\u0002\u0014\t\u0013aBQ1mC:\u001cWM]*uCR,8/A\u0013uKN$H)Z:de&\u0014WMQ1mC:\u001cWM]*uCR,8/\u0012:s_J\u001cF/\u0019;vg\"\u0012\u0001C`\u0001\u001bi\u0016\u001cH\u000fR3tGJL'-Z+oKZ,g\u000eT8bIR\u000b7o\u001b\u0015\u0003#y\fa\u0006^3ti\u0012+7o\u0019:jE\u0016,f.\u001a<f]2{\u0017\rZ%o\t&\u001c\u0018M\u00197fI\u0006sGm\u0015;beR\u001cF/\u0019;fg\"\u0012!C`\u0001*m\u0006d\u0017\u000eZ1uK>+H\u000f];u\u0003:$WI\u001d:pe\u001a{'/\u00168fm\u0016tGj\\1e'R\fG/^:\u0015\u000b9\u000b)#a\f\t\u000f\u0005\u001d2\u00031\u0001\u0002*\u0005i1-\u001e:sK:$8\u000b^1ukN\u00042!QA\u0016\u0013\r\tiC\u0011\u0002\u0016\u000bZ,gn\u00117vgR,'\u000fT8bIN#\u0018\r^;t\u0011\u001d\t\td\u0005a\u0001\u0003S\t!\u0002\u001d:fmN#\u0018\r^;t\u0003a1\u0018\r\\5eCR,WK\\3wK:du.\u00193Ti\u0006$Xo\u001d\u000b\bG\u0006]\u00121HA \u0011\u001d\tI\u0004\u0006a\u0001\u0003S\t\u0011\u0003^3ti\u000e+(O]3oiN#\u0018\r^;t\u0011\u001d\ti\u0004\u0006a\u0001\u0003S\ta\u0002^3tiB\u0013XM^*uCR,8\u000fC\u0004\u0002BQ\u0001\r!a\u0011\u0002\u001b\u0015\u0014(o\u001c:U_J+G/\u001e:o!\r\t\u0015QI\u0005\u0004\u0003\u000f\u0012%A\u0006\"bY\u0006t7-\u001a:Pa\u0016\u0014\u0018\r^5p]\u0016\u0013(o\u001c:\u00029M,G/\u001e9Fm\u0016tGj\\1e\t\u0016\u001c8M]5qi&|g.T8dWRYa*!\u0014\u0002P\u0005E\u0013QKA-\u0011\u001d\t9#\u0006a\u0001\u0003SAq!!\r\u0016\u0001\u0004\tI\u0003\u0003\u0004\u0002TU\u0001\r\u0001O\u0001\u0014GV\u0014(/\u001a8u+B$\u0017\r^3US6,Wj\u001d\u0005\u0007\u0003/*\u0002\u0019\u0001\u001d\u0002!A\u0014XM^+qI\u0006$X\rV5nK6\u001b\bbBA.+\u0001\u0007\u00111I\u0001\u000f_B,'/\u0019;j_:,%O]8s\u0003\u0001\"Xm\u001d;EKN\u001c'/\u001b2f+:,g/\u001a8M_\u0006$G+Y:l\u000bJ\u0014xN]:)\u0005Yq\u0018!D4fi\u0016\u0013(o\u001c:SK\u001e,\u0007\u0010\u0006\u0004\u0002f\u0005U\u0014\u0011\u0010\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003!i\u0017\r^2iS:<'bAA8G\u0005!Q\u000f^5m\u0013\u0011\t\u0019(!\u001b\u0003\u001fUs\u0017M\\2i_J,GMU3hKbDa!a\u001e\u0018\u0001\u0004\u0019\u0017!E3ya\u0016\u001cG/\u001a3QQ\u0006\u001cXMT1nK\"9\u00111P\fA\u0002\u0005\r\u0013!D3ya\u0016\u001cG/\u001a3FeJ|'\u000f")
public class ClusterRebalanceCommandTest {
    private final String bootstrapServer;
    private final long currentTimeMs = new SystemTime().hiResClockMs();
    private final long prevTimeMs = this.currentTimeMs() - new package.DurationInt(package$.MODULE$.DurationInt(60)).second().toMillis();
    private MockAdminClient testAdminClient = (MockAdminClient)Mockito.mock(MockAdminClient.class);

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    public long prevTimeMs() {
        return this.prevTimeMs;
    }

    public MockAdminClient testAdminClient() {
        return this.testAdminClient;
    }

    public void testAdminClient_$eq(MockAdminClient x$1) {
        this.testAdminClient = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.testAdminClient_$eq((MockAdminClient)Mockito.mock(MockAdminClient.class));
    }

    private String runCommand(String[] args, MockAdminClient mockAdminClient, Function1<ConfluentAdmin, BoxedUnit> balancerCommandOperation) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> {
            new ClusterRebalanceCommandOptions((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}), (Object)args, ClassTag$.MODULE$.apply(String.class)));
            try {
                balancerCommandOperation.apply((Object)mockAdminClient);
                return;
            }
            catch (ApiException runBalancerCommand_e) {
                if (runBalancerCommand_e instanceof TimeoutException) {
                    throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)runBalancerCommand_e);
                }
                if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                    ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                    throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)runBalancerCommand_e);
                }
                if (runBalancerCommand_e instanceof BalancerOfflineException) {
                    BalancerOfflineException balancerOfflineException = (BalancerOfflineException)runBalancerCommand_e;
                    throw new AdminCommandFailedException(balancerOfflineException.getMessage(), (Throwable)balancerOfflineException);
                }
                throw runBalancerCommand_e;
            }
            catch (Throwable runBalancerCommand_e) {
                Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                throw runBalancerCommand_e;
            }
        };
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    @Test
    public void testCommandOptions() {
        ClusterRebalanceCommandOptions options_none = new ClusterRebalanceCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_none.verifyArgs(), (String)"Expected IllegalArgumentException if no bootstrap-server arg provided");
        ClusterRebalanceCommandOptions options_noCommand = new ClusterRebalanceCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_noCommand.verifyArgs(), (String)"Expected IllegalArgumentException if no subcommand provided");
        ClusterRebalanceCommandOptions options_twoCommands = new ClusterRebalanceCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), "--status", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_twoCommands.verifyArgs(), (String)"Expected IllegalArgumentException if multiple subcommands provided");
        new ClusterRebalanceCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), "--status"}).verifyArgs();
    }

    @Test
    public void testDescribeBalancerStatusSimpleStatuses() {
        Object[] balancerStatuses = BalancerStatus.values();
        ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(balancerStatuses), (Function1 & Serializable)x$1 -> {
            this.assertStatusTypeProperlyReported(x$1);
            return BoxedUnit.UNIT;
        }, (ClassTag)ClassTag$.MODULE$.Unit());
    }

    /*
     * WARNING - void declaration
     */
    private void assertStatusTypeProperlyReported(BalancerStatus statusToValidate) {
        String string;
        String string2;
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        this.testAdminClient_$eq((MockAdminClient)Mockito.mock(MockAdminClient.class));
        DescribeBalancerStatusResult describeBalancerStatusResult = (DescribeBalancerStatusResult)Mockito.mock(DescribeBalancerStatusResult.class);
        KafkaFutureImpl describeBalancerStatusDescriptionMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        BalancerStatusDescription mockBalancerStatusDescription = (BalancerStatusDescription)Mockito.spy((Object)new BalancerStatusDescription(statusToValidate, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), null));
        Mockito.when((Object)this.testAdminClient().describeBalancerStatus()).thenReturn((Object)describeBalancerStatusResult);
        Mockito.when((Object)describeBalancerStatusResult.description()).thenReturn((Object)describeBalancerStatusDescriptionMock);
        Mockito.when((Object)describeBalancerStatusDescriptionMock.get()).thenReturn((Object)mockBalancerStatusDescription);
        Function1 & Serializable intersect = (Function1 & Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = new String[]{"--status"};
        JFunction0.mcV.sp & Serializable runCommand_grabConsoleOutput_f = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string3 = string2 = runCommand_grabConsoleOutput_out.toString();
        Object var9_8 = null;
        Object var10_9 = null;
        string2 = null;
        String string4 = string = string3;
        Object var6_7 = null;
        mockAdminClient = null;
        intersect = null;
        string = null;
        String output = string4;
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).describeBalancerStatus();
        ((BalancerStatusDescription)Mockito.verify((Object)mockBalancerStatusDescription)).balancerStatus();
        Assertions.assertTrue((boolean)output.contains(statusToValidate.toString()), (String)new StringBuilder(28).append("Expected status to be ").append(statusToValidate.toString()).append(", got ").append(output).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeBalancerStatusErrorStatus() {
        String string;
        String string2;
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        DescribeBalancerStatusResult describeBalancerStatusResult = (DescribeBalancerStatusResult)Mockito.mock(DescribeBalancerStatusResult.class);
        KafkaFutureImpl describeBalancerStatusDescriptionMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        String testErrorString = "test error";
        BalancerOperationError balancerError = new BalancerOperationError(Errors.BALANCER_OFFLINE, testErrorString);
        BalancerStatusDescription mockBalancerStatusDescription = (BalancerStatusDescription)Mockito.spy((Object)new BalancerStatusDescription(BalancerStatus.ERROR, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), balancerError));
        Mockito.when((Object)this.testAdminClient().describeBalancerStatus()).thenReturn((Object)describeBalancerStatusResult);
        Mockito.when((Object)describeBalancerStatusResult.description()).thenReturn((Object)describeBalancerStatusDescriptionMock);
        Mockito.when((Object)describeBalancerStatusDescriptionMock.get()).thenReturn((Object)mockBalancerStatusDescription);
        Function1 & Serializable intersect = (Function1 & Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = new String[]{"--status"};
        JFunction0.mcV.sp & Serializable runCommand_grabConsoleOutput_f = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string3 = string2 = runCommand_grabConsoleOutput_out.toString();
        Object var10_9 = null;
        Object var11_10 = null;
        string2 = null;
        String string4 = string = string3;
        Object var7_8 = null;
        mockAdminClient = null;
        intersect = null;
        string = null;
        String output = string4;
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).describeBalancerStatus();
        ((BalancerStatusDescription)Mockito.verify((Object)mockBalancerStatusDescription)).balancerStatus();
        Assertions.assertTrue((boolean)output.contains(BalancerStatus.ERROR.toString()), (String)new StringBuilder(33).append("Expected status to be error, got ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(testErrorString), (String)new StringBuilder(40).append("Expected to see test error message, got ").append(output).toString());
    }

    @Test
    public void testDescribeUnevenLoadTask() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])EvenClusterLoadStatus.values()), (Function1 & Serializable)currentStatus -> {
            ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$1(this, currentStatus);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeUnevenLoadInDisabledAndStartStates() {
        String unevenLoadDisabledOutput = this.validateUnevenLoadStatus(EvenClusterLoadStatus.DISABLED, null, null);
        Assertions.assertFalse((boolean)unevenLoadDisabledOutput.contains("Previous"), (String)new StringBuilder(53).append("Did not expect to see output for previous state, got ").append(unevenLoadDisabledOutput).toString());
        String unevenLoadStartingOutput = this.validateUnevenLoadStatus(EvenClusterLoadStatus.STARTING, null, null);
        Assertions.assertFalse((boolean)unevenLoadStartingOutput.contains("Previous"), (String)new StringBuilder(53).append("Did not expect to see output for previous state, got ").append(unevenLoadStartingOutput).toString());
    }

    private void validateOutputAndErrorForUnevenLoadStatus(EvenClusterLoadStatus currentStatus, EvenClusterLoadStatus prevStatus) {
        String testErrorMessage = "test error";
        EvenClusterLoadStatus evenClusterLoadStatus = currentStatus;
        EvenClusterLoadStatus evenClusterLoadStatus2 = EvenClusterLoadStatus.BALANCING_FAILED;
        BalancerOperationError testException = (evenClusterLoadStatus == null ? evenClusterLoadStatus2 != null : !evenClusterLoadStatus.equals(evenClusterLoadStatus2)) && (prevStatus == null || !prevStatus.equals(EvenClusterLoadStatus.BALANCING_FAILED)) ? null : new BalancerOperationError(Errors.BALANCER_OPERATION_FAILED, testErrorMessage);
        String testOutput = this.validateUnevenLoadStatus(currentStatus, prevStatus, testException);
        if (!(currentStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED) || prevStatus != null && prevStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED))) {
            Assertions.assertFalse((boolean)testOutput.contains("Exception"), (String)new StringBuilder(71).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected no exception to be reported in output, got ").append(testOutput).toString());
            Assertions.assertFalse((boolean)testOutput.contains(testErrorMessage), (String)new StringBuilder(64).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected no error message in output, but got ").append(testOutput).toString());
            return;
        }
        Assertions.assertTrue((boolean)testOutput.contains("Exception"), (String)new StringBuilder(99).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected an Exception to be reported in command output, but didn't find one in: ").append(testOutput).toString());
        Assertions.assertTrue((boolean)testOutput.contains(testErrorMessage), (String)new StringBuilder(75).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected the test error message ").append(testErrorMessage).append(" but didn't find it in: ").append(testOutput).toString());
    }

    /*
     * WARNING - void declaration
     */
    private String validateUnevenLoadStatus(EvenClusterLoadStatus testCurrentStatus, EvenClusterLoadStatus testPrevStatus, BalancerOperationError errorToReturn) {
        Option option;
        String string;
        String string2;
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        Regex currentRegex = (Regex)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Current: (\\w+)")).unanchored();
        Regex prevStatusRegex = (Regex)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Previous: (\\w+)")).unanchored();
        this.setupEvenLoadDescriptionMock(testCurrentStatus, testPrevStatus, 0L, 0L, errorToReturn);
        Function1 & Serializable intersect = (Function1 & Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = new String[]{"--describe"};
        JFunction0.mcV.sp & Serializable runCommand_grabConsoleOutput_f = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string3 = string2 = runCommand_grabConsoleOutput_out.toString();
        Object var14_9 = null;
        Object var15_10 = null;
        string2 = null;
        String string4 = string = string3;
        Object var11_8 = null;
        mockAdminClient = null;
        intersect = null;
        string = null;
        String output = string4;
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).describeEvenClusterLoadStatus();
        if (output != null && !(option = currentRegex.unapplySeq((CharSequence)output)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String extractedCurrentStatus = (String)((LinearSeqOps)option.get()).apply(0);
            Assertions.assertTrue((boolean)extractedCurrentStatus.equals(testCurrentStatus.toString()), (String)new StringBuilder(71).append("Current uneven-load task status wasn't the expected value, got ").append(extractedCurrentStatus).append(" wanted ").append(testCurrentStatus).toString());
        } else {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(53).append("Couldn't find current status of uneven load task in: ").append(output).toString());
        }
        if (testPrevStatus != null) {
            Option option2;
            if (output != null && !(option2 = prevStatusRegex.unapplySeq((CharSequence)output)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
                String extractedPreviousStatus = (String)((LinearSeqOps)option2.get()).apply(0);
                Assertions.assertTrue((boolean)extractedPreviousStatus.equals(testPrevStatus.toString()), (String)new StringBuilder(72).append("Previous uneven-load task status wasn't the expected value, got ").append(extractedPreviousStatus).append(" wanted ").append(testPrevStatus).toString());
            } else {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)new StringBuilder(54).append("Couldn't find status of previous uneven load task in: ").append(output).toString());
            }
        } else {
            Assertions.assertFalse((boolean)output.contains("Previous"), (String)new StringBuilder(47).append("Expected no previous state to be printed, got: ").append(output).toString());
        }
        return output;
    }

    /*
     * Unable to fully structure code
     */
    private void setupEvenLoadDescriptionMock(EvenClusterLoadStatus currentStatus, EvenClusterLoadStatus prevStatus, long currentUpdateTimeMs, long prevUpdateTimeMs, BalancerOperationError operationError) {
        v0 = currentStatus;
        var8_6 = EvenClusterLoadStatus.BALANCING_FAILED;
        if (!(v0 == null ? var8_6 != null : v0.equals(var8_6) == false)) ** GOTO lbl-1000
        v1 = prevStatus;
        var9_7 = EvenClusterLoadStatus.BALANCING_FAILED;
        if (!(v1 != null ? v1.equals(var9_7) == false : var9_7 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)(v2 ^ operationError == null), (String)new StringBuilder(92).append("Invalid status/error combination sent to test: currentStatus: ").append(currentStatus).append(" prevStatus: ").append(prevStatus).append(" operationError: ").append(operationError).toString());
        this.testAdminClient_$eq((MockAdminClient)Mockito.mock(MockAdminClient.class));
        describeUnevenLoadTaskResult = (DescribeEvenClusterLoadStatusResult)Mockito.mock(DescribeEvenClusterLoadStatusResult.class);
        describeUnevenLoadDescriptionMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)this.testAdminClient().describeEvenClusterLoadStatus()).thenReturn((Object)describeUnevenLoadTaskResult);
        Mockito.when((Object)describeUnevenLoadTaskResult.description()).thenReturn((Object)describeUnevenLoadDescriptionMock);
        spyUnevenLoadDescription = (EvenClusterLoadStatusDescription)Mockito.spy((Object)new EvenClusterLoadStatusDescription(currentStatus, prevStatus, currentUpdateTimeMs, prevUpdateTimeMs, operationError));
        Mockito.when((Object)describeUnevenLoadDescriptionMock.get()).thenReturn((Object)spyUnevenLoadDescription);
    }

    @Test
    public void testDescribeUnevenLoadTaskErrors() {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        BalancerOperationError currentError = new BalancerOperationError(Errors.BALANCER_OPERATION_FAILED, "current operation failed");
        String currentErrorOutput = this.validateUnevenLoadStatus(EvenClusterLoadStatus.BALANCING_FAILED, EvenClusterLoadStatus.BALANCED, currentError);
        UnanchoredRegex currentErrorRegex = this.getErrorRegex("Current", currentError);
        boolean bl = currentErrorOutput != null && !(option5 = ((Regex)currentErrorRegex).unapplySeq((CharSequence)currentErrorOutput)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(34).append("Expected error message ").append(((Regex)currentErrorRegex).toString()).append(" in output ").append(currentErrorOutput).toString());
        BalancerOperationError prevError = new BalancerOperationError(Errors.BALANCER_OPERATION_FAILED, "previous operation failed");
        String prevErrorOutput = this.validateUnevenLoadStatus(EvenClusterLoadStatus.BALANCED, EvenClusterLoadStatus.BALANCING_FAILED, prevError);
        UnanchoredRegex prevErrorRegex = this.getErrorRegex("Previous", prevError);
        boolean bl2 = prevErrorOutput != null && !(option4 = ((Regex)prevErrorRegex).unapplySeq((CharSequence)prevErrorOutput)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl2, (String)new StringBuilder(34).append("Expected error message ").append(((Regex)prevErrorRegex).toString()).append(" in output ").append(prevErrorOutput).toString());
        String bothErrorOutput = this.validateUnevenLoadStatus(EvenClusterLoadStatus.BALANCING_FAILED, EvenClusterLoadStatus.BALANCING_FAILED, currentError);
        boolean bl3 = bothErrorOutput != null && !(option3 = ((Regex)currentErrorRegex).unapplySeq((CharSequence)bothErrorOutput)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl3, (String)new StringBuilder(34).append("Expected error message ").append(((Regex)currentErrorRegex).toString()).append(" in output ").append(bothErrorOutput).toString());
        boolean bl4 = bothErrorOutput != null && !(option2 = ((Regex)prevErrorRegex).unapplySeq((CharSequence)bothErrorOutput)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(0) == 0;
        Assertions.assertFalse((boolean)bl4, (String)new StringBuilder(40).append("Did not expect error message ").append(((Regex)prevErrorRegex).toString()).append(" in output ").append(bothErrorOutput).toString());
        UnanchoredRegex prevExpectedRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append("Previous: ").append(EvenClusterLoadStatus.BALANCING_FAILED.toString()).append("\\s*\\R\\s*Last Update Time").toString())).unanchored();
        boolean bl5 = bothErrorOutput != null && !(option = ((Regex)prevExpectedRegex).unapplySeq((CharSequence)bothErrorOutput)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl5, (String)new StringBuilder(75).append("Expected no error message for previous phase when both in error state, got ").append(bothErrorOutput).toString());
    }

    private UnanchoredRegex getErrorRegex(String expectedPhaseName, BalancerOperationError expectedError) {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(12).append(expectedPhaseName).append(": ").append(EvenClusterLoadStatus.BALANCING_FAILED.toString()).append("\\s*\\R\\s*").append(expectedError.exception().getClass().getName()).append(": ").append(expectedError.errorMessage()).toString())).unanchored();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnevenLoadTask$2(EvenClusterLoadStatus x$2) {
        return !x$2.equals((Object)EvenClusterLoadStatus.DISABLED);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnevenLoadTask$3(EvenClusterLoadStatus x$3) {
        return !x$3.equals((Object)EvenClusterLoadStatus.STARTING);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnevenLoadTask$4(EvenClusterLoadStatus x$4) {
        return !x$4.equals((Object)EvenClusterLoadStatus.BALANCING);
    }

    public static final /* synthetic */ void $anonfun$testDescribeUnevenLoadTask$1(ClusterRebalanceCommandTest $this, EvenClusterLoadStatus currentStatus) {
        $this.validateOutputAndErrorForUnevenLoadStatus(currentStatus, null);
        if (!currentStatus.equals((Object)EvenClusterLoadStatus.DISABLED) && !currentStatus.equals((Object)EvenClusterLoadStatus.STARTING)) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])EvenClusterLoadStatus.values()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$2(x$2)))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$3(x$3)))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$4(x$4)))), (Function1 & Serializable)prevStatus -> {
                $this.validateOutputAndErrorForUnevenLoadStatus(currentStatus, prevStatus);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ClusterRebalanceCommandTest() {
        this.bootstrapServer = "localhost:9092";
    }
}

