/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionException;
import kafka.admin.ReplicaExclusionCommand$;
import kafka.admin.ReplicaExclusionCommandOptions;
import kafka.common.AdminCommandFailedException;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BrokerReplicaExclusionNotFoundException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y4Aa\u0005\u000b\u00017!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00039\u0003B\u0002\u0019\u0001A\u0003%\u0001\u0006C\u00042\u0001\u0001\u0007I\u0011\u0001\u001a\t\u000f}\u0002\u0001\u0019!C\u0001\u0001\"1a\t\u0001Q!\nMBQa\u0012\u0001\u0005\u0002!CQ\u0001\u0016\u0001\u0005\u0002!CQ!\u0017\u0001\u0005\u0002!CQa\u0017\u0001\u0005\u0002!CQ!\u0018\u0001\u0005\u0002!CQa\u0018\u0001\u0005\u0002!CQ!\u0019\u0001\u0005\u0002!CQa\u0019\u0001\u0005\u0002!CQ!\u001a\u0001\u0005\u0002!CQa\u001a\u0001\u0005\u0002!CQ!\u001b\u0001\u0005\u0002!CQa\u001b\u0001\u0005\u00021\u00141DU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8D_6l\u0017M\u001c3UKN$(BA\u000b\u0017\u0003!\u0011\u0017\r\\1oG\u0016\u0014(BA\f\u0019\u0003\u0015\tG-\\5o\u0015\u0005I\u0012!B6bM.\f7\u0001A\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0015\u0003=\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014X#\u0001\u0015\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00027b]\u001eT\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t11\u000b\u001e:j]\u001e\f\u0001CY8piN$(/\u00199TKJ4XM\u001d\u0011\u0002\u001fQ,7\u000f^!e[&t7\t\\5f]R,\u0012a\r\t\u0003iuj\u0011!\u000e\u0006\u0003/YR!a\u000e\u001d\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0011$\u000f\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\tq1i\u001c8gYV,g\u000e^!e[&t\u0017a\u0005;fgR\fE-\\5o\u00072LWM\u001c;`I\u0015\fHCA!E!\ti\")\u0003\u0002D=\t!QK\\5u\u0011\u001d)U!!AA\u0002M\n1\u0001\u001f\u00132\u0003A!Xm\u001d;BI6Lgn\u00117jK:$\b%A\u0003tKR,\u0006\u000fF\u0001BQ\t9!\n\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u0006\u0019\u0011\r]5\u000b\u0005=\u0003\u0016a\u00026va&$XM\u001d\u0006\u0003#n\nQA[;oSRL!a\u0015'\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000buKN$H)Z:de&\u0014W-\u0012=dYV\u001c\u0018n\u001c8)\u0005!1\u0006CA&X\u0013\tAFJ\u0001\u0003UKN$\u0018\u0001\b;fgR$Um]2sS\n,W\t_2mkNLwN\u001c$jYR,'o\u001d\u0015\u0003\u0013Y\u000b1\u0004^3ti\u0012+7o\u0019:jE\u0016,\u0005p\u00197vg&|g\u000e\u00165s_^\u001c\bF\u0001\u0006W\u0003I!Xm\u001d;BYR,'/\u0012=dYV\u001c\u0018n\u001c8)\u0005-1\u0016!\t;fgR\fE\u000e^3s\u000bb\u001cG.^:j_:$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007F\u0001\u0007W\u0003]!Xm\u001d;F[B$\u0018pQ8n[\u0006tGm\u00149uS>t7\u000f\u000b\u0002\u000e-\u0006iB/Z:u\u0007>lW.\u00198e\u001fB$\u0018n\u001c8t\t\u0016\u001c8M]5cK>\u0003H\u000f\u000b\u0002\u000f-\u0006yB/Z:u\u0007>lW.\u00198e\u001fB$\u0018n\u001c8t\u0003\u0012$G)\u001a7fi\u0016|\u0005\u000f^:)\u0005=1\u0016A\u0005;fgR\u0004\u0016M]:f\u0005J|7.\u001a:JIND#\u0001\u0005,\u0002#Q,7\u000f^#yG2,8/[8og6\u000b\u0007\u000f\u000b\u0002\u0012-\u0006Q!/\u001e8D_6l\u0017M\u001c3\u0015\u00075<H\u0010\u0005\u0002ok:\u0011qn\u001d\t\u0003azi\u0011!\u001d\u0006\u0003ej\ta\u0001\u0010:p_Rt\u0014B\u0001;\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011qF\u001e\u0006\u0003izAQ\u0001\u001f\nA\u0002e\fA!\u0019:hgB\u0019QD_7\n\u0005mt\"!B!se\u0006L\b\"B?\u0013\u0001\u0004\u0019\u0014aD7pG.\fE-\\5o\u00072LWM\u001c;")
public class ReplicaExclusionCommandTest {
    private final String bootstrapServer;
    private ConfluentAdmin testAdminClient = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public ConfluentAdmin testAdminClient() {
        return this.testAdminClient;
    }

    public void testAdminClient_$eq(ConfluentAdmin x$1) {
        this.testAdminClient = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.testAdminClient_$eq((ConfluentAdmin)Mockito.mock(ConfluentAdmin.class));
    }

    @Test
    public void testDescribeExclusion() {
        String reason1 = "maintenance";
        String reason2 = "maintenance2";
        DescribeBrokerReplicaExclusionsResult describeResult = (DescribeBrokerReplicaExclusionsResult)Mockito.mock(DescribeBrokerReplicaExclusionsResult.class);
        java.util.List descriptions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription[]{new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription(121, reason1), new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription(212, reason2)}))).asJava();
        KafkaFutureImpl futureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeResult.descriptions()).thenReturn((Object)futureMock);
        Mockito.when((Object)futureMock.get()).thenReturn((Object)descriptions);
        Mockito.when((Object)this.testAdminClient().describeBrokerReplicaExclusions()).thenReturn((Object)describeResult);
        String output = this.runCommand(new String[]{"--describe"}, this.testAdminClient());
        Assertions.assertTrue((boolean)output.contains("Broker 121"), (String)new StringBuilder(43).append("Output should contain broker 121. Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains("Broker 212"), (String)new StringBuilder(43).append("Output should contain broker 212. Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(reason1), (String)new StringBuilder(42).append("Output should contain reason '").append(reason1).append("'. Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(reason2), (String)new StringBuilder(42).append("Output should contain reason '").append(reason2).append("'. Output - ").append(output).toString());
    }

    @Test
    public void testDescribeExclusionFilters() {
        String reason1 = "maintenance";
        String reason2 = "maintenance2";
        DescribeBrokerReplicaExclusionsResult describeResult = (DescribeBrokerReplicaExclusionsResult)Mockito.mock(DescribeBrokerReplicaExclusionsResult.class);
        java.util.List descriptions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription[]{new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription(121, reason1), new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription(212, reason2)}))).asJava();
        KafkaFutureImpl futureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeResult.descriptions()).thenReturn((Object)futureMock);
        Mockito.when((Object)futureMock.get()).thenReturn((Object)descriptions);
        Mockito.when((Object)this.testAdminClient().describeBrokerReplicaExclusions()).thenReturn((Object)describeResult);
        String output = this.runCommand(new String[]{"--describe", "--broker-ids", "121"}, this.testAdminClient());
        Assertions.assertTrue((boolean)output.contains("Broker 121"), (String)new StringBuilder(43).append("Output should contain broker 121. Output - ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains("Broker 212"), (String)new StringBuilder(70).append("Output should NOT contain broker 212 as it was filtered out. Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(reason1), (String)new StringBuilder(42).append("Output should contain reason '").append(reason1).append("'. Output - ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains(reason2), (String)new StringBuilder(78).append("Output should NOT contain reason '").append(reason2).append("' as that broker was filtered out. Output - ").append(output).toString());
    }

    @Test
    public void testDescribeExclusionThrows() {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiException[]{new InvalidBrokerReplicaExclusionException("invalid exclusion!"), new BrokerReplicaExclusionNotFoundException("exclusion not found!"), new ClusterAuthorizationException("not authorized!"), new TimeoutException("Timed out waiting for results"), new InvalidRequestException("invalid req!")}))).foreach((Function1 & Serializable)expectedException -> {
            ReplicaExclusionCommandTest.$anonfun$testDescribeExclusionThrows$1(this, expectedException);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterExclusion() {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--add", "--delete"}))).foreach((Function1 & Serializable)command -> {
            ReplicaExclusionCommandTest.$anonfun$testAlterExclusion$1(this, command);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterExclusionThrowsException() {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--add", "--delete"}))).foreach((Function1 & Serializable)command -> {
            ReplicaExclusionCommandTest.$anonfun$testAlterExclusionThrowsException$1(this, command);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEmptyCommandOptions() {
        ReplicaExclusionCommandOptions emptyOptions = new ReplicaExclusionCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> emptyOptions.verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
    }

    @Test
    public void testCommandOptionsDescribeOpt() {
        new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), "--describe"}).verifyArgs();
        new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), "--describe", "--broker-ids", "1 2"}).verifyArgs();
    }

    @Test
    public void testCommandOptionsAddDeleteOpts() {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--add", "--delete"}))).foreach((Function1 & Serializable)command -> {
            new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), command, "--broker-ids", "1 2"}).verifyArgs();
            new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), command, "--reason", "maintenance", "--broker-ids", "1, 2"}).verifyArgs();
            ReplicaExclusionCommandOptions invalidOptions = new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), command});
            Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> invalidOptions.verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), command, "--broker-ids", "1, 2", "--reason"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            return Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), command, "--broker-ids"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        });
        ReplicaExclusionCommandOptions invalidOptions = new ReplicaExclusionCommandOptions(new String[]{"--bootstrap-server", this.bootstrapServer(), "--add", "--delete", "--broker-ids", "1, 2"});
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> invalidOptions.verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
    }

    @Test
    public void testParseBrokerIds() {
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", "1,   2"})));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", "1"})));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", "1,2,3"})));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", ""})), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", "1,d,3"})), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", "1 2"})), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ReplicaExclusionCommand$.MODULE$.brokerIds(new ReplicaExclusionCommandOptions(new String[]{"--broker-ids", "2313_21"})), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("ReplicaExclusionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
    }

    @Test
    public void testExclusionsMap() {
        List ids = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
        String brokerIdString = ids.mkString(", ");
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExclusionOp.OpType[]{ExclusionOp.OpType.SET, ExclusionOp.OpType.DELETE}))).foreach((Function1 & Serializable)opType -> {
            ReplicaExclusionCommandTest.$anonfun$testExclusionsMap$1(this, brokerIdString, ids, opType);
            return BoxedUnit.UNIT;
        });
    }

    public String runCommand(String[] args, ConfluentAdmin mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> ReplicaExclusionCommand$.MODULE$.run((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}), (Object)args, ClassTag$.MODULE$.apply(String.class)), (Option)new Some((Object)mockAdminClient));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExclusionThrows$1(ReplicaExclusionCommandTest $this, ApiException expectedException) {
        DescribeBrokerReplicaExclusionsResult describeResult = (DescribeBrokerReplicaExclusionsResult)Mockito.mock(DescribeBrokerReplicaExclusionsResult.class);
        KafkaFutureImpl futureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeResult.descriptions()).thenReturn((Object)futureMock);
        Mockito.when((Object)futureMock.get()).thenAnswer(x$1 -> {
            throw new ExecutionException("", expectedException);
        });
        Mockito.when((Object)$this.testAdminClient().describeBrokerReplicaExclusions()).thenReturn((Object)describeResult);
        AdminCommandFailedException receivedException = (AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> $this.runCommand(new String[]{"--describe"}, $this.testAdminClient()));
        Assertions.assertEquals((Object)expectedException.getMessage(), (Object)receivedException.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterExclusion$2(ReplicaExclusionCommandTest $this, ExclusionOp.OpType opType$1, String reason$1, Option errMsgOpt) {
        String string;
        ExclusionOpResult exclusionOpResult;
        ExclusionOpResult broker121OpResult = new ExclusionOpResult(new ExclusionOp(opType$1, reason$1));
        if (errMsgOpt instanceof Some) {
            String errMsg = (String)((Some)errMsgOpt).value();
            exclusionOpResult = new ExclusionOpResult(new ExclusionOp(opType$1, reason$1), new ExclusionOperationError(Errors.CLUSTER_AUTHORIZATION_FAILED, errMsg));
        } else if (None$.MODULE$.equals(errMsgOpt)) {
            exclusionOpResult = new ExclusionOpResult(new ExclusionOp(opType$1, reason$1));
        } else {
            throw new MatchError((Object)errMsgOpt);
        }
        scala.collection.immutable.Map exclusions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)121), (Object)broker121OpResult), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)212), (Object)exclusionOpResult)}));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = new AlterBrokerReplicaExclusionsResult.ExclusionsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)exclusions).asJava(), errMsgOpt.isEmpty());
        AlterBrokerReplicaExclusionsResult alterResult = (AlterBrokerReplicaExclusionsResult)Mockito.mock(AlterBrokerReplicaExclusionsResult.class);
        KafkaFutureImpl futureResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)alterResult.result()).thenReturn((Object)futureResult);
        Mockito.when((Object)futureResult.get()).thenReturn((Object)result);
        Mockito.when((Object)$this.testAdminClient().alterBrokerReplicaExclusions((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)alterResult);
        if (errMsgOpt instanceof Some) {
            string = ((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> $this.runCommand(new String[]{"--add", "--broker-ids", "121, 212"}, $this.testAdminClient()))).getMessage();
        } else if (None$.MODULE$.equals(errMsgOpt)) {
            string = $this.runCommand(new String[]{"--add", "--broker-ids", "121, 212"}, $this.testAdminClient());
        } else {
            throw new MatchError((Object)errMsgOpt);
        }
        Assertions.assertTrue((boolean)string.contains("121"), (String)new StringBuilder(43).append("Output should contain broker 121. Output - ").append(string).toString());
        Assertions.assertTrue((boolean)string.contains("212"), (String)new StringBuilder(43).append("Output should contain broker 212. Output - ").append(string).toString());
        if (errMsgOpt.isDefined()) {
            String errMsg = (String)errMsgOpt.get();
            Assertions.assertTrue((boolean)string.contains(errMsg), (String)new StringBuilder(49).append("Output should contain error message '").append(errMsg).append("'. Output - ").append(string).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$testAlterExclusion$1(ReplicaExclusionCommandTest $this, String command) {
        String string = command;
        String string2 = "--add";
        ExclusionOp.OpType opType = string != null && string.equals(string2) ? ExclusionOp.OpType.SET : ExclusionOp.OpType.DELETE;
        String reason = "maintenance";
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{None$.MODULE$, new Some((Object)"authorization failed")}))).foreach((Function1 & Serializable)errMsgOpt -> {
            ReplicaExclusionCommandTest.$anonfun$testAlterExclusion$2($this, opType, reason, errMsgOpt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testAlterExclusionThrowsException$2(ReplicaExclusionCommandTest $this, String command$1, ApiException expectedException) {
        AlterBrokerReplicaExclusionsResult alterResult = (AlterBrokerReplicaExclusionsResult)Mockito.mock(AlterBrokerReplicaExclusionsResult.class);
        KafkaFutureImpl futureResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)alterResult.result()).thenReturn((Object)futureResult);
        Mockito.when((Object)futureResult.get()).thenAnswer(x$2 -> {
            throw new ExecutionException("", expectedException);
        });
        Mockito.when((Object)$this.testAdminClient().alterBrokerReplicaExclusions((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)alterResult);
        AdminCommandFailedException receivedException = (AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> $this.runCommand(new String[]{command$1, "--broker-ids", "121, 212"}, $this.testAdminClient()));
        Assertions.assertEquals((Object)expectedException.getMessage(), (Object)receivedException.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterExclusionThrowsException$1(ReplicaExclusionCommandTest $this, String command) {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiException[]{new InvalidBrokerReplicaExclusionException("invalid exclusion!"), new BrokerReplicaExclusionNotFoundException("exclusion not found!"), new ClusterAuthorizationException("not authorized!"), new TimeoutException("Timed out waiting for results"), new InvalidRequestException("invalid req!")}))).foreach((Function1 & Serializable)expectedException -> {
            ReplicaExclusionCommandTest.$anonfun$testAlterExclusionThrowsException$2($this, command, expectedException);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testExclusionsMap$4(ExclusionOp.OpType opType$2, Option givenReasonOpt$1, Tuple2 x$3) {
        if (x$3 != null) {
            ExclusionOp exclusionOp = (ExclusionOp)x$3._2();
            Assertions.assertEquals((Object)opType$2, (Object)exclusionOp.opType());
            if (givenReasonOpt$1 instanceof Some) {
                Assertions.assertEquals((Object)((String)((Some)givenReasonOpt$1).value()), (Object)exclusionOp.reason());
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$testExclusionsMap$2(ReplicaExclusionCommandTest $this, String brokerIdString$1, ExclusionOp.OpType opType$2, List ids$1, Option givenReasonOpt) {
        ArrayBuffer params = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", $this.bootstrapServer(), "--add", "--broker-ids", brokerIdString$1}));
        if (givenReasonOpt instanceof Some) {
            String reason = (String)((Some)givenReasonOpt).value();
            params.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--reason", reason}));
        }
        ReplicaExclusionCommandOptions opts = new ReplicaExclusionCommandOptions((String[])params.toArray(ClassTag$.MODULE$.apply(String.class)));
        scala.collection.mutable.Map receivedMap = CollectionConverters$.MODULE$.MapHasAsScala(ReplicaExclusionCommand$.MODULE$.exclusionsMap(opType$2, ReplicaExclusionCommand$.MODULE$.brokerIds(opts), ReplicaExclusionCommand$.MODULE$.reasonOpt(opts))).asScala();
        Assertions.assertEquals((int)ids$1.size(), (int)receivedMap.size());
        Assertions.assertEquals((Object)ids$1, (Object)receivedMap.keys().toList().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        receivedMap.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$3 -> {
            ReplicaExclusionCommandTest.$anonfun$testExclusionsMap$4(opType$2, givenReasonOpt, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testExclusionsMap$1(ReplicaExclusionCommandTest $this, String brokerIdString$1, List ids$1, ExclusionOp.OpType opType) {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)"reason"), None$.MODULE$}))).foreach((Function1 & Serializable)givenReasonOpt -> {
            ReplicaExclusionCommandTest.$anonfun$testExclusionsMap$2($this, brokerIdString$1, opType, ids$1, givenReasonOpt);
            return BoxedUnit.UNIT;
        });
    }

    public ReplicaExclusionCommandTest() {
        this.bootstrapServer = "localhost:9092";
    }
}

