/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004/\u0001\u0001\u0006I\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019I\u0004\u0001)A\u0005c!9!\b\u0001b\u0001\n\u0003\u0001\u0004BB\u001e\u0001A\u0003%\u0011\u0007C\u0004=\u0001\t\u0007I\u0011A\u0014\t\ru\u0002\u0001\u0015!\u0003)\u0011\u001dq\u0004A1A\u0005\u0002}Baa\u0017\u0001!\u0002\u0013\u0001\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007K\u0002\u0001\u000b\u0011\u00020\t\u000b\u0019\u0004A\u0011I4\t\u000bI\u0004A\u0011I:\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005=\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\ty\u0005\u0001C\u0005\u0003#\u0012!\u0005\u0016:b]N\f7\r^5p]N<\u0016\u000e\u001e5NCbLeN\u00127jO\"$xJ\\3UKN$(BA\f\u0019\u0003\r\t\u0007/\u001b\u0006\u00023\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\ty\u0002$A\u0006j]R,wM]1uS>t\u0017BA\u0011\u001f\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0017\u0003)qW/\\*feZ,'o]\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t\u0019\u0011J\u001c;\u0002\u00179,XnU3sm\u0016\u00148\u000fI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\t1\fgn\u001a\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u0003\u0019!x\u000e]5de\u00059Ao\u001c9jGJ\u0002\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN,\u0012\u0001\u0011\t\u0004\u0003\u001aCU\"\u0001\"\u000b\u0005\r#\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000b*\n!bY8mY\u0016\u001cG/[8o\u0013\t9%I\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0013N+V+D\u0001K\u0015\tYE*\u0001\u0005qe>$WoY3s\u0015\tie*A\u0004dY&,g\u000e^:\u000b\u0005ey%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001\u0016&\u0003\u001b-\u000bgm[1Qe>$WoY3s!\rIc\u000bW\u0005\u0003/*\u0012Q!\u0011:sCf\u0004\"!K-\n\u0005iS#\u0001\u0002\"zi\u0016\fq\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN,\u0012A\u0018\t\u0004\u0003\u001a{\u0006\u0003\u00021d+Vk\u0011!\u0019\u0006\u0003E2\u000b\u0001bY8ogVlWM]\u0005\u0003I\u0006\u0014QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\u0018a\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u00015\u0011\u0007%TG.D\u0001E\u0013\tYGIA\u0002TKF\u0004\"!\u001c9\u000e\u00039T!a\u001c\r\u0002\rM,'O^3s\u0013\t\thNA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!B:fiV\u0003HC\u0001;x!\tIS/\u0003\u0002wU\t!QK\\5u\u0011\u0015Ax\u00021\u0001z\u0003!!Xm\u001d;J]\u001a|\u0007c\u0001>\u0002\u00025\t1P\u0003\u0002\u0018y*\u0011QP`\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0018+A\u0003kk:LG/C\u0002\u0002\u0004m\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0004\u001f\u0005\u001d\u0001c\u0001>\u0002\n%\u0019\u00111B>\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005!\bf\u0001\t\u0002\u0014A\u0019!0!\u0006\n\u0007\u0005]1PA\u0005BMR,'/R1dQ\u0006\u0019D/Z:u)J\fgn]1di&|g.\u00197Qe>$WoY3s'&tw\r\\3Ce>\\WM]'bq&sg\t\\5hQR|e.\u001a\u0015\u0004#\u0005u\u0001c\u0001>\u0002 %\u0019\u0011\u0011E>\u0003\tQ+7\u000f^\u0001\fg\u0016\u0014h/\u001a:Qe>\u00048\u000f\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.U\nA!\u001e;jY&!\u0011\u0011GA\u0016\u0005)\u0001&o\u001c9feRLWm]\u0001\u001cGJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:\u0015\u0007}\u000b9\u0004C\u0004\u0002:M\u0001\r!a\u000f\u0002\u000b\u001d\u0014x.\u001e9\u0011\t\u0005u\u00121\n\b\u0005\u0003\u007f\t9\u0005E\u0002\u0002B)j!!a\u0011\u000b\u0007\u0005\u0015#$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0013R\u0013A\u0002)sK\u0012,g-C\u00029\u0003\u001bR1!!\u0013+\u0003m\u0019'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2feR\u0019\u0001*a\u0015\t\u000f\u0005UC\u00031\u0001\u0002<\u0005yAO]1og\u0006\u001cG/[8oC2LE\r")
public class TransactionsWithMaxInFlightOneTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(1));
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig, this.createTopic$default$5());
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig, this.createTopic$default$5());
        this.createTransactionalProducer("transactional-producer");
        this.createReadCommittedConsumer("transactional-group");
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testTransactionalProducerSingleBrokerMaxInFlightOne() {
        Assertions.assertEquals((int)1, (int)this.servers().size());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group) {
        void var2_18;
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        None$ none$3;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$5 = none$4;
        String string2 = string = "earliest";
        string = null;
        String x$6 = string2;
        int n = 500;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$8 = securityProtocol2;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$12 = byteArrayDeserializer4;
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, (Option<String>)x$5, x$6, false, true, n, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12);
        this.transactionalConsumers().$plus$eq(consumer);
        return var2_18;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        void var2_8;
        Buffer<KafkaServer> x$2 = this.servers();
        int n = 16384;
        long l = 60000L;
        long l2 = 60000L;
        int n2 = 120000;
        int n3 = 30000;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, n, l, l2, n2, n3, 1);
        this.transactionalProducers().$plus$eq(producer);
        return var2_8;
    }

    public TransactionsWithMaxInFlightOneTest() {
        this.numServers = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }
}

