/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.ConfluentReplicaTest$;
import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.log.MergedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ut!\u0002\u0013&\u0011\u0003Qc!\u0002\u0017&\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\ta\u000e\u0005\u0007w\u0005\u0001\u000b\u0011\u0002\u001d\t\u000fq\n!\u0019!C\u0001{!1\u0011*\u0001Q\u0001\nyBqAS\u0001C\u0002\u0013\u00051\n\u0003\u0004P\u0003\u0001\u0006I\u0001\u0014\u0004\u0005Y\u0015\u0002\u0001\u000bC\u00035\u0013\u0011\u0005\u0011\u000bC\u0004T\u0013\t\u0007I\u0011\u0001+\t\rmK\u0001\u0015!\u0003V\u0011%a\u0016\u00021AA\u0002\u0013\u0005Q\fC\u0005b\u0013\u0001\u0007\t\u0019!C\u0001E\"I\u0001.\u0003a\u0001\u0002\u0003\u0006KA\u0018\u0005\u0006S&!\tA\u001b\u0005\u0006m&!Ia\u001e\u0005\b\u0003\u000bIA\u0011AA\u0004\u0011\u001d\t\u0019\"\u0003C\u0005\u0003+Aq!a\t\n\t\u0013\t)\u0003C\u0004\u00028%!I!!\u000f\t\u000f\u0005u\u0012\u0002\"\u0003\u0002@!1\u00111I\u0005\u0005\u0002)Da!!\u0014\n\t\u0003Q\u0007BBA)\u0013\u0011\u0005!\u000e\u0003\u0004\u0002V%!\tA\u001b\u0005\u0007\u00033JA\u0011\u00016\t\r\u0005u\u0013\u0002\"\u0001k\u0011\u0019\t\t'\u0003C\u0001U\"1\u0011QM\u0005\u0005\u0002)Da!!\u001b\n\t\u0003Q\u0007BBA7\u0013\u0011\u0005!\u000e\u0003\u0004\u0002r%!\tA\u001b\u0005\u0007\u0003kJA\u0011\u00016\t\r\u0005e\u0014\u0002\"\u0001k\u0003Q\u0019uN\u001c4mk\u0016tGOU3qY&\u001c\u0017\rV3ti*\u0011aeJ\u0001\bG2,8\u000f^3s\u0015\u0005A\u0013!B6bM.\f7\u0001\u0001\t\u0003W\u0005i\u0011!\n\u0002\u0015\u0007>tg\r\\;f]R\u0014V\r\u001d7jG\u0006$Vm\u001d;\u0014\u0005\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002U\u0005A!I]8lKJLE-F\u00019!\ty\u0013(\u0003\u0002;a\t\u0019\u0011J\u001c;\u0002\u0013\t\u0013xn[3s\u0013\u0012\u0004\u0013!\u0003)beRLG/[8o+\u0005q\u0004CA H\u001b\u0005\u0001%BA!C\u0003\u0019\u0019w.\\7p]*\u0011\u0001f\u0011\u0006\u0003\t\u0016\u000ba!\u00199bG\",'\"\u0001$\u0002\u0007=\u0014x-\u0003\u0002I\u0001\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0003)beRLG/[8oA\u0005\u0019\"+\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\tA\n\u0005\u00020\u001b&\u0011a\n\r\u0002\u0005\u0019>tw-\u0001\u000bSKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\n\u0003\u00139\"\u0012A\u0015\t\u0003W%\tA\u0001^5nKV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002YO\u0005)Q\u000f^5mg&\u0011!l\u0016\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!/\u001a9mS\u000e\fW#\u00010\u0011\u0005-z\u0016B\u00011&\u0005\u001d\u0011V\r\u001d7jG\u0006\f1B]3qY&\u001c\u0017m\u0018\u0013fcR\u00111M\u001a\t\u0003_\u0011L!!\u001a\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bO:\t\t\u00111\u0001_\u0003\rAH%M\u0001\te\u0016\u0004H.[2bA\u0005)1/\u001a;vaR\t1\r\u000b\u0002\u0011YB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0004CBL'BA9s\u0003\u001dQW\u000f]5uKJT!a]#\u0002\u000b),h.\u001b;\n\u0005Ut'A\u0003\"fM>\u0014X-R1dQ\u0006\u0011\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u001d\u0019\u0007P\u001f?\u007f\u0003\u0003AQ!_\tA\u00021\u000ba\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0003|#\u0001\u0007A*\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0003~#\u0001\u0007A*\u0001\nmCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\b\"B@\u0012\u0001\u0004a\u0015a\u00077bgR4U\r^2i\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000f\u0003\u0004\u0002\u0004E\u0001\r\u0001T\u0001\u0010Y\u0006\u001cHOR3uG\"$\u0016.\\3Ng\u0006y\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f\t>,7OT8u\u0007\"\fgnZ3\u0015\u0007\r\fI\u0001\u0003\u0005\u0002\fI!\t\u0019AA\u0007\u0003\ty\u0007\u000f\u0005\u00030\u0003\u001f\u0019\u0017bAA\ta\tAAHY=oC6,g(\u0001\tva\u0012\fG/\u001a$fi\u000eD7\u000b^1uKR9A*a\u0006\u0002\u001c\u0005}\u0001BBA\r'\u0001\u0007A*A\ng_2dwn^3s\r\u0016$8\r[(gMN,G\u000f\u0003\u0004\u0002\u001eM\u0001\r\u0001T\u0001\u0014M>dGn\\<feN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003C\u0019\u0002\u0019\u0001'\u0002\u001f1,\u0017\rZ3s\u000b:$wJ\u001a4tKR\f\u0011C]3tKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u001da\u0015qEA\u0015\u0003gAa!!\t\u0015\u0001\u0004a\u0005bBA\u0016)\u0001\u0007\u0011QF\u0001\fSNtUm\u001e'fC\u0012,'\u000fE\u00020\u0003_I1!!\r1\u0005\u001d\u0011un\u001c7fC:Dq!!\u000e\u0015\u0001\u0004\ti#\u0001\tjg\u001a{G\u000e\\8xKJLenU=oG\u0006QR.Y=cKJ+7/\u001a;MCN$8)Y;hQR,\u0006\u000fV5nKR\u0019A*a\u000f\t\r\u0005\u0005R\u00031\u0001M\u0003)I7oQ1vO\"$X\u000b\u001d\u000b\u0005\u0003[\t\t\u0005\u0003\u0004\u0002\"Y\u0001\r\u0001T\u0001\u0011i\u0016\u001cH/\u00138ji&\fGn\u0015;bi\u0016D3aFA$!\ri\u0017\u0011J\u0005\u0004\u0003\u0017r'\u0001\u0002+fgR\fA\u0003^3tiV\u0003H-\u0019;f\r\u0016$8\r[*uCR,\u0007f\u0001\r\u0002H\u0005aD/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u0019\u0016\fG-\u001a:JgJ+W\r\\3di\u0016$\u0017I\u001c3SKBd\u0017nY1Jg&s7+\u001f8dQ\rI\u0012qI\u0001@i\u0016\u001cHOU3tKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f/\",g\u000eT3bI\u0016\u0014\u0018j\u001d*fK2,7\r^3e\u0003:$'+\u001a9mS\u000e\f\u0017j\u001d(pi&s7+\u001f8dQ\rQ\u0012qI\u0001>i\u0016\u001cHOU3tKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f/\",gNT3x\u0019\u0016\fG-\u001a:Jg\u0016cWm\u0019;fI\u0006sGMU3qY&\u001c\u0017-S:J]NKhn\u0019\u0015\u00047\u0005\u001d\u0013\u0001\u0011;fgR\u0014Vm]3u%\u0016\u0004H.[2b'R\fG/Z,iK:tUm\u001e'fC\u0012,'/S:FY\u0016\u001cG/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006L5OT8u\u0013:\u001c\u0016P\\2)\u0007q\t9%A\ruKN$(+Z:fi2\u000b7\u000f^\"bk\u001eDG/\u00169US6,\u0007fA\u000f\u0002H\u00059E/Z:u%\u0016\u001cX\r\u001e'bgR\u001c\u0015-^4iiV\u0003H+[7f\u0013Ntu\u000e\u001e*fg\u0016$\u0018I\u001a;fe2+\u0017\rZ3s\u000b2,7\r^3e\u0003:$'+\u001a9mS\u000e\fgj\u001c;J]&\u001b(\u000fK\u0002\u001f\u0003\u000f\nq\t^3ti2\u000b7\u000f^\"bk\u001eDG/\u00169US6,\u0017j\u001d(piJ+7/\u001a;XQ\u0016tW\u000b\u001d3bi\u00164U\r^2i'R\fG/Z,ji\"\u001cF/\u00197f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004?\u0005\u001d\u0013\u0001\u000f;fgR\u0014V\r\u001d7jG\u0006\u001c\u0006n\\;mI:{GOQ3DCV<\u0007\u000e^+q/\",g.V:j]\u001e\u001cF/\u00197f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004A\u0005\u001d\u0013a\u000b;fgRL5oQ1vO\"$X\u000b],iK:\u0014V\r\u001d7jG\u0006L5oQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0007\u0005\n9%\u0001\u0018uKN$\u0018j]\"bk\u001eDG/\u00169XQ\u0016t'+\u001a9mS\u000e\f\u0017j\u001d(pi\u000e\u000bWo\u001a5u+B$v\u000eT8h\u000b:$\u0007f\u0001\u0012\u0002H\u0005YE/Z:u\u0013N\u001c\u0015-^4iiV\u0003H+[7f\u0013Ntu\u000e^!mo\u0006L8OU3tKR<\u0006.\u001a8G_2dwn^3s\u0013N\u001c\u0015-^4iiV\u0003Hk\\*uC2,Gj\\4F]\u0012|eMZ:fi\"\u001a1%a\u0012")
public class ConfluentReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ConfluentReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ConfluentReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        this.replica_$eq(new Replica(ConfluentReplicaTest$.MODULE$.BrokerId(), ConfluentReplicaTest$.MODULE$.Partition()));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs());
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchState(new LogOffsetMetadata(followerFetchOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), followerStartOffset, currentTimeMs, leaderEndOffset);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    /*
     * WARNING - void declaration
     */
    private long maybeResetLastCaughtUpTime(long leaderEndOffset) {
        void var3_2;
        long currentTimeMs = this.time().milliseconds();
        this.replica().maybeResetLastCaughtUpTime(currentTimeMs, leaderEndOffset);
        return (long)var3_2;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L);
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1);
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2);
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), resetTimeMs1, MergedLog$.MODULE$.UnknownOffset(), 0L);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, MergedLog$.MODULE$.UnknownOffset(), 0L);
    }

    @Test
    public void testResetLastCaughtUpTime() {
        this.updateFetchState(5L, 1L, 10L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(15L));
        this.time().sleep(1000L);
        this.updateFetchState(10L, 1L, 15L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        this.time().sleep(1000L);
        this.updateFetchState(16L, 1L, 16L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(17L);
        this.assertReplicaState(1L, 16L, resetTimeMs1, 17L, resetTimeMs1);
    }

    @Test
    public void testResetLastCaughtUpTimeIsNotResetAfterLeaderElectedAndReplicaNotInIsr() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(10L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 10L, 0L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
    }

    @Test
    public void testLastCaughtUpTimeIsNotResetWhenUpdateFetchStateWithStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1);
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
    }

    @Test
    public void testReplicaShouldNotBeCaughtUpWhenUsingStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(0L, 0L, 10L);
        this.assertReplicaState(0L, 0L, 0L, 10L, fetchTimeMs1);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(12L));
        this.updateFetchState(10L, 1L, 10L);
        this.time().sleep(ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(12L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }

    @Test
    public void testIsCaughtUpTimeIsNotAlwaysResetWhenFollowerIsCaughtUpToStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1);
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        Assertions.assertTrue((boolean)this.isCaughtUp(11L));
        this.time().sleep(ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(12L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        Assertions.assertTrue((boolean)this.isCaughtUp(12L));
        this.time().sleep(ConfluentReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(13L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        Assertions.assertTrue((boolean)this.isCaughtUp(13L));
        this.time().sleep(1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(13L));
    }
}

