/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogTestUtils;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterIsrManager;
import kafka.server.Defaults$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001B\u00193\u0001]BQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001J\u0011\u0019y\u0005\u0001)A\u0005\u0015\"9\u0001\u000b\u0001b\u0001\n\u0003I\u0005BB)\u0001A\u0003%!\nC\u0004S\u0001\t\u0007I\u0011A*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\u0002eCaA\u0019\u0001!\u0002\u0013Q\u0006bB2\u0001\u0005\u0004%\t!\u0017\u0005\u0007I\u0002\u0001\u000b\u0011\u0002.\t\u000f\u0015\u0004!\u0019!C\u0001M\"1q\u000e\u0001Q\u0001\n\u001dDq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0001r\u0011\u00199\b\u0001)A\u0005e\"9\u0001\u0010\u0001b\u0001\n\u0003I\bbBA\u0013\u0001\u0001\u0006IA\u001f\u0005\n\u0003O\u0001!\u0019!C\u0001\u0003SA\u0001\"a\u000e\u0001A\u0003%\u00111\u0006\u0005\n\u0003s\u0001!\u0019!C\u0001\u0003wA\u0001\"!\u0013\u0001A\u0003%\u0011Q\b\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0003\ti\u0005C\u0006\u0002V\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001fB1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002h!Y\u0011q\u000e\u0001A\u0002\u0003\u0007I\u0011AA9\u0011-\t)\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0004\u0002CAB\u0001\u0001\u0006I!a\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u001d\u0005bBAU\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003g\u0003A\u0011AAD\u0011\u001d\t9\f\u0001C\u0001\u0003\u000fCq!a/\u0001\t\u0003\t9\tC\u0004\u0002@\u0002!I!a\"\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002\b\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005wAqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003f\u0001!IAa\u001a\t\u000f\tE\u0004\u0001\"\u0003\u0003t\t\t\u0002+\u0019:uSRLwN\u001c'pG.$Vm\u001d;\u000b\u0005M\"\u0014aB2mkN$XM\u001d\u0006\u0002k\u0005)1.\u00194lC\u000e\u00011c\u0001\u00019}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u001b\u0002\u000bU$\u0018\u000e\\:\n\u0005\r\u0003%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0003\"a\u0012\u0001\u000e\u0003I\n!C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sgV\t!\n\u0005\u0002:\u0017&\u0011AJ\u000f\u0002\u0004\u0013:$\u0018a\u00058v[J+\u0007\u000f\\5dC\u001a+Go\u00195feN\u0004\u0013\u0001\u00048v[B\u0013x\u000eZ;dKJ\u001c\u0018!\u00048v[B\u0013x\u000eZ;dKJ\u001c\b%A\u000bok6\u0014VmY8sIN\u0004VM\u001d)s_\u0012,8-\u001a:\u0002-9,XNU3d_J$7\u000fU3s!J|G-^2fe\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0002)B\u0011q(V\u0005\u0003-\u0002\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\na\u0001^7q\t&\u0014X#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AA5p\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013aD3yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002m=\u0006!Q\u000f^5m\u0013\tq\u0017NA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003A)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007%A\bbaB,g\u000eZ*f[\u0006\u0004\bn\u001c:f+\u0005\u0011\bC\u00015t\u0013\t!\u0018NA\u0005TK6\f\u0007\u000f[8sK\u0006\u0001\u0012\r\u001d9f]\u0012\u001cV-\\1qQ>\u0014X\rI\u0001\u0013g\"\u0014\u0018N\\6JgJ\u001cV-\\1qQ>\u0014X-A\ntQJLgn[%teN+W.\u00199i_J,\u0007%\u0001\bg_2dwn^3s#V,W/Z:\u0016\u0003i\u0004Ra_A\u0001\u0003\u000bi\u0011\u0001 \u0006\u0003{z\f\u0011\"[7nkR\f'\r\\3\u000b\u0005}T\u0014AC2pY2,7\r^5p]&\u0019\u00111\u0001?\u0003\u0015%sG-\u001a=fIN+\u0017\u000fE\u0003i\u0003\u000f\tY!C\u0002\u0002\n%\u0014!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vKB!\u0011QBA\u0011\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011A\u0002:fG>\u0014HM\u0003\u0003\u0002\u0016\u0005]\u0011AB2p[6|gNC\u00026\u00033QA!a\u0007\u0002\u001e\u00051\u0011\r]1dQ\u0016T!!a\b\u0002\u0007=\u0014x-\u0003\u0003\u0002$\u0005=!!D'f[>\u0014\u0018PU3d_J$7/A\bg_2dwn^3s#V,W/Z:!\u0003E!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003W\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c!\u0014a\u00017pO&!\u0011QGA\u0018\u0005E!\u0016.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u0001\u0013i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\b%\u0001\nuS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA\u001f!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"i\u0005!A/[3s\u0013\u0011\t9%!\u0011\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA(!\u0011\ti#!\u0015\n\t\u0005M\u0013q\u0006\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u00033\ny\u0006E\u0002:\u00037J1!!\u0018;\u0005\u0011)f.\u001b;\t\u0013\u0005\u00054$!AA\u0002\u0005=\u0013a\u0001=%c\u0005YAn\\4NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002jA\u0019q)a\u001b\n\u0007\u00055$GA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$B!!\u0017\u0002t!I\u0011\u0011\r\u0010\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003w\u0002B!! \u0002\u00005\u0011\u00111C\u0005\u0005\u0003\u0003\u000b\u0019B\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nQa]3u+B$\"!!\u0017)\u0007\t\nY\t\u0005\u0003\u0002\u000e\u0006mUBAAH\u0015\u0011\t\t*a%\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0016\u0006]\u0015a\u00026va&$XM\u001d\u0006\u0005\u00033\u000bi\"A\u0003kk:LG/\u0003\u0003\u0002\u001e\u0006=%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002$\u0003G\u0003B!!$\u0002&&!\u0011qUAH\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0013uKN$hj\u001c'pG.\u001cuN\u001c;f]RLwN\\,ji\"|W\u000f^%teV\u0003H-\u0019;fQ\r!\u0013Q\u0016\t\u0005\u0003\u001b\u000by+\u0003\u0003\u00022\u0006=%\u0001\u0002+fgR\fA\u0007^3ti\u0006\u0003\b/\u001a8e%\u0016\u0004H.[2b\r\u0016$8\r[,ji\"\u001c6\r[3ek2,'o\u00115fG.4uN]*ie&t7.S:sQ\r)\u0013QV\u0001$i\u0016\u001cH/\u00119qK:$'+\u001a9mS\u000e\fg)\u001a;dQ^KG\u000f[+qI\u0006$X-S:sQ\r1\u0013QV\u0001)i\u0016\u001cHoR3u%\u0016\u0004H.[2b/&$\b.\u00169eCR,\u0017i]:jO:lWM\u001c;B]\u0012L5O\u001d\u0015\u0004O\u00055\u0016AJ2p]\u000e,(O]3oiB\u0013x\u000eZ;dK\u001a+Go\u00195XSRD'+Z1e\u0019>\u001c7n\u00148ms\u0006\u00193m\u001c8dkJ\u0014XM\u001c;Qe>$WoY3GKR\u001c\u0007nV5uQ^\u0013\u0018\u000e^3M_\u000e\\\u0017aD:dQ\u0016$W\u000f\\3BaB,g\u000eZ:\u0015\u0005\u0005\u001d\u0007CBAe\u00033\fyN\u0004\u0003\u0002L\u0006Ug\u0002BAg\u0003'l!!a4\u000b\u0007\u0005Eg'\u0001\u0004=e>|GOP\u0005\u0002w%\u0019\u0011q\u001b\u001e\u0002\u000fA\f7m[1hK&!\u00111\\Ao\u0005\r\u0019V-\u001d\u0006\u0004\u0003/T\u0004\u0007BAq\u0003W\u0004R\u0001[Ar\u0003OL1!!:j\u0005\u00191U\u000f^;sKB!\u0011\u0011^Av\u0019\u0001!1\"!<+\u0003\u0003\u0005\tQ!\u0001\u0002p\n\u0019q\fJ\u0019\u0012\t\u0005E\u0018q\u001f\t\u0004s\u0005M\u0018bAA{u\t9aj\u001c;iS:<\u0007cA\u001d\u0002z&\u0019\u00111 \u001e\u0003\u0007\u0005s\u00170A\ftG\",G-\u001e7f+B$\u0017\r^3G_2dwn^3sgR!!\u0011\u0001B\u0007!\u0019\tI-!7\u0003\u0004A\"!Q\u0001B\u0005!\u0015A\u00171\u001dB\u0004!\u0011\tIO!\u0003\u0005\u0017\t-1&!A\u0001\u0002\u000b\u0005\u0011q\u001e\u0002\u0004?\u0012\u0012\u0004B\u0002B\bW\u0001\u0007!*\u0001\u0006ok6\u0014VmY8sIN\f\u0011c]2iK\u0012,H.Z*ie&t7.S:s)\u0019\u0011)Ba\b\u00030A\"!q\u0003B\u000e!\u0015A\u00171\u001dB\r!\u0011\tIOa\u0007\u0005\u0017\tuA&!A\u0001\u0002\u000b\u0005\u0011q\u001e\u0002\u0004?\u0012\u001a\u0004b\u0002B\u0011Y\u0001\u0007!1E\u0001\u000bC\u000e$\u0018N^3GY\u0006<\u0007\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\u0007\t%\u0012.\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005[\u00119CA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\b\u0005ca\u0003\u0019\u0001B\u001a\u0003=iwnY6US6,7\u000b\\3fa6\u001b\bcA\u001d\u00036%\u0019!q\u0007\u001e\u0003\t1{gnZ\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$B!!\u001b\u0003>!9\u00111J\u0017A\u0002\u0005=\u0013aE2sK\u0006$X\rT8h!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\"\u0005\u0017\u0002BA!\u0012\u0003H5\t1.C\u0002\u0003J-\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011iE\fa\u0001\u0005\u001f\n\u0011b\u001c<feJLG-Z:\u0011\u0011\tE#\u0011\fB0\u0005?rAAa\u0015\u0003VA\u0019\u0011Q\u001a\u001e\n\u0007\t]#(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00057\u0012iFA\u0002NCBT1Aa\u0016;!\u0011\u0011\tF!\u0019\n\t\t\r$Q\f\u0002\u0007'R\u0014\u0018N\\4\u0002\r\u0005\u0004\b/\u001a8e)!\tIF!\u001b\u0003l\t5\u0004bBA3_\u0001\u0007\u0011\u0011\u000e\u0005\u0007\u0005\u001fy\u0003\u0019\u0001&\t\ra|\u0003\u0019\u0001B8!\u0019\tI-!7\u0002\u0006\u0005AR\u000f\u001d3bi\u00164u\u000e\u001c7po\u0016\u0014h)\u001a;dQN#\u0018\r^3\u0015\u0015\u0005e#Q\u000fB<\u0005w\u0012i\bC\u0004\u0002fA\u0002\r!!\u001b\t\r\te\u0004\u00071\u0001K\u0003)1w\u000e\u001c7po\u0016\u0014\u0018\n\u001a\u0005\u0007\u0005\u001f\u0001\u0004\u0019\u0001&\t\u000f\t}\u0004\u00071\u0001\u0002\u0006\u0005iam\u001c7m_^,'/U;fk\u0016\u0004")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private final IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)x$1 -> PartitionLockTest.$anonfun$followerQueues$1(BoxesRunTime.unboxToInt((Object)x$1)));
    private final TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues() {
        return this.followerQueues;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        String string;
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        int n4 = Integer.MAX_VALUE;
        String string2 = string = "MD5";
        string = null;
        String x$10 = string2;
        boolean bl = false;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}))), logConfig, configRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, n4, x$10, bl), this.mockTime(), ApiVersion$.MODULE$.latestVersion(), TierLogComponents$.MODULE$.EMPTY()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"shrinkIsr not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)}))).asJava();
        java.util.List secondReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints, (Option)None$.MODULE$);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleUpdateFollowers(1).foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$6 -> x$6.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$10 -> x$10.get(15L, TimeUnit.SECONDS));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable)x$11 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$11)));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleUpdateFollowers(int numRecords) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable)index -> PartitionLockTest.$anonfun$scheduleUpdateFollowers$1(this, numRecords, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public AbstractLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                AbstractLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, topicId);
                return new LogTestUtils.SlowAppendAsLeaderLog((MergedLog)log, this.$outer.tierLogComponents(), this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), brokerId$1, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, (Option)new Some((Object)$outer.tierReplicaManager()), (Option)None$.MODULE$, (Option)None$.MODULE$, alterIsrManager$1, (Option)None$.MODULE$, false, (Option)None$.MODULE$);
            }
        };
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)alterIsrManager.submit((TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()), (LeaderAndIsr)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i))).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords, scala.collection.immutable.Seq<ArrayBlockingQueue<MemoryRecords>> followerQueues) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
            partition.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal, partition.appendRecordsToLeader$default$5());
            followerQueues.foreach((Function1 & Serializable)x$13 -> {
                x$13.put(batch);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void updateFollowerFetchState(Partition partition, int followerId, int numRecords, ArrayBlockingQueue<MemoryRecords> followerQueue) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
            MemoryRecords batch = (MemoryRecords)followerQueue.poll(15L, TimeUnit.SECONDS);
            if (batch == null) {
                throw new RuntimeException(new StringBuilder(33).append("Timed out waiting for next batch ").append(i).toString());
            }
            List batches = CollectionConverters$.MODULE$.IteratorHasAsScala(batch.batches().iterator()).asScala().toList();
            Assertions.assertEquals((int)1, (int)batches.size());
            MutableRecordBatch recordBatch = (MutableRecordBatch)batches.head();
            return partition.updateFollowerFetchState(followerId, new LogOffsetMetadata(recordBatch.lastOffset() + 1L, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.mockTime().milliseconds(), partition.localLogOrException().logEndOffset());
        });
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1(int x$1) {
        return new ArrayBlockingQueue(2);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$11) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer(), (scala.collection.immutable.Seq<ArrayBlockingQueue<MemoryRecords>>)$this.followerQueues());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1(PartitionLockTest $this, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.updateFollowerFetchState($this.partition(), index, numRecords$1, (ArrayBlockingQueue)$this.followerQueues().apply(index - 1));
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
    }
}

