/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Optional;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_2_8_IV1$;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000592A\u0001B\u0003\u0001\u0015!)q\u0002\u0001C\u0001!!)!\u0003\u0001C)'!)!\u0004\u0001C\u00017\t!\u0003+\u0019:uSRLwN\\,ji\"dUmZ1ds6+7o]1hK\u001a{'/\\1u)\u0016\u001cHO\u0003\u0002\u0007\u000f\u000591\r\\;ti\u0016\u0014(\"\u0001\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0003\t\u0003\u00195i\u0011!B\u0005\u0003\u001d\u0015\u0011Q#\u00112tiJ\f7\r\u001e)beRLG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011A\u0002A\u0001\u001bS:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0002)A\u0011Q\u0003G\u0007\u0002-)\u0011qcB\u0001\u0004CBL\u0017BA\r\u0017\u0005)\t\u0005/\u001b,feNLwN\\\u00013i\u0016\u001cH/T1lK2+\u0017\rZ3s\t>,7OT8u+B$\u0017\r^3Fa>\u001c\u0007nQ1dQ\u00164uN](mI\u001a{'/\\1ugR\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0003V]&$\bFA\u0002$!\t!C&D\u0001&\u0015\t9bE\u0003\u0002(Q\u00059!.\u001e9ji\u0016\u0014(BA\u0015+\u0003\u0015QWO\\5u\u0015\u0005Y\u0013aA8sO&\u0011Q&\n\u0002\u0005)\u0016\u001cH\u000f")
public class PartitionWithLegacyMessageFormatTest
extends AbstractPartitionTest {
    @Override
    public ApiVersion interBrokerProtocolVersion() {
        return KAFKA_2_8_IV1$.MODULE$;
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        this.configRepository().setTopicConfig(this.topicPartition().topic(), LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_2_IV0$.MODULE$.shortVersion());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$12, x$3, x$4, (Option)x$2);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}))), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)-1, (int)epochEndOffset.leaderEpoch());
    }
}

