/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kafka.common.ReplicaExclusionCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReplicaExclusionCacheTest {
    @Test
    public void testCache() {
        ReplicaExclusionCache cache = new ReplicaExclusionCache();
        Assertions.assertEquals(Collections.emptyMap(), (Object)cache.exclusions());
        Assertions.assertEquals(Collections.emptySet(), (Object)cache.excludedBrokers());
        HashMap<Integer, String> expectedExclusions = new HashMap<Integer, String>();
        expectedExclusions.put(1, "maintenance-1");
        expectedExclusions.put(2, "maintenance-2");
        cache.overrideMap(expectedExclusions);
        Set receivedExcludedBrokers = cache.excludedBrokers();
        HashSet<Integer> expectedExcludedBrokers = new HashSet<Integer>(Arrays.asList(1, 2));
        Assertions.assertEquals(expectedExcludedBrokers, (Object)receivedExcludedBrokers);
        boolean removed = receivedExcludedBrokers.remove(1);
        Assertions.assertTrue((boolean)removed);
        Assertions.assertEquals(expectedExcludedBrokers, (Object)cache.excludedBrokers());
        Map receivedMap = cache.exclusions();
        Assertions.assertEquals(expectedExclusions, (Object)receivedMap);
        receivedMap.put(4, "new reason");
        Assertions.assertEquals(expectedExclusions, (Object)cache.exclusions());
    }
}

