/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$;
import kafka.controller.ControlMetadataBatchIntegrationTest$KafkaControllerTest$;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DelegationTokenManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCQA\u0013\u0001\u0005\u0002-CQa\u0018\u0001\u0005\n\u00014Aa\u001b\u0001\u0001Y\"A!\r\u0002BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005r\t\t\u0005\t\u0015!\u0003d\u0011\u00151E\u0001\"\u0001s\u0011\u001d1HA1A\u0005\u0002]Daa\u001f\u0003!\u0002\u0013A\bb\u0002?\u0005\u0005\u0004%\t! \u0005\b\u0003\u0013!\u0001\u0015!\u0003\u007f\u0011%\tY\u0001\u0002a\u0001\n\u0003\ti\u0001C\u0005\u0002\u001c\u0011\u0001\r\u0011\"\u0001\u0002\u001e!A\u00111\u0005\u0003!B\u0013\ty\u0001\u0003\u0004\u0002&\u0011!\ta\u0013\u0005\u0007\u0003O!A\u0011A&\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA\u001b\u0001\u0011%\u0011q\u0007\u0004\u0007\u0003w\u0001\u0001!!\u0010\t\u0011Y$\"Q1A\u0005B]D!b\u001f\u000b\u0003\u0002\u0003\u0006I\u0001_A#\u0011)\tY\u0001\u0006B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003\u000f\"\"\u0011!Q\u0001\n\u0005%\u0003BCA0)\t\u0005\t\u0015!\u0003\u0002b!I\u00111\u000e\u000b\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003[\"\"\u0011!Q\u0001\n\u0005=\u0004BCA;)\t\u0005\t\u0015!\u0003\u0002x!Q\u0011Q\u0010\u000b\u0003\u0002\u0003\u0006I!a \t\u0015\u0005EEC!A!\u0002\u0013\t\u0019\n\u0003\u0006\u0002,R\u0011\t\u0011)A\u0005\u0003[C!\"a-\u0015\u0005\u0003\u0005\u000b\u0011BA[\u0011\u00191E\u0003\"\u0001\u0002<\"9\u0011Q\u001b\u000b\u0005B\u0005]w!CA~\u0001\u0005\u0005\t\u0012AA\u007f\r%\tY\u0004AA\u0001\u0012\u0003\ty\u0010\u0003\u0004GI\u0011\u0005!\u0011\u0001\u0005\n\u0005\u0007!\u0013\u0013!C\u0001\u0005\u000bA\u0011Ba\u0007%#\u0003%\tA!\b\t\u0013\t\u0005B%%A\u0005\u0002\t\rbA\u0002B\u0014\u0001\u0001\u0011I\u0003\u0003\u0006\u0002b&\u0012\t\u0011)A\u0005\u0003GD\u0001B^\u0015\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u000b\u0003\u000fJ#\u0011!Q\u0001\n\u0005%\u0003BCA0S\t\u0005\t\u0015!\u0003\u0002b!Q\u0011\u0011_\u0015\u0003\u0002\u0003\u0006I!a=\t\u0015\u0005E\u0015F!A!\u0002\u0013\t\u0019\n\u0003\u0004GS\u0011\u0005!1\u0006\u0005\b\u0005wIC\u0011\u000bB\u001f\u0011\u001d\u0011y%\u000bC)\u0005#BqAa\u0016*\t#\u0012I\u0006C\u0004\u0003V%\"\tA!\u0018\b\u0013\t\u0005\u0004!!A\t\u0002\t\rd!\u0003B\u0014\u0001\u0005\u0005\t\u0012\u0001B3\u0011\u00191e\u0007\"\u0001\u0003h!I!\u0011\u000e\u001c\u0012\u0002\u0013\u0005!1\u0005\u0002$\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195J]R,wM]1uS>tG+Z:u\u0015\tYD(\u0001\u0006d_:$(o\u001c7mKJT\u0011!P\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002Dy\u000511/\u001a:wKJL!!\u0012\"\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0011B\u0011\u0011\nA\u0007\u0002u\u0005QD/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d#pKNtu\u000e\u001e*fM\u0016\u0014Hk\u001c\"s_.,'o\u001d(pi&sW*\u001a;bI\u0006$\u0018mQ1dQ\u0016LV\r\u001e\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n!QK\\5uQ\t\u00111\u000b\u0005\u0002U;6\tQK\u0003\u0002W/\u0006\u0019\u0011\r]5\u000b\u0005aK\u0016a\u00026va&$XM\u001d\u0006\u00035n\u000bQA[;oSRT\u0011\u0001X\u0001\u0004_J<\u0017B\u00010V\u0005\u0011!Vm\u001d;\u0002UY,'/\u001b4z\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\"bi\u000eD'+\u001a4feR{7J\\8x]\n\u0013xn[3sgR\u0019A*\u00194\t\u000b\t\u001c\u0001\u0019A2\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"!\u00143\n\u0005\u0015t%aA%oi\")qm\u0001a\u0001Q\u0006y!M]8lKJ\u001cF/\u0019;f\u0013:4w\u000e\u0005\u0002JS&\u0011!N\u000f\u0002\u001a\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u001cF/\u0019;f\u0013:4wN\u0001\u0006UKN$(I]8lKJ\u001c\"\u0001B7\u0011\u00055s\u0017BA8O\u0005\u0019\te.\u001f*fMV\t1-A\u0005ce>\\WM]%eAQ\u00111/\u001e\t\u0003i\u0012i\u0011\u0001\u0001\u0005\u0006E\u001e\u0001\raY\u0001\u0007G>tg-[4\u0016\u0003a\u0004\"!Q=\n\u0005i\u0014%aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0006ce>\\WM]%oM>,\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001P\u0001\u0003u.LA!a\u0002\u0002\u0002\tQ!I]8lKJLeNZ8\u0002\u0017\t\u0014xn[3s\u0013:4w\u000eI\u0001\tu.\u001cE.[3oiV\u0011\u0011q\u0002\t\u0006\u001b\u0006E\u0011QC\u0005\u0004\u0003'q%AB(qi&|g\u000eE\u0002\u0000\u0003/IA!!\u0007\u0002\u0002\ti1*\u00194lCj[7\t\\5f]R\fAB_6DY&,g\u000e^0%KF$2\u0001TA\u0010\u0011%\t\t#DA\u0001\u0002\u0004\ty!A\u0002yIE\n\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u000f\r|gN\\3di\u0006QA-[:d_:tWm\u0019;\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0007a\fi\u0003C\u0003c#\u0001\u00071-\u0001\tde\u0016\fG/\u001a\"s_.,'/\u00138g_R\u0019a0a\r\t\u000bY\u0014\u0002\u0019\u0001=\u0002\u001d\r\u0014X-\u0019;f5.\u001cE.[3oiR!\u0011QCA\u001d\u0011\u001518\u00031\u0001y\u0005MY\u0015MZ6b\u0007>tGO]8mY\u0016\u0014H+Z:u'\r!\u0012q\b\t\u0004\u0013\u0006\u0005\u0013bAA\"u\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'/C\u0002w\u0003\u0003\nA\u0001^5nKB!\u00111JA.\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!B;uS2\u001c(\u0002BA*\u0003+\naaY8n[>t'bA\u001f\u0002X)\u0019\u0011\u0011L.\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ti&!\u0014\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t\u0019'a\u001a\u000e\u0005\u0005\u0015$\u0002BA0\u0003#JA!!\u001b\u0002f\t9Q*\u001a;sS\u000e\u001c\u0018!E5oSRL\u0017\r\u001c\"s_.,'/\u00138g_\u0006\u0011\u0012N\\5uS\u0006d'I]8lKJ,\u0005o\\2i!\ri\u0015\u0011O\u0005\u0004\u0003gr%\u0001\u0002'p]\u001e\fA\u0002^8lK:l\u0015M\\1hKJ\u00042!QA=\u0013\r\tYH\u0011\u0002\u0017\t\u0016dWmZ1uS>tGk\\6f]6\u000bg.Y4fe\u0006\u0019B/[3s)>\u0004\u0018nY'b]\u0006<WM](qiB)Q*!\u0005\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!\u0002;pa&\u001c'bAAFy\u0005!A/[3s\u0013\u0011\ty)!\"\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\u0018\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\u0015i\u0015\u0011CAK!\u0011\t9*!*\u000f\t\u0005e\u0015\u0011\u0015\t\u0004\u00037sUBAAO\u0015\r\tyJP\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\rf*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\u000bIK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Gs\u0015A\u00042s_.,'OR3biV\u0014Xm\u001d\t\u0004\u0003\u0006=\u0016bAAY\u0005\nq!I]8lKJ4U-\u0019;ve\u0016\u001c\u0018\u0001\u00044fCR,(/Z\"bG\",\u0007cA!\u00028&\u0019\u0011\u0011\u0018\"\u0003+\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7)Y2iKRA\u0012QXA`\u0003\u0003\f\u0019-!2\u0002H\u0006%\u00171ZAg\u0003\u001f\f\t.a5\u0011\u0005Q$\u0002\"\u0002<\"\u0001\u0004A\bbBA\u0006C\u0001\u0007\u0011Q\u0003\u0005\b\u0003\u000f\n\u0003\u0019AA%\u0011\u001d\ty&\ta\u0001\u0003CBa!a\u001b\"\u0001\u0004q\bbBA7C\u0001\u0007\u0011q\u000e\u0005\n\u0003k\n\u0003\u0013!a\u0001\u0003oB\u0011\"! \"!\u0003\u0005\r!a \t\u0013\u0005E\u0015\u0005%AA\u0002\u0005M\u0005bBAVC\u0001\u0007\u0011Q\u0016\u0005\b\u0003g\u000b\u0003\u0019AA[\u0003mqWm^\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feRq\u0011\u0011\\Ap\u0003S\fY/!<\u0002p\u0006e\bcA%\u0002\\&\u0019\u0011Q\u001c\u001e\u00031\r{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000fC\u0004\u0002b\n\u0002\r!a9\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000fE\u0002J\u0003KL1!a:;\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006m\n\u0002\r\u0001\u001f\u0005\b\u0003\u000f\u0012\u0003\u0019AA%\u0011\u001d\tyF\ta\u0001\u0003CBq!!=#\u0001\u0004\t\u00190A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u00042!SA{\u0013\r\t9P\u000f\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\bbBAIE\u0001\u0007\u00111S\u0001\u0014\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7feR+7\u000f\u001e\t\u0003i\u0012\u001a\"\u0001J7\u0015\u0005\u0005u\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\b)\"\u0011q\u000fB\u0005W\t\u0011Y\u0001\u0005\u0003\u0003\u000e\t]QB\u0001B\b\u0015\u0011\u0011\tBa\u0005\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u000b\u001d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te!q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003 )\"\u0011q\u0010B\u0005\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u0005\u0016\u0005\u0003'\u0013IA\u0001\u000fD_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ$Vm\u001d;\u0014\u0007%\nI\u000e\u0006\b\u0003.\t=\"\u0011\u0007B\u001a\u0005k\u00119D!\u000f\u0011\u0005QL\u0003bBAqa\u0001\u0007\u00111\u001d\u0005\u0006mB\u0002\r\u0001\u001f\u0005\b\u0003\u000f\u0002\u0004\u0019AA%\u0011\u001d\ty\u0006\ra\u0001\u0003CBq!!=1\u0001\u0004\t\u0019\u0010C\u0005\u0002\u0012B\u0002\n\u00111\u0001\u0002\u0014\u0006a\u0011\r\u001a3OK^\u0014%o\\6feR\u0019AJa\u0010\t\u000f\t\u0005\u0013\u00071\u0001\u0003D\u00051!M]8lKJ\u0004BA!\u0012\u0003L5\u0011!q\t\u0006\u0004\u0005\u0013b\u0014aB2mkN$XM]\u0005\u0005\u0005\u001b\u00129E\u0001\u0004Ce>\\WM]\u0001\u0015e\u0016lwN^3Fq&\u001cH/\u001b8h\u0005J|7.\u001a:\u0015\u00071\u0013\u0019\u0006\u0003\u0004\u0003VI\u0002\r\u0001[\u0001\fEJ|7.\u001a:Ti\u0006$X-\u0001\fti\u0006\u0014HOU3rk\u0016\u001cHoU3oIRC'/Z1e)\ra%1\f\u0005\u0006EN\u0002\ra\u0019\u000b\u0004Q\n}\u0003\"\u000225\u0001\u0004\u0019\u0017\u0001H\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feR+7\u000f\u001e\t\u0003iZ\u001a\"AN7\u0015\u0005\t\r\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c\u0007")
public class ControlMetadataBatchIntegrationTest
extends QuorumTestHarness {
    private volatile ControlMetadataBatchIntegrationTest$KafkaControllerTest$ KafkaControllerTest$module;
    private volatile ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$ ControllerChannelManagerTest$module;

    public ControlMetadataBatchIntegrationTest$KafkaControllerTest$ KafkaControllerTest() {
        if (this.KafkaControllerTest$module == null) {
            this.KafkaControllerTest$lzycompute$1();
        }
        return this.KafkaControllerTest$module;
    }

    public ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$ ControllerChannelManagerTest() {
        if (this.ControllerChannelManagerTest$module == null) {
            this.ControllerChannelManagerTest$lzycompute$1();
        }
        return this.ControllerChannelManagerTest$module;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet() {
        Metrics metrics = new Metrics();
        TestBroker broker0 = null;
        TestBroker testBroker = null;
        TestBroker testBroker2 = null;
        KafkaControllerTest kafkaControllerTest = null;
        try {
            broker0 = new TestBroker(this, 0);
            testBroker = new TestBroker(this, 1);
            testBroker2 = new TestBroker(this, 2);
            broker0.connect();
            BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
            KafkaConfig x$1 = broker0.config();
            KafkaZkClient x$2 = (KafkaZkClient)broker0.zkClient().get();
            Time x$3 = Time.SYSTEM;
            BrokerInfo x$5 = broker0.brokerInfo();
            FinalizedFeatureCache x$8 = new FinalizedFeatureCache(brokerFeatures);
            DelegationTokenManager x$9 = this.KafkaControllerTest().$lessinit$greater$default$7();
            Option<TierTopicManager> x$10 = this.KafkaControllerTest().$lessinit$greater$default$8();
            Option<String> x$11 = this.KafkaControllerTest().$lessinit$greater$default$9();
            kafkaControllerTest = new KafkaControllerTest(x$1, x$2, x$3, metrics, x$5, 0L, x$9, x$10, x$11, brokerFeatures, x$8);
            kafkaControllerTest.startup();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!kafkaControllerTest.isActive()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Controller has not become active");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ControllerChannelManagerTest controllerChannelManager = (ControllerChannelManagerTest)kafkaControllerTest.controllerChannelManager();
            testBroker.connect();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!kafkaControllerTest.controllerContext().liveOrShuttingDownBroker(testBroker.brokerId()).isDefined()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Broker 1 has not joined");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            testBroker2.connect();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!kafkaControllerTest.controllerContext().liveOrShuttingDownBroker(testBroker2.brokerId()).isDefined()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Broker 2 has not joined");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
            adminZkClient.createTopicWithAssignment("topic", new Properties(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)package$.MODULE$.Seq().empty()))})), adminZkClient.createTopicWithAssignment$default$4(), adminZkClient.createTopicWithAssignment$default$5(), adminZkClient.createTopicWithAssignment$default$6(), adminZkClient.createTopicWithAssignment$default$7());
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$7(controllerChannelManager)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                    Assertions.fail((String)"Broker 1 does not have the expected number of pending requests");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
            }
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$9(controllerChannelManager)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                    Assertions.fail((String)"Broker 2 does not have the expected number of pending requests");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
            }
            testBroker2.disconnect();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime6 = System.currentTimeMillis();
            while (!kafkaControllerTest.controllerContext().liveOrShuttingDownBroker(testBroker2.brokerId()).isEmpty()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                    Assertions.fail((String)"Broker 1 has not left");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
            }
            testBroker.disconnect();
            long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs7 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime7 = System.currentTimeMillis();
            while (!kafkaControllerTest.controllerContext().liveOrShuttingDownBroker(testBroker.brokerId()).isEmpty()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                    Assertions.fail((String)"Broker 2 has not left");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
            }
            Option leaderAndIsr = kafkaControllerTest.controllerContext().partitionLeadershipInfo(new TopicPartition("topic", 0));
            Assertions.assertTrue((boolean)leaderAndIsr.isDefined());
            Assertions.assertEquals((int)-1, (int)((LeaderIsrAndControllerEpoch)leaderAndIsr.get()).leaderAndIsr().leader());
            Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)((LeaderIsrAndControllerEpoch)leaderAndIsr.get()).leaderAndIsr().isr());
            testBroker2.connect();
            long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime8 = System.currentTimeMillis();
            while (!kafkaControllerTest.controllerContext().liveOrShuttingDownBroker(testBroker2.brokerId()).isDefined()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                    Assertions.fail((String)"Broker 2 has not joined");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
            }
            testBroker.connect();
            long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime9 = System.currentTimeMillis();
            while (!kafkaControllerTest.controllerContext().liveOrShuttingDownBroker(testBroker.brokerId()).isDefined()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs9) {
                    Assertions.fail((String)"Broker 1 has not joined");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs9), (long)waitUntilTrue_pause));
            }
            this.verifyLeaderAndIsrBatchReferToKnownBrokers(1, controllerChannelManager.brokerState(1));
            this.verifyLeaderAndIsrBatchReferToKnownBrokers(2, controllerChannelManager.brokerState(2));
        }
        catch (Throwable throwable) {
            if ((KafkaController)kafkaControllerTest != null) {
                ((KafkaController)kafkaControllerTest).shutdown();
            }
            if (broker0 != null) {
                broker0.disconnect();
            }
            if ((TestBroker)testBroker != null) {
                testBroker.disconnect();
            }
            if ((TestBroker)testBroker2 != null) {
                ((TestBroker)testBroker2).disconnect();
            }
            metrics.close();
            throw throwable;
        }
        kafkaControllerTest.shutdown();
        broker0.disconnect();
        testBroker.disconnect();
        testBroker2.disconnect();
        metrics.close();
    }

    private void verifyLeaderAndIsrBatchReferToKnownBrokers(int brokerId, ControllerBrokerStateInfo brokerStateInfo) {
        Set knownBrokers = Predef$.MODULE$.Set().empty();
        while (brokerStateInfo.messageQueue().size() > 0) {
            ControlMetadataBatch controlMetadataBatch = brokerStateInfo.messageQueue().take().batch();
            if (controlMetadataBatch instanceof UpdateMetadataBatch) {
                knownBrokers = ((IterableOnceOps)((UpdateMetadataBatch)controlMetadataBatch).liveBrokers().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).toSet();
                continue;
            }
            if (controlMetadataBatch instanceof LeaderAndIsrBatch) {
                LeaderAndIsrBatch leaderAndIsrBatch = (LeaderAndIsrBatch)controlMetadataBatch;
                Set unknownBroker = (Set)((IterableOnceOps)((IterableOps)leaderAndIsrBatch.partitions().values().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.leader()))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 >= 0)).toSet().$minus$minus((IterableOnce)knownBrokers);
                if (!unknownBroker.nonEmpty()) continue;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(58).append("Received an LeaderAndIsrBatch ").append(leaderAndIsrBatch).append(" for ").append(brokerId).append(" with unknown brokers: ").append(unknownBroker).toString());
                continue;
            }
            if (controlMetadataBatch instanceof StopReplicaBatch) continue;
            throw new MatchError((Object)controlMetadataBatch);
        }
    }

    public KafkaConfig kafka$controller$ControlMetadataBatchIntegrationTest$$createConfig(int brokerId) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public BrokerInfo kafka$controller$ControlMetadataBatchIntegrationTest$$createBrokerInfo(KafkaConfig config) {
        return BrokerInfo$.MODULE$.apply(new Broker(config.brokerId(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("", 0, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT)})), (Option)None$.MODULE$, Features.emptySupportedFeatures(), Predef$.MODULE$.Map().empty()), config.interBrokerProtocolVersion(), -1);
    }

    public KafkaZkClient kafka$controller$ControlMetadataBatchIntegrationTest$$createZkClient(KafkaConfig config) {
        return KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), config.zkMaxInFlightRequests(), Time.SYSTEM, new StringBuilder(6).append("Kafka ").append(config.brokerId()).toString(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(config, false), "kafka.server", "SessionExpireListener", false);
    }

    private final void KafkaControllerTest$lzycompute$1() {
        synchronized (this) {
            if (this.KafkaControllerTest$module == null) {
                this.KafkaControllerTest$module = new ControlMetadataBatchIntegrationTest$KafkaControllerTest$(this);
            }
            return;
        }
    }

    private final void ControllerChannelManagerTest$lzycompute$1() {
        synchronized (this) {
            if (this.ControllerChannelManagerTest$module == null) {
                this.ControllerChannelManagerTest$module = new ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$1(ObjectRef controller$1) {
        return ((KafkaController)controller$1.elem).isActive();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$2() {
        return "Controller has not become active";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$3(ObjectRef controller$1, ObjectRef broker1$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker1$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$4() {
        return "Broker 1 has not joined";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$5(ObjectRef controller$1, ObjectRef broker2$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker2$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$6() {
        return "Broker 2 has not joined";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$7(ControllerChannelManagerTest controllerChannelManager$1) {
        return controllerChannelManager$1.brokerState(1).messageQueue().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$8() {
        return "Broker 1 does not have the expected number of pending requests";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$9(ControllerChannelManagerTest controllerChannelManager$1) {
        return controllerChannelManager$1.brokerState(2).messageQueue().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$10() {
        return "Broker 2 does not have the expected number of pending requests";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$11(ObjectRef controller$1, ObjectRef broker2$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker2$1.elem).brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$12() {
        return "Broker 1 has not left";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$13(ObjectRef controller$1, ObjectRef broker1$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker1$1.elem).brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$14() {
        return "Broker 2 has not left";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$15(ObjectRef controller$1, ObjectRef broker2$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker2$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$16() {
        return "Broker 2 has not joined";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$17(ObjectRef controller$1, ObjectRef broker1$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker1$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$18() {
        return "Broker 1 has not joined";
    }

    public class ControllerChannelManagerTest
    extends ControllerChannelManager {
        public void addNewBroker(Broker broker) {
            ControlMetadataAccumulator messageQueue = new ControlMetadataAccumulator();
            this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo(null, new Node(broker.id(), "", 0), messageQueue, null, null, null, (Option)None$.MODULE$));
        }

        public void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
            Predef$.MODULE$.println((Object)brokerState);
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
        }

        public void startRequestSendThread(int brokerId) {
        }

        public ControllerBrokerStateInfo brokerState(int brokerId) {
            return (ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        }

        public /* synthetic */ ControlMetadataBatchIntegrationTest kafka$controller$ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$$$outer() {
            return ControlMetadataBatchIntegrationTest.this;
        }

        public ControllerChannelManagerTest(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
            if (ControlMetadataBatchIntegrationTest.this == null) {
                throw null;
            }
            super(controllerContext, config, time, metrics, stateChangeLogger, threadNamePrefix);
        }
    }

    public class KafkaControllerTest
    extends KafkaController {
        public KafkaConfig config() {
            return super.config();
        }

        public ControllerChannelManager newControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
            return this.kafka$controller$ControlMetadataBatchIntegrationTest$KafkaControllerTest$$$outer().new ControllerChannelManagerTest(controllerContext, config, time, metrics, stateChangeLogger, threadNamePrefix);
        }

        public /* synthetic */ ControlMetadataBatchIntegrationTest kafka$controller$ControlMetadataBatchIntegrationTest$KafkaControllerTest$$$outer() {
            return ControlMetadataBatchIntegrationTest.this;
        }

        public KafkaControllerTest(KafkaConfig config, KafkaZkClient zkClient, Time time, Metrics metrics, BrokerInfo initialBrokerInfo, long initialBrokerEpoch, DelegationTokenManager tokenManager, Option<TierTopicManager> tierTopicManagerOpt, Option<String> threadNamePrefix, BrokerFeatures brokerFeatures, FinalizedFeatureCache featureCache) {
            if (ControlMetadataBatchIntegrationTest.this == null) {
                throw null;
            }
            super(config, zkClient, time, metrics, initialBrokerInfo, initialBrokerEpoch, tokenManager, tierTopicManagerOpt, (ClusterLinkFactory.LinkManager)new ClusterLinkDisabled.LinkManager(), brokerFeatures, featureCache, new ReplicaExclusionCache(), threadNamePrefix);
        }
    }

    public class TestBroker {
        private final int brokerId;
        private final KafkaConfig config;
        private final BrokerInfo brokerInfo;
        private Option<KafkaZkClient> zkClient;
        public final /* synthetic */ ControlMetadataBatchIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public KafkaConfig config() {
            return this.config;
        }

        public BrokerInfo brokerInfo() {
            return this.brokerInfo;
        }

        public Option<KafkaZkClient> zkClient() {
            return this.zkClient;
        }

        public void zkClient_$eq(Option<KafkaZkClient> x$1) {
            this.zkClient = x$1;
        }

        public void connect() {
            KafkaZkClient client = this.kafka$controller$ControlMetadataBatchIntegrationTest$TestBroker$$$outer().kafka$controller$ControlMetadataBatchIntegrationTest$$createZkClient(this.config());
            client.createTopLevelPaths();
            client.registerBroker(this.brokerInfo());
            this.zkClient_$eq((Option<KafkaZkClient>)new Some((Object)client));
        }

        public void disconnect() {
            this.zkClient().foreach((Function1 & Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            this.zkClient_$eq((Option<KafkaZkClient>)None$.MODULE$);
        }

        public /* synthetic */ ControlMetadataBatchIntegrationTest kafka$controller$ControlMetadataBatchIntegrationTest$TestBroker$$$outer() {
            return this.$outer;
        }

        public TestBroker(ControlMetadataBatchIntegrationTest $outer, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.config = $outer.kafka$controller$ControlMetadataBatchIntegrationTest$$createConfig(brokerId);
            this.brokerInfo = $outer.kafka$controller$ControlMetadataBatchIntegrationTest$$createBrokerInfo(this.config());
            this.zkClient = None$.MODULE$;
        }
    }
}

