/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004?\u0001\u0001\u0007I\u0011A \t\r\u0015\u0003\u0001\u0015)\u0003<\u0011\u001d1\u0005A1A\u0005\u0002\u001dCaA\u0014\u0001!\u0002\u0013A\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007A\u0002\u0001\u000b\u0011B)\t\u000f\u0005\u0004!\u0019!C\u0001E\"1Q\u000e\u0001Q\u0001\n\rDqA\u001c\u0001C\u0002\u0013\u0005!\r\u0003\u0004p\u0001\u0001\u0006Ia\u0019\u0005\ba\u0002\u0011\r\u0011\"\u0001c\u0011\u0019\t\b\u0001)A\u0005G\")!\u000f\u0001C\u0001g\"1q\u0010\u0001C\u0005\u0003\u0003Aq!!\u0003\u0001\t\u0013\tY\u0001\u0003\u0004\u00022\u0001!\ta\u001d\u0005\u0007\u0003w\u0001A\u0011A:\t\r\u0005}\u0002\u0001\"\u0001t\u0011\u0019\t\u0019\u0005\u0001C\u0001g\"1\u0011q\t\u0001\u0005\u0002MDa!a\u0013\u0001\t\u0003\u0019\bBBA(\u0001\u0011\u00051\u000f\u0003\u0004\u0002T\u0001!\ta\u001d\u0005\u0007\u0003/\u0002A\u0011A:\t\r\u0005m\u0003\u0001\"\u0001t\u0011\u0019\ty\u0006\u0001C\u0001g\"1\u00111\r\u0001\u0005\u0002MDa!a\u001a\u0001\t\u0003\u0019\bBBA6\u0001\u0011\u00051\u000f\u0003\u0004\u0002p\u0001!\ta\u001d\u0005\u0007\u0003g\u0002A\u0011A:\t\r\u0005]\u0004\u0001\"\u0001t\u0011\u0019\tY\b\u0001C\u0001g\"1\u0011q\u0010\u0001\u0005\u0002MDa!a!\u0001\t\u0003\u0019\bBBAD\u0001\u0011\u00051\u000f\u0003\u0004\u0002\f\u0002!\ta\u001d\u0002\u0016\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$H+Z:u\u0015\tQ3&\u0001\u0006d_:$(o\u001c7mKJT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003%\nqaY8oi\u0016DH/F\u0001<!\tAD(\u0003\u0002>S\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002\u0017\r|g\u000e^3yi~#S-\u001d\u000b\u0003\u0001\u000e\u0003\"\u0001M!\n\u0005\t\u000b$\u0001B+oSRDq\u0001R\u0002\u0002\u0002\u0003\u00071(A\u0002yIE\n\u0001bY8oi\u0016DH\u000fI\u0001\u000fKb\u001cG.^:j_:\u001c\u0015m\u00195f+\u0005A\u0005CA%M\u001b\u0005Q%BA&,\u0003\u0019\u0019w.\\7p]&\u0011QJ\u0013\u0002\u0016%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c\u0015m\u00195f\u0003=)\u0007p\u00197vg&|gnQ1dQ\u0016\u0004\u0013a\u00022s_.,'o]\u000b\u0002#B\u0019!KW/\u000f\u0005MCfB\u0001+X\u001b\u0005)&B\u0001,.\u0003\u0019a$o\\8u}%\t!'\u0003\u0002Zc\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005\r\u0019V-\u001d\u0006\u00033F\u0002\"\u0001\r0\n\u0005}\u000b$aA%oi\u0006A!M]8lKJ\u001c\b%A\u0002uaF*\u0012a\u0019\t\u0003I.l\u0011!\u001a\u0006\u0003\u0017\u001aT!\u0001L4\u000b\u0005!L\u0017AB1qC\u000eDWMC\u0001k\u0003\ry'oZ\u0005\u0003Y\u0016\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0003uaF\u0002\u0013a\u0001;qe\u0005!A\u000f\u001d\u001a!\u0003\r!\boM\u0001\u0005iB\u001c\u0004%A\u0003tKR,\u0006\u000fF\u0001AQ\tyQ\u000f\u0005\u0002w{6\tqO\u0003\u0002ys\u0006\u0019\u0011\r]5\u000b\u0005i\\\u0018a\u00026va&$XM\u001d\u0006\u0003y&\fQA[;oSRL!A`<\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000bde\u0016\fG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\u0007\u0001\u000b\u0019\u0001C\u0004\u0002\u0006A\u0001\r!a\u0002\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002S5\u000e\fAcZ3oKJ\fG/\u001a\"s_.,'/\u00129pG\"\u001cH\u0003BA\u0007\u0003W\u0001\u0002\"a\u0004\u0002\u0016\u0005e\u0011QE\u0007\u0003\u0003#Q1!a\u00052\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\t\tBA\u0002NCB\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?Y\u0013aB2mkN$XM]\u0005\u0005\u0003G\tiB\u0001\u0004Ce>\\WM\u001d\t\u0004a\u0005\u001d\u0012bAA\u0015c\t!Aj\u001c8h\u0011\u001d\ti#\u0005a\u0001\u0003_\tqB\u0019:pW\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007n\u001d\t\b\u0003\u001f\t)\"XA\u0013\u0003\u0001#Xm\u001d;Va\u0012\fG/\u001a)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;P]2L\bf\u0001\n\u00026A\u0019a/a\u000e\n\u0007\u0005erO\u0001\u0003UKN$\u0018\u0001\u0011;fgR,\u0006\u000fZ1uKB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0007M\t)$A&uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oiJ+G/\u001e:og\u0016k\u0007\u000f^=TKFLe\rV8qS\u000e|%\u000fU1si&$\u0018n\u001c8E_\u0016\u001chj\u001c;Fq&\u001cH\u000fK\u0002\u0015\u0003k\ta\u000b^3tiB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$(+\u001a;ve:\u001cX)\u001c9us\u0006\u001b8/[4o[\u0016tG/\u00134U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007U\t)$\u0001%uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oi\u001a{'\u000fV8qS\u000e\u0014V\r^;s]N,U\u000e\u001d;z\u001b\u0006\u0004\u0018J\u001a+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\u001aa#!\u000e\u0002\u000fR,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$hi\u001c:U_BL7MU3ukJt7/\u0012=qK\u000e$X\r\u001a*fa2L7-Y!tg&<g.\\3oiND3aFA\u001b\u0003y!Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0019\u0003k\t\u0011\u0006^3tiJ+\u0017m]:jO:lWM\u001c;Ge>lwJY:feZ,'\u000fV8Ts:\u001c'+\u001a9mS\u000e\f\u0007fA\r\u00026\u0005AB/Z:u%\u0016lwN^1m\u001f\u001a\u001c\u0016P\\2SKBd\u0017nY1)\u0007i\t)$A\u000buKN$(+Z7pm\u0006dwJZ(cg\u0016\u0014h/\u001a:)\u0007m\t)$A\u001auKN$(+Z7pm\u0006dwJZ(cg\u0016\u0014h/\u001a:B]\u0012l\u0015m[3Ts:\u001c'+\u001a9mS\u000e\f\u0017J\u001c;p\u001f\n\u001cXM\u001d<fe\"\u001aA$!\u000e\u0002SQ,7\u000f\u001e*f[>4\u0018\r\\(g'ft7MU3qY&\u001c\u0017-\u00118e\u001f\n\u001cXM\u001d<fe\u000eC\u0017M\\4fQ\ri\u0012QG\u0001.i\u0016\u001cHOU3bgNLwM\\7f]R\u001cv/\u00199t\u001f\n\u001cXM\u001d<feN\fe\u000eZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001c\bf\u0001\u0010\u00026\u0005IB/Z:u%\u0016\f7o]5h]R{\u0017\nZ3na>$XM\\2fQ\ry\u0012QG\u0001\u000fi\u0016\u001cHOU3bgNLwM\u001c+pQ\r\u0001\u0013QG\u0001\"i\u0016\u001cHOU3n_ZLgn\u001a*fa2L7-\u0019+be\u001e,Go\u00142tKJ4XM\u001d\u0015\u0004C\u0005U\u0012a\t;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-S7cC2\fgnY3NKR\u0014\u0018n\u0019\u0015\u0004E\u0005U\u0012a\b;fgR\u0004&/\u001a4feJ,G\rT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]\"\u001a1%!\u000e\u0002KQ,7\u000f\u001e)sK\u001a,'O]3e\u0019\u0016\fG-\u001a:XSRDG)Z7pi\u0016$'I]8lKJ\u001c\bf\u0001\u0013\u00026\u0005\u0011C/Z:u!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u0019\u0016\fG-\u001a:t\u001f:\u0014%o\\6feND3!JA\u001b\u0003-\"Xm\u001d;QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5Qe\u00164WM\u001d:fI2+\u0017\rZ3sg>s'I]8lKJ\u001c\bf\u0001\u0014\u00026\u0005AB/Z:u'\u0016$H)Z7pi\u0016$'I]8lKJLeNZ8)\u0007\u001d\n)\u0004")
public class ControllerContextTest {
    private ControllerContext context = null;
    private final ReplicaExclusionCache exclusionCache = new ReplicaExclusionCache();
    private final scala.collection.immutable.Seq<Object> brokers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public scala.collection.immutable.Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @BeforeEach
    public void setUp() {
        this.context_$eq(new ControllerContext());
        Map<Broker, Object> brokerEpochs = this.generateBrokerEpochs((Map<Object, Object>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)1L))}))));
        this.context().setLiveBrokers(brokerEpochs);
        this.createTopicPartitions((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2(), this.tp3()}))));
    }

    private void createTopicPartitions(scala.collection.immutable.Seq<TopicPartition> partitions) {
        IntRef leaderIndex = IntRef.create((int)0);
        partitions.foreach((Function1 & Serializable)partition -> {
            ControllerContextTest.$anonfun$createTopicPartitions$1(this, leaderIndex, partition);
            return BoxedUnit.UNIT;
        });
    }

    private Map<Broker, Object> generateBrokerEpochs(Map<Object, Object> brokerAndEpochs) {
        return (Map)brokerAndEpochs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            long brokerEpoch = x0$1._2$mcJ$sp();
            EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)brokerEpoch));
            return tuple2;
        });
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnly() {
        scala.collection.immutable.Seq expectedReplicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)expectedReplicas, (Seq)package$.MODULE$.Seq().empty()));
        Seq assignment = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedReplicas, (Object)assignment);
        Assertions.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        scala.collection.immutable.Seq initialReplicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)initialReplicas, (Seq)package$.MODULE$.Seq().empty()));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assertions.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assertions.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.empty();
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        Map expectedAssignments = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assertions.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = new ReplicaAssignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5, 6})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        Assertions.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition.targetAssignment());
        ReplicaAssignment reassigningPartition2 = new ReplicaAssignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        Assertions.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition2.targetAssignment());
        ReplicaAssignment reassigningPartition3 = new ReplicaAssignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        Assertions.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition3.targetAssignment());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)package$.MODULE$.Seq().empty());
        Assertions.assertFalse((boolean)partition.isBeingReassigned());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)package$.MODULE$.Seq().empty()), (Object)partition.targetReplicaAssignment());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition4.targetAssignment());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition5.targetAssignment());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)package$.MODULE$.Seq().empty()), (Object)nonReassigningPartition.targetReplicaAssignment());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)nonReassigningPartition.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)nonReassigningPartition.removingReplicas());
        Assertions.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignmentFromObserverToSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserverAndMakeSyncReplicaIntoObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplicaAndObserverChange() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testReassignmentSwapsObserversAndSyncReplicas() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)reassignment.effectiveObservers());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignment.removingReplicas());
    }

    @Test
    public void testReassignToIdempotence() {
        ReplicaAssignment assignment1 = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty());
        Assertions.assertEquals((Object)assignment1, (Object)assignment1.reassignTo(new ReplicaAssignment.Assignment(assignment1.replicas(), assignment1.observers())));
        ReplicaAssignment assignment2 = new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Option)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)assignment2, (Object)assignment2.reassignTo((ReplicaAssignment.Assignment)assignment2.targetAssignment().get()));
        ReplicaAssignment assignment3 = new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 3, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Option)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)assignment3, (Object)assignment3.reassignTo((ReplicaAssignment.Assignment)assignment3.targetAssignment().get()));
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty());
        ReplicaAssignment firstReassign = assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty())), (Object)firstReassign);
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty())), (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().empty())));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty())), (Object)assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().empty())));
        Assertions.assertEquals((Object)assignment, (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty())));
    }

    @Test
    public void testRemovingReplicaTargetObserver() {
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))).removeReplica(3), (Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})))));
    }

    @Test
    public void testPreferredReplicaImbalanceMetric() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp3(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(3, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.tp3().topic()})));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().removeTopic(this.tp1().topic());
        this.context().removeTopic(this.tp2().topic());
        this.context().removeTopic(this.tp3().topic());
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    @Test
    public void testPreferredLeaderForPartition() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)2, (int)this.context().preferredLeaderForPartition(this.tp1()));
    }

    @Test
    public void testPreferredLeaderWithDemotedBrokers() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
        this.context().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.context().demotedBrokerIds());
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
    }

    @Test
    public void testPartitionsWithLeadersOnBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()})), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}))));
        String topic = "large topic";
        this.createTopicPartitions((scala.collection.immutable.Seq<TopicPartition>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> ControllerContextTest.$anonfun$testPartitionsWithLeadersOnBrokers$1(topic, BoxesRunTime.unboxToInt((Object)i))));
        Assertions.assertEquals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 33).map((Function1 & Serializable)i -> ControllerContextTest.$anonfun$testPartitionsWithLeadersOnBrokers$2(topic, BoxesRunTime.unboxToInt((Object)i))).toSet(), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
    }

    @Test
    public void testPartitionsWithPreferredLeadersOnBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithPreferredLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithPreferredLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
    }

    @Test
    public void testSetDemotedBrokerInfo() {
        this.context().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.context().demotedBrokerIds());
        this.context().setDemotedReasons(2, (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.context().demotedBrokerIds());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})), (Object)this.context().demotedReasons(1));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})), (Object)this.context().demotedReasons(2));
        this.context().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.empty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.context().demotedBrokerIds());
    }

    public static final /* synthetic */ void $anonfun$createTopicPartitions$1(ControllerContextTest $this, IntRef leaderIndex$1, TopicPartition partition) {
        IndexedSeq replicas = $this.brokers().indices().map((Function1)(JFunction1.mcII.sp & Serializable)i -> BoxesRunTime.unboxToInt((Object)$this.brokers().apply((i + leaderIndex$1.elem) % $this.brokers().size())));
        $this.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)package$.MODULE$.Seq().empty()));
        $this.context().putPartitionLeadershipInfo(partition, new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)replicas.head()), replicas.toList()), 0));
        ++leaderIndex$1.elem;
    }

    public static final /* synthetic */ TopicPartition $anonfun$testPartitionsWithLeadersOnBrokers$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testPartitionsWithLeadersOnBrokers$2(String topic$1, int i) {
        return new TopicPartition(topic$1, i * 3);
    }
}

