/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.AlterReplicaExclusionsResult;
import kafka.common.BrokerReplicaExclusion;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.DataBalanceManager;
import kafka.controller.KafkaController;
import kafka.controller.KafkaControllerTest$SuccessfulAlterLeadershipScenario$;
import kafka.controller.KafkaControllerTest$SuccessfulExclusionScenario$;
import kafka.server.BrokerFeatures;
import kafka.server.DelegationTokenManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\ree\u0001\u0002&L\u0001ACQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001C\u0002\u0013\u0005A\f\u0003\u0004k\u0001\u0001\u0006I!\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019A\b\u0001)A\u0005[\"9\u0011\u0010\u0001b\u0001\n\u0003Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\u0001\u0007I\u0011AA\u0001\u0011%\ty\u0001\u0001a\u0001\n\u0003\t\t\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\u0002\u0011%\ty\u0002\u0001a\u0001\n\u0003\t\t\u0003C\u0005\u00020\u0001\u0001\r\u0011\"\u0001\u00022!A\u0011Q\u0007\u0001!B\u0013\t\u0019\u0003C\u0005\u00028\u0001\u0001\r\u0011\"\u0001\u0002:!I\u0011Q\t\u0001A\u0002\u0013\u0005\u0011q\t\u0005\t\u0003\u0017\u0002\u0001\u0015)\u0003\u0002<!I\u0011Q\n\u0001A\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0001\u0019!C\u0001\u00033B\u0001\"!\u0018\u0001A\u0003&\u0011\u0011\u000b\u0005\n\u0003?\u0002\u0001\u0019!C\u0001\u0003CB\u0011\"!\u001b\u0001\u0001\u0004%\t!a\u001b\t\u0011\u0005=\u0004\u0001)Q\u0005\u0003GB\u0011\"!\u001d\u0001\u0001\u0004%\t!a\u001d\t\u0013\u0005e\u0005\u00011A\u0005\u0002\u0005m\u0005\u0002CAP\u0001\u0001\u0006K!!\u001e\t\u0013\u0005\u0005\u0006\u00011A\u0005\u0002\u0005\r\u0006\"CAV\u0001\u0001\u0007I\u0011AAW\u0011!\t\t\f\u0001Q!\n\u0005\u0015\u0006\"CAZ\u0001\u0001\u0007I\u0011AA[\u0011%\ti\f\u0001a\u0001\n\u0003\ty\f\u0003\u0005\u0002D\u0002\u0001\u000b\u0015BA\\\u0011%\t)\r\u0001a\u0001\n\u0003\t9\rC\u0005\u0002P\u0002\u0001\r\u0011\"\u0001\u0002R\"A\u0011Q\u001b\u0001!B\u0013\tI\rC\u0006\u0002X\u0002\u0001\r\u00111A\u0005\u0002\u0005e\u0007bCAq\u0001\u0001\u0007\t\u0019!C\u0001\u0003GD1\"a:\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\\\"I\u0011\u0011\u001e\u0001C\u0002\u0013\u0005\u00111\u001e\u0005\t\u0003g\u0004\u0001\u0015!\u0003\u0002n\"Y\u0011Q\u001f\u0001A\u0002\u0003\u0007I\u0011AA|\u0011-\u0011\u0019\u0001\u0001a\u0001\u0002\u0004%\tA!\u0002\t\u0017\t%\u0001\u00011A\u0001B\u0003&\u0011\u0011 \u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005\u001bAqAa\f\u0001\t\u0003\u0011i\u0001C\u0004\u0003:\u0001!\tA!\u0004\t\u000f\tu\u0002\u0001\"\u0001\u0003\u000e!9!\u0011\t\u0001\u0005\u0002\t5\u0001b\u0002B#\u0001\u0011\u0005!Q\u0002\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001bAqA!\u0015\u0001\t\u0003\u0011iaB\u0004\u0003V\u0001A\tAa\u0016\u0007\u000f\tm\u0003\u0001#\u0001\u0003^!1qK\u000eC\u0001\u0005?BqA!\u00197\t\u0003\u0011\u0019gB\u0004\u0003H\u0002A\tA!3\u0007\u000f\t-\u0007\u0001#\u0001\u0003N\"1qK\u000fC\u0001\u0005\u001fD\u0011B!5;\u0005\u0004%\tAa5\t\u0011\t\r(\b)A\u0005\u0005+DqA!:;\t\u0003\u0011i\u0001C\u0004\u0003hj\"\tA!;\t\u000f\r\u001d\u0001\u0001\"\u0001\u0003\u000e!911\u0002\u0001\u0005\n\r5\u0001bBB\u001e\u0001\u0011%1Q\b\u0005\b\u0007w\u0001A\u0011BB4\u0011\u001d\u0019y\u0007\u0001C\u0005\u0007c:qa! L\u0011\u0003\u0019yH\u0002\u0004K\u0017\"\u00051\u0011\u0011\u0005\u0007/\u001a#\taa!\t\u000f\r\u0015e\t\"\u0001\u0003\u000e!91q\u0012$\u0005\u0002\t5!aE&bM.\f7i\u001c8ue>dG.\u001a:UKN$(B\u0001'N\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u001d\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001R!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0017\t\u00035\u0002i\u0011aS\u0001\u0005i&lW-F\u0001^!\tq\u0006.D\u0001`\u0015\t\u0001\u0017-A\u0003vi&d7O\u0003\u0002cG\u000611m\\7n_:T!A\u00143\u000b\u0005\u00154\u0017AB1qC\u000eDWMC\u0001h\u0003\ry'oZ\u0005\u0003S~\u0013A\u0001V5nK\u0006)A/[7fA\u0005\u0019B/[3s)>\u0004\u0018nY'b]\u0006<WM](qiV\tQ\u000eE\u0002S]BL!a\\*\u0003\r=\u0003H/[8o!\t\th/D\u0001s\u0015\t\u0019H/A\u0003u_BL7M\u0003\u0002v\u001b\u0006!A/[3s\u0013\t9(O\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0006!B/[3s)>\u0004\u0018nY'b]\u0006<WM](qi\u0002\n!#\u001b8ji&\fGN\u0011:pW\u0016\u0014X\t]8dQV\t1\u0010\u0005\u0002Sy&\u0011Qp\u0015\u0002\u0005\u0019>tw-A\nj]&$\u0018.\u00197Ce>\\WM]#q_\u000eD\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013i\u0015AB:feZ,'/\u0003\u0003\u0002\u000e\u0005\u001d!aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007I\u000b)\"C\u0002\u0002\u0018M\u0013A!\u00168ji\"I\u00111D\u0005\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\tu.\u001cE.[3oiV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F'\u0002\u0005i\\\u0017\u0002BA\u0017\u0003O\u0011QbS1gW\u0006T6n\u00117jK:$\u0018\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fH\u0003BA\n\u0003gA\u0011\"a\u0007\r\u0003\u0003\u0005\r!a\t\u0002\u0013i\\7\t\\5f]R\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003w\u0001B!!\u0010\u0002B5\u0011\u0011q\b\u0006\u0004\u0003o\t\u0017\u0002BA\"\u0003\u007f\u0011q!T3ue&\u001c7/A\u0006nKR\u0014\u0018nY:`I\u0015\fH\u0003BA\n\u0003\u0013B\u0011\"a\u0007\u0010\u0003\u0003\u0005\r!a\u000f\u0002\u00115,GO]5dg\u0002\n\u0011#\u001b8ji&\fGN\u0011:pW\u0016\u0014\u0018J\u001c4p+\t\t\t\u0006\u0005\u0003\u0002&\u0005M\u0013\u0002BA+\u0003O\u0011!B\u0011:pW\u0016\u0014\u0018J\u001c4p\u0003UIg.\u001b;jC2\u0014%o\\6fe&sgm\\0%KF$B!a\u0005\u0002\\!I\u00111\u0004\n\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0013S:LG/[1m\u0005J|7.\u001a:J]\u001a|\u0007%\u0001\u0007u_.,g.T1oC\u001e,'/\u0006\u0002\u0002dA!\u0011QAA3\u0013\u0011\t9'a\u0002\u0003-\u0011+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJ\f\u0001\u0003^8lK:l\u0015M\\1hKJ|F%Z9\u0015\t\u0005M\u0011Q\u000e\u0005\n\u00037)\u0012\u0011!a\u0001\u0003G\nQ\u0002^8lK:l\u0015M\\1hKJ\u0004\u0013AE2mkN$XM\u001d'j].l\u0015M\\1hKJ,\"!!\u001e\u0011\t\u0005]\u00141\u0013\b\u0005\u0003s\niI\u0004\u0003\u0002|\u0005%e\u0002BA?\u0003\u000fsA!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007{\u0015A\u0002\u001fs_>$h(C\u0001O\u0013\r\tI!T\u0005\u0005\u0003\u0017\u000b9!\u0001\u0003mS:\\\u0017\u0002BAH\u0003#\u000b!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss*!\u00111RA\u0004\u0013\u0011\t)*a&\u0003\u00171Kgn['b]\u0006<WM\u001d\u0006\u0005\u0003\u001f\u000b\t*\u0001\fdYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\u0019\"!(\t\u0013\u0005m\u0001$!AA\u0002\u0005U\u0014aE2mkN$XM\u001d'j].l\u0015M\\1hKJ\u0004\u0013A\u00042s_.,'OR3biV\u0014Xm]\u000b\u0003\u0003K\u0003B!!\u0002\u0002(&!\u0011\u0011VA\u0004\u00059\u0011%o\\6fe\u001a+\u0017\r^;sKN\f!C\u0019:pW\u0016\u0014h)Z1ukJ,7o\u0018\u0013fcR!\u00111CAX\u0011%\tYbGA\u0001\u0002\u0004\t)+A\bce>\\WM\u001d$fCR,(/Z:!\u000311W-\u0019;ve\u0016\u001c\u0015m\u00195f+\t\t9\f\u0005\u0003\u0002\u0006\u0005e\u0016\u0002BA^\u0003\u000f\u0011QCR5oC2L'0\u001a3GK\u0006$XO]3DC\u000eDW-\u0001\tgK\u0006$XO]3DC\u000eDWm\u0018\u0013fcR!\u00111CAa\u0011%\tYBHA\u0001\u0002\u0004\t9,A\u0007gK\u0006$XO]3DC\u000eDW\rI\u0001\u0010W\u000647.Y\"p]R\u0014x\u000e\u001c7feV\u0011\u0011\u0011\u001a\t\u00045\u0006-\u0017bAAg\u0017\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\nlC\u001a\\\u0017mQ8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005M\u0007\"CA\u000eC\u0005\u0005\t\u0019AAe\u0003AY\u0017MZ6b\u0007>tGO]8mY\u0016\u0014\b%A\ncC2\fgnY3s\u001b\u0006t\u0017mZ3s\u001b>\u001c7.\u0006\u0002\u0002\\B\u0019!,!8\n\u0007\u0005}7J\u0001\nECR\f')\u00197b]\u000e,W*\u00198bO\u0016\u0014\u0018a\u00062bY\u0006t7-\u001a:NC:\fw-\u001a:N_\u000e\\w\fJ3r)\u0011\t\u0019\"!:\t\u0013\u0005mA%!AA\u0002\u0005m\u0017\u0001\u00062bY\u0006t7-\u001a:NC:\fw-\u001a:N_\u000e\\\u0007%\u0001\bfa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8\u0016\u0005\u00055\bc\u0001*\u0002p&\u0019\u0011\u0011_*\u0003\u0007%sG/A\bfa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8!\u00039)\u0007p\u00197vg&|gnQ1dQ\u0016,\"!!?\u0011\t\u0005m\u0018q`\u0007\u0003\u0003{T!AY'\n\t\t\u0005\u0011Q \u0002\u0016%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c\u0015m\u00195f\u0003I)\u0007p\u00197vg&|gnQ1dQ\u0016|F%Z9\u0015\t\u0005M!q\u0001\u0005\n\u00037I\u0013\u0011!a\u0001\u0003s\fq\"\u001a=dYV\u001c\u0018n\u001c8DC\u000eDW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003'A3a\u000bB\t!\u0011\u0011\u0019B!\t\u000e\u0005\tU!\u0002\u0002B\f\u00053\t1!\u00199j\u0015\u0011\u0011YB!\b\u0002\u000f),\b/\u001b;fe*\u0019!q\u00044\u0002\u000b),h.\u001b;\n\t\t\r\"Q\u0003\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u00071\u0012I\u0003\u0005\u0003\u0003\u0014\t-\u0012\u0002\u0002B\u0017\u0005+\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002%R,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:D_6\u0004H.\u001a;fg\u000e\u000bG\u000e\u001c2bG.<\u0016\u000e\u001e5V].twn\u001e8TKJ4XM]#yG\u0016\u0004H/[8o\u001f:T6*\u0012=dKB$\u0018n\u001c8)\u00075\u0012\u0019\u0004\u0005\u0003\u0003\u0014\tU\u0012\u0002\u0002B\u001c\u0005+\u0011A\u0001V3ti\u0006\u0011E/Z:u\u00032$XM\u001d*fa2L7-Y#yG2,8/[8ogJ+G/\u001e:og&sg/\u00197jI\u0016C8\r\\;tS>twJ\\+oQ\u0006tG\r\\3e\u001fB$\u0016\u0010]3)\u00079\u0012\u0019$\u0001\u000euKN$\u0018\t\u001c;feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t7\u000fK\u00020\u0005g\t1\b^3ti\u0006cG/\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N$u.Z:oiB+'o]5ti>sG)\u001e9mS\u000e\fG/Z#yG2,8/[8oQ\r\u0001$1G\u0001Bi\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn],pe.\u001c\u0018J\u001a#bi\u0006\u0014\u0015\r\\1oG\u0016\u0014H\u000b\u001b:poN|eNT8uS\u001aL7-\u0019;j_:D3!\rB\u001a\u0003\u0005\u001aH/\u0019:u\u0007>tGO]8mY\u0016\u0014x+\u001b;i\u0003\u0012+Wn\u001c;fI\n\u0013xn[3s)\t\ti/A\u000euKN$\u0018\t\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f\u0015\u0004g\tM\u0012a\f;fgR\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u00180\u00134ECR\f'-\u00197b]\u000e,'\u000f\u00165s_^\u001c\bf\u0001\u001b\u00034\u0005\t3+^2dKN\u001ch-\u001e7BYR,'\u000fT3bI\u0016\u00148\u000f[5q'\u000e,g.\u0019:j_B\u0019!\u0011\f\u001c\u000e\u0003\u0001\u0011\u0011eU;dG\u0016\u001c8OZ;m\u00032$XM\u001d'fC\u0012,'o\u001d5jaN\u001bWM\\1sS>\u001c\"AN)\u0015\u0005\t]\u0013a\b<fe&4\u0017\u0010T3bI\u0016\u00148\u000f[5q!JLwN]5usJ+7/\u001e7ugR1\u00111\u0003B3\u0005GCqAa\u001a9\u0001\u0004\u0011I'A\rmK\u0006$WM]:iSB\u0004&/[8sSRL(+Z:vYR\u001c\b\u0003\u0002*o\u0005W\u0002bA!\u001c\u0003x\tud\u0002\u0002B8\u0005grA!a \u0003r%\tA+C\u0002\u0003vM\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003z\tm$\u0001\u0002'jgRT1A!\u001eT!\u0011\u0011yH!(\u000f\t\t\u0005%q\u0013\b\u0005\u0005\u0007\u0013\u0019J\u0004\u0003\u0003\u0006\nEe\u0002\u0002BD\u0005\u001fsAA!#\u0003\u000e:!\u0011q\u0010BF\u0013\u00059\u0017BA3g\u0013\tqE-\u0003\u0002cG&\u0019!QS1\u0002\u000f5,7o]1hK&!!\u0011\u0014BN\u0003\r\nE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018PU3ta>t7/\u001a#bi\u0006T1A!&b\u0013\u0011\u0011yJ!)\u0003=\t\u0013xn[3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018PU3tk2$(\u0002\u0002BM\u00057CqA!*9\u0001\u0004\u00119+\u0001\teK6|G/\u001a3Ce>\\WM]%egB1!\u0011\u0016BY\u0005osAAa+\u0003.B\u0019\u0011qP*\n\u0007\t=6+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005g\u0013)LA\u0002TKRT1Aa,T!\u0011\u0011ILa1\u000e\u0005\tm&\u0002\u0002B_\u0005\u007f\u000bA\u0001\\1oO*\u0011!\u0011Y\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003F\nm&aB%oi\u0016<WM]\u0001\u001c'V\u001c7-Z:tMVdW\t_2mkNLwN\\*dK:\f'/[8\u0011\u0007\te#HA\u000eTk\u000e\u001cWm]:gk2,\u0005p\u00197vg&|gnU2f]\u0006\u0014\u0018n\\\n\u0003uE#\"A!3\u0002\u0019\u0015D8\r\\;tS>tw\n]:\u0016\u0005\tU\u0007C\u0002BU\u0005c\u00139\u000e\u0005\u0003\u0003Z\n}WB\u0001Bn\u0015\r\u0011'Q\u001c\u0006\u0004\u0003\u0013\u0019\u0017\u0002\u0002Bq\u00057\u0014q#\u00117uKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u00149\u0002\u001b\u0015D8\r\\;tS>tw\n]:!\u0003\u0011!Xm\u001d;\u0002C\u0005\u001c8/\u001a:u'V\u001c7-Z:tMVdW\t_2mkNLwN\\\"bY2\u0014\u0017mY6\u0015\t\u0005M!1\u001e\u0005\b\u0005[|\u0004\u0019\u0001Bx\u0003\u0019\u0011Xm];miBA!Q\u000eBy\u0005k\u001c\t!\u0003\u0003\u0003t\nm$AB#ji\",'\u000f\u0005\u0003\u0003x\nuXB\u0001B}\u0015\r\u0011Y0Y\u0001\te\u0016\fX/Z:ug&!!q B}\u0005!\t\u0005/[#se>\u0014\b\u0003BA~\u0007\u0007IAa!\u0002\u0002~\na\u0012\t\u001c;feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t7OU3tk2$\u0018\u0001\u0007;fgR\fE.\u001b<f\u0005J|7.\u001a:t':\f\u0007o\u001d5pi\"\u001a\u0001Ia\r\u0002?\u0005\u001c8/\u001a:u'V\u001c7-Z:tMVdW\t_2mkNLwN\u001c*fgVdG\u000f\u0006\u0005\u0002\u0014\r=11DB\u0010\u0011\u001d\u0019\t\"\u0011a\u0001\u0007'\tqB]3dK&4X\r\u001a*fgVdGo\u001d\t\u0007\u0005S\u0013\tl!\u0006\u0011\t\te7qC\u0005\u0005\u00073\u0011YN\u0001\u000fCe>\\WM\u001d*fa2L7-Y#yG2,8/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\ru\u0011\t1\u0001\u0002n\u0006\u0001R\r\u001f9fGR,GM\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0007C\t\u0005\u0019AB\u0012\u00039)\u0007\u0010]3di\u0016$w\n\u001d+za\u0016\u0004Ba!\n\u000469!1qEB\u0019\u001b\t\u0019IC\u0003\u0003\u0004,\r5\u0012!B1e[&t'bAB\u0018G\u000691\r\\5f]R\u001c\u0018\u0002BB\u001a\u0007S\t1\"\u0012=dYV\u001c\u0018n\u001c8Pa&!1qGB\u001d\u0005\u0019y\u0005\u000fV=qK*!11GB\u0015\u0003E1XM]5gs6+GO]5d-\u0006dW/\u001a\u000b\t\u0003'\u0019yd!\u0017\u0004d!91\u0011\t\"A\u0002\r\r\u0013aD7fiJL7m\u001d*fO&\u001cHO]=\u0011\t\r\u00153QK\u0007\u0003\u0007\u000fRAa!\u0013\u0004L\u0005!1m\u001c:f\u0015\u0011\t9d!\u0014\u000b\t\r=3\u0011K\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\rM\u0013aA2p[&!1qKB$\u0005=iU\r\u001e:jGN\u0014VmZ5tiJL\bbBB.\u0005\u0002\u00071QL\u0001\u0011[\u0016$(/[2TS6\u0004H.\u001a(b[\u0016\u0004BA!+\u0004`%!1\u0011\rB[\u0005\u0019\u0019FO]5oO\"91Q\r\"A\u0002\t]\u0016!D3ya\u0016\u001cG/\u001a3WC2,X\r\u0006\u0005\u0002\u0014\r%41NB7\u0011\u001d\u0019\te\u0011a\u0001\u0007\u0007Bqaa\u0017D\u0001\u0004\u0019i\u0006C\u0004\u0004f\r\u0003\ra!\u0018\u0002\r5,GO]5d)\u0019\u0019\u0019h!\u001f\u0004|A!1QIB;\u0013\u0011\u00199ha\u0012\u0003\r5+GO]5d\u0011\u001d\u0019\t\u0005\u0012a\u0001\u0007\u0007Bqaa\u0017E\u0001\u0004\u0019i&A\nLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s)\u0016\u001cH\u000f\u0005\u0002[\rN\u0011a)\u0015\u000b\u0003\u0007\u007f\n!b]3u+B\u001cE.Y:tQ\rA5\u0011\u0012\t\u0005\u0005'\u0019Y)\u0003\u0003\u0004\u000e\nU!!\u0003\"fM>\u0014X-\u00117m\u00035!X-\u0019:E_^t7\t\\1tg\"\u001a\u0011ja%\u0011\t\tM1QS\u0005\u0005\u0007/\u0013)B\u0001\u0005BMR,'/\u00117m\u0001")
public class KafkaControllerTest {
    private volatile KafkaControllerTest$SuccessfulAlterLeadershipScenario$ SuccessfulAlterLeadershipScenario$module;
    private volatile KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario$module;
    private final Time time = new MockTime();
    private final Option<TierTopicManager> tierTopicManagerOpt = None$.MODULE$;
    private final long initialBrokerEpoch;
    private KafkaConfig config = null;
    private KafkaZkClient zkClient = null;
    private Metrics metrics = null;
    private BrokerInfo initialBrokerInfo = null;
    private DelegationTokenManager tokenManager = null;
    private ClusterLinkFactory.LinkManager clusterLinkManager = null;
    private BrokerFeatures brokerFeatures = null;
    private FinalizedFeatureCache featureCache = null;
    private KafkaController kafkaController = null;
    private DataBalanceManager balancerManagerMock;
    private final int epochZkVersion;
    private ReplicaExclusionCache exclusionCache;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public KafkaControllerTest$SuccessfulAlterLeadershipScenario$ SuccessfulAlterLeadershipScenario() {
        if (this.SuccessfulAlterLeadershipScenario$module == null) {
            this.SuccessfulAlterLeadershipScenario$lzycompute$1();
        }
        return this.SuccessfulAlterLeadershipScenario$module;
    }

    public KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario() {
        if (this.SuccessfulExclusionScenario$module == null) {
            this.SuccessfulExclusionScenario$lzycompute$1();
        }
        return this.SuccessfulExclusionScenario$module;
    }

    public Time time() {
        return this.time;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public long initialBrokerEpoch() {
        return this.initialBrokerEpoch;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void initialBrokerInfo_$eq(BrokerInfo x$1) {
        this.initialBrokerInfo = x$1;
    }

    public DelegationTokenManager tokenManager() {
        return this.tokenManager;
    }

    public void tokenManager_$eq(DelegationTokenManager x$1) {
        this.tokenManager = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    public BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    public void brokerFeatures_$eq(BrokerFeatures x$1) {
        this.brokerFeatures = x$1;
    }

    public FinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    public void featureCache_$eq(FinalizedFeatureCache x$1) {
        this.featureCache = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public DataBalanceManager balancerManagerMock() {
        return this.balancerManagerMock;
    }

    public void balancerManagerMock_$eq(DataBalanceManager x$1) {
        this.balancerManagerMock = x$1;
    }

    public int epochZkVersion() {
        return this.epochZkVersion;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public void exclusionCache_$eq(ReplicaExclusionCache x$1) {
        this.exclusionCache = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        boolean bl = true;
        this.config_$eq(new KafkaConfig((java.util.Map)props, bl));
        this.zkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.metrics_$eq(new Metrics());
        this.initialBrokerInfo_$eq((BrokerInfo)Mockito.mock(BrokerInfo.class));
        this.tokenManager_$eq((DelegationTokenManager)Mockito.mock(DelegationTokenManager.class));
        this.clusterLinkManager_$eq((ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
        this.brokerFeatures_$eq((BrokerFeatures)Mockito.mock(BrokerFeatures.class));
        this.featureCache_$eq((FinalizedFeatureCache)Mockito.mock(FinalizedFeatureCache.class));
        this.balancerManagerMock_$eq((DataBalanceManager)Mockito.mock(DataBalanceManager.class));
        this.exclusionCache_$eq(new ReplicaExclusionCache());
        TestUtils$.MODULE$.clearYammerMetrics();
        KafkaYammerMetrics.defaultRegistry().shutdown();
        this.kafkaController_$eq(new KafkaController(this.config(), this.zkClient(), this.time(), this.metrics(), this.initialBrokerInfo(), this.initialBrokerEpoch(), this.tokenManager(), this.tierTopicManagerOpt(), this.clusterLinkManager(), this.brokerFeatures(), this.featureCache(), this.exclusionCache(), (Option)None$.MODULE$));
        this.kafkaController().dataBalancer_$eq(this.balancerManagerMock());
    }

    @AfterEach
    public void tearDown() {
        if (this.kafkaController().eventManager().thread().isRunning()) {
            this.kafkaController().shutdown();
        }
    }

    @Test
    public void testAlterReplicaExclusionsCompletesCallbackWithUnknownServerExceptionOnZKException() {
        AlterReplicaExclusionOp exclusionOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.SET);
        this.zkClient().setOrCreateReplicaExclusions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(exclusionOp.brokerId(), exclusionOp.reason())})), this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.APIERROR, (String)"replica_exclusions");
        });
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{exclusionOp})), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$1(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusionsReturnsInvalidExclusionOnUnhandledOpType() {
        AlterReplicaExclusionOp unknownOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.UNKNOWN);
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{unknownOp})), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$2(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusions() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusions$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(1, "maintenance")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusions$3(x$4);
            return BoxedUnit.UNIT;
        });
        this.SuccessfulExclusionScenario().test();
    }

    @Test
    public void testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(2, "delete")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(x$5);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set exclusionOps = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{new AlterReplicaExclusionOp(1, "", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(2, "excluded", ExclusionOp.OpType.SET)}));
        this.kafkaController().alterBrokerReplicaExclusions((Set)exclusionOps, (Function1 & Serializable)result -> {
            this.callback$3(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        ((ClusterBalanceManager)Mockito.verify((Object)this.balancerManagerMock(), (VerificationMode)Mockito.never())).onAlteredExclusions(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{1}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{2}))).asJava());
    }

    @Test
    public void testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.balancerManagerMock().onAlteredExclusions((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
            throw new Exception("test!");
        });
        this.SuccessfulExclusionScenario().test();
    }

    /*
     * WARNING - void declaration
     */
    public int startControllerWithADemotedBroker() {
        void var1_1;
        int demotedBrokerId = 1;
        this.kafkaController().controllerContext().setDemotedReasons(demotedBrokerId, (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"demoted broker for test"})));
        this.kafkaController().startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$startControllerWithADemotedBroker$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Map expectedLeadershipPriorityInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)demotedBrokerId)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"demoted for test"})))}));
        this.zkClient().setLeadershipPriorityState(expectedLeadershipPriorityInfo);
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$7 -> {
            KafkaControllerTest.$anonfun$startControllerWithADemotedBroker$3(x$7);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(demotedBrokerId));
        return (int)var1_1;
    }

    @Test
    public void testAlterLeadershipPriority() {
        int initiallyDemotedBrokerId = this.startControllerWithADemotedBroker();
        ObjectRef leadershipPriorityResults = ObjectRef.create((Object)None$.MODULE$);
        int demotedBrokerId = 2;
        this.kafkaController().alterLeadershipPriority("demotion test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{demotedBrokerId})), true, (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, leadershipPriorityResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterLeadershipScenario().verifyLeadershipPriorityResults((Option<List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>>)((Option)leadershipPriorityResults.elem), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDemotedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerId)}))));
    }

    @Test
    public void testAlterLeadershipPriorityIfDatabalancerThrows() {
        int initiallyDemotedBrokerId = this.startControllerWithADemotedBroker();
        ObjectRef leadershipPriorityResults = ObjectRef.create((Object)None$.MODULE$);
        this.balancerManagerMock().onBrokerLeadershipPriorityChange((AliveBrokersMetadata)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$8 -> {
            throw new Exception("test!");
        });
        int demotedBrokerId = 2;
        this.kafkaController().alterLeadershipPriority("demotion test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{demotedBrokerId})), true, (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$5(result, leadershipPriorityResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterLeadershipScenario().verifyLeadershipPriorityResults((Option<List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>>)((Option)leadershipPriorityResults.elem), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDemotedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerId)}))));
    }

    @Test
    public void testAliveBrokersSnapshot() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{(EndPoint)Mockito.mock(EndPoint.class)})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{(EndPoint)Mockito.mock(EndPoint.class)})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{(EndPoint)Mockito.mock(EndPoint.class)})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.exclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"reason")}))).asJava());
        this.kafkaController().controllerContext().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"demoted broker for test"})));
        Assertions.assertEquals((Object)new AliveBrokersSnapshot(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)3L))}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)2)}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava()), (Object)this.kafkaController().aliveBrokersSnapshot());
    }

    public void kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult(scala.collection.immutable.Set<BrokerReplicaExclusionResult> receivedResults, int expectedBrokerId, ExclusionOp.OpType expectedOpType) {
        Option findOpt = receivedResults.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KafkaControllerTest.$anonfun$assertSuccessfulExclusionResult$1(expectedBrokerId, p)));
        Assertions.assertFalse((boolean)findOpt.isEmpty(), (String)new StringBuilder(34).append("Could not find broker ").append(expectedBrokerId).append(" in results ").append(receivedResults).toString());
        BrokerReplicaExclusionResult exclusion = (BrokerReplicaExclusionResult)findOpt.get();
        Assertions.assertEquals((int)expectedBrokerId, (int)exclusion.brokerId());
        Assertions.assertEquals((Object)expectedOpType, (Object)exclusion.opType());
        Assertions.assertTrue((!exclusion.apiErrorOptional().isPresent() ? 1 : 0) != 0, (String)new StringBuilder(51).append("Expected exclusion for broker ").append(expectedBrokerId).append(" to not have an error").toString());
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, Integer expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$1(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$2(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, String expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$3(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$4(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
    }

    private Metric metric(MetricsRegistry metricsRegistry, String metricSimpleName) {
        java.util.Map metrics = metricsRegistry.allMetrics();
        MetricName metricName = metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).findFirst().get();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).count());
        Assertions.assertEquals((Object)"kafka.controller", (Object)metricName.getGroup());
        return (Metric)metrics.get(metricName);
    }

    private final void SuccessfulAlterLeadershipScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulAlterLeadershipScenario$module == null) {
                this.SuccessfulAlterLeadershipScenario$module = new KafkaControllerTest$SuccessfulAlterLeadershipScenario$(this);
            }
            return;
        }
    }

    private final void SuccessfulExclusionScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulExclusionScenario$module == null) {
                this.SuccessfulExclusionScenario$module = new KafkaControllerTest$SuccessfulExclusionScenario$(this);
            }
            return;
        }
    }

    private static final void callback$1(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)error.error());
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected an error while processing exclusions");
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$2(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertFalse((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to not be successful");
            Assertions.assertEquals((int)1, (int)result2.brokerReplicaExclusionResults().size());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.INVALID_REPLICA_EXCLUSION})), (Object)((IterableOps)((IterableOps)result2.brokerReplicaExclusionResults().map((Function1 & Serializable)r -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.apiErrorOptional())))).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.isDefined()))).map((Function1 & Serializable)e -> ((ApiError)e.get()).error()));
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusions$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusions$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusions$3(InvocationOnMock x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(InvocationOnMock x$5) {
    }

    private final void callback$3(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertTrue((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to be successful");
            Assertions.assertEquals((int)2, (int)result2.brokerReplicaExclusionResults().size());
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 1, ExclusionOp.OpType.DELETE);
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 2, ExclusionOp.OpType.SET);
            java.util.Map exclusions = this.kafkaController().replicaExclusionCache().exclusions();
            Assertions.assertEquals((int)1, (int)exclusions.size());
            Assertions.assertTrue((boolean)exclusions.containsKey(BoxesRunTime.boxToInteger((int)1)), (String)"Expected exclusion for broker 1 to be present");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ boolean $anonfun$startControllerWithADemotedBroker$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$startControllerWithADemotedBroker$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$startControllerWithADemotedBroker$3(InvocationOnMock x$7) {
    }

    private static final void callback$4(Either result, ObjectRef leadershipPriorityResults$1) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            leadershipPriorityResults$1.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$5(Either result, ObjectRef leadershipPriorityResults$2) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            leadershipPriorityResults$2.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulExclusionResult$1(int expectedBrokerId$1, BrokerReplicaExclusionResult p) {
        return p.brokerId() == expectedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$1(KafkaControllerTest $this, MetricsRegistry metricsRegistry$1, String metricSimpleName$1, AtomicReference lastSeenValue$1, Integer expectedValue$1) {
        Integer value = (Integer)((Gauge)$this.metric(metricsRegistry$1, metricSimpleName$1)).value();
        lastSeenValue$1.set(value);
        Integer n = expectedValue$1;
        return !(n != null ? !((Object)n).equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$2(String metricSimpleName$1, Integer expectedValue$1, AtomicReference lastSeenValue$1) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$1).append(" to be ").append(expectedValue$1).append(" but instead was ").append(lastSeenValue$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$3(KafkaControllerTest $this, MetricsRegistry metricsRegistry$2, String metricSimpleName$2, AtomicReference lastSeenValue$2, String expectedValue$2) {
        String value = (String)((Gauge)$this.metric(metricsRegistry$2, metricSimpleName$2)).value();
        lastSeenValue$2.set(value);
        String string = expectedValue$2;
        return !(string != null ? !string.equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$4(String metricSimpleName$2, String expectedValue$2, AtomicReference lastSeenValue$2) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$2).append(" to be ").append(expectedValue$2).append(" but instead was ").append(lastSeenValue$2.get()).toString();
    }

    public KafkaControllerTest() {
        this.initialBrokerEpoch = 0L;
        this.epochZkVersion = 0;
    }
}

