/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.Unhealthy$;
import kafka.controller.ControllerChannelManager;
import kafka.controller.UnhealthyBroker;
import kafka.server.BaseRequestTest;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EB\u0011\"\n\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013a\u0002\u0001\u0019!a\u0001\n\u0003I\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011%\u0019\u0005\u00011AA\u0002\u0013\u0005A\tC\u0005I\u0001\u0001\u0007\t\u0019!C\u0001\u0013\"I1\n\u0001a\u0001\u0002\u0003\u0006K!\u0012\u0005\n[\u0001\u0001\r\u00111A\u0005\u0002QB\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011A'\t\u0013=\u0003\u0001\u0019!A!B\u0013)\u0004\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u00015\u0011%\t\u0006\u00011AA\u0002\u0013\u0005!\u000bC\u0005U\u0001\u0001\u0007\t\u0011)Q\u0005k!IQ\u000b\u0001a\u0001\u0002\u0004%\tA\u0016\u0005\n5\u0002\u0001\r\u00111A\u0005\u0002mC\u0011\"\u0018\u0001A\u0002\u0003\u0005\u000b\u0015B,\t\u0013y\u0003\u0001\u0019!a\u0001\n\u00031\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0001a\u0011%\u0011\u0007\u00011A\u0001B\u0003&q\u000bC\u0005d\u0001\u0001\u0007\t\u0019!C\u0001-\"IA\r\u0001a\u0001\u0002\u0004%\t!\u001a\u0005\nO\u0002\u0001\r\u0011!Q!\n]Cq\u0001\u001b\u0001A\u0002\u0013\u0005\u0011\u000eC\u0004s\u0001\u0001\u0007I\u0011A:\t\rU\u0004\u0001\u0015)\u0003k\u0011\u001d1\b\u00011A\u0005\u0002%Dqa\u001e\u0001A\u0002\u0013\u0005\u0001\u0010\u0003\u0004{\u0001\u0001\u0006KA\u001b\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u0010\u0001\t\u0003\t)\u0004C\u0004\u0002J\u0001!\t!!\u000e\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\t1SK\u001c5fC2$\b.\u001f\"s_.,'o\u00155vi\u0012|wO\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\u00152\u0013AC2p]R\u0014x\u000e\u001c7fe*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#BA\u0017'\u0003\u0019\u0019XM\u001d<fe&\u0011q\u0006\f\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011\u0001J\u000b\u0002kA\u00111FN\u0005\u0003o1\u00121bS1gW\u0006\u001cVM\u001d<fe\u0006q1m\u001c8ue>dG.\u001a:`I\u0015\fHC\u0001\u001eA!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0011)f.\u001b;\t\u000f\u0005\u001b\u0011\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#A#\u0011\u0005M2\u0015BA$%\u0005a\u0019uN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u001dG>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014x\fJ3r)\tQ$\nC\u0004B\r\u0005\u0005\t\u0019A#\u00023\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHC\u0001\u001eO\u0011\u001d\t\u0015\"!AA\u0002U\nqa]3sm\u0016\u0014\b%A\u0004tKJ4XM\u001d\u001a\u0002\u0017M,'O^3se}#S-\u001d\u000b\u0003uMCq!\u0011\u0007\u0002\u0002\u0003\u0007Q'\u0001\u0005tKJ4XM\u001d\u001a!\u0003!\u0019XM\u001d<fe&#W#A,\u0011\u0005mB\u0016BA-=\u0005\rIe\u000e^\u0001\rg\u0016\u0014h/\u001a:JI~#S-\u001d\u000b\u0003uqCq!Q\b\u0002\u0002\u0003\u0007q+A\u0005tKJ4XM]%eA\u0005I1/\u001a:wKJLEMM\u0001\u000eg\u0016\u0014h/\u001a:JIJzF%Z9\u0015\u0005i\n\u0007bB!\u0013\u0003\u0003\u0005\raV\u0001\u000bg\u0016\u0014h/\u001a:JIJ\u0002\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0017\u0001E2p]R\u0014x\u000e\u001c7fe&#w\fJ3r)\tQd\rC\u0004B+\u0005\u0005\t\u0019A,\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0003)\u0011\u0018mY6TiJLgnZ\u000b\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0005Y\u0006twMC\u0001p\u0003\u0011Q\u0017M^1\n\u0005Ed'AB*ue&tw-\u0001\bsC\u000e\\7\u000b\u001e:j]\u001e|F%Z9\u0015\u0005i\"\bbB!\u0019\u0003\u0003\u0005\rA[\u0001\fe\u0006\u001c7n\u0015;sS:<\u0007%A\u0006sC\u000e\\7\u000b\u001e:j]\u001e\u0014\u0014a\u0004:bG.\u001cFO]5oOJzF%Z9\u0015\u0005iJ\bbB!\u001c\u0003\u0003\u0005\rA[\u0001\re\u0006\u001c7n\u0015;sS:<'\u0007I\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"AO?\t\u000byl\u0002\u0019A@\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)A\\\u0001\u0005kRLG.\u0003\u0003\u0002\n\u0005\r!A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\u0019!(a\u0004\t\u000f\u0005Ea\u00041\u0001\u0002\u0014\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\u0016\u0005\u001dRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u001e\u0005}\u0011a\u00026va&$XM\u001d\u0006\u0005\u0003C\t\u0019#A\u0003kk:LGO\u0003\u0002\u0002&\u0005\u0019qN]4\n\t\u0005%\u0012q\u0003\u0002\t)\u0016\u001cH/\u00138g_\"\u001aa$!\f\u0011\t\u0005U\u0011qF\u0005\u0005\u0003c\t9B\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002u!\u001aq$!\u000f\u0011\t\u0005U\u00111H\u0005\u0005\u0003{\t9BA\u0005BMR,'/R1dQ\u0006QD/Z:u+:DW-\u00197uQf\u0014%o\\6feNCW\u000f\u001e3po:lU\r\u001e:jGJ+7m\u001c:egVs\u0007.Z1mi\"L8\u000b[;uI><hn\u001d\u0015\u0004A\u0005\r\u0003\u0003BA\u000b\u0003\u000bJA!a\u0012\u0002\u0018\t!A+Z:u\u0003U\"Xm\u001d;V]\",\u0017\r\u001c;is\n\u0013xn[3s'\",H\u000fZ8x]6+GO]5d!>\u0004X\u000f\\1uKN\fe\u000e\u001a)feNL7\u000f^:)\u0007\u0005\n\u0019%A\rdQ\u0016\u001c7.\u00168iK\u0006dG\u000f[=Ce>\\WM\u001d,bYV,G#\u0003\u001e\u0002R\u0005m\u0013qLA<\u0011\u001d\t\u0019F\ta\u0001\u0003+\n\u0001\"\\1q-\u0006dW/\u001a\t\u0004g\u0005]\u0013bAA-I\tyQK\u001c5fC2$\b.\u001f\"s_.,'\u000f\u0003\u0004\u0002^\t\u0002\raV\u0001\u0011Kb\u0004Xm\u0019;fI\n\u0013xn[3s\u0013\u0012Dq!!\u0019#\u0001\u0004\t\u0019'\u0001\bfqB,7\r^3e%\u0006\u001c7.\u00133\u0011\t\u0005\u0015\u00141\u000f\b\u0005\u0003O\ny\u0007E\u0002\u0002jqj!!a\u001b\u000b\u0007\u00055\u0004&\u0001\u0004=e>|GOP\u0005\u0004\u0003cb\u0014A\u0002)sK\u0012,g-C\u0002r\u0003kR1!!\u001d=\u0011\u0019\tIH\ta\u0001/\u0006)R\r\u001f9fGR,Gm\u00155vi\u0012|wO\\\"pk:$\b")
public class UnhealthyBrokerShutdownIntegrationTest
extends BaseRequestTest {
    private KafkaServer controller;
    private ControllerChannelManager controllerChannelManager;
    private KafkaServer server;
    private KafkaServer server2;
    private int serverId;
    private int serverId2;
    private int controllerId;
    private String rackString = "";
    private String rackString2 = "";

    public KafkaServer controller() {
        return this.controller;
    }

    public void controller_$eq(KafkaServer x$1) {
        this.controller = x$1;
    }

    public ControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public void controllerChannelManager_$eq(ControllerChannelManager x$1) {
        this.controllerChannelManager = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public int serverId() {
        return this.serverId;
    }

    public void serverId_$eq(int x$1) {
        this.serverId = x$1;
    }

    public int serverId2() {
        return this.serverId2;
    }

    public void serverId2_$eq(int x$1) {
        this.serverId2 = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public void controllerId_$eq(int x$1) {
        this.controllerId = x$1;
    }

    public String rackString() {
        return this.rackString;
    }

    public void rackString_$eq(String x$1) {
        this.rackString = x$1;
    }

    public String rackString2() {
        return this.rackString2;
    }

    public void rackString2_$eq(String x$1) {
        this.rackString2 = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        void var5_5;
        void var4_4;
        SeqOps seqOps;
        block3: {
            List list;
            block2: {
                super.setUp(testInfo);
                this.controller_$eq(this.getController());
                this.controllerId_$eq(this.controller().config().brokerId());
                this.controllerChannelManager_$eq(this.controller().kafkaController().controllerChannelManager());
                list = ((IterableOnceOps)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UnhealthyBrokerShutdownIntegrationTest.$anonfun$setUp$1(this, s)))).take(2)).toList();
                if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list))) break block2;
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) break block3;
            }
            throw new MatchError((Object)list);
        }
        KafkaServer first = (KafkaServer)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        KafkaServer second = (KafkaServer)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        this.server_$eq((KafkaServer)var4_4);
        this.serverId_$eq(this.server().config().brokerId());
        this.rackString_$eq((String)this.server().config().rack().getOrElse((Function0 & Serializable)() -> ""));
        this.server2_$eq((KafkaServer)var5_5);
        this.serverId2_$eq(this.server2().config().brokerId());
        this.rackString2_$eq((String)this.server().config().rack().getOrElse((Function0 & Serializable)() -> ""));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.server().shutdown();
        this.server2().shutdown();
        this.controller().shutdown();
        this.server().awaitShutdown();
        this.server2().awaitShutdown();
        this.controller().awaitShutdown();
        super.tearDown();
    }

    @Test
    public void testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns() {
        VolatileBooleanRef hasCalledExit = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(x$9, x$10) -> UnhealthyBrokerShutdownIntegrationTest.$anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$1(hasCalledExit, BoxesRunTime.unboxToInt((Object)x$9), x$10);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var6_2 = null;
        UnhealthyBroker unhealthyBrokerValue = (UnhealthyBroker)this.controllerChannelManager().unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)this.serverId()));
        UnhealthyBroker unhealthyBrokerValue2 = (UnhealthyBroker)this.controllerChannelManager().unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)this.serverId2()));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "0");
        this.server2().dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        try {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!UnhealthyBrokerShutdownIntegrationTest.$anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$3(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Broker is still Healthy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!UnhealthyBrokerShutdownIntegrationTest.$anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$5(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"Broker is not undergoing controlled shutdown");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            long l5 = 15000L;
            long l6 = 100L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!hasCalledExit.elem) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                    Assertions.fail((String)"Exit wasn't triggered");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue2, this.serverId2(), this.rackString2(), 1);
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue, this.serverId(), this.rackString(), 0);
        this.server2().shutdown();
        long l = 15000L;
        long l7 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UnhealthyBrokerShutdownIntegrationTest.$anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$9(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for broker to shutdown");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l7));
        }
        this.server2().startup();
        long l8 = 15000L;
        long l9 = 100L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!UnhealthyBrokerShutdownIntegrationTest.$anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$11(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + l8) {
                Assertions.fail((String)"Timed out waiting for broker to start running");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l8), l9));
        }
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue2, this.serverId2(), this.rackString2(), 1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnhealthyBrokerShutdownMetricPopulatesAndPersists() {
        KafkaServer kafkaServer;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer2;
        Time time;
        None$ none$;
        None$ none$2;
        None$ none$3;
        Assertions.assertTrue((boolean)this.controllerChannelManager().unhealthyBrokerMap().contains((Object)BoxesRunTime.boxToInteger((int)this.serverId())));
        Assertions.assertTrue((boolean)this.controllerChannelManager().unhealthyBrokerMap().contains((Object)BoxesRunTime.boxToInteger((int)this.serverId2())));
        Assertions.assertTrue((boolean)this.controllerChannelManager().unhealthyBrokerMap().contains((Object)BoxesRunTime.boxToInteger((int)this.controllerId())));
        Assertions.assertFalse((boolean)this.controllerChannelManager().unhealthyBrokerMap().contains((Object)BoxesRunTime.boxToInteger((int)3)));
        UnhealthyBroker unhealthyBrokerValue = (UnhealthyBroker)this.controllerChannelManager().unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)this.serverId()));
        UnhealthyBroker unhealthyBrokerValue2 = (UnhealthyBroker)this.controllerChannelManager().unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)this.serverId2()));
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue, this.serverId(), this.rackString(), 0);
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue2, this.serverId2(), this.rackString2(), 0);
        this.server().shutdown();
        this.server().awaitShutdown();
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue, this.serverId(), this.rackString(), 0);
        String newRackId = "5";
        int x$1 = this.serverId();
        String x$2 = this.zkConnect();
        Option x$3 = Option$.MODULE$.apply((Object)newRackId);
        boolean bl = true;
        boolean bl2 = true;
        int n = TestUtils$.MODULE$.RandomPort();
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n4 = TestUtils$.MODULE$.RandomPort();
        int n5 = 1;
        boolean bl7 = false;
        int n6 = 1;
        short s = 1;
        Properties newConfigProp = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, bl, bl2, n, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, bl3, bl4, n2, bl5, n3, bl6, n4, (Option<String>)x$3, n5, bl7, n6, s);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(newConfigProp);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        KafkaServer kafkaServer3 = kafkaServer2 = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        Object var21_32 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer4 = kafkaServer = kafkaServer3;
        Object var18_31 = null;
        kafkaConfig = null;
        time3 = null;
        kafkaServer = null;
        KafkaServer newServer = kafkaServer4;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UnhealthyBrokerShutdownIntegrationTest.$anonfun$testUnhealthyBrokerShutdownMetricPopulatesAndPersists$1(newServer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for broker to start running");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.checkUnhealthyBrokerValue(unhealthyBrokerValue, this.serverId(), newRackId, 0);
        newServer.shutdown();
        newServer.awaitShutdown();
    }

    public void checkUnhealthyBrokerValue(UnhealthyBroker mapValue, int expectedBrokerId, String expectedRackId, int expectedShutdownCount) {
        Assertions.assertEquals((long)expectedShutdownCount, (long)mapValue.meter().count());
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(expectedBrokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack-id"), (Object)expectedRackId)})), (Object)mapValue.shutdownTag());
    }

    public static final /* synthetic */ boolean $anonfun$setUp$1(UnhealthyBrokerShutdownIntegrationTest $this, KafkaServer s) {
        return s.config().brokerId() != $this.controller().config().brokerId();
    }

    public static final /* synthetic */ Nothing$ $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$1(VolatileBooleanRef hasCalledExit$1, int x$9, Option x$10) {
        hasCalledExit$1.elem = true;
        throw new Exception();
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$3(UnhealthyBrokerShutdownIntegrationTest $this) {
        BrokerHealthStatus brokerHealthStatus = $this.server2().brokerHealthManager().brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(unhealthy$);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$4() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$5(UnhealthyBrokerShutdownIntegrationTest $this) {
        BrokerState brokerState = $this.server2().brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$6() {
        return "Broker is not undergoing controlled shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$7(VolatileBooleanRef hasCalledExit$1) {
        return hasCalledExit$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$8() {
        return "Exit wasn't triggered";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$9(UnhealthyBrokerShutdownIntegrationTest $this) {
        BrokerState brokerState = $this.server2().brokerState();
        BrokerState brokerState2 = BrokerState.NOT_RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$10() {
        return "Timed out waiting for broker to shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$11(UnhealthyBrokerShutdownIntegrationTest $this) {
        BrokerState brokerState = $this.server2().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownMetricRecordsUnhealthyShutdowns$12() {
        return "Timed out waiting for broker to start running";
    }

    public static final /* synthetic */ boolean $anonfun$testUnhealthyBrokerShutdownMetricPopulatesAndPersists$1(KafkaServer newServer$1) {
        BrokerState brokerState = newServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testUnhealthyBrokerShutdownMetricPopulatesAndPersists$2() {
        return "Timed out waiting for broker to start running";
    }

    public UnhealthyBrokerShutdownIntegrationTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "true");
    }
}

