/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\u00180\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\u0002-C\u0011B\u0015\u0001A\u0002\u0003\u0007I\u0011A*\t\u0013e\u0003\u0001\u0019!A!B\u0013a\u0005\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0001\\\u0011%y\u0006\u00011AA\u0002\u0013\u0005\u0001\rC\u0005c\u0001\u0001\u0007\t\u0011)Q\u00059\"I1\r\u0001a\u0001\u0002\u0004%\t\u0001\u001a\u0005\ne\u0002\u0001\r\u00111A\u0005\u0002MD\u0011\"\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B3\t\u0013Y\u0004\u0001\u0019!a\u0001\n\u00039\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013A!\"!\u0004\u0001\u0001\u0004\u0005\t\u0015)\u0003y\u0011-\ty\u0001\u0001a\u0001\u0002\u0004%\t!!\u0005\t\u0017\u0005e\u0001\u00011AA\u0002\u0013\u0005\u00111\u0004\u0005\f\u0003?\u0001\u0001\u0019!A!B\u0013\t\u0019\u0002C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\u0002\u0005\r\u0002bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0001\u0003[A1\"!\r\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002&!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!I\u0011q\b\u0001C\u0002\u0013\u0005\u0011\u0011\t\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002D!I\u00111\n\u0001C\u0002\u0013\u0005\u0011\u0011\t\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002D!I\u0011q\n\u0001C\u0002\u0013\u0005\u0011\u0011\u000b\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002T!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011\u0011\u000b\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002T!I\u0011q\u000e\u0001C\u0002\u0013\u0005\u0011\u0011\u000b\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002T!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBAG\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003/\u0003A\u0011AA;\u0011\u001d\tY\n\u0001C\u0001\u0003kBq!a(\u0001\t\u0003\t)\bC\u0004\u0002$\u0002!\t!!\u001e\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002v!9\u00111\u0016\u0001\u0005\u0002\u0005U\u0004bBAX\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!!9\u0001\t\u0013\t\u0019O\u0001\u000bRk>$\u0018mQ8pe\u0012Lg.\u0019;peR+7\u000f\u001e\u0006\u0003aE\nQ!];pi\u0006T!AM\u001a\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011C\u0001\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011aL\u0001\u0007G>tg-[4\u0016\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S!AR\u001a\u0002\rM,'O^3s\u0013\tAUIA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005i&lW-F\u0001M!\ti\u0005+D\u0001O\u0015\ty5'A\u0003vi&d7/\u0003\u0002R\u001d\nAQj\\2l)&lW-\u0001\u0005uS6,w\fJ3r)\t!v\u000b\u0005\u00029+&\u0011a+\u000f\u0002\u0005+:LG\u000fC\u0004Y\u000b\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0013'A\u0003uS6,\u0007%A\u0005tG\",G-\u001e7feV\tA\f\u0005\u0002N;&\u0011aL\u0014\u0002\u000e\u001b>\u001c7nU2iK\u0012,H.\u001a:\u0002\u001bM\u001c\u0007.\u001a3vY\u0016\u0014x\fJ3r)\t!\u0016\rC\u0004Y\u0011\u0005\u0005\t\u0019\u0001/\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u000bj]R,'O\\1m\u0003\u0012l\u0017N\\*vaBd\u0017.\u001a:\u0016\u0003\u0015\u00042AZ7p\u001b\u00059'B\u00015j\u0003!1WO\\2uS>t'B\u00016l\u0003\u0011)H/\u001b7\u000b\u00031\fAA[1wC&\u0011an\u001a\u0002\t'V\u0004\b\u000f\\5feB\u0011A\t]\u0005\u0003c\u0016\u0013Q\"\u00138uKJt\u0017\r\\!e[&t\u0017!G5oi\u0016\u0014h.\u00197BI6LgnU;qa2LWM]0%KF$\"\u0001\u0016;\t\u000fa[\u0011\u0011!a\u0001K\u00061\u0012N\u001c;fe:\fG.\u00113nS:\u001cV\u000f\u001d9mS\u0016\u0014\b%A\rdYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\W#\u0001=\u0011\u0007e\f\u0019!D\u0001{\u0015\t\u00014P\u0003\u0002Gy*\u0011A' \u0006\u0003}~\fa!\u00199bG\",'BAA\u0001\u0003\ry'oZ\u0005\u0004\u0003\u000bQ(!G\"mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.\fQd\u00197vgR,'\u000fT3wK2\fVo\u001c;b\u0007\u0006dGNY1dW~#S-\u001d\u000b\u0004)\u0006-\u0001b\u0002-\u000f\u0003\u0003\u0005\r\u0001_\u0001\u001bG2,8\u000f^3s\u0019\u00164X\r\\)v_R\f7)\u00197mE\u0006\u001c7\u000eI\u0001\u0012cV|G/Y*uCR,W*\u00198bO\u0016\u0014XCAA\n!\r\u0001\u0015QC\u0005\u0004\u0003/y#!E)v_R\f7\u000b^1uK6\u000bg.Y4fe\u0006)\u0012/^8uCN#\u0018\r^3NC:\fw-\u001a:`I\u0015\fHc\u0001+\u0002\u001e!A\u0001,EA\u0001\u0002\u0004\t\u0019\"\u0001\nrk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013\u0001E9v_R\f7i\\8sI&t\u0017\r^8s+\t\t)\u0003E\u0002A\u0003OI1!!\u000b0\u0005A\tVo\u001c;b\u0007>|'\u000fZ5oCR|'/\u0001\u000brk>$\u0018mQ8pe\u0012Lg.\u0019;pe~#S-\u001d\u000b\u0004)\u0006=\u0002\u0002\u0003-\u0015\u0003\u0003\u0005\r!!\n\u0002#E,x\u000e^1D_>\u0014H-\u001b8bi>\u0014\b%\u0001\fdYV\u001cH/\u001a:UQJ|Wo\u001a5qkR\fVo\u001c;b+\t\t9\u0004E\u00029\u0003sI1!a\u000f:\u0005\u0019!u.\u001e2mK\u000692\r\\;ti\u0016\u0014H\u000b\u001b:pk\u001eD\u0007/\u001e;Rk>$\u0018\rI\u0001\bK:$\u0018\u000e^=2+\t\t\u0019\u0005E\u0002A\u0003\u000bJ1!a\u00120\u0005-\tVo\u001c;b\u000b:$\u0018\u000e^=\u0002\u0011\u0015tG/\u001b;zc\u0001\nq!\u001a8uSRL('\u0001\u0005f]RLG/\u001f\u001a!\u0003e)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM\u001d\u0019\u0016\u0005\u0005M\u0003CBA+\u0003?\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%IW.\\;uC\ndWMC\u0002\u0002^e\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0016\u0003\u0007M+\u0017\u000fE\u0002A\u0003KJ1!a\u001a0\u0005i\tVo\u001c;b\u000b:$\u0018\u000e^=B]\u0012\u001cuN\\:v[B$\u0018n\u001c8t\u0003i)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM\u001d\u0019!\u0003e)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM]\u0019\u00025\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'/\r\u0011\u00023\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'OM\u0001\u001bK:$\u0018\u000e^=D_:\u001cX/\u001c9uS>t7O\u0011:pW\u0016\u0014(\u0007I\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002)\"\u001a!%!\u001f\u0011\t\u0005m\u0014\u0011R\u0007\u0003\u0003{RA!a \u0002\u0002\u0006\u0019\u0011\r]5\u000b\t\u0005\r\u0015QQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9i`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0017\u000biH\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0005^3ti\u000e{W\u000e];uKF+x\u000e^1t\u0013:\f7\r^5wK\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004G\u0005E\u0005\u0003BA>\u0003'KA!!&\u0002~\t!A+Z:u\u0003\u0015\"Xm\u001d;D_6\u0004X\u000f^3Rk>$\u0018m]%om\u0006d\u0017\u000eZ)v_R\fWI\u001c;ji&,7\u000fK\u0002%\u0003#\u000bQ\u0005^3ti\u0012+7o\u0019:jE\u0016\fVo\u001c;bg&s\u0017m\u0019;jm\u0016\u001cun\u001c:eS:\fGo\u001c:)\u0007\u0015\n\t*\u0001\u0013uKN$H)Z:de&\u0014W-U;pi\u0006\u001cXI\u001c;jif$u.Z:O_R,\u00050[:uQ\r1\u0013\u0011S\u0001\u001di\u0016\u001cHoQ8naV$X-\u00118e\t\u0016\u001c8M]5cKF+x\u000e^1tQ\r9\u0013\u0011S\u0001*i\u0016\u001cHoQ8naV$X-\u00118e\t\u0016\u001c8M]5cKF+x\u000e^1t/\",g\u000e\u00165s_R$H.\u001a3)\u0007!\n\t*\u0001\u000euKN$X\t\u001f9je\u0016\fVo\u001c;b\u0007>t7/^7qi&|g\u000eK\u0002*\u0003#\u000ba\u0003^3ti\u0006cGNW3s_\u000e{gn];naRLwN\u001c\u0015\u0004U\u0005E\u0015!F2p[B,H/Z)v_R\f7oQ1mY\n\f7m\u001b\u000b\u0004)\u0006]\u0006bBA]W\u0001\u0007\u00111X\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007\u0001\u000bi,C\u0002\u0002@>\u0012\u0011CU3q_J$\u0018+^8uCJ+7/\u001e7u\u0003-1XM]5gsF+x\u000e^1\u0015\u0013Q\u000b)-a4\u0002T\u0006u\u0007bBAdY\u0001\u0007\u0011\u0011Z\u0001\u0007EJ|7.\u001a:\u0011\u0007a\nY-C\u0002\u0002Nf\u00121!\u00138u\u0011\u001d\t\t\u000e\fa\u0001\u0003\u0007\n1\"];pi\u0006,e\u000e^5us\"9\u0011Q\u001b\u0017A\u0002\u0005]\u0017!C9v_R\fG+\u001f9f!\rI\u0018\u0011\\\u0005\u0004\u00037T(aD\"mS\u0016tG/U;pi\u0006$\u0016\u0010]3\t\u000f\u0005}G\u00061\u0001\u00028\u0005iQ\r\u001f9fGR,G-U;pi\u0006\f\u0011dZ3u#V|G/Y\"p_J$\u0017N\\1u_J\u001cuN\u001c4jOR!\u0011Q]Av!\r\u0001\u0015q]\u0005\u0004\u0003S|#AF)v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\t\u000b\u0005k\u0003\u0019A\"")
public class QuotaCoordinatorTest {
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
    private MockTime time;
    private MockScheduler scheduler;
    private Supplier<InternalAdmin> internalAdminSupplier;
    private ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private QuotaStateManager quotaStateManager;
    private QuotaCoordinator quotaCoordinator;
    private final double clusterThroughputQuota;
    private final QuotaEntity entity1 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
    private final QuotaEntity entity2 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant2")})));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaEntityAndConsumptions[]{new QuotaEntityAndConsumptions(this.entity1(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaConsumption[]{new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false)}))), new QuotaEntityAndConsumptions(this.entity2(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaConsumption[]{new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false)})))}));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaEntityAndConsumptions[]{new QuotaEntityAndConsumptions(this.entity1(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaConsumption[]{new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 400.0, false)}))), new QuotaEntityAndConsumptions(this.entity2(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaConsumption[]{new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 300.0, false)})))}));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaEntityAndConsumptions[]{new QuotaEntityAndConsumptions(this.entity1(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaConsumption[]{new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 5000.0, true)})))}));

    public KafkaConfig config() {
        return this.config;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(MockScheduler x$1) {
        this.scheduler = x$1;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public void internalAdminSupplier_$eq(Supplier<InternalAdmin> x$1) {
        this.internalAdminSupplier = x$1;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public void clusterLevelQuotaCallback_$eq(ClusterLevelQuotaCallback x$1) {
        this.clusterLevelQuotaCallback = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public double clusterThroughputQuota() {
        return this.clusterThroughputQuota;
    }

    public QuotaEntity entity1() {
        return this.entity1;
    }

    public QuotaEntity entity2() {
        return this.entity2;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0() {
        return this.entityConsumptionsBroker0;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1() {
        return this.entityConsumptionsBroker1;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2() {
        return this.entityConsumptionsBroker2;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq(new MockTime());
        this.scheduler_$eq(new MockScheduler((Time)this.time()));
        InternalAdmin internalAdmin = (InternalAdmin)EasyMock.createNiceMock(InternalAdmin.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)EasyMock.eq((Object)"_confluent-quotas"), EasyMock.anyInt(), EasyMock.anyShort(), (Properties)EasyMock.anyObject(Properties.class)))).andReturn((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.config().confluentConfig().quotasTopicPartitions()))).anyTimes();
        this.internalAdminSupplier_$eq(() -> internalAdmin);
        this.clusterLevelQuotaCallback_$eq((ClusterLevelQuotaCallback)EasyMock.createNiceMock(ClusterLevelQuotaCallback.class));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().clusterQuotaLimit((ClientQuotaType)EasyMock.anyObject(ClientQuotaType.class), (java.util.Map)EasyMock.anyObject(java.util.Map.class))).andReturn((Object)Predef$.MODULE$.double2Double(this.clusterThroughputQuota())).anyTimes();
        QuotaCoordinatorConfig quotaCoordinatorConfig = this.getQuotaCoordinatorConfig(this.config());
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getMagic((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)((byte)2)))).anyTimes();
        this.quotaStateManager_$eq(new QuotaStateManager(quotaCoordinatorConfig, (Scheduler)this.scheduler(), replicaManager, new Metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> 50, (Function0)(JFunction0.mcV.sp & Serializable)() -> {});
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity2()));
        EasyMock.replay((Object[])new Object[]{internalAdmin, this.clusterLevelQuotaCallback(), replicaManager});
        this.quotaCoordinator_$eq(new QuotaCoordinator(quotaCoordinatorConfig, this.quotaStateManager(), (Scheduler)this.scheduler(), this.internalAdminSupplier(), this.clusterLevelQuotaCallback(), (Time)this.time()));
    }

    @Test
    public void testComputeQuotasInactiveCoordinator() {
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.callback$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testComputeQuotasInvalidQuotaEntities() {
        this.quotaStateManager().removeOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addLoadingPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.callback$2(result);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasInactiveCoordinator() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var2_2, (Object)Errors.COORDINATOR_NOT_AVAILABLE, (String)new StringBuilder(24).append("Got error ").append(var2_2).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)var3_3, (String)new StringBuilder(32).append("Got non-empty quota description ").append(var3_3).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasEntityDoesNotExist() {
        void var3_3;
        void var2_2;
        this.quotaCoordinator().isActive().set(true);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var2_2, (Object)Errors.QUOTA_ENTITY_NOT_FOUND, (String)new StringBuilder(24).append("Got error ").append(var2_2).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)var3_3, (String)new StringBuilder(32).append("Got non-empty quota description ").append(var3_3).toString());
    }

    @Test
    public void testComputeAndDescribeQuotas() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 12000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 12000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 2400.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 3000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 9600.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 9000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
    }

    @Test
    public void testComputeAndDescribeQuotasWhenThrottled() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 12000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 2400.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 9600.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(2, this.entityConsumptionsBroker2(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 800.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 11000.0);
    }

    @Test
    public void testExpireQuotaConsumption() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, this.entityConsumptionsBroker2(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 800.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 11000.0);
        this.time().sleep(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3));
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 200.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 800.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 11000.0);
        this.time().sleep(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3));
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 2400.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 9600.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
    }

    @Test
    public void testAllZeroConsumption() {
        this.quotaCoordinator().isActive().set(true);
        scala.collection.immutable.Seq zeroConsumption = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaEntityAndConsumptions[]{new QuotaEntityAndConsumptions(this.entity1(), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaConsumption[]{new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 0.0, false)})))}));
        this.quotaCoordinator().computeQuotas(0, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
    }

    private void computeQuotasCallback(ReportQuotaResult result) {
        result.entityErrors().foreach((Function1 & Serializable)x0$1 -> {
            QuotaCoordinatorTest.$anonfun$computeQuotasCallback$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyQuota(int broker, QuotaEntity quotaEntity, ClientQuotaType quotaType, double expectedQuota) {
        void var7_6;
        void var8_7;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        double computedQuota = BoxesRunTime.unboxToDouble((Object)((MapOps)var8_7.brokerQuotas().getOrElse((Object)BoxesRunTime.boxToInteger((int)broker), (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).getOrElse((Object)quotaType.toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)var7_6, (String)new StringBuilder(40).append("Got error ").append(var7_6).append(" when describing quota entity ").append(quotaEntity).toString());
        Assertions.assertEquals((double)expectedQuota, (double)computedQuota, (String)new StringBuilder(53).append("Got quota ").append(computedQuota).append(" on broker ").append(broker).append(" for quota entity ").append(quotaEntity).append(" but expected ").append(expectedQuota).toString());
    }

    private QuotaCoordinatorConfig getQuotaCoordinatorConfig(KafkaConfig config) {
        return new QuotaCoordinatorConfig(Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions()), Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize()), config.confluentConfig().quotasTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs()), config.confluentConfig().quotasTopicPlacementConstraints(), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasConsumptionExpirationTimeMs()));
    }

    public static final /* synthetic */ void $anonfun$testComputeQuotasInactiveCoordinator$1(ReportQuotaResult result$1, QuotaEntityAndConsumptions entityAndConsumption) {
        Option option = result$1.entityErrors().get((Object)entityAndConsumption.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)error, (String)new StringBuilder(42).append("Got error ").append(error).append(" for quota entity ").append(entityAndConsumption.entity()).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(36).append("Did not get status for quota entity ").append(entityAndConsumption.entity()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void callback$1(ReportQuotaResult result) {
        this.entityConsumptionsBroker0().foreach((Function1 & Serializable)entityAndConsumption -> {
            QuotaCoordinatorTest.$anonfun$testComputeQuotasInactiveCoordinator$1(result, entityAndConsumption);
            return BoxedUnit.UNIT;
        });
    }

    private final void callback$2(ReportQuotaResult result) {
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)result.entityErrors().apply((Object)this.entity1()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity1())).append(" but expected ").append(Errors.COORDINATOR_LOAD_IN_PROGRESS).toString());
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)result.entityErrors().apply((Object)this.entity2()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity2())).append(" but expected ").append(Errors.NOT_COORDINATOR).toString());
    }

    public static final /* synthetic */ void $anonfun$computeQuotasCallback$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            QuotaEntity quotaEntity = (QuotaEntity)x0$1._1();
            Errors error = (Errors)x0$1._2();
            Assertions.assertEquals((Object)Errors.NONE, (Object)error, (String)new StringBuilder(49).append("Got error ").append(error).append(" when reporting usage for quota entity ").append(quotaEntity).toString());
            return;
        }
        throw new MatchError(null);
    }

    public QuotaCoordinatorTest() {
        this.clusterThroughputQuota = 12000.0;
    }
}

