/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.quota.QuotaStateManagerTest$;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.MergedLog$;
import kafka.message.CompressionCodec;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tug\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0001U\u0011\u0019Q\u0006\u0001)A\u0005+\"91\f\u0001b\u0001\n\u0003a\u0006B\u00029\u0001A\u0003%Q\fC\u0004r\u0001\t\u0007I\u0011\u0001:\t\rm\u0004\u0001\u0015!\u0003t\u0011\u001da\bA1A\u0005\u0002uDaa \u0001!\u0002\u0013q\b\u0002CA\u0001\u0001\t\u0007I\u0011\u0001:\t\u000f\u0005\r\u0001\u0001)A\u0005g\"A!\t\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0004\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\f\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\t\u0017\u0005U\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0007\u0005\f\u0003\u0007\u0002\u0001\u0019!A!B\u0013\tI\u0003C\u0006\u0002F\u0001\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0003bCA+\u0001\u0001\u0007\t\u0019!C\u0001\u0003/B1\"a\u0017\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002J!Y\u0011Q\f\u0001A\u0002\u0003\u0007I\u0011AA0\u0011-\t9\u0007\u0001a\u0001\u0002\u0004%\t!!\u001b\t\u0017\u00055\u0004\u00011A\u0001B\u0003&\u0011\u0011\r\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0003\t\t\bC\u0006\u0002z\u0001\u0001\r\u00111A\u0005\u0002\u0005m\u0004bCA@\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gB1\"!!\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0004\"Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011AAJ\u0011-\t9\n\u0001a\u0001\u0002\u0003\u0006K!!\"\t\u0017\u0005e\u0005\u00011AA\u0002\u0013\u0005\u00111\u0014\u0005\f\u0003O\u0003\u0001\u0019!a\u0001\n\u0003\tI\u000bC\u0006\u0002.\u0002\u0001\r\u0011!Q!\n\u0005u\u0005bCAX\u0001\u0001\u0007\t\u0019!C\u0001\u0003cC1\"a4\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002R\"Y\u0011Q\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAZ\u0011-\t9\u000e\u0001a\u0001\u0002\u0004%\t!!7\t\u0017\u0005\u0005\b\u00011AA\u0002\u0013\u0005\u00111\u001d\u0005\f\u0003O\u0004\u0001\u0019!A!B\u0013\tY\u000eC\u0005\u0002j\u0002\u0001\r\u0011\"\u0001\u0002l\"I!q\u0001\u0001A\u0002\u0013\u0005!\u0011\u0002\u0005\t\u0005\u001b\u0001\u0001\u0015)\u0003\u0002n\"Y!q\u0002\u0001A\u0002\u0003\u0007I\u0011\u0001B\t\u0011-\u0011Y\u0002\u0001a\u0001\u0002\u0004%\tA!\b\t\u0017\t\u0005\u0002\u00011A\u0001B\u0003&!1\u0003\u0005\n\u0005G\u0001!\u0019!C\u0005\u0005KA\u0001B!\f\u0001A\u0003%!q\u0005\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005cAqAa\u0015\u0001\t\u0003\u0011\t\u0004C\u0004\u0003^\u0001!\tA!\r\t\u000f\t\u0005\u0004\u0001\"\u0001\u00032!9!Q\r\u0001\u0005\u0002\tE\u0002b\u0002B5\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005[\u0002A\u0011\u0001B\u0019\u0011\u001d\u0011\t\b\u0001C\u0005\u0005gBqA!\u001d\u0001\t\u0013\u0011\u0019\nC\u0004\u0003$\u0002!IA!*\t\u000f\tU\u0006\u0001\"\u0003\u00038\n)\u0012+^8uCN#\u0018\r^3NC:\fw-\u001a:UKN$(B\u0001\"D\u0003\u0015\tXo\u001c;b\u0015\t!U)A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u0001$\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0006C\u0001*\u0001\u001b\u0005\t\u0015a\u00058v[F+x\u000e^1t!\u0006\u0014H/\u001b;j_:\u001cX#A+\u0011\u0005)3\u0016BA,L\u0005\rIe\u000e^\u0001\u0015]Vl\u0017+^8uCN\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002)E,x\u000e^1U_BL7\rU1si&$\u0018n\u001c8t+\u0005i\u0006c\u00010dK6\tqL\u0003\u0002aC\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003E.\u000b!bY8mY\u0016\u001cG/[8o\u0013\t!wLA\u0002TKF\u0004\"A\u001a8\u000e\u0003\u001dT!\u0001[5\u0002\r\r|W.\\8o\u0015\t1%N\u0003\u0002lY\u00061\u0011\r]1dQ\u0016T\u0011!\\\u0001\u0004_J<\u0017BA8h\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ#];pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0006f]RLG/\u001f+za\u0016,\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019\u0019FO]5oO\u0006YQM\u001c;jif$\u0016\u0010]3!\u0003-)g\u000e^5us:\u000bW.Z:\u0016\u0003y\u00042AX2t\u00031)g\u000e^5us:\u000bW.Z:!\u0003%\tXo\u001c;b)f\u0004X-\u0001\u0006rk>$\u0018\rV=qK\u0002*\"!a\u0002\u0011\u0007)\u000bI!C\u0002\u0002\f-\u0013a\u0001R8vE2,\u0017AB9v_R\f\u0007%A\u0003vg\u0006<W-\u0001\u0004vg\u0006<W\rI\u0001\nY><7i\u001c8gS\u001e,\"!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\bF\u0003\rawnZ\u0005\u0005\u0003C\tYBA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002\tQLW.Z\u000b\u0003\u0003S\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_)\u0015!B;uS2\u001c\u0018\u0002BA\u001a\u0003[\u0011\u0001\"T8dWRKW.Z\u0001\ti&lWm\u0018\u0013fcR!\u0011\u0011HA !\rQ\u00151H\u0005\u0004\u0003{Y%\u0001B+oSRD\u0011\"!\u0011\u0016\u0003\u0003\u0005\r!!\u000b\u0002\u0007a$\u0013'A\u0003uS6,\u0007%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=S)\u0001\u0004tKJ4XM]\u0005\u0005\u0003'\niE\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003s\tI\u0006C\u0005\u0002Ba\t\t\u00111\u0001\u0002J\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"!!\u0019\u0011\t\u0005e\u00111M\u0005\u0005\u0003K\nYB\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005-\u0004\"CA!7\u0005\u0005\t\u0019AA1\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002#E,x\u000e^1Ti\u0006$X-T1oC\u001e,'/\u0006\u0002\u0002tA\u0019!+!\u001e\n\u0007\u0005]\u0014IA\tRk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ\fQ#];pi\u0006\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005u\u0004\"CA!=\u0005\u0005\t\u0019AA:\u0003I\tXo\u001c;b'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAF\u000b\u000691\r\\;ti\u0016\u0014\u0018\u0002BAH\u0003\u0013\u0013\u0011\u0002U1si&$\u0018n\u001c8\u0002\u001bA\f'\u000f^5uS>tw\fJ3r)\u0011\tI$!&\t\u0013\u0005\u0005\u0013%!AA\u0002\u0005\u0015\u0015A\u00039beRLG/[8oA\u00059Q.\u001a;sS\u000e\u001cXCAAO!\u0011\ty*a)\u000e\u0005\u0005\u0005&bAAMO&!\u0011QUAQ\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR!\u0011\u0011HAV\u0011%\t\t\u0005JA\u0001\u0002\u0004\ti*\u0001\u0005nKR\u0014\u0018nY:!\u00035\tXo\u001c;b\u000b:$\u0018\u000e^5fgV\u0011\u00111\u0017\t\u0007\u0003k\u000b)-!3\u000f\t\u0005]\u0016\u0011\u0019\b\u0005\u0003s\u000by,\u0004\u0002\u0002<*\u0019\u0011QX$\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015bAAb\u0017\u00069\u0001/Y2lC\u001e,\u0017b\u00013\u0002H*\u0019\u00111Y&\u0011\u0007I\u000bY-C\u0002\u0002N\u0006\u00131\"U;pi\u0006,e\u000e^5us\u0006\t\u0012/^8uC\u0016sG/\u001b;jKN|F%Z9\u0015\t\u0005e\u00121\u001b\u0005\n\u0003\u0003:\u0013\u0011!a\u0001\u0003g\u000ba\"];pi\u0006,e\u000e^5uS\u0016\u001c\b%\u0001\u0006rk>$\u0018MV1mk\u0016,\"!a7\u0011\u0007I\u000bi.C\u0002\u0002`\u0006\u0013!\"U;pi\u00064\u0016\r\\;f\u00039\tXo\u001c;b-\u0006dW/Z0%KF$B!!\u000f\u0002f\"I\u0011\u0011\t\u0016\u0002\u0002\u0003\u0007\u00111\\\u0001\fcV|G/\u0019,bYV,\u0007%A\u0007rk>$\u0018MV1mk\u0016l\u0015\r]\u000b\u0003\u0003[\u0004\u0002\"a<\u0002v\u0006e\u00181\\\u0007\u0003\u0003cT1!a=b\u0003\u001diW\u000f^1cY\u0016LA!a>\u0002r\n\u0019Q*\u00199\u0011\t\u0005m(1\u0001\b\u0005\u0003{\fy\u0010E\u0002\u0002:.K1A!\u0001L\u0003\u0019\u0001&/\u001a3fM&\u0019!P!\u0002\u000b\u0007\t\u00051*A\trk>$\u0018MV1mk\u0016l\u0015\r]0%KF$B!!\u000f\u0003\f!I\u0011\u0011I\u0017\u0002\u0002\u0003\u0007\u0011Q^\u0001\u000fcV|G/\u0019,bYV,W*\u00199!\u00031\tXo\u001c;b\u000b:$(/[3t+\t\u0011\u0019\u0002\u0005\u0004\u00026\u0006\u0015'Q\u0003\t\u0004%\n]\u0011b\u0001B\r\u0003\nQ\u0011+^8uC\u0016sGO]=\u0002!E,x\u000e^1F]R\u0014\u0018.Z:`I\u0015\fH\u0003BA\u001d\u0005?A\u0011\"!\u00111\u0003\u0003\u0005\rAa\u0005\u0002\u001bE,x\u000e^1F]R\u0014\u0018.Z:!\u0003-\tXo\u001c;b\u0007>tg-[4\u0016\u0005\t\u001d\u0002c\u0001*\u0003*%\u0019!1F!\u0003-E+x\u000e^1D_>\u0014H-\u001b8bi>\u00148i\u001c8gS\u001e\fA\"];pi\u0006\u001cuN\u001c4jO\u0002\nQa]3u+B$\"!!\u000f)\u0007Q\u0012)\u0004\u0005\u0003\u00038\t\u0015SB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003@\t\u0005\u0013a\u00026va&$XM\u001d\u0006\u0004\u0005\u0007b\u0017!\u00026v]&$\u0018\u0002\u0002B$\u0005s\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u001b\u0003NA!!q\u0007B(\u0013\u0011\u0011\tF!\u000f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0006;fgRdu.\u00193Rk>$\u0018MU3d_J$7\u000fK\u00027\u0005/\u0002BAa\u000e\u0003Z%!!1\fB\u001d\u0005\u0011!Vm\u001d;\u0002\u001fQ,7\u000f^*u_J,\u0017+^8uCND3a\u000eB,\u0003A!Xm\u001d;FqBL'/Z)v_R\f7\u000fK\u00029\u0005/\n\u0001\u0005^3ti\u0016C\b/\u001b:f#V|G/Y:XSRDwK]5uK\u001a\u000b\u0017\u000e\\;sK\"\u001a\u0011Ha\u0016\u0002+Q,7\u000f^)v_R\fWI\u001c;ssB\u000b'o]5oO\"\u001a!Ha\u0016\u00023Q,7\u000f^)v_R\fGk\\7cgR|g.\u001a)beNLgn\u001a\u0015\u0004w\t]\u0013AF3ya\u0016\u001cG/U;pi\u0006\u0014VmY8sINdu.\u00193\u0015\u0011\u0005e\"Q\u000fB=\u0005\u0007CaAa\u001e=\u0001\u0004)\u0017aG4s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003|q\u0002\rA! \u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0004\u0015\n}\u0014b\u0001BA\u0017\n!Aj\u001c8h\u0011\u001d\u0011)\t\u0010a\u0001\u0005\u000f\u000bqA]3d_J$7\u000f\u0005\u0003\u0003\n\n=UB\u0001BF\u0015\r\u0011iiZ\u0001\u0007e\u0016\u001cwN\u001d3\n\t\tE%1\u0012\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0015\u0011\tu$Q\u0013BP\u0005CCqAa&>\u0001\u0004\u0011I*A\u0004m_\u001elunY6\u0011\t\u0005e!1T\u0005\u0005\u0005;\u000bYBA\u0006BEN$(/Y2u\u0019><\u0007b\u0002B>{\u0001\u0007!Q\u0010\u0005\b\u0005\u000bk\u0004\u0019\u0001BD\u0003E\u0019'/Z1uKF+x\u000e^1SK\u000e|'\u000f\u001a\u000b\u0007\u0005O\u0013iK!-\u0011\t\t%%\u0011V\u0005\u0005\u0005W\u0013YI\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0004\u00030z\u0002\r!!3\u0002\u0017E,x\u000e^1F]RLG/\u001f\u0005\b\u0005gs\u0004\u0019\u0001B\u000b\u0003)\tXo\u001c;b\u000b:$(/_\u0001\u0015Kb\u0004Xm\u0019;BaB,g\u000eZ'fgN\fw-Z:\u0015\t\te&1\u001a\t\u0007\u0005w\u0013\tM!2\u000e\u0005\tu&b\u0001B`Y\u0006AQ-Y:z[>\u001c7.\u0003\u0003\u0003D\nu&aB\"baR,(/\u001a\t\b\u0005\u000f\u0014I-\u001aBD\u001b\u0005\t\u0017bAA|C\"9!QZ A\u0002\t=\u0017AB3se>\u00148\u000f\u0005\u0004\u00026\u0006\u0015'\u0011\u001b\t\u0005\u0005'\u0014I.\u0004\u0002\u0003V*\u0019!q[4\u0002\u0011A\u0014x\u000e^8d_2LAAa7\u0003V\n1QI\u001d:peN\u0004")
public class QuotaStateManagerTest {
    private final int numQuotasPartitions;
    private final int brokerId;
    private final Seq<TopicPartition> quotaTopicPartitions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("_confluent-quotas", 0), new TopicPartition("_confluent-quotas", 1)}));
    private final String entityType;
    private final Seq<String> entityNames = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"entityName0", "entityName1"}));
    private final String quotaType;
    private final double quota;
    private final double usage;
    private final LogConfig logConfig = new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.$lessinit$greater$default$2());
    private MockTime time;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private QuotaStateManager quotaStateManager;
    private Partition partition;
    private Metrics metrics;
    private Seq<QuotaEntity> quotaEntities;
    private QuotaValue quotaValue;
    private scala.collection.mutable.Map<String, QuotaValue> quotaValueMap = new HashMap();
    private Seq<QuotaEntry> quotaEntries;
    private final QuotaCoordinatorConfig quotaConfig;

    public int numQuotasPartitions() {
        return this.numQuotasPartitions;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Seq<TopicPartition> quotaTopicPartitions() {
        return this.quotaTopicPartitions;
    }

    public String entityType() {
        return this.entityType;
    }

    public Seq<String> entityNames() {
        return this.entityNames;
    }

    public String quotaType() {
        return this.quotaType;
    }

    public double quota() {
        return this.quota;
    }

    public double usage() {
        return this.usage;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public Seq<QuotaEntity> quotaEntities() {
        return this.quotaEntities;
    }

    public void quotaEntities_$eq(Seq<QuotaEntity> x$1) {
        this.quotaEntities = x$1;
    }

    public QuotaValue quotaValue() {
        return this.quotaValue;
    }

    public void quotaValue_$eq(QuotaValue x$1) {
        this.quotaValue = x$1;
    }

    public scala.collection.mutable.Map<String, QuotaValue> quotaValueMap() {
        return this.quotaValueMap;
    }

    public void quotaValueMap_$eq(scala.collection.mutable.Map<String, QuotaValue> x$1) {
        this.quotaValueMap = x$1;
    }

    public Seq<QuotaEntry> quotaEntries() {
        return this.quotaEntries;
    }

    public void quotaEntries_$eq(Seq<QuotaEntry> x$1) {
        this.quotaEntries = x$1;
    }

    private QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    @BeforeEach
    public void setUp() {
        this.metrics_$eq(new Metrics());
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.logManager_$eq((LogManager)EasyMock.createNiceMock(LogManager.class));
        this.quotaStateManager_$eq(new QuotaStateManager(this.quotaConfig(), (Scheduler)this.time().scheduler(), this.replicaManager(), this.metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> this.numQuotasPartitions(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {});
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
        this.quotaEntities_$eq((Seq<QuotaEntity>)((Seq)this.entityNames().map((Function1 & Serializable)name -> new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), name)}))))));
        this.quotaValue_$eq(QuotaValue$.MODULE$.loadValue(this.usage(), false, this.quota(), this.time().milliseconds()));
        this.quotaValueMap().update((Object)this.quotaType(), (Object)this.quotaValue());
        this.quotaEntries_$eq((Seq<QuotaEntry>)((Seq)this.quotaEntities().map((Function1 & Serializable)entity -> new QuotaEntry(entity, this.time().milliseconds()))));
        this.quotaEntries().foreach((Function1 & Serializable)quotaEntry -> {
            quotaEntry.putQuotaValue(this.brokerId(), this.quotaType(), this.quotaValue());
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getLogConfig((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.logConfig())).anyTimes();
    }

    @AfterEach
    public void tearDown() {
        this.quotaStateManager().shutdown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadQuotaRecords() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        long startOffset = 10L;
        SimpleRecord quotaRecord = this.createQuotaRecord((QuotaEntity)this.quotaEntities().head(), (QuotaEntry)this.quotaEntries().head());
        TopicPartition quotaTopicPartition = (TopicPartition)this.quotaTopicPartitions().apply(this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().head()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{quotaRecord};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var12_6 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var9_5 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.expectQuotaRecordsLoad(quotaTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaStateManager().loadQuotaState(quotaTopicPartition.partition(), 0);
        this.time().sleep(5L);
        QuotaEntry loadedQuota = this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head());
        Assertions.assertEquals((Object)this.quotaEntities().head(), (Object)loadedQuota.quotaEntity());
        int loadedBroker = ((Tuple2)loadedQuota.computedQuotas().head())._1$mcI$sp();
        Assertions.assertEquals((int)this.brokerId(), (int)loadedBroker);
        scala.collection.mutable.Map loadedQuotaValues = (scala.collection.mutable.Map)((Tuple2)loadedQuota.computedQuotas().head())._2();
        Assertions.assertEquals(this.quotaValueMap(), (Object)loadedQuotaValues);
        EasyMock.verify((Object[])new Object[]{this.replicaManager(), this.logManager()});
    }

    @Test
    public void testStoreQuotas() {
        Seq expectedErrors = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.NONE, Errors.NONE}));
        Capture<Map<TopicPartition, MemoryRecords>> capturedRecords = this.expectAppendMessages((Seq<Errors>)expectedErrors);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeErrors = ObjectRef.create((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$10))), (Object)None$.MODULE$)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        QuotaStateManager qual$1 = this.quotaStateManager();
        scala.collection.immutable.Map x$1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.quotaTopicPartitions().apply(BoxesRunTime.unboxToInt((Object)i))), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaEntry[]{(QuotaEntry)this.quotaEntries().apply(BoxesRunTime.unboxToInt((Object)i))})))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Function1 & Serializable x$2 = (Function1 & Serializable)errors -> {
            QuotaStateManagerTest.callback$1(errors, maybeErrors);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$3 = qual$1.storeQuotas$default$3();
        qual$1.storeQuotas((Map)x$1, (Function1)x$2, x$3);
        ((Map)maybeErrors.elem).foreach((Function1 & Serializable)x0$1 -> {
            QuotaStateManagerTest.$anonfun$testStoreQuotas$5(expectedErrors, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)capturedRecords.hasCaptured());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            List records = CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)capturedRecords.getValue()).apply(this.quotaTopicPartitions().apply(partition))).records()).asScala().toList();
            Assertions.assertEquals((int)1, (int)records.size());
            Record record = (Record)records.head();
            QuotaEntity capturedQuotaKey = QuotaStateManager$.MODULE$.readMessageKey(record.key());
            Assertions.assertEquals((Object)this.quotaEntities().apply(partition), (Object)capturedQuotaKey);
            Option capturedQuotaValue = QuotaStateManager$.MODULE$.readMessageValue((QuotaEntity)this.quotaEntities().apply(partition), record.value());
            int capturedBrokerId = ((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._1$mcI$sp();
            Assertions.assertEquals((int)this.brokerId(), (int)capturedBrokerId);
            scala.collection.mutable.Map capturedQuotaValues = (scala.collection.mutable.Map)((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._2();
            Assertions.assertEquals(this.quotaValueMap(), (Object)capturedQuotaValues);
        });
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireQuotas() {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, callbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture callbackCapture$1;

            public void answer() {
                ((Function1)this.callbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callbackCapture$1 = callbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotas$1(this.quotaStateManager(), arg_0));
        this.time().sleep(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head()).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), 100000.0, this.time().milliseconds(), Long.MAX_VALUE);
        this.time().sleep(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3));
        Assertions.assertEquals((int)1, (int)((MapOps)recordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)recordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)recordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    @Test
    public void testExpireQuotasWithWriteFailure() {
        Capture firstRecordsCapture = EasyMock.newCapture();
        Capture firstCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)firstRecordsCapture), (Function1)EasyMock.capture((Capture)firstCallbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, firstCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture firstCallbackCapture$1;

            public void answer() {
                ((Function1)this.firstCallbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_ENOUGH_REPLICAS, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.firstCallbackCapture$1 = firstCallbackCapture$1;
            }
        }).once();
        Capture secondRecordsCapture = EasyMock.newCapture();
        Capture secondCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)secondRecordsCapture), (Function1)EasyMock.capture((Capture)secondCallbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, secondCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture secondCallbackCapture$1;

            public void answer() {
                ((Function1)this.secondCallbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondCallbackCapture$1 = secondCallbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotasWithWriteFailure$1(this.quotaStateManager(), arg_0));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).lastUpdatedTimestamp_$eq(this.time().milliseconds() - (long)(this.quotaConfig().quotasExpirationTimeMs() * 2));
        this.time().sleep(this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapOps)firstRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)firstRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)firstRecordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
        this.time().sleep(this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapOps)secondRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)secondRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)secondRecordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaEntryParsing() {
        void var8_8;
        void var7_7;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, this.time().milliseconds());
        quotaEntry.putQuotaValue(0, this.quotaType(), this.quotaValue());
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] valueBytes = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        Record quotaRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(keyBytes, valueBytes)}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)var7_7);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(37).append("computedQuotas:").append(quotaEntry.computedQuotasString()).append(",lastUpdatedTimestamp:").append(this.time().milliseconds()).toString()), (Object)var8_8);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaTombstoneParsing() {
        void var6_6;
        void var5_5;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        Record quotaRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(keyBytes, null)}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)var5_5);
        Assertions.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)var6_6);
    }

    private void expectQuotaRecordsLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records) {
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        long endOffset = this.expectQuotaRecordsLoad(logMock, startOffset, records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.expect((Object)this.replicaManager().logManager()).andStubReturn((Object)this.logManager());
        this.logManager().abortAndPauseCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.logManager().resumeCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.logManager()});
    }

    private long expectQuotaRecordsLoad(AbstractLog logMock, long startOffset, MemoryRecords records) {
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{fileRecordsMock});
        return endOffset;
    }

    private SimpleRecord createQuotaRecord(QuotaEntity quotaEntity, QuotaEntry quotaEntry) {
        byte[] quotaRecordKey = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] quotaRecordValue = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        return new SimpleRecord(quotaRecordKey, quotaRecordValue);
    }

    /*
     * WARNING - void declaration
     */
    private Capture<Map<TopicPartition, MemoryRecords>> expectAppendMessages(Seq<Errors> errors) {
        void var3_3;
        Capture capturedCallback = EasyMock.newCapture();
        Capture capturedRecords = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)capturedRecords), (Function1)EasyMock.capture((Capture)capturedCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedCallback, errors){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture capturedCallback$1;
            private final Seq errors$1;

            public void answer() {
                ((Function1)this.capturedCallback$1.getValue()).apply((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.numQuotasPartitions()).map((Function1 & Serializable)i -> $anon$5.$anonfun$answer$1(this, BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public static final /* synthetic */ Tuple2 $anonfun$answer$1($anon$5 $this, int i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc($this.$outer.quotaTopicPartitions().apply(i)), (Object)new ProduceResponse.PartitionResponse((Errors)$this.errors$1.apply(i), 0L, -1L, 0L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.capturedCallback$1 = capturedCallback$1;
                this.errors$1 = errors$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(kafka.coordinator.quota.QuotaStateManagerTest$$anon$5 java.lang.Object )}, serializedLambda);
            }
        });
        return var3_3;
    }

    private static final void callback$1(Map errors, ObjectRef maybeErrors$1) {
        maybeErrors$1.elem = (Map)errors.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Errors error = (Errors)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)new Some((Object)error));
            return tuple2;
        });
    }

    public static final /* synthetic */ void $anonfun$testStoreQuotas$5(Seq expectedErrors$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int i = x0$1._1$mcI$sp();
            Option errorOpt = (Option)x0$1._2();
            if (errorOpt instanceof Some) {
                Errors error = (Errors)((Some)errorOpt).value();
                Assertions.assertEquals((Object)expectedErrors$1.apply(i), (Object)error);
                return;
            }
            if (None$.MODULE$.equals(errorOpt)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(51).append("Partition ").append(i).append(" was not processed by the append callback").toString());
                return;
            }
            throw new MatchError((Object)errorOpt);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotas$1(QuotaStateManager eta$0$1$1, QuotaEntity quotaEntity) {
        return eta$0$1$1.getAndMaybePutQuota(quotaEntity);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotasWithWriteFailure$1(QuotaStateManager eta$0$1$2, QuotaEntity quotaEntity) {
        return eta$0$1$2.getAndMaybePutQuota(quotaEntity);
    }

    public QuotaStateManagerTest() {
        this.numQuotasPartitions = 2;
        this.brokerId = 0;
        this.entityType = "entityType";
        this.quotaType = "quotaType";
        this.quota = 60000.0;
        this.usage = 3000.0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        int x$1 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize());
        int x$2 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions());
        int x$3 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes());
        short x$4 = Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor());
        CompressionCodec x$5 = config.confluentConfig().quotasTopicCompressionCodec();
        int x$6 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs());
        String x$7 = config.confluentConfig().quotasTopicPlacementConstraints();
        int x$8 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs());
        int x$9 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs());
        int n = QuotaCoordinatorConfig$.MODULE$.DefaultQuotasConsumptionExpirationTimeMs();
        this.quotaConfig = new QuotaCoordinatorConfig(x$2, x$4, x$3, x$1, x$5, x$6, x$7, x$8, x$9, n);
    }
}

