/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.LogConfig;
import kafka.log.MergedLog$;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\reg\u0001\u00025j\u0001ADQa\u001e\u0001\u0005\u0002aDqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B?\t\u0011\u0005\r\u0001A1A\u0005\u0002qDq!!\u0002\u0001A\u0003%Q\u0010\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001}\u0011\u001d\tI\u0001\u0001Q\u0001\nuD\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u001fA\u0001\"a\n\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003S\u0001\u0001\u0015!\u0003~\u0011%\tY\u0003\u0001b\u0001\n\u0003\ti\u0003\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u0018\u0011%\ti\u0005\u0001b\u0001\n\u0003\ty\u0005\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA)\u0011%\ty\u0006\u0001b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA2\u0011%\ty\u0007\u0001b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA:\u0011%\t\t\t\u0001b\u0001\n\u0003\t\u0019\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAC\u0011%\t\u0019\n\u0001b\u0001\n\u0003\t)\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0011BAL\u0011%\t\u0019\u000b\u0001b\u0001\n\u0003\t)\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAT\u0011%\ty\u000b\u0001b\u0001\n\u0003\t\t\f\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAZ\u0011%\tY\f\u0001b\u0001\n\u0003\ti\f\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BA`\u0011%\t9\r\u0001b\u0001\n\u0003\tI\r\u0003\u0005\u0002R\u0002\u0001\u000b\u0011BAf\u0011%\t\u0019\u000e\u0001b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002n\u0002\u0001\u000b\u0011BAl\u0011%\ty\u000f\u0001b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002r\u0002\u0001\u000b\u0011BAl\u0011%\t\u0019\u0010\u0001b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0004\u0001\u0001\u000b\u0011BA|\u0011%\u0011)\u0001\u0001b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\b\u0001\u0001\u000b\u0011BA|\u0011%\u0011I\u0001\u0001b\u0001\n\u0003\u0011Y\u0001\u0003\u0005\u0003\u001c\u0001\u0001\u000b\u0011\u0002B\u0007\u0011%\u0011i\u0002\u0001a\u0001\n\u0003\u0011y\u0002C\u0005\u0003(\u0001\u0001\r\u0011\"\u0001\u0003*!A!Q\u0007\u0001!B\u0013\u0011\t\u0003C\u0005\u00038\u0001\u0001\r\u0011\"\u0001\u0003 !I!\u0011\b\u0001A\u0002\u0013\u0005!1\b\u0005\t\u0005\u007f\u0001\u0001\u0015)\u0003\u0003\"!I!\u0011\t\u0001A\u0002\u0013\u0005!1\t\u0005\n\u0005#\u0002\u0001\u0019!C\u0001\u0005'B\u0001Ba\u0016\u0001A\u0003&!Q\t\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011\u0019\b\u0001C\u0001\u00057BqA! \u0001\t\u0003\u0011Y\u0006C\u0004\u0003\b\u0002!\tAa\u0017\t\u000f\t-\u0005\u0001\"\u0001\u0003\\!9!q\u0012\u0001\u0005\u0002\tm\u0003b\u0002BJ\u0001\u0011\u0005!1\f\u0005\b\u0005/\u0003A\u0011\u0001B.\u0011\u001d\u0011Y\n\u0001C\u0001\u00057BqAa(\u0001\t\u0003\u0011Y\u0006C\u0004\u0003$\u0002!\tAa\u0017\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003\\!9!1\u0016\u0001\u0005\u0002\tm\u0003b\u0002BX\u0001\u0011\u0005!1\f\u0005\b\u0005g\u0003A\u0011\u0001B.\u0011\u001d\u00119\f\u0001C\u0001\u00057BqAa/\u0001\t\u0003\u0011Y\u0006C\u0004\u0003@\u0002!\tAa\u0017\t\u000f\t\r\u0007\u0001\"\u0001\u0003\\!9!q\u0019\u0001\u0005\u0002\tm\u0003b\u0002Bf\u0001\u0011\u0005!1\f\u0005\b\u0005\u001f\u0004A\u0011\u0001B.\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u00057BqAa6\u0001\t\u0003\u0011Y\u0006C\u0004\u0003\\\u0002!\tAa\u0017\t\u000f\t}\u0007\u0001\"\u0001\u0003\\!9!1\u001d\u0001\u0005\u0002\tm\u0003b\u0002Bt\u0001\u0011\u0005!1\f\u0005\b\u0005W\u0004A\u0011\u0001B.\u0011\u001d\u0011y\u000f\u0001C\u0001\u00057BqAa=\u0001\t\u0003\u0011Y\u0006C\u0004\u0003x\u0002!IA!?\t\u000f\rU\u0001\u0001\"\u0003\u0004\u0018!91Q\u0004\u0001\u0005\n\r}\u0001bBB\u0011\u0001\u0011\u0005!1\f\u0005\b\u0007K\u0001A\u0011\u0001B.\u0011\u001d\u0019I\u0003\u0001C\u0005\u0007WAqa!\r\u0001\t\u0013\u0019\u0019\u0004C\u0004\u00048\u0001!Ia!\u000f\t\u000f\r\r\u0003\u0001\"\u0003\u0004F!91Q\f\u0001\u0005\n\r}\u0003bBB4\u0001\u0011%1\u0011\u000e\u0005\b\u0007s\u0002A\u0011BB>\u0011\u001d\u0019\t\t\u0001C\u0005\u0007\u0007Cqaa\"\u0001\t\u0013\u0019I\tC\u0005\u0004\u0018\u0002\t\n\u0011\"\u0003\u0004\u001a\"I1q\u0016\u0001\u0012\u0002\u0013%1\u0011\u0017\u0005\b\u0007k\u0003A\u0011BB\\\u0011\u001d\u0019\u0019\r\u0001C\u0005\u0007\u000bDqa!3\u0001\t\u0003\u0011Y\u0006C\u0004\u0004N\u0002!\tAa\u0017\t\u000f\rE\u0007\u0001\"\u0001\u0003\\!91Q\u001b\u0001\u0005\u0002\tm#a\u0007+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002kW\u0006YAO]1og\u0006\u001cG/[8o\u0015\taW.A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u00018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0002i\u0006)1oY1mC&\u0011ao\u001d\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\bC\u0001>\u0001\u001b\u0005I\u0017a\u00039beRLG/[8o\u0013\u0012,\u0012! \t\u0003ezL!a`:\u0003\u0007%sG/\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0006)BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\"5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004d_6lwN\u001c\u0006\u0004]\u0006e!\u0002BA\u000e\u0003;\ta!\u00199bG\",'BAA\u0010\u0003\ry'oZ\u0005\u0005\u0003G\t\u0019B\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007%\u0001\u0006uq:\u0014VmY8sIN,\"!a\f\u0011\r\u0005E\u00121HA \u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003s\u0019\u0018AC2pY2,7\r^5p]&!\u0011QHA\u001a\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u0002\u0014\u00051!/Z2pe\u0012LA!!\u0013\u0002D\ta1+[7qY\u0016\u0014VmY8sI\u0006YA\u000f\u001f8SK\u000e|'\u000fZ:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\t\u0005]\u00131C\u0001\u0006kRLGn]\u0005\u0005\u00037\n)F\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002dA!\u0011QMA5\u001b\t\t9GC\u0002\u0002X5LA!a\u001b\u0002h\tiQj\\2l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003!Q8n\u00117jK:$XCAA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=[\u0006\u0011!p[\u0005\u0005\u0003{\n9HA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002\u0006B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f6\faa]3sm\u0016\u0014\u0018\u0002BAH\u0003\u0013\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003\u001diW\r\u001e:jGN,\"!a&\u0011\t\u0005e\u0015QT\u0007\u0003\u00037SA!a%\u0002\u0014%!\u0011qTAN\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\te\u0016\u0004xN\u001d;feV\u0011\u0011q\u0015\t\u0005\u00033\u000bI+\u0003\u0003\u0002,\u0006m%a\u0003&nqJ+\u0007o\u001c:uKJ\f\u0011B]3q_J$XM\u001d\u0011\u0002\u001d5,GO]5dg\u000e{g\u000e^3yiV\u0011\u00111\u0017\t\u0005\u00033\u000b),\u0003\u0003\u00028\u0006m%aE&bM.\fW*\u001a;sS\u000e\u001c8i\u001c8uKb$\u0018aD7fiJL7m]\"p]R,\u0007\u0010\u001e\u0011\u0002\u0013QDhnQ8oM&<WCAA`!\rQ\u0018\u0011Y\u0005\u0004\u0003\u0007L'!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006QA\u000f\u001f8D_:4\u0017n\u001a\u0011\u0002%Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM]\u000b\u0003\u0003\u0017\u00042A_Ag\u0013\r\ty-\u001b\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f1\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4fe\u0002\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0019\u0016\u0005\u0005]\u0007\u0003BAm\u0003OtA!a7\u0002dB\u0019\u0011Q\\:\u000e\u0005\u0005}'bAAq_\u00061AH]8pizJ1!!:t\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011^Av\u0005\u0019\u0019FO]5oO*\u0019\u0011Q]:\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0005\tBO]1og\u0006\u001cG/[8oC2LEM\r\u0011\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019\u0016\u0005\u0005]\b#\u0002:\u0002z\u0006u\u0018bAA~g\n)\u0011I\u001d:bsB\u0019!/a@\n\u0007\t\u00051O\u0001\u0003CsR,\u0017\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\f\u0004%A\nuq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c('\u0001\u000buq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c(\u0007I\u0001\faJ|G-^2fe&#7/\u0006\u0002\u0003\u000eAA!q\u0002B\t\u0003/\u0014)\"\u0004\u0002\u00028%!!1CA\u001c\u0005\ri\u0015\r\u001d\t\u0004e\n]\u0011b\u0001B\rg\n!Aj\u001c8h\u00031\u0001(o\u001c3vG\u0016\u0014\u0018\nZ:!\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\u0011\t\u0003E\u0002{\u0005GI1A!\nj\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0003A!\bP\\'fi\u0006$\u0017\r^12?\u0012*\u0017\u000f\u0006\u0003\u0003,\tE\u0002c\u0001:\u0003.%\u0019!qF:\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005gY\u0013\u0011!a\u0001\u0005C\t1\u0001\u001f\u00132\u00035!\bP\\'fi\u0006$\u0017\r^12A\u0005aA\u000f\u001f8NKR\fG-\u0019;be\u0005\u0001B\u000f\u001f8NKR\fG-\u0019;be}#S-\u001d\u000b\u0005\u0005W\u0011i\u0004C\u0005\u000349\n\t\u00111\u0001\u0003\"\u0005iA\u000f\u001f8NKR\fG-\u0019;be\u0001\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014XC\u0001B#!\u0011\u00119E!\u0014\u000e\u0005\t%#\u0002\u0002B&\u0003'\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005\u001f\u0012IE\u0001\u0004FeJ|'o]\u0001\u0012Kb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:`I\u0015\fH\u0003\u0002B\u0016\u0005+B\u0011Ba\r2\u0003\u0003\u0005\rA!\u0012\u0002\u001d\u0015D\b/Z2uK\u0012,%O]8sA\u0005)1/\u001a;VaR\u0011!1\u0006\u0015\u0004g\t}\u0003\u0003\u0002B1\u0005_j!Aa\u0019\u000b\t\t\u0015$qM\u0001\u0004CBL'\u0002\u0002B5\u0005W\nqA[;qSR,'O\u0003\u0003\u0003n\u0005u\u0011!\u00026v]&$\u0018\u0002\u0002B9\u0005G\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u001b\u0003xA!!\u0011\rB=\u0013\u0011\u0011YHa\u0019\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgR4\u0016\r\\5eCR,GK]1og\u0006\u001cG/[8o)&lWm\\;uQ\r)$\u0011\u0011\t\u0005\u0005C\u0012\u0019)\u0003\u0003\u0003\u0006\n\r$\u0001\u0002+fgR\fa\u0002^3ti\u0006#GmR3u!&$7\u000fK\u00027\u0005\u0003\u000b1\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3a\u000eBA\u0003i!Xm\u001d;EK2,G/\u001a'pC\u0012Lgn\u001a)beRLG/[8oQ\rA$\u0011Q\u0001*i\u0016\u001cH\u000fT8bI\u0006sGMU3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000fU1si&$\u0018n\u001c8)\u0007e\u0012\t)A\u0015uKN$8i\\7qY\u0016$X\r\u0016:b]NLG/[8o/\",g.\u00119qK:$7+^2dK\u0016$W\r\u001a\u0015\u0004u\t\u0005\u0015\u0001\f;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p\u0007>|'\u000fZ5oCR|'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016,%O]8sQ\rY$\u0011Q\u0001$i\u0016\u001cH/\u00119qK:$g)Y5m)>tu\u000e^\"p_J$\u0017N\\1u_J,%O]8sQ\ra$\u0011Q\u0001(i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:M_\u0006$\u0017N\\4FeJ|'\u000fK\u0002>\u0005\u0003\u000bA\u0004^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8V].twn\u001e8FeJ|'\u000fK\u0002?\u0005\u0003\u000bQ\u0005^3tiB+g\u000eZ5oON#\u0018\r^3O_R\u0014Vm]3u\u001f:\u0014V\r\u001e:z\u0003B\u0004XM\u001c3)\u0007}\u0012\t)A\u0017uKN$\u0018\t\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{wm\u00165jY\u0016\u0004&o\u001c3vG\u0016\u0014h)\u001a8dK\u0012D3\u0001\u0011BA\u0003I\"Xm\u001d;BaB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8h/\"LG.\u001a)f]\u0012LgnZ*uCR,7\t[1oO\u0016$\u0007fA!\u0003\u0002\u0006y4\u000f[8vY\u0012\u0014V\r^;s]:{GoQ8pe\u0012Lg.\u0019;pe\u0016\u0013(o\u001c:JMR\u0013\u0018M\\:bGRLwN\\%e!\u0006\u0014H/\u001b;j_:tu\u000e^(x]\u0016$\u0007f\u0001\"\u0003\u0002\u0006!D/Z:u\u0019&\u001cH\u000f\u0016:b]N\f7\r^5p]N<\u0016\u000e\u001e5D_>\u0014H-\u001b8bi>\u0014Hj\\1eS:<\u0017J\u001c)s_\u001e\u0014Xm]:)\u0007\r\u0013\t)A\u000fuKN$H*[:u)J\fgn]1di&|gn\u001d$jYR,'/\u001b8hQ\r!%\u0011Q\u00017g\"|W\u000f\u001c3P]2L8i\u001c8tS\u0012,'\u000f\u0016:b]N\f7\r^5p]NLe\u000e\u00165f\u001f:<w.\u001b8h'R\fG/\u001a+p\u0003\n|'\u000f\u001e\u0015\u0004\u000b\n\u0005\u0015\u0001O:i_VdGm\u0016:ji\u0016$\u0006P\\'be.,'o\u001d$peR\u0013\u0018M\\:bGRLwN\\%o!J,\u0007/\u0019:fI\u000e{W.\\5u'R\fG/\u001a\u0015\u0004\r\n\u0005\u0015aN:i_VdGm\u0016:ji\u0016$\u0006P\\'be.,'o\u001d$peR\u0013\u0018M\\:bGRLwN\\%o!J,\u0007/\u0019:fI\u0006\u0013wN\u001d;Ti\u0006$X\rK\u0002H\u0005\u0003\u000b\u0011g\u001d5pk2$'+Z7pm\u0016\u001cu.\u001c9mKR,7i\\7nSR,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002I\u0005\u0003\u000b\u0001g\u001d5pk2$'+Z7pm\u0016\u001cu.\u001c9mKR,\u0017IY8si\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bfA%\u0003\u0002\u0006A3\u000f[8vY\u0012\u0014V-\\8wK\u0016k\u0007\u000f^=FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001a!J!!\u0002mMDw.\u001e7e\u001d>$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00134M_\u001e\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\\:)\u0007-\u0013\t)\u0001\u0014tQ>,H\u000e\u001a(piJ+Wn\u001c<f\u001f:<w.\u001b8h)J\fgn]1di&|g.\u00197JIND3\u0001\u0014BA\u0003-\u001a\bn\\;mI:{GOU3n_Z,\u0007K]3qCJ,\u0017IY8siR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bfA'\u0003\u0002\u0006a3\u000f[8vY\u0012tu\u000e\u001e*f[>4X\r\u0015:fa\u0006\u0014XmQ8n[&$HK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u001d\n\u0005\u0015\u0001\r;fgR$&/\u00198tC\u000e$\u0018n\u001c8bY\u0016C\b/\u001b:bi&|gnV5uQR{wnU7bY2\u0014\u0015\r^2i'&TX\rK\u0002P\u0005\u0003\u000bA\u0006^3tiR\u0013\u0018M\\:bGRLwN\\1m\u000bb\u0004\u0018N]1uS>tw+\u001b;i\u001f\u001a4G.\u001b8f\u0019><G)\u001b:)\u0007A\u0013\t)A\u0018uKN$HK]1og\u0006\u001cG/[8o\u000bb\u0004\u0018N]1uS>t7\u000b[8vY\u0012\u0014Vm\u001d9fGR\u0014\u0015\r^2i'&TX\rK\u0002R\u0005\u0003\u000bQeY8mY\u0016\u001cG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:Ge>lGk\\7cgR|g.Z:\u0015\t\tm8\u0011\u0001\t\u0007\u00033\u0014i0a6\n\t\t}\u00181\u001e\u0002\u0004'\u0016$\bbBB\u0002%\u0002\u00071QA\u0001\u0010CB\u0004XM\u001c3fIJ+7m\u001c:egBA\u0011\u0011GB\u0004\u0003\u001f\u0019I!\u0003\u0003\u0003\u0014\u0005M\u0002CBA\u0019\u0007\u0017\u0019y!\u0003\u0003\u0004\u000e\u0005M\"A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002B\rE\u0011\u0002BB\n\u0003\u0007\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\u0018a\u00077pC\u0012,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0003\u0003|\u000ee\u0001BBB\u000e'\u0002\u0007Q0A\nok6$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/A\u000fmSN$X\t\u001f9je\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t)\t\u0011Y0A\u000euKN$8+^2dKN\u001ch-\u001e7SK&lW.[4sCRLwN\u001c\u0015\u0004+\n\u0005\u0015a\u000b;fgRdu.\u00193Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mV5uQ\u000e{'O];qi\u0016$Gj\\4)\u0007Y\u0013\t)\u0001\u0012wKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001cX\t_5ti\u0006sG-S:Vg\u0006\u0014G.\u001a\u000b\u0005\u0005W\u0019i\u0003C\u0004\u00040]\u0003\r!a6\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0011D^3sS\u001aLX*\u001a;bI\u0006$\u0018\rR8fg:$X\t_5tiR!!1FB\u001b\u0011\u001d\u0019y\u0003\u0017a\u0001\u0003/\fq$\u001a=qK\u000e$HK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o)\u0019\u0011Yca\u000f\u0004@!91QH-A\u0002\t\u0015\u0013aC1qa\u0016tG-\u0012:s_JDqa!\u0011Z\u0001\u0004\u0019)!A\bdCB$XO]3e\u0003B\u0004XM\u001c3t\u0003uaw.\u00193Ue\u0006t7/Y2uS>t7OR8s!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\u0016\u0007\u000fBqa!\u0013[\u0001\u0004\u0019Y%\u0001\u0007qCJ$\u0018\u000e^5p]&#7\u000fE\u0003\u0004N\r]SP\u0004\u0003\u0004P\rMc\u0002BAo\u0007#J\u0011\u0001^\u0005\u0004\u0007+\u001a\u0018a\u00029bG.\fw-Z\u0005\u0005\u00073\u001aYFA\u0002TKFT1a!\u0016t\u0003=)\u0007\u0010]3di2{wmQ8oM&<GC\u0002B\u0016\u0007C\u001a\u0019\u0007C\u0004\u0004Jm\u0003\raa\u0013\t\r\r\u00154\f1\u0001~\u00031i\u0017\r\u001f\"bi\u000eD7+\u001b>f\u0003\u0011\u001aX\r^;q\u0003:$'+\u001e8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tGC\u0002B\u0016\u0007W\u001ay\u0007C\u0004\u0004nq\u0003\rA!\u0012\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\rED\f1\u0001\u0004t\u0005AA\u000f\u001f8Ti\u0006$X\rE\u0002{\u0007kJ1aa\u001ej\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-\u0001\u0013wKJLg-_,sSR,7\u000f\u0016=o\u001b\u0006\u00148.\u001a:t\u0013:\u0004&/\u001a9be\u0016\u001cF/\u0019;f)\u0011\u0011Yc! \t\u000f\r}T\f1\u0001\u0004t\u0005)1\u000f^1uK\u0006q\u0011m]:feR\u001c\u0015\r\u001c7cC\u000e\\G\u0003\u0002B\u0016\u0007\u000bCqa!\u001c_\u0001\u0004\u0011)%A\nue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0003\"\r-5QRBI\u0007'Cqaa\f`\u0001\u0004\t9\u000eC\u0004\u0004\u0010~\u0003\rA!\u0006\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0005\u0004\u0000}\u0003\n\u00111\u0001\u0004t!A1QS0\u0011\u0002\u0003\u0007Q0\u0001\u0006uq:$\u0016.\\3pkR\fQ\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u00077SCaa\u001d\u0004\u001e.\u00121q\u0014\t\u0005\u0007C\u001bY+\u0004\u0002\u0004$*!1QUBT\u0003%)hn\u00195fG.,GMC\u0002\u0004*N\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019ika)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019LK\u0002~\u0007;\u000bQ\u0002\u001d:fa\u0006\u0014X\r\u0016=o\u0019><G\u0003\u0003B\u0016\u0007s\u001bYla0\t\u000f\u0005-!\r1\u0001\u0002\u0010!91Q\u00182A\u0002\tU\u0011aC:uCJ$xJ\u001a4tKRDqa!1c\u0001\u0004\u0019y!A\u0004sK\u000e|'\u000fZ:\u00025A\u0014X\r]1sK\u001a{'\u000f\u0016=o\u001b\u0016\u001c8/Y4f\u0003B\u0004XM\u001c3\u0015\t\t-2q\u0019\u0005\b\u0007[\u001a\u0007\u0019\u0001B#\u0003]!Xm\u001d;QCJ$\u0018\u000e^5p]2{\u0017\rZ'fiJL7\rK\u0002e\u0005\u0003\u000bA\u0005^3tiR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'fiJL7m\u0011:fCRLwN\u001c\u0015\u0004K\n\u0005\u0015\u0001\b;fgR\u001cF/\u0019;f\u000bJ\u0014xN]'fiJL7m\u0011:fCRLwN\u001c\u0015\u0004M\n\u0005\u0015A\b;fgR$v\u000e^1m)J\fgn]1di&|g\u000eV5nK6+GO]5dQ\r9'\u0011\u0011")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final Metrics metrics;
    private final JmxReporter reporter;
    private final KafkaMetricsContext metricsContext;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public JmxReporter reporter() {
        return this.reporter;
    }

    public KafkaMetricsContext metricsContext() {
        return this.metricsContext;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        this.transactionManager().shutdown();
        this.reporter().close();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteLoadingPartition() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        AbstractLog logMock = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var22_7 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var17_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            latch.await();
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable)(x$3, x$4, x$5, x$6) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(BoxesRunTime.unboxToInt((Object)x$3), x$4, x$5, x$6);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for loading partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var9_4 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var6_3 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$7 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$8 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$9, x$10, x$11, x$12) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$9), x$10, x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString());
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString());
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$13 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$14 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        String x$1 = this.transactionalId1();
        int x$2 = this.coordinatorEpoch();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        String x$7 = this.transactionalId1();
        Function1 & Serializable x$10 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, 10, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        String x$13 = this.transactionalId1();
        Function1 & Serializable x$16 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, 10, failedMetadata, (Function1)x$16, x$18, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        String x$19 = this.transactionalId1();
        Function1 & Serializable x$22 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, 10, failedMetadata, (Function1)x$22, x$24, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        String x$7 = this.transactionalId1();
        Function1 & Serializable x$10 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, 10, failedMetadata, (Function1)x$10, x$12, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        String x$13 = this.transactionalId1();
        Function1 & Serializable x$16 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, 10, failedMetadata, (Function1)x$16, x$18, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        String x$19 = this.transactionalId1();
        Function1 & Serializable x$22 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, 10, failedMetadata, (Function1)x$22, x$24, requestLocal);
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        String x$7 = this.transactionalId1();
        Function1 & Serializable x$10 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, 10, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$15)), RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, newMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> {
            String x$1 = this.transactionalId1();
            Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
                this.assertCallback(error);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
            this.transactionManager().appendTransactionToLog(x$1, 10, newMetadata, (Function1)x$4, x$6, x$5);
        });
    }

    @Test
    public void shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$16 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void testListTransactionsWithCoordinatorLoadingInProgress() {
        this.transactionManager().addLoadingPartition(0, 15);
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty());
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)Errors.forCode((short)listResponse.errorCode()));
    }

    @Test
    public void testListTransactionsFiltering() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
        this.putTransaction$1("t0", 0L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t1", 1L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t2", 2L, (TransactionState)PrepareCommit$.MODULE$);
        this.putTransaction$1("t3", 3L, (TransactionState)PrepareAbort$.MODULE$);
        this.putTransaction$1("t4", 4L, (TransactionState)CompleteCommit$.MODULE$);
        this.putTransaction$1("t5", 5L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t6", 6L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t7", 7L, (TransactionState)PrepareEpochFence$.MODULE$);
        this.putTransaction$1("t8", 8L, (TransactionState)Dead$.MODULE$);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"})), TransactionStateManagerTest.assertListTransactions$default$2$1(), TransactionStateManagerTest.assertListTransactions$default$3$1());
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing"}));
        scala.collection.immutable.Set x$3 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$1, x$3, x$2);
        scala.collection.immutable.Set x$4 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing", "UnknownState"}));
        scala.collection.immutable.Set x$6 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$4, x$6, x$5);
        scala.collection.immutable.Set x$7 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2", "t4"}));
        scala.collection.immutable.Set x$8 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PrepareCommit", "CompleteCommit"}));
        scala.collection.immutable.Set x$9 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$7, x$9, x$8);
        scala.collection.immutable.Set x$10 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$11 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"}));
        scala.collection.immutable.Set x$12 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$10, x$12, x$11);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L})), TransactionStateManagerTest.assertListTransactions$default$3$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t5", "t6"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 6L, 8L, 9L})), TransactionStateManagerTest.assertListTransactions$default$3$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t4", "t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit", "CompleteAbort"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{3L, 6L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{10L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})));
        scala.collection.immutable.Set x$13 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$14 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dead"}));
        scala.collection.immutable.Set x$15 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$13, x$15, x$14);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionTimeoutMs()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0)})), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        attemptedAppends.values().foreach((Function1 & Serializable)batches -> {
            batches.foreach((Function1 & Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        void var9_9;
        void var8_8;
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).thenReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partition())));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)var8_8, expiredTransactionalIds);
        Assertions.assertEquals((Object)var9_9, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assertions.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.partition())));
        appendedRecords.values().foreach((Function1 & Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable)batches -> {
            batches.foreach((Function1 & Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1 & Serializable)i -> TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, BoxesRunTime.unboxToInt((Object)i)));
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((IterableOnceOps)((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty()).transactionStates()).asScala().map((Function1 & Serializable)x$22 -> x$22.transactionalId())).filter((Function1 & Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$2(this, transactionalId)))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulReimmigration() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var7_4 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var4_3 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$23, x$24, x$25, x$26) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$23), x$24, x$25, x$26);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable)(x$27, x$28, x$29, x$30) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$27), x$28, x$29, x$30);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        AbstractLog logMock = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$31, x$32, x$33, x$34) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$31), x$32, x$33, x$34);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getLog(this.topicPartition());
        ((AbstractLog)Mockito.verify((Object)logMock)).logStartOffset();
        ((AbstractLog)Mockito.verify((Object)logMock)).read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false));
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).getLogEndOffset(this.topicPartition());
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$35 -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError, x$35);
            return BoxedUnit.UNIT;
        });
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)logConfig.maxMessageSize()).thenReturn((Object)Predef$.MODULE$.int2Integer(maxBatchSize));
        partitionIds.foreach((Function1 & Serializable)partitionId -> TransactionStateManagerTest.$anonfun$expectLogConfig$1(this, logConfig, BoxesRunTime.unboxToInt((Object)partitionId)));
    }

    /*
     * WARNING - void declaration
     */
    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, kafka.log.Defaults$.MODULE$.MaxMessageSize());
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        boolean bl = Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState));
        boolean bl2 = bl;
        if (bl2) {
            MemoryRecords memoryRecords;
            MemoryRecords memoryRecords2;
            void withRecords_records;
            void withRecords_timestampType;
            MemoryRecords memoryRecords3;
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{expectedTombstone};
            CompressionType withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
            byte withRecords_magic = 2;
            TimestampType timestampType = TimestampType.CREATE_TIME;
            long withRecords_initialOffset = 0L;
            MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            timestampType = null;
            memoryRecords3 = null;
            MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
            memoryRecords2 = null;
            MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
            Object var11_11 = null;
            simpleRecordArray = null;
            memoryRecords = null;
            MemoryRecords expectedRecords = memoryRecords6;
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MemoryRecords[]{expectedRecords})), (Object)((IterableOnceOps)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assertions.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var9_5 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var6_4 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        AbstractLog logMock = (AbstractLog)Mockito.mock(AbstractLog.class);
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        Mockito.when((Object)this.replicaManager().getLog(topicPartition)).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(topicPartition)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$36 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
    }

    private void prepareForTxnMessageAppend(Errors error) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        ArgumentCaptor capturedArgument = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)capturedArgument.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$37 -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error, x$37);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getMagic((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionLoadMetric() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var11_8 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var8_7 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$38, x$39, x$40, x$41) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$38), x$39, x$40, x$41);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testTransactionTimeoutMetricCreation() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)0.0, (double)TransactionStateManagerTest.getExpiredTransactionCount$1(server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)this.reporter().containsMbean(mBeanName));
    }

    @Test
    public void testStateErrorMetricCreation() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)0.0, (double)TransactionStateManagerTest.getStateErrorCount$1(server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)this.reporter().containsMbean(mBeanName));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTotalTransactionTimeMetric() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((long)0L, (long)TransactionStateManagerTest.getMaxTotalTime$1(mBeanName, server));
        Assertions.assertTrue((boolean)this.reporter().containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var11_6 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var8_5 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$42, x$43, x$44, x$45) -> {
            TransactionStateManagerTest.$anonfun$testTotalTransactionTimeMetric$1(BoxesRunTime.unboxToInt((Object)x$42), x$43, x$44, x$45);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.time().sleep(1000L);
        Assertions.assertTrue((TransactionStateManagerTest.getMaxTotalTime$1(mBeanName, server) >= 0L ? 1 : 0) != 0);
        TransactionMetadata cachedTxnMetadata1 = (TransactionMetadata)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)0))).metadataPerTransactionalId().get((Object)this.transactionalId1());
        cachedTxnMetadata1.completeTransitionTo(cachedTxnMetadata1.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds()));
        cachedTxnMetadata1.completeTransitionTo(cachedTxnMetadata1.prepareComplete(this.time().milliseconds()));
        Assertions.assertTrue((TransactionStateManagerTest.getMaxTotalTime$1(mBeanName, server) >= 0L ? 1 : 0) != 0);
        TransactionMetadata cachedTxnMetadata2 = (TransactionMetadata)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)0))).metadataPerTransactionalId().get((Object)this.transactionalId2());
        cachedTxnMetadata2.completeTransitionTo(cachedTxnMetadata2.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds()));
        cachedTxnMetadata2.completeTransitionTo(cachedTxnMetadata2.prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((long)0L, (long)TransactionStateManagerTest.getMaxTotalTime$1(mBeanName, server));
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$3(int x$3, TransactionResult x$4, TransactionMetadata x$5, TxnTransitMetadata x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$4(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$5() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$9, TransactionResult x$10, TransactionMetadata x$11, TxnTransitMetadata x$12) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$15) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private final void putTransaction$1(String transactionalId, long producerId, TransactionState state) {
        TransactionMetadata txnMetadata = this.transactionMetadata(transactionalId, producerId, state, this.transactionTimeoutMs());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata).left().toOption().foreach((Function1 & Serializable)error -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Failed to insert transaction ").append(txnMetadata).append(" due to error ").append(error).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testListTransactionsFiltering$4(String state) {
        return TransactionState$.MODULE$.fromName(state).isEmpty();
    }

    private final void assertListTransactions$1(scala.collection.immutable.Set expectedTransactionalIds, scala.collection.immutable.Set filterProducerIds, scala.collection.immutable.Set filterStates) {
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(filterProducerIds, filterStates);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)listResponse.errorCode()));
        Assertions.assertEquals((Object)expectedTransactionalIds, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(listResponse.transactionStates()).asScala().map((Function1 & Serializable)x$17 -> x$17.transactionalId())).toSet());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)filterStates.filter((Function1 & Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testListTransactionsFiltering$4(state)))), (Object)CollectionConverters$.MODULE$.ListHasAsScala(listResponse.unknownStateFilters()).asScala().toSet());
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$2$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$3$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assertions.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$21) {
        return x$21.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assertions.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)batches.forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$21))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assertions.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = new StringBuilder(3).append("id_").append(i).toString();
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, (TransactionState)Empty$.MODULE$, $this.transactionTimeoutMs());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$2(TransactionStateManagerTest $this, String transactionalId) {
        boolean bl;
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            bl = $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$23, TransactionResult x$24, TransactionMetadata x$25, TxnTransitMetadata x$26) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$27, TransactionResult x$28, TransactionMetadata x$29, TxnTransitMetadata x$30) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$31, TransactionResult x$32, TransactionMetadata x$33, TxnTransitMetadata x$34) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(ArgumentCaptor callbackCapture$1, ArgumentCaptor recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1, InvocationOnMock x$35) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((MapOps)recordsCapture$1.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            MemoryRecords records = (MemoryRecords)x0$1._2();
            ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
                void var2_2;
                Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                capturedAppends$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)batches));
                return var2_2;
            })).$plus$eq((Object)records);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L));
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$expectLogConfig$1(TransactionStateManagerTest $this, LogConfig logConfig$1, int partitionId) {
        return Mockito.when((Object)$this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).thenReturn((Object)new Some((Object)logConfig$1));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, ArgumentCaptor capturedArgument$1, Errors error$1, InvocationOnMock x$37) {
        ((Function1)capturedArgument$1.getValue()).apply(scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$38, TransactionResult x$39, TransactionMetadata x$40, TxnTransitMetadata x$41) {
    }

    private static final double getExpiredTransactionCount$1(MBeanServer server$2, String mBeanName$2) {
        return BoxesRunTime.unboxToDouble((Object)server$2.getAttribute(new ObjectName(mBeanName$2), "transaction-timeout-count"));
    }

    private static final double getStateErrorCount$1(MBeanServer server$3, String mBeanName$3) {
        return BoxesRunTime.unboxToDouble((Object)server$3.getAttribute(new ObjectName(mBeanName$3), "transaction-state-error-count"));
    }

    private static final long getMaxTotalTime$1(String mBean, MBeanServer server$4) {
        return BoxesRunTime.unboxToLong((Object)server$4.getAttribute(new ObjectName(mBean), "active-transaction-total-time-max"));
    }

    public static final /* synthetic */ void $anonfun$testTotalTransactionTimeMetric$1(int x$42, TransactionResult x$43, TransactionMetadata x$44, TxnTransitMetadata x$45) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        Mockito.when((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions())));
        this.metrics = new Metrics();
        this.reporter = new JmxReporter();
        this.metricsContext = new KafkaMetricsContext("kafka.server");
        this.reporter().contextChange((MetricsContext)this.metricsContext());
        this.metrics().addReporter((MetricsReporter)this.reporter());
        this.txnConfig = new TransactionConfig(TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs(), TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs(), TransactionLog$.MODULE$.DefaultNumPartitions(), TransactionLog$.MODULE$.DefaultReplicationFactor(), TransactionLog$.MODULE$.DefaultSegmentBytes(), TransactionLog$.MODULE$.DefaultLoadBufferSize(), TransactionLog$.MODULE$.DefaultMinInSyncReplicas(), TransactionLog$.MODULE$.DefaultPlacementConstraints(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs(), Defaults$.MODULE$.RequestTimeoutMs(), (TransactionLoggingVerbosity)TransactionLoggingVerbosity.Off$.MODULE$);
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.expectedError = Errors.NONE;
    }
}

