/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.AuditJobResult;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B A\u0001\u001dCQA\u0014\u0001\u0005\u0002=CqA\u0015\u0001A\u0002\u0013\u00051\u000bC\u0004]\u0001\u0001\u0007I\u0011A/\t\r\r\u0004\u0001\u0015)\u0003U\u0011\u001d!\u0007\u00011A\u0005\u0002\u0015Dq\u0001\u001c\u0001A\u0002\u0013\u0005Q\u000e\u0003\u0004p\u0001\u0001\u0006KA\u001a\u0005\na\u0002\u0001\r\u00111A\u0005\u0002ED\u0011\u0002\u001f\u0001A\u0002\u0003\u0007I\u0011A=\t\u0013m\u0004\u0001\u0019!A!B\u0013\u0011\bb\u0002?\u0001\u0001\u0004%\t! \u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0001\u0003\u000bAq!!\u0003\u0001A\u0003&a\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0001\u0002\u000e!I\u0011Q\b\u0001A\u0002\u0013\u0005\u0011q\b\u0005\t\u0003\u0007\u0002\u0001\u0015)\u0003\u0002\u0010!I\u0011Q\t\u0001A\u0002\u0013\u0005\u0011q\t\u0005\n\u0003/\u0002\u0001\u0019!C\u0001\u00033B\u0001\"!\u0018\u0001A\u0003&\u0011\u0011\n\u0005\n\u0003?\u0002\u0001\u0019!C\u0001\u0003CB\u0011\"a\u001d\u0001\u0001\u0004%\t!!\u001e\t\u0011\u0005e\u0004\u0001)Q\u0005\u0003GB\u0011\"a\u001f\u0001\u0005\u0004%\t!! \t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003\u007fB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\n\"Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011AAL\u0011-\tY\n\u0001a\u0001\u0002\u0003\u0006K!a#\t\u0017\u0005u\u0005\u00011AA\u0002\u0013\u0005\u0011q\u0014\u0005\f\u0003O\u0003\u0001\u0019!a\u0001\n\u0003\tI\u000bC\u0006\u0002.\u0002\u0001\r\u0011!Q!\n\u0005\u0005\u0006bCAX\u0001\u0001\u0007\t\u0019!C\u0001\u0003cC1\"a/\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002>\"Y\u0011\u0011\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BAZ\u0011%\t\u0019\r\u0001b\u0001\n\u0003\t)\r\u0003\u0005\u0002h\u0002\u0001\u000b\u0011BAd\u0011-\tI\u000f\u0001a\u0001\u0002\u0004%\t!a;\t\u0017\u00055\b\u00011AA\u0002\u0013\u0005\u0011q\u001e\u0005\f\u0003g\u0004\u0001\u0019!A!B\u0013\t9\u0003C\u0005\u0002v\u0002\u0001\r\u0011\"\u0001\u0002x\"I\u0011\u0011 \u0001A\u0002\u0013\u0005\u00111 \u0005\t\u0003\u007f\u0004\u0001\u0015)\u0003\u0002R!9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u000e\u0001\u0011\u0005!1\u0001\u0005\b\u0005K\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005\u0007AqAa\r\u0001\t\u0003\u0011\u0019\u0001C\u0004\u00038\u0001!IA!\u000f\t\u000f\tm\u0003\u0001\"\u0001\u0003\u0004!9!q\f\u0001\u0005\u0002\t\r\u0001b\u0002B2\u0001\u0011\u0005!1\u0001\u0005\b\u0005O\u0002A\u0011\u0001B\u0002\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005\u0007AqAa\u001c\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003t\u0001!\tAa\u0001\t\u000f\t]\u0004\u0001\"\u0001\u0003\u0004!9!1\u0010\u0001\u0005\u0002\t\r\u0001b\u0002B@\u0001\u0011\u0005!1\u0001\u0005\b\u0005\u0007\u0003A\u0011\u0001B\u0002\u0011\u001d\u00119\t\u0001C\u0001\u0005\u0007AqAa#\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003\u0010\u0002!\tAa\u0001\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0004\ta\u0011)\u001e3ji*{'\rV3ti*\u0011\u0011IQ\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\u0007\u0012\u000b!\u0002Z;sC\nLG.\u001b;z\u0015\u0005)\u0015!B6bM.\f7\u0001A\n\u0003\u0001!\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001Q!\t\t\u0006!D\u0001A\u0003\u0019awn\u001a#jeV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006\u0011\u0011n\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011a,\u0019\t\u0003\u0013~K!\u0001\u0019&\u0003\tUs\u0017\u000e\u001e\u0005\bE\u000e\t\t\u00111\u0001U\u0003\rAH%M\u0001\bY><G)\u001b:!\u0003)awnZ'b]\u0006<WM]\u000b\u0002MB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eR\u0001\u0004Y><\u0017BA6i\u0005)aunZ'b]\u0006<WM]\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\tqf\u000eC\u0004c\r\u0005\u0005\t\u0019\u00014\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0005i&lW-F\u0001s!\t\u0019h/D\u0001u\u0015\t)H)A\u0003vi&d7/\u0003\u0002xi\nAQj\\2l)&lW-\u0001\u0005uS6,w\fJ3r)\tq&\u0010C\u0004c\u0013\u0005\u0005\t\u0019\u0001:\u0002\u000bQLW.\u001a\u0011\u0002\u0011\u0005,H-\u001b;K_\n,\u0012A \t\u0003#~L1!!\u0001A\u0005!\tU\u000fZ5u\u0015>\u0014\u0017\u0001D1vI&$(j\u001c2`I\u0015\fHc\u00010\u0002\b!9!\rDA\u0001\u0002\u0004q\u0018!C1vI&$(j\u001c2!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA\b!\u0019\t\t\"!\t\u0002(9!\u00111CA\u000f\u001d\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\r\u00061AH]8pizJ\u0011aS\u0005\u0004\u0003?Q\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003G\t)CA\u0002TKFT1!a\bK!\u0011\tI#!\u000f\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\taaY8n[>t'bA#\u00022)!\u00111GA\u001b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qG\u0001\u0004_J<\u0017\u0002BA\u001e\u0003W\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\nu_BL7\rU1si&$\u0018n\u001c8t?\u0012*\u0017\u000fF\u0002_\u0003\u0003B\u0001BY\b\u0002\u0002\u0003\u0007\u0011qB\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\na\u0002]1si&$\u0018n\u001c8UkBdW-\u0006\u0002\u0002JA1\u0011\u0011CA\u0011\u0003\u0017\u0002r!SA'\u0003O\t\t&C\u0002\u0002P)\u0013a\u0001V;qY\u0016\u0014\u0004cA%\u0002T%\u0019\u0011Q\u000b&\u0003\t1{gnZ\u0001\u0013a\u0006\u0014H/\u001b;j_:$V\u000f\u001d7f?\u0012*\u0017\u000fF\u0002_\u00037B\u0001B\u0019\n\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0010a\u0006\u0014H/\u001b;j_:$V\u000f\u001d7fA\u0005AqN\u00196Ti>\u0014X-\u0006\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!B:u_J,'bAA7\t\u0006!A/[3s\u0013\u0011\t\t(a\u001a\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\fAb\u001c2k'R|'/Z0%KF$2AXA<\u0011!\u0011W#!AA\u0002\u0005\r\u0014!C8cUN#xN]3!\u0003\u0015QwNY%e+\t\ty\bE\u0002J\u0003\u0003K1!a!K\u0005\rIe\u000e^\u0001\u0007U>\u0014\u0017\n\u001a\u0011\u0002\u000f5,GO]5dgV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b\t*\u0004\u0002\u0002\u0010*!\u0011qQA\u0016\u0013\u0011\t\u0019*a$\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\rq\u0016\u0011\u0014\u0005\tEj\t\t\u00111\u0001\u0002\f\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\btS6\u0004H.\u001a*fa>\u0014H/\u001a:\u0016\u0005\u0005\u0005\u0006cA)\u0002$&\u0019\u0011Q\u0015!\u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u0003I\u0019\u0018.\u001c9mKJ+\u0007o\u001c:uKJ|F%Z9\u0015\u0007y\u000bY\u000b\u0003\u0005c;\u0005\u0005\t\u0019AAQ\u0003=\u0019\u0018.\u001c9mKJ+\u0007o\u001c:uKJ\u0004\u0013a\u00053ve\u0006\u0014\u0017\u000e\\5us6+GO]5d\u001b\u001e\u0014XCAAZ!\u0011\t),a.\u000e\u0003\tK1!!/C\u0005a!UO]1cS2LG/_'fiJL7m]'b]\u0006<WM]\u0001\u0018IV\u0014\u0018MY5mSRLX*\u001a;sS\u000eluM]0%KF$2AXA`\u0011!\u0011\u0007%!AA\u0002\u0005M\u0016\u0001\u00063ve\u0006\u0014\u0017\u000e\\5us6+GO]5d\u001b\u001e\u0014\b%A\u0007bk\u0012LGo]!mY><X\rZ\u000b\u0003\u0003\u000f\u0004b!!3\u0002T\u0006]WBAAf\u0015\u0011\ti-a4\u0002\u0013%lW.\u001e;bE2,'bAAi\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\u0004'\u0016$\b\u0003BAm\u0003?t1!UAn\u0013\r\ti\u000eQ\u0001\u0015\tV\u0014\u0018MY5mSRL\u0018)\u001e3ji\u000eCWmY6\n\t\u0005\u0005\u00181\u001d\u0002\u0006-\u0006dW/Z\u0005\u0004\u0003KT%aC#ok6,'/\u0019;j_:\fa\"Y;eSR\u001c\u0018\t\u001c7po\u0016$\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0012A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\0%KF$2AXAy\u0011!\u0011W%!AA\u0002\u0005\u001d\u0012a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u0011\u0011\u00147i\u001c8gS\u001e,\"!!\u0015\u0002\u0019\u0011\u00147i\u001c8gS\u001e|F%Z9\u0015\u0007y\u000bi\u0010\u0003\u0005cQ\u0005\u0005\t\u0019AA)\u0003%!'mQ8oM&<\u0007%A\u0003tKR,\u0006\u000fF\u0001_Q\rQ#q\u0001\t\u0005\u0005\u0013\u00119\"\u0004\u0002\u0003\f)!!Q\u0002B\b\u0003\r\t\u0007/\u001b\u0006\u0005\u0005#\u0011\u0019\"A\u0004kkBLG/\u001a:\u000b\t\tU\u0011QG\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00053\u0011YA\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004W\t}\u0001\u0003\u0002B\u0005\u0005CIAAa\t\u0003\f\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0015i\u0016\u001cHoU5na2,wJ\u001a4tKR\u001c6-\u00198)\u00071\u0012I\u0003\u0005\u0003\u0003\n\t-\u0012\u0002\u0002B\u0017\u0005\u0017\u0011A\u0001V3ti\u0006qC/Z:u'&l\u0007\u000f\\3PM\u001a\u001cX\r^*dC:<\u0016\u000e\u001e5Pm\u0016\u0014H.\u00199XSRDG+[3s!>\u0014H/[8oQ\ri#\u0011F\u0001\u001bi\u0016\u001cHoU5na2,G+[3sK\u0012|eMZ:fiN\u001b\u0017M\u001c\u0015\u0004]\t%\u0012\u0001F5oSRL\u0017\r\\5{K2{w-T1oC\u001e,'\u000f\u0006\u0003\u0003<\t]\u0003C\u0002B\u001f\u0005\u000f\u0012Y%\u0004\u0002\u0003@)!!\u0011\tB\"\u0003!\u0019H/\u001e2cS:<'\u0002\u0002B#\u0003k\tq!\\8dW&$x.\u0003\u0003\u0003J\t}\"aD(oO>LgnZ*uk\n\u0014\u0017N\\4\u0011\u000b%\u0013iE!\u0015\n\u0007\t=#J\u0001\u0004PaRLwN\u001c\t\u0004O\nM\u0013b\u0001B+Q\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\u0011If\fa\u0001\u0005#\nA!\u001c'pO\u0006QB/Z:u\u001f\nTWm\u0019;Ti>\u0014XmU3h[\u0016tG\u000fT8tg\"\u001a\u0001G!\u000b\u00027Q,7\u000f\u001e+jKJ\u001cu.\u001c9bGR,Gm\u00142kK\u000e$Hj\\:tQ\r\t$\u0011F\u0001 i\u0016\u001cH\u000fV5fe\u000e{W\u000e]1di\u0016$Gk\u001c9jGZ\u000bG.\u001b3bi\u0016\u001c\bf\u0001\u001a\u0003*\u0005yB/Z:u\u001b&\u001c8/\u001b8h'\u0016<W.\u001a8u\u0013:|%M[3diN#xN]3)\u0007M\u0012I#A\u000fuKN$H*Y4hS:<G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fQ\r!$\u0011F\u0001\u0010i\u0016\u001cH/\u00128e)>,e\u000e\u001a*v]\"\u001aQG!\u000b\u0002GQ,7\u000f^(gMN,GoR1q\u0005\u0016$x/Z3o)&,'/\u00118e\u0019>\u001c\u0017\r\u001c'pO\"\u001aaG!\u000b\u00021Q,7\u000f\u001e+jKJ|eMZ:fi\u001e\u000b\u0007OU3ue&,7\u000fK\u00028\u0005S\ta\u0003^3ti:{g.\u00117jO:,GmU3h[\u0016tGo\u001d\u0015\u0004q\t%\u0012a\u0007;fgR\u001cu.\u001c9bGR,G\rV8qS\u000eL5/\u0011<pS\u0012,G\rK\u0002:\u0005S\t\u0011\u0005^3ti\u000e{W\u000e]1di\u0016$Gk\u001c9jG\u000eC\u0017M\\4fIR{G)\u001a7fi\u0016D3A\u000fB\u0015\u0003\u0005\"Xm\u001d;MCR\u001c\u0007nQ8v]R$wn\u001e8UQJ|wo]#yG\u0016\u0004H/[8oQ\rY$\u0011F\u0001&i\u0016\u001cH/Q;eSRTuNY*mK\u0016\u00048OR8s)&,'OV3sS\u001aL7-\u0019;j_:D3\u0001\u0010B\u0015\u0003!\"Xm\u001d;US\u0016\u0014Hj\\4TK\u001elWM\u001c;D_:4XM]:j_:4uN\u001d,bY&$\u0017\r^8sQ\ri$\u0011F\u0001\u0018i\u0016\u001cHo\u00115fG.\u001cX/\u001c#jg\u0006\u0014G.\u001a+fgRD3A\u0010B\u0015\u0001")
public class AuditJobTest {
    private File logDir = null;
    private LogManager logManager = null;
    private MockTime time;
    private AuditJob auditJob = null;
    private scala.collection.immutable.Seq<TopicPartition> topicPartitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> partitionTuple = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private TierObjectStore objStore = null;
    private final int jobId;
    private Metrics metrics;
    private AuditReporter simpleReporter;
    private DurabilityMetricsManager durabilityMetricMgr;
    private final Set<Enumeration.Value> auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()}));
    private TopicPartition topicPartition;
    private long dbConfig = 0L;

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public AuditJob auditJob() {
        return this.auditJob;
    }

    public void auditJob_$eq(AuditJob x$1) {
        this.auditJob = x$1;
    }

    public scala.collection.immutable.Seq<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(scala.collection.immutable.Seq<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> partitionTuple() {
        return this.partitionTuple;
    }

    public void partitionTuple_$eq(scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> x$1) {
        this.partitionTuple = x$1;
    }

    public TierObjectStore objStore() {
        return this.objStore;
    }

    public void objStore_$eq(TierObjectStore x$1) {
        this.objStore = x$1;
    }

    public int jobId() {
        return this.jobId;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter simpleReporter() {
        return this.simpleReporter;
    }

    public void simpleReporter_$eq(AuditReporter x$1) {
        this.simpleReporter = x$1;
    }

    public DurabilityMetricsManager durabilityMetricMgr() {
        return this.durabilityMetricMgr;
    }

    public void durabilityMetricMgr_$eq(DurabilityMetricsManager x$1) {
        this.durabilityMetricMgr = x$1;
    }

    public Set<Enumeration.Value> auditsAllowed() {
        return this.auditsAllowed;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    public long dbConfig() {
        return this.dbConfig;
    }

    public void dbConfig_$eq(long x$1) {
        this.dbConfig = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.time_$eq(new MockTime());
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.metrics_$eq(new Metrics(new MetricConfig(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), (Time)this.time()));
        this.durabilityMetricMgr_$eq(new DurabilityMetricsManager("0", this.metrics(), (Time)this.time(), DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS()));
        DurabilityMetricsManager apply_metricManager = this.durabilityMetricMgr();
        Object var1_1 = null;
        this.simpleReporter_$eq(new AuditReporter(apply_metricManager));
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        this.topicPartition_$eq(new TopicPartition("some-topic", 1));
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))));
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L))}))));
    }

    @AfterEach
    public void tearDown() {
        if (this.objStore() != null) {
            this.objStore().close();
        }
        this.logManager_$eq(null);
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testSimpleOffsetScan() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("some-topic", 1)}))));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, 0L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), segments, (scala.collection.immutable.Seq<TierLogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleOffsetScanWithOverlapWithTierPortion() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("some-topic", 1)}))));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        TierPartitionState tierPartitionMock = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        File x$1 = this.logDir();
        long l = 0L;
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(x$1, 10L, l, 10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionMock.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        TopicPartition x$5 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$7 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$8 = new Some((Object)tierPartitionMock);
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$9 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$10 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$11 = none$6;
        boolean bl = false;
        boolean bl2 = false;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$5, segments, (scala.collection.immutable.Seq<TierLogSegment>)x$7, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$9, (Option<Object>)x$10, (Option<Object>)x$11, bl, bl2, (Option<TierPartitionState>)x$8);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)22L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleTieredOffsetScan() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testSimpleTieredOffsetScan$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$5 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$6 = none$5;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$6;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, bl, bl2, (Option<TierPartitionState>)x$9);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    private OngoingStubbing<Option<AbstractLog>> initializeLogManager(AbstractLog mLog) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        return Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
    }

    @Test
    public void testObjectStoreSegmentLoss() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testObjectStoreSegmentLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedObjectLoss() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testTierCompactedObjectLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$8;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$7, (Option<Object>)x$8, true, true, (Option<TierPartitionState>)x$9);
        this.initializeLogManager(mlog);
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedTopicValidates() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testTierCompactedTopicValidates$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$8;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$7, (Option<Object>)x$8, true, true, (Option<TierPartitionState>)x$9);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testMissingSegmentInObjectStore() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata((TierLogSegment)tierSegments.head()), this.objStore());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1010L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1010L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLaggingTierPartitionState() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)3000L)), (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testEndToEndRun() {
        long expectedTotalMsgCount = 2004L;
        long expectedGapCount = 0L;
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("some-topic", 1), new TopicPartition("some-topic", 2)}))));
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        Map logMap = ((IterableOnceOps)this.topicPartitions().map((Function1 & Serializable)topicPartition -> {
            File file;
            File file2;
            File file3;
            File file4 = file3 = TestUtils.tempDirectory(null, null);
            file3 = null;
            File file5 = file2 = file4;
            file2 = null;
            File file6 = file = file5;
            file = null;
            File logDir = file6;
            scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)topicPartition, this.objStore(), 0L, 0L);
            tierSegments.foreach((Function1 & Serializable)tierSegment -> {
                AuditJobTest.$anonfun$testEndToEndRun$2(this, tierSegment);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(logDir, 0L, 2000L, 1);
            return new Tuple2(topicPartition, (Object)DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)topicPartition, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)logMap));
        CountDownLatch countdown = new CountDownLatch(1);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), countdown, this.simpleReporter(), 0, (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        this.auditJob().run();
        this.partitionTuple().foreach((Function1 & Serializable)x0$1 -> {
            AuditJobTest.$anonfun$testEndToEndRun$3(this, expectedGapCount, expectedTotalMsgCount, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Assertions.assertEquals((long)0L, (long)countdown.getCount());
    }

    @Test
    public void testOffsetGapBetweenTierAndLocalLog() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testOffsetGapBetweenTierAndLocalLog$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.localLogStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(localLogStartOffset)));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)42L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)42L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierOffsetGapRetries() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        scala.collection.immutable.Seq<TierLogSegment> secondaryTierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 2000L);
        ((IterableOnceOps)tierSegments.$plus$plus(secondaryTierSegments)).foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testTierOffsetGapRetries$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, 4000L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)new Some(tierSegments.$plus$plus(secondaryTierSegments)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testNonAlignedSegments() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)mLog.config()).thenReturn((Object)new LogConfig(new HashMap(), LogConfig$.MODULE$.$lessinit$greater$default$2()));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        Object[] objectArray = new TierLogSegment[3];
        objectArray[0] = LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L);
        objectArray[1] = LogTestUtils$.MODULE$.createTierLogSegment(tid, 11L, 20L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L);
        objectArray[2] = LogTestUtils$.MODULE$.createTierLogSegment(tid, 18L, 31L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L);
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testNonAlignedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Object[] objectArray2 = new LogSegment[3];
        objectArray2[0] = LogTestUtils$.MODULE$.createLocalLogSegment(20L, 30L, this.logDir(), 10, Time.SYSTEM, -1L);
        objectArray2[1] = LogTestUtils$.MODULE$.createLocalLogSegment(31L, 40L, this.logDir(), 10, Time.SYSTEM, -1L);
        objectArray2[2] = LogTestUtils$.MODULE$.createLocalLogSegment(41L, 50L, this.logDir(), 10, Time.SYSTEM, -1L);
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        LogManager qual$2 = this.logManager();
        TopicPartition x$3 = (TopicPartition)this.topicPartitions().head();
        boolean x$4 = qual$2.getLog$default$2();
        Mockito.when((Object)qual$2.getLog(x$3, x$4)).thenReturn((Object)new Some((Object)mlog));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)66L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicIsAvoided() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, 0L, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$3 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        boolean bl = false;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$8;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, segments, (scala.collection.immutable.Seq<TierLogSegment>)x$3, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$6, (Option<Object>)x$7, true, bl, (Option<TierPartitionState>)x$9);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)0L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertFalse((boolean)auditResult.errorOpt().isEmpty());
        Predef$.MODULE$.assert(auditResult.errorOpt().get() instanceof UnsupportedOperationException);
        Assertions.assertTrue((boolean)((Throwable)auditResult.errorOpt().get()).getMessage().contains("is not audited"));
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicChangedToDelete() {
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)ConfigFlag$.MODULE$.OnceCompacted().id()))}))));
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 1000L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testCompactedTopicChangedToDelete$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 1000L, 4000L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, true, true, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), AuditJob$.MODULE$.$lessinit$greater$default$8(), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.config().compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)mLog.tieredLogSegments()).thenReturn((Object)tierSegments.iterator());
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), AuditJob$.MODULE$.$lessinit$greater$default$8(), (Option)None$.MODULE$));
        AuditJobResult auditResult2 = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult2.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult2.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult2.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLatchCountdownThrowsException() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        Object[] objectArray = new TierLogSegment[1];
        objectArray[0] = LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L);
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(0), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        Assertions.assertThrows(InterruptedException.class, () -> this.auditJob().doAuditSafely(mlog, this.dbConfig()), () -> "Expected InterruptedException to be thrown");
    }

    @Test
    public void testAuditJobSleepsForTierVerification() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(AuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE() + 1, (Function0 & Serializable)() -> LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L));
        long beforeAccessTimestamp = this.time().milliseconds();
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), (Option)None$.MODULE$));
        this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)(AuditJob$.MODULE$.SLEEP_TIME_MS() * 2L), (long)(this.time().milliseconds() - beforeAccessTimestamp));
    }

    @Test
    public void testTierLogSegmentConversionForValidator() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        int keyBaseOffset = 44;
        int virtualBaseOffset = 43;
        int endOffset = 55;
        int maxTimestamp = 100;
        int size = 33;
        int firstBatchTimestamp = 30;
        SegmentState segmentState = new SegmentState(0, UUID.randomUUID(), (long)virtualBaseOffset, (long)keyBaseOffset, (long)endOffset, (long)maxTimestamp, (long)firstBatchTimestamp, size, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, true, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, 99L);
        TierLogSegment tierLogSegmentOverlapping = new TierLogSegment(topicIdPartition, segmentState);
        TierObjectMetadata overlappingMetadata = AuditJob$.MODULE$.getTierObjectMetadata(tierLogSegmentOverlapping);
        Assertions.assertEquals((long)keyBaseOffset, (long)overlappingMetadata.baseOffset(), (String)"tier log segment with virtually bounded base offset should return true key base offset in metadata");
        Assertions.assertEquals((long)55L, (long)overlappingMetadata.endOffset());
        Assertions.assertEquals((long)100L, (long)overlappingMetadata.maxTimestamp());
        Assertions.assertEquals((int)33, (int)size);
    }

    @Test
    public void testChecksumDisableTest() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("some-topic", 1)}))));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            AuditJobTest.$anonfun$testChecksumDisableTest$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        this.initializeLogManager(mLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().mayContainTieredData())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().validateChecksum())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.ChecksumValidation())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    public static final /* synthetic */ void $anonfun$testSimpleTieredOffsetScan$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testObjectStoreSegmentLoss$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedObjectLoss$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedTopicValidates$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$2(AuditJobTest $this, TierLogSegment tierSegment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(tierSegment), $this.objStore());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEndToEndRun$3(AuditJobTest $this, long expectedGapCount$1, long expectedTotalMsgCount$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var8_6;
            void var10_7;
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Tuple2 tuple2 = $this.simpleReporter().getDurabilityCounters(topicPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long total = tuple2._1$mcJ$sp();
            long gap = tuple2._2$mcJ$sp();
            Assertions.assertEquals((long)expectedGapCount$1, (long)var10_7, (String)new StringBuilder(19).append("Incorrect gap for: ").append(topicPartition).toString());
            Assertions.assertEquals((long)expectedTotalMsgCount$1, (long)var8_6, (String)new StringBuilder(21).append("Incorrect total for: ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testOffsetGapBetweenTierAndLocalLog$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierOffsetGapRetries$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testNonAlignedSegments$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testCompactedTopicChangedToDelete$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testChecksumDisableTest$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public AuditJobTest() {
        this.jobId = 0;
    }
}

