/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.durability.audit.AuditManager;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditManagerTrait;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityTestUtilConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005=4AAB\u0004\u0001\u001d!)q\u0004\u0001C\u0001A!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003BB!\u0001A\u0003%A\u0005C\u0003C\u0001\u0011\u00053\tC\u0003k\u0001\u0011\u00051N\u0001\tUKN$\u0018)\u001e3ji6\u000bg.Y4fe*\u0011\u0001\"C\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\u0015-\t!\u0002Z;sC\nLG.\u001b;z\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0005\u0001=)\u0012\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011aB\u0005\u00031\u001d\u0011\u0011#Q;eSRl\u0015M\\1hKJ$&/Y5u!\tQR$D\u0001\u001c\u0015\ta2\"A\u0003vi&d7/\u0003\u0002\u001f7\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001\"!\t1\u0002!A\u0003rk\u0016,X-F\u0001%!\r)CFL\u0007\u0002M)\u0011q\u0005K\u0001\u000bG>t7-\u001e:sK:$(BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0003-\nAA[1wC&\u0011QF\n\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u00030smZT\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001C2p]N,X.\u001a:\u000b\u0005M\"\u0014aB2mS\u0016tGo\u001d\u0006\u0003\u0019UR!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO&\u0011!\b\r\u0002\u0010\u0007>t7/^7feJ+7m\u001c:egB\u0019\u0001\u0003\u0010 \n\u0005u\n\"!B!se\u0006L\bC\u0001\t@\u0013\t\u0001\u0015C\u0001\u0003CsR,\u0017AB9vKV,\u0007%A\bhKR\fU\u000fZ5u\u001b\u0006t\u0017mZ3s)\u0015!u\t\u0014+b!\t1R)\u0003\u0002G\u000f\ta\u0011)\u001e3ji6\u000bg.Y4fe\")\u0001\n\u0002a\u0001\u0013\u000611m\u001c8gS\u001e\u0004\"A\u0006&\n\u0005-;!!\u0006#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;D_:4\u0017n\u001a\u0005\u0006\u001b\u0012\u0001\rAT\u0001\u0012e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003J<\u0007CA(S\u001b\u0005\u0001&BA)\f\u0003\u0019\u0019XM\u001d<fe&\u00111\u000b\u0015\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015)F\u00011\u0001W\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0011\u0007A9\u0016,\u0003\u0002Y#\t1q\n\u001d;j_:\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\u000bM$xN]3\u000b\u0005y[\u0011\u0001\u0002;jKJL!\u0001Y.\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016DQA\u0019\u0003A\u0002\r\fA\u0001^5nKB\u0011A\r[\u0007\u0002K*\u0011AD\u001a\u0006\u0003OR\naaY8n[>t\u0017BA5f\u0005\u0011!\u0016.\\3\u0002\u000f\rdW-\u00198VaR\tA\u000e\u0005\u0002\u0011[&\u0011a.\u0005\u0002\u0005+:LG\u000f")
public class TestAuditManager
implements AuditManagerTrait {
    private final ArrayBlockingQueue<ConsumerRecords<byte[], byte[]>> queue;
    private volatile AuditManager instance;
    private ConcurrentHashMap<TopicIdPartition, RegisterPartitionRequest> pendingRegistration;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public Option<AuditManager> initialize(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        return AuditManagerTrait.initialize$((AuditManagerTrait)this, (DurabilityAuditConfig)config, (ReplicaManager)replicaManager, tierObjectStoreOpt, (Time)time);
    }

    public void startAuditManager() {
        AuditManagerTrait.startAuditManager$((AuditManagerTrait)this);
    }

    public void stopAuditManager(boolean shutdown) {
        AuditManagerTrait.stopAuditManager$((AuditManagerTrait)this, (boolean)shutdown);
    }

    public boolean stopAuditManager$default$1() {
        return AuditManagerTrait.stopAuditManager$default$1$((AuditManagerTrait)this);
    }

    public void submitAuditRequest(AuditManagerRequest auditRequest) {
        AuditManagerTrait.submitAuditRequest$((AuditManagerTrait)this, (AuditManagerRequest)auditRequest);
    }

    public void reconfigureConfigValues(String events, String checks) {
        AuditManagerTrait.reconfigureConfigValues$((AuditManagerTrait)this, (String)events, (String)checks);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public AuditManager instance() {
        return this.instance;
    }

    public void instance_$eq(AuditManager x$1) {
        this.instance = x$1;
    }

    public ConcurrentHashMap<TopicIdPartition, RegisterPartitionRequest> pendingRegistration() {
        return this.pendingRegistration;
    }

    public void kafka$durability$audit$AuditManagerTrait$_setter_$pendingRegistration_$eq(ConcurrentHashMap<TopicIdPartition, RegisterPartitionRequest> x$1) {
        this.pendingRegistration = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ArrayBlockingQueue<ConsumerRecords<byte[], byte[]>> queue() {
        return this.queue;
    }

    public AuditManager getAuditManager(DurabilityAuditConfig config, ReplicaManager replicaManagerArg, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        return new AuditManager(this, config, replicaManagerArg, tierObjectStoreOpt, time){
            private final /* synthetic */ TestAuditManager $outer;

            public DurabilityDB getDB() {
                return DbTestUtils$.MODULE$.getDbInstance();
            }

            public DurabilityTopicManager getTopicManager() {
                DurabilityDB x$1 = this.db();
                Some x$2 = new Some(this.$outer.queue());
                BlockingQueue<ConsumerRecords<byte[], byte[]>> x$3 = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2();
                return new DurabilityTopicManager(x$1, x$3, (Option)x$2){
                    private DurabilityTopicConsumer consumerProvider;
                    private DurabilityTopicProducer producerProvider;
                    private volatile byte bitmap$0;
                    private final BlockingQueue topicPartitionQueue$1;
                    private DurabilityDB db$1;
                    private Option resultQueue$1;

                    /*
                     * WARNING - void declaration
                     */
                    private DurabilityTopicConsumer consumerProvider$lzycompute() {
                        synchronized (this) {
                            if ((byte)(this.bitmap$0 & 1) == 0) {
                                void getDurabilityConsumer_resultQueue;
                                Option option = this.resultQueue$1;
                                DurabilityDB getDurabilityConsumer_db = this.db$1;
                                BlockingQueue getDurabilityConsumer_topicPartitionQueue = this.topicPartitionQueue$1;
                                Object var1_3 = null;
                                Object var2_2 = null;
                                option = null;
                                this.consumerProvider = new DurabilityTopicConsumer(getDurabilityConsumer_db, getDurabilityConsumer_topicPartitionQueue, (Option)getDurabilityConsumer_resultQueue){
                                    private KafkaConsumer<byte[], byte[]> consumer;
                                    private volatile boolean bitmap$0;
                                    public final BlockingQueue topicPartitionQueue$2;
                                    private final Option resultQueue$2;

                                    private KafkaConsumer<byte[], byte[]> consumer$lzycompute() {
                                        synchronized (this) {
                                            if (!this.bitmap$0) {
                                                this.consumer = new KafkaConsumer<byte[], byte[]>(this){
                                                    private final /* synthetic */ DurabilityTestUtils$.anon.3 $outer;

                                                    public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
                                                        return (ConsumerRecords)this.$outer.topicPartitionQueue$2.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                                                    }

                                                    public void seek(TopicPartition partition, long offset) {
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toConsumerProperties("dummy"));
                                                    }
                                                };
                                                this.bitmap$0 = true;
                                            }
                                        }
                                        return this.consumer;
                                    }

                                    public KafkaConsumer<byte[], byte[]> consumer() {
                                        if (!this.bitmap$0) {
                                            return this.consumer$lzycompute();
                                        }
                                        return this.consumer;
                                    }

                                    public void processRecords(ConsumerRecords<byte[], byte[]> records) {
                                        Option option = this.resultQueue$2;
                                        if (option instanceof Some) {
                                            BlockingQueue queue = (BlockingQueue)((Some)option).value();
                                            if (records != null) {
                                                queue.put(records);
                                                return;
                                            }
                                        }
                                    }
                                    {
                                        this.topicPartitionQueue$2 = topicPartitionQueue$2;
                                        this.resultQueue$2 = resultQueue$2;
                                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$2, (DurabilityEventsMaterialize)Mockito.mock(DurabilityEventsMaterialize.class));
                                    }
                                };
                                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                            }
                        }
                        this.db$1 = null;
                        this.resultQueue$1 = null;
                        return this.consumerProvider;
                    }

                    public DurabilityTopicConsumer consumerProvider() {
                        if ((byte)(this.bitmap$0 & 1) == 0) {
                            return this.consumerProvider$lzycompute();
                        }
                        return this.consumerProvider;
                    }

                    private DurabilityTopicProducer producerProvider$lzycompute() {
                        synchronized (this) {
                            if ((byte)(this.bitmap$0 & 2) == 0) {
                                BlockingQueue getDurabilityProducer_queue = this.topicPartitionQueue$1;
                                DurabilityTopicConfig getDurabilityProducer_config = DurabilityTestUtils$.MODULE$.getDurabilityConfig();
                                Object var1_2 = null;
                                Object var2_1 = null;
                                this.producerProvider = new DurabilityTopicProducer(getDurabilityProducer_config, getDurabilityProducer_queue){
                                    private KafkaProducer<byte[], byte[]> get;
                                    private KafkaProducer<byte[], byte[]> producer;
                                    private volatile boolean bitmap$0;
                                    public final BlockingQueue queue$1;

                                    private KafkaProducer<byte[], byte[]> producer() {
                                        return this.producer;
                                    }

                                    private KafkaProducer<byte[], byte[]> get$lzycompute() {
                                        synchronized (this) {
                                            if (!this.bitmap$0) {
                                                this.get = this.producer();
                                                this.bitmap$0 = true;
                                            }
                                        }
                                        this.producer = null;
                                        return this.get;
                                    }

                                    public KafkaProducer<byte[], byte[]> get() {
                                        if (!this.bitmap$0) {
                                            return this.get$lzycompute();
                                        }
                                        return this.get;
                                    }
                                    {
                                        this.queue$1 = queue$1;
                                        super(config$1);
                                        this.producer = new KafkaProducer<byte[], byte[]>(this){
                                            private final /* synthetic */ DurabilityTestUtils$.anon.5 $outer;

                                            public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
                                                this.$outer.queue$1.add(DurabilityTestUtils$.MODULE$.kafka$durability$audit$DurabilityTestUtils$$toConsumerRecord(record));
                                                return (Future)Mockito.mock(Future.class);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toProducerProperties("dummy"));
                                            }
                                        };
                                    }
                                };
                                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                            }
                        }
                        return this.producerProvider;
                    }

                    public DurabilityTopicProducer producerProvider() {
                        if ((byte)(this.bitmap$0 & 2) == 0) {
                            return this.producerProvider$lzycompute();
                        }
                        return this.producerProvider;
                    }
                    {
                        this.topicPartitionQueue$1 = topicPartitionQueue$1;
                        this.db$1 = db$1;
                        this.resultQueue$1 = resultQueue$1;
                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$1, (DurabilityEventsMaterialize)Mockito.mock(DurabilityEventsMaterialize.class), DurabilityTestUtils$.MODULE$.internalAdminSupplier(), Time.SYSTEM);
                    }
                };
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(config$2, replicaManagerArg$1, tierObjectStoreOpt$1, time$2);
            }
        };
    }

    public void cleanUp() {
        this.stopAuditManager(this.stopAuditManager$default$1());
        this.queue().clear();
        Option$.MODULE$.apply((Object)this.instance()).foreach((Function1 & Serializable)manager -> {
            DbTestUtils$.MODULE$.cleanup(manager.db());
            return BoxedUnit.UNIT;
        });
        this.instance_$eq(null);
    }

    public TestAuditManager() {
        AuditManagerTrait.$init$((AuditManagerTrait)this);
        this.queue = new ArrayBlockingQueue(DurabilityTestUtilConstants$.MODULE$.TEST_QUEUE_SIZE());
        Statics.releaseFence();
    }
}

