/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.tools.DumpDB$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005u4A!\u0006\f\u0001;!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0003I\u0003BB\u001b\u0001A\u0003%!\u0006C\u00047\u0001\t\u0007I\u0011A\u001c\t\r\u0019\u0003\u0001\u0015!\u00039\u0011\u001d9\u0005A1A\u0005\u0002!Ca!\u0015\u0001!\u0002\u0013I\u0005b\u0002*\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007'\u0002\u0001\u000b\u0011B%\t\u000fQ\u0003!\u0019!C\u0001+\"1\u0011\f\u0001Q\u0001\nYCQA\u0017\u0001\u0005\u0002mCQA\u001b\u0001\u0005\u0002mCQa\u001c\u0001\u0005\u0002mCQ!\u001d\u0001\u0005\u0002mCQa\u001d\u0001\u0005\u0002mCQ!\u001e\u0001\u0005\u0002mCQa\u001e\u0001\u0005\u0002mCQ!\u001f\u0001\u0005\u0002mCQa\u001f\u0001\u0005\u0002m\u0013\u0001\u0003R;sC\nLG.\u001b;z\t\n#Vm\u001d;\u000b\u0005]A\u0012A\u00013c\u0015\tI\"$\u0001\u0006ekJ\f'-\u001b7jifT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u0003Y\t!\u0001\u001e9\u0016\u0003)\u0002\"aK\u001a\u000e\u00031R!!\f\u0018\u0002\r\r|W.\\8o\u0015\tYrF\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b-\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003))\u0007o\\2i\u0007\"\f\u0017N\\\u000b\u0002qA!\u0011H\u0010!D\u001b\u0005Q$BA\u001e=\u0003\u001diW\u000f^1cY\u0016T!!\u0010\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002@u\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u0010B\u0013\t\u0011\u0005EA\u0002J]R\u0004\"a\b#\n\u0005\u0015\u0003#\u0001\u0002'p]\u001e\f1\"\u001a9pG\"\u001c\u0005.Y5oA\u00051A/\u001c9ESJ,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b!![8\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\n!\u0001]:\u0016\u0003Y\u0003\"aJ,\n\u0005a3\"A\u0004)beRLG/[8o'R\fG/Z\u0001\u0004aN\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003q\u0003\"aH/\n\u0005y\u0003#\u0001B+oSRD#\u0001\u00041\u0011\u0005\u0005DW\"\u00012\u000b\u0005\r$\u0017aA1qS*\u0011QMZ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0017'A\u0003kk:LG/\u0003\u0002jE\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0015\tV\u0014\u0018MY5mSRLHIQ%oSR$Vm\u001d;)\u00055a\u0007CA1n\u0013\tq'M\u0001\u0003UKN$\u0018\u0001\f#ve\u0006\u0014\u0017\u000e\\5us\u0012\u00135+\u001a:jC2L'0\u0019;j_:$Um]3sS\u0006d\u0017N_1uS>tG+Z:uQ\tqA.A\u000fEkJ\f'-\u001b7jif$%)\u00138ji\u000eCWmY6Q_&tG/\u001b8hQ\tyA.A\fEkJ\f'-\u001b7jif$%)R7qif$%IR5mK\"\u0012\u0001\u0003\\\u0001$\tV\u0014\u0018MY5mSRLHIQ'vYRL\u0007\u000f\\3QCJ$\u0018\u000e^5p]V\u0003H-\u0019;fQ\t\tB.A\rB!&\u000b5mY3tg&s\u0017J\\5u'R\fG/^:UKN$\bF\u0001\nm\u0003=!U\r\\3uKB\u000b'\u000f^5uS>t\u0007FA\nm\u0003)!U/\u001c9EER+7\u000f\u001e\u0015\u0003)1\u0004")
public class DurabilityDBTest {
    private final TopicPartition tp = new TopicPartition("test", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final PartitionState ps;

    public TopicPartition tp() {
        return this.tp;
    }

    public HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public PartitionState ps() {
        return this.ps;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void DurabilityDBInitTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        Assertions.assertTrue((boolean)db.header().equals((Object)new DbHeader(2, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()))), (String)"Database failed to initialize");
        Assertions.assertEquals((int)db.topicStates().size(), (int)0, (String)"Database failed to initialize");
    }

    @Test
    public void DurabilityDBSerializationDeserializationTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        DurabilityDB newDB = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)newDB.header().equals((Object)db.header()), (String)"Check-pointing and recovery of db not consistent");
        Assertions.assertEquals((Object)newDB.fetchPartitionState(this.tp()).get(), (Object)this.ps(), (String)"PartitionState not preserved after recovery");
    }

    @Test
    public void DurabilityDBInitCheckPointing() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        db.close();
        DurabilityDB newDb = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)db.header().equals((Object)newDb.header()), (String)"Inconsistent db after check pointing in empty state");
        Assertions.assertEquals((Object)newDb.topicStates(), (Object)db.topicStates(), (String)"Inconsistent db after check pointing in empty state");
    }

    @Test
    public void DurabilityDBEmptyDBFile() {
        DurabilityDB$.MODULE$.apply(this.logDir()).dbFile().createNewFile();
        Assertions.assertTrue((boolean)DurabilityDB$.MODULE$.apply(this.logDir()).header().equals((Object)new DbHeader(2, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()))), (String)"Database not in empty state");
    }

    @Test
    public void DurabilityDBMultiplePartitionUpdate() {
        ObjectRef db = ObjectRef.create((Object)DurabilityDB$.MODULE$.apply(this.logDir()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4000).foreach((Function1 & Serializable)ii -> DurabilityDBTest.$anonfun$DurabilityDBMultiplePartitionUpdate$1(this, db, BoxesRunTime.unboxToInt((Object)ii)));
        ((DurabilityDB)db.elem).close();
        db.elem = DurabilityDB$.MODULE$.apply(this.logDir());
        Seq committed = ((DurabilityDB)db.elem).getDurabilityTopicPartitionOffsets();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> {
            TopicPartition id = new TopicPartition(this.tp().topic(), ii);
            Assertions.assertEquals((long)((PartitionState)((DurabilityDB)db$1.elem).fetchPartitionState(id).get()).startOffset(), (long)ii, (String)new StringBuilder(45).append("Failed to get last valid state for partition ").append(ii).toString());
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)committed.apply(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT())), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()), (String)new StringBuilder(54).append("Failed to fetch latest committed offset for partition ").append(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()).toString());
        });
    }

    @Test
    public void APIAccessInInitStatusTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.status_$eq(DbStatus$.MODULE$.Init());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> db.addPartition(this.tp(), this.ps()), ClassTag$.MODULE$.apply(DurabilityDBNotReadyException.class), new Position("DurabilityDBTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void DeletePartition() {
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        void apply_startOffset;
        PartitionState partitionState;
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        TopicPartition id = new TopicPartition(this.tp().topic(), 2);
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = this.epochChain();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 1L;
        int apply_partition = 2;
        PartitionState partitionState2 = partitionState = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config);
        hashMap = null;
        uuid = null;
        partitionState = null;
        PartitionState ps2 = partitionState2;
        db.addPartition(id, ps2);
        Assertions.assertTrue((boolean)((PartitionState)db.fetchPartitionState(this.tp()).get()).equals((Object)this.ps()), (String)"Fetch for partition failed");
        db.deletePartition(this.tp());
        Assertions.assertEquals((Object)db.fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
        db.close();
        Assertions.assertEquals((Object)DurabilityDB$.MODULE$.apply(this.logDir()).fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
    }

    @Test
    public void DumpDbTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        Assertions.assertTrue((boolean)DurabilityDBTest.dumpOutput$1(this.logDir(), this.tp().topic(), Integer.toString(this.tp().partition())).startsWith(new StringBuilder(7).append("Topic: ").append(this.tp().topic()).toString()));
        Assertions.assertTrue((boolean)DurabilityDBTest.dumpOutput$1(this.logDir(), this.tp().topic(), "123").contains("DB doesn't contain partition"));
        Assertions.assertTrue((boolean)DurabilityDBTest.dumpOutput$1(this.logDir(), "invalid-topic", "123").contains("DB doesn't contain Topic"));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$DurabilityDBMultiplePartitionUpdate$1(DurabilityDBTest $this, ObjectRef db$1, int ii) {
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        void apply_startOffset;
        PartitionState partitionState;
        TopicPartition id = new TopicPartition($this.tp().topic(), ii);
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = $this.epochChain();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = ii;
        int apply_partition = id.partition();
        PartitionState partitionState2 = partitionState = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config);
        hashMap = null;
        uuid = null;
        partitionState = null;
        PartitionState ps = partitionState2;
        ((DurabilityDB)db$1.elem).updateDurabilityTopicPartitionOffset(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()));
        return ((DurabilityDB)db$1.elem).addPartition(id, ps);
    }

    private static final String dumpOutput$1(File logDir, String topic, String partition) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpDB$.MODULE$.dump(logDir, topic, partition));
        return out.toString();
    }

    /*
     * WARNING - void declaration
     */
    public DurabilityDBTest() {
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = this.epochChain();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long apply_startOffset = 1L;
        int apply_partition = this.tp().partition();
        this.ps = new PartitionState(apply_partition, apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config);
    }
}

