/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.materialization.Validator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMd\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013u\u0003\u0001\u0019!a\u0001\n\u0013q\u0006\"\u00033\u0001\u0001\u0004\u0005\t\u0015)\u0003R\u0011%)\u0007\u00011AA\u0002\u0013%a\rC\u0005n\u0001\u0001\u0007\t\u0019!C\u0005]\"I\u0001\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001a\u0005\nc\u0002\u0001\r\u00111A\u0005\nID\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0013i\u0004\u0001\u0019!A!B\u0013\u0019\b\"C>\u0001\u0001\u0004\u0005\r\u0011\"\u0003}\u0011-\t9\u0001\u0001a\u0001\u0002\u0004%I!!\u0003\t\u0015\u00055\u0001\u00011A\u0001B\u0003&Q\u0010C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?A1\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0014\u0011-\tI\u0004\u0001a\u0001\u0002\u0004%I!a\u000f\t\u0017\u0005}\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0006\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0005C\u0006\u0002V\u0001\u0001\r\u00111A\u0005\n\u0005]\u0003bCA.\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bB\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\t\u0011\u0005%\u0004\u0001)A\u0005\u0003CB\u0011\"a\u001b\u0001\u0005\u0004%I!a\u0018\t\u0011\u00055\u0004\u0001)A\u0005\u0003CB\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005e\u0004\u0001)A\u0005\u0003gB\u0011\"a\u001f\u0001\u0005\u0004%I!! \t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u007fB\u0011\"!(\u0001\u0005\u0004%I!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC\u0011\"!+\u0001\u0005\u0004%\t!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[C\u0011\"!.\u0001\u0005\u0004%\t!a.\t\u0011\u0005]\u0007\u0001)A\u0005\u0003sC1\"!7\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\\\"Y\u0011q\u001d\u0001A\u0002\u0003\u0007I\u0011AAu\u0011-\ti\u000f\u0001a\u0001\u0002\u0003\u0006K!!8\t\u0017\u0005=\b\u00011AA\u0002\u0013\u0005\u0011\u0011\u001f\u0005\f\u0003s\u0004\u0001\u0019!a\u0001\n\u0003\tY\u0010C\u0006\u0002\u0000\u0002\u0001\r\u0011!Q!\n\u0005M\bb\u0003B\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0007A1B!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0014!Y!q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u0003\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqAa\r\u0001\t\u0003\u0011Y\u0002C\u0004\u0003>\u0001!\tAa\u0007\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003\u001c!9!1\n\u0001\u0005\u0002\tm\u0001b\u0002B(\u0001\u0011\u0005!1\u0004\u0005\b\u0005'\u0002A\u0011\u0001B\u000e\u0011\u001d\u00119\u0006\u0001C\u0001\u00057AqAa\u0017\u0001\t\u0003\u0011Y\u0002C\u0004\u0003`\u0001!\tAa\u0007\t\u000f\t\r\u0004\u0001\"\u0001\u0003\u001c!9!q\r\u0001\u0005\u0002\tm\u0001b\u0002B6\u0001\u0011\u0005!1\u0004\u0005\b\u0005_\u0002A\u0011\u0001B\u000e\u0005}!UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{KR+7\u000f\u001e\u0006\u0003}}\nq\"\\1uKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u0001\u0006\u000b!\u0002Z;sC\nLG.\u001b;z\u0015\u0005\u0011\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001N!\tq\u0005!D\u0001>\u0003\u001diW\r\u001e:jGN,\u0012!\u0015\t\u0003%nk\u0011a\u0015\u0006\u0003\u001fRS!!\u0016,\u0002\r\r|W.\\8o\u0015\t\u0011uK\u0003\u0002Y3\u00061\u0011\r]1dQ\u0016T\u0011AW\u0001\u0004_J<\u0017B\u0001/T\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011qL\u0019\t\u0003\r\u0002L!!Y$\u0003\tUs\u0017\u000e\u001e\u0005\bG\u000e\t\t\u00111\u0001R\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005A!/\u001a9peR,'/F\u0001h!\tA7.D\u0001j\u0015\tQw(A\u0003bk\u0012LG/\u0003\u0002mS\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\fAB]3q_J$XM]0%KF$\"aX8\t\u000f\r4\u0011\u0011!a\u0001O\u0006I!/\u001a9peR,'\u000fI\u0001\t[6\u000bg.Y4feV\t1\u000f\u0005\u0002uk6\tq(\u0003\u0002w\u007f\tAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002\u00195l\u0015M\\1hKJ|F%Z9\u0015\u0005}K\bbB2\n\u0003\u0003\u0005\ra]\u0001\n[6\u000bg.Y4fe\u0002\nA\u0001^5nKV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003!\u0016!B;uS2\u001c\u0018bAA\u0003\u007f\n!A+[7f\u0003!!\u0018.\\3`I\u0015\fHcA0\u0002\f!91\rDA\u0001\u0002\u0004i\u0018!\u0002;j[\u0016\u0004\u0013A\u00013c+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\r\tyaP\u0005\u0005\u00037\t9B\u0001\u0007EkJ\f'-\u001b7jif$%)\u0001\u0004eE~#S-\u001d\u000b\u0004?\u0006\u0005\u0002\u0002C2\u0010\u0003\u0003\u0005\r!a\u0005\u0002\u0007\u0011\u0014\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0002j_*\u0011\u00111G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u00055\"\u0001\u0002$jY\u0016\f!\u0002^7q\t&\u0014x\fJ3r)\ry\u0016Q\b\u0005\tGJ\t\t\u00111\u0001\u0002*\u00059A/\u001c9ESJ\u0004\u0013\u0001\u0004;jKJ|%M[*u_J,WCAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nQa\u001d;pe\u0016T1!a\u0014B\u0003\u0011!\u0018.\u001a:\n\t\u0005M\u0013\u0011\n\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006\u0001B/[3s\u001f\nT7\u000b^8sK~#S-\u001d\u000b\u0004?\u0006e\u0003\u0002C2\u0016\u0003\u0003\u0005\r!!\u0012\u0002\u001bQLWM](cUN#xN]3!\u0003\u001d!x\u000e]5d\u0013\u0012,\"!!\u0019\u0011\t\u0005\r\u0014QM\u0007\u0002)&\u0019\u0011q\r+\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005Y!0\u001a:p)>\u0004\u0018nY%e\u00031QXM]8U_BL7-\u00133!\u0003\r!\b/M\u000b\u0003\u0003g\u0002B!a\u0019\u0002v%\u0019\u0011q\u000f+\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qc\u0001\n!\"\u001a9pG\"\u001c\u0005.Y5o+\t\ty\b\u0005\u0005\u0002\u0002\u0006-\u0015qRAK\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013;\u0015AC2pY2,7\r^5p]&!\u0011QRAB\u0005\u001dA\u0015m\u001d5NCB\u00042ARAI\u0013\r\t\u0019j\u0012\u0002\u0004\u0013:$\bc\u0001$\u0002\u0018&\u0019\u0011\u0011T$\u0003\t1{gnZ\u0001\fKB|7\r[\"iC&t\u0007%\u0001\u0002qgV\u0011\u0011\u0011\u0015\t\u0005\u0003+\t\u0019+\u0003\u0003\u0002&\u0006]!A\u0004)beRLG/[8o'R\fG/Z\u0001\u0004aN\u0004\u0013\u0001\u0002;q\u0013\u0012,\"!!,\u0011\t\u0005=\u0016\u0011W\u0007\u0003\u0003\u001bJA!a\u001e\u0002N\u0005)A\u000f]%eA\u0005aAn\\2bY>3gm]3ugV\u0011\u0011\u0011\u0018\t\u0007\u0003w\u000bY-!5\u000f\t\u0005u\u0016q\u0019\b\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y\"\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015bAAe\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BAg\u0003\u001f\u00141aU3r\u0015\r\tIm\u0012\t\b\r\u0006M\u0017QSAK\u0013\r\t)n\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b1|7-\u00197PM\u001a\u001cX\r^:!\u0003\rawnZ\u000b\u0003\u0003;\u0004B!a8\u0002d6\u0011\u0011\u0011\u001d\u0006\u0004\u00033\f\u0015\u0002BAs\u0003C\u00141\"\u00112tiJ\f7\r\u001e'pO\u00069An\\4`I\u0015\fHcA0\u0002l\"A1MJA\u0001\u0002\u0004\ti.\u0001\u0003m_\u001e\u0004\u0013A\u00037pO6\u000bg.Y4feV\u0011\u00111\u001f\t\u0005\u0003?\f)0\u0003\u0003\u0002x\u0006\u0005(A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fHcA0\u0002~\"A1-KA\u0001\u0002\u0004\t\u00190A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0005\u000b\u0001BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0004\u0005\u0017\t\u0015AB:feZ,'/\u0003\u0003\u0003\u0010\t%!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002`\u0005+A\u0001b\u0019\u0017\u0002\u0002\u0003\u0007!QA\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\tq\fK\u0002/\u0005?\u0001BA!\t\u000305\u0011!1\u0005\u0006\u0005\u0005K\u00119#A\u0002ba&TAA!\u000b\u0003,\u00059!.\u001e9ji\u0016\u0014(b\u0001B\u00173\u0006)!.\u001e8ji&!!\u0011\u0007B\u0012\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aqFa\u000e\u0011\t\t\u0005\"\u0011H\u0005\u0005\u0005w\u0011\u0019CA\u0005BMR,'/R1dQ\u0006yB/Z:u'6\fG\u000e\\3s\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:)\u0007A\u0012\t\u0005\u0005\u0003\u0003\"\t\r\u0013\u0002\u0002B#\u0005G\u0011A\u0001V3ti\u0006qB/Z:u\u0019\u0006\u0014x-\u001a:IS\u001eDw+\u0019;fe6\f'o[\"iC:<Wm\u001d\u0015\u0004c\t\u0005\u0013a\u0007;fgR\u0014VM[3di&|gn\u00144Ti\u0006dWMU3d_J$7\u000fK\u00023\u0005\u0003\nA\u0004^3ti\"\u000bg\u000e\u001a7f'R\fG.\u001a#fY\u0016$XMU3d_J$7\u000fK\u00024\u0005\u0003\n1\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3\u0001\u000eB!\u0003\t\"Xm\u001d;NSN\u001c\u0018N\\4EK2,G/\u001a)beRLG/[8o%\u0016\u001cwN^3ss\"\u001aQG!\u0011\u00021Q,7\u000f^#q_\u000eD7\t[1j]Z\u000bG.\u001b3bi&|g\u000eK\u00027\u0005\u0003\n\u0001\u0005^3tiRKW.\u001a\"bg\u0016$'+\u001a;f]RLwN\u001c,bY&$\u0017\r^5p]\"\u001aqG!\u0011\u0002yQ,7\u000f\u001e+j[\u0016\u0014\u0015m]3e%\u0016$XM\u001c;j_:4\u0016\r\\5eCRLwN\\,ji\"tu\u000eR3mKR,GmU3h[\u0016tG/T3uC\u0012\fG/\u0019\u0015\u0004q\t\u0005\u0013\u0001\r;fgR$\u0016.\\3CCN,GMU3uK:$\u0018n\u001c8WC2LG-\u0019;j_:<\u0016\u000e\u001e5Vg\u0016\u0014H)\u001a7fi&|g\u000eK\u0002:\u0005\u0003\n!\u0004^3ti6K7o]5oO\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3A\u000fB!\u0003q!Xm\u001d;Ti\u0006dW-\u0012<f]R<\u0016\u000e\u001e5pkR$v\u000e]5d\u0013\u0012D3a\u000fB!\u0001")
public class DurabilityEventsMaterializeTest {
    private Metrics metrics;
    private AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    private DurabilityMetricsManager mManager;
    private Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    private DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    private File tmpDir;
    private TierObjectStore tierObjStore;
    private final Uuid topicId = Uuid.randomUuid();
    private final Uuid zeroTopicId = Uuid.ZERO_UUID;
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), new TopicPartition("t1", 1));
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))}));
    private final PartitionState ps;
    private final kafka.tier.TopicIdPartition tpId;
    private final scala.collection.immutable.Seq<Tuple2<Object, Object>> localOffsets;
    private AbstractLog log;
    private LogManager logManager;
    private ReplicaManager replicaManager;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    }

    private void reporter_$eq(AuditReporter x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    public Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    }

    private void time_$eq(Time x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time = x$1;
    }

    public DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    }

    private void db_$eq(DurabilityDB x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db = x$1;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    private TierObjectStore tierObjStore() {
        return this.tierObjStore;
    }

    private void tierObjStore_$eq(TierObjectStore x$1) {
        this.tierObjStore = x$1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private Uuid zeroTopicId() {
        return this.zeroTopicId;
    }

    private TopicIdPartition tp1() {
        return this.tp1;
    }

    private HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    private PartitionState ps() {
        return this.ps;
    }

    public kafka.tier.TopicIdPartition tpId() {
        return this.tpId;
    }

    public scala.collection.immutable.Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time()));
        this.mManager_$eq(new DurabilityMetricsManager("0", this.metrics(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS()));
        DurabilityMetricsManager apply_metricManager = this.mManager();
        Object var1_1 = null;
        this.reporter_$eq(new AuditReporter(apply_metricManager));
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.tierObjStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db());
        Utils.delete((File)this.tmpDir());
        this.tierObjStore().close();
    }

    @Test
    public void testSmallerHighWatermarkChanges() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$1;
            }
        };
        materialize.materializeHighWatermarkChanges(this.tp1().topicPartition(), 2, 30L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)10L, (long)lapse);
        Assertions.assertEquals((long)10L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testLargerHighWatermarkChanges() {
        File file;
        File file2;
        File file3;
        scala.collection.immutable.Seq localOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(10L, 20L), new Tuple2.mcJJ.sp(21L, 30L), new Tuple2.mcJJ.sp(31L, 40L)}));
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tmpDir = file6;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$2;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRejectionOfStaleRecords() {
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_timeMs;
        RetentionChangeEvent retentionChangeEvent;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_size2;
        void apply_timeMs2;
        RetentionChangeEvent retentionChangeEvent2;
        void apply_logStartOffset3;
        void apply_highWatermark3;
        void apply_epoch3;
        void apply_size3;
        void apply_timeMs3;
        RetentionChangeEvent retentionChangeEvent3;
        void apply_config;
        void apply_topicId;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark4;
        void apply_startOffset;
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        long l = 0L;
        Uuid uuid = this.topicId();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 1L;
        int apply_partition = this.tp1().topicPartition().partition();
        uuid = null;
        PartitionState ps1 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark4, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, epochChain, (Uuid)apply_topicId, (long)apply_config);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$3;
            }
        };
        long l9 = -1L;
        long l10 = -1L;
        boolean bl = true;
        long l11 = -1L;
        long l12 = 500L;
        TopicIdPartition apply_id = this.tp1();
        RetentionChangeEvent retentionChangeEvent4 = retentionChangeEvent3 = new RetentionChangeEvent(apply_id, (long)apply_timeMs3, (long)apply_size3, 2, (int)apply_epoch3, (long)apply_highWatermark3, (long)apply_logStartOffset3);
        Object var30_21 = null;
        retentionChangeEvent3 = null;
        RetentionChangeEvent event1 = retentionChangeEvent4;
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        long l13 = -1L;
        long l14 = -1L;
        int n = 2;
        long l15 = -1L;
        long l16 = 1000L;
        TopicIdPartition apply_id2 = this.tp1();
        RetentionChangeEvent retentionChangeEvent5 = retentionChangeEvent2 = new RetentionChangeEvent(apply_id2, (long)apply_timeMs2, (long)apply_size2, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2);
        Object var41_30 = null;
        retentionChangeEvent2 = null;
        RetentionChangeEvent event2 = retentionChangeEvent5;
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 200L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        long l17 = -1L;
        long l18 = -1L;
        int n2 = 3;
        long l19 = -1L;
        long l20 = 1000L;
        TopicIdPartition apply_id3 = this.tp1();
        RetentionChangeEvent retentionChangeEvent6 = retentionChangeEvent = new RetentionChangeEvent(apply_id3, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset);
        Object var52_39 = null;
        retentionChangeEvent = null;
        RetentionChangeEvent event3 = retentionChangeEvent6;
        ConsumerRecord record3 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event3.serializeKey(), (Object)event3.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record3));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleStaleDeleteRecords() {
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_trimmedOffset;
        DeleteRecordsEvent deleteRecordsEvent;
        void apply_config;
        void apply_topicId;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark2;
        void apply_startOffset;
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        long l = 0L;
        Uuid uuid = this.tp1().topicId();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 5L;
        int apply_partition = this.tp1().partition();
        uuid = null;
        PartitionState ps1 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark2, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, epochChain, (Uuid)apply_topicId, (long)apply_config);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$4;
            }
        };
        Set set = DeleteRecordsEvent$.MODULE$.apply$default$6();
        long l9 = 1L;
        long l10 = 60L;
        boolean bl = true;
        long l11 = 15L;
        TopicIdPartition apply_id = this.tp1();
        DeleteRecordsEvent deleteRecordsEvent2 = deleteRecordsEvent = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr);
        Object var26_21 = null;
        set = null;
        deleteRecordsEvent = null;
        DeleteRecordsEvent event = deleteRecordsEvent2;
        ConsumerRecord record = new ConsumerRecord(this.tp1().topic(), this.tp1().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event.serializeKey(), (Object)event.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record));
        Predef$.MODULE$.assert(ps1.committedStartOffset() == 15L);
        Predef$.MODULE$.assert(ps1.highWatermark() == 100L);
        Predef$.MODULE$.assert(ps1.latestEpoch() == 2);
        Predef$.MODULE$.assert(ps1.startOffset() == 5L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletePartition() {
        void apply_epoch;
        DeletePartitionEvent deletePartitionEvent;
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$);
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$1(testAuditManager)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this.replicaManager(), testAuditManager.instance().db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        int n = 3;
        TopicIdPartition apply_id = this.tp1();
        DeletePartitionEvent deletePartitionEvent2 = deletePartitionEvent = new DeletePartitionEvent(apply_id, 2, (int)apply_epoch);
        Object var6_7 = null;
        deletePartitionEvent = null;
        DeletePartitionEvent evt = deletePartitionEvent2;
        materialize.materializeDeletePartition(evt);
        Assertions.assertEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingDeletePartitionRecovery() {
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_version;
        void apply_isr2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_version2;
        EpochChangeEvent epochChangeEvent;
        File file;
        File file2;
        File file3;
        scala.collection.immutable.Seq localOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(10L, 20L), new Tuple2.mcJJ.sp(21L, 30L), new Tuple2.mcJJ.sp(31L, 40L)}));
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tmpDir = file6;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$5;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        long apply_firstOffset = 0L;
        EpochChangeEvent epochChangeEvent2 = epochChangeEvent = new EpochChangeEvent(tp, apply_firstOffset, (int)apply_version2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (Set)apply_isr2);
        set = null;
        epochChangeEvent = null;
        EpochChangeEvent epochChangeEvent3 = epochChangeEvent2;
        materialize.checkMissingTopicDeletion((AbstractDurabilityEvent)epochChangeEvent3, this.ps());
        materialize.materializeEpochChangeEvent(epochChangeEvent3, this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 0, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Set set2 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l3 = 0L;
        long l4 = 80L;
        boolean bl3 = false;
        boolean bl4 = false;
        long apply_firstOffset2 = 0L;
        set2 = null;
        materialize.materializeEpochChangeEvent(new EpochChangeEvent(tp, apply_firstOffset2, (int)apply_version, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr), this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)101L, (long)this.mManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEpochChainValidation() {
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        IsrExpandEvent isrExpandEvent;
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        File file;
        File file2;
        File file3;
        scala.collection.immutable.Seq localOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(10L, 20L), new Tuple2.mcJJ.sp(21L, 30L), new Tuple2.mcJJ.sp(31L, 40L)}));
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tmpDir = file6;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        boolean bl8 = true;
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)props, bl8);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(config, logManager);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(replicaManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        long l = this.ps().committedStartOffset();
        long l2 = this.ps().highWatermark();
        int n6 = 3;
        int apply_expandBrokerId = 1;
        IsrExpandEvent isrExpandEvent2 = isrExpandEvent = new IsrExpandEvent(tp, apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset);
        isrExpandEvent = null;
        IsrExpandEvent evt = isrExpandEvent2;
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private scala.collection.immutable.Seq<EpochEntry> epochs;
            private final File file;

            private scala.collection.immutable.Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(scala.collection.immutable.Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Iterable<EpochEntry> epochs) {
                this.epochs_$eq((scala.collection.immutable.Seq<EpochEntry>)epochs.toSeq());
            }

            public byte[] toByteArray(Seq<EpochEntry> epochs) {
                throw new UnsupportedOperationException();
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
                this.file = TestUtils.tempFile();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp.topicPartition(), checkpoint);
        cache.assign(0, 0L);
        cache.assign(1, 11L);
        cache.assign(2, 21L);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)Option$.MODULE$.apply((Object)cache));
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        cache.assign(2, 15L);
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeBasedRetentionValidation() {
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        StartOffsetChangeEvent startOffsetChangeEvent;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_size;
        void apply_timeMs;
        RetentionChangeEvent retentionChangeEvent;
        void apply_isr2;
        void apply_retentionValue2;
        void apply_retentionType2;
        void apply_logStartOffset3;
        void apply_highWatermark3;
        void apply_epoch3;
        StartOffsetChangeEvent startOffsetChangeEvent2;
        void apply_isr3;
        void apply_retentionValue3;
        void apply_retentionType3;
        void apply_logStartOffset4;
        void apply_highWatermark4;
        void apply_epoch4;
        StartOffsetChangeEvent startOffsetChangeEvent3;
        void apply_isr4;
        void apply_retentionValue4;
        void apply_retentionType4;
        void apply_logStartOffset5;
        void apply_highWatermark5;
        void apply_epoch5;
        StartOffsetChangeEvent startOffsetChangeEvent4;
        void apply_isr5;
        void apply_retentionValue5;
        void apply_retentionType5;
        void apply_logStartOffset6;
        void apply_highWatermark6;
        void apply_epoch6;
        StartOffsetChangeEvent startOffsetChangeEvent5;
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(201L, 300L), new Tuple2.mcJJ.sp(301L, 400L), new Tuple2.mcJJ.sp(401L, 500L)}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int n = 10;
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, n, x$4, x$5);
            return logSegment;
        });
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(10L, 100L), new Tuple2.mcJJ.sp(101L, 150L), new Tuple2.mcJJ.sp(151L, 200L)}))).map((Function1 & Serializable)x0$2 -> {
            TierObjectMetadata.State state;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State state2 = state = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
            state = null;
            TierObjectMetadata.State x$12 = state2;
            long l = 1L;
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, l);
            return tierLogSegment;
        });
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$6;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, 1L)));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        Set set = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l = this.ps().retentionMs();
        byte by = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l2 = 5L;
        long l3 = this.ps().highWatermark();
        int n = this.ps().latestEpoch();
        TopicIdPartition apply_id = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent6 = startOffsetChangeEvent5 = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch6, (long)apply_highWatermark6, (long)apply_logStartOffset6, (byte)apply_retentionType5, (long)apply_retentionValue5, (Set)apply_isr5);
        Object var25_18 = null;
        set = null;
        startOffsetChangeEvent5 = null;
        StartOffsetChangeEvent evt = startOffsetChangeEvent6;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)5L);
        Set set2 = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l4 = this.ps().retentionMs();
        byte by2 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l5 = 20L;
        long l6 = this.ps().highWatermark();
        int n2 = this.ps().latestEpoch();
        TopicIdPartition apply_id2 = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent7 = startOffsetChangeEvent4 = new StartOffsetChangeEvent(apply_id2, 2, (int)apply_epoch5, (long)apply_highWatermark5, (long)apply_logStartOffset5, (byte)apply_retentionType4, (long)apply_retentionValue4, (Set)apply_isr4);
        Object var36_29 = null;
        set2 = null;
        startOffsetChangeEvent4 = null;
        evt = startOffsetChangeEvent7;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple22 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long lapse2 = tuple22._2$mcJ$sp();
        Assertions.assertEquals((long)15L, (long)lapse2);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)20L);
        Set set3 = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l7 = this.ps().retentionMs();
        byte by3 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l8 = 21L;
        long l9 = this.ps().highWatermark();
        int n3 = this.ps().latestEpoch();
        TopicIdPartition apply_id3 = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent8 = startOffsetChangeEvent3 = new StartOffsetChangeEvent(apply_id3, 2, (int)apply_epoch4, (long)apply_highWatermark4, (long)apply_logStartOffset4, (byte)apply_retentionType3, (long)apply_retentionValue3, (Set)apply_isr3);
        Object var47_39 = null;
        set3 = null;
        startOffsetChangeEvent3 = null;
        evt = startOffsetChangeEvent8;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple23 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        long lapse3 = tuple23._2$mcJ$sp();
        Assertions.assertEquals((long)16L, (long)lapse3);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)21L);
        Set set4 = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l10 = this.ps().retentionMs() / 2L;
        byte by4 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l11 = 25L;
        long l12 = this.ps().highWatermark();
        int n4 = this.ps().latestEpoch();
        TopicIdPartition apply_id4 = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent9 = startOffsetChangeEvent2 = new StartOffsetChangeEvent(apply_id4, 2, (int)apply_epoch3, (long)apply_highWatermark3, (long)apply_logStartOffset3, (byte)apply_retentionType2, (long)apply_retentionValue2, (Set)apply_isr2);
        Object var58_49 = null;
        set4 = null;
        startOffsetChangeEvent2 = null;
        evt = startOffsetChangeEvent9;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        long l13 = -1L;
        long l14 = -1L;
        int n5 = this.ps().latestEpoch();
        long l15 = -1L;
        long l16 = 1000L;
        TopicIdPartition apply_id5 = this.tp1();
        RetentionChangeEvent retentionChangeEvent2 = retentionChangeEvent = new RetentionChangeEvent(apply_id5, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2);
        Object var69_56 = null;
        retentionChangeEvent = null;
        RetentionChangeEvent evt2 = retentionChangeEvent2;
        materialize.materializeRetentionChangeEvent(evt2, this.ps());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        Set set5 = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l17 = this.ps().retentionMs() / 2L;
        byte by5 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l18 = 30L;
        long l19 = this.ps().highWatermark();
        int n6 = this.ps().latestEpoch();
        TopicIdPartition apply_id6 = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent10 = startOffsetChangeEvent = new StartOffsetChangeEvent(apply_id6, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr);
        Object var80_65 = null;
        set5 = null;
        startOffsetChangeEvent = null;
        evt = startOffsetChangeEvent10;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)30L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeBasedRetentionValidationWithNoDeletedSegmentMetadata() {
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        StartOffsetChangeEvent startOffsetChangeEvent;
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(201L, 300L), new Tuple2.mcJJ.sp(301L, 400L), new Tuple2.mcJJ.sp(401L, 500L)}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int n = 10;
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, n, x$4, x$5);
            return logSegment;
        });
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(151L, 200L)}))).map((Function1 & Serializable)x0$2 -> {
            TierObjectMetadata.State state;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State state2 = state = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
            state = null;
            TierObjectMetadata.State x$12 = state2;
            long l = 1L;
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, l);
            return tierLogSegment;
        });
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$7;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp);
        Set set = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l = this.ps().retentionMs();
        byte by = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l2 = 221L;
        long l3 = this.ps().highWatermark();
        int n = this.ps().latestEpoch();
        TopicIdPartition apply_id = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent2 = startOffsetChangeEvent = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr);
        Object var15_16 = null;
        set = null;
        startOffsetChangeEvent = null;
        StartOffsetChangeEvent evt = startOffsetChangeEvent2;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)221L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeBasedRetentionValidationWithUserDeletion() {
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        StartOffsetChangeEvent startOffsetChangeEvent;
        void apply_isr2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_trimmedOffset;
        DeleteRecordsEvent deleteRecordsEvent;
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(201L, 300L), new Tuple2.mcJJ.sp(301L, 400L), new Tuple2.mcJJ.sp(401L, 500L)}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int n = 10;
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, n, x$4, x$5);
            return logSegment;
        });
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(10L, 100L), new Tuple2.mcJJ.sp(101L, 150L), new Tuple2.mcJJ.sp(151L, 200L)}))).map((Function1 & Serializable)x0$2 -> {
            TierObjectMetadata.State state;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State state2 = state = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
            state = null;
            TierObjectMetadata.State x$12 = state2;
            long l = 1L;
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, l);
            return tierLogSegment;
        });
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$);
        DurabilityDB db = (DurabilityDB)Mockito.mock(DurabilityDB.class);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, db, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$8;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, 1L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.ps().highWatermark()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        Set set = DeleteRecordsEvent$.MODULE$.apply$default$6();
        long l = 0L;
        long l2 = this.ps().highWatermark();
        int n = this.ps().latestEpoch();
        long l3 = 5L;
        TopicIdPartition apply_id = this.tp1();
        DeleteRecordsEvent deleteRecordsEvent2 = deleteRecordsEvent = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (Set)apply_isr2);
        Object var20_18 = null;
        set = null;
        deleteRecordsEvent = null;
        DeleteRecordsEvent delEvent = deleteRecordsEvent2;
        materialize.materializeDeleteRecordEvent(delEvent, this.ps(), materialize.materializeDeleteRecordEvent$default$3(), materialize.materializeDeleteRecordEvent$default$4());
        Set set2 = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l4 = this.ps().retentionMs();
        byte by = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l5 = 5L;
        long l6 = this.ps().highWatermark();
        int n2 = this.ps().latestEpoch();
        TopicIdPartition apply_id2 = this.tp1();
        StartOffsetChangeEvent startOffsetChangeEvent2 = startOffsetChangeEvent = new StartOffsetChangeEvent(apply_id2, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr);
        Object var30_27 = null;
        set2 = null;
        startOffsetChangeEvent = null;
        StartOffsetChangeEvent evt = startOffsetChangeEvent2;
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 != null) {
            long lapse = tuple2._2$mcJ$sp();
            Assertions.assertEquals((long)0L, (long)lapse);
            return;
        }
        throw new MatchError(null);
    }

    @Test
    public void testMissingDeletePartition() {
        Uuid exclusiveRandomUUID1 = Uuid.randomUuid();
        Uuid exclusiveRandomUUID2 = Uuid.randomUuid();
        while (true) {
            Uuid uuid = exclusiveRandomUUID1;
            if (uuid != null ? !uuid.equals(exclusiveRandomUUID2) : exclusiveRandomUUID2 != null) break;
            exclusiveRandomUUID2 = Uuid.randomUuid();
        }
        TopicIdPartition tt1 = new TopicIdPartition(exclusiveRandomUUID1, new TopicPartition("test-topic", 0));
        TopicIdPartition tt2 = new TopicIdPartition(exclusiveRandomUUID2, new TopicPartition("test-topic", 0));
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$);
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt1, 1, true));
        testAuditManager.instance().doWork();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$1(testAuditManager)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        Option option = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            Assertions.assertEquals((int)1, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID1, (Object)value.topicId());
        } else {
            Predef$.MODULE$.assert(false);
        }
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt2, 2, true));
        testAuditManager.instance().doWork();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$3(testAuditManager)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
        Option option2 = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option2 instanceof Some) {
            PartitionState value = (PartitionState)((Some)option2).value();
            Assertions.assertEquals((int)2, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID2, (Object)value.topicId());
            return;
        }
        Predef$.MODULE$.assert(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStaleEventWithoutTopicId() {
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        RetentionChangeEvent retentionChangeEvent;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_size2;
        void apply_timeMs;
        RetentionChangeEvent retentionChangeEvent2;
        void apply_config;
        void apply_topicId;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark3;
        void apply_startOffset;
        TopicIdPartition zeroTp1 = new TopicIdPartition(this.zeroTopicId(), new TopicPartition(this.tp1().topic(), this.tp1().partition()));
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        long l = 0L;
        Uuid uuid = this.topicId();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 1L;
        int apply_partition = this.tp1().topicPartition().partition();
        uuid = null;
        PartitionState ps1 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark3, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, epochChain, (Uuid)apply_topicId, (long)apply_config);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$9;
            }
        };
        long l9 = -1L;
        long l10 = -1L;
        int n = 3;
        long l11 = -1L;
        long l12 = 1000L;
        TopicIdPartition apply_id = this.tp1();
        RetentionChangeEvent retentionChangeEvent3 = retentionChangeEvent2 = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size2, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2);
        Object var29_22 = null;
        retentionChangeEvent2 = null;
        RetentionChangeEvent event1 = retentionChangeEvent3;
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
        long l13 = -1L;
        long l14 = -1L;
        int n2 = 4;
        long l15 = -1L;
        long apply_timeMs2 = 1000L;
        RetentionChangeEvent retentionChangeEvent4 = retentionChangeEvent = new RetentionChangeEvent(zeroTp1, apply_timeMs2, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset);
        retentionChangeEvent = null;
        RetentionChangeEvent event2 = retentionChangeEvent4;
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartition$1(TestAuditManager testAuditManager$1) {
        return testAuditManager$1.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$1(TestAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$3(TestAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$4() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public DurabilityEventsMaterializeTest() {
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = this.epochChain();
        long l2 = 1024L;
        long l3 = 36000000L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 40L;
        long apply_startOffset = 0L;
        int apply_partition = this.tp1().topicPartition().partition();
        hashMap = null;
        uuid = null;
        this.ps = new PartitionState(apply_partition, apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config);
        this.tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        this.localOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(10L, 20L), new Tuple2.mcJJ.sp(21L, 30L), new Tuple2.mcJJ.sp(31L, 40L)}));
    }
}

