/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicProducer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005i3A!\u0004\b\u0001+!)A\u0004\u0001C\u0001;!9q\u0002\u0001b\u0001\n\u0003\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011%\u0001\u0004\u00011AA\u0002\u0013\u0005\u0011\u0007C\u00058\u0001\u0001\u0007\t\u0019!C\u0001q!Ia\b\u0001a\u0001\u0002\u0003\u0006KA\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u001d\u0002!\t\u0001\u0011\u0005\u0006'\u0002!\t\u0001\u0011\u0005\u00061\u0002!\t\u0001\u0011\u0002\u001b\tV\u0014\u0018MY5mSRLHk\u001c9jG6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u001fA\tQ\u0001^8qS\u000eT!!\u0005\n\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\ta\"F\u0001\"!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0005qCJ$\u0018\u000e^5p]V\tA\u0006\u0005\u0002\u0018[%\u0011a\u0006\u0007\u0002\u0004\u0013:$\u0018A\u00039beRLG/[8oA\u0005\u0011AMY\u000b\u0002eA\u00111'N\u0007\u0002i)\u0011\u0001\u0007E\u0005\u0003mQ\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000ba\u0001\u001a2`I\u0015\fHCA\u001d=!\t9\"(\u0003\u0002<1\t!QK\\5u\u0011\u001dit!!AA\u0002I\n1\u0001\u001f\u00132\u0003\r!'\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u0012\u0011B\u0011\t\u0003\u00072k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1!\u00199j\u0015\t9\u0005*A\u0004kkBLG/\u001a:\u000b\u0005%S\u0015!\u00026v]&$(\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#A\u0003)\u0011\u0005\r\u000b\u0016B\u0001*E\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0010CCNL7\rR;sC\nLG.\u001b;z)>\u0004\u0018nY'b]\u0006<WM\u001d+fgRD#aC+\u0011\u0005\r3\u0016BA,E\u0005\u0011!Vm\u001d;\u0002AQ{\u0007/[2NC:\fw-\u001a:Qe>$WoY3s\u0007>t7/^7feR+7\u000f\u001e\u0015\u0003\u0019U\u0003")
public class DurabilityTopicManagerTest {
    private final String topic;
    private final int partition;
    private DurabilityDB db;

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.db());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicDurabilityTopicManagerTest() {
        void getDurabilityTopicManager_resultQueue;
        None$ none$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$3 = none$2;
        BlockingQueue<ConsumerRecords<byte[], byte[]>> getDurabilityTopicManager_topicPartitionQueue = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2();
        DurabilityDB getDurabilityTopicManager_db = this.db();
        Object var2_4 = null;
        Object var3_3 = null;
        none$3 = null;
        DurabilityTopicManager manager = new DurabilityTopicManager(getDurabilityTopicManager_db, getDurabilityTopicManager_topicPartitionQueue, (Option)getDurabilityTopicManager_resultQueue){
            private DurabilityTopicConsumer consumerProvider;
            private DurabilityTopicProducer producerProvider;
            private volatile byte bitmap$0;
            private final BlockingQueue topicPartitionQueue$1;
            private DurabilityDB db$1;
            private Option resultQueue$1;

            /*
             * WARNING - void declaration
             */
            private DurabilityTopicConsumer consumerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        void getDurabilityConsumer_resultQueue;
                        Option option = this.resultQueue$1;
                        DurabilityDB getDurabilityConsumer_db = this.db$1;
                        BlockingQueue getDurabilityConsumer_topicPartitionQueue = this.topicPartitionQueue$1;
                        Object var1_3 = null;
                        Object var2_2 = null;
                        option = null;
                        this.consumerProvider = new DurabilityTopicConsumer(getDurabilityConsumer_db, getDurabilityConsumer_topicPartitionQueue, (Option)getDurabilityConsumer_resultQueue){
                            private KafkaConsumer<byte[], byte[]> consumer;
                            private volatile boolean bitmap$0;
                            public final BlockingQueue topicPartitionQueue$2;
                            private final Option resultQueue$2;

                            private KafkaConsumer<byte[], byte[]> consumer$lzycompute() {
                                synchronized (this) {
                                    if (!this.bitmap$0) {
                                        this.consumer = new KafkaConsumer<byte[], byte[]>(this){
                                            private final /* synthetic */ DurabilityTestUtils$.anon.3 $outer;

                                            public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
                                                return (ConsumerRecords)this.$outer.topicPartitionQueue$2.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                                            }

                                            public void seek(TopicPartition partition, long offset) {
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toConsumerProperties("dummy"));
                                            }
                                        };
                                        this.bitmap$0 = true;
                                    }
                                }
                                return this.consumer;
                            }

                            public KafkaConsumer<byte[], byte[]> consumer() {
                                if (!this.bitmap$0) {
                                    return this.consumer$lzycompute();
                                }
                                return this.consumer;
                            }

                            public void processRecords(ConsumerRecords<byte[], byte[]> records) {
                                Option option = this.resultQueue$2;
                                if (option instanceof Some) {
                                    BlockingQueue queue = (BlockingQueue)((Some)option).value();
                                    if (records != null) {
                                        queue.put(records);
                                        return;
                                    }
                                }
                            }
                            {
                                this.topicPartitionQueue$2 = topicPartitionQueue$2;
                                this.resultQueue$2 = resultQueue$2;
                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$2, (DurabilityEventsMaterialize)Mockito.mock(DurabilityEventsMaterialize.class));
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                this.db$1 = null;
                this.resultQueue$1 = null;
                return this.consumerProvider;
            }

            public DurabilityTopicConsumer consumerProvider() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.consumerProvider$lzycompute();
                }
                return this.consumerProvider;
            }

            private DurabilityTopicProducer producerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        BlockingQueue getDurabilityProducer_queue = this.topicPartitionQueue$1;
                        DurabilityTopicConfig getDurabilityProducer_config = DurabilityTestUtils$.MODULE$.getDurabilityConfig();
                        Object var1_2 = null;
                        Object var2_1 = null;
                        this.producerProvider = new DurabilityTopicProducer(getDurabilityProducer_config, getDurabilityProducer_queue){
                            private KafkaProducer<byte[], byte[]> get;
                            private KafkaProducer<byte[], byte[]> producer;
                            private volatile boolean bitmap$0;
                            public final BlockingQueue queue$1;

                            private KafkaProducer<byte[], byte[]> producer() {
                                return this.producer;
                            }

                            private KafkaProducer<byte[], byte[]> get$lzycompute() {
                                synchronized (this) {
                                    if (!this.bitmap$0) {
                                        this.get = this.producer();
                                        this.bitmap$0 = true;
                                    }
                                }
                                this.producer = null;
                                return this.get;
                            }

                            public KafkaProducer<byte[], byte[]> get() {
                                if (!this.bitmap$0) {
                                    return this.get$lzycompute();
                                }
                                return this.get;
                            }
                            {
                                this.queue$1 = queue$1;
                                super(config$1);
                                this.producer = new KafkaProducer<byte[], byte[]>(this){
                                    private final /* synthetic */ DurabilityTestUtils$.anon.5 $outer;

                                    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
                                        this.$outer.queue$1.add(DurabilityTestUtils$.MODULE$.kafka$durability$audit$DurabilityTestUtils$$toConsumerRecord(record));
                                        return (Future)Mockito.mock(Future.class);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toProducerProperties("dummy"));
                                    }
                                };
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.producerProvider;
            }

            public DurabilityTopicProducer producerProvider() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.producerProvider$lzycompute();
                }
                return this.producerProvider;
            }
            {
                this.topicPartitionQueue$1 = topicPartitionQueue$1;
                this.db$1 = db$1;
                this.resultQueue$1 = resultQueue$1;
                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$1, (DurabilityEventsMaterialize)Mockito.mock(DurabilityEventsMaterialize.class), DurabilityTestUtils$.MODULE$.internalAdminSupplier(), Time.SYSTEM);
            }
        };
        Assertions.assertFalse((boolean)manager.isReady());
        manager.start();
        Assertions.assertTrue((boolean)manager.consumerProvider().isReady());
        Assertions.assertTrue((boolean)manager.isReady());
        manager.shutdown();
        Assertions.assertTrue((boolean)manager.isShutdown());
        Assertions.assertFalse((boolean)manager.consumerProvider().isReady());
    }

    @Test
    public void TopicManagerProducerConsumerTest() {
        TopicIdPartition tpid = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 50));
        int epoch = 0;
        ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(32);
        DurabilityDB x$1 = this.db();
        Some x$2 = new Some(resultQueue);
        BlockingQueue<ConsumerRecords<byte[], byte[]>> x$3 = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2();
        DurabilityTopicManager manager = new /* invalid duplicate definition of identical inner class */;
        manager.database().addPartition(tpid.topicPartition(), PartitionState$.MODULE$.apply(tpid.topicPartition().partition(), 0L));
        manager.start();
        manager.addDurabilityEvent((AbstractDurabilityEvent)OffsetChangeEvent$.MODULE$.apply(tpid, epoch, 100L, 0L));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityTopicManagerTest.$anonfun$TopicManagerProducerConsumerTest$1(resultQueue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        manager.shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$TopicManagerProducerConsumerTest$1(ArrayBlockingQueue resultQueue$1) {
        return resultQueue$1.size() == 1;
    }

    public static final /* synthetic */ String $anonfun$TopicManagerProducerConsumerTest$2() {
        return "";
    }

    public DurabilityTopicManagerTest() {
        this.topic = "test-topic";
        this.partition = 50;
    }
}

