/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.LogManager;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ResultOrError;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r-f!\u0002)R\u0003\u00031\u0006\"B/\u0001\t\u0003q\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007S\u0002\u0001\u000b\u0011B2\t\u000f)\u0004\u0001\u0019!C\u0001W\"9Q\u000f\u0001a\u0001\n\u00031\bB\u0002?\u0001A\u0003&A\u000eC\u0004~\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005E\u0001\u0001)A\u0005\u007f\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\n\u0003S\u0001\u0001\u0019!C\u0001\u0003WA\u0011\"!\u000f\u0001\u0001\u0004%\t!a\u000f\t\u0011\u0005}\u0002\u0001)Q\u0005\u0003[A\u0011\"!\u0011\u0001\u0001\u0004%I!a\u0011\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u0005\u001d\u0003\u0002CA&\u0001\u0001\u0006K!a\r\t\r\u00055\u0003A\"\u0001l\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0015\u0001\t\u0003\t\t\u0006\u0003\u0004\u0002V\u0001!\ta\u001b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u0013\u0005-\u0006!%A\u0005\u0002\u00055\u0006bBAb\u0001\u0011E\u0011Q\u0019\u0005\b\u0003\u001f\u0003A\u0011CAl\u0011\u001d\tI\u000e\u0001C\t\u00037Dq!a<\u0001\t#\t\t\u0010C\u0004\u0003\u0002\u0001!\t\"!=\t\u000f\t\r\u0001\u0001\"\u0005\u0003\u0006!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u001e\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0005{\u0001A\u0011IA)\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013B\u0011Ba\u0015\u0001#\u0003%\tA!\u0016\t\u0013\te\u0003!%A\u0005\u0002\tU\u0003b\u0002B.\u0001\u0011\u0005!Q\f\u0005\n\u0005K\u0002\u0011\u0013!C\u0001\u0003[C\u0011Ba\u001a\u0001#\u0003%\tA!\u001b\t\u000f\t5\u0004\u0001\"\u0001\u0003p!I!q\u0012\u0001\u0012\u0002\u0013\u0005!\u0011\u0013\u0005\n\u0005+\u0003\u0011\u0013!C\u0001\u0005#C\u0011Ba&\u0001#\u0003%\tA!\u001b\t\u0013\te\u0005!%A\u0005\u0002\u00055\u0006b\u0002BN\u0001\u0011\u0005!Q\u0014\u0005\n\u0005[\u0003\u0011\u0013!C\u0001\u0003[CqA!\u001c\u0001\t\u0003\u0011y\u000bC\u0004\u00038\u0002!\tA!/\t\u0013\t}\u0006!%A\u0005\u0002\u00055\u0006b\u0002Ba\u0001\u0011\u0005!1\u0019\u0005\b\u0005\u0003\u0004A\u0011\u0001B|\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u007fDqaa\u0001\u0001\t\u0003\u0019)\u0001C\u0004\u0004\u0016\u0001!\taa\u0006\t\u000f\re\u0001\u0001\"\u0001\u0004\u001c!91q\u0004\u0001\u0005\u0002\r\u0005\u0002bBB\u0014\u0001\u0011\u00051\u0011\u0006\u0005\n\u0007_\u0001\u0011\u0013!C\u0001\u0005+Bqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0005\u0004:\u0001\t\n\u0011\"\u0001\u0003V!911\b\u0001\u0005\u0002\ru\u0002bBB!\u0001\u0011\u000511\t\u0005\b\u0007\u0017\u0002A\u0011AA)\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007\u001fB\u0011ba\u0015\u0001#\u0003%\tA!\u0016\t\u000f\rU\u0003\u0001\"\u0001\u0002R!91q\u000b\u0001\u0005\u0002\u0005E\u0003bBB-\u0001\u0011\u000511\f\u0005\b\u0007;\u0002A\u0011AB0\u0011\u001d\u00199\u0007\u0001C\u0001\u0007SBqaa\u001d\u0001\t\u0003\u0019)\bC\u0004\u0004t\u0001!\taa\"\t\u000f\r%\u0005\u0001\"\u0001\u0004\f\"91q\u0012\u0001\u0005\u0002\rE\u0005bBBK\u0001\u0011\u00051q\u0013\u0005\b\u00077\u0003A\u0011BBO\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007GCqaa*\u0001\t\u0003\u0019IK\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0015\t\u00116+A\u0006j]R,wM]1uS>t'\"\u0001+\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035N\u000baa]3sm\u0016\u0014\u0018B\u0001/Z\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0003\"\u0001\u0019\u0001\u000e\u0003E\u000bQBZ5sgR\u0014%o\\6fe&#W#A2\u0011\u0005\u0011<W\"A3\u000b\u0003\u0019\fQa]2bY\u0006L!\u0001[3\u0003\u0007%sG/\u0001\bgSJ\u001cHO\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001f%t7\u000f^1oG\u0016\u001cuN\u001c4jON,\u0012\u0001\u001c\t\u0004[B\u0014X\"\u00018\u000b\u0005=,\u0017AC2pY2,7\r^5p]&\u0011\u0011O\u001c\u0002\u0004'\u0016\f\bC\u0001-t\u0013\t!\u0018LA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aE5ogR\fgnY3D_:4\u0017nZ:`I\u0015\fHCA<{!\t!\u00070\u0003\u0002zK\n!QK\\5u\u0011\u001dYX!!AA\u00021\f1\u0001\u001f\u00132\u0003AIgn\u001d;b]\u000e,7i\u001c8gS\u001e\u001c\b%\u0001\u0005`EJ|7.\u001a:t+\u0005y\bCBA\u0001\u0003\u000f\tY!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u00018\u0002\u000f5,H/\u00192mK&!\u0011\u0011BA\u0002\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007a\u000bi!C\u0002\u0002\u0010e\u00131bS1gW\u0006\u0014%o\\6fe\u0006IqL\u0019:pW\u0016\u00148\u000fI\u0001\bEJ|7.\u001a:t+\t\t9\u0002\u0005\u0004\u0002\u0002\u0005e\u00111B\u0005\u0005\u00037\t\u0019A\u0001\u0004Ck\u001a4WM]\u0001\bg\u0016\u0014h/\u001a:t+\t\t\t\u0003\u0005\u0004\u0002\u0002\u0005e\u00111\u0005\t\u00041\u0006\u0015\u0012bAA\u00143\nY1*\u00194lCN+'O^3s\u0003\u0015\tG.\u001b<f+\t\ti\u0003E\u0003e\u0003_\t\u0019$C\u0002\u00022\u0015\u0014Q!\u0011:sCf\u00042\u0001ZA\u001b\u0013\r\t9$\u001a\u0002\b\u0005>|G.Z1o\u0003%\tG.\u001b<f?\u0012*\u0017\u000fF\u0002x\u0003{A\u0001b\u001f\u0007\u0002\u0002\u0003\u0007\u0011QF\u0001\u0007C2Lg/\u001a\u0011\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00117jm\u0016,\"!a\r\u0002'\r|g\u000e\u001e:pY2,'/\u00117jm\u0016|F%Z9\u0015\u0007]\fI\u0005\u0003\u0005|\u001f\u0005\u0005\t\u0019AA\u001a\u0003A\u0019wN\u001c;s_2dWM]!mSZ,\u0007%A\bhK:,'/\u0019;f\u0007>tg-[4t\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012a^\u0001#G>tg-[4ve\u0016\u001cVmY;sSRL\u0018I\u001a;feN+'O^3sgN#\u0018M\u001d;\u0002\u000f\r|gNZ5hg\u0006Y1/\u001a:wKJ4uN]%e)\u0011\tY&!\u0019\u0011\u000b\u0011\fi&a\t\n\u0007\u0005}SM\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003G*\u0002\u0019A2\u0002\u0005%$\u0017a\u00032s_.,'OR8s\u0013\u0012$B!!\u001b\u0002lA)A-!\u0018\u0002\f!1\u00111\r\fA\u0002\r\f\u0011BY8v]\u0012\u0004vN\u001d;\u0015\u0007\r\f\t\b\u0003\u0004[/\u0001\u0007\u00111E\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN$B!a\u001e\u0002\u000eB!\u0011\u0011PAD\u001d\u0011\tY(a!\u0011\u0007\u0005uT-\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q+\u0002\rq\u0012xn\u001c;?\u0013\r\t))Z\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00151\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015U\rC\u0005\u0002\u0010b\u0001\n\u00111\u0001\u0002\u0012\u0006aA.[:uK:,'OT1nKB!\u00111SAT\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015a\u00028fi^|'o\u001b\u0006\u0005\u00037\u000bi*\u0001\u0004d_6lwN\u001c\u0006\u0004)\u0006}%\u0002BAQ\u0003G\u000ba!\u00199bG\",'BAAS\u0003\ry'oZ\u0005\u0005\u0003S\u000b)J\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u000ec_>$8\u000f\u001e:baN+'O^3sg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00020*\"\u0011\u0011SAYW\t\t\u0019\f\u0005\u0003\u00026\u0006}VBAA\\\u0015\u0011\tI,a/\u0002\u0013Ut7\r[3dW\u0016$'bAA_K\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0017q\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003#\fI*\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t).a3\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>dWCAAI\u00039!(/^:u'R|'/\u001a$jY\u0016,\"!!8\u0011\u000b\u0011\fi&a8\u0011\t\u0005\u0005\u00181^\u0007\u0003\u0003GTA!!:\u0002h\u0006\u0011\u0011n\u001c\u0006\u0003\u0003S\fAA[1wC&!\u0011Q^Ar\u0005\u00111\u0015\u000e\\3\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\t\t\u0019\u0010E\u0003e\u0003;\n)\u0010\u0005\u0003\u0002x\u0006uXBAA}\u0015\u0011\tY0a:\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u007f\fIP\u0001\u0006Qe>\u0004XM\u001d;jKN\fAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00032s_.,'\u000fV5nKR!!q\u0001B\n!\u0011\u0011IAa\u0004\u000e\u0005\t-!\u0002\u0002B\u0007\u00033\u000bQ!\u001e;jYNLAA!\u0005\u0003\f\t!A+[7f\u0011\u0019\u0011)b\ba\u0001G\u0006A!M]8lKJLE-A\u0003tKR,\u0006\u000fF\u0002x\u00057AqA!\b!\u0001\u0004\u0011y\"\u0001\u0005uKN$\u0018J\u001c4p!\u0011\u0011\tCa\f\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\t1!\u00199j\u0015\u0011\u0011ICa\u000b\u0002\u000f),\b/\u001b;fe*!!QFAR\u0003\u0015QWO\\5u\u0013\u0011\u0011\tDa\t\u0003\u0011Q+7\u000f^%oM>D3\u0001\tB\u001b!\u0011\u0011\tCa\u000e\n\t\te\"1\u0005\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017AF2p]\u000e,(O]3oiN#\u0018M\u001d;Ce>\\WM]:\u0002\u0011Q,\u0017M\u001d#po:D3A\tB!!\u0011\u0011\tCa\u0011\n\t\t\u0015#1\u0005\u0002\n\u0003\u001a$XM]#bG\"\fqB]3de\u0016\fG/\u001a\"s_.,'o\u001d\u000b\u0006o\n-#q\n\u0005\n\u0005\u001b\u001a\u0003\u0013!a\u0001\u0003g\t1B]3d_:4\u0017nZ;sK\"I!\u0011K\u0012\u0011\u0002\u0003\u0007\u00111G\u0001\bgR\f'\u000f^;q\u0003e\u0011Xm\u0019:fCR,'I]8lKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t]#\u0006BA\u001a\u0003c\u000b\u0011D]3de\u0016\fG/\u001a\"s_.,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u00112M]3bi\u0016|eMZ:fiN$v\u000e]5d)\u00159(q\fB1\u0011%\tyI\nI\u0001\u0002\u0004\t\t\nC\u0005\u0003d\u0019\u0002\n\u00111\u0001\u0002v\u0006\t\u0012\rZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4\u00029\r\u0014X-\u0019;f\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%c\u0005a2M]3bi\u0016|eMZ:fiN$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012TC\u0001B6U\u0011\t)0!-\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\r\u0005c\u0012iH!!\u0003\u0006\n%%Q\u0012\t\u0007\u0005g\u0012IhY2\u000e\u0005\tU$b\u0001B<]\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005w\u0012)HA\u0002NCBDqAa *\u0001\u0004\t9(A\u0003u_BL7\r\u0003\u0005\u0003\u0004&\u0002\n\u00111\u0001d\u00035qW/\u001c)beRLG/[8og\"A!qQ\u0015\u0011\u0002\u0003\u00071-A\tsKBd\u0017nY1uS>tg)Y2u_JD\u0011Ba#*!\u0003\u0005\r!!>\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\u0005\n\u0003\u001fK\u0003\u0013!a\u0001\u0003#\u000bQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0014*\u001a1-!-\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%g\u0005)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\"\u0014!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H%N\u0001\u001aGJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0003r\t}%\u0011\u0015BV\u0011\u001d\u0011yH\fa\u0001\u0003oBqAa)/\u0001\u0004\u0011)+\u0001\u000eqCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u0005\u0004n\u0005O\u001b'\u0011V\u0005\u0004\u0005wr\u0007cA7qG\"I\u0011q\u0012\u0018\u0011\u0002\u0003\u0007\u0011\u0011S\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134)!\u0011\tH!-\u00034\nU\u0006b\u0002B@a\u0001\u0007\u0011q\u000f\u0005\b\u0005G\u0003\u0004\u0019\u0001BS\u0011\u001d\u0011Y\t\ra\u0001\u0003k\f1\u0002Z3mKR,Gk\u001c9jGR)qOa/\u0003>\"9!qP\u0019A\u0002\u0005]\u0004\"CAHcA\u0005\t\u0019AAI\u0003U!W\r\\3uKR{\u0007/[2%I\u00164\u0017-\u001e7uII\nAd^1jiVsG/\u001b7M_\u001e\u001c%/Z1uK\u0012|eN\u0011:pW\u0016\u00148/\u0006\u0003\u0003F\n-H#B<\u0003H\nM\u0007b\u0002Beg\u0001\u0007!1Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011iMa4\u000e\u0005\u0005e\u0015\u0002\u0002Bi\u00033\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0014M\u0002\rA!6\u0011\r\t]'\u0011\u001dBt\u001d\u0011\u0011IN!8\u000f\t\u0005u$1\\\u0005\u0002M&\u0019!q\\3\u0002\u000fA\f7m[1hK&!!1\u001dBs\u0005!IE/\u001a:bE2,'b\u0001BpKB!!\u0011\u001eBv\u0019\u0001!qA!<4\u0005\u0004\u0011yOA\u0001C#\u0011\u0011\t0a\u0003\u0011\u0007\u0011\u0014\u00190C\u0002\u0003v\u0016\u0014qAT8uQ&tw\rF\u0003x\u0005s\u0014Y\u0010C\u0004\u0003\u0000Q\u0002\r!a\u001e\t\r\tuH\u00071\u0001d\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0015\u0007]\u001c\t\u0001C\u0004\u0003JV\u0002\rAa3\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001cHCAB\u0004!\u0011i\u0007o!\u0003\u0011\t\r-1\u0011C\u0007\u0003\u0007\u001bQAaa\u0004\u0002h\u0006!A.\u00198h\u0013\u0011\u0019\u0019b!\u0004\u0003\u000f%sG/Z4fe\u0006\u00012.\u001b7m%\u0006tGm\\7Ce>\\WM\u001d\u000b\u0002G\u0006q1.\u001b7m\u0005J|7.\u001a:Cs&#GcA<\u0004\u001e!1\u00111\r\u001dA\u0002\r\f!b[5mY\n\u0013xn[3s)\r981\u0005\u0005\u0007\u0007KI\u0004\u0019A2\u0002\u000b%tG-\u001a=\u0002#I,7\u000f^1si\u0012+\u0017\r\u001a\"s_.,'\u000fF\u0003x\u0007W\u0019i\u0003\u0003\u0004\u0004&i\u0002\ra\u0019\u0005\n\u0005\u001bR\u0004\u0013!a\u0001\u0003g\t1D]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012\u0014!\u0006:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6fe\nK\u0018\n\u001a\u000b\u0006o\u000eU2q\u0007\u0005\u0007\u0005+a\u0004\u0019A2\t\u0013\t5C\b%AA\u0002\u0005M\u0012a\b:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6fe\nK\u0018\n\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005a!/Z7pm\u0016\u0014%o\\6feR\u0019qoa\u0010\t\u000f\r\ra\b1\u0001\u0004\b\u0005I\u0011\r\u001a3Ce>\\WM\u001d\u000b\u0006o\u000e\u00153q\t\u0005\u0007\u0007Ky\u0004\u0019A2\t\r\r%s\b1\u0001s\u0003\u0019\u0019wN\u001c4jO\u0006q1.\u001b7m\u00032d'I]8lKJ\u001c\u0018A\u0005:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6feN$2a^B)\u0011%\u0011i%\u0011I\u0001\u0002\u0004\t\u0019$\u0001\u000fsKN$\u0018M\u001d;EK\u0006$'I]8lKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002/MDW\u000f\u001e3po:\\\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018!\u0005:fgR\f'\u000f^\"p]R\u0014x\u000e\u001c7fe\u0006iq-\u001a;D_:$(o\u001c7mKJ$\"!a\t\u0002%\u001d,Go\u0013*bMR\u001cuN\u001c;s_2dWM\u001d\u000b\u0003\u0007C\u00022\u0001WB2\u0013\r\u0019)'\u0017\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\faf^1ji\u001a{'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2$v.\u00119qK\u0006\u0014xJ\\!mY\n\u0013xn[3sgR)qoa\u001b\u0004p!91QN$A\u0002\u0005]\u0014aD2mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197\t\u000f\rEt\t1\u0001\u0002x\u0005iQ.Z2iC:L7/\u001c(b[\u0016\f1bZ3u)>\u0004\u0018nY%egR!1qOBA!!\tIh!\u001f\u0002x\rm\u0014\u0002\u0002B>\u0003\u0017\u0003BA!4\u0004~%!1qPAM\u0005\u0011)V/\u001b3\t\u000f\r\r\u0005\n1\u0001\u0004\u0006\u0006)a.Y7fgB!Q\u000e]A<)\t\u00199(A\u0007hKR$v\u000e]5d\u001d\u0006lWm\u001d\u000b\u0003\u0007\u001b\u0003\u0002\"!\u001f\u0004z\rm\u0014qO\u0001\u0013g\u0016\u0014h/\u001a:XSRD'I]8lKJLE\r\u0006\u0003\u0002\f\rM\u0005B\u0002B\u000b\u0017\u0002\u00071-A\u0007de\u0016\fG/\u001a\"s_.,'o\u001d\u000b\u0004o\u000ee\u0005b\u0002B)\u0019\u0002\u0007\u00111G\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d$s_6\u001cuN\u001c4jOR!\u00111BBP\u0011\u0019\u0019I%\u0014a\u0001e\u0006a!M]8lKJ<\u0016\u000e\u001e5JIR!\u00111BBS\u0011\u0019\u0011)B\u0014a\u0001G\u0006yq-\u001a;SC:$w.\u001c\"s_.,'\u000f\u0006\u0002\u0002\f\u0001")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private final int firstBrokerId;
    private Seq<KafkaConfig> instanceConfigs = null;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive = null;
    private boolean controllerAlive = false;

    public int firstBrokerId() {
        return this.firstBrokerId;
    }

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaServer> servers() {
        this.checkIsZKTest();
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    private boolean controllerAlive() {
        return this.controllerAlive;
    }

    private void controllerAlive_$eq(boolean x$1) {
        this.controllerAlive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart() {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public Option<KafkaBroker> brokerForId(int id) {
        return this.brokers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$brokerForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart();
        this.createBrokers(true);
        this.controllerAlive_$eq(true);
        this.configureSecurityAfterServersStart();
    }

    public void concurrentStartBrokers() {
        int numBrokers = this.configs().size();
        ArrayBuffer brokerFutures = ArrayBuffer$.MODULE$.empty();
        ExecutorService executorService = Executors.newFixedThreadPool(numBrokers);
        this.alive_$eq(new boolean[numBrokers]);
        Arrays.fill(this.alive(), false);
        try {
            this.configs().foreach((Function1 & Serializable)config -> (ArrayBuffer)brokerFutures.$plus$eq(executorService.submit(() -> {
                void var2_2;
                KafkaBroker broker = this.createBrokerFromConfig((KafkaConfig)config);
                broker.startup();
                return var2_2;
            })));
            AtomicReference firstException = new AtomicReference();
            brokerFutures.foreach((Function1 & Serializable)future -> {
                KafkaServerTestHarness.$anonfun$concurrentStartBrokers$3(this, firstException, future);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), true);
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);){
                TestUtils$.MODULE$.createOffsetsTopicWithAdmin(resource_resource, this.brokers());
            }
            return;
        }
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties());){
                map = KafkaServerTestHarness.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, resource_resource);
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaServer>)this.servers(), topicConfig);
    }

    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties());){
                map = KafkaServerTestHarness.$anonfun$createTopicWithAssignment$1(this, topic, partitionReplicaAssignment, resource_resource);
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaServer>)this.servers());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties topicConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties());){
                map = KafkaServerTestHarness.$anonfun$createTopic$2(this, topic, partitionReplicaAssignment, topicConfig, resource_resource);
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaServer>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    public void deleteTopic(String topic, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties());){
                TestUtils$.MODULE$.deleteTopicWithAdmin(resource_resource, topic, this.brokers());
            }
            return;
        }
        this.adminZkClient().deleteTopic(topic);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public <B extends KafkaBroker> void waitUntilLogCreatedOnBrokers(TopicPartition topicPartition, Iterable<B> brokers) {
        brokers.foreach((Function1 & Serializable)broker -> {
            KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$1(topicPartition, broker);
            return BoxedUnit.UNIT;
        });
    }

    public void waitUntilLogCreatedOnBrokers(String topic, int partitionId) {
        this.waitUntilLogCreatedOnBrokers(new TopicPartition(topic, partitionId));
    }

    public void waitUntilLogCreatedOnBrokers(TopicPartition topicPartition) {
        Buffer replicas = CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)this.brokers().head()).metadataCache().getPartitionInfo(topicPartition.topic(), topicPartition.partition()).get()).isr()).asScala();
        this.waitUntilLogCreatedOnBrokers(topicPartition, (Iterable)replicas.map((Function1 & Serializable)x$1 -> (KafkaBroker)this.brokerForId(Predef$.MODULE$.Integer2int(x$1)).get()));
    }

    public Seq<Integer> brokerIds() {
        return (Seq)this._brokers().map((Function1 & Serializable)b -> new Integer(b.config().brokerId()));
    }

    /*
     * WARNING - void declaration
     */
    public int killRandomBroker() {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return (int)var1_1;
    }

    public void killBrokerById(int id) {
        int brokerIndex = this._brokers().indexWhere((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$killBrokerById$1(id, b)));
        this.killBroker(brokerIndex);
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown();
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
        }
    }

    public void restartDeadBroker(int index, boolean reconfigure) {
        if (!this.alive()[index]) {
            if (reconfigure || this.isKRaftTest()) {
                this._brokers().update(index, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(index)));
            }
            ((KafkaBroker)this._brokers().apply(index)).startup();
            this.alive()[index] = true;
        }
    }

    public boolean restartDeadBroker$default$2() {
        return false;
    }

    public void restartDeadBrokerById(int brokerId, boolean reconfigure) {
        int brokerIndex = this._brokers().indexWhere((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$restartDeadBrokerById$1(brokerId, b)));
        this.restartDeadBroker(brokerIndex, reconfigure);
    }

    public boolean restartDeadBrokerById$default$2() {
        return false;
    }

    public void removeBroker(Seq<Integer> brokerIds) {
        brokerIds.foreach((Function1 & Serializable)id -> {
            KafkaServerTestHarness.$anonfun$removeBroker$1(this, id);
            return BoxedUnit.UNIT;
        });
    }

    public void addBroker(int index, KafkaConfig config) {
        Assertions.assertTrue((index <= this._brokers().size() ? 1 : 0) != 0, (String)new StringBuilder(33).append("Can only add a broker at index 0-").append(this._brokers().size()).toString());
        KafkaBroker broker = this.createBroker(config, this.brokerTime(config.brokerId()), this.createBroker$default$3());
        if (index >= this._brokers().size()) {
            this._brokers().$plus$eq((Object)broker);
            boolean[] newAlive = new boolean[this._brokers().length()];
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.booleanArrayOps(this.alive())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                newAlive$1[i] = this.alive()[i];
            });
            this.alive_$eq(newAlive);
        } else {
            this._brokers().update(index, (Object)broker);
        }
        this.alive()[index] = true;
    }

    public void killAllBrokers() {
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> this.restartDeadBroker(x$3, reconfigure));
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void shutdownKafkaController() {
        if (this.isKRaftTest()) {
            throw new UnsupportedOperationException("KRaft tests do not have a KafkaController instance.");
        }
        if (this.controllerAlive()) {
            this.getController().shutdown();
            this.controllerAlive_$eq(false);
        }
    }

    public void restartController() {
        if (this.isKRaftTest()) {
            this.restartControllerServer();
        } else {
            this.shutdownKafkaController();
            Assertions.assertFalse((boolean)this.controllerAlive());
            this.getController().startup();
        }
        this.controllerAlive_$eq(true);
    }

    public KafkaServer getController() {
        this.checkIsZKTest();
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        return (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public ControllerServer getKRaftController() {
        this.checkIsKRaftTest();
        if (!this.controllerServer().controller().isActive()) {
            throw new KafkaException("Could not find the active controller!");
        }
        return this.controllerServer();
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        if (this.isKRaftTest()) {
            java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContext.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(names).asJava()).get();
            names.foreach((Function1 & Serializable)name -> {
                ResultOrError response = (ResultOrError)topicIdsMap.get(name);
                return (Uuid)result.put(name, response.result());
            });
        } else {
            scala.collection.immutable.Map topicIdsMap = this.getController().kafkaController().controllerContext().topicIds().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            names.foreach((Function1 & Serializable)name -> {
                if (topicIdsMap.contains(name)) {
                    return result.put(name, topicIdsMap.get(name).get());
                }
                return BoxedUnit.UNIT;
            });
        }
        return CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        if (this.isKRaftTest()) {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContext.ANONYMOUS_CONTEXT).get()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return this.getController().kafkaController().controllerContext().topicIds().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        if (this.isKRaftTest()) {
            HashMap result = new HashMap();
            ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContext.ANONYMOUS_CONTEXT).get()).entrySet().forEach(e -> result.put(e.getValue(), e.getKey()));
            return CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return this.getController().kafkaController().controllerContext().topicNames().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public KafkaBroker serverWithBrokerId(int brokerId) {
        return (KafkaBroker)this.brokers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverWithBrokerId$1(brokerId, x$4))).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    public void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        void createServer_startup;
        if (this.isKRaftTest()) {
            return this.createBroker(config, this.brokerTime(config.brokerId()), false);
        }
        boolean bl = false;
        None$ createServer_threadNamePrefix = None$.MODULE$;
        Time createServer_time = this.brokerTime(config.brokerId());
        return TestUtils$.MODULE$.createServer(config, createServer_time, (Option<String>)createServer_threadNamePrefix, 1, (boolean)createServer_startup);
    }

    public KafkaBroker brokerWithId(int brokerId) {
        return (KafkaBroker)this._brokers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$brokerWithId$1(brokerId, x$5))).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    public KafkaBroker getRandomBroker() {
        void var1_1;
        KafkaBroker broker = (KafkaBroker)this._brokers().apply(TestUtils$.MODULE$.random().nextInt(this._brokers().size() - 1));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Returning Broker with ID ").append(broker.config().brokerId()).append(" as the next random broker").toString());
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ boolean $anonfun$brokerForId$1(int id$2, KafkaBroker s) {
        return s.config().brokerId() == id$2;
    }

    public static final /* synthetic */ void $anonfun$concurrentStartBrokers$3(KafkaServerTestHarness $this, AtomicReference firstException$1, Future future) {
        try {
            KafkaBroker broker = (KafkaBroker)future.get(60000L, TimeUnit.MILLISECONDS);
            $this._brokers().$plus$eq((Object)broker);
            $this.alive()[$this._brokers().length() - 1] = true;
        }
        catch (Exception e) {
            firstException$1.compareAndSet(null, e);
        }
        if (firstException$1.get() != null) {
            throw (Throwable)firstException$1.get();
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(KafkaServerTestHarness $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Map map;
        Buffer<KafkaBroker> x$3 = $this.brokers();
        Map map2 = map = (Map)Map$.MODULE$.empty();
        map = null;
        Map x$7 = map2;
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$3, numPartitions$1, replicationFactor$1, (Map<Object, Seq<Object>>)x$7, topicConfig$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopicWithAssignment$1(KafkaServerTestHarness $this, String topic$2, Map partitionReplicaAssignment$1, Admin admin) {
        Properties properties;
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int n = 1;
        int n2 = 1;
        Properties properties2 = properties = new Properties();
        properties = null;
        Properties x$7 = properties2;
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$2, x$4, n, n2, (Map<Object, Seq<Object>>)partitionReplicaAssignment$1, x$7);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$2(KafkaServerTestHarness $this, String topic$3, Map partitionReplicaAssignment$2, Properties topicConfig$2, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int n = 1;
        int n2 = 1;
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$3, x$4, n, n2, (Map<Object, Seq<Object>>)partitionReplicaAssignment$2, topicConfig$2);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLogCreatedOnBrokers$2(KafkaBroker broker$1, TopicPartition topicPartition$1) {
        LogManager qual$1 = broker$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLogCreatedOnBrokers$3(TopicPartition topicPartition$1) {
        return new StringBuilder(16).append("Log for ").append(topicPartition$1).append(" created").toString();
    }

    public static final /* synthetic */ void $anonfun$waitUntilLogCreatedOnBrokers$1(TopicPartition topicPartition$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$2(broker, topicPartition$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$3(topicPartition$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
    }

    public static final /* synthetic */ boolean $anonfun$killBrokerById$1(int id$3, KafkaBroker b) {
        return b.config().brokerId() == id$3;
    }

    public static final /* synthetic */ boolean $anonfun$restartDeadBrokerById$1(int brokerId$1, KafkaBroker b) {
        return b.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeBroker$2(Integer id$4, KafkaBroker x$2) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$2.config().brokerId()), (Object)id$4);
    }

    public static final /* synthetic */ void $anonfun$removeBroker$1(KafkaServerTestHarness $this, Integer id) {
        $this._brokers().$minus$eq($this._brokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$removeBroker$2(id, x$2))).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(id).append(" not found").toString());
        }));
        $this.alive()[Predef$.MODULE$.Integer2int((Integer)id)] = false;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverWithBrokerId$1(int brokerId$2, KafkaBroker x$4) {
        return x$4.config().brokerId() == brokerId$2;
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithId$1(int brokerId$3, KafkaBroker x$5) {
        return x$5.config().brokerId() == brokerId$3;
    }

    public KafkaServerTestHarness() {
        this.firstBrokerId = 0;
    }

    public static final /* synthetic */ Object $anonfun$deleteTopic$1$adapted(KafkaServerTestHarness $this, String topic$4, Admin admin) {
        TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic$4, $this.brokers());
        return BoxedUnit.UNIT;
    }
}

