/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType$CircularMirror$;
import kafka.link.FailureType$SourceTopicDelete$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005e4A\u0001E\t\u0001-!)1\u0004\u0001C\u00019!9a\u0004\u0001b\u0001\n\u0003z\u0002B\u0002\u0014\u0001A\u0003%\u0001\u0005C\u0005(\u0001\u0001\u0007\t\u0011)Q\u0005Q!)A\u0007\u0001C!k!)q\b\u0001C\u0001\u0001\")Q\t\u0001C\u0001\u0001\")q\t\u0001C\u0001\u0001\")\u0011\n\u0001C\u0001\u0001\")1\n\u0001C\u0001\u0001\")Q\n\u0001C\u0001\u0001\")q\n\u0001C\u0001\u0001\")\u0011\u000b\u0001C\u0005%\"9Q\rAI\u0001\n\u00131\u0007bB9\u0001#\u0003%IA\u001a\u0002\u0015\u00072,8\u000f^3s\u0019&t7.\u00132qeY\"Vm\u001d;\u000b\u0005I\u0019\u0012\u0001\u00027j].T\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011#\u0003\u0002\u001b#\t\u0011\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW&sG/Z4sCRLwN\u001c+fgR\fa\u0001P5oSRtD#A\u000f\u0011\u0005a\u0001\u0011!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;peV\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0003TQ>\u0014H/\u0001\nsKBd\u0017nY1uS>tg)Y2u_J\u0004\u0013!C0uKN$\u0018J\u001c4p!\tI#'D\u0001+\u0015\tYC&A\u0002ba&T!!\f\u0018\u0002\u000f),\b/\u001b;fe*\u0011q\u0006M\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002c\u0005\u0019qN]4\n\u0005MR#\u0001\u0003+fgRLeNZ8\u0002\u000bM,G/\u00169\u0015\u0005YJ\u0004CA\u00118\u0013\tA$E\u0001\u0003V]&$\b\"\u0002\u001e\u0006\u0001\u0004A\u0013\u0001\u0003;fgRLeNZ8)\u0005\u0015a\u0004CA\u0015>\u0013\tq$F\u0001\u0006CK\u001a|'/Z#bG\"\f1\u0004^3tiN{WO]2f\u0007\"\fgnZ3Qe>\u0004\u0018mZ1uS>tG#\u0001\u001c)\u0005\u0019\u0011\u0005CA\u0015D\u0013\t!%F\u0001\u0003UKN$\u0018!\r;fgR,fn\u00197fC:\u001cv.\u001e:dK2+\u0017\rZ3s\u000b2,7\r^5p]^KG\u000f\u001b#fgR,\u0005o\\2i\u0003\",\u0017\r\u001a\u0015\u0003\u000f\t\u000b!\u0006^3ti6K'O]8s/&$\bnU8ve\u000e,g)Y5mkJ,7oV5uQ>cG\rR3ti&\u0003(\r\u000b\u0002\t\u0005\u0006aC/Z:u\u001b&\u0014(o\u001c:XSRD7k\\;sG\u00164\u0015-\u001b7ve\u0016\u001cx+\u001b;i\u001f2$7k\\;sG\u0016L\u0005O\u0019\u0015\u0003\u0013\t\u000b!\u0005^3ti:{g.T8o_R|g.[2T_V\u00148-\u001a'fC\u0012,'/\u00129pG\"\u001c\bF\u0001\u0006C\u0003-\"Xm\u001d;T_V\u00148-\u001a+pa&\u001c'+Z2sK\u0006$X\rR3uK\u000e$X\rZ(o)J,hnY1uS>t\u0007FA\u0006C\u0003I!Xm\u001d;DSJ\u001cW\u000f\\1s\u001b&\u0014(o\u001c:)\u00051\u0011\u0015!D:fiV\u00038\t\\;ti\u0016\u00148\u000fF\u00027'\u000eDq\u0001V\u0007\u0011\u0002\u0003\u0007Q+A\u0004eKN$\u0018J\u00199\u0011\u0007\u00052\u0006,\u0003\u0002XE\t1q\n\u001d;j_:\u0004\"!\u00171\u000f\u0005is\u0006CA.#\u001b\u0005a&BA/\u0016\u0003\u0019a$o\\8u}%\u0011qLI\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`E!9A-\u0004I\u0001\u0002\u0004)\u0016!C:pkJ\u001cW-\u00132q\u0003]\u0019X\r^+q\u00072,8\u000f^3sg\u0012\"WMZ1vYR$\u0013'F\u0001hU\t)\u0006nK\u0001j!\tQw.D\u0001l\u0015\taW.A\u0005v]\u000eDWmY6fI*\u0011aNI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00019l\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018g\u0016$X\u000b]\"mkN$XM]:%I\u00164\u0017-\u001e7uIIBC\u0001A:woB\u0011\u0011\u0006^\u0005\u0003k*\u00121\u0001V1h\u0003\u00151\u0018\r\\;fC\u0005A\u0018aC5oi\u0016<'/\u0019;j_:\u0004")
public class ClusterLinkIbp26Test
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor;
    private TestInfo _testInfo;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    @Test
    public void testSourceChangePropagation() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$4 = qual$1.createDestClusterLink$default$3();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$4, 10000L, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().deleteTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
    }

    @Test
    public void testUncleanSourceLeaderElectionWithDestEpochAhead() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$3 = qual$1.createDestClusterLink$default$3();
        long x$4 = qual$1.createDestClusterLink$default$4();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$3, x$4, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(true);
        this.verifyLinkedLeaderChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldDestIpb() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        int recordsBeforeSourceFailure = 10;
        Properties x$22 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$1();
        int x$3 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(x$22, recordsBeforeSourceFailure, x$3);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        KafkaBroker destLeader = this.destCluster().partitionLeader(tp);
        this.waitForMirror((Seq<KafkaBroker>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaBroker[]{destLeader}))), this.waitForMirror$default$2());
        ((IterableOnceOps)this.destCluster().brokers().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(destLeader, x$2)))).foreach((Function1 & Serializable)follower -> {
            ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(this, recordsBeforeSourceFailure, tp, follower);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$4 = this.topic();
        String x$5 = this.linkName();
        boolean x$7 = qual$1.unlinkTopic$default$3();
        boolean x$8 = qual$1.unlinkTopic$default$5();
        qual$1.unlinkTopic(x$4, x$5, x$7, false, x$8);
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldSourceIpb() {
        None$ none$;
        Some x$1 = new Some((Object)"2.4");
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$2 = none$2;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        Properties topicConfig = new Properties();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$3 = this.topic();
        Seq<KafkaBroker> x$5 = this.verifyMirror$default$2();
        this.verifyMirror(x$3, x$5, false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonMonotonicSourceLeaderEpochs() {
        void var10_11;
        None$ none$;
        Some x$1 = new Some((Object)"2.6");
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$2 = none$2;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("min.insync.replicas", "1");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$3 = this.topic();
        int x$4 = this.numPartitions();
        ListenerName x$7 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$3, x$4, 1, topicConfigs, x$7);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        this.produceToSourceCluster(10);
        Tuple2<Object, Object> tuple2 = this.sourceCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader = tuple2._1$mcI$sp();
        this.sourceCluster().startBroker((int)var10_11);
        this.produceToSourceCluster(10);
        int sourceEpoch = this.sourceCluster().leaderEpoch(tp);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$8 = this.linkName();
        ClusterLinkTestHarness x$9 = this.sourceCluster();
        long x$11 = qual$2.createDestClusterLink$default$3();
        long x$12 = qual$2.createDestClusterLink$default$5();
        Properties x$13 = qual$2.createDestClusterLink$default$6();
        qual$2.createDestClusterLink(x$8, x$9, x$11, 10000L, x$12, x$13);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$14 = this.topic();
        String x$16 = this.linkName();
        Map<String, String> x$17 = qual$3.linkTopic$default$4();
        String x$18 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$14, (short)3, x$16, x$17, x$18);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Partition sourcePartition = this.sourceCluster().partitionLeader(tp).replicaManager().getPartitionOrException(tp);
        TestUtils.setFieldValue((Object)sourcePartition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)0));
        this.produceToSourceCluster(10);
        TestUtils.setFieldValue((Object)sourcePartition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)sourceEpoch));
        this.sourceCluster().consumerConfig().setProperty("auto.offset.reset", "earliest");
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        ByteArrayDeserializer x$19 = qual$4.createConsumer$default$1();
        ByteArrayDeserializer x$20 = qual$4.createConsumer$default$2();
        Properties x$21 = qual$4.createConsumer$default$3();
        List<String> x$22 = qual$4.createConsumer$default$4();
        KafkaConsumer sourceConsumer = qual$4.createConsumer(x$19, x$20, x$21, x$22);
        sourceConsumer.assign(Collections.singleton(tp));
        Seq sourceRecords = TestUtils$.MODULE$.consumeRecords(sourceConsumer, 30, 15000L);
        ((IterableOnceOps)sourceRecords.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkIbp26Test.$anonfun$testNonMonotonicSourceLeaderEpochs$1(sourceEpoch, sourceRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        Partition destPartition = this.destCluster().partitionLeader(tp).replicaManager().getPartitionOrException(tp);
        Assertions.assertTrue((destPartition.getLeaderEpoch() >= sourceEpoch ? 1 : 0) != 0, (String)new StringBuilder(29).append("Unexpected dest leader epoch ").append(destPartition.getLeaderEpoch()).toString());
        Assertions.assertEquals((long)20L, (long)destPartition.localLogOrException().logEndOffset());
    }

    @Test
    public void testSourceTopicRecreateDetectedOnTruncation() {
        this.numPartitions_$eq(1);
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        this.setupLinkAndMirrorForFailureTest(20000L, 60000L, "testGroup");
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$2 = this.topic();
        int x$3 = this.numPartitions();
        short x$4 = this.replicationFactor();
        Properties x$5 = qual$2.createTopic$default$4();
        ListenerName x$6 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(5);
        this.truncate(5);
        this.waitForFailure(destAdmin, FailureType$SourceTopicDelete$.MODULE$);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().killAllBrokers();
        ConfluentAdmin destAdmin2 = (ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get();
        this.waitForFailure(destAdmin2, FailureType$SourceTopicDelete$.MODULE$);
        String x$7 = this.topic();
        Seq<KafkaBroker> x$9 = this.verifyMirror$default$2();
        this.verifyMirror(x$7, x$9, false);
    }

    @Test
    public void testCircularMirror() {
        None$ none$;
        Some x$1 = new Some((Object)"2.6");
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$2 = none$2;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties linkPropOverrides = new Properties();
        linkPropOverrides.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$3 = this.linkName();
        ClusterLinkTestHarness x$4 = this.sourceCluster();
        long x$6 = qual$1.createDestClusterLink$default$3();
        long x$7 = qual$1.createDestClusterLink$default$4();
        long x$8 = qual$1.createDestClusterLink$default$5();
        UUID linkId = qual$1.createDestClusterLink(x$3, x$4, x$6, x$7, x$8, linkPropOverrides);
        Properties linkProps = new Properties();
        ClusterLinkTestHarness qual$2 = this.destCluster();
        ListenerName x$9 = qual$2.bootstrapServers$default$1();
        linkProps.put("bootstrap.servers", qual$2.bootstrapServers(x$9));
        linkProps.putAll((java.util.Map<?, ?>)this.destCluster().clientSecurityProps(this.linkName()));
        linkProps.put("sasl.jaas.config", this.createLinkCredentials(this.linkName(), this.destCluster(), this.createLinkCredentials$default$3()));
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$10 = this.linkName();
        ClusterLinkTestHarness x$11 = this.destCluster();
        long x$13 = qual$3.createDestClusterLink$default$3();
        long x$14 = qual$3.createDestClusterLink$default$4();
        long x$15 = qual$3.createDestClusterLink$default$5();
        UUID sourceLinkId = qual$3.createDestClusterLink(x$10, x$11, x$13, x$14, x$15, linkPropOverrides);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        String x$16 = this.topic();
        int x$17 = this.numPartitions();
        short x$18 = this.replicationFactor();
        Properties x$19 = qual$4.createTopic$default$4();
        ListenerName x$20 = qual$4.createTopic$default$5();
        qual$4.createTopic(x$16, x$17, x$18, x$19, x$20);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = this.topic();
        short x$22 = this.replicationFactor();
        String x$23 = this.linkName();
        Map<String, String> x$24 = qual$5.linkTopic$default$4();
        String x$25 = qual$5.linkTopic$default$5();
        qual$5.linkTopic(x$21, x$22, x$23, x$24, x$25);
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        String x$26 = this.topic();
        short x$27 = this.replicationFactor();
        String x$28 = this.linkName();
        Map<String, String> x$29 = qual$6.linkTopic$default$4();
        String x$30 = qual$6.linkTopic$default$5();
        qual$6.linkTopic(x$26, x$27, x$28, x$29, x$30);
        ClusterLinkTestHarness qual$7 = this.sourceCluster();
        Properties x$31 = qual$7.createConfluentAdminClient$default$1();
        ConfluentAdmin sourceAdmin = qual$7.createConfluentAdminClient(x$31);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Properties x$32 = qual$8.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$8.createConfluentAdminClient(x$32);
        this.waitForReplicaState$1(sourceAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForReplicaState$1(destAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForBlockedPartition$1(sourceLinkId, linkId, tp);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$33 = this.topic();
        String x$34 = this.linkName();
        boolean x$36 = qual$9.unlinkTopic$default$3();
        boolean x$37 = qual$9.unlinkTopic$default$5();
        qual$9.unlinkTopic(x$33, x$34, x$36, false, x$37);
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$10 = this.destCluster();
        ByteArraySerializer x$38 = qual$10.createProducer$default$1();
        ByteArraySerializer x$39 = qual$10.createProducer$default$2();
        Properties x$40 = qual$10.createProducer$default$3();
        KafkaProducer producer = qual$10.createProducer(x$38, x$39, x$40);
        this.produceRecords(producer, this.topic(), 20, this.produceRecords$default$4());
        producer.close();
        this.waitForMirror((Seq<KafkaBroker>)this.sourceCluster().brokers(), this.waitForMirror$default$2());
        this.waitForReplicaState$1(sourceAdmin, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE})));
    }

    private void setUpClusters(Option<String> destIbp, Option<String> sourceIbp) {
        destIbp.foreach((Function1 & Serializable)ibp -> this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        sourceIbp.foreach((Function1 & Serializable)ibp -> this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        super.setUp(this._testInfo);
    }

    private Option<String> setUpClusters$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setUpClusters$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(KafkaBroker destLeader$1, KafkaBroker x$2) {
        KafkaBroker kafkaBroker = x$2;
        return !(kafkaBroker != null ? !kafkaBroker.equals(destLeader$1) : destLeader$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(ClusterLinkIbp26Test $this, int recordsBeforeSourceFailure$1, TopicPartition tp$1, KafkaBroker follower) {
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)recordsBeforeSourceFailure$1)), $this.logEndOffset(follower, tp$1));
    }

    public static final /* synthetic */ void $anonfun$testNonMonotonicSourceLeaderEpochs$1(int sourceEpoch$1, Seq sourceRecords$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Integer leaderEpoch = (Integer)record.leaderEpoch().get();
            Assertions.assertEquals((int)(index >= 10 && index < 20 ? sourceEpoch$1 : 0), (Integer)leaderEpoch, (String)new StringBuilder(35).append("Unexpected epoch at index ").append(index).append(", epochs=").append(sourceRecords$1.map((Function1 & Serializable)x$3 -> x$3.leaderEpoch())).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testCircularMirror$1(ClusterLinkIbp26Test $this, ConfluentAdmin admin$1) {
        return $this.mirrorPartitionStates(admin$1);
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForReplicaState$1(ConfluentAdmin admin, scala.collection.immutable.Set expectedStates) {
        void var4_9;
        Tuple2 tuple2;
        long l = 15000L;
        long l2 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            scala.collection.immutable.Set<ReplicaStatus.MirrorInfo.State> computeUntilTrue_result;
            if ((computeUntilTrue_result = this.mirrorPartitionStates(admin)).subsetOf((Set)expectedStates)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple22 = tuple2;
        Object var7_6 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set actualStates = (scala.collection.immutable.Set)tuple23._1();
        Assertions.assertTrue((boolean)var4_9.subsetOf((Set)expectedStates), (String)new StringBuilder(25).append("Expected subset of ").append(expectedStates).append(", got ").append(var4_9).toString());
    }

    private static final ConcurrentHashMap waitingPartitions$1(ClusterLinkTestHarness cluster, UUID linkId, TopicPartition tp$2) {
        return (ConcurrentHashMap)TestUtils.fieldValue((Object)cluster.partitionLeader(tp$2).clusterLinkManager().fetcherManager(linkId).get(), ClusterLinkFetcherManager.class, (String)"waitingPartitions");
    }

    public static final /* synthetic */ boolean $anonfun$testCircularMirror$3(ConcurrentHashMap sourceWaitingPartitions$1, TopicPartition tp$2, ConcurrentHashMap destWaitingPartitions$1) {
        return sourceWaitingPartitions$1.containsKey(tp$2) || destWaitingPartitions$1.containsKey(tp$2);
    }

    public static final /* synthetic */ String $anonfun$testCircularMirror$4() {
        return "Partition not blocked after consecutive epoch bumps";
    }

    private final void waitForBlockedPartition$1(UUID sourceLinkId$1, UUID linkId$1, TopicPartition tp$2) {
        ConcurrentHashMap sourceWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.sourceCluster(), sourceLinkId$1, tp$2);
        ConcurrentHashMap destWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.destCluster(), linkId$1, tp$2);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIbp26Test.$anonfun$testCircularMirror$3(sourceWaitingPartitions, tp$2, destWaitingPartitions)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Partition not blocked after consecutive epoch bumps");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public ClusterLinkIbp26Test() {
        None$ none$;
        None$ none$2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$4 = none$3;
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$4;
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        this.replicationFactor = (short)3;
    }

    public static final /* synthetic */ Object $anonfun$testCircularMirror$2$adapted(scala.collection.immutable.Set expectedStates$1, scala.collection.immutable.Set x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.subsetOf((Set)expectedStates$1));
    }
}

