/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005!4Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!9Q\u0003\u0001b\u0001\n\u00032\u0002BB\u000f\u0001A\u0003%q\u0003C\u0003\u001f\u0001\u0011\u0005s\u0004C\u00036\u0001\u0011\u0005a\u0007C\u0003\\\u0001\u0011\u0005AL\u0001\nDYV\u001cH/\u001a:MS:\\\u0017j\u001d:UKN$(BA\u0005\u000b\u0003\u0011a\u0017N\\6\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0011%\u0011\u0011\u0003\u0003\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005!\u0002CA\b\u0001\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t)1\u000b[8si\u0006\u0011\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u0003\u0015\u0019X\r^+q)\t\u00013\u0005\u0005\u0002\u0019C%\u0011!%\u0007\u0002\u0005+:LG\u000fC\u0003%\t\u0001\u0007Q%\u0001\u0005uKN$\u0018J\u001c4p!\t1s&D\u0001(\u0015\tA\u0013&A\u0002ba&T!AK\u0016\u0002\u000f),\b/\u001b;fe*\u0011A&L\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002]\u0005\u0019qN]4\n\u0005A:#\u0001\u0003+fgRLeNZ8)\u0005\u0011\u0011\u0004C\u0001\u00144\u0013\t!tE\u0001\u0006CK\u001a|'/Z#bG\"\f!\u0004^3ti\u0012+7\u000f^5oCRLwN\\+oI\u0016\u0014X*\u001b8JgJ$\"\u0001I\u001c\t\u000ba*\u0001\u0019A\u001d\u0002\rE,xN];n!\tQ\u0014I\u0004\u0002<\u007fA\u0011A(G\u0007\u0002{)\u0011a\bD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001K\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\r)\t\u0015)UJ\u0014\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u0015&\na\u0001]1sC6\u001c\u0018B\u0001'H\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012q*U\u0011\u0002!\u0006\u0011!p[\u0011\u0002%\u0006)1N]1gi\"\"Q\u0001\u0016-Z!\t)f+D\u0001J\u0013\t9\u0016JA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n!,\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\fQ\u0003^3tiJ+7\u000f^1siB\u000bWo]3e\u0019&t7\u000e\u0006\u0002!;\")\u0001H\u0002a\u0001s!\"a!R'`Y\ty\u0015\u000b\u000b\u0003\u0007)bK\u0006\u0006\u0002\u0001cK\u001a\u0004\"AJ2\n\u0005\u0011<#a\u0001+bO\u0006)a/\u00197vK\u0006\nq-A\u0006j]R,wM]1uS>t\u0007")
public class ClusterLinkIsrTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor = (short)3;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ none$;
            None$ none$2;
            None$ none$3 = none$2 = None$.MODULE$;
            none$2 = null;
            None$ x$4 = none$3;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ none$4 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$8 = none$4;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ none$;
            None$ none$5;
            None$ none$6 = none$5 = None$.MODULE$;
            none$5 = null;
            None$ x$12 = none$6;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$12, 0, 3));
            None$ none$7 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$16 = none$7;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$16, 100, 3));
        }
        this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "5000");
        this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationUnderMinIsr(String quorum) {
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$12, x$2, x$3, x$4, x$5);
        Properties linkProps = new Properties();
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp(), "-1");
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.linkName();
        ClusterLinkTestHarness x$7 = this.sourceCluster();
        long x$9 = qual$2.createDestClusterLink$default$3();
        long x$10 = qual$2.createDestClusterLink$default$4();
        long x$11 = qual$2.createDestClusterLink$default$5();
        qual$2.createDestClusterLink(x$6, x$7, x$9, x$10, x$11, linkProps);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$122 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$122, x$13, x$14, x$15, x$16);
        this.produceToSourceCluster(2);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        KafkaBroker destLeader = this.destCluster().partitionLeader(tp);
        scala.collection.immutable.Map destFollowers = ((IterableOnceOps)((IterableOps)this.destCluster().brokers().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$1(destLeader, x$1)))).map((Function1 & Serializable)follower -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)follower.config().brokerId())), follower))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        destFollowers.foreach((Function1 & Serializable)follower -> {
            ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$3(this, follower);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$4(this, destLeader, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Destination not under-min-isr with two brokers down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.produceToSourceCluster(10);
        long destOffset = BoxesRunTime.unboxToLong((Object)this.logEndOffset(destLeader, tp).get());
        long sourceOffset = BoxesRunTime.unboxToLong((Object)this.logEndOffset(this.sourceCluster().partitionLeader(tp), tp).get());
        Assertions.assertTrue((sourceOffset > destOffset ? 1 : 0) != 0, (String)new StringBuilder(62).append("Records mirrored with under-min-isrs sourceOffset=").append(sourceOffset).append(" destOffset=").append(destOffset).toString());
        destFollowers.foreach((Function1 & Serializable)follower -> {
            ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$6(this, follower);
            return BoxedUnit.UNIT;
        });
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceToSourceCluster(10);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRestartPausedLink(String quorum) {
        void var30_43;
        Tuple2 tuple2;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$22 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$52 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$22, x$3, x$4, x$52);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.linkName();
        ClusterLinkTestHarness x$7 = this.sourceCluster();
        long x$8 = qual$2.createDestClusterLink$default$3();
        long x$9 = qual$2.createDestClusterLink$default$4();
        long x$10 = qual$2.createDestClusterLink$default$5();
        Properties x$11 = qual$2.createDestClusterLink$default$6();
        UUID linkId = qual$2.createDestClusterLink(x$6, x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$12, x$13, x$14, x$15, x$16);
        this.produceToSourceCluster(2);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ObjectRef destLeader = ObjectRef.create((Object)this.destCluster().partitionLeader(tp));
        Buffer buffer = (Buffer)this.destCluster().brokers().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$1(destLeader, x$2)));
        this.destCluster().shutdownBroker(((KafkaBroker)buffer.head()).config().brokerId());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            this.produceToSourceCluster(2);
            if (((Partition)((KafkaBroker)destLeader.elem).replicaManager().onlinePartition(tp).get()).isUnderReplicated()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Destination not under-replicated with a broker down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitForMirror((Seq<KafkaBroker>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaBroker[]{(KafkaBroker)destLeader.elem}))), this.waitForMirror$default$2());
        Option<Object> endOffset = this.logEndOffset((KafkaBroker)destLeader.elem, tp);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))), (scala.collection.immutable.Seq<KafkaBroker>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaBroker[]{(KafkaBroker)destLeader.elem}))));
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testRestartPausedLink$4(this, linkId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"ClusterLink is not paused in one or more brokers.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        this.produceToSourceCluster(2);
        this.destCluster().shutdownBroker(((KafkaBroker)buffer.apply(1)).config().brokerId());
        this.destCluster().shutdownBroker(((KafkaBroker)destLeader.elem).config().brokerId());
        this.destCluster().startBroker(((KafkaBroker)destLeader.elem).config().brokerId());
        destLeader.elem = this.destCluster().partitionLeader(tp);
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                bl = !((KafkaBroker)destLeader.elem).replicaManager().getPartitionOrException(tp).isBlockedOnMirrorSource();
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"Paused partition should not be blocked on source");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        Assertions.assertEquals(endOffset, this.logEndOffset((KafkaBroker)destLeader.elem, tp));
        buffer = (Buffer)buffer.map((Function1 & Serializable)follower -> this.destCluster().startBroker(follower.config().brokerId()));
        scala.collection.immutable.Seq expectedOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{endOffset, endOffset}));
        long l7 = 15000L;
        long l8 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Buffer buffer2;
            Buffer buffer3 = buffer2 = (Buffer)buffer.map((Function1 & Serializable)x$5 -> this.logEndOffset((KafkaBroker)x$5, tp$2));
            buffer2 = null;
            Buffer computeUntilTrue_result = buffer3;
            if (ClusterLinkIsrTest.$anonfun$testRestartPausedLink$13(expectedOffsets, computeUntilTrue_result)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l7) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l7), l8));
        }
        Tuple2 tuple22 = tuple2;
        Object var43_40 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Buffer offsets = (Buffer)tuple23._1();
        Assertions.assertEquals((Object)expectedOffsets, (Object)var30_43);
        long l9 = 15000L;
        long l10 = 100L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!(!((Partition)((KafkaBroker)destLeader.elem).replicaManager().onlinePartition(tp).get()).isUnderReplicated())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + l9) {
                Assertions.fail((String)"Destination follower unable to join ISR with paused link");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l9), l10));
        }
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$17 = this.linkName();
        Map x$18 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$19 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$17, (Map<String, String>)x$18, x$19);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceToSourceCluster(2);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationUnderMinIsr$1(KafkaBroker destLeader$1, KafkaBroker x$1) {
        KafkaBroker kafkaBroker = x$1;
        return !(kafkaBroker != null ? !kafkaBroker.equals(destLeader$1) : destLeader$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testDestinationUnderMinIsr$3(ClusterLinkIsrTest $this, Tuple2 follower) {
        $this.destCluster().killBrokerById(follower._1$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationUnderMinIsr$4(ClusterLinkIsrTest $this, KafkaBroker destLeader$1, TopicPartition tp$1) {
        $this.produceToSourceCluster(2);
        return ((Partition)destLeader$1.replicaManager().onlinePartition(tp$1).get()).isUnderMinIsr();
    }

    public static final /* synthetic */ String $anonfun$testDestinationUnderMinIsr$5() {
        return "Destination not under-min-isr with two brokers down";
    }

    public static final /* synthetic */ void $anonfun$testDestinationUnderMinIsr$6(ClusterLinkIsrTest $this, Tuple2 follower) {
        ClusterLinkTestHarness qual$4 = $this.destCluster();
        int x$17 = follower._1$mcI$sp();
        boolean x$18 = qual$4.restartDeadBrokerById$default$2();
        qual$4.restartDeadBrokerById(x$17, x$18);
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$1(ObjectRef destLeader$2, KafkaBroker x$2) {
        KafkaBroker kafkaBroker = x$2;
        KafkaBroker kafkaBroker2 = (KafkaBroker)destLeader$2.elem;
        return !(kafkaBroker != null ? !kafkaBroker.equals(kafkaBroker2) : kafkaBroker2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$2(ClusterLinkIsrTest $this, ObjectRef destLeader$2, TopicPartition tp$2) {
        $this.produceToSourceCluster(2);
        return ((Partition)((KafkaBroker)destLeader$2.elem).replicaManager().onlinePartition(tp$2).get()).isUnderReplicated();
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$3() {
        return "Destination not under-replicated with a broker down";
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$6(ClusterLinkFactory.ConnectionManager x$4) {
        return !x$4.active();
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$5(UUID linkId$1, KafkaBroker x$3) {
        return x$3.clusterLinkManager().connectionManager(linkId$1).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$6(x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$4(ClusterLinkIsrTest $this, UUID linkId$1) {
        return $this.destCluster().aliveServers().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$5(linkId$1, x$3)));
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$7() {
        return "ClusterLink is not paused in one or more brokers.";
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$8(ObjectRef destLeader$2, TopicPartition tp$2) {
        boolean bl;
        try {
            if (((KafkaBroker)destLeader$2.elem).replicaManager().getPartitionOrException(tp$2).isBlockedOnMirrorSource()) {
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$9() {
        return "Paused partition should not be blocked on source";
    }

    public static final /* synthetic */ Buffer $anonfun$testRestartPausedLink$11(ClusterLinkIsrTest $this, ObjectRef destFollowers$1, TopicPartition tp$2) {
        return (Buffer)((Buffer)destFollowers$1.elem).map((Function1 & Serializable)x$5 -> this.logEndOffset((KafkaBroker)x$5, tp$2));
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$13(scala.collection.immutable.Seq expectedOffsets$1, Buffer x$6) {
        Buffer buffer = x$6;
        return !(buffer != null ? !buffer.equals(expectedOffsets$1) : expectedOffsets$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$14(ObjectRef destLeader$2, TopicPartition tp$2) {
        return !((Partition)((KafkaBroker)destLeader$2.elem).replicaManager().onlinePartition(tp$2).get()).isUnderReplicated();
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$15() {
        return "Destination follower unable to join ISR with paused link";
    }

    public static final /* synthetic */ Object $anonfun$testRestartPausedLink$13$adapted(scala.collection.immutable.Seq expectedOffsets$1, Buffer x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$13(expectedOffsets$1, x$6));
    }
}

