/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.lang.reflect.Method;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\r\u001b\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0015\t\u0013U\u0002\u0001\u0019!a\u0001\n\u00131\u0004\"C \u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%\u0001\u0005\u00011AA\u0002\u0013%\u0011\tC\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\"I\u0001\n\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\n\u0005C\u0011B\u0013\u0001A\u0002\u0003\u0007I\u0011B&\t\u00135\u0003\u0001\u0019!A!B\u0013\u0011\u0005\"\u0002(\u0001\t\u0003z\u0005\"\u0002,\u0001\t\u00139\u0006\"\u0002/\u0001\t\u0003i\u0006\"\u00022\u0001\t\u0003i\u0006\"\u00023\u0001\t\u0003)\u0007BBA\u000b\u0001\u0011\u0005Q\f\u0003\u0004\u0002\u001a\u0001!\t!\u0018\u0005\u0007\u0003;\u0001A\u0011A/\t\r\u0005\u0005\u0002\u0001\"\u0001^\u0011\u0019\t)\u0003\u0001C\u0001;\"1\u0011\u0011\u0006\u0001\u0005\nuCq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u0002,\u0001!I!!\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\tqB*\u001b8l\u0007>|'\u000fZ5oCR|'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u00037q\tA\u0001\\5oW*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011#\u001b\u0005Q\u0012BA\u0012\u001b\u0005\t\n%m\u001d;sC\u000e$8\t\\;ti\u0016\u0014H*\u001b8l\u0013:$Xm\u001a:bi&|g\u000eV3ti\u00061A(\u001b8jiz\"\u0012A\n\t\u0003C\u0001\t\u0011b\u0018;fgRLeNZ8\u0016\u0003%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002/_\u00059!.\u001e9ji\u0016\u0014(B\u0001\u00192\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0014aA8sO&\u0011Ag\u000b\u0002\t)\u0016\u001cH/\u00138g_\u0006iq\f^3ti&sgm\\0%KF$\"aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b}\r\t\t\u00111\u0001*\u0003\rAH%M\u0001\u000b?R,7\u000f^%oM>\u0004\u0013!G3oC\ndWmU8ve\u000e,W*\u001a;bI\u0006$\u0018\rV8qS\u000e,\u0012A\u0011\t\u0003q\rK!\u0001R\u001d\u0003\u000f\t{w\u000e\\3b]\u0006iRM\\1cY\u0016\u001cv.\u001e:dK6+G/\u00193bi\u0006$v\u000e]5d?\u0012*\u0017\u000f\u0006\u00028\u000f\"9aHBA\u0001\u0002\u0004\u0011\u0015AG3oC\ndWmU8ve\u000e,W*\u001a;bI\u0006$\u0018\rV8qS\u000e\u0004\u0013aF3oC\ndW\rR3ti6+G/\u00193bi\u0006$v\u000e]5d\u0003m)g.\u00192mK\u0012+7\u000f^'fi\u0006$\u0017\r^1U_BL7m\u0018\u0013fcR\u0011q\u0007\u0014\u0005\b}%\t\t\u00111\u0001C\u0003a)g.\u00192mK\u0012+7\u000f^'fi\u0006$\u0017\r^1U_BL7\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003oACQ!U\u0006A\u0002%\n\u0001\u0002^3ti&sgm\u001c\u0015\u0003\u0017M\u0003\"A\u000b+\n\u0005U[#A\u0003\"fM>\u0014X-R1dQ\u0006i1/\u001a;va\u000ecWo\u001d;feN$Ba\u000e-[7\")\u0011\f\u0004a\u0001\u0005\u0006y1o\\;sG\u0016Le.\u001b;jCR,G\rC\u0003A\u0019\u0001\u0007!\tC\u0003J\u0019\u0001\u0007!)A\u0014uKN$H)Z:u\u0013:LG/[1uK\u0012\u001cuN\u001c;s_2dWM\u001d+p\u0007>tGO]8mY\u0016\u0014H#A\u001c)\u00055y\u0006C\u0001\u0016a\u0013\t\t7F\u0001\u0003UKN$\u0018!\u000b;fgR\u001cv.\u001e:dK&s\u0017\u000e^5bi\u0016$7i\u001c8ue>dG.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0002\u000f?\u0006)C/Z:u\t\u0016\u001cH/\u00138ji&\fG/\u001a3MS:\\7i\\8sIR{G*\u001b8l\u0007>|'\u000f\u001a\u000b\u0003o\u0019DQaZ\bA\u0002!\fa!];peVl\u0007CA5q\u001d\tQg\u000e\u0005\u0002ls5\tAN\u0003\u0002n=\u00051AH]8pizJ!a\\\u001d\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_fBCa\u0004;}{B\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\taJ|g/\u001b3fe*\u0011\u00110L\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005m4(a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000fL\u0002\u007f\u0003\u0003\t\u0013a`\u0001\u0003u.\f#!a\u0001\u0002\u000b-\u0014\u0018M\u001a;)\u000f=\t9!a\u0004\u0002\u0012A!\u0011\u0011BA\u0006\u001b\u0005A\u0018bAA\u0007q\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003'\t\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003\u001d\"Xm\u001d;T_V\u00148-Z%oSRL\u0017\r^3e\u0019&t7nQ8pe\u0012$v\u000eT5oW\u000e{wN\u001d3)\u0005Ay\u0016A\n;fgR$Um\u001d;J]&$\u0018.\u0019;fI\u000e{g\u000e\u001e:pY2,'\u000fV8MS:\\7i\\8sI\"\u0012\u0011cX\u0001)i\u0016\u001cHoU8ve\u000e,\u0017J\\5uS\u0006$X\rZ\"p]R\u0014x\u000e\u001c7feR{G*\u001b8l\u0007>|'\u000f\u001a\u0015\u0003%}\u000ba\u0005^3ti\u0012+7\u000f^%oSRL\u0017\r^3e\u0019&t7nQ8pe\u0012$vnQ8oiJ|G\u000e\\3sQ\t\u0019r,\u0001\u0015uKN$8k\\;sG\u0016Le.\u001b;jCR,G\rT5oW\u000e{wN\u001d3U_\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0002\u0015?\u00069b/\u001a:jMf\u001cun\u001c:eS:\fGo\u001c:DQ\u0006tw-Z\u0001\u0012G\"\fgnZ3D_>\u0014H-\u001b8bi>\u0014HcA\u001c\u00020!9\u0011\u0011\u0007\fA\u0002\u0005M\u0012aB2mkN$XM\u001d\t\u0004C\u0005U\u0012bAA\u001c5\t12\t\\;ti\u0016\u0014H*\u001b8l)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fF\u00038\u0003w\ti\u0004C\u0004\u00022]\u0001\r!a\r\t\r\u0005}r\u00031\u0001C\u0003M)g.\u00192mK6+G/\u00193bi\u0006$v\u000e]5d\u0003ua\u0017N\\6OC6,Gk\\'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]&#GCBA#\u0003\u0017\ny\u0005E\u00029\u0003\u000fJ1!!\u0013:\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u001bB\u0002\u0019\u00015\u0002\u00111Lgn\u001b(b[\u0016Dq!!\u0015\u0019\u0001\u0004\t\u0019&A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s!\u0011\t)&!\u0018\u000e\u0005\u0005]#bA\u000e\u0002Z)\u0019\u00111\f\u000f\u0002\rM,'O^3s\u0013\u0011\ty&a\u0016\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:)\u000f\u0001\t\u0019'!\u001b\u0002lA\u0019!&!\u001a\n\u0007\u0005\u001d4FA\u0002UC\u001e\fQA^1mk\u0016\f#!!\u001c\u0002\u0017%tG/Z4sCRLwN\u001c")
public class LinkCoordinatorIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;
    private boolean enableSourceMetadataTopic;
    private boolean enableDestMetadataTopic;

    private TestInfo _testInfo() {
        return this._testInfo;
    }

    private void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    private boolean enableSourceMetadataTopic() {
        return this.enableSourceMetadataTopic;
    }

    private void enableSourceMetadataTopic_$eq(boolean x$1) {
        this.enableSourceMetadataTopic = x$1;
    }

    private boolean enableDestMetadataTopic() {
        return this.enableDestMetadataTopic;
    }

    private void enableDestMetadataTopic_$eq(boolean x$1) {
        this.enableDestMetadataTopic = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo_$eq(testInfo);
    }

    private void setupClusters(boolean sourceInitiated, boolean enableSourceMetadataTopic, boolean enableDestMetadataTopic) {
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo()) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ none$;
            None$ none$2;
            None$ none$3 = none$2 = None$.MODULE$;
            none$2 = null;
            None$ x$4 = none$3;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ none$4 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$8 = none$4;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ none$;
            None$ none$5;
            None$ none$6 = none$5 = None$.MODULE$;
            none$5 = null;
            None$ x$12 = none$6;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$12, 0, 3));
            None$ none$7 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$16 = none$7;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$16, 100, 3));
        }
        this.useSourceInitiatedLink_$eq(sourceInitiated);
        this.enableSourceMetadataTopic_$eq(enableSourceMetadataTopic);
        this.enableDestMetadataTopic_$eq(enableDestMetadataTopic);
        if (enableSourceMetadataTopic) {
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        if (enableDestMetadataTopic) {
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        super.setUp(this._testInfo());
    }

    @Test
    public void testDestInitiatedControllerToController() {
        this.setupClusters(false, false, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToController() {
        this.setupClusters(true, false, false);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestInitiatedLinkCoordToLinkCoord(String quorum) {
        this.setupClusters(false, true, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedLinkCoordToLinkCoord() {
        this.setupClusters(true, true, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedControllerToLinkCoord() {
        this.setupClusters(false, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToLinkCoord() {
        this.setupClusters(true, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedLinkCoordToController() {
        this.setupClusters(false, true, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedLinkCoordToController() {
        this.setupClusters(true, true, false);
        this.verifyCoordinatorChange();
    }

    private void verifyCoordinatorChange() {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.destCluster());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.sourceCluster());
        this.produceToSourceCluster(10);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    private void changeCoordinator(ClusterLinkTestHarness cluster) {
        if (cluster == this.sourceCluster()) {
            this.changeCoordinator(this.sourceCluster(), this.enableSourceMetadataTopic());
            return;
        }
        if (cluster == this.destCluster()) {
            this.changeCoordinator(this.destCluster(), this.enableDestMetadataTopic());
        }
    }

    private void changeCoordinator(ClusterLinkTestHarness cluster, boolean enableMetadataTopic) {
        if (enableMetadataTopic) {
            String metadataTopic = "_confluent-link-metadata";
            KafkaBroker linkCoordinator = cluster.linkCoordinator(this.linkName());
            int partition = this.linkNameToMetadataPartitionId(this.linkName(), LinkCoordinatorIntegrationTest.metadataManager$1(linkCoordinator));
            int newLeader = cluster.changeLeader(new TopicPartition(metadataTopic, partition));
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!LinkCoordinatorIntegrationTest.$anonfun$changeCoordinator$1(this, cluster, newLeader)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"New link coordinator not elected");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            return;
        }
        cluster.changeController();
    }

    private int linkNameToMetadataPartitionId(String linkName, ClusterLinkMetadataManager metadataManager) {
        Method method = metadataManager.getClass().getSuperclass().getDeclaredMethod("linkNameToPartitionId", String.class);
        method.setAccessible(true);
        return BoxesRunTime.unboxToInt((Object)method.invoke((Object)metadataManager, linkName));
    }

    private static final ClusterLinkMetadataManager metadataManager$1(KafkaBroker server) {
        return ((ClusterLinkManager)server.clusterLinkManager()).metadataManager();
    }

    public static final /* synthetic */ boolean $anonfun$changeCoordinator$1(LinkCoordinatorIntegrationTest $this, ClusterLinkTestHarness cluster$1, int newLeader$1) {
        ClusterLinkMetadataManager qual$1 = LinkCoordinatorIntegrationTest.metadataManager$1(cluster$1.brokerWithId(newLeader$1));
        String x$1 = $this.linkName();
        boolean x$2 = qual$1.isLinkCoordinator$default$2();
        return qual$1.isLinkCoordinator(x$1, x$2);
    }

    public static final /* synthetic */ String $anonfun$changeCoordinator$2() {
        return "New link coordinator not elected";
    }
}

