/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.MergedLog$;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t-e\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004R\u0001\u0001\u0006Ia\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019Q\u0006\u0001)A\u0005)\"91\f\u0001b\u0001\n\u0013a\u0006BB2\u0001A\u0003%Q\fC\u0004e\u0001\t\u0007I\u0011B3\t\r9\u0004\u0001\u0015!\u0003g\u0011\u001dy\u0007A1A\u0005\n\u0015Da\u0001\u001d\u0001!\u0002\u00131\u0007\"B9\u0001\t\u0003\u0011\bBBA\u0004\u0001\u0011\u0005!\u000f\u0003\u0004\u0002\u0012\u0001!\tA\u001d\u0005\u0007\u00037\u0001A\u0011\u0001:\t\u000f\u0005E\u0001\u0001\"\u0001\u0002 \u00191\u0011\u0011\u0006\u0001\u0005\u0003WA\u0011BO\t\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005\u001d\u0013C!A!\u0002\u0013\tI\u0005\u0003\u0004F#\u0011\u0005\u0011q\n\u0005\n\u00033\n\"\u0019!C\u0001\u00037B\u0001Ba\t\u0012A\u0003%\u0011Q\f\u0005\u0007\u0005K\tB\u0011\t:\u0007\r\t\u001d\u0002\u0001\u0002B\u0015\u0011%Q\u0004D!A!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002Ha\u0011\t\u0011)A\u0005\u0003+Ca!\u0012\r\u0005\u0002\t-\u0002B\u0002B\u00131\u0011\u0005#\u000fC\u0004\u00034\u0001!IA!\u000e\t\u0013\t\u0005\u0003!%A\u0005\n\t\r\u0003b\u0002B$\u0001\u0011%!\u0011\n\u0004\u0007\u0003_\u0002A)!\u001d\t\u0015\u0005E\u0005E!f\u0001\n\u0003\t\u0019\n\u0003\u0006\u0002\u001c\u0002\u0012\t\u0012)A\u0005\u0003+C!\"!(!\u0005+\u0007I\u0011AAP\u0011)\t\t\u000b\tB\tB\u0003%\u0011\u0011\n\u0005\u0007\u000b\u0002\"\t!a)\t\u000f\u0005%\u0006\u0005\"\u0011\u0002,\"I\u0011Q\u0018\u0011\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u000b\u0004\u0013\u0013!C\u0001\u0003\u000fD\u0011\"!8!#\u0003%\t!a8\t\u0013\u0005\r\b%!A\u0005B\u0005\u0015\b\"CAvA\u0005\u0005I\u0011AAP\u0011%\ti\u000fIA\u0001\n\u0003\ty\u000fC\u0005\u0002|\u0002\n\t\u0011\"\u0011\u0002~\"I!q\u0001\u0011\u0002\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005'\u0001\u0013\u0011!C!\u0005+A\u0011B!\u0007!\u0003\u0003%\tEa\u0007\t\u0013\tu\u0001%!A\u0005B\t}q!\u0003B+\u0001\u0005\u0005\t\u0012\u0002B,\r%\ty\u0007AA\u0001\u0012\u0013\u0011I\u0006\u0003\u0004Fg\u0011\u0005!1\u000e\u0005\n\u0003S\u001b\u0014\u0011!C#\u0005[B\u0011Ba\u001c4\u0003\u0003%\tI!\u001d\t\u0013\t]4'!A\u0005\u0002\ne$A\u0005'pO\u000e{gnY;se\u0016t7-\u001f+fgRT!AO\u001e\u0002\u00071|wMC\u0001=\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\t\u0005\u0002I\u00015\t\u0011(\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002Ow\u000511/\u001a:wKJL!\u0001U'\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00051!/\u00198e_6,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\u000bA!\u001e;jY&\u0011\u0011L\u0016\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005I1o\u00195fIVdWM]\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mO\u0001\u0006kRLGn]\u0005\u0003E~\u0013abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\na\u0001^7q\t&\u0014X#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017AA5p\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013!B:fiV\u0004H#A:\u0011\u0005\u0001#\u0018BA;B\u0005\u0011)f.\u001b;)\u000519\bc\u0001=\u0002\u00045\t\u0011P\u0003\u0002{w\u0006\u0019\u0011\r]5\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}~\fQA[;oSRT!!!\u0001\u0002\u0007=\u0014x-C\u0002\u0002\u0006e\u0014!BQ3g_J,W)Y2i\u0003!\u0019\b.\u001e;e_^t\u0007fA\u0007\u0002\fA\u0019\u00010!\u0004\n\u0007\u0005=\u0011PA\u0005BMR,'/R1dQ\u0006qB/Z:u+:\u001cw.\\7jiR,G\rR1uC:{GoQ8ogVlW\r\u001a\u0015\u0004\u001d\u0005U\u0001c\u0001=\u0002\u0018%\u0019\u0011\u0011D=\u0003\tQ+7\u000f^\u00013i\u0016\u001cH/\u00168d_6l\u0017\u000e\u001e;fI\u0012\u000bG/\u0019(pi\u000e{gn];nK\u00124%/Z9vK:$8+Z4nK:$(k\u001c7mg\"\u001aq\"!\u0006\u0015\u0007M\f\t\u0003\u0003\u0004;!\u0001\u0007\u00111\u0005\t\u0004\u0011\u0006\u0015\u0012bAA\u0014s\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u00051\u0019uN\\:v[\u0016\u0014H+Y:l'\u0015\t\u0012QFA\u001d!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001aU\u0006!A.\u00198h\u0013\u0011\t9$!\r\u0003\r=\u0013'.Z2u!\u0015\tY$a\u0011t\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AC2p]\u000e,(O]3oi*\u0011qK[\u0005\u0005\u0003\u000b\niD\u0001\u0005DC2d\u0017M\u00197f\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\t\u0004\u0001\u0006-\u0013bAA'\u0003\n\u0019\u0011J\u001c;\u0015\r\u0005E\u0013QKA,!\r\t\u0019&E\u0007\u0002\u0001!1!\b\u0006a\u0001\u0003GAq!a\u0012\u0015\u0001\u0004\tI%A\bd_:\u001cX/\\3e\u0005\u0006$8\r[3t+\t\ti\u0006\u0005\u0004\u0002`\u0005%\u0014QN\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001e;bE2,'bAA4\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bcAA*A\taa)\u001a;dQ\u0016$')\u0019;dQN1\u0001ePA:\u0003s\u00022\u0001QA;\u0013\r\t9(\u0011\u0002\b!J|G-^2u!\u0011\tY(a#\u000f\t\u0005u\u0014q\u0011\b\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111Q\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015bAAE\u0003\u00069\u0001/Y2lC\u001e,\u0017\u0002BAG\u0003\u001f\u0013AbU3sS\u0006d\u0017N_1cY\u0016T1!!#B\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0003\u0003+\u00032\u0001QAL\u0013\r\tI*\u0011\u0002\u0005\u0019>tw-A\u0006cCN,wJ\u001a4tKR\u0004\u0013!B3q_\u000eDWCAA%\u0003\u0019)\u0007o\\2iAQ1\u0011QNAS\u0003OCq!!%&\u0001\u0004\t)\nC\u0004\u0002\u001e\u0016\u0002\r!!\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!,\u0011\t\u0005=\u0016q\u0017\b\u0005\u0003c\u000b\u0019\fE\u0002\u0002\u0000\u0005K1!!.B\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011XA^\u0005\u0019\u0019FO]5oO*\u0019\u0011QW!\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003[\n\t-a1\t\u0013\u0005Eu\u0005%AA\u0002\u0005U\u0005\"CAOOA\u0005\t\u0019AA%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!3+\t\u0005U\u00151Z\u0016\u0003\u0003\u001b\u0004B!a4\u0002Z6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0005v]\u000eDWmY6fI*\u0019\u0011q[!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\\\u0006E'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAqU\u0011\tI%a3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u000f\u0005\u0003\u00020\u0005%\u0018\u0002BA]\u0003c\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002r\u0006]\bc\u0001!\u0002t&\u0019\u0011Q_!\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002z2\n\t\u00111\u0001\u0002J\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a@\u0011\r\t\u0005!1AAy\u001b\t\t)'\u0003\u0003\u0003\u0006\u0005\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0003\u0003\u0012A\u0019\u0001I!\u0004\n\u0007\t=\u0011IA\u0004C_>dW-\u00198\t\u0013\u0005eh&!AA\u0002\u0005E\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a:\u0003\u0018!I\u0011\u0011`\u0018\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011J\u0001\u0007KF,\u0018\r\\:\u0015\t\t-!\u0011\u0005\u0005\n\u0003s\f\u0014\u0011!a\u0001\u0003c\f\u0001cY8ogVlW\r\u001a\"bi\u000eDWm\u001d\u0011\u0002\t\r\fG\u000e\u001c\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012$\u0016m]6\u0014\u000ba\ti#!\u000f\u0015\r\t5\"q\u0006B\u0019!\r\t\u0019\u0006\u0007\u0005\u0007um\u0001\r!a\t\t\u000f\u0005\u001d3\u00041\u0001\u0002\u0016\u0006I1M]3bi\u0016dun\u001a\u000b\u0005\u0003G\u00119\u0004C\u0005\u0003:u\u0001\n\u00111\u0001\u0003<\u000511m\u001c8gS\u001e\u00042\u0001\u0013B\u001f\u0013\r\u0011y$\u000f\u0002\n\u0019><7i\u001c8gS\u001e\f1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIE*\"A!\u0012+\t\tm\u00121Z\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e{gn];nK\u0012$\u0015\r^1\u0015\u000bM\u0014YE!\u0014\t\riz\u0002\u0019AA\u0012\u0011\u001d\tIf\ba\u0001\u0005\u001f\u0002b!a\u001f\u0003R\u00055\u0014\u0002\u0002B*\u0003\u001f\u0013\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\r\r\u0016$8\r[3e\u0005\u0006$8\r\u001b\t\u0004\u0003'\u001a4#B\u001a\u0003\\\t\u001d\u0004C\u0003B/\u0005G\n)*!\u0013\u0002n5\u0011!q\f\u0006\u0004\u0005C\n\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005K\u0012yFA\tBEN$(/Y2u\rVt7\r^5p]J\u00022a\u001aB5\u0013\r\ti\t\u001b\u000b\u0003\u0005/\"\"!a:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u00055$1\u000fB;\u0011\u001d\t\tJ\u000ea\u0001\u0003+Cq!!(7\u0001\u0004\tI%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm$q\u0011\t\u0006\u0001\nu$\u0011Q\u0005\u0004\u0005\u007f\n%AB(qi&|g\u000eE\u0004A\u0005\u0007\u000b)*!\u0013\n\u0007\t\u0015\u0015I\u0001\u0004UkBdWM\r\u0005\n\u0005\u0013;\u0014\u0011!a\u0001\u0003[\n1\u0001\u001f\u00131\u0001")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, "kafka-scheduler-", true, false);
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(AbstractLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private AbstractLog createLog(LogConfig config) {
        None$ none$;
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$;
        File x$1 = this.logDir();
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Metrics x$7 = new Metrics();
        Time x$8 = Time.SYSTEM;
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        None$ x$14 = None$.MODULE$;
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$2 = noOpLogOffsetsListener$ = NoOpLogOffsetsListener$.MODULE$;
        noOpLogOffsetsListener$ = null;
        NoOpLogOffsetsListener$ x$17 = noOpLogOffsetsListener$2;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$18 = none$2;
        return MergedLog$.MODULE$.apply(x$1, config, 0L, 0L, (Scheduler)x$5, x$6, x$7, x$8, 300000, 3600000, x$11, x$12, x$13, true, (Option)x$14, true, (LogOffsetsListener)x$17, (Option)x$18);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
    }

    private void validateConsumedData(AbstractLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.localLogSegments().foreach((Function1 & Serializable)segment -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$1(iter, segment);
            return BoxedUnit.UNIT;
        });
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$1(Iterator iter$1, LogSegment segment) {
        segment.log().batches().forEach(batch -> {
            if (iter$1.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter$1.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(0).append(new StringBuilder(16).append("Consumed batch ").append(consumedBatch).append(" ").toString()).append(new StringBuilder(42).append("does not match next expected batch in log ").append(batch).toString()).toString(), t);
                }
            }
        });
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.readLocal(fetchOffset.elem, 1, (FetchIsolation)FetchHighWatermark$.MODULE$, true).records().batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, AbstractLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "baseOffset";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer();
                    if (!bl) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (!(this.baseOffset() == fetchedBatch.baseOffset() && this.epoch() == fetchedBatch.epoch() && fetchedBatch.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        CompressionType compressionType;
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset();
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)));
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte by = 2;
                        CompressionType compressionType2 = compressionType = CompressionType.NONE;
                        compressionType = null;
                        CompressionType x$5 = compressionType2;
                        long l = -1L;
                        short s = -1;
                        int n2 = -1;
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, by, x$5, l, s, n2, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, AbstractLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

