/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.LazyIndex;
import kafka.log.LazyIndex$;
import kafka.log.LocalLog$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.ProducerStateManager$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.log.TierLogSegment;
import kafka.log.TransactionIndex;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class LogTestUtils$ {
    public static final LogTestUtils$ MODULE$ = new LogTestUtils$();

    /*
     * WARNING - void declaration
     */
    public LogSegment createSegment(long offset, File logDir, int indexIntervalBytes, Time time, boolean fileAlreadyExists) {
        String string;
        String string2;
        String string3;
        void open_preallocate;
        void open_initFileSize;
        FileRecords fileRecords;
        String string4;
        String string5 = string4 = "";
        string4 = null;
        String logFile_suffix = string5;
        Object var11_7 = null;
        boolean bl = false;
        boolean bl2 = false;
        File open_file = LocalLog$.MODULE$.logFile(logDir, offset, logFile_suffix);
        FileRecords fileRecords2 = fileRecords = FileRecords.open((File)open_file, (boolean)true, (boolean)fileAlreadyExists, (int)open_initFileSize, (boolean)open_preallocate);
        Object var12_10 = null;
        fileRecords = null;
        FileRecords ms = fileRecords2;
        String string6 = string3 = "";
        string3 = null;
        String offsetIndexFile_suffix = string6;
        Object var16_14 = null;
        LazyIndex idx = LazyIndex$.MODULE$.forOffset(LocalLog$.MODULE$.offsetIndexFile(logDir, offset, offsetIndexFile_suffix), fileAlreadyExists, offset, 1000, true);
        String string7 = string2 = "";
        string2 = null;
        String timeIndexFile_suffix = string7;
        Object var17_17 = null;
        LazyIndex timeIdx = LazyIndex$.MODULE$.forTime(LocalLog$.MODULE$.timeIndexFile(logDir, offset, timeIndexFile_suffix), fileAlreadyExists, offset, 1500, true);
        String string8 = string = "";
        string = null;
        String transactionIndexFile_suffix = string8;
        Object var18_20 = null;
        TransactionIndex txnIndex = new TransactionIndex(offset, LocalLog$.MODULE$.transactionIndexFile(logDir, offset, transactionIndexFile_suffix), fileAlreadyExists);
        return new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, time);
    }

    public int createSegment$default$3() {
        return 10;
    }

    public Time createSegment$default$4() {
        return Time.SYSTEM;
    }

    public boolean createSegment$default$5() {
        return false;
    }

    public LogSegment createLocalLogSegment(long startOffset, long endOffset, File logDir, int indexIntervalBytes, Time time, long maxTimestamp) {
        LogSegment segment = this.createSegment(startOffset, logDir, indexIntervalBytes, time, false);
        List dummyData = (List)package$.MODULE$.List().fill((int)(endOffset - startOffset + 1L), (Function0 & Serializable)() -> "dummy_data");
        MemoryRecords recordList = this.records(startOffset, (Seq<String>)dummyData);
        segment.append(endOffset, recordList);
        return segment;
    }

    public int createLocalLogSegment$default$4() {
        return 10;
    }

    public Time createLocalLogSegment$default$5() {
        return Time.SYSTEM;
    }

    public long createLocalLogSegment$default$6() {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(long offset, Seq<String> records) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)records.map((Function1 & Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public TierLogSegment createTierLogSegment(TopicIdPartition topicIdPartition, long startOffset, long endOffset, TierObjectStore objectStore, TierObjectMetadata.State state, long maxTimestamp, long firstBatchTimestamp) {
        int segmentSize = (int)(endOffset - startOffset + 1L);
        SegmentState tierMetadata = new SegmentState(0, UUID.randomUUID(), startOffset, startOffset, endOffset, maxTimestamp, firstBatchTimestamp, segmentSize, state, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, -1L);
        return new TierLogSegment(topicIdPartition, tierMetadata);
    }

    public TierObjectMetadata.State createTierLogSegment$default$5() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
    }

    public long createTierLogSegment$default$6() {
        return 1L;
    }

    public long createTierLogSegment$default$7() {
        return 1L;
    }

    public LogConfig createLogConfig(long segmentMs, int segmentBytes, long retentionMs, long retentionBytes, long segmentJitterMs, String cleanupPolicy, int maxMessageBytes, int indexIntervalBytes, int segmentIndexBytes, String messageFormatVersion, long fileDeleteDelayMs, boolean tierEnable, long tierLocalHotsetBytes, long tierLocalHotsetMs, int tierSegmentHotsetRollMinBytes, long preferTierFetchMs, boolean tierCleanerEnable) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(segmentMs));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentBytes));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(retentionMs));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(retentionBytes));
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), Predef$.MODULE$.long2Long(segmentJitterMs));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageBytes));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(indexIntervalBytes));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(segmentIndexBytes));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.long2Long(fileDeleteDelayMs));
        logProps.put(LogConfig$.MODULE$.TierEnableProp(), Predef$.MODULE$.boolean2Boolean(tierEnable));
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetBytesProp(), Predef$.MODULE$.long2Long(tierLocalHotsetBytes));
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetMsProp(), Predef$.MODULE$.long2Long(tierLocalHotsetMs));
        logProps.put(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp(), InterceptorUtils.MockRecordInterceptor.class.getName());
        logProps.put(LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp(), Predef$.MODULE$.int2Integer(tierSegmentHotsetRollMinBytes));
        logProps.put(LogConfig$.MODULE$.PreferTierFetchMsProp(), Predef$.MODULE$.long2Long(preferTierFetchMs));
        logProps.put(LogConfig$.MODULE$.TierCleanerEnableProp(), Predef$.MODULE$.boolean2Boolean(tierCleanerEnable));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public MergedLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel, LogOffsetsListener logOffsetsListener, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile) {
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, new Metrics(), time, maxTransactionTimeoutMs, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, logDirFailureChannel, tierLogComponents, lastShutdownClean, topicId, keepPartitionMetadataFile, logOffsetsListener, (Option)None$.MODULE$);
    }

    public long createLogConfig$default$1() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public int createLogConfig$default$2() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public long createLogConfig$default$3() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public long createLogConfig$default$4() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long createLogConfig$default$5() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public String createLogConfig$default$6() {
        return Defaults$.MODULE$.CleanupPolicy();
    }

    public int createLogConfig$default$7() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int createLogConfig$default$8() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int createLogConfig$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public String createLogConfig$default$10() {
        return Defaults$.MODULE$.MessageFormatVersion();
    }

    public long createLogConfig$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public boolean createLogConfig$default$12() {
        return Defaults$.MODULE$.TierEnable();
    }

    public long createLogConfig$default$13() {
        return Defaults$.MODULE$.TierLocalHotsetBytes();
    }

    public long createLogConfig$default$14() {
        return Defaults$.MODULE$.TierLocalHotsetMs();
    }

    public int createLogConfig$default$15() {
        return Defaults$.MODULE$.TierSegmentHotsetRollMinBytes();
    }

    public long createLogConfig$default$16() {
        return Defaults$.MODULE$.PreferTierFetchMs();
    }

    public boolean createLogConfig$default$17() {
        return true;
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 300000;
    }

    public int createLog$default$9() {
        return 3600000;
    }

    public int createLog$default$10() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public TierLogComponents createLog$default$11() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    public LogDirFailureChannel createLog$default$12() {
        return new LogDirFailureChannel(10);
    }

    public LogOffsetsListener createLog$default$13() {
        return NoOpLogOffsetsListener$.MODULE$;
    }

    public boolean createLog$default$14() {
        return true;
    }

    public Option<Uuid> createLog$default$15() {
        return None$.MODULE$;
    }

    public boolean createLog$default$16() {
        return true;
    }

    public boolean hasOffsetOverflow(AbstractLog log) {
        return this.firstOverflowSegment(log).isDefined();
    }

    public Option<LogSegment> firstOverflowSegment(AbstractLog log) {
        Object object = new Object();
        try {
            log.localLogSegments().foreach((Function1 & Serializable)segment -> {
                LogTestUtils$.$anonfun$firstOverflowSegment$1(object, segment);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public FileRecords rawSegment(File logDir, long baseOffset) {
        File file;
        String string;
        String string2 = string = "";
        string = null;
        String logFile_suffix = string2;
        File file2 = file = LocalLog$.MODULE$.logFile(logDir, baseOffset, logFile_suffix);
        Object var4_4 = null;
        file = null;
        File open_file = file2;
        boolean open_mutable = true;
        return FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
    }

    public void initializeLogDirWithOverflowedSegment(File logDir) {
        long nextOffset = 0L;
        nextOffset = this.writeNormalSegment$1(nextOffset, logDir);
        nextOffset = this.writeOverflowSegment$1(nextOffset, logDir);
        this.writeNormalSegment$1(nextOffset, logDir);
    }

    public Iterable<Object> keysInLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable)logSegment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable)batch -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().withFilter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)record.hasKey())).map((Function1 & Serializable)record -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())))))));
    }

    public AbstractLog recoverAndCheck(File logDir, LogConfig config, Iterable<Object> expectedKeys, BrokerTopicStats brokerTopicStats, Time time, Scheduler scheduler) {
        None$ none$;
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$;
        LogDirFailureChannel logDirFailureChannel;
        TierLogComponents tierLogComponents;
        long l = 0L;
        long l2 = 0L;
        int n = 300000;
        int n2 = 3600000;
        int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        TierLogComponents tierLogComponents2 = tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        tierLogComponents = null;
        TierLogComponents x$12 = tierLogComponents2;
        LogDirFailureChannel logDirFailureChannel2 = logDirFailureChannel = new LogDirFailureChannel(10);
        logDirFailureChannel = null;
        LogDirFailureChannel x$13 = logDirFailureChannel2;
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$2 = noOpLogOffsetsListener$ = NoOpLogOffsetsListener$.MODULE$;
        noOpLogOffsetsListener$ = null;
        NoOpLogOffsetsListener$ x$14 = noOpLogOffsetsListener$2;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$2;
        boolean bl = true;
        MergedLog recoveredLog = this.createLog(logDir, config, brokerTopicStats, scheduler, time, l, l2, n, n2, n3, x$12, x$13, (LogOffsetsListener)x$14, false, (Option<Uuid>)x$15, bl);
        time.sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)file -> {
            LogTestUtils$.$anonfun$recoverAndCheck$1(file);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(expectedKeys, this.keysInLog((AbstractLog)recoveredLog));
        Assertions.assertFalse((boolean)this.hasOffsetOverflow((AbstractLog)recoveredLog));
        return recoveredLog;
    }

    public LogAppendInfo appendEndTxnMarkerAsLeader(AbstractLog log, long producerId, short producerEpoch, ControlRecordType controlType, long timestamp, int coordinatorEpoch, int leaderEpoch) {
        long l = 0L;
        int n = 0;
        MemoryRecords records = this.endTxnRecords(controlType, producerId, producerEpoch, l, coordinatorEpoch, n, timestamp);
        AppendOrigin.Coordinator$ x$9 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$11 = log.appendAsLeader$default$4();
        RequestLocal x$12 = log.appendAsLeader$default$5();
        return log.appendAsLeader(records, leaderEpoch, (AppendOrigin)x$9, x$11, x$12);
    }

    public int appendEndTxnMarkerAsLeader$default$6() {
        return 0;
    }

    public int appendEndTxnMarkerAsLeader$default$7() {
        return 0;
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short epoch, long offset, int coordinatorEpoch, int partitionLeaderEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)epoch, (EndTransactionMarker)marker);
    }

    private long endTxnRecords$default$4() {
        return 0L;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    public FetchDataInfo readLog(AbstractLog log, long startOffset, int maxLength, FetchIsolation isolation, boolean minOneMessage) {
        return (FetchDataInfo)log.read(startOffset, maxLength, isolation, minOneMessage, false);
    }

    public FetchIsolation readLog$default$4() {
        return FetchLogEnd$.MODULE$;
    }

    public boolean readLog$default$5() {
        return true;
    }

    public Iterable<AbortedTxn> allAbortedTransactions(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable)x$1 -> x$1.txnIndex().allAbortedTxns());
    }

    public void deleteProducerSnapshotFiles(File logDir) {
        Object[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$1(f)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(files), (Function1 & Serializable)x$1 -> {
            LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Object> listProducerSnapshotOffsets(File logDir) {
        return (Seq)((SeqOps)ProducerStateManager$.MODULE$.listSnapshotFiles(logDir).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset()))).sorted((Ordering)Ordering.Long$.MODULE$);
    }

    public void assertLeaderEpochCacheEmpty(AbstractLog log) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.leaderEpochCache());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        Assertions.assertFalse((boolean)LeaderEpochCheckpointFile$.MODULE$.newFile(log.dir()).exists());
    }

    /*
     * WARNING - void declaration
     */
    public void appendNonTransactionalAsLeader(AbstractLog log, int numRecords) {
        MemoryRecords memoryRecords;
        MemoryRecords memoryRecords2;
        void withRecords_records;
        void withRecords_timestampType;
        MemoryRecords memoryRecords3;
        IndexedSeq simpleRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)seq -> LogTestUtils$.$anonfun$appendNonTransactionalAsLeader$1(BoxesRunTime.unboxToInt((Object)seq)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        timestampType = null;
        memoryRecords3 = null;
        MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
        memoryRecords2 = null;
        MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
        Object var5_5 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords6;
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    public Function1<Object, BoxedUnit> appendTransactionalAsLeader(AbstractLog log, long producerId, short producerEpoch, Time time) {
        return arg_0 -> LogTestUtils$.$anonfun$appendTransactionalAsLeader$1(IntRef.create((int)0), time, producerId, producerEpoch, log, arg_0);
    }

    private static final boolean hasOverflow$1(long baseOffset, RecordBatch batch) {
        return batch.lastOffset() > baseOffset + Integer.MAX_VALUE || batch.baseOffset() < baseOffset;
    }

    public static final /* synthetic */ void $anonfun$firstOverflowSegment$1(Object nonLocalReturnKey1$1, LogSegment segment) {
        if (CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().find((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.hasOverflow$1(segment.baseOffset(), (RecordBatch)batch))).isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)segment));
        }
    }

    private static final SimpleRecord record$1(long offset) {
        byte[] data = Long.toString(offset).getBytes();
        return new SimpleRecord(data, data);
    }

    /*
     * WARNING - void declaration
     */
    private static final long writeSampleBatches$1(long baseOffset, FileRecords segment, File logDir$1) {
        String string;
        String string2;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset)};
        boolean bl = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var4_5 = null;
        simpleRecordArray = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)baseOffset, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + 1L), LogTestUtils$.record$1(baseOffset + 2L)};
        boolean bl2 = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = baseOffset + 1L;
        compressionType = null;
        simpleRecordArray2 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + Integer.MAX_VALUE - 1L)};
        boolean bl3 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = baseOffset + Integer.MAX_VALUE - 1L;
        compressionType2 = null;
        simpleRecordArray3 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        String string3 = string2 = "";
        string2 = null;
        String offsetIndexFile_suffix = string3;
        Object var17_15 = null;
        LocalLog$.MODULE$.offsetIndexFile(logDir$1, baseOffset, offsetIndexFile_suffix).createNewFile();
        String string4 = string = "";
        string = null;
        String timeIndexFile_suffix = string4;
        Object var18_17 = null;
        LocalLog$.MODULE$.timeIndexFile(logDir$1, baseOffset, timeIndexFile_suffix).createNewFile();
        return baseOffset + Integer.MAX_VALUE;
    }

    private final long writeNormalSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1);
        }
        return l;
    }

    private final long writeOverflowSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1), segment, logDir$1);
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ void $anonfun$recoverAndCheck$1(File file) {
        Assertions.assertFalse((boolean)file.getName().endsWith(MergedLog$.MODULE$.DeletedFileSuffix()), (String)"Unexpected .deleted file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(MergedLog$.MODULE$.CleanedFileSuffix()), (String)"Unexpected .cleaned file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix()), (String)"Unexpected .swap file after recovery");
    }

    public static final /* synthetic */ boolean $anonfun$deleteProducerSnapshotFiles$1(File f) {
        return f.isFile() && f.getName().endsWith(MergedLog$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$deleteProducerSnapshotFiles$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendNonTransactionalAsLeader$1(int seq) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendTransactionalAsLeader$2(Time time$1, int seq) {
        return new SimpleRecord(time$1.milliseconds(), String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$appendTransactionalAsLeader$1(IntRef sequence$1, Time time$1, long producerId$1, short producerEpoch$1, AbstractLog log$1, int numRecords) {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        MemoryRecords memoryRecords;
        IndexedSeq simpleRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(sequence$1.elem), sequence$1.elem + numRecords).map((Function1 & Serializable)seq -> LogTestUtils$.$anonfun$appendTransactionalAsLeader$2(time$1, BoxesRunTime.unboxToInt((Object)seq)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int n = sequence$1.elem;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId$1, (short)producerEpoch$1, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Object var9_9 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        log$1.appendAsLeader(records, 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        sequence$1.elem += numRecords;
    }

    private LogTestUtils$() {
    }
}

