/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.durability.audit.SegmentDeletionStats;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.HotsetRetention$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.RetentionType;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MergedLogTest$ {
    public static final MergedLogTest$ MODULE$ = new MergedLogTest$();

    public List<Record> allRecords(AbstractLog log) {
        ListBuffer recordsFound = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        log.localLogSegments().foreach((Function1 & Serializable)logSegment -> {
            MergedLogTest$.$anonfun$allRecords$1(recordsFound, logSegment);
            return BoxedUnit.UNIT;
        });
        return recordsFound.toList();
    }

    public void verifyRecordsInLog(AbstractLog log, List<Record> expectedRecords) {
        Assertions.assertEquals(expectedRecords, this.allRecords(log));
    }

    public MemoryRecords createRecords(int segmentIdx, int messageIdx, long timestamp) {
        CompressionType compressionType;
        String segmentStr = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%06d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)segmentIdx)}));
        String messageStr = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%06d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageIdx)}));
        byte[] x$1 = new StringBuilder(4).append("test").append(segmentStr).append(messageStr).toString().getBytes();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, by);
    }

    public int createRecords$default$1() {
        return 0;
    }

    public int createRecords$default$2() {
        return 0;
    }

    public long createRecords$default$3() {
        return -1L;
    }

    public void initializeTierMetadata(MergedLog log, TopicIdPartition topicIdPartition) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        log.setTopicId(topicIdPartition.kafkaTopicId());
        tierPartitionState.onCatchUpComplete();
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
    }

    public void createTieredSegments(MergedLog log, LogSegment segment, TopicIdPartition topicIdPartition, int epoch) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, epoch, UUID.randomUUID(), segment.baseOffset(), segment.offsetOfMaxTimestampSoFar(), segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, false, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        tierPartitionState.flush();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    public int createTieredSegments$default$4() {
        return 0;
    }

    public MergedLog createLogWithOverlap(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk) {
        String string;
        String string2;
        int x$3 = Predef$.MODULE$.Integer2int(logConfig.segmentSize());
        long x$4 = Predef$.MODULE$.Long2long(logConfig.segmentMs());
        long l = Defaults$.MODULE$.RetentionMs();
        long l2 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$8 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        String string4 = string = Defaults$.MODULE$.MessageFormatVersion();
        string = null;
        String x$12 = string4;
        long l3 = Defaults$.MODULE$.FileDeleteDelayMs();
        long l4 = Defaults$.MODULE$.TierLocalHotsetMs();
        int n4 = Defaults$.MODULE$.TierSegmentHotsetRollMinBytes();
        long l5 = Defaults$.MODULE$.PreferTierFetchMs();
        boolean bl = true;
        LogConfig tempConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$3, l, 1L, l2, x$8, n, n2, n3, x$12, l3, true, 1L, l4, n4, l5, bl);
        ObjectRef log = ObjectRef.create((Object)LogTestUtils$.MODULE$.createLog(dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, tierLogComponents, new LogDirFailureChannel(10), (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, true, (Option<Uuid>)None$.MODULE$, true));
        ObjectRef tierPartitionState = ObjectRef.create((Object)((MergedLog)log.elem).tierPartitionState());
        ((TierPartitionState)tierPartitionState.elem).setTopicId(topicIdPartition.topicId());
        ((MergedLog)log.elem).isTieredMetadataRecovering_$eq(false);
        ((TierPartitionState)tierPartitionState.elem).onCatchUpComplete();
        int epoch = 0;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)segment -> {
            int currentNumSegments = ((MergedLog)log$87.elem).localLogSegments().size();
            long timestamp = segmentMaxTimestampCbk.apply$mcJ$sp();
            int message = 0;
            while (((MergedLog)log$87.elem).localLogSegments().size() == currentNumSegments) {
                MergedLog qual$1 = (MergedLog)log$87.elem;
                MemoryRecords x$18 = MODULE$.createRecords(segment, message, timestamp);
                AppendOrigin x$20 = qual$1.appendAsLeader$default$3();
                ApiVersion x$21 = qual$1.appendAsLeader$default$4();
                RequestLocal x$22 = qual$1.appendAsLeader$default$5();
                qual$1.appendAsLeader(x$18, 0, x$20, x$21, x$22);
                ++message;
            }
        });
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numTieredSegments + numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        ((TierPartitionState)tierPartitionState.elem).append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Iterable segmentsToTier = (Iterable)((MergedLog)log.elem).localLogSegments().take(numTieredSegments + numOverlap);
        segmentsToTier.foreach((Function1 & Serializable)segment -> {
            MergedLogTest$.$anonfun$createLogWithOverlap$2(tierPartitionState, topicIdPartition, epoch, segment);
            return BoxedUnit.UNIT;
        });
        Iterable localSegmentsToDelete = (Iterable)segmentsToTier.take(numTieredSegments);
        if (localSegmentsToDelete.nonEmpty()) {
            MergedLog qual$2 = (MergedLog)log.elem;
            Some x$23 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
            Function0 & Serializable x$24 = (Function0 & Serializable)() -> None$.MODULE$;
            HotsetRetention$ x$26 = HotsetRetention$.MODULE$;
            Function1 x$27 = qual$2.deleteOldSegments$default$5();
            SegmentDeletionStats x$28 = qual$2.deleteOldSegments$default$6();
            qual$2.deleteOldSegments((Option)x$23, (Function0)x$24, Integer.MAX_VALUE, (RetentionType)x$26, x$27, x$28);
        }
        ((MergedLog)log.elem).close();
        log.elem = LogTestUtils$.MODULE$.createLog(dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, tierLogComponents, new LogDirFailureChannel(10), (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, true, (Option<Uuid>)None$.MODULE$, true);
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        tierPartitionState.elem = ((MergedLog)log.elem).tierPartitionState();
        ((MergedLog)log.elem).isTieredMetadataRecovering_$eq(false);
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        Assertions.assertEquals((int)(numTieredSegments + numOverlap), (int)CollectionConverters$.MODULE$.IteratorHasAsScala(((TierPartitionState)tierPartitionState.elem).segments()).asScala().size());
        Tuple2 tuple2 = ((MergedLog)log.elem).uniqueLogSegments();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Iterator tierLogSegments = (Iterator)tuple2._1();
        Iterable localLogSegments = (Iterable)tuple2._2();
        Assertions.assertEquals((int)numTieredSegments, (int)tierLogSegments.size());
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)localLogSegments.size());
        return (MergedLog)log.elem;
    }

    public long createLogWithOverlap$default$11() {
        return 0L;
    }

    public long createLogWithOverlap$default$12() {
        return 0L;
    }

    public int createLogWithOverlap$default$13() {
        return 300000;
    }

    public int createLogWithOverlap$default$14() {
        return 3600000;
    }

    public int createLogWithOverlap$default$15() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public Function0<Object> createLogWithOverlap$default$16() {
        return (JFunction0.mcJ.sp & Serializable)() -> -1L;
    }

    public Tuple2<MergedLog, Iterable<LogSegment>> createLogWithMissingTierState(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk) {
        String string;
        String string2;
        int x$3 = Predef$.MODULE$.Integer2int(logConfig.segmentSize());
        long x$4 = Predef$.MODULE$.Long2long(logConfig.segmentMs());
        long l = Defaults$.MODULE$.RetentionMs();
        long l2 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$8 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        String string4 = string = Defaults$.MODULE$.MessageFormatVersion();
        string = null;
        String x$12 = string4;
        long l3 = Defaults$.MODULE$.FileDeleteDelayMs();
        long l4 = Defaults$.MODULE$.TierLocalHotsetMs();
        int n4 = Defaults$.MODULE$.TierSegmentHotsetRollMinBytes();
        long l5 = Defaults$.MODULE$.PreferTierFetchMs();
        boolean bl = true;
        LogConfig tempConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$3, l, 1L, l2, x$8, n, n2, n3, x$12, l3, true, 1L, l4, n4, l5, bl);
        ObjectRef log = ObjectRef.create((Object)LogTestUtils$.MODULE$.createLog(dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, tierLogComponents, new LogDirFailureChannel(10), (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, true, (Option<Uuid>)None$.MODULE$, true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)segment -> {
            int currentNumSegments = ((MergedLog)log$88.elem).localLogSegments().size();
            long timestamp = segmentMaxTimestampCbk.apply$mcJ$sp();
            int message = 0;
            while (((MergedLog)log$88.elem).localLogSegments().size() == currentNumSegments) {
                MergedLog qual$1 = (MergedLog)log$88.elem;
                MemoryRecords x$18 = MODULE$.createRecords(segment, message, timestamp);
                AppendOrigin x$20 = qual$1.appendAsLeader$default$3();
                ApiVersion x$21 = qual$1.appendAsLeader$default$4();
                RequestLocal x$22 = qual$1.appendAsLeader$default$5();
                qual$1.appendAsLeader(x$18, 0, x$20, x$21, x$22);
                ++message;
            }
        });
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numTieredSegments + numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        Iterable localSegmentsToDelete = (Iterable)((Iterable)((MergedLog)log.elem).localLogSegments().take(numTieredSegments + numOverlap)).take(numTieredSegments);
        Iterable retTierSegments = (Iterable)((MergedLog)log.elem).localLogSegments().take(numTieredSegments + numOverlap);
        MergedLog qual$2 = (MergedLog)log.elem;
        Some x$23 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
        Function0 & Serializable x$24 = (Function0 & Serializable)() -> None$.MODULE$;
        HotsetRetention$ x$26 = HotsetRetention$.MODULE$;
        Function1 x$27 = qual$2.deleteOldSegments$default$5();
        SegmentDeletionStats x$28 = qual$2.deleteOldSegments$default$6();
        qual$2.deleteOldSegments((Option)x$23, (Function0)x$24, Integer.MAX_VALUE, (RetentionType)x$26, x$27, x$28);
        ((MergedLog)log.elem).close();
        log.elem = LogTestUtils$.MODULE$.createLog(dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, tierLogComponents, new LogDirFailureChannel(10), (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, true, (Option<Uuid>)None$.MODULE$, true);
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        return new Tuple2((Object)((MergedLog)log.elem), (Object)retTierSegments);
    }

    public long createLogWithMissingTierState$default$11() {
        return 0L;
    }

    public long createLogWithMissingTierState$default$12() {
        return 0L;
    }

    public int createLogWithMissingTierState$default$13() {
        return 300000;
    }

    public int createLogWithMissingTierState$default$14() {
        return 3600000;
    }

    public int createLogWithMissingTierState$default$15() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public Function0<Object> createLogWithMissingTierState$default$16() {
        return (JFunction0.mcJ.sp & Serializable)() -> -1L;
    }

    public void kafka$log$MergedLogTest$$deleteOldLogSegments(MergedLog log, int expectedNumDeleted) {
        int maxNumSegmentsToDeletePerRun = 1;
        IntRef numDeleted = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), expectedNumDeleted).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            numDeleted$1.elem += log.deleteOldSegments(maxNumSegmentsToDeletePerRun);
            Assertions.assertEquals((int)i, (int)numDeleted$1.elem);
        });
        Assertions.assertEquals((int)expectedNumDeleted, (int)numDeleted.elem);
        Assertions.assertEquals((int)0, (int)log.deleteOldSegments());
    }

    public static final /* synthetic */ void $anonfun$allRecords$1(ListBuffer recordsFound$1, LogSegment logSegment) {
        CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().foreach((Function1 & Serializable)batch -> (ListBuffer)recordsFound$1.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IteratorHasAsScala(batch.iterator()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$createLogWithOverlap$2(ObjectRef tierPartitionState$18, TopicIdPartition topicIdPartition$1, int epoch$14, LogSegment segment) {
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata((TierPartitionState)tierPartitionState$18.elem, topicIdPartition$1, epoch$14, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, false, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        ((TierPartitionState)tierPartitionState$18.elem).flush();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    private MergedLogTest$() {
    }
}

