/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.ExtendedOffsetMap;
import kafka.log.OffsetMap;
import kafka.log.OffsetMapTest$;
import kafka.log.SkimpyOffsetMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005y4Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)!\u0007\u0001C\u0001C!)A\u0007\u0001C\u0001C!)a\u0007\u0001C\u0001C!)\u0001\b\u0001C\u0001s!)a\t\u0001C\u0001\u000f\"9Q\u000bAI\u0001\n\u00031\u0006\"B1\u0001\t\u0003\u0011\u0007bB4\u0001#\u0003%\tAV\u0004\u0006QBA\t!\u001b\u0004\u0006\u001fAA\tA\u001b\u0005\u000691!\ta\u001b\u0005\u0006Y2!\t!\u001c\u0002\u000e\u001f\u001a47/\u001a;NCB$Vm\u001d;\u000b\u0005E\u0011\u0012a\u00017pO*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002!\u0005\u0019B/Z:u\u0005\u0006\u001c\u0018n\u0019,bY&$\u0017\r^5p]R\t!\u0005\u0005\u0002\u0018G%\u0011A\u0005\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0003MA\u0011q\u0005M\u0007\u0002Q)\u0011\u0011FK\u0001\u0004CBL'BA\u0016-\u0003\u001dQW\u000f]5uKJT!!\f\u0018\u0002\u000b),h.\u001b;\u000b\u0003=\n1a\u001c:h\u0013\t\t\u0004F\u0001\u0003UKN$\u0018!\u0003;fgR\u001cE.Z1sQ\t\u0019a%A\buKN$x)\u001a;XQ\u0016tg)\u001e7mQ\t!a%A\u000buKN$X\t\u001f;f]\u0012,Gm\u00144gg\u0016$X*\u00199)\u0005\u00151\u0013aA6fsR\u0011!H\u0011\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\n1A\\5p\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u00039\r\u0001\u00071\t\u0005\u0002\u0018\t&\u0011Q\t\u0007\u0002\u0005\u0019>tw-A\u0006wC2LG-\u0019;f\u001b\u0006\u0004Hc\u0001%L!B\u0011q$S\u0005\u0003\u0015B\u0011qbU6j[BLxJ\u001a4tKRl\u0015\r\u001d\u0005\u0006\u0019\u001e\u0001\r!T\u0001\u0006SR,Wn\u001d\t\u0003/9K!a\u0014\r\u0003\u0007%sG\u000fC\u0004R\u000fA\u0005\t\u0019\u0001*\u0002\u00151|\u0017\r\u001a$bGR|'\u000f\u0005\u0002\u0018'&\u0011A\u000b\u0007\u0002\u0007\t>,(\r\\3\u0002+Y\fG.\u001b3bi\u0016l\u0015\r\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\tqK\u000b\u0002S1.\n\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003=b\t!\"\u00198o_R\fG/[8o\u0013\t\u00017LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1C^1mS\u0012\fG/Z#yi\u0016tG-\u001a3NCB$BAI2eM\")A*\u0003a\u0001\u001b\")Q-\u0003a\u0001\u001b\u00061Q.\u0019=LKfDq!U\u0005\u0011\u0002\u0003\u0007!+A\u000fwC2LG-\u0019;f\u000bb$XM\u001c3fI6\u000b\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00134\u00035yeMZ:fi6\u000b\u0007\u000fV3tiB\u0011q\u0004D\n\u0003\u0019Y!\u0012![\u0001\u0005[\u0006Lg\u000e\u0006\u0002#]\")qN\u0004a\u0001a\u0006!\u0011M]4t!\r9\u0012o]\u0005\u0003eb\u0011Q!\u0011:sCf\u0004\"\u0001^>\u000f\u0005UL\bC\u0001<\u0019\u001b\u00059(B\u0001=\u0015\u0003\u0019a$o\\8u}%\u0011!\u0010G\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{1\u0001")
public class OffsetMapTest {
    public static void main(String[] args) {
        OffsetMapTest$.MODULE$.main(args);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000, "MD5");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i))));
        map.clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L));
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096, "MD5");
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assertions.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    @Test
    public void testExtendedOffsetMap() {
        this.validateExtendedMap(100, 100, this.validateExtendedMap$default$3());
        this.validateExtendedMap(10000, 200, this.validateExtendedMap$default$3());
        this.validateExtendedMap(10000, 5000, this.validateExtendedMap$default$3());
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(Long.toString(key).getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), "MD5");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)i));
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }

    public void validateExtendedMap(int items, int maxKey, double loadFactor) {
        Random rnd = new Random();
        HashMap truthMap = new HashMap();
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), "MD5");
        ExtendedOffsetMap extendedMap = new ExtendedOffsetMap((OffsetMap)map);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int intKey = rnd.nextInt(maxKey);
            boolean isTombstone = rnd.nextBoolean();
            truthMap.put((Object)BoxesRunTime.boxToInteger((int)intKey), (Object)new Tuple2.mcIZ.sp(i, isTombstone));
            extendedMap.put(this.key(intKey), (long)i, isTombstone);
        });
        Assertions.assertEquals((int)truthMap.size(), (int)extendedMap.size());
        Assertions.assertEquals((int)truthMap.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetMapTest.$anonfun$validateExtendedMap$2(x$1))), (int)extendedMap.tombstoneCount());
        truthMap.foreach((Function1 & Serializable)entry -> {
            OffsetMapTest.$anonfun$validateExtendedMap$3(this, extendedMap, entry);
            return BoxedUnit.UNIT;
        });
    }

    public double validateExtendedMap$default$3() {
        return 0.5;
    }

    public static final /* synthetic */ boolean $anonfun$validateExtendedMap$2(Tuple2 x$1) {
        return ((Tuple2)x$1._2())._2$mcZ$sp();
    }

    public static final /* synthetic */ void $anonfun$validateExtendedMap$3(OffsetMapTest $this, ExtendedOffsetMap extendedMap$1, Tuple2 entry) {
        Assertions.assertEquals((long)((Tuple2)entry._2())._1$mcI$sp(), (long)extendedMap$1.get($this.key(entry._1$mcI$sp())));
    }
}

