/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.MergedLogState;
import kafka.log.MergedLogStateSnapshot;
import kafka.log.RecordState;
import kafka.log.SegmentFields;
import kafka.tier.state.TierPartitionStatus;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

public final class SpecValidator$
implements Logging {
    public static final SpecValidator$ MODULE$ = new SpecValidator$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$((Logging)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String logIdent() {
        return logIdent;
    }

    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<String> validate(MergedLogState state, MergedLogStateSnapshot snapshot, String check) {
        Some failure;
        Object object;
        Predef$.MODULE$.assert(state.currentTimeMs() == snapshot.time(), (Function0 & Serializable)() -> new StringBuilder(27).append("times should match ").append(state.currentTimeMs()).append(" vs ").append(snapshot.time()).append(". ").append(state).append(", ").append(MODULE$).toString());
        long maxLegalStartOffsetRetentionBytes = BoxesRunTime.unboxToLong((Object)((IterableOps)((IterableOnceOps)state.appendedBatches().reverse()).foldLeft(package$.MODULE$.List().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(batches, batch) -> {
            if (BoxesRunTime.unboxToLong((Object)state.latestDeleteRecordsOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) <= batch.endOffset() && (!state.config().delete() || (long)BoxesRunTime.unboxToInt((Object)batches.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) < Predef$.MODULE$.Long2long(state.config().retentionSize()) || BoxesRunTime.equalsNumObject((Number)state.config().retentionSize(), (Object)BoxesRunTime.boxToInteger((int)-1)))) {
                return (List)batches.$colon$plus(batch);
            }
            return batches;
        })).lastOption().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.startOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long deleteRecordsBound = BoxesRunTime.unboxToLong((Object)state.latestDeleteRecordsOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long deleteRecordsAndRetentionBytesBound = Math.max(deleteRecordsBound, maxLegalStartOffsetRetentionBytes);
        scala.collection.immutable.Set worstCaseOffsets = state.everCompacted() ? state.cleanedRecords(deleteRecordsAndRetentionBytesBound).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.offset())).toSet() : state.records().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset())).toSet();
        long maxLegalStartOffsetRetentionMs = BoxesRunTime.unboxToLong((Object)state.records().takeWhile((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$10(deleteRecordsAndRetentionBytesBound, worstCaseOffsets, state, record))).lastOption().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)SpecValidator$.$anonfun$validate$11(x$13))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long maxLegalStartOffset = Math.min(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(maxLegalStartOffsetRetentionMs), maxLegalStartOffsetRetentionBytes)), deleteRecordsBound), snapshot.highWatermark());
        if (snapshot.logStartOffset() > maxLegalStartOffset) {
            object = new Some((Object)new StringBuilder(0).append(new StringBuilder(103).append("records should have bounded retention to a lower point, maxLegalStartOffset ").append(maxLegalStartOffset).append(" vs actual logStartOffset ").append(snapshot.logStartOffset()).append(".").toString()).append(new StringBuilder(94).append(" Start offset was composed of retention.ms bound: ").append(maxLegalStartOffsetRetentionMs).append(" for ").append(state.config().retentionMs()).append("ms, retention.bytes bound: ").append(maxLegalStartOffsetRetentionBytes).append(" for ").append(state.config().retentionSize()).append(" bytes,").toString()).append(new StringBuilder(36).append(" delete records bound ").append(state.latestDeleteRecordsOffset()).append(", this state ").append(this.toString()).append(".").toString()).toString());
        } else if (snapshot.localLogStartOffset() != Math.max(((SegmentFields)snapshot.localLogSegments().head()).baseOffset(), snapshot.logStartOffset())) {
            object = new Some((Object)new StringBuilder(128).append("localLogStartOffset (").append(snapshot).append(".localLogStartOffset) should match local log segments base offset (").append(((SegmentFields)snapshot.localLogSegments().head()).baseOffset()).append(") and log start offset (").append(snapshot).append(".logStartOffset)").toString());
        } else if (snapshot.highWatermark() != state.highWatermark()) {
            object = new Some((Object)new StringBuilder(71).append("log highwatermark ").append(snapshot).append(".highWatermark should match model highwatermark ").append(state.highWatermark()).append(" ").append(state).append(" vs ").append(this).toString());
        } else if (snapshot.logEndOffset() > state.logEndOffset()) {
            object = new Some((Object)new StringBuilder(60).append("incorrect logEndOffset ").append(snapshot).append(".logEndOffset vs model highwatermark ").append(state.logEndOffset()).toString());
        } else {
            TierPartitionStatus tierPartitionStatus = snapshot.tierStateStatus();
            TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ERROR;
            if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
                object = new Some((Object)new StringBuilder(32).append("TierPartitionState is in ").append(snapshot.tierStateStatus()).append(" status").toString());
            } else if (state.everCompacted()) {
                scala.collection.immutable.Set actual;
                Map reverseOffsetMap = (Map)CollectionConverters$.MODULE$.MapHasAsScala(snapshot.offsetMap()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Option k = (Option)x0$1._1();
                    long offset = x0$1._2$mcJ$sp();
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)offset), (Object)k);
                    return tuple2;
                });
                ListBuffer cleanedReadRecords = (ListBuffer)snapshot.records().filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$14(reverseOffsetMap, maxLegalStartOffset, r)));
                scala.collection.immutable.Set modeled = state.cleanedRecords(maxLegalStartOffset).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$15(x$14))).toSet();
                object = !modeled.equals((Object)(actual = ((IterableOnceOps)cleanedReadRecords.filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$16(x$15)))).toSet())) ? new Some((Object)new StringBuilder(97).append("compaction resulted in different offsets remaining than expected, records diff: ").append(modeled.diff((Set)actual)).append("\nmodel: ").append(modeled).append("\nactual: ").append(actual).toString()) : None$.MODULE$;
            } else {
                object = failure = None$.MODULE$;
            }
        }
        if (failure.isDefined()) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = SpecValidator$.$anonfun$validate$17(check, (Option)failure, state, snapshot);
                Object var21_16 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = SpecValidator$.$anonfun$validate$18(check, state);
            Object var22_17 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        return failure;
    }

    public static final /* synthetic */ boolean $anonfun$validate$10(long deleteRecordsAndRetentionBytesBound$1, scala.collection.immutable.Set worstCaseOffsets$1, MergedLogState state$1, RecordState record) {
        return record.offset() < deleteRecordsAndRetentionBytesBound$1 || !worstCaseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)record.offset())) || record.isTombstone() && state$1.everCompacted() || state$1.config().delete() && !BoxesRunTime.equalsNumObject((Number)state$1.config().retentionMs(), (Object)BoxesRunTime.boxToInteger((int)-1)) && record.timestamp() < state$1.currentTimeMs() - Predef$.MODULE$.Long2long(state$1.config().retentionMs());
    }

    public static final /* synthetic */ long $anonfun$validate$11(RecordState x$13) {
        return x$13.offset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$validate$14(Map reverseOffsetMap$2, long maxLegalStartOffset$1, RecordState r) {
        return reverseOffsetMap$2.contains((Object)BoxesRunTime.boxToLong((long)r.offset())) && r.offset() >= maxLegalStartOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$validate$15(RecordState x$14) {
        return !x$14.isTombstone();
    }

    public static final /* synthetic */ boolean $anonfun$validate$16(RecordState x$15) {
        return !x$15.isTombstone();
    }

    public static final /* synthetic */ String $anonfun$validate$17(String check$1, Option failure$1, MergedLogState state$1, MergedLogStateSnapshot snapshot$1) {
        return new StringBuilder(40).append(check$1).append(" falsified:\nreason: ").append(failure$1.get()).append("\nstate: ").append(state$1).append("\nSUT state:\n").append(snapshot$1).toString();
    }

    public static final /* synthetic */ String $anonfun$validate$18(String check$1, MergedLogState state$1) {
        return new StringBuilder(27).append(check$1).append(" passed\nstate: ").append(state$1).append("\nSUT state:\n").append(MODULE$).toString();
    }

    private SpecValidator$() {
    }
}

