/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005A4A!\u0006\f\u00017!)!\u0005\u0001C\u0001G!Ia\u0005\u0001a\u0001\u0002\u0004%\ta\n\u0005\na\u0001\u0001\r\u00111A\u0005\u0002EB\u0011b\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0015\t\u0013a\u0002\u0001\u0019!a\u0001\n\u0003I\u0004\"C\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0001?\u0011%\u0001\u0005\u00011A\u0001B\u0003&!\bC\u0004B\u0001\t\u0007I\u0011\u0001\"\t\r\u0019\u0003\u0001\u0015!\u0003D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u00151\u0006\u0001\"\u0001I\u0011\u0015Y\u0006\u0001\"\u0001I\u0011\u0015\u0001\u0007\u0001\"\u0001I\u0011\u0015\u0011\u0007\u0001\"\u0001I\u0011\u0015!\u0007\u0001\"\u0001I\u0011\u00151\u0007\u0001\"\u0001I\u0011\u0015A\u0007\u0001\"\u0001I\u0011\u0015Q\u0007\u0001\"\u0001I\u0011\u0015a\u0007\u0001\"\u0001I\u0011\u0015q\u0007\u0001\"\u0001I\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010V3ti*\u0011q\u0003G\u0001\u0004Y><'\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u00051\u0012\u0001\u00024jY\u0016,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n!![8\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0005\r&dW-\u0001\u0005gS2,w\fJ3r)\t\u0011T\u0007\u0005\u0002\u001eg%\u0011AG\b\u0002\u0005+:LG\u000fC\u00047\u0007\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013'A\u0003gS2,\u0007%A\u0003j]\u0012,\u00070F\u0001;!\t)3(\u0003\u0002=-\t\u0001BK]1og\u0006\u001cG/[8o\u0013:$W\r_\u0001\nS:$W\r_0%KF$\"AM \t\u000fY2\u0011\u0011!a\u0001u\u00051\u0011N\u001c3fq\u0002\naa\u001c4gg\u0016$X#A\"\u0011\u0005u!\u0015BA#\u001f\u0005\u0011auN\\4\u0002\u000f=4gm]3uA\u0005)1/\u001a;vaR\t!\u0007\u000b\u0002\u000b\u0015B\u00111\nV\u0007\u0002\u0019*\u0011QJT\u0001\u0004CBL'BA(Q\u0003\u001dQW\u000f]5uKJT!!\u0015*\u0002\u000b),h.\u001b;\u000b\u0003M\u000b1a\u001c:h\u0013\t)FJ\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0017a\u0003\"aS-\n\u0005ic%!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;Q_NLG/[8o'\u0016$8i\u001c:sK\u000e$H._,iK:|\u0005/\u001a8fI\"\u0012A\"\u0018\t\u0003\u0017zK!a\u0018'\u0003\tQ+7\u000f^\u0001$i\u0016\u001cHOU3pa\u0016tg)Y5m/\",gNR5mK\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\tiQ,A\buKN$8+\u00198jif\u001c\u0005.Z2lQ\tqQ,\u0001\u000euKN$H*Y:u\u001f\u001a47/\u001a;NkN$\u0018J\\2sK\u0006\u001cX\r\u000b\u0002\u0010;\u0006aB/Z:u\u0019\u0006\u001cHo\u00144gg\u0016$8)\u00198o_R$Um\u0019:fCN,\u0007F\u0001\t^\u0003y!Xm\u001d;D_2dWm\u0019;BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u000b\u0002\u0012;\u0006aA/Z:u)J,hnY1uK\"\u0012!#X\u0001\u0014i\u0016\u001cH/\u00112peR,G\r\u0016=o'\u0016\u0014H-\u001a\u0015\u0003'u\u000bq\u0002^3tiJ+g.Y7f\u0013:$W\r\u001f\u0015\u0003)u\u0003")
public class TransactionIndexTest {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @BeforeEach
    public void setup() {
        this.file_$eq(TestUtils.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file(), false));
    }

    @AfterEach
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        List abortedTxns = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        abortedTxns.foreach(arg_0 -> TransactionIndexTest.$anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file(), true);
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assertions.assertEquals((Object)abortedTxns.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{anotherAbortedTxn}))), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test
    public void testReopenFailWhenFileAlreadyExists() {
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
        this.index().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new TransactionIndex(0L, this.file(), false));
        this.index_$eq(new TransactionIndex(this.offset(), this.file(), true));
    }

    @Test
    public void testSanityCheck() {
        ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testSanityCheck$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file(), true);
        Assertions.assertThrows(CorruptIndexException.class, () -> reopenedIndex.sanityCheck());
    }

    @Test
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 15L, 11L)));
    }

    @Test
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 10L, 11L)));
    }

    @Test
    public void testCollectAbortedTransactions() {
        List abortedTransactions = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testCollectAbortedTransactions$1$adapted(this.index(), arg_0));
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assertions.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assertions.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assertions.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assertions.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assertions.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        List abortedTransactions = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 2L), new AbortedTxn(1L, 5L, 15L, 16L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testTruncate$1$adapted(this.index(), arg_0));
        this.index().truncateTo(51L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assertions.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().reset();
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assertions.assertEquals((short)AbortedTxn$.MODULE$.CurrentVersion(), (short)abortedTxn.version());
        Assertions.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File file;
        File file2 = file = TestUtils.tempFile();
        file = null;
        File renamed = file2;
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assertions.assertEquals((int)2, (int)abortedTxns.size());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }

    public static final /* synthetic */ Object $anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(TransactionIndex eta$0$1$1, AbortedTxn abortedTxn) {
        eta$0$1$1.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSanityCheck$1$adapted(TransactionIndex eta$0$1$2, AbortedTxn abortedTxn) {
        eta$0$1$2.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactions$1$adapted(TransactionIndex eta$0$1$3, AbortedTxn abortedTxn) {
        eta$0$1$3.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncate$1$adapted(TransactionIndex eta$0$1$4, AbortedTxn abortedTxn) {
        eta$0$1$4.append(abortedTxn);
        return BoxedUnit.UNIT;
    }
}

