/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B\u0012%\u0001%BQA\u000e\u0001\u0005\u0002]B\u0011B\u000f\u0001A\u0002\u0003\u0005\u000b\u0015B\u001e\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"1q\n\u0001Q\u0001\n%Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019a\u0006\u0001)A\u0005)\")Q\f\u0001C\u0001=\")Q\r\u0001C!M\"91\u000f\u0001b\u0001\n\u0003A\u0005B\u0002;\u0001A\u0003%\u0011\nC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!a\"\u0001\t\u0003\tI\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0007\u0004A\u0011AAc\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011q \u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[AqA!\r\u0001\t\u0013\u0011\u0019DA\u0006NKR\u0014\u0018nY:UKN$(BA\u0013'\u0003\u001diW\r\u001e:jGNT\u0011aJ\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0019\n1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011q\u0006\f\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011\u0011\u0007N\u0007\u0002e)\u00111GJ\u0001\u0006kRLGn]\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002I\u0005Iq\f^3ti&sgm\u001c\t\u0003y\u0015k\u0011!\u0010\u0006\u0003}}\n1!\u00199j\u0015\t\u0001\u0015)A\u0004kkBLG/\u001a:\u000b\u0005\t\u001b\u0015!\u00026v]&$(\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G{\tAA+Z:u\u0013:4w.\u0001\u0005ok6tu\u000eZ3t+\u0005I\u0005C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%aA%oi\u0006Ia.^7O_\u0012,7\u000fI\u0001\t]Vl\u0007+\u0019:ug\u0006Ia.^7QCJ$8\u000fI\u0001\u001ae\u0016\fX/\u001b:fI.\u000bgm[1TKJ4XM\u001d)sK\u001aL\u00070F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<\u0017A\u0007:fcVL'/\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bK]3gSb\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!A\u0019-\u0002\tU$\u0018\u000e\\\u0005\u0003I\u0006\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A4\u0011\u0007!\\W.D\u0001j\u0015\tQ7*\u0001\u0006d_2dWm\u0019;j_:L!\u0001\\5\u0003\u0007M+\u0017\u000f\u0005\u0002oc6\tqN\u0003\u0002qM\u000511/\u001a:wKJL!A]8\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\n]6+7o]1hKN\f!B\\'fgN\fw-Z:!\u0003\u0015\u0019X\r^+q)\t9(\u0010\u0005\u0002Kq&\u0011\u0011p\u0013\u0002\u0005+:LG\u000fC\u0003|\u001b\u0001\u00071(\u0001\u0005uKN$\u0018J\u001c4pQ\tiQ\u0010\u0005\u0002=}&\u0011q0\u0010\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\n;fgRlU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\u0018I\u001a;fe\u0012+G.\u001a;j]\u001e$v\u000e]5d)\r9\u0018Q\u0001\u0005\b\u0003\u000fq\u0001\u0019AA\u0005\u0003\u0019\tXo\u001c:v[B!\u00111BA\r\u001d\u0011\ti!!\u0006\u0011\u0007\u0005=1*\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\t9bS\u0001\u0007!J,G-\u001a4\n\u0007m\u000bYBC\u0002\u0002\u0018-CsADA\u0010\u0003_\t\t\u0004\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0011A\u0014xN^5eKJT1!!\u000b@\u0003\u0019\u0001\u0018M]1ng&!\u0011QFA\u0012\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u00111GA\u001cC\t\t)$\u0001\u0002{W\u0006\u0012\u0011\u0011H\u0001\u0006WJ\fg\r\u001e\u0015\b\u001d\u0005u\u0012QIA$!\u0011\ty$!\u0011\u000e\u0005\u0005\u001d\u0012\u0002BA\"\u0003O\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005%\u0013\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006!D/Z:u\u0005J|7.\u001a:U_BL7-T3ue&\u001c7/\u00168sK\u001eL7\u000f^3sK\u0012\fe\r^3s\t\u0016dW\r^5oOR{\u0007/[2\u0015\u0007]\fy\u0005C\u0004\u0002\b=\u0001\r!!\u0003)\u000f=\ty\"a\f\u0002T1\"\u00111GA\u001cQ\u001dy\u0011QHA#\u0003\u000f\n1\u0003^3ti\u000ecWo\u001d;fe&#W*\u001a;sS\u000e$2a^A.\u0011\u001d\t9\u0001\u0005a\u0001\u0003\u0013As\u0001EA\u0010\u0003_\ty\u0006\f\u0003\u00024\u0005]\u0002f\u0002\t\u0002>\u0005\u0015\u0013qI\u0001\u0016i\u0016\u001cHO\u0011:pW\u0016\u00148\u000b^1uK6+GO]5d)\r9\u0018q\r\u0005\b\u0003\u000f\t\u0002\u0019AA\u0005Q\u001d\t\u0012qDA\u0018\u0003WbC!a\r\u00028!:\u0011#!\u0010\u0002F\u0005\u001d\u0013\u0001\b;fgRL\u0016-\\7fe6+GO]5dg\u000e{WO\u001c;NKR\u0014\u0018n\u0019\u000b\u0004o\u0006M\u0004bBA\u0004%\u0001\u0007\u0011\u0011\u0002\u0015\b%\u0005}\u0011qFA<Y\u0011\t\u0019$a\u000e)\u000fI\ti$!\u0012\u0002H\u0005\u0011B/Z:u\u0019&tW\u000f_%p\u001b\u0016$(/[2t)\r9\u0018q\u0010\u0005\b\u0003\u000f\u0019\u0002\u0019AA\u0005Q\u001d\u0019\u0012qDA\u0018\u0003\u0007cC!a\r\u00028!:1#!\u0010\u0002F\u0005\u001d\u0013!\u0004;fgRTU\n\u0017$jYR,'\u000fF\u0002x\u0003\u0017Cq!a\u0002\u0015\u0001\u0004\tI\u0001K\u0004\u0015\u0003?\ty#a$-\t\u0005M\u0012q\u0007\u0015\b)\u0005u\u0012QIA$\u0003M!Xm\u001d;Va\u0012\fG/\u001a&N1\u001aKG\u000e^3s)\r9\u0018q\u0013\u0005\b\u0003\u000f)\u0002\u0019AA\u0005Q\u001d)\u0012qDA\u0018\u00037cC!a\r\u00028!:Q#!\u0010\u0002F\u0005\u001d\u0013A\r;fgR<UM\\3sC2\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:Be\u0016<%/Z3eS2L(+Z4jgR,'/\u001a3\u0015\u0007]\f\u0019\u000bC\u0004\u0002\bY\u0001\r!!\u0003)\u000fY\ty\"a\f\u0002(2\"\u00111GA\u001cQ\u001d1\u0012QHA#\u0003\u000f\n\u0001\u0004^3ti^Kg\u000eZ8xgN#\u0018\u0010\\3UC\u001et\u0015-\\3t)\r9\u0018q\u0016\u0005\b\u0003\u000f9\u0002\u0019AA\u0005Q\u001d9\u0012qDA\u0018\u0003gcC!a\r\u00028!:q#!\u0010\u0002F\u0005\u001d\u0013\u0001\t;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:CsR,7/\u00138PkR$2a^A^\u0011\u001d\t9\u0001\u0007a\u0001\u0003\u0013As\u0001GA\u0010\u0003_\ty\f\f\u0003\u00024\u0005]\u0002f\u0002\r\u0002>\u0005\u0015\u0013qI\u0001'i\u0016\u001cHO\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u000e{W\u000e]1di\u0016$')\u001f;fg&sGcA<\u0002H\"9\u0011qA\rA\u0002\u0005%\u0001fB\r\u0002 \u0005=\u00121\u001a\u0017\u0005\u0003g\t9\u0004K\u0004\u001a\u0003{\t)%a\u0012\u0002mQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGNtunS3z\u0007>l\u0007/Y2uK\u0012$v\u000e]5d%\u0016\u001cwN\u001d3t\u0019><w-\u001a3\u0015\u0007]\f\u0019\u000eC\u0004\u0002\bi\u0001\r!!\u0003)\u000fi\ty\"a\f\u0002X2\"\u00111GA\u001cQ\u001dQ\u0012QHA#\u0003\u000f\nq\u0003^3tij[7i\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:\u0015\u0007]\fy\u000eC\u0004\u0002\bm\u0001\r!!\u0003)\u000fm\ty\"a\f\u0002d2\u0012\u00111\u0007\u0015\b7\u0005u\u0012QIA$\u0003\u0015\"Xm\u001d;BO\u001e\u0014XmZ1uKJ+7m\u001c:e\u001b\u0016$(/[2t\u0013:LG/[1mSj,G\rF\u0002x\u0003WDq!a\u0002\u001d\u0001\u0004\tI\u0001K\u0004\u001d\u0003?\ty#a<-\t\u0005M\u0012q\u0007\u0015\b9\u0005u\u0012QIA$\u0003\t\"Xm\u001d;Ce>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001c8+Z4nK:$(+Z1egR\u0019q/a>\t\u000f\u0005\u001dQ\u00041\u0001\u0002\n!:Q$a\b\u00020\u0005mHFAA\u001aQ\u001di\u0012QHA#\u0003\u000f\n\u0001\u0005^3tiN+7o]5p]\u0016C\b/\u001b:f\u0019&\u001cH/\u001a8fe6+GO]5dgR\u0019qOa\u0001\t\u000f\u0005\u001da\u00041\u0001\u0002\n!:a$a\b\u00020\t\u001dA\u0006BA\u001a\u0003oAsAHA\u001f\u0003\u000b\n9%\u0001\nuKN$Hj\\1e\u0019><7/T3ue&\u001cGcA<\u0003\u0010!9\u0011qA\u0010A\u0002\u0005%\u0001fB\u0010\u0002 \u0005=\"1\u0003\u0017\u0005\u0003g\t9\u0004K\u0004 \u0003{\t)%a\u0012\u0002\u0019Q|\u0007/[2NKR\u0014\u0018nY:\u0015\t\tm!\u0011\u0005\t\u0006Q\nu\u0011\u0011B\u0005\u0004\u0005?I'aA*fi\"9!1\u0005\u0011A\u0002\t\u0015\u0012!\u0002;pa&\u001c\u0007#\u0002&\u0003(\u0005%\u0011b\u0001B\u0015\u0017\n1q\n\u001d;j_:\f\u0011\u0003^8qS\u000elU\r\u001e:jG\u001e\u0013x.\u001e9t)\u0011\u0011YBa\f\t\u000f\t\r\u0012\u00051\u0001\u0002\n\u0005Ab-\u001b7uKJ\u0014\u0015\u0010V8qS\u000elU\r\u001e:jGJ+w-\u001a=\u0015\r\tm!Q\u0007B\u001c\u0011\u0019)#\u00051\u0001\u0003\u001c!9!1\u0005\u0012A\u0002\t\u0015\u0002f\u0002\u0001\u0003<\t\u0005#1\t\t\u0004y\tu\u0012b\u0001B {\t9A+[7f_V$\u0018!\u0002<bYV,g$\u0001=")
public class MetricsTest
extends KafkaServerTestHarness {
    private TestInfo _testInfo;
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    /*
     * WARNING - void declaration
     */
    public Properties overridingProps() {
        void var1_1;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        props.put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo)) {
            props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        }
        return var1_1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$2 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$2, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsReporterAfterDeletingTopic(String quorum) {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$3))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerStateMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$4))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testYammerMetricsCountMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$5))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLinuxIoMetrics(String quorum) {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testJMXFilter(String quorum) {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateJMXFilter(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWindowsStyleTagNames(String quorum) {
        void metricName_name;
        com.yammer.metrics.core.MetricName metricName;
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        String string = "test-metric";
        KafkaMetricsGroup$ metricName_this = KafkaMetricsGroup$.MODULE$;
        com.yammer.metrics.core.MetricName metricName2 = metricName = KafkaMetricsGroup.metricName$((KafkaMetricsGroup)metricName_this, (String)metricName_name, (Map)tags);
        Object var6_6 = null;
        string = null;
        metricName = null;
        com.yammer.metrics.core.MetricName metric = metricName2;
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsBytesInOut(String quorum) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsCompactedBytesIn(String quorum) {
        String topicCompacted = "test-bytes-in-compacted-topic";
        String topicNotCompacted = "test-bytes-in-not-compacted-topic";
        List topics = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicCompacted, topicNotCompacted}));
        String bytesInCompactedTopic = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topicCompacted).toString();
        String bytesInNotCompactedTopic = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topicNotCompacted).toString();
        String totalBytesIn = BrokerTopicStats$.MODULE$.BytesInPerSec();
        String totalCompactedBytesIn = BrokerTopicStats$.MODULE$.CompactedTopicsBytesInPerSec();
        Properties topicConfigCompacted = new Properties();
        topicConfigCompacted.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicConfigCompacted.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topicCompacted, 1, this.numNodes(), topicConfigCompacted, this.createTopic$default$5());
        Properties topicConfigNotCompacted = new Properties();
        topicConfigNotCompacted.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicConfigNotCompacted.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        this.createTopic(topicNotCompacted, 1, this.numNodes(), topicConfigNotCompacted, this.createTopic$default$5());
        topics.foreach((Function1 & Serializable)topic -> TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), (String)topic, this.nMessages(), -1));
        topics.foreach((Function1 & Serializable)topic -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsCompactedBytesIn$2(this, topic);
            return BoxedUnit.UNIT;
        });
        long initialCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInCompactedTopic);
        long initialNotCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInNotCompactedTopic);
        long initialTotalBytesIn = TestUtils$.MODULE$.meterCount(totalBytesIn);
        long initialTotalCompactedBytesIn = TestUtils$.MODULE$.meterCount(totalCompactedBytesIn);
        Assertions.assertEquals((long)initialCompactedTopicBytesIn, (long)initialNotCompactedTopicBytesIn);
        Assertions.assertEquals((long)(initialCompactedTopicBytesIn + initialNotCompactedTopicBytesIn), (long)initialTotalBytesIn);
        Assertions.assertEquals((long)initialCompactedTopicBytesIn, (long)initialTotalCompactedBytesIn);
        topics.foreach((Function1 & Serializable)topic -> TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), (String)topic, this.nMessages(), -1));
        long finalCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInCompactedTopic);
        long finalNotCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInNotCompactedTopic);
        long finalTotalBytesIn = TestUtils$.MODULE$.meterCount(totalBytesIn);
        long finalTotalCompactedBytesIn = TestUtils$.MODULE$.meterCount(totalCompactedBytesIn);
        Assertions.assertEquals((long)finalCompactedTopicBytesIn, (long)finalNotCompactedTopicBytesIn);
        Assertions.assertEquals((long)(finalCompactedTopicBytesIn + finalNotCompactedTopicBytesIn), (long)finalTotalBytesIn);
        Assertions.assertEquals((long)finalCompactedTopicBytesIn, (long)finalTotalCompactedBytesIn);
        Assertions.assertTrue((finalCompactedTopicBytesIn > initialCompactedTopicBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalNotCompactedTopicBytesIn > initialNotCompactedTopicBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalTotalBytesIn > initialTotalBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalTotalCompactedBytesIn > initialTotalCompactedBytesIn ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged(String quorum) {
        String topic = "test-compacted-topic-record-no-key";
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5());
        try {
            TestUtils$.MODULE$.produceMessages(this.brokers(), (Seq<ProducerRecord<byte[], byte[]>>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{new ProducerRecord(topic, (Object)"test".getBytes())}))), -1);
            Assertions.fail((String)"Exception should have been thrown since a compacted topic cannot accept a message without keys");
        }
        catch (Exception exception) {}
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged$1(x$11))));
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount("name=NoKeyCompactedTopicRecordsPerSec") > 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testZkControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$1(x$12))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$2(x$13))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$3(x$14))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$4(x$15))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$5(x$16))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$6(x$17))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$7(x$18))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$8(x$19))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$9(x$20))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$10(x$21))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$11(x$22))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAggregateRecordMetricsInitialized(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$1(x$23))));
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$2(x$24))));
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$3(x$25))));
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$4(x$26))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testBrokerTopicMetricsSegmentReads(String quorum) {
        String topic = "test-segment-reads";
        String segmentReads = BrokerTopicStats$.MODULE$.SegmentReadsPerSec();
        String segmentSpeculativePrefetches = BrokerTopicStats$.MODULE$.SegmentSpeculativePrefetchesPerSec();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp(), "true");
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentBytesProp(), "128");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5());
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentReads));
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        MetricsTest.testTopicMetricFails$1(segmentReads, topic);
        MetricsTest.testTopicMetricFails$1(segmentSpeculativePrefetches, topic);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, 1, -1);
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, 1, "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 32).foreach((Function1 & Serializable)x$27 -> TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, 1, -1));
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, 32, "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 1L ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) - 1L > TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSessionExpireListenerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        int expectedNumMetrics = this.isKRaftTest() ? 0 : 1;
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$28))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$29))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$30))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLoadLogsMetric(String quorum) {
        String topic = "test-load-logs-metric";
        this.createTopic(topic, 1, this.numNodes(), this.createTopic$default$4(), this.createTopic$default$5());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, 1, -1);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testLoadLogsMetric$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$31 -> x$31.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable)() -> "")).toString())).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$32)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, com.yammer.metrics.core.MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, com.yammer.metrics.core.MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, com.yammer.metrics.core.MetricName x$6) {
        String string = x$6.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$6))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$8 -> x$8 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsCompactedBytesIn$3(String topic$3, TopicPartition topicPartition$2, KafkaBroker server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = new TopicPartition(topic$3, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$10 -> x$10 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$2).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsCompactedBytesIn$2(MetricsTest $this, String topic) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        $this.brokers().foreach((Function1 & Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsCompactedBytesIn$3(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged$1(com.yammer.metrics.core.MetricName x$11) {
        return x$11.getMBeanName().endsWith("name=NoKeyCompactedTopicRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$1(com.yammer.metrics.core.MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$2(com.yammer.metrics.core.MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$3(com.yammer.metrics.core.MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$4(com.yammer.metrics.core.MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$5(com.yammer.metrics.core.MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$6(com.yammer.metrics.core.MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$7(com.yammer.metrics.core.MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$8(com.yammer.metrics.core.MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$9(com.yammer.metrics.core.MetricName x$20) {
        String string = x$20.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$10(com.yammer.metrics.core.MetricName x$21) {
        String string = x$21.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$11(com.yammer.metrics.core.MetricName x$22) {
        String string = x$22.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=FencedBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$1(com.yammer.metrics.core.MetricName x$23) {
        return x$23.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NoKeyCompactedTopicRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$2(com.yammer.metrics.core.MetricName x$24) {
        return x$24.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMagicNumberRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$3(com.yammer.metrics.core.MetricName x$25) {
        return x$25.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMessageCrcRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$4(com.yammer.metrics.core.MetricName x$26) {
        return x$26.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NonIncreasingOffsetRecordsPerSec");
    }

    private static final void testTopicMetricFails$1(String metric, String topic$4) {
        Assertions.assertThrows(Throwable.class, () -> TestUtils$.MODULE$.meterCount(new StringBuilder(7).append(metric).append(",topic=").append(topic$4).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(com.yammer.metrics.core.MetricName x$28) {
        String string = x$28.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(com.yammer.metrics.core.MetricName x$29) {
        String string = x$29.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(com.yammer.metrics.core.MetricName x$30) {
        String string = x$30.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLoadLogsMetric$1(KafkaBroker broker) {
        broker.shutdown();
        broker.startup();
        MetricName loadLogsTimeAvgMetric = broker.metrics().metricName("load-logs-time-avg", "log-manager-metrics");
        MetricName loadLogsTimeMaxMetric = broker.metrics().metricName("load-logs-time-max", "log-manager-metrics");
        Assertions.assertTrue((boolean)broker.metrics().metrics().containsKey(loadLogsTimeAvgMetric));
        Assertions.assertTrue((boolean)broker.metrics().metrics().containsKey(loadLogsTimeMaxMetric));
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)broker.metrics().metrics().get(loadLogsTimeAvgMetric)).metricValue()) > 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)broker.metrics().metrics().get(loadLogsTimeMaxMetric)).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$32) {
        return pattern$1.matcher(x$32).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.nMessages = 2;
    }
}

