/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kafka.network.ConnectionQuotas$;
import kafka.network.DataPlaneAcceptor;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u0004:\u0001\u0001\u0006I!\f\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u0019!\u0005\u0001)A\u0005y!9Q\t\u0001b\u0001\n\u00031\u0005BB'\u0001A\u0003%q\tC\u0004O\u0001\t\u0007I\u0011\u0001$\t\r=\u0003\u0001\u0015!\u0003H\u0011\u001d\u0001\u0006A1A\u0005\u0002ECa\u0001\u0017\u0001!\u0002\u0013\u0011\u0006bB-\u0001\u0005\u0004%\tA\u0017\u0005\u0007=\u0002\u0001\u000b\u0011B.\t\u000f}\u0003!\u0019!C\u0001A\"1q\r\u0001Q\u0001\n\u0005DQ\u0001\u001b\u0001\u0005B\u0019CQ!\u001b\u0001\u0005B)DQA\u001e\u0001\u0005B]Daa \u0001\u0005\u0002\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0012\u0001\t\u0013\t9\u0005C\u0005\u0002`\u0001\t\n\u0011\"\u0003\u0002b!9\u0011q\u000f\u0001\u0005\n\u0005\u0005!\u0001L\"p]\u001adW/\u001a8u\u0007>tg.Z2uS>t\u0017+^8uCN\u0014VmY8oM&<WO]1uS>tG+Z:u\u0015\taR$A\u0004oKR<xN]6\u000b\u0003y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\u0011A%H\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0019\u001a#a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005Y\u0012\u0001\u00037jgR,g.\u001a:\u0016\u00035\u0002\"AL\u001c\u000e\u0003=R!\u0001\b\u0019\u000b\u0005E\u0012\u0014AB2p[6|gN\u0003\u0002\u001fg)\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0013\tAtF\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\u0005mSN$XM\\3sA\u0005aAn\\2bY\u0006#GM]3tgV\tA\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006\u0019a.\u001a;\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/A\u0007m_\u000e\fG.\u00113ee\u0016\u001c8\u000fI\u0001\u001ea2\f\u0017N\u001c;fqRd\u0015n\u001d;f]\u0016\u0014H)\u001a4bk2$\u0018+^8uCV\tq\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0002J]R\fa\u0004\u001d7bS:$X\r\u001f;MSN$XM\\3s\t\u00164\u0017-\u001e7u#V|G/\u0019\u0011\u0002;Ad\u0017-\u001b8uKb$H*[:uK:,'\u000fR3gCVdGO\u00127p_J\fa\u0004\u001d7bS:$X\r\u001f;MSN$XM\\3s\t\u00164\u0017-\u001e7u\r2|wN\u001d\u0011\u0002\tQLW.Z\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011Q+H\u0001\u0006kRLGn]\u0005\u0003/R\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\bg2,W\r]'t+\u0005Y\u0006C\u0001%]\u0013\ti\u0016J\u0001\u0003M_:<\u0017\u0001C:mK\u0016\u0004Xj\u001d\u0011\u0002/\r|gN\\3di&|gNU1uK\u001acwn\u001c:Qe>\u0004X#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011\u0004\u0015\u0001\u00027b]\u001eL!AZ2\u0003\rM#(/\u001b8h\u0003a\u0019wN\u001c8fGRLwN\u001c*bi\u00164En\\8s!J|\u0007\u000fI\u0001\fEJ|7.\u001a:D_VtG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u00111N\u001c\t\u0003\u00112L!!\\%\u0003\tUs\u0017\u000e\u001e\u0005\u0006_F\u0001\r\u0001]\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA9u\u001b\u0005\u0011(BA:A\u0003\u0011)H/\u001b7\n\u0005U\u0014(A\u0003)s_B,'\u000f^5fg\u0006Q!M]8lKJ$\u0016.\\3\u0015\u0005al\bCA=|\u001b\u0005Q(BA+1\u0013\ta(P\u0001\u0003US6,\u0007\"\u0002@\u0013\u0001\u00049\u0015\u0001\u00032s_.,'/\u00133\u0002UQ,7\u000f\u001e#z]\u0006l\u0017nY\"p]:,7\r^5p]J\u000bG/\u001a+v]&twMU3d_:4\u0017nZ;sKR\t1\u000eK\u0002\u0014\u0003\u000b\u0001B!a\u0002\u0002\u00165\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0002ba&TA!a\u0004\u0002\u0012\u00059!.\u001e9ji\u0016\u0014(bAA\nk\u0005)!.\u001e8ji&!\u0011qCA\u0005\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f\u001e#z]\u0006l\u0017nY\"p]:,7\r^5p]J\u000bG/\u001a+v]&tw\rR5tC\ndW\rK\u0002\u0015\u0003\u000b\taC^3sS\u001aL8i\u001c8gS\u001e\u0004&o\u001c9bO\u0006$X\r\u001a\u000b\u0006W\u0006\u0005\u0012\u0011\b\u0005\b\u0003G)\u0002\u0019AA\u0013\u0003\u0011\u0001(o\u001c9\u0011\t\u0005\u001d\u0012Q\u0007\b\u0005\u0003S\t\t\u0004E\u0002\u0002,%k!!!\f\u000b\u0007\u0005=r$\u0001\u0004=e>|GOP\u0005\u0004\u0003gI\u0015A\u0002)sK\u0012,g-C\u0002g\u0003oQ1!a\rJ\u0011\u001d\tY$\u0006a\u0001\u0003K\tQA^1mk\u0016\f1\"\u00197uKJ\u001cuN\u001c4jOR)1.!\u0011\u0002D!9\u00111\u0005\fA\u0002\u0005\u0015\u0002bBA\u001e-\u0001\u0007\u0011QE\u0001#o\u0006LGOR8s\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|gNU1uKF+x\u000e^1\u0015\u000f-\fI%a\u0016\u0002\\!9\u00111J\fA\u0002\u00055\u0013aB7fiJL7m\u001d\t\u0005\u0003\u001f\n\u0019&\u0004\u0002\u0002R)\u0019\u00111\n\u0019\n\t\u0005U\u0013\u0011\u000b\u0002\b\u001b\u0016$(/[2t\u0011\u0019\tIf\u0006a\u0001\u000f\u0006\u0011R\r\u001f9fGR,G-U;pi\u0006d\u0015.\\5u\u0011!\tif\u0006I\u0001\u0002\u0004Y\u0016!C7bq^\u000b\u0017\u000e^'t\u00031:\u0018-\u001b;G_Jd\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0002d)\u001a1,!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001dJ\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faDZ8sG\u0016\u001cuN\u001c8fGRLwN\u001c*bi\u0016$VO\\5oO\u000eCWmY6")
public class ConfluentConnectionQuotasReconfigurationTest
extends BaseRequestTest {
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final int plaintextListenerDefaultQuota;
    private final int plaintextListenerDefaultFloor;
    private final MockTime time = new MockTime();
    private final long sleepMs = ConnectionQuotas$.MODULE$.ConnectionBackpressureCheckIntervalMs() + 1L;
    private final String connectionRateFloorProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public int plaintextListenerDefaultFloor() {
        return this.plaintextListenerDefaultFloor;
    }

    public MockTime time() {
        return this.time;
    }

    public long sleepMs() {
        return this.sleepMs;
    }

    public String connectionRateFloorProp() {
        return this.connectionRateFloorProp;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.plaintextListenerDefaultQuota()));
        properties.put(this.connectionRateFloorProp(), Integer.toString(this.plaintextListenerDefaultFloor()));
    }

    @Override
    public Time brokerTime(int brokerId) {
        return this.time();
    }

    @Test
    public void testDynamicConnectionRateTuningReconfigure() {
        int updatedFloor = 20;
        this.forceConnectionRateTuningCheck();
        this.waitForListenerConnectionRateQuota(((KafkaServer)this.servers().head()).metrics(), this.plaintextListenerDefaultFloor(), 15000L);
        this.forceConnectionRateTuningCheck();
        Assertions.assertThrows(AssertionError.class, () -> this.waitForListenerConnectionRateQuota(((KafkaServer)this.servers().head()).metrics(), 20, TimeUnit.SECONDS.toMillis(1L)));
        this.alterConfig(this.connectionRateFloorProp(), Integer.toString(updatedFloor));
        this.forceConnectionRateTuningCheck();
        this.waitForListenerConnectionRateQuota(((KafkaServer)this.servers().head()).metrics(), 25, 15000L);
        this.forceConnectionRateTuningCheck();
        this.waitForListenerConnectionRateQuota(((KafkaServer)this.servers().head()).metrics(), updatedFloor, 15000L);
    }

    @Test
    public void testDynamicConnectionRateTuningDisable() {
        this.forceConnectionRateTuningCheck();
        this.waitForListenerConnectionRateQuota(((KafkaServer)this.servers().head()).metrics(), 25, 15000L);
        this.alterConfig(this.connectionRateFloorProp(), Integer.toString(this.plaintextListenerDefaultQuota()));
        this.forceConnectionRateTuningCheck();
        Assertions.assertThrows(AssertionError.class, () -> this.waitForListenerConnectionRateQuota(((KafkaServer)this.servers().head()).metrics(), 25, TimeUnit.SECONDS.toMillis(1L)));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyConfigPropagated(String prop, String value) {
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ConfluentConnectionQuotasReconfigurationTest.$anonfun$verifyConfigPropagated$1(this, value, prop);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    private void alterConfig(String prop, String value) {
        Properties props = new Properties();
        props.put(prop, value);
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        TestUtils$.MODULE$.incrementalAlterConfigs(this.servers(), (Admin)adminClient, props, false, AlterConfigOp.OpType.SET).all().get();
        this.verifyConfigPropagated(prop, value);
        adminClient.close();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForListenerConnectionRateQuota(Metrics metrics, int expectedQuotaLimit, long maxWaitMs) {
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ConfluentConnectionQuotasReconfigurationTest.$anonfun$waitForListenerConnectionRateQuota$1(this, metrics, expectedQuotaLimit);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var11_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForListenerConnectionRateQuota$default$3() {
        return 15000L;
    }

    private void forceConnectionRateTuningCheck() {
        DataPlaneAcceptor acceptor = (DataPlaneAcceptor)((Tuple2)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala((ConcurrentMap)((KafkaServer)this.servers().head()).socketServer().dataPlaneAcceptors()).asScala().head())._2();
        this.time().sleep(this.sleepMs());
        acceptor.processorQueueSizeSensor().record(16.0, this.time().milliseconds());
        acceptor.wakeup();
    }

    public static final /* synthetic */ void $anonfun$verifyConfigPropagated$1(ConfluentConnectionQuotasReconfigurationTest $this, String value$1, String prop$1) {
        Assertions.assertEquals((Object)value$1, ((KafkaServer)$this.servers().head()).config().originals().get(prop$1));
    }

    public static final /* synthetic */ void $anonfun$waitForListenerConnectionRateQuota$1(ConfluentConnectionQuotasReconfigurationTest $this, Metrics metrics$1, int expectedQuotaLimit$1) {
        KafkaMetric rateMetric = metrics$1.metric(metrics$1.metricName("connection-tokens", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), $this.listener().value())));
        KafkaMetric rateLimitMetric = metrics$1.metric(metrics$1.metricName("connection-accept-limit", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), $this.listener().value())));
        Assertions.assertEquals((double)expectedQuotaLimit$1, (double)rateMetric.config().quota().bound(), (double)0.01);
        Assertions.assertEquals((double)expectedQuotaLimit$1, (double)BoxesRunTime.unboxToDouble((Object)rateLimitMetric.metricValue()), (double)0.01);
    }

    public ConfluentConnectionQuotasReconfigurationTest() {
        this.plaintextListenerDefaultQuota = 30;
        this.plaintextListenerDefaultFloor = 25;
    }
}

