/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotas$;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ProcessorQueueSizePercentiles$;
import kafka.server.QueueSizePercentiles;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YB\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"\u0003(\u0001\u0001\u0004\u0005\t\u0015)\u0003<\u0011%y\u0005\u00011AA\u0002\u0013%\u0001\u000bC\u0005U\u0001\u0001\u0007\t\u0019!C\u0005+\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019\u0001\u0007\u0001)A\u00055\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u0002<\u0001A\u0003%1\rC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\"IQ\u0010\u0001a\u0001\u0002\u0004%IA \u0005\u000b\u0003\u0003\u0001\u0001\u0019!A!B\u0013I\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u001d\u0001\"CA\b\u0001\t\u0007I\u0011BA\u0003\u0011!\t\t\u0002\u0001Q\u0001\n\u0005\u001d\u0001\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011\u001d\t9\u0002\u0001Q\u0001\n%D\u0011\"!\u0007\u0001\u0005\u0004%I!!\u0006\t\u000f\u0005m\u0001\u0001)A\u0005S\"I\u0011Q\u0004\u0001C\u0002\u0013%\u0011Q\u0003\u0005\b\u0003?\u0001\u0001\u0015!\u0003j\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u0012\u0001\t\u0003\ty\u0003C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005=\u0002bBA:\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003o\u0002A\u0011AA\u0018\u0011\u001d\tY\b\u0001C\u0001\u0003_Aq!a \u0001\t\u0003\ty\u0003C\u0004\u0002\u0004\u0002!\t!a\f\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u00111\u0013\u0001\u0005\n\u0005U\u0005bBAO\u0001\u0011%\u0011q\u0014\u0002\u001e\u0007>tg\r\\;f]R\u001cuN\u001c8fGRLwN\\)v_R\f7\u000fV3ti*\u0011!fK\u0001\b]\u0016$xo\u001c:l\u0015\u0005a\u0013!B6bM.\f7\u0001A\n\u0003\u0001=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00018!\tA\u0004!D\u0001*\u0003\u001diW\r\u001e:jGN,\u0012a\u000f\t\u0003y\u0015k\u0011!\u0010\u0006\u0003syR!a\u0010!\u0002\r\r|W.\\8o\u0015\ta\u0013I\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$>\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003a)K!aS\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u000e\t\t\u00111\u0001<\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0002#B\u0011\u0001HU\u0005\u0003'&\u0012\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u0002)\r|gN\\3di&|g.U;pi\u0006\u001cx\fJ3r)\tIe\u000bC\u0004N\r\u0005\u0005\t\u0019A)\u0002#\r|gN\\3di&|g.U;pi\u0006\u001c\b%\u0001\u0003uS6,W#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u[\u0013!B;uS2\u001c\u0018BA0]\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!\u00037jgR,g.\u001a:t+\u0005\u0019\u0007\u0003\u00023hSFl\u0011!\u001a\u0006\u0003MF\n!bY8mY\u0016\u001cG/[8o\u0013\tAWMA\u0002NCB\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\t1\fgn\u001a\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u00018N\u0001\u0004TiJLgn\u001a\t\u0003eRl\u0011a\u001d\u0006\u0003UyJ!!^:\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u00151L7\u000f^3oKJ\u001c\b%\u0001\rmSN$XM\\3s#V,W/Z*ju\u0016\u001cVM\\:peN,\u0012!\u001f\t\u0005I\u001e\f(\u0010\u0005\u0002=w&\u0011A0\u0010\u0002\u0007'\u0016t7o\u001c:\u000291L7\u000f^3oKJ\fV/Z;f'&TXmU3og>\u00148o\u0018\u0013fcR\u0011\u0011j \u0005\b\u001b6\t\t\u00111\u0001z\u0003ea\u0017n\u001d;f]\u0016\u0014\u0018+^3vKNK'0Z*f]N|'o\u001d\u0011\u0002;\u0011,g-Y;mi\u000e{gN\\3di&|gn\u0011:fCRLwN\u001c*bi\u0016,\"!a\u0002\u0011\u0007A\nI!C\u0002\u0002\fE\u00121!\u00138u\u0003y!WMZ1vYR\u001cuN\u001c8fGRLwN\\\"sK\u0006$\u0018n\u001c8SCR,\u0007%A\u000fd_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018-\u00113kkN$X.\u001a8u\u0003y\u0019wN\u001c8fGRLwN\u001c*bi\u0016\fVo\u001c;b\u0003\u0012TWo\u001d;nK:$\b%A\rfqR,'O\\1m\u0019&\u001cH/\u001a8fe2KW.\u001b;Qe>\u0004X#A5\u00025\u0015DH/\u001a:oC2d\u0015n\u001d;f]\u0016\u0014H*[7jiB\u0013x\u000e\u001d\u0011\u00023\u0015DH/\u001a:oC2d\u0015n\u001d;f]\u0016\u0014h\t\\8peB\u0013x\u000e]\u0001\u001bKb$XM\u001d8bY2K7\u000f^3oKJ4En\\8s!J|\u0007\u000fI\u0001\u001de\u0016\u0004H.[2bi&|g\u000eT5ti\u0016tWM\u001d$m_>\u0014\bK]8q\u0003u\u0011X\r\u001d7jG\u0006$\u0018n\u001c8MSN$XM\\3s\r2|wN\u001d)s_B\u0004\u0013AE:b[BdW-\u0012=qSJ\fG/[8o\u001bN,\"!!\n\u0011\u0007A\n9#C\u0002\u0002*E\u0012A\u0001T8oO\u0006\u00192/Y7qY\u0016,\u0005\u0010]5sCRLwN\\'tA\u0005)1/\u001a;VaR\t\u0011\nK\u0002\u001c\u0003g\u0001B!!\u000e\u0002D5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0002ba&TA!!\u0010\u0002@\u00059!.\u001e9ji\u0016\u0014(bAA!\u0007\u0006)!.\u001e8ji&!\u0011QIA\u001c\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aA$a\u0013\u0011\t\u0005U\u0012QJ\u0005\u0005\u0003\u001f\n9DA\u0005BMR,'/R1dQ\u0006Q#M]8lKJ\u0004&o\u001c9t/&$\b.\u0012=uKJt\u0017\r\\\"p]:,7\r^5p]J\u000bG/\u001a'j[&$XCAA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.[\u0006!Q\u000f^5m\u0013\u0011\ty&!\u0017\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\fde\u0016\fG/Z\"p]:,7\r^5p]F+x\u000e^1t)\rI\u0015Q\r\u0005\b\u0003Or\u0002\u0019AA+\u0003\u0015\u0001(o\u001c9t\u0003=\"Xm\u001d;V]\u000e|gNZ5hkJ,G\rT5ti\u0016tWM]\"p]:,7\r^5p]J\u000bG/\u001a$m_>\u0014\bK]8qQ\ry\u0012Q\u000e\t\u0005\u0003k\ty'\u0003\u0003\u0002r\u0005]\"\u0001\u0002+fgR\f\u0001\u0006^3ti2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016$VO\\5oO\u0012K7/\u00192mK\u0012D3\u0001IA7\u0003!\"Xm\u001d;SK\u0012,8-\u001a'jgR,g.\u001a:Rk>$\u0018mV5uQ\"Kw\r[)vKV,7+\u001b>fQ\r\t\u0013QN\u0001*i\u0016\u001cH/\u00138de\u0016\f7/\u001a'jgR,g.\u001a:Rk>$\u0018mV5uQ2{w/U;fk\u0016\u001c\u0016N_3)\u0007\t\ni'\u0001\u0016uKN$(+Z2p]\u001aLw-\u001e:f\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|gNU1uK\u001acwn\u001c:)\u0007\r\ni'\u0001\u0015uKN$(+Z2p]\u001aLw-\u001e:f\u0019&\u001cH/\u001a8fe6\u000b\u0007pQ8o]\u0016\u001cG/[8o%\u0006$X\rK\u0002%\u0003[\n\u0001D]3d_J$\u0007K]8dKN\u001cxN])vKV,7+\u001b>f)\u0015I\u00151RAH\u0011\u0019\ti)\na\u0001c\u0006AA.[:uK:,'\u000fC\u0004\u0002\u0012\u0016\u0002\r!a\u0002\u0002\u000bY\fG.^3\u00021I,7m\u001c8gS\u001e,(/\u001a'jgR,g.\u001a:Rk>$\u0018\rF\u0004J\u0003/\u000bI*a'\t\u000b=3\u0003\u0019A)\t\u000f\u0005\u001dd\u00051\u0001\u0002V!1\u0011Q\u0012\u0014A\u0002E\f\u0011E^3sS\u001aLH*[:uK:,'oQ8o]\u0016\u001cG/[8o%\u0006$X-U;pi\u0006$R!SAQ\u0003GCa!!$(\u0001\u0004\t\bbBASO\u0001\u0007\u0011qA\u0001\u0013Kb\u0004Xm\u0019;fIF+x\u000e^1MS6LG\u000f")
public class ConfluentConnectionQuotasTest {
    private Metrics metrics;
    private ConnectionQuotas connectionQuotas;
    private final MockTime time = new MockTime();
    private final Map<String, ListenerName> listeners = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)new ListenerName("EXTERNAL")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REPLICATION"), (Object)new ListenerName("REPLICATION"))}));
    private Map<ListenerName, Sensor> listenerQueueSizeSensors;
    private final int defaultConnectionCreationRate;
    private final int connectionRateQuotaAdjustment = ConnectionQuotas$.MODULE$.DefaultConnectionRateQuotaAdjustment();
    private final String externalListenerLimitProp = new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"EXTERNAL")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
    private final String externalListenerFloorProp = new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"EXTERNAL")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
    private final String replicationListenerFloorProp = new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"REPLICATION")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
    private final long sampleExpirationMs = TimeUnit.MINUTES.toMillis(1L);

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<String, ListenerName> listeners() {
        return this.listeners;
    }

    private Map<ListenerName, Sensor> listenerQueueSizeSensors() {
        return this.listenerQueueSizeSensors;
    }

    private void listenerQueueSizeSensors_$eq(Map<ListenerName, Sensor> x$1) {
        this.listenerQueueSizeSensors = x$1;
    }

    private int defaultConnectionCreationRate() {
        return this.defaultConnectionCreationRate;
    }

    private int connectionRateQuotaAdjustment() {
        return this.connectionRateQuotaAdjustment;
    }

    private String externalListenerLimitProp() {
        return this.externalListenerLimitProp;
    }

    private String externalListenerFloorProp() {
        return this.externalListenerFloorProp;
    }

    private String replicationListenerFloorProp() {
        return this.replicationListenerFloorProp;
    }

    private long sampleExpirationMs() {
        return this.sampleExpirationMs;
    }

    @BeforeEach
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time()));
        this.listenerQueueSizeSensors_$eq((Map<ListenerName, Sensor>)((IterableOnceOps)this.listeners().values().map((Function1 & Serializable)listener -> {
            void add_stat;
            void createPercentiles_tags;
            void createPercentiles_metricNamePrefix;
            void createPercentiles_queueSize;
            void createPercentiles_metrics;
            Percentiles percentiles;
            Sensor sensor = this.metrics().sensor(new StringBuilder(19).append("ProcessorQueueSize-").append(listener.value()).toString());
            Map map = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener"), (Object)listener.value())}));
            String string = "";
            int n = Processor$.MODULE$.ConnectionQueueSize();
            Metrics metrics = this.metrics();
            ProcessorQueueSizePercentiles$ createPercentiles_this = ProcessorQueueSizePercentiles$.MODULE$;
            Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
            Object var3_7 = null;
            metrics = null;
            string = null;
            map = null;
            percentiles = null;
            Percentiles percentiles3 = percentiles2;
            if (sensor == null) {
                throw null;
            }
            sensor.add((CompoundStat)add_stat, null);
            percentiles3 = null;
            return new Tuple2(listener, (Object)sensor);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @AfterEach
    public void tearDown() {
        if (this.connectionQuotas() != null) {
            this.connectionQuotas().close();
        }
        this.metrics().close();
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithExternalConnectionRateLimit() {
        void var1_23;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp(), Integer.toString(1));
        props.put(new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"EXTERNAL")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.defaultConnectionCreationRate()));
        return var1_23;
    }

    private void createConnectionQuotas(Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, (Time)this.time(), this.metrics()));
        this.listeners().values().foreach((Function1 & Serializable)x$4 -> {
            ConfluentConnectionQuotasTest.$anonfun$createConnectionQuotas$1(this, config, x$4);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUnconfiguredListenerConnectionRateFloorProp() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        ListenerName replicationListener = (ListenerName)this.listeners().apply((Object)"REPLICATION");
        this.createConnectionQuotas(this.brokerPropsWithExternalConnectionRateLimit());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.recordProcessorQueueSize(externalListener, 16);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(replicationListener);
        this.verifyListenerConnectionRateQuota(replicationListener, Defaults$.MODULE$.MaxConnectionCreationRate());
        this.recordProcessorQueueSize(replicationListener, 16);
        this.verifyListenerConnectionRateQuota(replicationListener, Defaults$.MODULE$.MaxConnectionCreationRate());
    }

    @Test
    public void testListenerConnectionRateTuningDisabled() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        ListenerName replicationListener = (ListenerName)this.listeners().apply((Object)"REPLICATION");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int replicationConnectionRateFloor = this.defaultConnectionCreationRate() + 5;
        props.put(this.externalListenerFloorProp(), Integer.toString(this.defaultConnectionCreationRate()));
        props.put(new StringBuilder(0).append(replicationListener.configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.defaultConnectionCreationRate()));
        props.put(this.replicationListenerFloorProp(), Integer.toString(replicationConnectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.recordProcessorQueueSize(replicationListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(replicationListener);
        this.verifyListenerConnectionRateQuota(replicationListener, this.defaultConnectionCreationRate());
    }

    @Test
    public void testReduceListenerQuotaWithHighQueueSize() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        ListenerName replicationListener = (ListenerName)this.listeners().apply((Object)"REPLICATION");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        props.put(new StringBuilder(0).append(replicationListener.configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.defaultConnectionCreationRate()));
        props.put(this.replicationListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.connectionQuotas().maybeAdjustListenerQuota(replicationListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        this.verifyListenerConnectionRateQuota(replicationListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
    }

    @Test
    public void testIncreaseListenerQuotaWithLowQueueSize() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        this.time().sleep(this.sampleExpirationMs());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
    }

    @Test
    public void testReconfigureListenerConnectionRateFloor() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
        int reducedFloor = 25;
        props.put(this.externalListenerFloorProp(), Integer.toString(reducedFloor));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, reducedFloor);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> this.connectionQuotas().maybeAdjustListenerQuota(externalListener));
        this.verifyListenerConnectionRateQuota(externalListener, reducedFloor);
        int increasedFloor = 32;
        props.put(this.externalListenerFloorProp(), Integer.toString(increasedFloor));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, increasedFloor);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, increasedFloor);
        this.time().sleep(this.sampleExpirationMs());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, increasedFloor + this.connectionRateQuotaAdjustment());
        props.remove(this.externalListenerFloorProp());
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
    }

    @Test
    public void testReconfigureListenerMaxConnectionRate() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        int newRateLimit = 45;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        props.put(this.externalListenerLimitProp(), Integer.toString(newRateLimit));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, newRateLimit);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, newRateLimit - this.connectionRateQuotaAdjustment());
        props.put(this.externalListenerLimitProp(), Integer.toString(this.defaultConnectionCreationRate()));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
    }

    private void recordProcessorQueueSize(ListenerName listener, int value) {
        ((Sensor)this.listenerQueueSizeSensors().apply((Object)listener)).record((double)value);
    }

    private void reconfigureListenerQuota(ConnectionQuotas connectionQuotas, Properties props, ListenerName listener) {
        java.util.Map listenerConfig = KafkaConfig$.MODULE$.fromProps(props).valuesWithPrefixOverride(listener.configPrefix());
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas.maxConnectionsPerListener().apply((Object)listener)).reconfigure(listenerConfig);
    }

    private void verifyListenerConnectionRateQuota(ListenerName listener, int expectedQuotaLimit) {
        KafkaMetric rateMetric = this.metrics().metric(this.metrics().metricName("connection-tokens", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener.value())));
        Assertions.assertEquals((double)expectedQuotaLimit, (double)rateMetric.config().quota().bound(), (double)0.01);
        KafkaMetric rateLimitMetric = this.metrics().metric(this.metrics().metricName("connection-accept-limit", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener.value())));
        Assertions.assertEquals((double)expectedQuotaLimit, (double)BoxesRunTime.unboxToDouble((Object)rateLimitMetric.metricValue()), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$createConnectionQuotas$1(ConfluentConnectionQuotasTest $this, KafkaConfig config$1, ListenerName x$4) {
        $this.connectionQuotas().addListener(config$1, x$4);
    }

    public ConfluentConnectionQuotasTest() {
        this.defaultConnectionCreationRate = 40;
    }
}

