/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Future;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.log.LogAppendInfo;
import kafka.log.TierLogSegment;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherPool;
import kafka.server.FetcherStats;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetFromLeader;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.TierState;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u0005b\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019i\u0005\u0001)A\u0005\u0015\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002,\u0001A\u0003%\u0001\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003j\u0001\u0011%!\u000eC\u0003|\u0001\u0011\u0005\u0001\f\u0003\u0004\u0002\u0002\u0001!\t\u0001\u0017\u0005\u0007\u0003\u000b\u0001A\u0011\u0001-\t\r\u0005%\u0001\u0001\"\u0001Y\u0011\u0019\ti\u0001\u0001C\u00011\"1\u0011\u0011\u0003\u0001\u0005\u0002aCa!!\u0006\u0001\t\u0003A\u0006BBA\r\u0001\u0011\u0005\u0001\f\u0003\u0004\u0002\u001e\u0001!\t\u0001\u0017\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011%\t\t\u0004AI\u0001\n\u0013\t\u0019\u0004C\u0004\u0002J\u0001!I!a\u0013\t\u0013\u0005]\u0004!%A\u0005\n\u0005e\u0004bBA?\u0001\u0011%\u0011q\u0010\u0004\u0007\u0003\u000f\u0003A!!#\t\u0013\u0005E\u0005D!A!\u0002\u0013\u0001\u0006BCAJ1\t\u0005\t\u0015!\u0003\u0002\u0016\"1a\b\u0007C\u0001\u00037Cq!!*\u0019\t#\n9\u000bC\u0004\u0002Nb!\t&a4\t\u000f\u0005u\u0007\u0004\"\u0015\u0002`\"9\u0011q\u001d\r\u0005R\u0005%\bb\u0002B\r1\u0011E#1\u0004\u0005\b\u0005CAB\u0011\u000bB\u0012\u0011\u001d\u00119\u0003\u0007C)\u0005SAqA!\f\u0019\t#\u0012y\u0003C\u0004\u0003@a!\tF!\u0011\t\u000f\t]\u0004\u0004\"\u0015\u0003z!9!Q\u0013\r\u0005R\t]\u0005b\u0002BP1\u0011E#\u0011\u0015\u0005\b\u0005OCB\u0011\u000bBU\u0011\u001d\u0011)\f\u0007C)\u0005oCqAa8\u0019\t#\u0012\t\u000fC\u0004\u0003nb!\tFa<\t\u000f\te\b\u0004\"\u0015\u0003|\"I1\u0011\u0003\rC\u0002\u0013E31\u0003\u0005\t\u00077A\u0002\u0015!\u0003\u0004\u0016!I1Q\u0004\rC\u0002\u0013E31\u0003\u0005\t\u0007?A\u0002\u0015!\u0003\u0004\u0016\tQ\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000fV3ti*\u00111\u0007N\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001!\u0011\u0005\u0005\u0003Q\"\u0001\u001a\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r^\u000b\u0002\tB\u0011\u0011(R\u0005\u0003\rj\u0012A\u0001T8oO\u0006aa-\u001a;dQ>3gm]3uA\u0005YA.Z1eKJ,\u0005o\\2i+\u0005Q\u0005CA\u001dL\u0013\ta%HA\u0002J]R\fA\u0002\\3bI\u0016\u0014X\t]8dQ\u0002\naB\u0019:pW\u0016\u0014XI\u001c3Q_&tG/F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F'A\u0004dYV\u001cH/\u001a:\n\u0005U\u0013&A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\u0010EJ|7.\u001a:F]\u0012\u0004v.\u001b8uA\u0005\u00192\r\\3b]6+GO]5d%\u0016<\u0017n\u001d;ssR\t\u0011\f\u0005\u0002:5&\u00111L\u000f\u0002\u0005+:LG\u000f\u000b\u0002\t;B\u0011alZ\u0007\u0002?*\u0011\u0001-Y\u0001\u0004CBL'B\u00012d\u0003\u001dQW\u000f]5uKJT!\u0001Z3\u0002\u000b),h.\u001b;\u000b\u0003\u0019\f1a\u001c:h\u0013\tAwL\u0001\u0006CK\u001a|'/Z#bG\"\fabZ3u\u001b\u0016$(/[2WC2,X\r\u0006\u0002l]B\u0011\u0011\b\\\u0005\u0003[j\u00121!\u00118z\u0011\u0015y\u0017\u00021\u0001q\u0003\u0011q\u0017-\\3\u0011\u0005EDhB\u0001:w!\t\u0019((D\u0001u\u0015\t)h'\u0001\u0004=e>|GOP\u0005\u0003oj\na\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qOO\u0001\u001ai\u0016\u001cH/\u00113e\u0003:$'+Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u000b{B\u0011aL`\u0005\u0003\u007f~\u0013A\u0001V3ti\u0006qB/Z:u\u001b\u0016$(/[2GC&dW\r\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0003\u0017u\f\u0011\u0004^3ti\u0012+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG\"\u0012A\"`\u0001\u0017i\u0016\u001cH/T5o\r\u0016$8\r\u001b*bi\u0016lU\r\u001e:jG\"\u0012Q\"`\u0001\u0013i\u0016\u001cH\u000fV8uC2d\u0015mZ'fiJL7\r\u000b\u0002\u000f{\u0006YB/Z:u\u001b&<'/\u0019;f\u0013:\u001c\u0016P\\2QCJ$\u0018\u000e^5p]ND#aD?\u0002/Q,7\u000f^'bs\n,W\u000b\u001d3bi\u0016$v\u000e]5d\u0013\u0012\u001c\bF\u0001\t~\u0003Q!Xm\u001d;FqB\fg\u000e\u001a+ie\u0016\fG\rU8pY\"\u0012\u0011#`\u0001\u0015i\u0016\u001cHo\u00155sS:\\G\u000b\u001b:fC\u0012\u0004vn\u001c7)\u0005Ii\u0018\u0001\u0006;fgR\u0014Vm]5{KRC'/Z1e!>|G\u000eF\u0004Z\u0003K\tI#!\f\t\r\u0005\u001d2\u00031\u0001K\u0003I\u0019WO\u001d:f]R4U\r^2iKJ\u001c\u0016N_3\t\r\u0005-2\u00031\u0001K\u00039qWm\u001e$fi\u000eDWM]*ju\u0016D\u0001\"a\f\u0014!\u0003\u0005\rAS\u0001\nEJ|7.\u001a:Ok6\fa\u0004^3tiJ+7/\u001b>f)\"\u0014X-\u00193Q_>dG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U\"f\u0001&\u00028-\u0012\u0011\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003%)hn\u00195fG.,GMC\u0002\u0002Di\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9%!\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nnC.,Gk\u001c9jGB\u000b'\u000f^5uS>tG\u0003CA'\u0003W\ny'a\u001d\u0011\r\u0005=\u0013QKA-\u001b\t\t\tFC\u0002\u0002Ti\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9&!\u0015\u0003\u0007M+G\u000f\u0005\u0003\u0002\\\u0005\u001dTBAA/\u0015\u0011\ty&!\u0019\u0002\r\r|W.\\8o\u0015\r)\u00141\r\u0006\u0004\u0003K*\u0017AB1qC\u000eDW-\u0003\u0003\u0002j\u0005u#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003[*\u0002\u0019\u0001&\u0002\u0011Q|\u0007/[2Ok6Da!!\u001d\u0016\u0001\u0004Q\u0015\u0001\u00049beRLG/[8o\u001dVl\u0007\u0002CA;+A\u0005\t\u0019\u00019\u0002\u0017Q|\u0007/[2Qe\u00164\u0017\u000e_\u0001\u001d[\u0006\\W\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tYHK\u0002q\u0003o\t1bZ3u\u0005J|7.\u001a:JIR)!*!!\u0002\u0006\"9\u00111Q\fA\u0002\u0005e\u0013A\u0001;q\u0011\u0019\tyc\u0006a\u0001\u0015\n9B+Z:u%\u0016\u001c\u0018N_3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\n\u00041\u0005-\u0005cA!\u0002\u000e&\u0019\u0011q\u0012\u001a\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006a1o\\;sG\u0016\u0014%o\\6fe\u0006\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004\u0003\u0006]\u0015bAAMe\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003;\u000b\t+a)\u0011\u0007\u0005}\u0005$D\u0001\u0001\u0011\u0019\t\tj\u0007a\u0001!\"9\u00111S\u000eA\u0002\u0005U\u0015\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002*\u0006m\u0016qXAa!\u0015I\u00141VAX\u0013\r\tiK\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.5\u0003\rawnZ\u0005\u0005\u0003s\u000b\u0019LA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003{c\u0002\u0019AA-\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DQA\u0011\u000fA\u0002\u0011Cq!a1\u001d\u0001\u0004\t)-A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003\u000f\fI-D\u0001\u0019\u0013\u0011\tY-!$\u0003\u0013\u0019+Go\u00195ECR\f\u0017\u0001\u0003;sk:\u001c\u0017\r^3\u0015\u000be\u000b\t.a5\t\u000f\u0005uV\u00041\u0001\u0002Z!9\u0011Q[\u000fA\u0002\u0005]\u0017a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007\u0005\u000bI.C\u0002\u0002\\J\u0012Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR)\u0011,!9\u0002d\"9\u0011Q\u0018\u0010A\u0002\u0005e\u0003BBAs=\u0001\u0007A)\u0001\u0004pM\u001a\u001cX\r^\u0001\u000bEVLG\u000e\u001a$fi\u000eDG\u0003BAv\u0005\u0013\u0001b!!<\u0002|\n\u0005a\u0002BAx\u0003otA!!=\u0002v:\u00191/a=\n\u0003UJ!a\r\u001b\n\u0007\u0005e('A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\n\t\u0005u\u0018q \u0002\u0015%\u0016\u001cX\u000f\u001c;XSRD\u0007+\u0019:uSRLwN\\:\u000b\u0007\u0005e(\u0007E\u0003:\u0003W\u0013\u0019\u0001\u0005\u0003\u0002n\n\u0015\u0011\u0002\u0002B\u0004\u0003\u007f\u0014ABU3qY&\u001c\u0017MR3uG\"DqAa\u0003 \u0001\u0004\u0011i!\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000f\u0005\u0005\u0002P\t=\u0011\u0011\fB\n\u0013\u0011\u0011\t\"!\u0015\u0003\u00075\u000b\u0007\u000fE\u0002B\u0005+I1Aa\u00063\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\tu!q\u0004\t\u0005s\u0005-&\nC\u0004\u0002>\u0002\u0002\r!!\u0017\u0002\u001d1|wm\u0015;beR|eMZ:fiR\u0019AI!\n\t\u000f\u0005u\u0016\u00051\u0001\u0002Z\u0005aAn\\4F]\u0012|eMZ:fiR\u0019AIa\u000b\t\u000f\u0005u&\u00051\u0001\u0002Z\u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\tE\"\u0011\bB\u001e!\u0015I\u00141\u0016B\u001a!\r\t%QG\u0005\u0004\u0005o\u0011$AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0003{\u001b\u0003\u0019AA-\u0011\u0019\u0011id\ta\u0001\u0015\u0006)Q\r]8dQ\u0006!b-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$BAa\u0011\u0003lAA\u0011q\nB\b\u00033\u0012)\u0005\u0005\u0003\u0003H\t\u0015d\u0002\u0002B%\u0005?rAAa\u0013\u0003\\9!!Q\nB-\u001d\u0011\u0011yEa\u0016\u000f\t\tE#Q\u000b\b\u0004g\nM\u0013\"\u00014\n\u0007\u0005\u0015T-C\u00026\u0003GJA!a\u0018\u0002b%!!QLA/\u0003\u001diWm]:bO\u0016LAA!\u0019\u0003d\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0015\u0011\u0011i&!\u0018\n\t\t\u001d$\u0011\u000e\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\u0011\tGa\u0019\t\u000f\t5D\u00051\u0001\u0003p\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u0011\u0005=#qBA-\u0005c\u0002B!a2\u0003t%!!QOAG\u0005%)\u0005o\\2i\t\u0006$\u0018-A\bgKR\u001c\u0007N\u0012:p[2+\u0017\rZ3s)\u0011\u0011YH! \u0011\u0011\u0005=#qBA-\u0003\u000bDqAa &\u0001\u0004\u0011\t)\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0003\u0004\n=e\u0002\u0002BC\u0005\u0017k!Aa\"\u000b\t\t%\u0015QL\u0001\te\u0016\fX/Z:ug&!!Q\u0012BD\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011\tJa%\u0003\u000f\t+\u0018\u000e\u001c3fe*!!Q\u0012BD\u0003u1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014H#\u0002#\u0003\u001a\nm\u0005bBA_M\u0001\u0007\u0011\u0011\f\u0005\u0007\u0005;3\u0003\u0019\u0001&\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[\u0001\u001cM\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\u000b\u0011\u0013\u0019K!*\t\u000f\u0005uv\u00051\u0001\u0002Z!1!QT\u0014A\u0002)\u000b\u0001FZ3uG\"$\u0016.\u001a:NCR,'/[1mSj\fG/[8o)\u0006\u0014x-\u001a;Ge>lG*Z1eKJ$bAa+\u00032\nM\u0006cA!\u0003.&\u0019!q\u0016\u001a\u0003!=3gm]3u\rJ|W\u000eT3bI\u0016\u0014\bbBA_Q\u0001\u0007\u0011\u0011\f\u0005\u0007\u0005;C\u0003\u0019\u0001&\u0002\u001d\u0019,Go\u00195US\u0016\u00148\u000b^1uKR1!\u0011\u0018Bj\u0005+\u0004bAa/\u0003J\n5WB\u0001B_\u0015\u0011\u0011yL!1\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003D\n\u0015\u0017\u0001B;uS2T!Aa2\u0002\t)\fg/Y\u0005\u0005\u0005\u0017\u0014iL\u0001\u0004GkR,(/\u001a\t\u0004\u0003\n=\u0017b\u0001Bie\tIA+[3s'R\fG/\u001a\u0005\b\u0003{K\u0003\u0019AA-\u0011\u001d\u00119.\u000ba\u0001\u00053\f1\u0002^5feN+w-\\3oiB!\u0011\u0011\u0017Bn\u0013\u0011\u0011i.a-\u0003\u001dQKWM\u001d'pON+w-\\3oi\u0006\u0011rN\u001c*fgR|'/\u001a+jKJ\u001cF/\u0019;f)\u001dI&1\u001dBs\u0005SDq!!0+\u0001\u0004\tI\u0006\u0003\u0004\u0003h*\u0002\r\u0001R\u0001\u0016aJ|\u0007o\\:fI2{7-\u00197M_\u001e\u001cF/\u0019:u\u0011\u001d\u0011YO\u000ba\u0001\u0005\u001b\f\u0011\u0002^5feN#\u0018\r^3\u0002?5\fG/\u001a:jC2L'0\u001a+jKJ\u001cF/\u0019;f+:$\u0018\u000e\\(gMN,G\u000f\u0006\u0004\u0003r\nM(Q\u001f\t\u0007\u0005w\u0013IM!7\t\u000f\u0005u6\u00061\u0001\u0002Z!1!q_\u0016A\u0002\u0011\u000bA\u0002^1sO\u0016$xJ\u001a4tKR\f\u0011%\\1uKJL\u0017\r\\5{KRKWM]*uCR,WK\u001c;jY>\u0013'.Z2u\u0013\u0012$\"B!=\u0003~\n}8\u0011AB\u0007\u0011\u001d\ti\f\fa\u0001\u00033BaAa>-\u0001\u0004!\u0005bBB\u0002Y\u0001\u00071QA\u0001\u000fi\u0006\u0014x-\u001a;PE*,7\r^%e!\u0011\u00199a!\u0003\u000e\u0005\t\u0005\u0017\u0002BB\u0006\u0005\u0003\u0014A!V+J\t\"11q\u0002\u0017A\u0002)\u000b!\u0003^1sO\u0016$(+Z:u_J,W\t]8dQ\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\rU\u0001cA\u001d\u0004\u0018%\u00191\u0011\u0004\u001e\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003qI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\r\t")
public class AbstractFetcherManagerTest {
    private final long fetchOffset;
    private final int leaderEpoch;
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 9092);

    public long fetchOffset() {
        return this.fetchOffset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_failedAttempts;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_currentLeaderEpoch;
        void apply_lag;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Mockito.when((Object)fetcher.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        int n = this.leaderEpoch();
        None$ none$2 = None$.MODULE$;
        long apply_offset = this.fetchOffset();
        none$2 = null;
        truncating$ = null;
        none$ = null;
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId, apply_offset, (Option)apply_lag, (int)apply_currentLeaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (int)apply_failedAttempts))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$1;
            private final AbstractFetcherThread fetcher2$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$1;
                }
                return this.fetcher2$1;
            }
            {
                this.fetcher1$1 = fetcher1$1;
                this.fetcher2$1 = fetcher2$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Mockito.when((Object)fetcher1.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)fetcher2.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)2, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{false}));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testMinFetchRateMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$2;
            private final AbstractFetcherThread fetcher2$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$2;
                }
                return this.fetcher2$2;
            }
            {
                this.fetcher1$2 = fetcher1$2;
                this.fetcher2$2 = fetcher2$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Meter requestRate1 = (Meter)EasyMock.mock(Meter.class);
        Meter requestRate2 = (Meter)EasyMock.mock(Meter.class);
        EasyMock.expect((Object)BoxesRunTime.boxToDouble((double)requestRate1.oneMinuteRate())).andStubReturn((Object)BoxesRunTime.boxToDouble((double)10.0));
        EasyMock.expect((Object)BoxesRunTime.boxToDouble((double)requestRate2.oneMinuteRate())).andStubReturn((Object)BoxesRunTime.boxToDouble((double)5.0));
        EasyMock.replay((Object[])new Object[]{requestRate1});
        EasyMock.replay((Object[])new Object[]{requestRate2});
        FetcherStats fetcherStats1 = (FetcherStats)EasyMock.mock(FetcherStats.class);
        FetcherStats fetcherStats2 = (FetcherStats)EasyMock.mock(FetcherStats.class);
        EasyMock.expect((Object)fetcherStats1.requestRate()).andStubReturn((Object)requestRate1);
        EasyMock.expect((Object)fetcherStats2.requestRate()).andStubReturn((Object)requestRate2);
        EasyMock.replay((Object[])new Object[]{fetcherStats1});
        EasyMock.replay((Object[])new Object[]{fetcherStats2});
        fetcher1.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).times(2);
        EasyMock.expect((Object)fetcher1.sourceBroker()).andReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher1.fetcherStats()).andStubReturn((Object)fetcherStats1);
        EasyMock.replay((Object[])new Object[]{fetcher1});
        fetcher2.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).times(2);
        EasyMock.expect((Object)fetcher2.sourceBroker()).andReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher2.fetcherStats()).andStubReturn((Object)fetcherStats2);
        EasyMock.replay((Object[])new Object[]{fetcher2});
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$1(x0$1)))).values().headOption().get()).value()));
        Assertions.assertEquals((int)0, (int)((IterableOnceOps)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$2(x0$2)))).keys().filter((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$3(k)))).size());
        fetcherManager.createSeparateFetcherMetrics();
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$4(x0$3)))).values().headOption().get()).value()));
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$5(x0$4)))).values().headOption().get()).value()));
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
        EasyMock.verify((Object[])new Object[]{fetcherStats1});
        EasyMock.verify((Object[])new Object[]{fetcherStats2});
        EasyMock.verify((Object[])new Object[]{requestRate1});
        EasyMock.verify((Object[])new Object[]{requestRate2});
    }

    @Test
    public void testTotalLagMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$3;
            private final AbstractFetcherThread fetcher2$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$3;
                }
                return this.fetcher2$3;
            }
            {
                this.fetcher1$3 = fetcher1$3;
                this.fetcher2$3 = fetcher2$3;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        IndexedSeq tps = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)i -> AbstractFetcherManagerTest.$anonfun$testTotalLagMetric$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq fetcher1Partitions = (IndexedSeq)tps.slice(0, 2);
        IndexedSeq fetcher2Partitions = (IndexedSeq)tps.slice(2, 4);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        scala.collection.immutable.Map fetcher1FetchState = ((IterableOnceOps)fetcher1Partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map fetcher2FetchState = ((IterableOnceOps)fetcher2Partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ClientIdAndBroker metricId = new ClientIdAndBroker("0", "localhost", 9092);
        FetcherLagStats fetcherLagStats1 = (FetcherLagStats)EasyMock.mock(FetcherLagStats.class);
        Function1 & Serializable valueFactory = (Function1 & Serializable)k -> new FetcherLagMetrics(new ClientIdTopicPartition(metricId.clientId(), k), (Map)Map$.MODULE$.empty());
        Pool lagStats1 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(0))).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(1))).lag_$eq(2L);
        Pool lagStats2 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(0))).lag_$eq(1L);
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(1))).lag_$eq(3L);
        FetcherLagStats fetcherLagStats2 = (FetcherLagStats)EasyMock.mock(FetcherLagStats.class);
        EasyMock.expect((Object)fetcherLagStats1.stats()).andStubReturn((Object)lagStats1);
        EasyMock.expect((Object)fetcherLagStats2.stats()).andStubReturn((Object)lagStats2);
        EasyMock.replay((Object[])new Object[]{fetcherLagStats1});
        EasyMock.replay((Object[])new Object[]{fetcherLagStats2});
        fetcher1.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher1.addPartitions((Map)fetcher1FetchState)).andReturn((Object)fetcher1Partitions.toSet());
        EasyMock.expect((Object)fetcher1.fetcherLagStats()).andStubReturn((Object)fetcherLagStats1);
        EasyMock.replay((Object[])new Object[]{fetcher1});
        fetcher2.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher2.addPartitions((Map)fetcher2FetchState)).andReturn((Object)fetcher2Partitions.toSet());
        EasyMock.expect((Object)fetcher2.fetcherLagStats()).andStubReturn((Object)fetcherLagStats2);
        EasyMock.replay((Object[])new Object[]{fetcher2});
        fetcherManager.addFetcherForPartitions((Map)fetcher1FetchState, (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)2L), (Object)this.getMetricValue("TotalLag"));
        fetcherManager.addFetcherForPartitions((Map)fetcher2FetchState, (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)6L), (Object)this.getMetricValue("TotalLag"));
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
    }

    @Test
    public void testMigrateInSyncPartitions() {
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$4;
            private final AbstractFetcherThread fetcher2$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$4;
                }
                return this.fetcher2$4;
            }
            {
                this.fetcher1$4 = fetcher1$4;
                this.fetcher2$4 = fetcher2$4;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$1.scheduler()), (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp_0 = new TopicPartition("topic", 0);
        TopicPartition tp_1 = new TopicPartition("topic", 1);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState_0 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        InitialFetchState initialFetchState_1 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        PartitionFetchState partitionFetchState_0 = new PartitionFetchState((Option)topicId, this.fetchOffset(), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), this.leaderEpoch(), (Option)None$.MODULE$, (ReplicaState)EasyMock.mock(ReplicaState.class), (Option)None$.MODULE$, 0);
        Function1 & Serializable valueFactory = arg_0 -> AbstractFetcherManagerTest.$anonfun$testMigrateInSyncPartitions$1(new ClientIdAndBroker("0", "localhost", 9092), arg_0);
        Pool lagStats = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_0)).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_1)).lag_$eq(1L);
        FetcherLagStats fetcherLagStats = (FetcherLagStats)EasyMock.mock(FetcherLagStats.class);
        EasyMock.expect((Object)fetcherLagStats.stats()).andStubReturn((Object)lagStats);
        EasyMock.replay((Object[])new Object[]{fetcherLagStats});
        fetcher1.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher1.sourceBroker()).andStubReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})))).andReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})))).andReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_1})));
        EasyMock.expect((Object)fetcher1.fetcherLagStats()).andStubReturn((Object)fetcherLagStats);
        EasyMock.expect((Object)fetcher1.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})))).andReturn(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)partitionFetchState_0)})));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fetcher1.partitionCount())).andReturn((Object)BoxesRunTime.boxToInteger((int)1));
        EasyMock.replay((Object[])new Object[]{fetcher1});
        fetcher2.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher2.sourceBroker()).andStubReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_1)})))).andReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        EasyMock.expect((Object)fetcher2.fetcherLagStats()).andStubReturn((Object)fetcherLagStats);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fetcher2.partitionCount())).andReturn((Object)BoxesRunTime.boxToInteger((int)1));
        EasyMock.replay((Object[])new Object[]{fetcher2});
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)1, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertTrue((boolean)fetcherManager.fetcherThreadMap().contains((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        time.sleep(1001L);
        Assertions.assertEquals((int)2, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertEquals((Object)fetcher1, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        Assertions.assertEquals((Object)fetcher2, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.InSync$.MODULE$)));
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
        EasyMock.verify((Object[])new Object[]{fetcherLagStats});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateTopicIds() {
        void apply_failedAttempts;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_failedAttempts2;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag;
        void apply_failedAttempts3;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_failedAttempts4;
        void apply_lastFetchedEpoch4;
        void apply_state4;
        void apply_lag2;
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$2.scheduler()), (Map)Map$.MODULE$.empty());
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$2 = None$.MODULE$;
        None$ apply_topicId = None$.MODULE$;
        Object var17_17 = null;
        none$2 = null;
        truncating$ = null;
        none$ = null;
        boolean bl2 = false;
        None$ none$3 = None$.MODULE$;
        Truncating$ truncating$2 = Truncating$.MODULE$;
        None$ apply_lag3 = None$.MODULE$;
        Object var22_21 = null;
        truncating$2 = null;
        none$3 = null;
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId, fetchOffset, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state4, (Option)apply_lastFetchedEpoch4, (int)apply_failedAttempts4))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId1, fetchOffset, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3, (int)apply_failedAttempts3)));
        boolean bl3 = false;
        None$ none$4 = None$.MODULE$;
        Truncating$ truncating$3 = Truncating$.MODULE$;
        None$ none$5 = None$.MODULE$;
        None$ apply_topicId2 = None$.MODULE$;
        Object var26_26 = null;
        none$5 = null;
        truncating$3 = null;
        none$4 = null;
        boolean bl4 = false;
        None$ none$6 = None$.MODULE$;
        Truncating$ truncating$4 = Truncating$.MODULE$;
        None$ apply_lag4 = None$.MODULE$;
        Object var31_30 = null;
        truncating$4 = null;
        none$6 = null;
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId2, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2, (int)apply_failedAttempts2))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId2, fetchOffset, (Option)apply_lag4, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (int)apply_failedAttempts)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds, (FetcherPool)FetcherPool.Default$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds, (FetcherPool)FetcherPool.Default$.MODULE$);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1), arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(name$1) : name$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$2._1()).getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$3(MetricName k) {
        return k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name()) || k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$3._1();
        String string = k.getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$5(Tuple2 x0$4) {
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$4._1();
        String string = k.getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
        return bl;
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTotalLagMetric$1(int i) {
        return new TopicPartition("topic", i);
    }

    public static final /* synthetic */ FetcherLagMetrics $anonfun$testMigrateInSyncPartitions$1(ClientIdAndBroker metricId$2, TopicPartition k) {
        return new FetcherLagMetrics(new ClientIdTopicPartition(metricId$2.clientId(), k), (Map)Map$.MODULE$.empty());
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public AbstractFetcherManagerTest() {
        this.fetchOffset = 10L;
        this.leaderEpoch = 15;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;
        private final boolean isTruncationOnFetchSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Map)Map$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return (Map)Map$.MODULE$.empty();
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return (Map)Map$.MODULE$.empty();
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public OffsetFromLeader fetchTierMaterializationTargetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
            throw new NotImplementedError("should not be called");
        }

        public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
            throw new NotImplementedError("should not be called");
        }

        public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
            throw new NotImplementedError("should not be called");
        }

        public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
            throw new NotImplementedError("should not be called");
        }

        public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
            throw new NotImplementedError("should not be called");
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions) {
            Map map;
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            ExponentialBackoff x$5 = new ExponentialBackoff(0L, 2, 1000L, 0.0);
            BrokerTopicStats x$6 = new BrokerTopicStats();
            boolean bl = true;
            Map map2 = map = (Map)Map$.MODULE$.empty();
            map = null;
            Map x$8 = map2;
            super("test-resize-fetcher", "mock-fetcher", sourceBroker, failedPartitions, x$5, bl, x$6, x$8);
            this.isOffsetForLeaderEpochSupported = false;
            this.isTruncationOnFetchSupported = false;
        }
    }
}

