/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.ZkIsrManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tMc\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u00022\u0001A\u0003%a\u000bC\u0004d\u0001\t\u0007I\u0011\u00013\t\r!\u0004\u0001\u0015!\u0003f\u0011%I\u0007\u00011AA\u0002\u0013\u0005!\u000eC\u0005o\u0001\u0001\u0007\t\u0019!C\u0001_\"IQ\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001b\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0011\u0019a\b\u0001)A\u0005q\"9Q\u0010\u0001b\u0001\n\u00039\bB\u0002@\u0001A\u0003%\u0001\u0010C\u0004\u0000\u0001\t\u0007I\u0011A<\t\u000f\u0005\u0005\u0001\u0001)A\u0005q\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\f\u0002!\t!!\u0002\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005\u0015\u0001bBAO\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003C\u0003A\u0011AA\u0003\u0011\u001d\t)\u000b\u0001C\u0005\u0003OCq!!/\u0001\t\u0013\tY\fC\u0004\u0002N\u0002!\t!!\u0002\t\u000f\u0005E\u0007\u0001\"\u0001\u0002\u0006!9\u0011Q\u001b\u0001\u0005\u0002\u0005\u0015\u0001bBAm\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0002\u0006!9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\u000e\u0001\u0011%!QD\u0004\b\u0005_\u0001\u0004\u0012\u0001B\u0019\r\u0019y\u0003\u0007#\u0001\u00034!1Ah\u000bC\u0001\u0005kAq!a\u0012,\t\u0003\u00119\u0004C\u0004\u0002p-\"\tA!\u0013\u0003'\u0005cG/\u001a:JgJl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005E\u0012\u0014AB:feZ,'OC\u00014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\b\u0005\u0002@\u00015\t\u0001'A\u0003u_BL7-F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003mC:<'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0003uS6,W#A'\u0011\u00059\u000bV\"A(\u000b\u0005A\u0013\u0014!B;uS2\u001c\u0018B\u0001*P\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002-B\u0011q\u000bY\u0007\u00021*\u0011A+\u0017\u0006\u00035n\u000baaY8n[>t'BA\u001a]\u0015\tif,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005D&aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005A!M]8lKJLE-F\u0001f!\t9d-\u0003\u0002hq\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ,\u0012a\u001b\t\u0003\u007f1L!!\u001c\u0019\u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0017EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR\u0011\u0001o\u001d\t\u0003oEL!A\u001d\u001d\u0003\tUs\u0017\u000e\u001e\u0005\bi.\t\t\u00111\u0001l\u0003\rAH%M\u0001\u0014EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000fI\u0001\u0004iB\u0004T#\u0001=\u0011\u0005eTX\"A-\n\u0005mL&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0005iB\u0004\u0004%A\u0002uaF\nA\u0001\u001e92A\u0005\u0019A\u000f\u001d\u001a\u0002\tQ\u0004(\u0007I\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002a\"\u001a1#!\u0003\u0011\t\u0005-\u0011\u0011D\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005\u0019\u0011\r]5\u000b\t\u0005M\u0011QC\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9BX\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00037\tiA\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011\u0002^3ti\n\u000b7/[2\u0015\u0007A\f\t\u0003C\u0004\u0002$Q\u0001\r!!\n\u0002\u0015\u0005\u0004\u0018NV3sg&|g\u000e\u0005\u0003\u0002(\u0005-RBAA\u0015\u0015\r\tyAM\u0005\u0005\u0003[\tIC\u0001\u0006Ba&4VM]:j_:Ds\u0001FA\u0019\u0003\u0003\n\u0019\u0005\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0011A\u0014xN^5eKJTA!a\u000f\u0002\u0012\u00051\u0001/\u0019:b[NLA!a\u0010\u00026\taQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011QI\u0011\u0003\u0003\u000f\n!\u0003\u001d:pm&$W-\u00119j-\u0016\u00148/[8og\"\u001aA#a\u0013\u0011\t\u00055\u0013qJ\u0007\u0003\u0003sIA!!\u0015\u0002:\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002AQ,7\u000f\u001e\"bg&\u001c7+\u001a8u\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/\u001a\u000b\u0006a\u0006]\u0013\u0011\f\u0005\b\u0003G)\u0002\u0019AA\u0013\u0011\u001d\tY&\u0006a\u0001\u0003;\n1\u0003\\3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003GZ\u0016\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\u001d\u0014\u0011\r\u0002\u0014\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/\u001a\u0015\b+\u0005E\u0012\u0011IA6Y\t\ti'\t\u0002\u0002p\u0005Q\u0002O]8wS\u0012,G*Z1eKJ\u0014VmY8wKJL8\u000b^1uK\"\u001aQ#a\u0013\u00021Q,7\u000f^(wKJ<(/\u001b;f/&$\b.\u001b8CCR\u001c\u0007\u000eF\u0002q\u0003oBq!a\t\u0017\u0001\u0004\t)\u0003K\u0004\u0017\u0003c\t\t%a\u001f-\u0005\u0005\u0015\u0003f\u0001\f\u0002L\u0005yA/Z:u'&tw\r\\3CCR\u001c\u0007\u000eF\u0002q\u0003\u0007Cq!a\t\u0018\u0001\u0004\t)\u0003K\u0004\u0018\u0003c\t\t%a\"-\u0005\u0005\u0015\u0003fA\f\u0002L\u00059B/Z:u\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8GC&dW\r\u001a\u0015\u00041\u0005=\u0005\u0003BA\u0006\u0003#KA!a%\u0002\u000e\t!A+Z:u\u0003Q!Xm\u001d;Ti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ\"\u001a\u0011$a$\u0002#Q,7\u000f^+oW:|wO\\*feZ,'\u000fK\u0002\u001b\u0003\u001f\u000b\u0001\u0005^3tiJ+GO]=P]\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001a1$a$\u0002EQ,7\u000f\u001e*fiJLxJ\\+ogV\u0004\bo\u001c:uK\u00124VM]:j_:,%O]8sQ\ra\u0012qR\u0001\u0019i\u0016\u001cHOU3uef|e\u000eV8q\u0019\u00164X\r\\#se>\u0014Hc\u00019\u0002*\"9\u00111V\u000fA\u0002\u00055\u0016!B3se>\u0014\b\u0003BAX\u0003kk!!!-\u000b\u0007\u0005M\u0016,\u0001\u0005qe>$xnY8m\u0013\u0011\t9,!-\u0003\r\u0015\u0013(o\u001c:t\u0003a!Xm\u001d;SKR\u0014\u0018p\u00148FeJ|'OU3ta>t7/\u001a\u000b\u0004a\u0006u\u0006bBA`=\u0001\u0007\u0011\u0011Y\u0001\te\u0016\u001c\bo\u001c8tKB!\u00111YAe\u001b\t\t)MC\u0002\u0002Hn\u000bqa\u00197jK:$8/\u0003\u0003\u0002L\u0006\u0015'AD\"mS\u0016tGOU3ta>t7/Z\u0001\u0019i\u0016\u001cH/\u00138wC2LG-\u00169eCR,g+\u001a:tS>t\u0007fA\u0010\u0002\u0010\u0006IB/Z:u+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8oQ\r\u0001\u0013qR\u0001\u0018i\u0016\u001cHOT8u\u0019\u0016\fG-\u001a:Pe\u001a{G\u000e\\8xKJD3!IAH\u0003I!Xm\u001d;J]Z\fG.\u001b3SKF,Xm\u001d;)\u0007\t\ny)A\ndQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8FeJ|'\u000fF\u0002q\u0003CDq!a+$\u0001\u0004\ti+\u0001\nuKN$\b+\u0019:uSRLwN\\#se>\u0014HCBAt\u0003[\f\t\u0010E\u0002@\u0003SL1!a;1\u0005=\tE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\bBBAxI\u0001\u0007\u00010\u0001\u0002ua\"9\u00111\u0016\u0013A\u0002\u00055\u0016a\u0004;fgR|e.Z%o\r2Lw\r\u001b;\u0015\u0007A\f9\u0010C\u0004\u0002$\u0015\u0002\r!!\n)\u000f\u0015\n\t$!\u0011\u0002|2\u0012\u0011Q\t\u0015\u0004K\u0005-\u0013A\b;fgR\u0004\u0016M\u001d;ji&|g.T5tg&tw-\u00138SKN\u0004xN\\:f)\r\u0001(1\u0001\u0005\b\u0003G1\u0003\u0019AA\u0013Q\u001d1\u0013\u0011GA!\u0005\u000fa#!!\u0012)\u0007\u0019\nY%A\u0006uKN$(l\u001b\"bg&\u001c\u0007fA\u0014\u0002\u0010\u0006IB/Z:u\u0007\u0006t7+\u001e2nSR4%o\\7DC2d'-Y2l)\r\u0001(1\u0003\u0005\b\u0003GA\u0003\u0019AA\u0013Q\u001dA\u0013\u0011GA!\u0005/a#!!\u0012)\u0007!\nY%A\tqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$bAa\b\u0003,\t5\u0002\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\u0007\t\u0015\u0012,\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011ICa\t\u0003-\u0005cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016Da!a<*\u0001\u0004A\bbBAVS\u0001\u0007\u0011QV\u0001\u0014\u00032$XM]%te6\u000bg.Y4feR+7\u000f\u001e\t\u0003\u007f-\u001a\"a\u000b\u001c\u0015\u0005\tEBC\u0001B\u001d!\u0019\u0011YD!\u0012\u0002&5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0004\u0005\u00072\u0015\u0001B;uS2LAAa\u0012\u0003>\t11\u000b\u001e:fC6$\"Aa\u0013\u0011\r\tm\"Q\tB'!\u0011\t\u0019Da\u0014\n\t\tE\u0013Q\u0007\u0002\n\u0003J<W/\\3oiN\u0004")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterIsrManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<ApiVersion> provideApiVersions() {
        return AlterIsrManagerTest$.MODULE$.provideApiVersions();
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testBasic(ApiVersion apiVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(ApiVersion apiVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        LeaderRecoveryState expectedLeaderRecoveryState = apiVersion.$greater$eq((Object)KAFKA_3_2_IV0$.MODULE$) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED;
        AlterPartitionRequestData.PartitionData partitionReq = (AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0);
        Assertions.assertEquals((byte)expectedLeaderRecoveryState.value(), (byte)partitionReq.leaderRecoveryState());
        LeaderRecoveryState leaderRecoveryState2 = leaderRecoveryState;
        LeaderRecoveryState leaderRecoveryState3 = LeaderRecoveryState.RECOVERING;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(leaderRecoveryState2 != null ? !leaderRecoveryState2.equals(leaderRecoveryState3) : leaderRecoveryState3 != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)partitionReq.isUnclean()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOverwriteWithinBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        CompletableFuture failedSubmitFuture = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testSingleBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(new TopicPartition(this.topic(), 0), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterIsrManager.submit(new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)i)), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), leaderAndIsr, 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterPartitionResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
    }

    private AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        CompletableFuture future = alterIsrManager.submit(tp, new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterIsrManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOneInFlight(ApiVersion apiVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testPartitionMissingInResponse(ApiVersion apiVersion) {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, apiVersion);
        alterIsrManager.start();
        CompletableFuture future1 = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0()})));
        CompletableFuture future2 = alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        CompletableFuture future3 = alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        callback1.onComplete(this.clientResponse$1(this.tp0(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()}))).onComplete(this.clientResponse$1(this.tp2(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()}))).onComplete(this.clientResponse$1(this.tp1(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2, (Option)None$.MODULE$), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testCanSubmitFromCallback(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        CompletableFuture future = this.submitAndVerify$1((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), alterIsrManager);
        future.whenComplete((x$4, x$5) -> this.submitAndVerify$1((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), alterIsrManager));
        AlterPartitionResponse alterIsrResp = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    private AlterPartitionResponse partitionResponse(TopicPartition tp, Errors error) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(error.code()))))));
    }

    private static final AbstractRequest.Builder matchesAlterIsr$1(Set topicPartitions) {
        return (AbstractRequest.Builder)ArgumentMatchers.argThat(request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Set requestTopicPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> {
                String topic = topicData.name();
                return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new TopicPartition(topic, partitionData.partitionIndex()));
            })).toSet();
            Set set = topicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        });
    }

    private final ControllerRequestCompletionHandler verifySendAlterIsr$1(Set topicPartitions) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest(AlterIsrManagerTest.matchesAlterIsr$1(topicPartitions), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private final ClientResponse clientResponse$1(TopicPartition topicPartition, Errors error) {
        AlterPartitionResponse alterIsrResponse = this.partitionResponse(topicPartition, error);
        return new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResponse);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture submitAndVerify$1(List isr, DefaultAlterIsrManager alterIsrManager$2) {
        void var3_3;
        CompletableFuture future = alterIsrManager$2.submit(this.tp0(), new LeaderAndIsr(1, 1, isr, LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertFalse((boolean)future.isDone());
        return var3_3;
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

