/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.server.BaseRequestTest;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002\u0013&\u0001)BQa\f\u0001\u0005\u0002AB\u0011B\r\u0001A\u0002\u0003\u0005\u000b\u0015B\u001a\t\u000b}\u0002A\u0011\t!\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\"1\u0011\u000b\u0001Q\u0001\n%CQA\u0015\u0001\u0005BMCQ!\u0018\u0001\u0005\u0002yCQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\u0002\u0015DQ\u0001\u001c\u0001\u0005\u0002\u0015DQA\u001c\u0001\u0005\u0002\u0015DQ\u0001\u001d\u0001\u0005\u0002\u0015DQA\u001d\u0001\u0005\u0002\u0015DQ\u0001\u001e\u0001\u0005\u0002\u0015DQA\u001e\u0001\u0005\u0002\u0015DQ\u0001\u001f\u0001\u0005\u0002\u0015DQA\u001f\u0001\u0005\u0002\u0015DQ\u0001 \u0001\u0005\u0002\u0015DQA \u0001\u0005\n}Dq!!\u000e\u0001\t\u0013\t9\u0004C\u0005\u0002L\u0001\t\n\u0011\"\u0003\u0002N!I\u00111\r\u0001\u0012\u0002\u0013%\u0011Q\n\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"I\u00111\u001d\u0001\u0012\u0002\u0013%\u0011Q\u001d\u0005\n\u0003S\u0004\u0011\u0013!C\u0005\u0003WDq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\te\u0001\u0001\"\u0003\u0003\u001c!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0013\u0001\u0011%!q\u0005\u0005\b\u0005W\u0001A\u0011\u0002B\u0017\u0005]\tE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002'O\u000511/\u001a:wKJT\u0011\u0001K\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0006\u0005\u0002-[5\tQ%\u0003\u0002/K\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011A\u0006A\u0001\n?R,7\u000f^%oM>\u0004\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\u0007\u0005\u0004\u0018N\u0003\u00029s\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001e<\u0003\u0015QWO\\5u\u0015\u0005a\u0014aA8sO&\u0011a(\u000e\u0002\t)\u0016\u001cH/\u00138g_\u0006Y!M]8lKJ\u001cu.\u001e8u+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%aA%oi\u0006AA.\u001b8l\u001d\u0006lW-F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013aa\u0015;sS:<\u0017!\u00037j].t\u0015-\\3!\u0003\u0015\u0019X\r^+q)\t!v\u000b\u0005\u0002C+&\u0011ak\u0011\u0002\u0005+:LG\u000fC\u0003Y\r\u0001\u00071'\u0001\u0005uKN$\u0018J\u001c4pQ\t1!\f\u0005\u000257&\u0011A,\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0005Q{\u0006\"\u0002-\b\u0001\u0004\u0019\u0004FA\u0004b!\t!$-\u0003\u0002dk\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0016i\u0016\u001cH/\u00117uKJl\u0015N\u001d:peN,U\u000e\u001d;z)\u0005!\u0006F\u0001\u0005h!\t!\u0004.\u0003\u0002jk\t!A+Z:u\u0003U!Xm\u001d;BYR,'/T5se>\u00148OQ1e\u001fBD#!C4\u0002'Q,7\u000f^*u_Bl\u0015N\u001d:peR{\u0007/[2)\u0005)9\u0017a\b;fgR\u001cFo\u001c9NSJ\u0014xN\u001d+pa&\u001c\u0017J\u001c<bY&$Gk\u001c9jG\"\u00121bZ\u0001$i\u0016\u001cHo\u0015;pa6K'O]8s)>\u0004\u0018n\u0019(p]\u0016D\u0018n\u001d;f]R$v\u000e]5dQ\taq-\u0001\u000buKN$8\t\\3be6K'O]8s)>\u0004\u0018n\u0019\u0015\u0003\u001b\u001d\f\u0001\u0005^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c\u0017J\u001c<bY&$Gk\u001c9jG\"\u0012abZ\u0001%i\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2O_:,\u00070[:uK:$Hk\u001c9jG\"\u0012qbZ\u0001\u0015i\u0016\u001cH\u000fU1vg\u0016l\u0015N\u001d:peR{\u0007/[2)\u0005A9\u0017\u0001\t;fgR\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7-\u00138wC2LG\rV8qS\u000eD#!E4\u0002IQ,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5d\u001d>tW\r_5ti\u0016tG\u000fV8qS\u000eD#AE4\u0002+\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7nV5uQR9A+!\u0001\u0002\u001c\u0005E\u0002bBA\u0002'\u0001\u0007\u0011QA\u0001\fC\u0012l\u0017N\\\"mS\u0016tG\u000f\u0005\u0003\u0002\b\u0005]QBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000b\u0005$W.\u001b8\u000b\t\u0005=\u0011\u0011C\u0001\bG2LWM\u001c;t\u0015\rA\u00131\u0003\u0006\u0004\u0003+Y\u0014AB1qC\u000eDW-\u0003\u0003\u0002\u001a\u0005%!!B!e[&t\u0007BB$\u0014\u0001\u0004\ti\u0002\u0005\u0003\u0002 \u00055b\u0002BA\u0011\u0003S\u00012!a\tD\u001b\t\t)CC\u0002\u0002(%\na\u0001\u0010:p_Rt\u0014bAA\u0016\u0007\u00061\u0001K]3eK\u001aL1\u0001UA\u0018\u0015\r\tYc\u0011\u0005\b\u0003g\u0019\u0002\u0019AA\u000f\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148/A\bde\u0016\fG/\u001a+pa&\u001cw+\u001b;i)%!\u0016\u0011HA\u001e\u0003\u007f\t9\u0005C\u0004\u0002\u0004Q\u0001\r!!\u0002\t\u000f\u0005uB\u00031\u0001\u0002\u001e\u0005)Ao\u001c9jG\"Aq\t\u0006I\u0001\u0002\u0004\t\t\u0005E\u0003C\u0003\u0007\ni\"C\u0002\u0002F\r\u0013aa\u00149uS>t\u0007\"CA%)A\u0005\t\u0019AA!\u0003-i\u0017N\u001d:peR{\u0007/[2\u00023\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fRC!!\u0011\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002^\r\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\rde\u0016\fG/\u001a+pa&\u001cw+\u001b;iI\u0011,g-Y;mi\u0012\"\u0014aD:u_Bl\u0015N\u001d:peR{\u0007/[2\u0015\u000bQ\u000bI'a\u001b\t\u000f\u0005ur\u00031\u0001\u0002\u001e!9\u0011QN\fA\u0002\u0005=\u0014aC:z]\u000eD'o\u001c8ju\u0016\u00042AQA9\u0013\r\t\u0019h\u0011\u0002\b\u0005>|G.Z1o\u0003A\u0019G.Z1s\u001b&\u0014(o\u001c:U_BL7\rF\u0002U\u0003sBq!!\u0010\u0019\u0001\u0004\ti\"\u0001\tqCV\u001cX-T5se>\u0014Hk\u001c9jGR)A+a \u0002\u0002\"9\u0011QH\rA\u0002\u0005u\u0001bBAB3\u0001\u0007\u0011qN\u0001\u0007K:\f'\r\\3\u0002\u0017\u0005dG/\u001a:NSJ\u0014xN\u001d\u000b\u0007\u0003\u0013\u000by*!)\u0011\r\u0005-\u0015QSAM\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C5oi\u0016\u0014h.\u00197t\u0015\u0011\t\u0019*!\u0005\u0002\r\r|W.\\8o\u0013\u0011\t9*!$\u0003\u001f-\u000bgm[1GkR,(/Z%na2\u00042ASAN\u0013\r\tij\u0013\u0002\u0005->LG\rC\u0004\u0002>i\u0001\r!!\b\t\u000f\u0005\r&\u00041\u0001\u0002&\u0006\u0011q\u000e\u001d\t\u0005\u0003\u000f\t9+\u0003\u0003\u0002*\u0006%!!D!mi\u0016\u0014X*\u001b:s_J|\u0005/\u0001\u0007bYR,'/T5se>\u00148\u000f\u0006\u0005\u00020\u0006\u0005\u00171\\Ap!\u0019\t\t,a/\u0002\n:!\u00111WA\\\u001d\u0011\t\u0019#!.\n\u0003\u0011K1!!/D\u0003\u001d\u0001\u0018mY6bO\u0016LA!!0\u0002@\n!A*[:u\u0015\r\tIl\u0011\u0005\b\u0003\u0007\\\u0002\u0019AAc\u0003\ry\u0007o\u001d\t\u0007\u0003c\u000bY,a2\u0011\t\u0005%\u0017Q\u001b\b\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*!\u0011qZAI\u0003\u001diWm]:bO\u0016LA!a5\u0002N\u00069\u0012\t\u001c;fe6K'O]8sgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003/\fINA\bNSJ\u0014xN](qKJ\fG/[8o\u0015\u0011\t\u0019.!4\t\u0013\u0005u7\u0004%AA\u0002\u0005=\u0014\u0001\u0004<bY&$\u0017\r^3P]2L\b\u0002CAq7A\u0005\t\u0019A!\u0002\u0013QLW.Z8vi6\u001b\u0018AF1mi\u0016\u0014X*\u001b:s_J\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d(\u0006BA8\u0003#\na#\u00197uKJl\u0015N\u001d:peN$C-\u001a4bk2$HeM\u000b\u0003\u0003[T3!QA)\u0003]\u0019XM\u001c3BYR,'/T5se>\u00148OU3rk\u0016\u001cH\u000f\u0006\u0005\u0002t\u0006}(\u0011\u0001B\u0002!\u0011\t)0a?\u000e\u0005\u0005](\u0002BA}\u0003#\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003{\f9P\u0001\u000bBYR,'/T5se>\u00148OU3ta>t7/\u001a\u0005\b\u0003\u0007t\u0002\u0019AAc\u0011\u001d\tiN\ba\u0001\u0003_Ba!!9\u001f\u0001\u0004\t\u0015AF4fi\u000ecWo\u001d;fe2Kgn\u001b$peR{\u0007/[2\u0015\t\t%!q\u0003\t\u0006\u0005\u0006\r#1\u0002\t\u0005\u0005\u001b\u0011\u0019\"\u0004\u0002\u0003\u0010)\u0019!\u0011C\u0013\u0002\t1Lgn[\u0005\u0005\u0005+\u0011yAA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\t\u000f\u0005ur\u00041\u0001\u0002\u001e\u0005\u0019Bo\u001c9jG&\u001b\u0018i\u0019;jm\u0016l\u0015N\u001d:peR!\u0011q\u000eB\u000f\u0011\u001d\ti\u0004\ta\u0001\u0003;\t1\u0003^8qS\u000eL5\u000fU1vg\u0016$W*\u001b:s_J$B!a\u001c\u0003$!9\u0011QH\u0011A\u0002\u0005u\u0011a\u0007;pa&\u001c\u0017j\u001d)f]\u0012LgnZ*u_B\u0004X\rZ'jeJ|'\u000f\u0006\u0003\u0002p\t%\u0002bBA\u001fE\u0001\u0007\u0011QD\u0001\u0015i>\u0004\u0018nY%t'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:\u0015\t\u0005=$q\u0006\u0005\b\u0003{\u0019\u0003\u0019AA\u000f\u0001")
public class AlterMirrorsRequestTest
extends BaseRequestTest {
    private TestInfo _testInfo;
    private final String linkName;

    @Override
    public int brokerCount() {
        return 1;
    }

    private String linkName() {
        return this.linkName;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        super.setUp(testInfo);
    }

    @AfterEach
    public void tearDown(TestInfo testInfo) {
        super.tearDown();
        TestUtils$.MODULE$.verifyNoUnexpectedThreads(this.getClass().getName());
    }

    @Test
    public void testAlterMirrorsEmpty() {
        Assertions.assertTrue((boolean)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)package$.MODULE$.List().empty(), false, 5000).isEmpty());
    }

    @Test
    public void testAlterMirrorsBadOp() {
        AlterMirrorsRequestData.MirrorOperation badOp = new AlterMirrorsRequestData.MirrorOperation().setTopic("topic").setOperationCode((byte)127);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterMirrorsRequestData.MirrorOperation[]{badOp}))), false, 5000).head(), InvalidRequestException.class, (Option<String>)None$.MODULE$);
    }

    @Test
    public void testStopMirrorTopic() {
        Seq topics = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-no-sync"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-sync"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
        ConfluentAdmin localAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        TestInfo runWithRemoteCluster_testInfo = this._testInfo;
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new IntegrationTestHarness(){

            public int brokerCount() {
                return 1;
            }
        };
        runWithRemoteCluster_remoteCluster.setUp(runWithRemoteCluster_testInfo);
        try {
            AlterMirrorsRequestTest.$anonfun$testStopMirrorTopic$1(this, localAdmin, topics, runWithRemoteCluster_remoteCluster);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testStopMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.stopMirrorTopic("topic!", false));
    }

    @Test
    public void testStopMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.stopMirrorTopic("unknown-topic", false));
    }

    @Test
    public void testClearMirrorTopic() {
        String activeTopic = "active-topic";
        String stoppedTopic = "stopped-topic";
        try (ConfluentAdmin localAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            TestInfo runWithRemoteCluster_testInfo = this._testInfo;
            IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
            runWithRemoteCluster_remoteCluster.setUp(runWithRemoteCluster_testInfo);
            try {
                AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1(this, localAdmin, activeTopic, stoppedTopic, runWithRemoteCluster_remoteCluster);
            }
            finally {
                runWithRemoteCluster_remoteCluster.tearDown();
            }
            Object var5_4 = null;
            Object var6_5 = null;
        }
    }

    @Test
    public void testClearMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.clearMirrorTopic("topic!"));
    }

    @Test
    public void testClearMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.clearMirrorTopic("unknown-topic"));
    }

    @Test
    public void testPauseMirrorTopic() {
        String topic = "topic";
        try (ConfluentAdmin localAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            TestInfo runWithRemoteCluster_testInfo = this._testInfo;
            IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
            runWithRemoteCluster_remoteCluster.setUp(runWithRemoteCluster_testInfo);
            try {
                AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1(this, localAdmin, topic, runWithRemoteCluster_remoteCluster);
            }
            finally {
                runWithRemoteCluster_remoteCluster.tearDown();
            }
            Object var4_3 = null;
            Object var5_4 = null;
        }
    }

    @Test
    public void testPauseMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", true));
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", false));
    }

    @Test
    public void testPauseMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", false));
    }

    private void createClusterLinkWith(Admin adminClient, String linkName, String bootstrapServers) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers)}));
        NewClusterLink newClusterLink = new NewClusterLink(linkName, null, CollectionConverters$.MODULE$.MapHasAsJava((Map)configs).asJava());
        admin.createClusterLinks(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewClusterLink[]{newClusterLink}))).asJavaCollection(), (CreateClusterLinksOptions)new CreateClusterLinksOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).all().get();
    }

    private void createTopicWith(Admin adminClient, String topic, Option<String> linkName, Option<String> mirrorTopic) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)1)));
        linkName.foreach((Function1 & Serializable)ln -> newTopic.mirror(Optional.of(new NewMirrorTopic(ln, (String)mirrorTopic.get()))));
        admin.createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJavaCollection(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).all().get();
    }

    private Option<String> createTopicWith$default$3() {
        return None$.MODULE$;
    }

    private Option<String> createTopicWith$default$4() {
        return None$.MODULE$;
    }

    private void stopMirrorTopic(String topic, boolean synchronize) {
        try {
            AlterMirrorOp stopOp = synchronize ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER;
            this.alterMirror(topic, stopOp).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void clearMirrorTopic(String topic) {
        try {
            this.alterMirror(topic, AlterMirrorOp.CLEAR).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void pauseMirrorTopic(String topic, boolean enable) {
        try {
            AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE : AlterMirrorOp.RESUME;
            this.alterMirror(topic, pauseOp).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private KafkaFutureImpl<Void> alterMirror(String topic, AlterMirrorOp op) {
        AlterMirrorsRequestData.MirrorOperation mirrorOp = new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.id());
        return (KafkaFutureImpl)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterMirrorsRequestData.MirrorOperation[]{mirrorOp}))), false, 5000).head();
    }

    private List<KafkaFutureImpl<Void>> alterMirrors(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        LinkedHashMap results = new LinkedHashMap();
        ops.foreach((Function1 & Serializable)op -> results.put(op.topic(), new KafkaFutureImpl()));
        this.sendAlterMirrorsRequest(ops, validateOnly, timeoutMs).complete(results);
        Assertions.assertEquals((int)ops.size(), (int)results.size());
        return CollectionConverters$.MODULE$.CollectionHasAsScala(results.values()).asScala().toList();
    }

    private boolean alterMirrors$default$2() {
        return false;
    }

    private int alterMirrors$default$3() {
        return 5000;
    }

    private AlterMirrorsResponse sendAlterMirrorsRequest(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava(ops).asJava(), validateOnly, timeoutMs).build();
        return (AlterMirrorsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Option<ClusterLinkTopicState> getClusterLinkForTopic(String topic) {
        return this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
    }

    private boolean topicIsActiveMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsActiveMirror$1(x$2)));
    }

    private boolean topicIsPausedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsPausedMirror$1(x$3)));
    }

    private boolean topicIsPendingStoppedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsPendingStoppedMirror$1(x$4)));
    }

    private boolean topicIsStoppedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsStoppedMirror$1(x$5)));
    }

    public static final /* synthetic */ void $anonfun$testStopMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, Seq topics$1, IntegrationTestHarness remoteCluster) {
        ConfluentAdmin remoteAdmin = remoteCluster.createConfluentAdminClient(remoteCluster.createConfluentAdminClient$default$1());
        $this.createClusterLinkWith((Admin)localAdmin$1, $this.linkName(), remoteCluster.bootstrapServers(remoteCluster.bootstrapServers$default$1()));
        topics$1.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            boolean synchronize = x0$1._2$mcZ$sp();
            $this.createTopicWith((Admin)remoteAdmin, topic, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$1, topic, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic));
            $this.stopMirrorTopic(topic, synchronize);
            InvalidRequestException invalidRequestException = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> $this.stopMirrorTopic(topic, synchronize));
            return invalidRequestException;
        });
    }

    private final boolean hasClusterLink$1(String topic) {
        return this.getClusterLinkForTopic(topic).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testClearMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String activeTopic$1, String stoppedTopic$1, IntegrationTestHarness remoteCluster) {
        try (ConfluentAdmin remoteAdmin = remoteCluster.createConfluentAdminClient(remoteCluster.createConfluentAdminClient$default$1());){
            $this.createClusterLinkWith((Admin)localAdmin$2, $this.linkName(), remoteCluster.bootstrapServers(remoteCluster.bootstrapServers$default$1()));
            $this.createTopicWith((Admin)remoteAdmin, activeTopic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$2, activeTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)activeTopic$1));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(activeTopic$1));
            $this.clearMirrorTopic(activeTopic$1);
            Assertions.assertFalse((boolean)$this.hasClusterLink$1(activeTopic$1));
            $this.clearMirrorTopic(activeTopic$1);
            Assertions.assertFalse((boolean)$this.hasClusterLink$1(activeTopic$1));
            $this.createTopicWith((Admin)remoteAdmin, stoppedTopic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$2, stoppedTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)stoppedTopic$1));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(stoppedTopic$1));
            $this.stopMirrorTopic(stoppedTopic$1, false);
            Assertions.assertTrue(($this.topicIsPendingStoppedMirror(stoppedTopic$1) || $this.topicIsStoppedMirror(stoppedTopic$1) ? 1 : 0) != 0, (String)new StringBuilder(23).append("Unexpected topic state ").append($this.getClusterLinkForTopic(stoppedTopic$1)).toString());
            $this.clearMirrorTopic(stoppedTopic$1);
            Assertions.assertFalse((boolean)$this.hasClusterLink$1(stoppedTopic$1));
        }
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String topic$2, IntegrationTestHarness remoteCluster) {
        try (ConfluentAdmin remoteAdmin = remoteCluster.createConfluentAdminClient(remoteCluster.createConfluentAdminClient$default$1());){
            $this.createClusterLinkWith((Admin)localAdmin$3, $this.linkName(), remoteCluster.bootstrapServers(remoteCluster.bootstrapServers$default$1()));
            $this.createTopicWith((Admin)remoteAdmin, topic$2, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$3, topic$2, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic$2));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, true);
            Assertions.assertTrue((boolean)$this.topicIsPausedMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, true);
            Assertions.assertTrue((boolean)$this.topicIsPausedMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, false);
            Assertions.assertFalse((boolean)$this.topicIsPausedMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, false);
            Assertions.assertFalse((boolean)$this.topicIsPausedMirror(topic$2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$topicIsActiveMirror$1(ClusterLinkTopicState x$2) {
        return x$2 instanceof ClusterLinkTopicState.Mirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsPausedMirror$1(ClusterLinkTopicState x$3) {
        return x$3 instanceof ClusterLinkTopicState.PausedMirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsPendingStoppedMirror$1(ClusterLinkTopicState x$4) {
        return x$4 instanceof ClusterLinkTopicState.PendingStoppedMirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsStoppedMirror$1(ClusterLinkTopicState x$5) {
        return x$5 instanceof ClusterLinkTopicState.StoppedMirror;
    }

    public AlterMirrorsRequestTest() {
        this.linkName = "test-link";
    }

    public static final /* synthetic */ Object $anonfun$testStopMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, Seq topics$1, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testStopMirrorTopic$1($this, localAdmin$1, topics$1, remoteCluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClearMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String activeTopic$1, String stoppedTopic$1, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1($this, localAdmin$2, activeTopic$1, stoppedTopic$1, remoteCluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPauseMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String topic$2, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1($this, localAdmin$3, topic$2, remoteCluster);
        return BoxedUnit.UNIT;
    }
}

