/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.telemetry.api.events.NoOpEventEmitter;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ThrottleCallback;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.mockito.Mockito;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013E1\u0005\u0003\u00042\u0001\u0001\u0006I\u0001\n\u0005\be\u0001\u0001\r\u0011\"\u00054\u0011\u001d9\u0004\u00011A\u0005\u0012aBaA\u0010\u0001!B\u0013!\u0004bB \u0001\u0005\u0004%\t\u0002\u0011\u0005\u0007\r\u0002\u0001\u000b\u0011B!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000bQ\u0003A\u0011C+\t\u000be\u0003A\u0011\u0003.\t\u0013\u0005%\u0002!%A\u0005\u0012\u0005-\u0002\"CA#\u0001E\u0005I\u0011CA$\u0011\u001d\ty\u0005\u0001C\t\u0003#Bq!a\u001a\u0001\t#\tI\u0007C\u0004\u0002\u0004\u0002!\t\"!\"\u00035\t\u000b7/Z\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005M!\u0012AB:feZ,'OC\u0001\u0016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!#\u0001\u0003uS6,W#\u0001\u0013\u0011\u0005\u0015zS\"\u0001\u0014\u000b\u0005\u001dB\u0013!B;uS2\u001c(BA\u0015+\u0003\u0019\u0019w.\\7p]*\u0011Qc\u000b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021M\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0007ok6\u001c\u0015\r\u001c7cC\u000e\\7/F\u00015!\tIR'\u0003\u000275\t\u0019\u0011J\u001c;\u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHCA\u001d=!\tI\"(\u0003\u0002<5\t!QK\\5u\u0011\u001diT!!AA\u0002Q\n1\u0001\u001f\u00132\u00035qW/\\\"bY2\u0014\u0017mY6tA\u00059Q.\u001a;sS\u000e\u001cX#A!\u0011\u0005\t#U\"A\"\u000b\u0005}B\u0013BA#D\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\ti\u0016\f'\u000fR8x]R\t\u0011\b\u000b\u0002\n\u0015B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u0004CBL'BA(Q\u0003\u001dQW\u000f]5uKJT!!U\u0017\u0002\u000b),h.\u001b;\n\u0005Mc%!C!gi\u0016\u0014X)Y2i\u0003!\u0019\u0017\r\u001c7cC\u000e\\W#\u0001,\u0011\u0005\u0005:\u0016B\u0001-\u0013\u0005A!\u0006N]8ui2,7)\u00197mE\u0006\u001c7.\u0001\u0007ck&dGMU3rk\u0016\u001cH/\u0006\u0002\\CR1Al^A\u0001\u0003\u001f\u0001B!G/`[&\u0011aL\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0001\fG\u0002\u0001\u0003\u0006E.\u0011\ra\u0019\u0002\u0002)F\u0011Am\u001a\t\u00033\u0015L!A\u001a\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0001n[\u0007\u0002S*\u0011!\u000eK\u0001\te\u0016\fX/Z:ug&\u0011A.\u001b\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3tiB\u0011a\u000e\u001e\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003cR\tqA\\3uo>\u00148.\u0003\u0002ta\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017BA;w\u0005\u001d\u0011V-];fgRT!a\u001d9\t\u000ba\\\u0001\u0019A=\u0002\u000f\t,\u0018\u000e\u001c3feB\u0019!0`0\u000f\u0005!\\\u0018B\u0001?j\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018B\u0001@\u0000\u0005\u001d\u0011U/\u001b7eKJT!\u0001`5\t\u0013\u0005\r1\u0002%AA\u0002\u0005\u0015\u0011\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BA\u0004\u0003\u0017i!!!\u0003\u000b\u0005ED\u0013\u0002BA\u0007\u0003\u0013\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016D\u0011\"!\u0005\f!\u0003\u0005\r!a\u0005\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004B!!\u0006\u0002$9!\u0011qCA\u0010!\r\tIBG\u0007\u0003\u00037Q1!!\b\u0017\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0005\u000e\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#a\n\u0003\rM#(/\u001b8h\u0015\r\t\tCG\u0001\u0017EVLG\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011QFA\"+\t\tyC\u000b\u0003\u0002\u0006\u0005E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\"$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b\td!\u0019A2\u0002-\t,\u0018\u000e\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*B!!\u0013\u0002NU\u0011\u00111\n\u0016\u0005\u0003'\t\t\u0004B\u0003c\u001b\t\u00071-\u0001\u0007ck&dGmU3tg&|g\u000e\u0006\u0003\u0002T\u0005\r\u0004\u0003BA+\u0003?r1!a\u0016s\u001d\u0011\tI&!\u0018\u000f\t\u0005e\u00111L\u0005\u0002+%\u0011\u0011\u000fF\u0005\u0004\u0003C2(aB*fgNLwN\u001c\u0005\b\u0003Kr\u0001\u0019AA\n\u0003\u0011)8/\u001a:\u0002\u00175\f\u0017PY3SK\u000e|'\u000f\u001a\u000b\ni\u0005-\u0014QOA<\u0003sBq!!\u001c\u0010\u0001\u0004\ty'\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002\"\u0003cJ1!a\u001d\u0013\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u000f\u0005\u0015t\u00021\u0001\u0002\u0014!9\u0011\u0011C\bA\u0002\u0005M\u0001bBA>\u001f\u0001\u0007\u0011QP\u0001\u0006m\u0006dW/\u001a\t\u00043\u0005}\u0014bAAA5\t1Ai\\;cY\u0016\f\u0001\u0002\u001e5s_R$H.\u001a\u000b\fs\u0005\u001d\u0015\u0011RAF\u0003\u001b\u000b\t\nC\u0004\u0002nA\u0001\r!a\u001c\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002\u0014!9\u0011\u0011\u0003\tA\u0002\u0005M\u0001BBAH!\u0001\u0007A'\u0001\buQJ|G\u000f\u001e7f)&lW-T:\t\r\u0005M\u0005\u00031\u0001W\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6")
public class BaseClientQuotaManagerTest {
    private final MockTime time = new MockTime();
    private int numCallbacks = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    public MockTime time() {
        return this.time;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public ThrottleCallback callback() {
        return new ThrottleCallback(this){
            private final /* synthetic */ BaseClientQuotaManagerTest $outer;

            public void startThrottling() {
            }

            public void endThrottling() {
                this.$outer.numCallbacks_$eq(this.$outer.numCallbacks() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName, String clientId) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(builder.apiKey(), request.version(), clientId, 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics, (Option)None$.MODULE$, NoOpEventEmitter.INSTANCE));
    }

    public <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public <T extends AbstractRequest> String buildRequest$default$3() {
        return "";
    }

    public RequestChannel.Session buildSession(String user) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return new RequestChannel.Session(principal, null);
    }

    public int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        return quotaManager.maybeRecordAndGetThrottleTimeMs(this.buildSession(user), clientId, value, this.time().milliseconds());
    }

    /*
     * WARNING - void declaration
     */
    public void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, ThrottleCallback channelThrottlingCallback) {
        void var9_9;
        ListenerName x$3;
        FetchRequest.Builder x$1 = FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1000, new HashMap());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)x$1, x$3 = this.buildRequest$default$2(), clientId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle((RequestChannel.Request)var9_9, channelThrottlingCallback, throttleTimeMs);
    }
}

