/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.QuotaType;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r]b\u0001\u0002*T\u0001aCQ!\u0018\u0001\u0005\u0002yCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004f\u0001\u0001\u0006IA\u0019\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0011\u0019Y\u0007\u0001)A\u0005Q\")A\u000e\u0001C\u0005[\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bb\u0002B\u0004\u0001\u0011\u0005\u00111\u001e\u0005\b\u0005\u0017\u0001A\u0011AAv\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003WDqAa\u0005\u0001\t\u0003\tY\u000fC\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\tm\u0002\u0001\"\u0001\u0002l\"9!q\b\u0001\u0005\u0002\u0005-\bb\u0002B\"\u0001\u0011\u0005\u00111\u001e\u0005\b\u0005\u000f\u0002A\u0011AAv\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0003WDqAa\u0014\u0001\t\u0003\tY\u000fC\u0004\u0003T\u0001!\t!a;\t\u000f\t]\u0003\u0001\"\u0001\u0002l\"9!1\f\u0001\u0005\u0002\u0005-\bb\u0002B0\u0001\u0011\u0005\u00111\u001e\u0005\b\u0005G\u0002A\u0011AAv\u0011\u001d\u00119\u0007\u0001C\u0001\u0003WDqAa\u001b\u0001\t\u0003\tY\u000fC\u0004\u0003p\u0001!\t!a;\t\u000f\tM\u0004\u0001\"\u0001\u0002l\"9!q\u000f\u0001\u0005\u0002\u0005-\bb\u0002B>\u0001\u0011\u0005\u00111\u001e\u0005\b\u0005\u007f\u0002A\u0011AAv\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0003WDqAa\"\u0001\t\u0003\tY\u000fC\u0004\u0003\f\u0002!\t!a;\t\u000f\t=\u0005\u0001\"\u0001\u0002l\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BU\u0001\u0011\u0005\u00111\u001e\u0005\b\u0005[\u0003A\u0011AAv\u0011\u001d\u0011\t\f\u0001C\u0001\u0003WDqA!.\u0001\t\u0003\tY\u000fC\u0004\u0003:\u0002!\t!a;\t\u000f\tu\u0006\u0001\"\u0001\u0002l\"9!\u0011\u0019\u0001\u0005\u0002\u0005-\bb\u0002Bc\u0001\u0011\u0005\u00111\u001e\u0005\b\u0005\u0013\u0004A\u0011\u0001Bf\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'DqAa7\u0001\t\u0003\u0011iN\u0002\u0003z\u0001\u0011S\bBCA\u000e_\tU\r\u0011\"\u0001\u0002\u001e!Q\u0011qF\u0018\u0003\u0012\u0003\u0006I!a\b\t\u0015\u0005ErF!f\u0001\n\u0003\ti\u0002\u0003\u0006\u00024=\u0012\t\u0012)A\u0005\u0003?A!\"!\u000e0\u0005+\u0007I\u0011AA\u001c\u0011)\tyd\fB\tB\u0003%\u0011\u0011\b\u0005\u000b\u0003\u0003z#Q3A\u0005\u0002\u0005]\u0002BCA\"_\tE\t\u0015!\u0003\u0002:!1Ql\fC\u0001\u0003\u000bBq!a\u00140\t\u0003\t\t\u0006C\u0005\u0002d=\n\t\u0011\"\u0001\u0002f!I\u0011qN\u0018\u0012\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003\u000f{\u0013\u0013!C\u0001\u0003cB\u0011\"!#0#\u0003%\t!a#\t\u0013\u0005=u&%A\u0005\u0002\u0005-\u0005\"CAI_\u0005\u0005I\u0011IAJ\u0011%\t)jLA\u0001\n\u0003\t9\nC\u0005\u0002 >\n\t\u0011\"\u0001\u0002\"\"I\u0011QV\u0018\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003{{\u0013\u0011!C\u0001\u0003\u007fC\u0011\"!30\u0003\u0003%\t%a3\t\u0013\u0005=w&!A\u0005B\u0005E\u0007\"CAj_\u0005\u0005I\u0011IAk\u0011%\t9nLA\u0001\n\u0003\nInB\u0005\u0003v\u0002\t\t\u0011#\u0003\u0003x\u001aA\u0011\u0010AA\u0001\u0012\u0013\u0011I\u0010\u0003\u0004^\u0013\u0012\u00051\u0011\u0003\u0005\n\u0003'L\u0015\u0011!C#\u0003+D\u0011ba\u0005J\u0003\u0003%\ti!\u0006\t\u0013\r}\u0011*%A\u0005\u0002\u0005-\u0005\"CB\u0011\u0013F\u0005I\u0011AAF\u0011%\u0019\u0019#SA\u0001\n\u0003\u001b)\u0003C\u0005\u00044%\u000b\n\u0011\"\u0001\u0002\f\"I1QG%\u0012\u0002\u0013\u0005\u00111\u0012\u0002\u0017\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti*\u0011A+V\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013B\u0011!lW\u0007\u0002'&\u0011Al\u0015\u0002\u001b\u0005\u0006\u001cXm\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0003\"A\u0017\u0001\u0002\r\r|gNZ5h+\u0005\u0011\u0007C\u0001.d\u0013\t!7K\u0001\rDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\u0016\u0003!\u0004\"AW5\n\u0005)\u001c&aG!cgR\u0014\u0018m\u0019;Rk>$\u0018m\u00115b]:,G.T1oC\u001e,'/A\bdQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0003A!Xm\u001d;Rk>$\u0018\rU1sg&tw\rF\u0005oiV\fi.!9\u0002fB\u0011qN]\u0007\u0002a*\t\u0011/A\u0003tG\u0006d\u0017-\u0003\u0002ta\n!QK\\5u\u0011\u0015\u0001g\u00011\u0001c\u0011\u00151h\u00011\u0001x\u0003\u001d\u0019G.[3oiF\u0002\"\u0001_\u0018\u000e\u0003\u0001\u0011!\"V:fe\u000ec\u0017.\u001a8u'\u0015y3P`A\u0002!\tyG0\u0003\u0002~a\n1\u0011I\\=SK\u001a\u0004\"a\\@\n\u0007\u0005\u0005\u0001OA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0015\u0011Q\u0003\b\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiaV\u0001\u0007yI|w\u000e\u001e \n\u0003EL1!a\u0005q\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0006\u0002\u001a\ta1+\u001a:jC2L'0\u00192mK*\u0019\u00111\u00039\u0002\tU\u001cXM]\u000b\u0003\u0003?\u0001B!!\t\u0002*9!\u00111EA\u0013!\r\tI\u0001]\u0005\u0004\u0003O\u0001\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(A\fQ!^:fe\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\nG2LWM\u001c;JI\u0002\n!bY8oM&<Wk]3s+\t\tI\u0004E\u0003p\u0003w\ty\"C\u0002\u0002>A\u0014aa\u00149uS>t\u0017aC2p]\u001aLw-V:fe\u0002\nabY8oM&<7\t\\5f]RLE-A\bd_:4\u0017nZ\"mS\u0016tG/\u00133!)%9\u0018qIA%\u0003\u0017\ni\u0005C\u0004\u0002\u001ca\u0002\r!a\b\t\u000f\u0005E\u0002\b1\u0001\u0002 !I\u0011Q\u0007\u001d\u0011\u0002\u0003\u0007\u0011\u0011\b\u0005\n\u0003\u0003B\u0004\u0013!a\u0001\u0003s\tqc]1oSRL'0\u001a3D_:4\u0017nZ\"mS\u0016tG/\u00133\u0016\u0005\u0005M\u0003#B8\u0002<\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0005Y\u0006twM\u0003\u0002\u0002`\u0005!!.\u0019<b\u0013\u0011\tY#!\u0017\u0002\t\r|\u0007/\u001f\u000b\no\u0006\u001d\u0014\u0011NA6\u0003[B\u0011\"a\u0007;!\u0003\u0005\r!a\b\t\u0013\u0005E\"\b%AA\u0002\u0005}\u0001\"CA\u001buA\u0005\t\u0019AA\u001d\u0011%\t\tE\u000fI\u0001\u0002\u0004\tI$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M$\u0006BA\u0010\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003\u0003\u0018AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!$+\t\u0005e\u0012QO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011QK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00032a\\AN\u0013\r\ti\n\u001d\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\u000bI\u000bE\u0002p\u0003KK1!a*q\u0005\r\te.\u001f\u0005\n\u0003W\u000b\u0015\u0011!a\u0001\u00033\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAY!\u0019\t\u0019,!/\u0002$6\u0011\u0011Q\u0017\u0006\u0004\u0003o\u0003\u0018AC2pY2,7\r^5p]&!\u00111XA[\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005\u0017q\u0019\t\u0004_\u0006\r\u0017bAAca\n9!i\\8mK\u0006t\u0007\"CAV\u0007\u0006\u0005\t\u0019AAR\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005U\u0013Q\u001a\u0005\n\u0003W#\u0015\u0011!a\u0001\u00033\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00033\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\na!Z9vC2\u001cH\u0003BAa\u00037D\u0011\"a+H\u0003\u0003\u0005\r!a)\t\r\u0005}g\u00011\u0001x\u0003\u001d\u0019G.[3oiJBa!a9\u0007\u0001\u00049\u0018\u0001\u0004:b]\u0012|Wn\u00117jK:$\bBBAt\r\u0001\u0007q/A\neK\u001a\fW\u000f\u001c;D_:4\u0017nZ\"mS\u0016tG/\u0001\ruKN$8\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001e$\u0012A\u001c\u0015\u0004\u000f\u0005=\b\u0003BAy\u0005\u0007i!!a=\u000b\t\u0005U\u0018q_\u0001\u0004CBL'\u0002BA}\u0003w\fqA[;qSR,'O\u0003\u0003\u0002~\u0006}\u0018!\u00026v]&$(B\u0001B\u0001\u0003\ry'oZ\u0005\u0005\u0005\u000b\t\u0019P\u0001\u0003UKN$\u0018\u0001\u0006;fgR,6/\u001a:Rk>$\u0018\rU1sg&tw\rK\u0002\t\u0003_\fA\u0004^3tiV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\rK\u0002\n\u0003_\fA\u0006^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\u0007)\ty/\u0001\u001buKN$Xk]3s\u00072LWM\u001c;Rk>$\u0018\rU1sg&tw-\u00133XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006D3aCAx\u0003)\u0019\u0007.Z2l#V|G/\u0019\u000b\u000e]\nm!Q\u0005B\u0014\u0005S\u0011\u0019Da\u000e\t\u000f\tuA\u00021\u0001\u0003 \u0005a\u0011/^8uC6\u000bg.Y4feB\u0019!L!\t\n\u0007\t\r2K\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\bbBA\u000e\u0019\u0001\u0007\u0011q\u0004\u0005\b\u0003ca\u0001\u0019AA\u0010\u0011\u001d\u0011Y\u0003\u0004a\u0001\u0005[\tQ\"\u001a=qK\u000e$X\r\u001a\"pk:$\u0007cA8\u00030%\u0019!\u0011\u00079\u0003\t1{gn\u001a\u0005\b\u0005ka\u0001\u0019AAM\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011I\u0004\u0004a\u0001\u0003\u0003\fa\"\u001a=qK\u000e$H\u000b\u001b:piRdW-A\u001buKN$x)\u001a;NCb4\u0016\r\\;f\u0013:\fVo\u001c;b/&tGm\\<XSRDgj\u001c8EK\u001a\fW\u000f\u001c;Rk>$\u0018mV5oI><\bfA\u0007\u0002p\u0006\u0001C/Z:u'\u0016$\u0018I\u001c3SK6|g/\u001a#fM\u0006,H\u000e^+tKJ\fVo\u001c;bQ\rq\u0011q^\u0001\u001ai\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016,6/\u001a:Rk>$\u0018\rK\u0002\u0010\u0003_\fq\u0004^3tiN+G/\u00118e%\u0016lwN^3Vg\u0016\u00148\t\\5f]R\fVo\u001c;bQ\r\u0001\u0012q^\u0001\u001ai\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jOB\u0013XmY3eK:\u001cW\rK\u0002\u0012\u0003_\f!\u0003^3tiF+x\u000e^1WS>d\u0017\r^5p]\"\u001a!#a<\u00029Q,7\u000f^#ya&\u0014X\r\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe\"\u001a1#a<\u0002-Q,7\u000f^#ya&\u0014X-U;pi\u0006\u001cVM\\:peND3\u0001FAx\u0003a!Xm\u001d;DY&,g\u000e^%e\u001d>$8+\u00198ji&TX\r\u001a\u0015\u0004+\u0005=\u0018a\b;fgR,f.\u001b<feN\fG.\u001b;z\u001f\u001a\f5\r^5wKR+g.\u00198ug\"\u001aa#a<\u00029Q,7\u000f\u001e$sKF,XM\\2z\u001f\u001a\fU\u000f^8Uk:,\u0017+^8uC\"\u001aq#a<\u0002;Q,7\u000f^%oC\u000e$\u0018N^3UK:\fg\u000e^:SKN,G/U;pi\u0006D3\u0001GAx\u0003-\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u00032d\u0017IY8wK\u001a\u000b\u0017N\u001d'j[&$\bfA\r\u0002p\u0006\u0001D/Z:u\u0003V$x\u000eV;oK\n\u000bg\u000eZ<jIRD\u0017+^8uC\u0006\u0013wN^3B]\u0012\u0014U\r\\8x\r\u0006L'\u000fT5nSRD3AGAx\u0003-\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u00032d')\u001a7po\u001a\u000b\u0017N\u001d'j[&$\bfA\u000e\u0002p\u0006IC/Z:u\u0003V$x\u000eV;oK\n\u000bg\u000eZ<jIRD\u0017+^8uC6+H\u000e^5qY\u0016$VM\\1oiND3\u0001HAx\u0003!\"Xm\u001d;BkR|G+\u001e8f/&$\bn\u00115b]\u001eLgn\u001a\"s_.,'/U;pi\u0006d\u0015.\\5uQ\ri\u0012q^\u0001,i\u0016\u001cH/Q;u_R+h.Z,ji\"\u001c\u0005.\u00198hS:<wJ]5hS:\fGn\u00117jK:$\u0018+^8uC\"\u001aa$a<\u0002MQ,7\u000f^!vi>$VO\\3XQ\u0016t7\t\\5f]R\u001cFo\u001c9t'\u0016tG-\u001b8h\u0019>\fG\rK\u0002 \u0003_\f1\u0007^3ti\u0006+Ho\u001c+v]\u0016<\u0006.\u001a8DY&,g\u000e^+tC\u001e,G)Z2sK\u0006\u001c\u0018N\\4BMR,'\u000f\u00165s_R$H.\u001a3)\u0007\u0001\ny/A\u0011uKN$\u0018+^8uCJ+\u0007o\u001c:uS:<7)\u00197mE\u0006\u001c7.\u00128bE2,G\rK\u0002\"\u0003_\fq\u0006^3tiF+x\u000e^1SKB|'\u000f^5oO\u000e\u000bG\u000e\u001c2bG.<\u0016\u000e\u001e5BGRLg/Z\"p]N,X\u000e\u001d;j_:D3AIAx\u0003M1XM]5gs\u0012Kh.Y7jGF+x\u000e^1t)\u0015q'q\u0013BM\u0011\u001d\u0011ib\ta\u0001\u0005?AqAa'$\u0001\u0004\u0011i*\u0001\rfqB,7\r^3e#V|G/Y:G_J\u001cE.[3oiN\u0004\u0002\"!\t\u0003 \u0006}!1U\u0005\u0005\u0005C\u000biCA\u0002NCB\u00042a\u001cBS\u0013\r\u00119\u000b\u001d\u0002\u0007\t>,(\r\\3\u0002gQ,7\u000f^!vi>$VO\\5oO\u0006cGn\\2bi\u0016\u001c()\u00198eo&$G\u000f\u001b)s_B|'\u000f^5p]\u0006dGk\\)v_R\f\u0007f\u0001\u0013\u0002p\u0006IC/Z:u\u0003V$x\u000eV;oS:<WK\u001c7j[&$X\rZ)v_R\fgi\u001c:BY2\u001cE.[3oiND3!JAx\u0003)\"Xm\u001d;BkR|G+\u001e8j]\u001e,f\u000e\\5nSR,G-U;pi\u00064uN]*p[\u0016\u001cE.[3oiND3AJAx\u0003=\"Xm\u001d;BkR|G+\u001e8j]\u001e,f\u000e\\5nSR,G-U;pi\u0006<\u0016\u000e\u001e5M_^,6/Y4f\u00072LWM\u001c;tQ\r9\u0013q^\u0001)i\u0016\u001cH/Q;u_R+h.\u001b8h+:d\u0017.\\5uK\u0012\fVo\u001c;b/&$\b\u000eT8x+N\fw-\u001a\u0015\u0004Q\u0005=\u0018A\b;fgR\fU\u000f^8Uk:Lgn\u001a%b]\u0012dWm\u001d.fe>\fVo\u001c;bQ\rI\u0013q^\u0001!i\u0016\u001cH/Q;u_R+h.\u001b8h'>\u0014Ho\u001d\"z+RLG.\u001b>bi&|g\u000eK\u0002+\u0003_\f\u0011\u0006^3tiB\u0013x\u000eZ;dKJL5\u000f\u00165s_R$H.\u001a3XQ\u0016tG)[:l'B\f7-Z%t\u0019><\bfA\u0016\u0002p\u0006yQ.\u001b7mSN$v\u000eU3sG\u0016tG\u000f\u0006\u0003\u0003$\n5\u0007b\u0002BhY\u0001\u0007!1U\u0001\u0007[&dG.[:\u0002\u00155,GO]5d)\u0006<7\u000f\u0006\u0004\u0003V\n]'\u0011\u001c\t\t\u0003C\u0011y*a\b\u0002 !9\u00111D\u0017A\u0002\u0005}\u0001bBA\u0019[\u0001\u0007\u0011qD\u0001\u000b]\u0016<X*\u001a;sS\u000e\u001cXC\u0001Bp!\u0011\u0011\tO!=\u000e\u0005\t\r(\u0002\u0002Bs\u0005O\fq!\\3ue&\u001c7O\u0003\u0003\u0003j\n-\u0018AB2p[6|gNC\u0002W\u0005[TAAa<\u0002\u0000\u00061\u0011\r]1dQ\u0016LAAa=\u0003d\n9Q*\u001a;sS\u000e\u001c\u0018AC+tKJ\u001cE.[3oiB\u0011\u00010S\n\u0006\u0013\nm8q\u0001\t\u000e\u0005{\u001c\u0019!a\b\u0002 \u0005e\u0012\u0011H<\u000e\u0005\t}(bAB\u0001a\u00069!/\u001e8uS6,\u0017\u0002BB\u0003\u0005\u007f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u0019Iaa\u0004\u000e\u0005\r-!\u0002BB\u0007\u0003;\n!![8\n\t\u0005]11\u0002\u000b\u0003\u0005o\fQ!\u00199qYf$\u0012b^B\f\u00073\u0019Yb!\b\t\u000f\u0005mA\n1\u0001\u0002 !9\u0011\u0011\u0007'A\u0002\u0005}\u0001\"CA\u001b\u0019B\u0005\t\u0019AA\u001d\u0011%\t\t\u0005\u0014I\u0001\u0002\u0004\tI$A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007O\u0019y\u0003E\u0003p\u0003w\u0019I\u0003E\u0006p\u0007W\ty\"a\b\u0002:\u0005e\u0012bAB\u0017a\n1A+\u001e9mKRB\u0001b!\rP\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L);
    private final AbstractQuotaChannelManager channelManager = (AbstractQuotaChannelManager)EasyMock.createMock(AbstractQuotaChannelManager.class);

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private AbstractQuotaChannelManager channelManager() {
        return this.channelManager;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 600 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L);
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L);
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            this.time().sleep(1000L);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 6550.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        scala.collection.mutable.Set activeTenants = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            requestQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
            this.maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
        }
        finally {
            quotaManager.shutdown();
            requestQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int n = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int n2 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(n, n2, x$1, x$5, 250.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int n = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int n2 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$52 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(n, n2, x$1, x$52, 250.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            this.time().sleep(11000L);
            this.maybeRecord(quotaManager, "", "", 300.0);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client2").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaMultipleTenants() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            Assertions.assertEquals((Object)quotaManager.quota("", "Client1"), (Object)quotaManager.dynamicQuota("", "Client1"));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertTrue((boolean)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.maybeRecord(quotaManager, "", "Client1", 250.0), this.maybeRecord(quotaManager, "", "Client2", 100.0), this.maybeRecord(quotaManager, "", "Client3", 200.0), this.maybeRecord(quotaManager, "", "Client4", 50.0)}))).forall((Function1)(JFunction1.mcZI.sp & Serializable)throttleTime -> throttleTime == 0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client3"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client4"), (Object)BoxesRunTime.boxToDouble((double)125.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 250.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)0.0, (double)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 250.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C2", 400.0);
            this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 190.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)310.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testQuotaReportingCallbackEnabled() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int n2 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double d = 9.223372036854776E18;
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(n, n2, x$4, x$5, d, 30000L);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.eq((long)config.consumptionReportingIntervalMs()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)this.channelManager()));
        EasyMock.verify((Object[])new Object[]{this.channelManager()});
        quotaManager.shutdown();
    }

    @Test
    public void testQuotaReportingCallbackWithActiveConsumption() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(2, n, x$5, x$6, 1000.0, 1000L);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C1")));
        entryData.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(100.0).setThrottled(false)));
        ReportQuotaConsumptionRequestData.EntryData entryData2 = new ReportQuotaConsumptionRequestData.EntryData();
        entryData2.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C2")));
        entryData2.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(1600.0).setThrottled(true)));
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData2));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.wakeup();
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), Option$.MODULE$.apply((Object)this.channelManager()));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 100.0));
            int throttleTime = this.maybeRecord(quotaManager, "", "C2", 800 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTime > 0 ? 1 : 0) != 0);
            this.throttle(quotaManager, "", "C2", throttleTime, this.callback());
            quotaManager.quotaUsageReportingCallback();
            EasyMock.verify((Object[])new Object[]{this.channelManager()});
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    private void verifyDynamicQuotas(ClientQuotaManager quotaManager, Map<String, Object> expectedQuotasForClients) {
        expectedQuotasForClients.foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotaManagerTest.$anonfun$verifyDynamicQuotas$1(quotaManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAutoTuningAllocatesBandwidthProportionalToQuota() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 1000.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(1400.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)700.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForAllClients() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 1000.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForSomeClients() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 1000.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsageClients() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 600.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(600.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 0.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)200.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)100.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsage() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 1000.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 100.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningHandlesZeroQuota() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 500.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(0.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 0.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 600.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningSortsByUtilization() {
        Metrics metrics = this.newMetrics();
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long l = 0L;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, n, x$4, x$5, 1000.0, l);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(500.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)300.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testProducerIsThrottledWhenDiskSpaceIsLow() {
        Path tempLogDir = Files.createTempDirectory("some-dir", new FileAttribute[0]);
        long diskThreshold = Long.MAX_VALUE;
        Metrics metrics = this.newMetrics();
        int throttledBandwidth = 300;
        long x$1 = throttledBandwidth;
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((Object)tempLogDir).toString()}));
        long l = 0x500000000L;
        double d = 1.5;
        boolean bl = false;
        DiskUsageBasedThrottlingConfig qual$1 = DiskUsageBasedThrottlingConfig$.MODULE$.apply(l, x$1, (Seq)x$2, true, 1000L, d, bl);
        Seq x$10 = qual$1.copy$default$3();
        boolean x$11 = qual$1.copy$default$4();
        long x$12 = qual$1.copy$default$5();
        double x$13 = qual$1.copy$default$6();
        boolean x$14 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = qual$1.copy(diskThreshold, 300L, x$10, x$11, x$12, x$13, x$14);
        BrokerBackpressureConfig x$16 = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int n = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        double d2 = 9.223372036854776E18;
        long l2 = 0L;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(2, n, x$16, diskThrottlingConfig, d2, l2);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this, configWithBackpressure, metrics, activeTenantsManager){
            private final DiskThrottleListenerManager listenerManager;

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                None$ none$;
                None$ none$2;
                QuotaType.Produce$ x$3 = QuotaType.Produce$.MODULE$;
                MockTime x$4 = $outer.time();
                Some x$6 = new Some((Object)activeTenantsManager$1);
                None$ none$3 = none$2 = None$.MODULE$;
                none$2 = null;
                None$ x$7 = none$3;
                None$ none$4 = none$ = None$.MODULE$;
                none$ = null;
                None$ x$8 = none$4;
                super(configWithBackpressure$1, metrics$1, (QuotaType)x$3, (Time)x$4, "", (Option)x$7, (Option)x$6, (Option)x$8);
                this.listenerManager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
            }
        };
        quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(1000.0, true)));
        quotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)quotaManager);
        Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertFalse((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        this.time().sleep(Math.max(configWithBackpressure.backpressureConfig().backpressureCheckFrequencyMs(), quotaManager.getCurrentDiskThrottlingConfig().diskCheckFrequencyMs()) + 1000L);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        Assertions.assertEquals((double)throttledBandwidth, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertTrue((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((long)throttledBandwidth, (long)BoxesRunTime.unboxToLong((Object)((Option)quotaManager.lastSignalledQuotaOptRef().get()).get()));
        quotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyDynamicQuotas$1(ClientQuotaManager quotaManager$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String clientId = (String)x0$1._1();
            Assertions.assertEquals((double)x0$1._2$mcD$sp(), (double)quotaManager$3.dynamicQuota("", clientId).bound(), (double)0.1, (String)new StringBuilder(21).append("Unexpected quota for ").append(clientId).toString());
            return;
        }
        throw new MatchError(null);
    }

    private class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

