/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.common.TopicPlacement;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.AdminManager$;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}2A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002B\u0002\u0014\u0001A\u0003%1\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003:\u0001\u0011\u0005\u0001\u0006C\u0003<\u0001\u0011\u0005\u0001\u0006C\u0003>\u0001\u0011\u0005\u0001FA\rD_:4G.^3oi\u0006#W.\u001b8NC:\fw-\u001a:UKN$(B\u0001\u0006\f\u0003\u0019\u0019XM\u001d<fe*\tA\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0013\u0005i\u0001\u000f\\1dK6,g\u000e\u001e&t_:,\u0012a\u0007\t\u00039\rr!!H\u0011\u0011\u0005y\tR\"A\u0010\u000b\u0005\u0001j\u0011A\u0002\u001fs_>$h(\u0003\u0002##\u00051\u0001K]3eK\u001aL!\u0001J\u0013\u0003\rM#(/\u001b8h\u0015\t\u0011\u0013#\u0001\bqY\u0006\u001cW-\\3oi*\u001bxN\u001c\u0011\u0002;Q,7\u000f\u001e+pa&\u001c\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oiN$\u0012!\u000b\t\u0003!)J!aK\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t5\u0002\"AL\u001c\u000e\u0003=R!\u0001M\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u00023g\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001b6\u0003\u0015QWO\\5u\u0015\u00051\u0014aA8sO&\u0011\u0001h\f\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$Hk\u001c9jGBc\u0017mY3nK:$xJY:feZ,'OT8u'V\u0004\bo\u001c:uK\u0012D#!B\u0017\u0002uQ,7\u000f\u001e+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\"pi\"$v\u000e]5d!2\f7-Z7f]R\fe\u000eZ!tg&<g.\\3oiN\u0003XmY5gS\u0016$\u0007F\u0001\u0004.\u0003\u0005#Xm\u001d;U_BL7\r\u00157bG\u0016lWM\u001c;C_RDGk\u001c9jGBc\u0017mY3nK:$\u0018I\u001c3SKBd\u0017nY1uS>tg)Y2u_J\u001c\u0006/Z2jM&,G\r\u000b\u0002\b[\u0001")
public class ConfluentAdminManagerTest {
    private final String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                                 | \"version\": 1,\n                                 |  \"replicas\": [{\n                                 |      \"count\": 2,\n                                 |      \"constraints\": {\n                                 |      }\n                                 |    }\n                                 |  ],\n                                 |  \"observers\": [{\n                                 |    \"count\": 1,\n                                 |    \"constraints\": {\n                                 |    }\n                                 |  }]\n                                 |}"));

    private String placementJson() {
        return this.placementJson;
    }

    @Test
    public void testTopicPlacementConstraints() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Properties topicConfigs = new Properties();
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", "");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", " ");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", "\t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)this.placementJson())));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kafkaConfig.isObserverSupportEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        topic.setReplicationFactor((short)-1);
        Option topicPlacementOpt = AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic);
        Assertions.assertEquals((Object)topicPlacement.map((Function1 & Serializable)x$1 -> x$1.toJson()), (Object)topicPlacementOpt.map((Function1 & Serializable)x$2 -> x$2.toJson()));
    }

    @Test
    public void testTopicPlacementObserverNotSupported() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
    }

    @Test
    public void testTopicPlacementBothTopicPlacementAndAssignmentSpecified() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kafkaConfig.isObserverSupportEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        CreateTopicsRequestData.CreatableReplicaAssignment assignment = new CreateTopicsRequestData.CreatableReplicaAssignment();
        CreateTopicsRequestData.CreatableReplicaAssignmentCollection assignments = new CreateTopicsRequestData.CreatableReplicaAssignmentCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreateTopicsRequestData.CreatableReplicaAssignment[]{assignment}))).asJava().iterator());
        topic.setAssignments(assignments);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        InvalidRequestException caught = (InvalidRequestException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ConfluentAdminManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        String expectedErrMsg = "Both assignments and confluent.placement.constraints are set. Both cannot be used at the same time.";
        Assertions.assertEquals((Object)caught.getMessage(), (Object)expectedErrMsg);
    }

    @Test
    public void testTopicPlacementBothTopicPlacementAndReplicationFactorSpecified() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kafkaConfig.isObserverSupportEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        topic.setReplicationFactor((short)3);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        InvalidRequestException caught = (InvalidRequestException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ConfluentAdminManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        String expectedErrMsg = "Both replicationFactor and confluent.placement.constraints are set. Both cannot be used at the same time.";
        Assertions.assertEquals((Object)caught.getMessage(), (Object)expectedErrMsg);
    }
}

