/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.cluster.PartitionListener;
import kafka.log.LogOffsetSnapshot;
import kafka.log.MergedLog$;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchTxnCommitted$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierFetchDataInfo;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.ReclaimableMemoryRecords;
import kafka.tier.fetcher.TierFetchResult;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001\u000f\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0019!\u0005\u0001)A\u0005}!9Q\t\u0001b\u0001\n\u00131\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rA\u0003\u0001\u0015!\u0003N\u0011%\t\u0006\u00011AA\u0002\u0013%!\u000bC\u0005W\u0001\u0001\u0007\t\u0019!C\u0005/\"IQ\f\u0001a\u0001\u0002\u0003\u0006Ka\u0015\u0005\u0006=\u0002!\ta\u0018\u0005\u0006[\u0002!\ta\u0018\u0005\u0006e\u0002!\ta\u0018\u0005\u0006o\u0002!\ta\u0018\u0005\u0006s\u0002!\ta\u0018\u0005\u0006w\u0002!\ta\u0018\u0005\u0006{\u0002!\ta\u0018\u0005\u0006\u007f\u0002!\ta\u0018\u0005\u0007\u0003\u0007\u0001A\u0011A0\t\r\u0005\u001d\u0001\u0001\"\u0001`\u0011\u0019\tY\u0001\u0001C\u0001?\"1\u0011q\u0002\u0001\u0005\u0002}Ca!a\u0005\u0001\t\u0003y\u0006BBA\f\u0001\u0011\u0005q\fC\u0004\u0002\u001c\u0001!I!!\b\t\u0013\u0005]\u0004!%A\u0005\n\u0005e\u0004bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003C\u0003A\u0011BAR\u0011%\t9\rAI\u0001\n\u0013\tI\rC\u0004\u0002N\u0002!I!a4\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"I!q\u0005\u0001\u0012\u0002\u0013%!\u0011\u0006\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\u0012\u0001\u0003R3mCf,GMR3uG\"$Vm\u001d;\u000b\u0005\u001dB\u0013AB:feZ,'OC\u0001*\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0007\u0005\u00026\u00015\ta%\u0001\u0005nCb\u0014\u0015\u0010^3t+\u0005A\u0004CA\u0017:\u0013\tQdFA\u0002J]R\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u00115|7m\u001b+j[\u0016,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\"\nQ!\u001e;jYNL!a\u0011!\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tq\t\u0005\u00026\u0011&\u0011\u0011J\n\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0004:fa2L7-Y)v_R\fW#A'\u0011\u0005Ur\u0015BA('\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u00035\u0011X\r\u001d7jG\u0006\fVo\u001c;bA\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002'B\u0011Q\u0007V\u0005\u0003+\u001a\u0012\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002)\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001cx\fJ3r)\tA6\f\u0005\u0002.3&\u0011!L\f\u0002\u0005+:LG\u000fC\u0004]\u0017\u0005\u0005\t\u0019A*\u0002\u0007a$\u0013'A\tce>\\WM\u001d+pa&\u001c7\u000b^1ug\u0002\nQa]3u+B$\u0012\u0001\u0017\u0015\u0003\u001b\u0005\u0004\"AY6\u000e\u0003\rT!\u0001Z3\u0002\u0007\u0005\u0004\u0018N\u0003\u0002gO\u00069!.\u001e9ji\u0016\u0014(B\u00015j\u0003\u0015QWO\\5u\u0015\u0005Q\u0017aA8sO&\u0011An\u0019\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u00059y\u0007C\u00012q\u0013\t\t8MA\u0005BMR,'/R1dQ\u0006\u0011B/Z:u\u001b&DX\r\u001a+jKJ4U\r^2iQ\tyA\u000f\u0005\u0002ck&\u0011ao\u0019\u0002\u0005)\u0016\u001cH/\u0001\ruKN$H+[3s\r\u0016$8\r[3s\u000bb\u001cW\r\u001d;j_:D#\u0001\u0005;\u00021Q,7\u000f\u001e$fi\u000eDw+\u001b;i\r\u0016t7-\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u0012i\u00069B/Z:u\u001d>$H*Z1eKJ|%OR8mY><XM\u001d\u0015\u0003%Q\f!\u0007^3ti\u001a{G\u000e\\8xKJ4U\r^2i)&lW\rT1h\u001d>$(+Z2pe\u0012,G-Q:D_:\u001cX/\\3s\r\u0016$8\r\u001b\u0015\u0003'Q\fA\u0004^3ti\u000e{gn];nKJ$\u0016.\u001a:GKR\u001c\u0007\u000eV5nK2\u000bw\r\u000b\u0002\u0015i\u0006\u0001D/Z:u\u0019>\u001c\u0017\r\\*fO6,g\u000e\u001e#fY\u0016$X\rZ!gi\u0016\u0014H)\u001a7bs\u0016$g)\u001a;dQ\u000e\u0013X-\u0019;j_:D#!\u0006;\u0002%Q,7\u000f\u001e#jm\u0016\u0014x-\u001b8h\u000bB|7\r\u001b\u0015\u0003-Q\fA\u0004^3ti\u0012+G.Y=fI2\u001bxNQ1tK\u0012$\u0016.\u001a:fI2{w\r\u000b\u0002\u0018i\u0006iB/Z:u\u0013:\u001c'/Z7f]R\fGNR3uG\"\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0019i\u0006\u0001D/Z:u\u0013:\u001c'/Z7f]R\fGNR3uG\"\u0004\u0016M\u001d;ji&|gn\u00165f]B\u0013XO\\5oO\u0012K7/\u00192mK\u0012D#!\u0007;\u0002EQ,7\u000f^'jq\u0016$g)\u001a;dQ\u0012{Wm\u001d(pi\u000e{W\u000e\u001d7fi\u0016,\u0015M\u001d7zQ\tQB/\u0001\u0011ck&dG-T;mi&\u0004\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\fGCCA\u0010\u0003K\tI#a\u0016\u0002nA\u0019Q'!\t\n\u0007\u0005\rbEA\u0007GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0005\u0007\u0003OY\u0002\u0019\u0001\u001d\u0002\u0013I,\u0007\u000f\\5dC&#\u0007bBA\u00167\u0001\u0007\u0011QF\u0001\u000bM\u0016$8\r[%oM>\u001c\bCBA\u0018\u0003k\tI$\u0004\u0002\u00022)\u0019\u00111\u0007\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u0005E\"aA*fcB9Q&a\u000f\u0002@\u0005E\u0013bAA\u001f]\t1A+\u001e9mKJ\u0002B!!\u0011\u0002N5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0004d_6lwN\u001c\u0006\u0004S\u0005%#bAA&S\u00061\u0011\r]1dQ\u0016LA!a\u0014\u0002D\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0004k\u0005M\u0013bAA+M\t1\u0002+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\rC\u0004\u0002Zm\u0001\r!a\u0017\u0002-\u0019,Go\u00195PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1NCB\u0004\u0002\"!\u0018\u0002d\u0005}\u0012qM\u0007\u0003\u0003?RA!!\u0019\u00022\u00059Q.\u001e;bE2,\u0017\u0002BA3\u0003?\u00121!T1q!\r)\u0014\u0011N\u0005\u0004\u0003W2#!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I\u0011qN\u000e\u0011\u0002\u0003\u0007\u0011\u0011O\u0001\u000fSN4%o\\7G_2dwn^3s!\ri\u00131O\u0005\u0004\u0003kr#a\u0002\"p_2,\u0017M\\\u0001+EVLG\u000eZ'vYRL\u0007+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tYH\u000b\u0003\u0002r\u0005u4FAA@!\u0011\t\t)a#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%e&\u0001\u0006b]:|G/\u0019;j_:LA!!$\u0002\u0004\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\t,\u0018\u000e\u001c3GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u000b\u0003?\t\u0019*!&\u0002\u001a\u0006u\u0005BBA\u0014;\u0001\u0007\u0001\bC\u0004\u0002\u0018v\u0001\r!a\u0010\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBAN;\u0001\u0007\u0011\u0011K\u0001\nM\u0016$8\r[%oM>Dq!a(\u001e\u0001\u0004\t9'A\ngKR\u001c\u0007n\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-A\u000bfqB,7\r\u001e*fC\u00124%o\\7SKBd\u0017nY1\u0015\u0017a\u000b)+a*\u0002*\u00065\u0016Q\u0018\u0005\u0007\u0003Oq\u0002\u0019\u0001\u001d\t\u000f\u0005]e\u00041\u0001\u0002@!9\u00111\u0016\u0010A\u0002\u0005E\u0013A\u00054fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006Dq!a,\u001f\u0001\u0004\t\t,A\u0003feJ|'\u000f\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,a\u0011\u0002\u0011A\u0014x\u000e^8d_2LA!a/\u00026\n1QI\u001d:peND\u0011\"a0\u001f!\u0003\u0005\r!!1\u0002\u0013%\u001cx\u000e\\1uS>t\u0007cA\u001b\u0002D&\u0019\u0011Q\u0019\u0014\u0003\u001d\u0019+Go\u00195Jg>d\u0017\r^5p]\u0006yR\r\u001f9fGR\u0014V-\u00193Ge>l'+\u001a9mS\u000e\fG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005-'\u0006BAa\u0003{\nqBY;jY\u0012\u0014V-\u00193SKN,H\u000e\u001e\u000b\u0005\u0003#\f9\u000eE\u00026\u0003'L1!!6'\u00055aun\u001a*fC\u0012\u0014Vm];mi\"9\u0011q\u0016\u0011A\u0002\u0005E\u0016!G3ya\u0016\u001cGoR3u)&,'OR3uG\"\u0014Vm];miN$r\u0001WAo\u0003c\u0014i\u0002C\u0004\u0002`\u0006\u0002\r!!9\u0002\u0019A,g\u000eZ5oO\u001a+Go\u00195\u0011\t\u0005\r\u0018Q^\u0007\u0003\u0003KTA!a:\u0002j\u00069a-\u001a;dQ\u0016\u0014(bAAvQ\u0005!A/[3s\u0013\u0011\ty/!:\u0003\u0019A+g\u000eZ5oO\u001a+Go\u00195\t\u000f\u0005M\u0018\u00051\u0001\u0002v\u00069Bo\u001c9jGB\u000b'\u000f^5uS>tW\t_2faRLwN\u001c\t\u0007\u0003_\t)$a>\u0011\u000f5\nY$!?\u0002\u0000B!\u0011\u0011IA~\u0013\u0011\ti0a\u0011\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B)QF!\u0001\u0003\u0006%\u0019!1\u0001\u0018\u0003\r=\u0003H/[8o!\u0011\u00119Aa\u0006\u000f\t\t%!1\u0003\b\u0005\u0005\u0017\u0011\t\"\u0004\u0002\u0003\u000e)\u0019!q\u0002\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013b\u0001B\u000b]\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\r\u00057\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\tUa\u0006C\u0005\u0003 \u0005\u0002\n\u00111\u0001\u0003\"\u00059!/Z2pe\u0012\u001c\b\u0003BAr\u0005GIAA!\n\u0002f\nA\"+Z2mC&l\u0017M\u00197f\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0002G\u0015D\b/Z2u\u000f\u0016$H+[3s\r\u0016$8\r\u001b*fgVdGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0006\u0016\u0005\u0005C\ti(\u0001\ffqB,7\r\u001e*fC\u00124%o\\7M_\u000e\fG\u000eT8h)\u001dA&\u0011\u0007B\u001a\u0005\u000bBQ!R\u0012A\u0002\u001dCqA!\u000e$\u0001\u0004\u00119$\u0001\bgKR\u001c\u0007\u000eR1uC&sgm\\:\u0011\r\u0005=\u0012Q\u0007B\u001d!%i#1HA \u0005\u007f\ty0C\u0002\u0003>9\u0012a\u0001V;qY\u0016\u001c\u0004cA\u001b\u0003B%\u0019!1\t\u0014\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2i\t\u0006$\u0018-\u00138g_\"9!qI\u0012A\u0002\t%\u0013!\u00045jO\"<\u0016\r^3s[\u0006\u00148\u000eE\u0002.\u0005\u0017J1A!\u0014/\u0005\u0011auN\\4\u0002%\t,\u0018\u000e\u001c3QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\u0007\u0003#\u0012\u0019F!\u0018\t\u000f\tUC\u00051\u0001\u0003X\u00059Ao\u001c9jG&#\u0007\u0003BA!\u00053JAAa\u0017\u0002D\t!Q+^5e\u0011\u001d\u0011y\u0006\na\u0001\u0005\u0013\n1BZ3uG\"|eMZ:fi\u0002")
public class DelayedFetchTest {
    private final int maxBytes;
    private final MockTime mockTime = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
    private BrokerTopicStats brokerTopicStats;

    private int maxBytes() {
        return this.maxBytes;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private void brokerTopicStats_$eq(BrokerTopicStats x$1) {
        this.brokerTopicStats = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.brokerTopicStats_$eq(new BrokerTopicStats());
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerTopicStats() != null) {
            this.brokerTopicStats().close();
        }
    }

    @Test
    public void testMixedTierFetch() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicIdPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition())), new Tuple2((Object)topicIdPartition1, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())}))), true);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), ReclaimableMemoryRecords.EMPTY);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testMixedTierFetch$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
    }

    @Test
    public void testTierFetcherException() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        TopicIdPartition topicIdPartition2 = new TopicIdPartition(topicId, 2, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition2, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)Nil$.MODULE$))), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicIdPartition0, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()), new Tuple2((Object)topicIdPartition1, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()), new Tuple2((Object)topicIdPartition2, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())}))), true);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0.topicPartition(), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)new Some((Object)new UnknownServerException())), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition2.topicPartition(), (Object)new Some((Object)new UnknownServerException())), (List)Nil$.MODULE$))), ReclaimableMemoryRecords.EMPTY);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition2, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)Nil$.MODULE$))), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((IterableOnceOps)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertTrue((results.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 fetch results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition0)).error(), (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition0 to return a FencedLeaderException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition1)).error(), (Object)Errors.UNKNOWN_SERVER_ERROR, (String)"Expected topicPartition1 to return a UnknownServerErrorException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition2)).error(), (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition2 to return a FencedLeaderException as it takes precedence over TierFetcher exceptions");
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty());
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenThrow(new Throwable[]{new FencedLeaderEpochException("Requested epoch has been fenced")});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.FENCED_LEADER_EPOCH, (FetchIsolation)FetchLogEnd$.MODULE$);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty());
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicIdPartition).append(" not available").toString())});
        this.expectReadFromReplica(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NOT_LEADER_OR_FOLLOWER, (FetchIsolation)FetchLogEnd$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testFollowerFetchTimeLagNotRecordedAsConsumerFetch() {
        CompressionType compressionType;
        boolean isFromFollower = true;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)Nil$.MODULE$), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicIdPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()))}))), isFromFollower);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)records, false, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$), highWatermark);
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)results.size(), (String)"Expected tiered fetch result");
        Assertions.assertEquals((int)0, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Follower fetch is not recorded, snapshot size is 0");
    }

    @Test
    public void testConsumerTierFetchTimeLag() {
        CompressionType compressionType;
        boolean isFromFollower = false;
        int fetchDelta = 3;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicIdPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition())), new Tuple2((Object)topicIdPartition1, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())}))), isFromFollower);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        ReclaimableMemoryRecords records = new ReclaimableMemoryRecords(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by).buffer(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        this.mockTime().sleep(fetchDelta);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), records);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)records, false, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Expected tiered and local fetch result");
        Assertions.assertEquals((int)2, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Expected size of recorded consumer fetch lag snapshot");
        double firstLagTimeMs = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)firstLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
        double lastLagTimeMs = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)lastLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
    }

    @Test
    public void testLocalSegmentDeletedAfterDelayedFetchCreation() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1, (Object)this.buildPartitionData(topicId, fetchOffset)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicIdPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition())), new Tuple2((Object)topicIdPartition1, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()))}))), true);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), ReclaimableMemoryRecords.EMPTY);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((IterableOnceOps)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition0)).records(), (Object)ReclaimableMemoryRecords.EMPTY);
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition1)).records(), (Object)ReclaimableMemoryRecords.EMPTY);
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch);
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE, (FetchIsolation)FetchLogEnd$.MODULE$);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testDelayedLsoBasedTieredLog() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> leaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicId, fetchOffset, logStartOffset, this.maxBytes(), leaderEpoch, leaderEpoch);
        FetchMetadata fetchMetadata = new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchTxnCommitted$.MODULE$, false, replicaId, true, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), 0))})));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$4(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()), (Object[])new Option[]{new Some((Object)topicIdPartition.topicId()), null});
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata updatedOffsetMetadata = new LogOffsetMetadata(505L, 500L, 500);
        new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), 0);
        Mockito.when((Object)partition.fetchOffsetSnapshot(leaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, updatedOffsetMetadata, updatedOffsetMetadata, updatedOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(leaderEpoch, Predef$.MODULE$.Integer2int(leaderEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(leaderEpoch.get())).setEndOffset(fetchOffset));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), partition, replicaId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE, (FetchIsolation)FetchTxnCommitted$.MODULE$);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testIncrementalFetchPartition() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        TopicIdPartition foo1 = new TopicIdPartition(topicId, 1, "foo");
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(topicId, 0L, 0L, 100, Optional.empty(), Optional.empty());
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata fooFetch0 = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch0.maybeUpdateResponseData(initialFetchResponse, true);
        IncrementalPartitionFetchMetadata fooFetch1 = new IncrementalPartitionFetchMetadata(foo1, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch1.maybeUpdateResponseData(initialFetchResponse, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo0.topicPartition(), (PartitionListener)fooFetch0))).thenAnswer(x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartition$1(fooFetch0, foo0, x$2)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo1.topicPartition(), (PartitionListener)fooFetch1))).thenAnswer(x$3 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartition$2(fooFetch1, foo1, x$3)));
        fooFetch0.maybeRegisterAsListener(this.replicaManager());
        fooFetch1.maybeRegisterAsListener(this.replicaManager());
        Assertions.assertFalse((boolean)fooFetch0.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch0.isCaughtUp(), (String)fooFetch0.toString());
        Assertions.assertFalse((boolean)fooFetch1.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch1.isCaughtUp(), (String)fooFetch1.toString());
        FetchMetadata fetchMetadata = new FetchMetadata(1, Integer.MAX_VALUE, false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, true, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)fooFetch1), (List)Nil$.MODULE$)), (scala.collection.mutable.Map)Map$.MODULE$.empty());
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertFalse((boolean)((Option)fetchResult.elem).isDefined());
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        fooFetch1.onEndOffsetUpdated(foo1.topicPartition(), 10L);
        Assertions.assertFalse((boolean)fooFetch1.isCaughtUp(), (String)fooFetch1.toString());
        Partition fooPartition1 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)fooPartition1.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)fooPartition1.topicPartition()).thenReturn((Object)foo1.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(foo1.topicPartition())).thenReturn((Object)fooPartition1);
        Mockito.when((Object)fooPartition1.convertToLocalOffsetMetadata(0L)).thenReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        Mockito.when((Object)fooPartition1.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new LogOffsetMetadata(0L, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition1, 1))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int x$1 = fetchMetadata.replicaId();
        boolean x$22 = fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$32 = fetchMetadata.fetchIsolation();
        int x$4 = fetchMetadata.fetchMaxBytes();
        boolean x$5 = fetchMetadata.hardMaxBytesLimit();
        Seq x$6 = fetchMetadata.fetchInfos();
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        Mockito.when((Object)this.replicaManager().readFromLocalLog(x$1, x$22, x$32, x$4, x$5, x$6, x$8, (Option)x$7)).thenReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo1.topicPartition(), fetchMetadata.replicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo1})), (Object)((MapOps)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testIncrementalFetchPartitionWhenPruningDisabled() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(topicId, 0L, 0L, 100, Optional.empty(), Optional.empty());
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata fooFetch0 = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch0.maybeUpdateResponseData(initialFetchResponse, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo0.topicPartition(), (PartitionListener)fooFetch0))).thenAnswer(x$4 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartitionWhenPruningDisabled$1(fooFetch0, foo0, x$4)));
        fooFetch0.maybeRegisterAsListener(this.replicaManager());
        Assertions.assertFalse((boolean)fooFetch0.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch0.isCaughtUp(), (String)fooFetch0.toString());
        FetchMetadata fetchMetadata = new FetchMetadata(1, Integer.MAX_VALUE, false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, false, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)Nil$.MODULE$), (scala.collection.mutable.Map)Map$.MODULE$.empty());
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return BoxedUnit.UNIT;
        });
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Partition fooPartition0 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)fooPartition0.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)fooPartition0.topicPartition()).thenReturn((Object)foo0.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(foo0.topicPartition())).thenReturn((Object)fooPartition0);
        Mockito.when((Object)fooPartition0.convertToLocalOffsetMetadata(0L)).thenReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        Mockito.when((Object)fooPartition0.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new LogOffsetMetadata(0L, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition0, 1))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int x$1 = fetchMetadata.replicaId();
        boolean x$2 = fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = fetchMetadata.fetchIsolation();
        int x$42 = fetchMetadata.fetchMaxBytes();
        boolean x$5 = fetchMetadata.hardMaxBytesLimit();
        Seq x$6 = fetchMetadata.fetchInfos();
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        Mockito.when((Object)this.replicaManager().readFromLocalLog(x$1, x$2, x$3, x$42, x$5, x$6, x$8, (Option)x$7)).thenReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo0.topicPartition(), fetchMetadata.replicaId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0})), (Object)((MapOps)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testMixedFetchDoesNotCompleteEarly() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition localTopicPartition = new TopicIdPartition(topicId, 0, "topic1");
        TopicIdPartition tieredTopicPartition = new TopicIdPartition(topicId, 1, "topic2");
        int replicaId = 1;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)localTopicPartition, (Object)this.buildPartitionData(topicId, 500L)), (List)new .colon.colon((Object)new Tuple2((Object)tieredTopicPartition, (Object)this.buildPartitionData(topicId, 500L)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)localTopicPartition, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition())), new Tuple2((Object)tieredTopicPartition, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()))}))), true);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{false, true, true}));
        Mockito.when((Object)pendingFetch.finish()).thenReturn(new HashMap(), (Object[])new java.util.Map[]{null});
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)x$5 -> {
            DelayedFetchTest.$anonfun$testMixedFetchDoesNotCompleteEarly$1(x$5);
            return BoxedUnit.UNIT;
        });
        Partition localPartition = (Partition)Mockito.mock(Partition.class);
        Partition tieredPartition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)localPartition.topicId()).thenReturn((Object)new Some((Object)localTopicPartition.topicId()), (Object[])new Option[]{new Some((Object)localTopicPartition.topicId()), null});
        Mockito.when((Object)localPartition.topicPartition()).thenReturn((Object)localTopicPartition.topicPartition(), (Object[])new TopicPartition[]{localTopicPartition.topicPartition(), null});
        Mockito.when((Object)tieredPartition.topicId()).thenReturn((Object)new Some((Object)tieredTopicPartition.topicId()), (Object[])new Option[]{new Some((Object)tieredTopicPartition.topicId()), null});
        Mockito.when((Object)tieredPartition.topicPartition()).thenReturn((Object)tieredTopicPartition.topicPartition(), (Object[])new TopicPartition[]{tieredTopicPartition.topicPartition(), null});
        LogOffsetSnapshot logOffsetSnapshot = new LogOffsetSnapshot(0L, new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Mockito.when((Object)localPartition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)logOffsetSnapshot);
        Mockito.when((Object)tieredPartition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)logOffsetSnapshot);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(localTopicPartition.topicPartition())).thenReturn((Object)localPartition, (Object[])new Partition[]{localPartition, null});
        Mockito.when((Object)this.replicaManager().getPartitionOrException(tieredTopicPartition.topicPartition())).thenReturn((Object)tieredPartition, (Object[])new Partition[]{tieredPartition, null});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLocalLog(ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((boolean)true), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((int)1024), ArgumentMatchers.eq((boolean)false), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)Nil$.MODULE$, (Object[])new Seq[]{null});
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
    }

    private FetchMetadata buildMultiPartitionFetchMetadata(int replicaId, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchInfos, scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata> fetchOffsetMetadataMap, boolean isFromFollower) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, isFromFollower, replicaId, true, fetchInfos, fetchOffsetMetadataMap);
    }

    private boolean buildMultiPartitionFetchMetadata$default$4() {
        return true;
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicIdPartition topicIdPartition, PartitionFetchMetadata fetchInfo, LogOffsetMetadata fetchOffsetMetadata) {
        return this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchInfo), (List)Nil$.MODULE$), (scala.collection.mutable.Map<TopicIdPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchOffsetMetadata)}))), true);
    }

    private void expectReadFromReplica(int replicaId, TopicIdPartition topicIdPartition, PartitionFetchMetadata fetchPartitionData, Errors error, FetchIsolation isolation) {
        int x$4 = this.maxBytes();
        .colon.colon x$6 = new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$);
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        Mockito.when((Object)this.replicaManager().readFromLocalLog(replicaId, true, isolation, x$4, false, (Seq)x$6, x$8, (Option)x$7)).thenReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private FetchIsolation expectReadFromReplica$default$5() {
        return FetchLogEnd$.MODULE$;
    }

    private LogReadResult buildReadResult(Errors error) {
        None$ none$;
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = FetchDataInfo$.MODULE$.empty();
        None$ x$3 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$11 = none$2;
        return new LogReadResult(x$2, (Option)x$3, -1L, -1L, -1L, -1L, -1L, (Option)x$10, false, (Option)x$11, (Option)x$1);
    }

    private void expectGetTierFetchResults(PendingFetch pendingFetch, Seq<Tuple2<TopicPartition, Option<Throwable>>> topicPartitionException, ReclaimableMemoryRecords records) {
        java.util.Map results = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topicPartitionException.map((Function1 & Serializable)x0$1 -> {
            Option exceptionOpt;
            TopicPartition topicPartition;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    topicPartition = (TopicPartition)x0$1._1();
                    exceptionOpt = (Option)x0$1._2();
                    if (topicPartition != null && exceptionOpt != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)new TierFetchResult(records, Collections.emptyList(), (Throwable)exceptionOpt.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        Mockito.when((Object)pendingFetch.finish()).thenReturn((Object)results);
    }

    private ReclaimableMemoryRecords expectGetTierFetchResults$default$3() {
        return ReclaimableMemoryRecords.EMPTY;
    }

    private void expectReadFromLocalLog(ReplicaManager replicaManager, Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>> fetchDataInfos, long highWatermark) {
        Seq readResults = (Seq)fetchDataInfos.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                AbstractFetchDataInfo tierFetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
                Option exceptionOpt = (Option)x0$1._3();
                if (tierFetchDataInfo instanceof TierFetchDataInfo) {
                    TierFetchDataInfo tierFetchDataInfo2 = (TierFetchDataInfo)tierFetchDataInfo;
                    if (exceptionOpt != null) {
                        return new Tuple2((Object)tp, (Object)new TierLogReadResult(tierFetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), 0, (Option)None$.MODULE$, (Option)None$.MODULE$, exceptionOpt));
                    }
                }
            }
            if (x0$1 == null) throw new MatchError(x0$1);
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            AbstractFetchDataInfo fetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
            Option exceptionOpt = (Option)x0$1._3();
            if (!(fetchDataInfo instanceof FetchDataInfo)) throw new MatchError(x0$1);
            FetchDataInfo fetchDataInfo2 = (FetchDataInfo)fetchDataInfo;
            if (exceptionOpt == null) throw new MatchError(x0$1);
            return new Tuple2((Object)tp, (Object)new LogReadResult(fetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), (Option)None$.MODULE$, true, (Option)None$.MODULE$, exceptionOpt));
        });
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)replicaManager.readFromLocalLog(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (FetchIsolation)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)readResults);
    }

    private PartitionFetchMetadata buildPartitionData(Uuid topicId, long fetchOffset) {
        return new FullPartitionFetchMetadata(topicId, fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty(), Optional.empty());
    }

    public static final /* synthetic */ boolean $anonfun$testMixedTierFetch$2(int highWatermark$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((FetchPartitionData)x0$1._2()).highWatermark() == (long)highWatermark$1;
        return bl;
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(int highWatermark$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((FetchPartitionData)x0$1._2()).highWatermark() == (long)highWatermark$2;
        return bl;
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef fetchResultOpt$4) {
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartition$1(IncrementalPartitionFetchMetadata fooFetch0$1, TopicIdPartition foo0$1, InvocationOnMock x$2) {
        fooFetch0$1.onStartOffsetUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onEndOffsetUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onHighWatermarkUpdated(foo0$1.topicPartition(), 0L);
        fooFetch0$1.onLastStableOffsetUpdated(foo0$1.topicPartition(), 0L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartition$2(IncrementalPartitionFetchMetadata fooFetch1$1, TopicIdPartition foo1$1, InvocationOnMock x$3) {
        fooFetch1$1.onStartOffsetUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onEndOffsetUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onHighWatermarkUpdated(foo1$1.topicPartition(), 0L);
        fooFetch1$1.onLastStableOffsetUpdated(foo1$1.topicPartition(), 0L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartitionWhenPruningDisabled$1(IncrementalPartitionFetchMetadata fooFetch0$2, TopicIdPartition foo0$2, InvocationOnMock x$4) {
        fooFetch0$2.onStartOffsetUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onEndOffsetUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onHighWatermarkUpdated(foo0$2.topicPartition(), 0L);
        fooFetch0$2.onLastStableOffsetUpdated(foo0$2.topicPartition(), 0L);
        return true;
    }

    public static final /* synthetic */ void $anonfun$testMixedFetchDoesNotCompleteEarly$1(Seq x$5) {
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

