/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.Defaults$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler;
import kafka.server.DiskUsageBasedThrottlerTest$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.QuotaType;
import kafka.utils.Logging;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r-a\u0001B&M\u0001ECQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004b\u0001\u0001\u0006IA\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003^\u0011\u0019\u0019\u0007\u0001)A\u0005=\"9A\r\u0001b\u0001\n\u0013i\u0006BB3\u0001A\u0003%a\fC\u0004g\u0001\t\u0007I\u0011B4\t\ra\u0004\u0001\u0015!\u0003i\u0011\u001dI\bA1A\u0005\niDqA!\u001a\u0001A\u0003%1\u0010C\u0005\u0003\u0004\u0001\u0011\r\u0011\"\u0003\u0003h!A!\u0011\u000e\u0001!\u0002\u0013\u0011)\u0001C\u0005\u0003\u000e\u0001\u0011\r\u0011\"\u0003\u0003l!A!1\u000f\u0001!\u0002\u0013\u0011i\u0007C\u0005\u0003v\u0001\u0011\r\u0011\"\u0003\u0003x!A!1\u0010\u0001!\u0002\u0013\u0011I\bC\u0006\u0003~\u0001\u0001\r\u00111A\u0005\n\t}\u0004b\u0003BB\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u000bC1Ba#\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0002\"9!Q\u0012\u0001\u0005\u0002\u0005U\bb\u0002BS\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0005_\u0003A\u0011AA{\u0011\u001d\u0011I\f\u0001C\u0001\u0003kDqA!0\u0001\t\u0003\t)\u0010C\u0004\u0003B\u0002!\t!!>\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002v\"9!\u0011\u001a\u0001\u0005\u0002\u0005U\bb\u0002Bg\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0005#\u0004A\u0011AA{\u0011\u001d\u0011)\u000e\u0001C\u0001\u0003kDqA!7\u0001\t\u0003\t)\u0010C\u0004\u0003^\u0002!\t!!>\t\u000f\t\u0005\b\u0001\"\u0001\u0002v\"9!Q\u001d\u0001\u0005\u0002\u0005U\bb\u0002Bu\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0005[\u0004A\u0011AA{\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0003kDqA!>\u0001\t\u0013\u00119\u0010C\u0005\u0004\u0006\u0001\t\n\u0011\"\u0003\u0004\b\u001d)a\u0010\u0014E\u0001\u007f\u001a11\n\u0014E\u0001\u0003\u0003Aa\u0001\u0017\u0016\u0005\u0002\u0005\raABA\u0003U\u0001\t9\u0001\u0003\u0004YY\u0011\u0005\u0011\u0011\u0004\u0005\t\u0003?a#\u0019!C\u0001;\"9\u0011\u0011\u0005\u0017!\u0002\u0013q\u0006\u0002CA\u0012Y\t\u0007I\u0011A/\t\u000f\u0005\u0015B\u0006)A\u0005=\"I\u0011q\u0005\u0017C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003\u007fa\u0003\u0015!\u0003\u0002,!9\u0011\u0011\t\u0017\u0005B\u0005\r\u0003bBA-Y\u0011\u0005\u00131\f\u0005\b\u0003GbC\u0011AA3\u0011\u001d\t\t\b\fC\u0001\u0003gBq!a\u001e-\t\u0003\nI\bC\u0004\u0002|1\"\t%!\u001f\t\u000f\u0005uD\u0006\"\u0011\u0002z!9\u0011q\u0010\u0017\u0005B\u0005\u0005\u0005bBA@Y\u0011\u0005\u00131\u0016\u0005\b\u0003_cC\u0011IAY\u0011\u001d\t9\r\fC!\u0003\u0013Dq!!\"-\t\u0003\n\u0019E\u0002\u0004\u0002N*\u0002\u0011q\u001a\u0005\u00071\u0002#\t!a6\t\u0015\u0005m\u0007I1A\u0005R1\u000bi\u000e\u0003\u0005\u0002f\u0002\u0003\u000b\u0011BAp\u0011%\t9\u000f\u0011b\u0001\n\u0003\tI\u0003\u0003\u0005\u0002j\u0002\u0003\u000b\u0011BA\u0016\u0011\u001d\tY\u000f\u0011C!\u0003[Dq!a=A\t\u0003\n)\u0010C\u0004\u0002x*\"\t!!?\t\u0013\t\u001d#&%A\u0005\u0002\t%\u0003\"\u0003B0UE\u0005I\u0011\u0001B1\u0005m!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2,'\u000fV3ti*\u0011QJT\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001%B\u00111KV\u0007\u0002)*\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001.\u0011\u0005m\u0003Q\"\u0001'\u0002\u0015QD'o\\;hQB,H/F\u0001_!\t\u0019v,\u0003\u0002a)\n!Aj\u001c8h\u0003-!\bN]8vO\"\u0004X\u000f\u001e\u0011\u0002\u0013QD'/Z:i_2$\u0017A\u0003;ie\u0016\u001c\bn\u001c7eA\u0005iA.\u0019:hK\u001aKG.Z*ju\u0016\fa\u0002\\1sO\u00164\u0015\u000e\\3TSj,\u0007%A\u0004m_\u001e$\u0015N]:\u0016\u0003!\u00042!\u001b8q\u001b\u0005Q'BA6m\u0003%IW.\\;uC\ndWM\u0003\u0002n)\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=T'aA*fcB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005Y\u0006twMC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(AB*ue&tw-\u0001\u0005m_\u001e$\u0015N]:!\u0003)1\u0017\u000e\\3Ti>\u0014Xm]\u000b\u0002wB\u0019\u0011N\u001c?\u0011\u0005udcBA.*\u0003m!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2,'\u000fV3tiB\u00111LK\n\u0003UI#\u0012a \u0002\u0017\t\u0016$XM]7j]&\u001cH/[2GS2,7\u000b^8sKN\u0019A&!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!a-\u001b7f\u0015\r\t\u0019\u0002^\u0001\u0004]&|\u0017\u0002BA\f\u0003\u001b\u0011\u0011BR5mKN#xN]3\u0015\u0005\u0005m\u0001cAA\u000fY5\t!&A\nU_R\fG.\u0011<bS2\f'\r\\3CsR,7/\u0001\u000bU_R\fG.\u0011<bS2\f'\r\\3CsR,7\u000fI\u0001\u0013\u0013:LG/[1m+N\f'\r\\3CsR,7/A\nJ]&$\u0018.\u00197Vg\u0006\u0014G.\u001a\"zi\u0016\u001c\b%\u0001\bbm\u0006LG.\u00192mK\nKH/Z:\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003wi!!a\f\u000b\t\u0005E\u00121G\u0001\u0007CR|W.[2\u000b\t\u0005U\u0012qG\u0001\u000bG>t7-\u001e:sK:$(bAA\u001di\u0006!Q\u000f^5m\u0013\u0011\ti$a\f\u0003\u0015\u0005#x.\\5d\u0019>tw-A\bbm\u0006LG.\u00192mK\nKH/Z:!\u0003\u0011q\u0017-\\3\u0015\u0005\u0005\u0015\u0003\u0003BA$\u0003+rA!!\u0013\u0002RA\u0019\u00111\n+\u000e\u0005\u00055#bAA(!\u00061AH]8pizJ1!a\u0015U\u0003\u0019\u0001&/\u001a3fM&\u0019q/a\u0016\u000b\u0007\u0005MC+\u0001\u0006jgJ+\u0017\rZ(oYf$\"!!\u0018\u0011\u0007M\u000by&C\u0002\u0002bQ\u0013qAQ8pY\u0016\fg.\u0001\bxe&$X\rT1sO\u00164\u0015\u000e\\3\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004'\u0006%\u0014bAA6)\n!QK\\5u\u0011\u0019\tyG\u000ea\u0001=\u0006Aa-\u001b7f'&TX-A\beK2,G/\u001a'be\u001e,g)\u001b7f)\u0011\t9'!\u001e\t\r\u0005=t\u00071\u0001_\u000359W\r\u001e+pi\u0006d7\u000b]1dKR\ta,\u0001\bhKR,6/\u00192mKN\u0003\u0018mY3\u0002'\u001d,G/\u00168bY2|7-\u0019;fIN\u0003\u0018mY3\u00023M,\b\u000f]8siN4\u0015\u000e\\3BiR\u0014\u0018NY;uKZKWm\u001e\u000b\u0005\u0003;\n\u0019\tC\u0004\u0002\u0006n\u0002\r!a\"\u0002\tQL\b/\u001a\u0019\u0005\u0003\u0013\u000b\u0019\n\u0005\u0004\u0002H\u0005-\u0015qR\u0005\u0005\u0003\u001b\u000b9FA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0002\u0012\u0006ME\u0002\u0001\u0003\r\u0003+\u000b\u0019)!A\u0001\u0002\u000b\u0005\u0011q\u0013\u0002\u0004?\u0012\n\u0014\u0003BAM\u0003?\u00032aUAN\u0013\r\ti\n\u0016\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t+a*\u000e\u0005\u0005\r&\u0002BAS\u0003\u001b\t\u0011\"\u0019;ue&\u0014W\u000f^3\n\t\u0005%\u00161\u0015\u0002\u0012\r&dW-\u0011;ue&\u0014W\u000f^3WS\u0016<H\u0003BA/\u0003[Cq!!\u0011=\u0001\u0004\t)%A\rhKR4\u0015\u000e\\3Ti>\u0014X-\u0011;ue&\u0014W\u000f^3WS\u0016<X\u0003BAZ\u0003o#B!!.\u0002DB!\u0011\u0011SA\\\t\u001d\tI,\u0010b\u0001\u0003w\u0013\u0011AV\t\u0005\u00033\u000bi\f\u0005\u0003\u0002\"\u0006}\u0016\u0002BAa\u0003G\u0013aCR5mKN#xN]3BiR\u0014\u0018NY;uKZKWm\u001e\u0005\b\u0003\u000bk\u0004\u0019AAc!\u0019\t9%a#\u00026\u0006aq-\u001a;BiR\u0014\u0018NY;uKR\u0019!+a3\t\u000f\u0005\u0015f\b1\u0001\u0002F\t1C+Z:uC\ndW\rR5tWV\u001b\u0018mZ3CCN,G\r\u00165s_R$H.\u001a'jgR,g.\u001a:\u0014\t\u0001\u0013\u0016\u0011\u001b\t\u00047\u0006M\u0017bAAk\u0019\nqB)[:l+N\fw-\u001a\"bg\u0016$G\u000b\u001b:piRdW\rT5ti\u0016tWM\u001d\u000b\u0003\u00033\u00042!!\bA\u0003%\tXo\u001c;b)f\u0004X-\u0006\u0002\u0002`B\u00191,!9\n\u0007\u0005\rHJA\u0005Rk>$\u0018\rV=qK\u0006Q\u0011/^8uCRK\b/\u001a\u0011\u0002\u000f\r|WO\u001c;fe\u0006A1m\\;oi\u0016\u0014\b%\u0001\niC:$G.\u001a#jg.\u001c\u0006/Y2f\u0019><H\u0003BA4\u0003_Da!!=G\u0001\u0004q\u0016\u0001G2baB,G-U;pi\u0006LeNQ=uKN\u0004VM]*fG\u0006A\u0002.\u00198eY\u0016$\u0015n]6Ta\u0006\u001cWMU3d_Z,'/\u001a3\u0015\u0005\u0005\u001d\u0014\u0001D4fiRC'o\u001c;uY\u0016\u0014HCCA~\u0005\u0003\u0011YA!\u000b\u0003>A\u00191,!@\n\u0007\u0005}HJA\fESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7fe\"I!1\u0001%\u0011\u0002\u0003\u0007!QA\u0001\u0007G>tg-[4\u0011\u0007m\u00139!C\u0002\u0003\n1\u0013a\u0004R5tWV\u001b\u0018mZ3CCN,G\r\u00165s_R$H.\u001b8h\u0007>tg-[4\t\u000f\t5\u0001\n1\u0001\u0003\u0010\u0005AQn\\2l)&lW\r\u0005\u0003\u0003\u0012\t\u0015RB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u000bU$\u0018\u000e\\:\u000b\t\te!1D\u0001\u0007G>lWn\u001c8\u000b\u0007=\u0013iB\u0003\u0003\u0003 \t\u0005\u0012AB1qC\u000eDWM\u0003\u0002\u0003$\u0005\u0019qN]4\n\t\t\u001d\"1\u0003\u0002\u0005)&lW\rC\u0004\u0003,!\u0003\rA!\f\u0002\u001d5|7m\u001b$jY\u0016\u001cFo\u001c:fgB1!q\u0006B\u001d\u0003\u0013qAA!\r\u000369!\u00111\nB\u001a\u0013\u0005)\u0016b\u0001B\u001c)\u00069\u0001/Y2lC\u001e,\u0017bA8\u0003<)\u0019!q\u0007+\t\u0013\t}\u0002\n%AA\u0002\t\u0005\u0013a\u00037jgR,g.\u001a:PaR\u0004Ra\u0015B\"\u0003#L1A!\u0012U\u0005\u0019y\u0005\u000f^5p]\u00061r-\u001a;UQJ|G\u000f\u001e7fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003L)\"!Q\u0001B'W\t\u0011y\u0005\u0005\u0003\u0003R\tmSB\u0001B*\u0015\u0011\u0011)Fa\u0016\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B-)\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu#1\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AF4fiRC'o\u001c;uY\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r$\u0006\u0002B!\u0005\u001b\n1BZ5mKN#xN]3tAU\u0011!QA\u0001\bG>tg-[4!+\t\u0011i\u0007\u0005\u0003\u0003\u0012\t=\u0014\u0002\u0002B9\u0005'\u0011\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\n\u0001\u0002\\5ti\u0016tWM]\u000b\u0003\u0005s\u0002\"! !\u0002\u00131L7\u000f^3oKJ\u0004\u0013\u0001\u0004;ie>$H\u000f\\3s\u001fB$XC\u0001BA!\u0015\u0019&1IA~\u0003A!\bN]8ui2,'o\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002h\t\u001d\u0005\"\u0003BE'\u0005\u0005\t\u0019\u0001BA\u0003\rAH%M\u0001\u000ei\"\u0014x\u000e\u001e;mKJ|\u0005\u000f\u001e\u0011\u0002\u000bM,G/\u001e9)\u0007U\u0011\t\n\u0005\u0003\u0003\u0014\n\u0005VB\u0001BK\u0015\u0011\u00119J!'\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003\u001c\nu\u0015a\u00026va&$XM\u001d\u0006\u0005\u0005?\u0013\t#A\u0003kk:LG/\u0003\u0003\u0003$\nU%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u0002\u0017\u0005S\u0003BAa%\u0003,&!!Q\u0016BK\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\tuKN$H)\u001a4bk2$8i\u001c8gS\u001eD3a\u0006BZ!\u0011\u0011\u0019J!.\n\t\t]&Q\u0013\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$8i\u001c8gS\u001e\u0014VM[3diNLE\u000e\\3hC24\u0016\r\\;fg\"\u001a\u0001Da-\u0002?Q,7\u000f^\"p]\u001aLwMU3kK\u000e$8OT3hCRLg/\u001a,bYV,7\u000fK\u0002\u001a\u0005g\u000b\u0011\u0005^3ti\u0016k\u0007\u000f^=M_\u001e$\u0015N]:ESN\f'\r\\3UQJ|G\u000f\u001e7j]\u001eD3A\u0007BZ\u0003Y!Xm\u001d;MSN$XM\\3s%\u0016<\u0017n\u001d;fe\u0016$\u0007fA\u000e\u00034\u00061B/Z:u\u0011\u0006tG\r\\3ESN\\7\u000b]1dK2{w\u000fK\u0002\u001d\u0005g\u000b\u0001\u0004^3ti\u000e\u000b\u0007OV1mk\u0016\u001cxJ\u001c'jgR,g.\u001a:tQ\ri\"1W\u0001\u001di\u0016\u001cH\u000fS1oI2,G)[:l'B\f7-\u001a*fG>4XM]3eQ\rq\"1W\u0001\u0017i\u0016\u001cH/T5o\t&\u001c8.V:bE2,')\u001f;fg\"\u001aqDa-\u0002+Q,7\u000f^'j]\u0012K7o\u001b+pi\u0006d')\u001f;fg\"\u001a\u0001Ea-\u0002'Q,7\u000f\u001e\"bg&\u001cG\u000b\u001b:piRd\u0017N\\4)\u0007\u0005\u0012\u0019,A\u0014uKN$H\u000b\u001b:pk\u001eD\u0007/\u001e;JgV\u0003H-\u0019;fI\u0012+(/\u001b8h)\"\u0014x\u000e\u001e;mS:<\u0007f\u0001\u0012\u00034\u0006IB/Z:u\u000b:\f'\r\\3GY\u0006<\u0017j\u001d*fgB,7\r^3eQ\r\u0019#1W\u0001\u0014i\u0016\u001cH\u000fV5nK&\u001b(+Z:qK\u000e$X\r\u001a\u0015\u0004I\tM\u0016A\u000e;fgR$\u0015n]6UQJ|G\u000f\u001e7j]\u001eL5/\u00138eKB,g\u000eZ3oi\u001a\u0013x.\u001c)s_\u0012,8-\u001a\"bG.\u0004(/Z:tkJ,\u0007fA\u0013\u00034\u0006QB/Z:u\u0003:LH*[:uK:,'/S:UQJ|G\u000f\u001e7fI\"\u001aaEa-\u0002)]LG\u000f\u001b'be\u001e,g)\u001b7f/JLG\u000f^3o)\u0019\t9G!?\u0004\u0004!9!1`\u0014A\u0002\tu\u0018!B5o]\u0016\u0014\bCB*\u0003\u0000z\u000b9'C\u0002\u0004\u0002Q\u0013\u0011BR;oGRLwN\\\u0019\t\u0011\u0005=t\u0005%AA\u0002y\u000bad^5uQ2\u000b'oZ3GS2,wK]5ui\u0016tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r%!f\u00010\u0003N\u0001")
public class DiskUsageBasedThrottlerTest {
    private final long throughput;
    private final long threshold;
    private final long largeFileSize;
    private final scala.collection.immutable.Seq<String> logDirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/some/fileA", "/some/fileB"}));
    private final scala.collection.immutable.Seq<DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeterministicFileStore[]{new DeterministicFileStore(), new DeterministicFileStore()}));
    private final DiskUsageBasedThrottlingConfig config = DiskUsageBasedThrottlingConfig$.MODULE$.apply(this.threshold(), this.throughput(), this.logDirs(), true, 500L, 1.5, false);
    private final MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime = new MockTime();
    private final TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener = new TestableDiskUsageBasedThrottleListener();
    private Option<DiskUsageBasedThrottler> throttlerOpt;

    public static Option<DiskUsageBasedThrottleListener> getThrottler$default$4() {
        return None$.MODULE$;
    }

    public static DiskUsageBasedThrottlingConfig getThrottler$default$1() {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$1();
    }

    public static DiskUsageBasedThrottler getThrottler(DiskUsageBasedThrottlingConfig config, Time mockTime, scala.collection.immutable.Seq<FileStore> mockFileStores, Option<DiskUsageBasedThrottleListener> listenerOpt) {
        return new DiskUsageBasedThrottler(config, mockTime, mockFileStores, listenerOpt){
            private final DiskThrottleListenerManager listenerManager;
            private volatile DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig;
            private AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime;
            private volatile Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores;
            private volatile long producerThrottleRate;
            private volatile long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate;
            private volatile long followerThrottleRate;
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final DiskUsageBasedThrottlingConfig config$1;
            private final Time mockTime$1;
            private final scala.collection.immutable.Seq mockFileStores$1;

            public void createDiskThrottlerMetrics() {
                DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)this);
            }

            public void removeDiskThrottlerMetrics() {
                DiskUsageBasedThrottler.removeDiskThrottlerMetrics$((DiskUsageBasedThrottler)this);
            }

            public void updateDiskThrottlingConfig(DiskUsageBasedThrottlingConfig newConfig) {
                DiskUsageBasedThrottler.updateDiskThrottlingConfig$((DiskUsageBasedThrottler)this, (DiskUsageBasedThrottlingConfig)newConfig);
            }

            public boolean diskThrottlingEnabledInConfig(DiskUsageBasedThrottlingConfig config) {
                return DiskUsageBasedThrottler.diskThrottlingEnabledInConfig$((DiskUsageBasedThrottler)this, (DiskUsageBasedThrottlingConfig)config);
            }

            public long minDiskTotalBytes() {
                return DiskUsageBasedThrottler.minDiskTotalBytes$((DiskUsageBasedThrottler)this);
            }

            public long minDiskUsableBytes() {
                return DiskUsageBasedThrottler.minDiskUsableBytes$((DiskUsageBasedThrottler)this);
            }

            public void checkAndUpdateQuotaOnDiskUsage(long timeMs) {
                DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)this, (long)timeMs);
            }

            public void initThrottler() {
                DiskUsageBasedThrottler.initThrottler$((DiskUsageBasedThrottler)this);
            }

            public DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig() {
                return DiskUsageBasedThrottler.getCurrentDiskThrottlingConfig$((DiskUsageBasedThrottler)this);
            }

            public MetricName metricName(String name, Map<String, String> tags) {
                return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
            }

            public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
                return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
            }

            public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
                return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
            }

            public <T> Map<String, String> newGauge$default$3() {
                return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
            }

            public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
                return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (MetricName)metricName, metric);
            }

            public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
                return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
            }

            public Map<String, String> newMeter$default$4() {
                return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
            }

            public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
                return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (MetricName)metricName, (String)eventType, (TimeUnit)timeUnit);
            }

            public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
                return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
            }

            public boolean newHistogram$default$2() {
                return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
            }

            public Map<String, String> newHistogram$default$3() {
                return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
            }

            public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
                return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
            }

            public Map<String, String> newTimer$default$4() {
                return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
            }

            public void removeMetric(String name, Map<String, String> tags) {
                KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
            }

            public Map<String, String> removeMetric$default$2() {
                return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
            }

            public void removeMetric(MetricName metricName) {
                KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (MetricName)metricName);
            }

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Logging.debug$((Logging)this, msg, e);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Logging.warn$((Logging)this, msg, e);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Logging.error$((Logging)this, msg, e);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            public DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig() {
                return this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig;
            }

            public void kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(DiskUsageBasedThrottlingConfig x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig = x$1;
            }

            public AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime() {
                return this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime;
            }

            public Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores() {
                return this.kafka$server$DiskUsageBasedThrottler$$fileStores;
            }

            public void kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(Seq<FileStore> x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$fileStores = x$1;
            }

            public long producerThrottleRate() {
                return this.producerThrottleRate;
            }

            public void producerThrottleRate_$eq(long x$1) {
                this.producerThrottleRate = x$1;
            }

            public long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate() {
                return this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate;
            }

            public void kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(long x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate = x$1;
            }

            public long followerThrottleRate() {
                return this.followerThrottleRate;
            }

            public void followerThrottleRate_$eq(long x$1) {
                this.followerThrottleRate = x$1;
            }

            public final void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(AtomicLong x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime = x$1;
            }

            public void kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskThrottleListenerManager x$1) {
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public DiskUsageBasedThrottlingConfig diskThrottlingConfig() {
                return this.config$1;
            }

            public Time time() {
                return this.mockTime$1;
            }

            public Seq<FileStore> getFileStores() {
                return this.mockFileStores$1;
            }

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }

            public static final /* synthetic */ void $anonfun$listenerManager$1(DiskThrottleListenerManager manager$1, DiskUsageBasedThrottleListener listener) {
                manager$1.registerListener(listener);
            }
            {
                this.config$1 = config$1;
                this.mockTime$1 = mockTime$1;
                this.mockFileStores$1 = mockFileStores$1;
                DiskUsageBasedThrottler.$init$((DiskUsageBasedThrottler)this);
                DiskThrottleListenerManager manager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
                listenerOpt$1.foreach((Function1 & Serializable)listener -> {
                    $anon$4.$anonfun$listenerManager$1(manager, listener);
                    return BoxedUnit.UNIT;
                });
                this.listenerManager = manager;
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$listenerManager$1$adapted(kafka.server.DiskThrottleListenerManager kafka.server.DiskUsageBasedThrottleListener )}, serializedLambda);
            }
        };
    }

    private long throughput() {
        return this.throughput;
    }

    private long threshold() {
        return this.threshold;
    }

    private long largeFileSize() {
        return this.largeFileSize;
    }

    private scala.collection.immutable.Seq<String> logDirs() {
        return this.logDirs;
    }

    public scala.collection.immutable.Seq<DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores;
    }

    private DiskUsageBasedThrottlingConfig config() {
        return this.config;
    }

    public MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime;
    }

    public TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$listener;
    }

    private Option<DiskUsageBasedThrottler> throttlerOpt() {
        return this.throttlerOpt;
    }

    private void throttlerOpt_$eq(Option<DiskUsageBasedThrottler> x$1) {
        this.throttlerOpt = x$1;
    }

    @BeforeEach
    public void setup() {
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)None$.MODULE$);
    }

    @AfterEach
    public void teardown() {
        this.throttlerOpt().foreach((Function1 & Serializable)x$2 -> {
            DiskUsageBasedThrottlerTest.$anonfun$teardown$1(this, x$2);
            return BoxedUnit.UNIT;
        });
        this.throttlerOpt().foreach((Function1 & Serializable)x$3 -> {
            x$3.removeDiskThrottlerMetrics();
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDefaultConfig() {
        DiskUsageBasedThrottlingConfig defaultConfig = DiskUsageBasedThrottlingConfig$.MODULE$.apply(0x500000000L, 131072L, (Seq)Seq$.MODULE$.empty(), false, DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs(), 1.5, false);
        Assertions.assertFalse((boolean)defaultConfig.enableDiskBasedThrottling());
        Assertions.assertEquals((long)0x500000000L, (long)defaultConfig.freeDiskThresholdBytes());
        Assertions.assertEquals((long)131072L, (long)defaultConfig.throttledProduceThroughput());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)defaultConfig.logDirs());
    }

    @Test
    public void testConfigRejectsIllegalValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(10L, 42L, (Seq)Seq$.MODULE$.empty(), false, DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs(), 1.5, false);
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testConfigRejectsNegativeValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(-10L, -42L, (Seq)Seq$.MODULE$.empty(), false, DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs(), 1.5, false);
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testEmptyLogDirsDisableThrottling() {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        long l = 0x500000000L;
        long l2 = 131072L;
        long l3 = DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs();
        double d = 1.5;
        boolean bl = false;
        DiskUsageBasedThrottlingConfig configWithEmptyLogDirs = DiskUsageBasedThrottlingConfig$.MODULE$.apply(l, l2, (Seq)x$1, true, l3, d, bl);
        Assertions.assertFalse((boolean)configWithEmptyLogDirs.enableDiskBasedThrottling());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)configWithEmptyLogDirs.logDirs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerRegistered() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$;
        TestableDiskUsageBasedThrottleListener newListener = new TestableDiskUsageBasedThrottleListener();
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$3 = none$2;
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var3_6 = null;
        mockTime = null;
        seq = null;
        none$3 = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertTrue((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertFalse((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
    }

    @Test
    public void testHandleDiskSpaceLow() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceLow(this.throughput());
        Assertions.assertEquals((long)this.throughput(), (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCapValuesOnListeners() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$;
        TestableDiskUsageBasedThrottleListener produceListener = new TestableDiskUsageBasedThrottleListener();
        TestableDiskUsageBasedThrottleListener followerListener = new TestableDiskUsageBasedThrottleListener(null){
            private final QuotaType quotaType;

            public QuotaType quotaType() {
                return this.quotaType;
            }
            {
                this.quotaType = QuotaType.FollowerReplication$.MODULE$;
            }
        };
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$3 = none$2;
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var7_7 = null;
        mockTime = null;
        seq = null;
        none$3 = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)followerListener);
        Predef$.MODULE$.println((Object)throttler.listenerManager().getListeners());
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testCapValuesOnListeners$1(this, throttler, produceListener, followerListener, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var6_10 = null;
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)followerListener);
    }

    @Test
    public void testHandleDiskSpaceRecovered() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceRecovered();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMinDiskUsableBytes() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$3 = none$2;
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var5_5 = null;
        mockTime = null;
        seq = null;
        none$3 = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        long l = DiskUsageBasedThrottler.minDiskUsableBytes$((DiskUsageBasedThrottler)throttler);
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskUsableBytes$1(this, throttler, l, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMinDiskTotalBytes() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$3 = none$2;
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var5_5 = null;
        mockTime = null;
        seq = null;
        none$3 = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        long l = DiskUsageBasedThrottler.minDiskTotalBytes$((DiskUsageBasedThrottler)throttler);
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskTotalBytes$1(throttler, l, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicThrottling() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7());
        Object var7_5 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testBasicThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var6_9 = null;
        long checkAndUpdateQuotaOnDiskUsage_timeMs2 = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs2);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThroughputIsUpdatedDuringThrottling() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7());
        Object var7_5 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testThroughputIsUpdatedDuringThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEnableFlagIsRespected() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        long x$5 = this.config().copy$default$5();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$3 = none$2;
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, x$3, x$4, false, x$5, x$6, x$7);
        Object var15_11 = null;
        mockTime = null;
        seq = null;
        none$3 = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testEnableFlagIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeIsRespected() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        boolean x$5 = this.config().copy$default$4();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, x$3, x$4, x$5, 1000L, x$6, x$7);
        Object var14_10 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testTimeIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testDiskThrottlingIsIndependentFromProduceBackpressure() {
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        DiskUsageBasedThrottlingConfig x$2 = this.config();
        int n = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int n2 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        double d = 9.223372036854776E18;
        long l = 0L;
        ClientQuotaManagerConfig quotaManagerConfig = new ClientQuotaManagerConfig(n, n2, x$1, x$2, d, l);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this, quotaManagerConfig){
            private final DiskThrottleListenerManager listenerManager;
            private final /* synthetic */ DiskUsageBasedThrottlerTest $outer;

            public Seq<FileStore> getFileStores() {
                return this.$outer.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
            }

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(quotaManagerConfig$1, new Metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)$outer.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), "someThread", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
                DiskThrottleListenerManager manager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
                TestableDiskUsageBasedThrottleListener registerListener_listener = $outer.kafka$server$DiskUsageBasedThrottlerTest$$listener();
                DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)manager, (DiskUsageBasedThrottleListener)registerListener_listener);
                this.listenerManager = var3_3;
            }
        };
        clientQuotaManager.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)clientQuotaManager));
        clientQuotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(this, clientQuotaManager, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var7_10 = null;
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        clientQuotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAnyListenerIsThrottled() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        DiskUsageBasedThrottler diskUsageBasedThrottler;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7());
        DiskUsageBasedThrottler diskUsageBasedThrottler2 = diskUsageBasedThrottler = new /* invalid duplicate definition of identical inner class */;
        Object var7_5 = null;
        mockTime = null;
        seq = null;
        some = null;
        diskUsageBasedThrottler = null;
        DiskUsageBasedThrottler throttler = diskUsageBasedThrottler2;
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testAnyListenerIsThrottled$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var6_10 = null;
        long checkAndUpdateQuotaOnDiskUsage_timeMs2 = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs2);
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
    }

    private void withLargeFileWritten(Function1<Object, BoxedUnit> inner, long fileSize) {
        DeterministicFileStore fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        fileStore.writeLargeFile(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        inner.apply$mcVJ$sp(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        fileStore.deleteLargeFile(fileSize);
    }

    private long withLargeFileWritten$default$2() {
        return this.largeFileSize();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler x$2) {
        x$2.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
    }

    public static final /* synthetic */ void $anonfun$testCapValuesOnListeners$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$1, TestableDiskUsageBasedThrottleListener produceListener$1, TestableDiskUsageBasedThrottleListener followerListener$1, long x$4) {
        throttler$1.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)produceListener$1.counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$1.producerThrottleRate());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)followerListener$1.counter().get());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)throttler$1.followerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskUsableBytes$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$2, long previousUsableSpaceBytes$1, long fileSize) {
        long currentUsableBytes = throttler$2.minDiskUsableBytes();
        Assertions.assertEquals((long)(previousUsableSpaceBytes$1 - fileSize), (long)currentUsableBytes);
        Assertions.assertEquals((long)previousUsableSpaceBytes$1, (long)((DeterministicFileStore)$this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().apply(1)).getUsableSpace());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskTotalBytes$1(DiskUsageBasedThrottler throttler$3, long existingTotalBytes$1, long x$5) {
        long currentTotalBytes = throttler$3.minDiskTotalBytes();
        Assertions.assertEquals((long)existingTotalBytes$1, (long)currentTotalBytes);
    }

    public static final /* synthetic */ void $anonfun$testBasicThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$4, long x$7) {
        throttler$4.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$4.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$4.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testThroughputIsUpdatedDuringThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$5, long x$9) {
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$5.producerThrottleRate());
        long updatedThroughput = 10L * $this.throughput();
        DiskUsageBasedThrottlingConfig qual$1 = throttler$5.getCurrentDiskThrottlingConfig();
        long x$2 = qual$1.copy$default$1();
        Seq x$3 = qual$1.copy$default$3();
        boolean x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        double x$6 = qual$1.copy$default$6();
        boolean x$7 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig updatedConfig = qual$1.copy(x$2, updatedThroughput, x$3, x$4, x$5, x$6, x$7);
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        throttler$5.updateDiskThrottlingConfig(updatedConfig);
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)updatedThroughput, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)updatedThroughput, (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)updatedThroughput, (long)throttler$5.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testEnableFlagIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$6, long x$11) {
        throttler$6.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$6.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$6.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testTimeIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$7, long x$13) {
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$7.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$7.producerThrottleRate());
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(500L);
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$7.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(DiskUsageBasedThrottlerTest $this, ClientQuotaManager clientQuotaManager$1, long x$14) {
        clientQuotaManager$1.updateBrokerQuotaLimit($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)clientQuotaManager$1.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testAnyListenerIsThrottled$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$8, long x$16) {
        throttler$8.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertTrue((boolean)throttler$8.listenerManager().anyListenerIsThrottled());
    }

    public DiskUsageBasedThrottlerTest() {
        this.throughput = 65536L;
        this.threshold = 0x140000000L;
        this.largeFileSize = 0x300000000L;
    }

    public static class DeterministicFileStore
    extends FileStore {
        private final long TotalAvailableBytes;
        private final long InitialUsableBytes;
        private final AtomicLong availableBytes = new AtomicLong(this.InitialUsableBytes());

        public long TotalAvailableBytes() {
            return this.TotalAvailableBytes;
        }

        public long InitialUsableBytes() {
            return this.InitialUsableBytes;
        }

        private AtomicLong availableBytes() {
            return this.availableBytes;
        }

        @Override
        public String name() {
            return this.getClass().getName();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public void writeLargeFile(long fileSize) {
            if (fileSize > this.availableBytes().get()) {
                throw new IllegalArgumentException(new StringBuilder(48).append("Can't write a file with size ").append(fileSize).append(" > available size: ").append(this.availableBytes().get()).toString());
            }
            this.availableBytes().updateAndGet(x$17 -> x$17 - fileSize);
        }

        public void deleteLargeFile(long fileSize) {
            if (this.availableBytes().get() + fileSize > this.TotalAvailableBytes()) {
                throw new IllegalArgumentException("Can't delete the large file, because the file might not have been written already");
            }
            this.availableBytes().addAndGet(fileSize);
        }

        @Override
        public long getTotalSpace() {
            return this.TotalAvailableBytes();
        }

        @Override
        public long getUsableSpace() {
            return this.availableBytes().get();
        }

        @Override
        public long getUnallocatedSpace() {
            return this.TotalAvailableBytes() - this.availableBytes().get();
        }

        @Override
        public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public boolean supportsFileAttributeView(String name) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public Object getAttribute(String attribute) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public String type() {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public DeterministicFileStore() {
            this.TotalAvailableBytes = 0x500000000L;
            this.InitialUsableBytes = 0x3C0000000L;
        }
    }

    public static class TestableDiskUsageBasedThrottleListener
    implements DiskUsageBasedThrottleListener {
        private final QuotaType quotaType;
        private final AtomicLong counter;
        private AtomicReference<Option<Object>> lastSignalledQuotaOptRef;

        public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
            return this.lastSignalledQuotaOptRef;
        }

        public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
            this.lastSignalledQuotaOptRef = x$1;
        }

        public QuotaType quotaType() {
            return this.quotaType;
        }

        public AtomicLong counter() {
            return this.counter;
        }

        public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
            this.counter().set(cappedQuotaInBytesPerSec);
        }

        public void handleDiskSpaceRecovered() {
            this.counter().set(Long.MAX_VALUE);
        }

        public TestableDiskUsageBasedThrottleListener() {
            DiskUsageBasedThrottleListener.$init$((DiskUsageBasedThrottleListener)this);
            this.quotaType = QuotaType.Produce$.MODULE$;
            this.counter = new AtomicLong(Long.MAX_VALUE);
            Statics.releaseFence();
        }
    }
}

