/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule;
import io.confluent.kafka.security.auth.plain.FileBasedDynamicPlainLoginCallbackHandler;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.admin.BrokerMetadata;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicDurabilityAuditConfig;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicLoginContext;
import kafka.server.DynamicLoginManager;
import kafka.server.DynamicThreadPool;
import kafka.server.DynamicTransactionCoordinator;
import kafka.server.DynamicZkControllerConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.server.TestQuotaCallback;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%b\u0001B\u001a5\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u0012\u0001\u0005\u0002\u0015CQA\u0016\u0001\u0005\u0002\u0015CQa\u0017\u0001\u0005\u0002\u0015CQ!\u0018\u0001\u0005\u0002\u0015CQa\u0018\u0001\u0005\u0002\u0015CQ!\u0019\u0001\u0005\u0002\u0015CQa\u0019\u0001\u0005\u0002\u0015CQ!\u001a\u0001\u0005\u0002\u0015CQa\u001a\u0001\u0005\u0002\u0015CQ!\u001b\u0001\u0005\u0002\u0015CQa\u001b\u0001\u0005\u0002\u0015CQ!\u001c\u0001\u0005\u0002\u0015CQa\u001c\u0001\u0005\u0002\u0015CQ!\u001d\u0001\u0005\u0002\u0015CQa\u001d\u0001\u0005\u0002\u0015CQ!\u001e\u0001\u0005\u0002\u0015CQa\u001e\u0001\u0005\u0002\u0015CQ!\u001f\u0001\u0005\u0002\u0015CQa\u001f\u0001\u0005\u0002\u0015CQ! \u0001\u0005\u0002\u0015CQa \u0001\u0005\u0002\u0015Ca!a\u0001\u0001\t\u0003)\u0005BBA\u0004\u0001\u0011\u0005Q\t\u0003\u0004\u0002\f\u0001!\t!\u0012\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\ty\u0005\u0001C\u0005\u0003#Ba!!!\u0001\t\u0003)\u0005BBAC\u0001\u0011\u0005Q\t\u0003\u0004\u0002\n\u0002!\t!\u0012\u0005\u0007\u0003\u001b\u0003A\u0011A#\t\r\u0005E\u0005\u0001\"\u0001F\u0011\u0019\t)\n\u0001C\u0001\u000b\"1\u0011\u0011\u0014\u0001\u0005\u0002\u0015Ca!!(\u0001\t\u0003)\u0005BBAQ\u0001\u0011\u0005Q\t\u0003\u0004\u0002&\u0002!\t!\u0012\u0005\u0007\u0003S\u0003A\u0011A#\t\r\u00055\u0006\u0001\"\u0001F\u0011\u0019\t\t\f\u0001C\u0001\u000b\"1\u0011Q\u0017\u0001\u0005\u0002\u0015Ca!!/\u0001\t\u0003)\u0005BBA_\u0001\u0011\u0005Q\t\u0003\u0004\u0002B\u0002!\t!\u0012\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u0019\t\t\u000e\u0001C\u0001\u000b\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007\"CAt\u0001E\u0005I\u0011BAu\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqAa\u0005\u0001\t\u0013\u0011)BA\fEs:\fW.[2Ce>\\WM]\"p]\u001aLw\rV3ti*\u0011QGN\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\"\u0011\u0005\r\u0003Q\"\u0001\u001b\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\u0012\t\u0003w\u001dK!\u0001\u0013\u001f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005)\u0003\"a\u0013+\u000e\u00031S!!\u0014(\u0002\u0007\u0005\u0004\u0018N\u0003\u0002P!\u00069!.\u001e9ji\u0016\u0014(BA)S\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0016aA8sO&\u0011Q\u000b\u0014\u0002\n\u0003\u001a$XM]#bG\"\f\u0001\u0003^3ti\u000e{gNZ5h+B$\u0017\r^3)\u0005\rA\u0006CA&Z\u0013\tQFJ\u0001\u0003UKN$\u0018\u0001\n;fgR$&/\u00198tC\u000e$\u0018n\u001c8WKJ\u0014wn]5us\u000e{gNZ5h+B$\u0017\r^3)\u0005\u0011A\u0016a\f;fgR$&/\u00198tC\u000e$\u0018n\u001c8M_\u001e<\u0017N\\4WKJ\u0014wn]5us\u000e{gNZ5h-\u0006d\u0017\u000eZ1uS>t\u0007FA\u0003Y\u0003e!Xm\u001d;EkJ\f'-\u001b7jif\fU\u000fZ5u\u0007>tg-[4)\u0005\u0019A\u0016a\t;fgR,E.[4jE2,7i\u001c8ue>dG.\u001a:t\u0007>tg-[4Va\u0012\fG/\u001a\u0015\u0003\u000fa\u000bq\u0005^3ti\u0016c\u0017nZ5cY\u0016\u001cuN\u001c;s_2dWM]:D_:4\u0017n\u001a,bY&$\u0017\r^5p]\"\u0012\u0001\u0002W\u0001'i\u0016\u001cH/\u00128bE2,G)\u001a4bk2$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>t\u0007FA\u0005Y\u0003m!Xm\u001d;Va\u0012\fG/\u001a#z]\u0006l\u0017n\u0019+ie\u0016\fG\rU8pY\"\u0012!\u0002W\u0001'i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5T_6,\u0017J\u001c<bY&$7i\u001c8gS\u001e\u001c\bFA\u0006Y\u0003M\"Xm\u001d;D_:4\u0017nZ+qI\u0006$XmV5uQJ+7m\u001c8gS\u001e,(/\u00192mKZ\u000bG.\u001b3bi&|gNR1jYV\u0014X\r\u000b\u0002\r1\u0006aB/Z:u%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f-\u0006d\u0017\u000eZ1uS>t\u0007FA\u0007Y\u0003M!Xm\u001d;TK\u000e,(/\u001b;z\u0007>tg-[4tQ\tq\u0001,A\nuKN$8i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\r\u000b\u0002\u00101\u0006!B/Z:u\u0019><W*\u00198bO\u0016\u00148i\u001c8gS\u001eD#\u0001\u0005-\u0002UQ,7\u000f\u001e+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\u001cuN\u001c4jO\"\u0012\u0011\u0003W\u0001\u0014i\u0016\u001cH\u000fV5feR\u000b7o[:D_:4\u0017n\u001a\u0015\u0003%a\u000b1\u0003^3ti\n\u000bG.\u00198dKJ\u001cuN\u001c4jOND#a\u0005-\u0002GQ,7\u000f\u001e\"bY\u0006t7-\u001a:WC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]\"\u0012A\u0003W\u0001(i\u0016\u001cHOQ1mC:\u001cWM\u001d*fG>tg-[4ve\u0016tUmZ1uSZ,G\u000b\u001b:piRdW\r\u000b\u0002\u00161\u00069B/Z:u\u0007>tg.Z2uS>t'+\u0019;f#V|G/\u0019\u0015\u0003-a\u000bA\u0004^3ti\u000e{gN\\3di&|gNU1uKF+x\u000e^1GY>|'\u000f\u000b\u0002\u00181\u0006\u0019B/Z:u#V|G/Y'vYRL\u0007\u000f\\5fe\"\u0012\u0001\u0004W\u0001\u0015i\u0016\u001cH/V:feF+x\u000e^1t\u000b:\f'\r\\3)\u0005eA\u0016A\u0005<fe&4\u0017pQ8oM&<W\u000b\u001d3bi\u0016$\u0012BRA\n\u0003[\t\t%a\u0013\t\u000f\u0005U!\u00041\u0001\u0002\u0018\u0005!a.Y7f!\u0011\tI\"a\n\u000f\t\u0005m\u00111\u0005\t\u0004\u0003;aTBAA\u0010\u0015\r\t\t\u0003O\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015B(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\tYC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Ka\u0004bBA\u00185\u0001\u0007\u0011\u0011G\u0001\u0006m\u0006dW/\u001a\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0012\u0001\u00026bm\u0006LA!a\u0010\u00026\t1qJ\u00196fGRDq!a\u0011\u001b\u0001\u0004\t)%A\bqKJ\u0014%o\\6fe\u000e{gNZ5h!\rY\u0014qI\u0005\u0004\u0003\u0013b$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001bR\u0002\u0019AA#\u00035)\u0007\u0010]3di\u001a\u000b\u0017\u000e\\;sK\u0006\u0019c/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\b.\u00138wC2LGmQ8oM&<G#\u0003$\u0002T\u0005u\u0013QNA?\u0011\u001d\t)f\u0007a\u0001\u0003/\naaY8oM&<\u0007cA\"\u0002Z%\u0019\u00111\f\u001b\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003?Z\u0002\u0019AA1\u0003%y'/[4Qe>\u00048\u000f\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'!\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\n)G\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u001c\u001c\u0001\u0004\t\t(\u0001\u0006wC2LG\r\u0015:paN\u0004\u0002\"a\u001d\u0002z\u0005]\u0011qC\u0007\u0003\u0003kR1!a\u001e=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\n)HA\u0002NCBDq!a \u001c\u0001\u0004\t\t(\u0001\u0007j]Z\fG.\u001b3Qe>\u00048/\u0001\u000fuKN$\b+Y:to>\u0014HmQ8oM&<WI\\2ssB$\u0018n\u001c8)\u0005qA\u0016!\n;fgR\u0004\u0016m]:x_J$7i\u001c8gS\u001e,enY8eKJ\u001cVm\u0019:fi\u000eC\u0017M\\4fQ\ti\u0002,A\ruKN$H)\u001f8b[&\u001cG*[:uK:,'oQ8oM&<\u0007F\u0001\u0010Y\u0003Q!Xm\u001d;BkRDwN]5{KJ\u001cuN\u001c4jO\"\u0012q\u0004W\u0001\u0015i\u0016\u001cH\u000f\u0013;uaN+'O^3s\u0007>tg-[4)\u0005\u0001B\u0016\u0001\u0004;fgR\u001c\u0016P\\8os6\u001c\bFA\u0011Y\u0003E\"Xm\u001d;Es:\fW.[2D_:4\u0017nZ%oSRL\u0017\r\\5{CRLwN\\,ji\"|W\u000f^\"p]\u001aLwm]%o5.C#A\t-\u0002eQ,7\u000f^\"p]\u001aLw-\u001e:fI&s7\u000f^1oG\u0016Le.\u001b;jC2L'0\u001a3XSRDG)\u001f8b[&\u001c7i\u001c8gS\u001eD#a\t-\u0002KQ,7\u000f\u001e*fa2L7-Y'b]\u0006<WM\u001d$fi\u000eDW*\u0019=CsR,7o\u00115b]\u001e,\u0007F\u0001\u0013Y\u0003Q\"Xm\u001d;SKBd\u0017nY1NC:\fw-\u001a:US\u0016\u0014X*\u0019=QCJ$\u0018\u000e^5p]\u001a+Go\u00195CsR,7o\u0014<feJLG-\u001a\u0015\u0003Ka\u000bQ\u0004^3ti&k\u0007O]8qKJ\u001cuN\u001c4jON\f%/\u001a*f[>4X\r\u001a\u0015\u0003Ma\u000bA\u0003^3ti\u000ec\u0017.\u001a8u\u0015\u0006\f7oQ8oM&<\u0007FA\u0014Y\u0003U!Xm\u001d;M_\u001eLgnQ8oM&<7\t[1oO\u0016D#\u0001\u000b-\u0002cQ,7\u000f^*bg2\u001c%/\u001a3f]RL\u0017\r\u001c*pi\u0006$\u0018n\u001c8XSRD\u0007K]3gSb,Gm\u0011:fI\u0016tG/[1mg\"\u0012\u0011\u0006W\u00014i\u0016\u001cHoU1tY\u000e\u0013X\rZ3oi&\fGNU8uCRLwN\\,ji\",f\u000e\u001d:fM&DX\rZ\"sK\u0012,g\u000e^5bYND#A\u000b-\u0002]Q,7\u000f^*bg2\u001c%/\u001a3f]RL\u0017\r\u001c*pi\u0006$\u0018n\u001c8XSRD7\u000b[1sK\u0012T\u0015-Y:D_:4\u0017n\u001a\u0015\u0003Wa\u000ba\u0003^3ti:+woU1tY\u000e\u0013X\rZ3oi&\fGn\u001d\u0015\u0003Ya\u000b\u0001D^3sS\u001aL8I]3eK:$\u0018.\u00197S_R\fG/[8o)\u00151\u0015\u0011ZAg\u0011\u001d\tY-\fa\u0001\u0003/\ta\"^:fe:\fW.Z\"p]\u001aLw\rC\u0004\u0002P6\u0002\r!a\u0006\u0002\u001dA\f7o]<pe\u0012\u001cuN\u001c4jO\u0006YC/Z:u\r&dWMQ1tK\u0012dunZ5o\u001d>$\b*\u00198eY\u0016$\u0017i\u001d#z]\u0006l\u0017nY\"p]\u001aLw\r\u000b\u0002/1\u0006Q2.\u00194lCB\u0013x\u000e]:XSRDG)\u001f8b[&\u001cGj\\4j]RA\u0011\u0011MAm\u00037\fi\u000eC\u0004\u0002L>\u0002\r!a\u0006\t\u000f\u0005=w\u00061\u0001\u0002\u0018!I\u0011q\\\u0018\u0011\u0002\u0003\u0007\u0011\u0011]\u0001\u000fa2,x-\u001b8Qe\u00164\u0017\u000e_3t!\u0019\t\u0019(a9\u0002\u0018%!\u0011Q]A;\u0005\r\u0019V\r^\u0001%W\u000647.\u0019)s_B\u001cx+\u001b;i\tft\u0017-\\5d\u0019><\u0017N\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001e\u0016\u0005\u0003C\fio\u000b\u0002\u0002pB!\u0011\u0011_A~\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018!C;oG\",7m[3e\u0015\r\tI\u0010P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u007f\u0003g\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0005\u001a'/Z1uK.\u000bgm[1D_:4\u0017nZ,ji\"$\u0015P\\1nS\u000edunZ5o)\u0011\u0011\u0019Aa\u0004\u0011\u000fm\u0012)!a\u0016\u0003\n%\u0019!q\u0001\u001f\u0003\rQ+\b\u000f\\33!\r\u0019%1B\u0005\u0004\u0005\u001b!$a\u0005#z]\u0006l\u0017n\u0019'pO&tW*\u00198bO\u0016\u0014\bb\u0002B\tc\u0001\u0007\u0011\u0011M\u0001\u0006aJ|\u0007o]\u0001\u0011m\u0016\u0014\u0018NZ=De\u0016$WM\u001c;jC2$rA\u0012B\f\u0005C\u0011)\u0003C\u0004\u0003\u001aI\u0002\rAa\u0007\u0002\u000f\r|g\u000e^3yiB\u00191I!\b\n\u0007\t}AGA\nEs:\fW.[2M_\u001eLgnQ8oi\u0016DH\u000fC\u0004\u0003$I\u0002\r!a\u0006\u0002\u0011U\u001cXM\u001d8b[\u0016DqAa\n3\u0001\u0004\t9\"\u0001\u0005qCN\u001cxo\u001c:e\u0001")
public class DynamicBrokerConfigTest {
    @AfterEach
    public void tearDown() {
        LoginManager.closeAll();
    }

    @Test
    public void testConfigUpdate() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, bl8);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testTransactionVerbosityConfigUpdate() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Object var10_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)config.confluentConfig().transactionLoggingVerbosity());
        TransactionCoordinator txnCoordinatorMock = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        DynamicTransactionCoordinator dynamicTxnCoordinatorConfig = new DynamicTransactionCoordinator(txnCoordinatorMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicTxnCoordinatorConfig);
        Properties props = new Properties();
        props.put("confluent.transaction.logging.verbosity", "1");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)config.confluentConfig().transactionLoggingVerbosity());
        ((TransactionCoordinator)Mockito.verify((Object)txnCoordinatorMock)).setLoggingVerbosity(1);
    }

    @Test
    public void testTransactionLoggingVerbosityConfigValidation() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Object var10_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)config.confluentConfig().transactionLoggingVerbosity());
        TransactionCoordinator txnCoordinatorMock = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        DynamicTransactionCoordinator dynamicTxnCoordinatorConfig = new DynamicTransactionCoordinator(txnCoordinatorMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicTxnCoordinatorConfig);
        Properties props = new Properties();
        props.put("confluent.transaction.logging.verbosity", "-11");
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, false));
    }

    @Test
    public void testDurabilityAuditConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Object var10_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)"PeriodicalAudit,ChecksumAudit", (Object)config.confluentConfig().auditConfigChecks());
        KafkaBroker kafkaBrokerMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DynamicDurabilityAuditConfig dynamicDurabilityAuditConfig = new DynamicDurabilityAuditConfig(kafkaBrokerMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicDurabilityAuditConfig);
        Properties props = new Properties();
        props.put("confluent.durability.audit.checks", "");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((Object)"", (Object)config.confluentConfig().auditConfigChecks());
    }

    @Test
    public void testEligibleControllersConfigUpdate() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Object var11_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)config.confluentConfig().eligibleControllers());
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        MetadataCache metadataCacheMock = (MetadataCache)Mockito.mock(MetadataCache.class);
        DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(controllerMock, metadataCacheMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicControllerConfig);
        Mockito.when((Object)metadataCacheMock.getAliveBrokers()).thenReturn(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(0, (Option)None$.MODULE$), new BrokerMetadata(1, (Option)None$.MODULE$)})));
        Properties props = new Properties();
        props.put("confluent.eligible.controllers", "0");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        ((KafkaController)Mockito.verify((Object)controllerMock)).updateEligibleControllers((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
        Mockito.reset((Object[])new KafkaController[]{controllerMock});
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)config.confluentConfig().eligibleControllers());
        props.put("confluent.eligible.controllers", "");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        ((KafkaController)Mockito.verify((Object)controllerMock)).updateEligibleControllers((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)config.confluentConfig().eligibleControllers());
    }

    @Test
    public void testEligibleControllersConfigValidation() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Object var11_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        MetadataCache metadataCacheMock = (MetadataCache)Mockito.mock(MetadataCache.class);
        DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(controllerMock, metadataCacheMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicControllerConfig);
        Mockito.when((Object)metadataCacheMock.getAliveBrokers()).thenReturn(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(0, (Option)None$.MODULE$), new BrokerMetadata(1, (Option)None$.MODULE$)})));
        Properties props = new Properties();
        props.put("confluent.eligible.controllers", "0,1");
        config.dynamicConfig().validate(props, false);
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        props.put("confluent.eligible.controllers", "1,2,3");
        config.dynamicConfig().validate(props, false);
        props.put("confluent.eligible.controllers", "2,3");
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, false));
        props.put("confluent.eligible.controllers", "");
        config.dynamicConfig().validate(props, false);
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        boolean bl8 = true;
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)origProps, bl8);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn(Iterable$.MODULE$.empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(LogConfig$.MODULE$.apply());
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        boolean bl8 = true;
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)origProps, bl8);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        origProps.put("ssl.keystore.type", "JKS");
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Map validProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        Map securityPropsWithoutListenerPrefix = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)securityPropsWithoutListenerPrefix);
        Map nonDynamicProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)nonDynamicProps);
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        Map excludedTopicConfig = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Map validProps = (Map)Map$.MODULE$.empty();
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        boolean bl8 = true;
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)origProps, bl8);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testLogManagerConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", true, false);
    }

    @Test
    public void testTierDeletedPartitionsCoordinatorConfig() {
        ((IterableOnceOps)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), KafkaConfig$.MODULE$.TierTopicDeleteMaxInprogressPartitionsProp(), KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp()}))).foreach((Function1 & Serializable)config -> {
            DynamicBrokerConfigTest.$anonfun$testTierDeletedPartitionsCoordinatorConfig$1(this, config);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTierTasksConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "0", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "1", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "1", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "4", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "4", false, false);
    }

    @Test
    public void testBalancerConfigs() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", "200", false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", Boolean.toString(true), false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", "PAUSED", false, true);
    }

    @Test
    public void testBalancerValidateReconfiguration() {
        KafkaConfig kafkaConfig;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        props.put("confluent.balancer.throttle.bytes.per.second", "200");
        boolean bl8 = true;
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)props, bl8);
        kafkaConfig = null;
        KafkaConfig newConfig = kafkaConfig2;
        new DynamicBalancerConfig((KafkaBroker)kafkaServer).validateReconfiguration(newConfig);
    }

    @Test
    public void testBalancerReconfigureNegativeThrottle() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_AUTO_THROTTLE.toString(), false, false);
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_MIN.toString(), false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    @Test
    public void testConnectionRateQuotaFloor() {
        String listenerMaxConnectionCreationFloorProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "30", false, false);
    }

    @Test
    public void testQuotaMultiplier() {
        String produceMultiplierProp = "confluent.quota.tenant.produce.multiplier";
        this.verifyConfigUpdate(produceMultiplierProp, "1.5", true, false);
        this.verifyConfigUpdate(produceMultiplierProp, "2.0", false, false);
        String fetchMultiplierProp = "confluent.quota.tenant.fetch.multiplier";
        this.verifyConfigUpdate(fetchMultiplierProp, "1.5", true, false);
        this.verifyConfigUpdate(fetchMultiplierProp, "2.0", false, false);
        this.verifyConfigUpdate(produceMultiplierProp, "0.5", true, true);
        this.verifyConfigUpdate(fetchMultiplierProp, "0.5", true, true);
        this.verifyConfigUpdate(produceMultiplierProp, "1.0", true, false);
        this.verifyConfigUpdate(fetchMultiplierProp, "1.0", true, false);
    }

    @Test
    public void testUserQuotasEnable() {
        this.verifyConfigUpdate("confluent.quota.tenant.user.quotas.enable", Boolean.toString(true), false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, Map<String, String> validProps, Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = props.put(k, v);
            return object;
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            Object object = props.put(k, v);
            return object;
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        KafkaConfig kafkaConfig;
        KafkaConfig kafkaConfig2;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        boolean bl8 = true;
        KafkaConfig kafkaConfig3 = kafkaConfig2 = new KafkaConfig((java.util.Map)props, bl8);
        kafkaConfig2 = null;
        KafkaConfig configWithoutSecret = kafkaConfig3;
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean bl9 = true;
        KafkaConfig kafkaConfig4 = kafkaConfig = new KafkaConfig((java.util.Map)props, bl9);
        kafkaConfig = null;
        KafkaConfig configWithSecret = kafkaConfig4;
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        boolean bl9 = true;
        KafkaConfig newConfigWithSameSecret = new KafkaConfig((java.util.Map)props, bl9);
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        boolean bl10 = true;
        KafkaConfig newConfigWithNewAndOldSecret = new KafkaConfig((java.util.Map)props, bl10);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        boolean bl11 = true;
        KafkaConfig newConfigWithNewSecret = new KafkaConfig((java.util.Map)props, bl11);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        boolean bl8 = true;
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, bl8));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean bl = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, bl));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;

            public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext x$1, List<AclBinding> x$2, Optional<String> x$3) {
                return super.createAcls(x$1, x$2, x$3);
            }

            public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext x$1, List<AclBindingFilter> x$2, Optional<String> x$3) {
                return super.deleteAcls(x$1, x$2, x$3);
            }

            public int aclCount() {
                return super.aclCount();
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
                return super.authorizeByResourceType(x$1, x$2, x$3);
            }

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava();
            }

            public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
                return null;
            }

            public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
                return null;
            }

            public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(null);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        Assertions.assertThrows(Throwable.class, () -> kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer));
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testHttpServerConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1
        implements KafkaHttpServer,
        Reconfigurable {
            private volatile String foobar;

            public boolean isNew() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStarting() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isRunning() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStopping() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isTerminated() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isFailed() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void start() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void stop() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public Optional<Throwable> getError() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStarted() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStarted(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStopped() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStopped(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public String foobar() {
                return this.foobar;
            }

            public void foobar_$eq(String x$1) {
                this.foobar = x$1;
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo.bar"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.foobar_$eq(configs.get("foo.bar").toString());
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(DynamicBrokerConfigTest $outer) {
                this.foobar = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1 httpServer = new Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(null);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.expect((Object)kafkaServer.authorizer()).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)kafkaServer.httpServer()).andReturn((Object)new Some((Object)httpServer)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        try {
            kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        }
        catch (Throwable throwable) {}
        props.put("foo.bar", "fozbaz");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"fozbaz", (Object)httpServer.foobar());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.secure.ssl.keystore.type", "ssl.keystore.type"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.sasl_ssl.plain.sasl.jaas.config", "sasl.jaas.config"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"some.config"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogRollTimeMillisProp(), KafkaConfig$.MODULE$.LogRollTimeHoursProp()})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient));
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testConfiguredInstanceInitializedWithDynamicConfig() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String quotaProp = "quota";
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(quotaProp, "static_quota");
        props.put(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), TestQuotaCallback.class.getName());
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties updatedProps = new Properties();
        updatedProps.put(quotaProp, "dynamic_quota");
        config.dynamicConfig().updateDefaultConfig(updatedProps, config.dynamicConfig().updateDefaultConfig$default$2());
        ClientQuotaCallback quotaCallback = (ClientQuotaCallback)config.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class);
        Assertions.assertEquals((Object)"dynamic_quota", (Object)((TestQuotaCallback)quotaCallback).defaultQuota());
    }

    @Test
    public void testReplicaManagerFetchMaxBytesChange() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "2048");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048), config.values().get(KafkaConfig$.MODULE$.FetchMaxBytes()));
    }

    @Test
    public void testReplicaManagerTierMaxPartitionFetchBytesOverride() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "1024000");
        boolean bl8 = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, bl8);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "2048000");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048000), config.values().get(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp()));
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        boolean bl = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, bl);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)Defaults$.MODULE$.MessageMaxBytes(), (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientJaasConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("sasl.jaas.config"));
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("listener.name.sasl_ssl.sasl.jaas.config"));
        Assertions.assertTrue((boolean)var3_3.isClientSaslJaasConfig("test.dynamic.login.sasl.jaas.config"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoginConfigChange() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        DynamicLoginContext context = (DynamicLoginContext)var3_3.reconfigurableContexts().head();
        HashMap<String, String> oldConfigs = new HashMap<String, String>();
        HashMap<String, String> newConfigs = new HashMap<String, String>();
        oldConfigs.put("test.dynamic.login.username", "alice");
        oldConfigs.put("test.dynamic.login.password", "alice-password");
        newConfigs.put("test.dynamic.login.username", "alice");
        newConfigs.put("test.dynamic.login.password", "alice-password");
        Assertions.assertFalse((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertFalse((boolean)context.needsReconfigure(Collections.emptyMap(), Collections.emptyMap()));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.emptyMap(), newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.emptyMap()));
        newConfigs.put("test.dynamic.login.password", "alice-new-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        newConfigs.put("test.dynamic.login.username", "bob");
        newConfigs.put("test.dynamic.login.password", "bob-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.singletonMap("test.dynamic.login.username", "alice")));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.singletonMap("test.dynamic.login.username", "alice"), newConfigs));
    }

    @Test
    public void testSaslCredentialRotationWithPrefixedCredentials() {
        this.verifyCredentialRotation("test.dynamic.login.username", "test.dynamic.login.password");
    }

    @Test
    public void testSaslCredentialRotationWithUnprefixedCredentials() {
        this.verifyCredentialRotation("login.username", "login.password");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSaslCredentialRotationWithSharedJaasConfig() {
        void var6_6;
        void var7_7;
        String usernameConfig = "login.username";
        String passwordConfig = "login.password";
        Set pluginPrefixes = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test.plugin1.", "test.plugin2."}));
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, (Set<String>)pluginPrefixes);
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Set credentialConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)var7_7.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)2, (int)var7_7.reconfigurableContexts().size());
        scala.collection.mutable.Set contexts = var7_7.reconfigurableContexts();
        Assertions.assertEquals((Object)pluginPrefixes, (Object)((IterableOnceOps)contexts.map((Function1 & Serializable)x$3 -> x$3.prefix())).toSet());
        Assertions.assertEquals((Object)pluginPrefixes.map((Function1 & Serializable)x$4 -> new StringBuilder(16).append((String)x$4).append("sasl.jaas.config").toString()), (Object)contexts.map((Function1 & Serializable)x$5 -> x$5.saslJaasConfigName()));
        contexts.foreach((Function1 & Serializable)context -> {
            DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(this, credentialConfigs, context);
            return BoxedUnit.UNIT;
        });
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$2((KafkaConfig)var6_6, dynamicProps);
        contexts.foreach((Function1 & Serializable)context -> {
            this.verifyCredential(context, "alice", "alice-new-password");
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(this, dynamicProps, usernameConfig, passwordConfig, contexts, (KafkaConfig)var6_6, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewSaslCredentials() {
        void var3_3;
        void var4_4;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        this.verifyCredential((DynamicLoginContext)var4_4.reconfigurableContexts().head(), "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty("test.another.login.security.protocol", "SASL_PLAINTEXT");
        dynamicProps.setProperty("test.another.login.sasl.mechanism", "PLAIN");
        dynamicProps.setProperty("test.another.login.username", "another");
        dynamicProps.setProperty(new StringBuilder(35).append("test.another.login.").append("sasl.jaas.config").toString(), new StringBuilder(64).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"username\" password_config=\"password\";").toString());
        dynamicProps.setProperty(new StringBuilder(52).append("test.another.login.").append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        dynamicProps.setProperty("test.another.login.password", "another-password");
        DynamicBrokerConfigTest.updateConfig$3((KafkaConfig)var3_3, dynamicProps);
        Assertions.assertEquals((int)2, (int)var4_4.reconfigurableContexts().size());
        DynamicLoginContext oldContext = (DynamicLoginContext)((IterableOps)var4_4.reconfigurableContexts().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$1(x$8)))).head();
        this.verifyCredential(oldContext, "alice", "alice-password");
        DynamicLoginContext newContext = (DynamicLoginContext)((IterableOps)var4_4.reconfigurableContexts().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$2(x$9)))).head();
        this.verifyCredential(newContext, "another", "another-password");
        dynamicProps.remove("test.another.login.password");
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable)() -> DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$3((KafkaConfig)var3_3, dynamicProps)), ClassTag$.MODULE$.apply(ConfigException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCredentialRotation(String usernameConfig, String passwordConfig) {
        void var5_5;
        void var6_6;
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty("test.static.login.security.protocol", "SASL_SSL");
        props.setProperty("test.static.login.sasl.mechanism", "PLAIN");
        props.setProperty(new StringBuilder(34).append("test.static.login.").append("sasl.jaas.config").toString(), new StringBuilder(55).append(PlainLoginModule.class.getName()).append(" required username=\"static\" password=\"static-password\";").toString());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Set credentialConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)var6_6.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)1, (int)var6_6.reconfigurableContexts().size());
        DynamicLoginContext context = (DynamicLoginContext)var6_6.reconfigurableContexts().head();
        Assertions.assertEquals((Object)"test.dynamic.login.", (Object)context.prefix());
        Assertions.assertEquals((Object)"test.dynamic.login.sasl.jaas.config", (Object)context.saslJaasConfigName());
        Assertions.assertEquals((Object)credentialConfigs, (Object)context.dynamicConfigs());
        this.verifyCredential(context, "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$4((KafkaConfig)var5_5, dynamicProps);
        this.verifyCredential(context, "alice", "alice-new-password");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$verifyCredentialRotation$1(this, dynamicProps, usernameConfig, passwordConfig, context, (KafkaConfig)var5_5, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFileBasedLoginNotHandledAsDynamicConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty(new StringBuilder(35).append("test.dynamic.login.").append("sasl.jaas.config").toString(), new StringBuilder(50).append(DynamicPlainLoginModule.class.getName()).append(" required credentials_path=\"/tmp/credentials.txt\";").toString());
        props.setProperty(new StringBuilder(52).append("test.dynamic.login.").append("sasl.login.callback.handler.class").toString(), FileBasedDynamicPlainLoginCallbackHandler.class.getName());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)var3_3.reconfigurableContexts());
    }

    private Properties kafkaPropsWithDynamicLogin(String usernameConfig, String passwordConfig, Set<String> pluginPrefixes) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "encoder-secret");
        props.setProperty(usernameConfig, "alice");
        props.setProperty(passwordConfig, "alice-password");
        pluginPrefixes.foreach((Function1 & Serializable)prefix -> {
            props.setProperty(new StringBuilder(17).append((String)prefix).append("security.protocol").toString(), "SASL_SSL");
            props.setProperty(new StringBuilder(14).append((String)prefix).append("sasl.mechanism").toString(), "PLAIN");
            props.setProperty(new StringBuilder(16).append((String)prefix).append("sasl.jaas.config").toString(), new StringBuilder(48).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"").append(usernameConfig).append("\" password_config=\"").append(passwordConfig).append("\";").toString());
            return props.setProperty(new StringBuilder(33).append((String)prefix).append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        });
        return props;
    }

    private Set<String> kafkaPropsWithDynamicLogin$default$3() {
        return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test.dynamic.login."}));
    }

    private Tuple2<KafkaConfig, DynamicLoginManager> createKafkaConfigWithDynamicLogin(Properties props) {
        KafkaConfig kafkaConfig;
        boolean bl = true;
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((java.util.Map)props, bl);
        kafkaConfig = null;
        KafkaConfig config = kafkaConfig2;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{zkClient});
        config.dynamicConfig().initialize((Option)new Some((Object)zkClient));
        return new Tuple2((Object)config, (Object)config.dynamicConfig().dynamicLoginManager());
    }

    private void verifyCredential(DynamicLoginContext context, String username, String password) {
        Assertions.assertEquals((Object)new DynamicPlainCredential(username, password.toCharArray()), (Object)context.loginManager().subject().getPrivateCredentials().iterator().next());
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    public static final /* synthetic */ void $anonfun$testTierDeletedPartitionsCoordinatorConfig$1(DynamicBrokerConfigTest $this, String config) {
        $this.verifyConfigUpdate(config, "-1", true, true);
        $this.verifyConfigUpdate(config, "-1", false, true);
        $this.verifyConfigUpdate(config, "0", true, true);
        $this.verifyConfigUpdate(config, "0", false, true);
        $this.verifyConfigUpdate(config, "10000", false, false);
        $this.verifyConfigUpdate(config, "20000", true, false);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$5, Properties props$3) {
        if (perBrokerConfig$1) {
            config$5.dynamicConfig().updateBrokerConfig(0, config$5.dynamicConfig().toPersistentProps(props$3, perBrokerConfig$1), config$5.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$5.dynamicConfig().updateDefaultConfig(props$3, config$5.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$6, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$6.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$6, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$6.originals().get(name));
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(DynamicBrokerConfigTest $this, Set credentialConfigs$1, DynamicLoginContext context) {
        Assertions.assertEquals((Object)credentialConfigs$1, (Object)context.dynamicConfigs());
        $this.verifyCredential(context, "alice", "alice-password");
    }

    private static final void updateConfig$2(KafkaConfig config$7, Properties dynamicProps$1) {
        config$7.dynamicConfig().updateBrokerConfig(0, config$7.dynamicConfig().toPersistentProps(dynamicProps$1, true), config$7.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(DynamicBrokerConfigTest $this, Properties dynamicProps$1, String usernameConfig$1, String passwordConfig$1, scala.collection.mutable.Set contexts$1, KafkaConfig config$7, int x$6) {
        dynamicProps$1.setProperty(usernameConfig$1, "bob");
        dynamicProps$1.setProperty(passwordConfig$1, "bob-password");
        DynamicBrokerConfigTest.updateConfig$2(config$7, dynamicProps$1);
        contexts$1.foreach((Function1 & Serializable)context -> {
            $this.verifyCredential(context, "bob", "bob-password");
            return BoxedUnit.UNIT;
        });
    }

    private static final void updateConfig$3(KafkaConfig config$8, Properties dynamicProps$2) {
        config$8.dynamicConfig().updateBrokerConfig(0, config$8.dynamicConfig().toPersistentProps(dynamicProps$2, true), config$8.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$1(DynamicLoginContext x$8) {
        String string = x$8.saslJaasConfigName();
        String string2 = "test.dynamic.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$2(DynamicLoginContext x$9) {
        String string = x$9.saslJaasConfigName();
        String string2 = "test.another.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testNewSaslCredentials$3(KafkaConfig config$8, Properties dynamicProps$2) {
        config$8.dynamicConfig().validate(dynamicProps$2, true);
    }

    private static final void updateConfig$4(KafkaConfig config$9, Properties dynamicProps$3) {
        config$9.dynamicConfig().updateBrokerConfig(0, config$9.dynamicConfig().toPersistentProps(dynamicProps$3, true), config$9.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$verifyCredentialRotation$1(DynamicBrokerConfigTest $this, Properties dynamicProps$3, String usernameConfig$2, String passwordConfig$2, DynamicLoginContext context$1, KafkaConfig config$9, int x$11) {
        dynamicProps$3.setProperty(usernameConfig$2, "bob");
        dynamicProps$3.setProperty(passwordConfig$2, "bob-password");
        DynamicBrokerConfigTest.updateConfig$4(config$9, dynamicProps$3);
        $this.verifyCredential(context$1, "bob", "bob-password");
    }
}

