/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.Constants$;
import kafka.server.IpConfigHandler;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005U2A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u00015!)Q\u0006\u0001C\u00015!)q\u0006\u0001C\u00015!)\u0011\u0007\u0001C\u00015!)1\u0007\u0001C\u00015\tYB)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKVs\u0017\u000e\u001e+fgRT!AC\u0006\u0002\rM,'O^3s\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\n\u0003\u0001\"Xm\u001d;Ja\"\u000bg\u000e\u001a7feVs'/Z:pYZ\f'\r\\3BI\u0012\u0014Xm]:\u0015\u0003m\u0001\"\u0001\u0005\u000f\n\u0005u\t\"\u0001B+oSRD#AA\u0010\u0011\u0005\u0001JS\"A\u0011\u000b\u0005\t\u001a\u0013aA1qS*\u0011A%J\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1s%A\u0003kk:LGOC\u0001)\u0003\ry'oZ\u0005\u0003U\u0005\u0012A\u0001V3ti\u0006)3\u000f[8vY\u0012\u0004\u0016M]:f%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u0007}\tQf\u001d5pk2$\u0007+\u0019:tK^KG\u000eZ2be\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018\r\u0015:pa\u0016\u0014H/[3tQ\t!q$A\u0017tQ>,H\u000e\u001a)beN,'+Z4be\u0012dWm]:PM^C\u0017\u000e^3ta\u0006\u001cW-\u0011:pk:$g+\u00197vKND#!B\u0010\u0002SMDw.\u001e7e!\u0006\u00148/\u001a(p]\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018\r\u0015:pa\u0016\u0014H/[3tQ\t1q$\u0001\u0011tQ>,H\u000e\u001a)beN,'+\u001a9mS\u000e\fG/[8o#V|G/\u0019*fg\u0016$\bFA\u0004 \u0001")
public class DynamicConfigChangeUnitTest {
    @Test
    public void testIpHandlerUnresolvableAddress() {
        IpConfigHandler configHandler = new IpConfigHandler(null);
        Properties props = new Properties();
        props.put("connection_creation_rate", "1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> configHandler.processConfigChanges("illegal-hostname", props));
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "* "));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " 6:102"));
    }

    @Test
    public void shouldParseNoneReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "none");
        Seq result = configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Constants$.MODULE$.NoReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    private static final Seq parse$1(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }
}

