/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.TierReplicaComponents;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013\u0005Q\u0005\u0003\u00040\u0001\u0001\u0006IA\n\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0003a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r5\u0003\u0001\u0015!\u0003G\u0011\u001dq\u0005A1A\u0005\u0002=Ca\u0001\u0016\u0001!\u0002\u0013\u0001\u0006bB+\u0001\u0005\u0004%\tA\u0016\u0005\u0007C\u0002\u0001\u000b\u0011B,\t\u000b\t\u0004A\u0011A2\t\u000bQ\u0004A\u0011A2\t\u000be\u0004A\u0011A2\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u000591m\u001c8gS\u001e\u001cX#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\tIC$\u0001\u0006d_2dWm\u0019;j_:L!a\u000b\u0015\u0003\u0007M+\u0017\u000f\u0005\u0002$[%\u0011a\u0006\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180F\u0001>!\tq\u0014)D\u0001@\u0015\t\u0001E#\u0001\u0005nKR\fG-\u0019;b\u0013\t\u0011uH\u0001\u000bN_\u000e\\7i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u0012G>tg-[4SKB|7/\u001b;pef\u0004\u0013a\u00037pO6\u000bg.Y4feN,\u0012A\u0012\t\u0004O):\u0005C\u0001%L\u001b\u0005I%B\u0001&\u0017\u0003\rawnZ\u0005\u0003\u0019&\u0013!\u0002T8h\u001b\u0006t\u0017mZ3s\u00031awnZ'b]\u0006<WM]:!\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYN,\u0012\u0001\u0015\t\u0004O)\n\u0006CA\u0012S\u0013\t\u0019FC\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0017Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7tA\u0005y\u0011\r\u001c;fe&\u001b(/T1oC\u001e,'/F\u0001X!\tAfL\u0004\u0002Z96\t!L\u0003\u0002\\-\u0005)Q\u000f^5mg&\u0011QLW\u0001\n)\u0016\u001cH/\u0016;jYNL!a\u00181\u0003'5{7m[!mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\u000b\u0005uS\u0016\u0001E1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:!\u0003!!X-\u0019:e_^tG#\u00013\u0011\u0005m)\u0017B\u00014\u001d\u0005\u0011)f.\u001b;)\u00059A\u0007CA5s\u001b\u0005Q'BA6m\u0003\r\t\u0007/\u001b\u0006\u0003[:\fqA[;qSR,'O\u0003\u0002pa\u0006)!.\u001e8ji*\t\u0011/A\u0002pe\u001eL!a\u001d6\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u000b;fgRD\u0015n\u001a5XCR,'/\\1sWB+'o]5ti\u0016t7-Z*j]\u001edW\rU1si&$\u0018n\u001c8)\u0005=1\bCA5x\u0013\tA(N\u0001\u0003UKN$\u0018A\f;fgRD\u0015n\u001a5XCR,'/\\1sWB+'o]5ti\u0016t7-Z'vYRL\u0007\u000f\\3QCJ$\u0018\u000e^5p]ND#\u0001\u0005<\u0002\r\u0005\u0004\b/\u001a8e)\u0011!W0a\u0003\t\u000by\f\u0002\u0019A@\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015a#A\u0004dYV\u001cH/\u001a:\n\t\u0005%\u00111\u0001\u0002\n!\u0006\u0014H/\u001b;j_:Dq!!\u0004\u0012\u0001\u0004\ty!A\u0003d_VtG\u000fE\u0002\u001c\u0003#I1!a\u0005\u001d\u0005\rIe\u000e^\u0001\u0007Q^lgi\u001c:\u0015\u0011\u0005e\u0011qDA\u0015\u0003\u007f\u00012aGA\u000e\u0013\r\ti\u0002\b\u0002\u0005\u0019>tw\rC\u0004\u0002\"I\u0001\r!a\t\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u00191%!\n\n\u0007\u0005\u001dBC\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\rA\u0012\u0002\u0019AA\u0016!\u0011\ti#a\u000f\u000f\t\u0005=\u0012q\u0007\t\u0004\u0003caRBAA\u001a\u0015\r\t)\u0004G\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005eB$\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\u0005u\"bAA\u001d9!1aP\u0005a\u0001\u0003\u001f\u0001")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    private final String topic;
    private final MockConfigRepository configRepository = new MockConfigRepository();
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable)config -> {
        TierLogComponents tierLogComponents;
        ApiVersion apiVersion;
        MockTime mockTime;
        MockConfigRepository mockConfigRepository;
        LogConfig logConfig;
        Seq x$12 = (Seq)config.logDirs().map((Function1 & Serializable)x$1 -> new File((String)x$1));
        CleanerConfig x$2 = new CleanerConfig(1, 0x400000L, 0.9, 0x100000, 0x2000000, Double.MAX_VALUE, 15000L, true, Integer.MAX_VALUE, "MD5", false);
        LogConfig logConfig2 = logConfig = LogConfig$.MODULE$.apply();
        logConfig = null;
        LogConfig x$3 = logConfig2;
        MockConfigRepository mockConfigRepository2 = mockConfigRepository = new MockConfigRepository();
        mockConfigRepository = null;
        MockConfigRepository x$4 = mockConfigRepository2;
        MockTime mockTime2 = mockTime = new MockTime();
        mockTime = null;
        MockTime x$5 = mockTime2;
        ApiVersion apiVersion2 = apiVersion = ApiVersion$.MODULE$.latestVersion();
        apiVersion = null;
        ApiVersion x$6 = apiVersion2;
        TierLogComponents tierLogComponents2 = tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        tierLogComponents = null;
        TierLogComponents x$7 = tierLogComponents2;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$3, x$4, x$2, x$5, x$6, x$7);
    });
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable)config -> new LogDirFailureChannel(config.logDirs().size()));
    private final TestUtils.MockAlterIsrManager alterIsrManager = new TestUtils.MockAlterIsrManager();

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    @AfterEach
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        TierReplicaComponents tierReplicaComponents;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        None$ none$7;
        None$ none$8;
        None$ none$9;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        ZkMetadataCache zkMetadataCache;
        KafkaScheduler scheduler = new KafkaScheduler(2, "kafka-scheduler-", true, false);
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "", (Option)None$.MODULE$);
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        LogManager x$5 = (LogManager)this.logManagers().head();
        boolean bl = false;
        int zkMetadataCache_brokerId = ((KafkaConfig)this.configs().head()).brokerId();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, bl);
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = (LogDirFailureChannel)this.logDirFailureChannels().head();
        TestUtils.MockAlterIsrManager x$9 = this.alterIsrManager();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$10 = none$9 = None$.MODULE$;
        none$9 = null;
        None$ x$12 = none$10;
        None$ none$11 = none$8 = None$.MODULE$;
        none$8 = null;
        None$ x$13 = none$11;
        None$ none$12 = none$7 = None$.MODULE$;
        none$7 = null;
        None$ x$14 = none$12;
        None$ none$13 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$15 = none$13;
        None$ none$14 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$16 = none$14;
        None$ none$15 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$17 = none$15;
        TierReplicaComponents tierReplicaComponents2 = tierReplicaComponents = TierReplicaComponents$.MODULE$.EMPTY();
        tierReplicaComponents = null;
        TierReplicaComponents x$18 = tierReplicaComponents2;
        None$ none$16 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$19 = none$16;
        None$ none$17 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$20 = none$17;
        None$ none$18 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$21 = none$18;
        ReplicaManager replicaManager = new ReplicaManager(x$2, metrics, (Time)time, (Scheduler)scheduler, x$5, quotaManager, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, x$18, (Option)x$19, (Option)x$20, (Option)x$21);
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.createPartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$22 = new TopicPartition(this.topic(), 0);
            None$ x$23 = None$.MODULE$;
            boolean x$24 = qual$1.getOrCreateLog$default$2();
            boolean x$25 = qual$1.getOrCreateLog$default$3();
            AbstractLog log0 = qual$1.getOrCreateLog(x$22, x$24, x$25, (Option)x$23);
            partition0.setLog(log0, false);
            partition0.updateAssignmentAndIsr((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().last()).brokerId()})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), LeaderRecoveryState.RECOVERED, Predef$.MODULE$.Set().empty(), (Option)None$.MODULE$);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
        }
        finally {
            replicaManager.shutdown(false);
            quotaManager.shutdown();
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        TierReplicaComponents tierReplicaComponents;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        None$ none$7;
        None$ none$8;
        None$ none$9;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        ZkMetadataCache zkMetadataCache;
        String topic1 = "foo1";
        String topic2 = "foo2";
        KafkaScheduler scheduler = new KafkaScheduler(2, "kafka-scheduler-", true, false);
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "", (Option)None$.MODULE$);
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        LogManager x$5 = (LogManager)this.logManagers().head();
        boolean bl = false;
        int zkMetadataCache_brokerId = ((KafkaConfig)this.configs().head()).brokerId();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, bl);
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = (LogDirFailureChannel)this.logDirFailureChannels().head();
        TestUtils.MockAlterIsrManager x$9 = this.alterIsrManager();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$10 = none$9 = None$.MODULE$;
        none$9 = null;
        None$ x$12 = none$10;
        None$ none$11 = none$8 = None$.MODULE$;
        none$8 = null;
        None$ x$13 = none$11;
        None$ none$12 = none$7 = None$.MODULE$;
        none$7 = null;
        None$ x$14 = none$12;
        None$ none$13 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$15 = none$13;
        None$ none$14 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$16 = none$14;
        None$ none$15 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$17 = none$15;
        TierReplicaComponents tierReplicaComponents2 = tierReplicaComponents = TierReplicaComponents$.MODULE$.EMPTY();
        tierReplicaComponents = null;
        TierReplicaComponents x$18 = tierReplicaComponents2;
        None$ none$16 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$19 = none$16;
        None$ none$17 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$20 = none$17;
        None$ none$18 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$21 = none$18;
        ReplicaManager replicaManager = new ReplicaManager(x$2, metrics, (Time)time, (Scheduler)scheduler, x$5, quotaManager, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, x$18, (Option)x$19, (Option)x$20, (Option)x$21);
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.createPartition(t1p0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            None$ x$23 = None$.MODULE$;
            boolean x$24 = qual$1.getOrCreateLog$default$2();
            boolean x$25 = qual$1.getOrCreateLog$default$3();
            AbstractLog topic1Log0 = qual$1.getOrCreateLog(t1p0, x$24, x$25, (Option)x$23);
            topic1Partition0.setLog(topic1Log0, false);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)topic1Log0.highWatermark(), (long)topic1Partition0Hw);
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)5L, (long)topic1Log0.highWatermark());
            Assertions.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.createPartition(t2p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            None$ x$27 = None$.MODULE$;
            boolean x$28 = qual$2.getOrCreateLog$default$2();
            boolean x$29 = qual$2.getOrCreateLog$default$3();
            AbstractLog topic2Log0 = qual$2.getOrCreateLog(t2p0, x$28, x$29, (Option)x$27);
            topic2Partition0.setLog(topic2Log0, false);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assertions.assertEquals((long)topic2Log0.highWatermark(), (long)topic2Partition0Hw);
            this.append(topic2Partition0, 15);
            topic2Partition0.localLogOrException().updateHighWatermark(15L);
            Assertions.assertEquals((long)15L, (long)topic2Log0.highWatermark());
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(10L);
            Assertions.assertEquals((long)10L, (long)topic1Log0.highWatermark());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assertions.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)10L, (long)topic1Partition0Hw);
        }
        finally {
            replicaManager.shutdown(false);
            quotaManager.shutdown();
            metrics.close();
            scheduler.shutdown();
        }
    }

    private void append(Partition partition, int count) {
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)i -> HighwatermarkPersistenceTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)i))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        AbstractLog qual$1 = partition.localLogOrException();
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(records, 0, x$3, x$4, x$5);
    }

    private long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

