/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KRaftClusterTestCreateTopicPolicy;
import kafka.server.KafkaConfig$;
import kafka.testkit.BrokerNode;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tue\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u00012\u0011\u0019a\u0004\u0001)A\u0005e!)Q\b\u0001C\u0001}!)Q\n\u0001C\u0001}!)q\n\u0001C\u0001}!)\u0011\u000b\u0001C\u0001}!)1\u000b\u0001C\u0001}!)Q\u000b\u0001C\u0001}!)q\u000b\u0001C\u0001}!)\u0011\f\u0001C\u00055\"I\u0011q\u0002\u0001\u0012\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\"\u0002!I!a)\t\r\u0005M\u0006\u0001\"\u0001?\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002x\u0002!I!!?\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a!9!\u0011\t\u0001\u0005\n\t\r\u0003\"\u0003B.\u0001E\u0005I\u0011\u0002B/\u0011\u0019\u0011\t\u0007\u0001C\u0001}!1!Q\r\u0001\u0005\u0002yBqA!\u001b\u0001\t\u0003\u0011Y\u0007\u0003\u0004\u0003~\u0001!\tA\u0010\u0005\u0007\u0005\u0003\u0003A\u0011\u0001 \u0003!-\u0013\u0016M\u001a;DYV\u001cH/\u001a:UKN$(BA\u0011#\u0003\u0019\u0019XM\u001d<fe*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002A\u0005\u0019An\\4\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u000bMdg\r\u000e6\u000b\u0003]\n1a\u001c:h\u0013\tIDG\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u0003m_\u001e\u0014\u0014!\u00027pOJ\u0002\u0013!\u0007;fgR\u001c%/Z1uK\u000ecWo\u001d;fe\u0006sGm\u00117pg\u0016$\u0012a\u0010\t\u0003O\u0001K!!\u0011\u0015\u0003\tUs\u0017\u000e\u001e\u0015\u0003\r\r\u0003\"\u0001R&\u000e\u0003\u0015S!AR$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002I\u0013\u00069!.\u001e9ji\u0016\u0014(B\u0001&7\u0003\u0015QWO\\5u\u0013\taUI\u0001\u0003UKN$\u0018a\f;fgR\u001c%/Z1uK\u000ecWo\u001d;fe\u0006sGmV1ji\u001a{'O\u0011:pW\u0016\u0014\u0018J\u001c*v]:LgnZ*uCR,\u0007FA\u0004D\u0003%\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f\u0019&\u001cH\u000fR3mKR,Gk\u001c9jG\"\u0012\u0001bQ\u0001(i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3De\u0016\fG/Z!oI6\u000bg.\u001f+pa&\u001c7\u000f\u000b\u0002\n\u0007\u0006\u0001B/Z:u\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0003\u0015\r\u000bq\u0005^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s/&$\b.\u00113wKJ$\u0018n]3e!>\u0014HOW3s_\"\u00121bQ\u0001Di\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014x+\u001b;i\u0003\u00124XM\u001d;jg\u0016$\u0007j\\:u\u0003:$\u0007k\u001c:u\t&4g-\u001a:f]R4%o\\7T_\u000e\\W\r^*feZ,'\u000f\u000b\u0002\r\u0007\u00069Bm\\(o'R\f'\u000f^3e\u0017\u000647.Y\"mkN$XM\u001d\u000b\u00057\u001edg\u000e\u0006\u0002@9\")Q,\u0004a\u0001=\u00061\u0011m\u0019;j_:\u0004BaJ0b\u007f%\u0011\u0001\r\u000b\u0002\n\rVt7\r^5p]F\u0002\"AY3\u000e\u0003\rT!\u0001\u001a\u0012\u0002\u000fQ,7\u000f^6ji&\u0011am\u0019\u0002\u0014\u0017\u000647.Y\"mkN$XM\u001d+fgR\\\u0015\u000e\u001e\u0005\bQ6\u0001\n\u00111\u0001j\u0003IqW/\\\"p]R\u0014x\u000e\u001c7fe:{G-Z:\u0011\u0005\u001dR\u0017BA6)\u0005\rIe\u000e\u001e\u0005\u0006[6\u0001\r![\u0001\u000f]Vl'I]8lKJtu\u000eZ3t\u0011\u0015yW\u00021\u0001q\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000fE\u0003(cN4\u00180\u0003\u0002sQ\tIa)\u001e8di&|gN\r\t\u0003ERL!!^2\u0003\u0019Q+7\u000f^&ji:{G-Z:\u0011\u0005\t<\u0018B\u0001=d\u0005)\u0011%o\\6fe:{G-\u001a\t\bu\u0006\r\u0011\u0011BA\u0005\u001d\tYx\u0010\u0005\u0002}Q5\tQP\u0003\u0002\u007fI\u00051AH]8pizJ1!!\u0001)\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u0003A\u0003c\u0001>\u0002\f%!\u0011QBA\u0004\u0005\u0019\u0019FO]5oO\u0006\tCm\\(o'R\f'\u000f^3e\u0017\u000647.Y\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0003\u0016\u0004S\u0006U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0002&\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002}M,g\u000e\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;U_\n{WO\u001c3Q_J$XK\u001c;jY\u0006cGN\u0011:pW\u0016\u00148\u000f\u0015:pa\u0006<\u0017\r^3e)\u0019\tY#a\u0012\u0002XQ!\u0011QFA\"!\u0011\ty#a\u0010\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003o\tI$\u0001\u0004d_6lwN\u001c\u0006\u0004G\u0005m\"bAA\u001fm\u00051\u0011\r]1dQ\u0016LA!!\u0011\u00022\t9B)Z:de&\u0014Wm\u00117vgR,'OU3ta>t7/\u001a\u0005\u0007\u0003\u000bz\u00019A1\u0002\u000f\rdWo\u001d;fe\"9\u0011\u0011J\bA\u0002\u0005-\u0013\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BA'\u0003'j!!a\u0014\u000b\t\u0005E\u0013QG\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t)&a\u0014\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u0005es\u00021\u0001\u0002\\\u0005Aq/Y5u)&lW\r\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0011\u0011,(/\u0019;j_:T1!!\u001a)\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003S\nyF\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002+]\f\u0017\u000e\u001e$peJ+hN\\5oO\n\u0013xn[3sgR1\u0011qNAF\u0003\u001f#B!!\u001d\u0002\nB1\u00111OA?\u0003\u0007sA!!\u001e\u0002z9\u0019A0a\u001e\n\u0003%J1!a\u001f)\u0003\u001d\u0001\u0018mY6bO\u0016LA!a \u0002\u0002\n\u00191+Z9\u000b\u0007\u0005m\u0004\u0006E\u00020\u0003\u000bK1!a\"!\u00051\u0011%o\\6feN+'O^3s\u0011\u0019\t)\u0005\u0005a\u0002C\"1\u0011Q\u0012\tA\u0002%\fQaY8v]RDq!!\u0017\u0011\u0001\u0004\tY&A\u001etK:$G)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000fV8C_VtG\rU8siVsG/\u001b7Ce>\\WM]:Qe>\u0004\u0018mZ1uK\u0012$\"\"!\f\u0002\u0016\u0006e\u00151TAP\u0011\u001d\t9*\u0005a\u0001\u0003\u0007\u000b1\u0002Z3ti&t\u0017\r^5p]\"9\u0011\u0011J\tA\u0002\u0005-\u0003BBAO#\u0001\u0007\u0011.A\nfqB,7\r^3e\u0005J|7.\u001a:D_VtG\u000fC\u0004\u0002ZE\u0001\r!a\u0017\u0002KM,g\u000e\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;U_\n{WO\u001c3Q_J$HCBA\u0017\u0003K\u000b\t\fC\u0004\u0002\u0018J\u0001\r!a*\u0011\t\u0005%\u0016QV\u0007\u0003\u0003WS1!!\u0015#\u0013\u0011\ty+a+\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\t\u000f\u0005%#\u00031\u0001\u0002L\u00059C/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:B]\u0012\u0004VM\u001d4pe6\u0014V-Y:tS\u001etW.\u001a8uQ\t\u00192)A\ndQ\u0016\u001c7NU3qY&\u001c\u0017-T1oC\u001e,'\u000fF\u0003@\u0003w\u000bi\f\u0003\u0004\u0002FQ\u0001\r!\u0019\u0005\b\u0003\u007f#\u0002\u0019AAa\u0003=)\u0007\u0010]3di\u0016$\u0007j\\:uS:<\u0007CBA:\u0003\u0007\f9-\u0003\u0003\u0002F\u0006\u0005%\u0001\u0002'jgR\u0004baJAeS\u00065\u0017bAAfQ\t1A+\u001e9mKJ\u0002b!a\u001d\u0002D\u0006=\u0007cA\u0014\u0002R&\u0019\u00111\u001b\u0015\u0003\u000f\t{w\u000e\\3b]\u0006YBO]1og2\fG/\u001a)beRLG/[8o\u0013:4w\u000eV8TKF$B!!7\u0002^B1\u00111OA?\u00037\u0004R!a\u001d\u0002~%Dq!a8\u0016\u0001\u0004\t\t/\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a9\u0002n\u0006=XBAAs\u0015\u0011\t9/!;\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003W\fAA[1wC&!\u0011QYAs!\u0011\t\t0a=\u000e\u0005\u0005U\u0012\u0002BA{\u0003k\u0011!\u0003V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00138g_\u0006\u0019r/Y5u\r>\u0014Hk\u001c9jG2K7\u000f^5oOR9q(a?\u0003\u000e\tM\u0001bBA\u007f-\u0001\u0007\u0011q`\u0001\u0006C\u0012l\u0017N\u001c\t\u0005\u0005\u0003\u0011I!\u0004\u0002\u0003\u0004)!\u0011Q B\u0003\u0015\u0011\u00119!!\u000f\u0002\u000f\rd\u0017.\u001a8ug&!!1\u0002B\u0002\u0005\u0015\tE-\\5o\u0011\u001d\u0011yA\u0006a\u0001\u0005#\tq\"\u001a=qK\u000e$X\r\u001a)sKN,g\u000e\u001e\t\u0007\u0003g\ni(!\u0003\t\u000f\tUa\u00031\u0001\u0003\u0012\u0005qQ\r\u001f9fGR,G-\u00112tK:$\u0018\u0001E5oGJ,W.\u001a8uC2\fE\u000e^3s)\u0019\u0011YBa\t\u0003&A1\u00111OA?\u0005;\u0001B!a\f\u0003 %!!\u0011EA\u0019\u0005!\t\u0005/[#se>\u0014\bbBA\u007f/\u0001\u0007\u0011q \u0005\b\u0005O9\u0002\u0019\u0001B\u0015\u0003\u001d\u0019\u0007.\u00198hKN\u0004b!a\u001d\u0002~\t-\u0002cB\u0014\u0002J\n5\"\u0011\b\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)!!1GA\u001b\u0003\u0019\u0019wN\u001c4jO&!!q\u0007B\u0019\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0004b!a\u001d\u0002~\tm\u0002\u0003\u0002B\u0001\u0005{IAAa\u0010\u0003\u0004\ti\u0011\t\u001c;fe\u000e{gNZ5h\u001fB\fqB^1mS\u0012\fG/Z\"p]\u001aLwm\u001d\u000b\t\u0005\u000b\u0012YE!\u0014\u0003XA9!0a\u0001\u0003.\t\u001d\u0003\u0003CAr\u0005\u0013\nI!!\u0003\n\t\u0005\u0015\u0011Q\u001d\u0005\b\u0003{D\u0002\u0019AA\u0000\u0011\u001d\u0011y\u0005\u0007a\u0001\u0005#\n\u0001\"\u001a=qK\u000e$X\r\u001a\t\bu\u0006\r!Q\u0006B*!\u0019\t\u0019(! \u0003VA9q%!3\u0002\n\u0005%\u0001\"\u0003B-1A\u0005\t\u0019AAh\u0003))\u0007\u0010[1vgRLg/Z\u0001\u001am\u0006d\u0017\u000eZ1uK\u000e{gNZ5hg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003`)\"\u0011qZA\u000b\u0003m!Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\"\u0012!dQ\u0001\u001bi\u0016\u001cHoU3u\u0019><GG[\"p]\u001aLw-\u001e:bi&|gn\u001d\u0015\u00037\r\u000b1\u0002\\3hC\u000eL\u0018\t\u001c;feR1!1\u0004B7\u0005_Bq!!@\u001d\u0001\u0004\ty\u0010C\u0004\u0003rq\u0001\rAa\u001d\u0002\u0013I,7o\\;sG\u0016\u001c\bc\u0002>\u0002\u0004\t5\"Q\u000f\t\u0007\u0003g\niHa\u001e\u0011\t\t\u0005!\u0011P\u0005\u0005\u0005w\u0012\u0019AA\u0006D_:4\u0017nZ#oiJL\u0018A\u0006;fgRdUmZ1ds\u0006cG/\u001a:D_:4\u0017nZ:)\u0005u\u0019\u0015a\r;fgR\u001c\u0006n\\;mI\u0006\u0003\b\u000f\\=De\u0016\fG/\u001a+pa&\u001c7\u000fU8mS\u000eLHk\\\"sK\u0006$X\rU1si&$\u0018n\u001c8tQ\tq2\tK\u0004\u0001\u0005\u000f\u0013iIa$\u0011\u0007\u0011\u0013I)C\u0002\u0003\f\u0016\u00131\u0001V1h\u0003\u00151\u0018\r\\;fC\t\u0011\t*A\u0006j]R,wM]1uS>t\u0007f\u0002\u0001\u0003\u0016\n5%1\u0014\t\u0004\t\n]\u0015b\u0001BM\u000b\n9A+[7f_V$h$\u0001=")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)new StringBuilder(1).append(KRaftClusterTest.class.getCanonicalName()).append("2").toString());

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}))));
            }
        }
    }

    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2", "test-topic-3"}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
            }
        }
    }

    @Test
    public void testClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var11_19;
                Tuple2 tuple2;
                ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit")}))).asJava());
                ClientQuotaFilter clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit")}))).asJava());
                java.util.Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99))})), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0))})), clientQuotaFilter, 3, admin);
                Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null)})), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("request_percentage", null)})), clientQuotaFilter, 0, admin);
                describeResult = null;
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0))})), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                ClientQuotaEntity entity2 = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"some-client")}))).asJava());
                clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client")}))).asJava());
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0))})), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                clientQuotaFilter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit")}))).asJava());
                long l3 = 15000L;
                long l4 = 100L;
                long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    Some some;
                    try {
                        java.util.Map $anonfun$testClientQuotas$5_results = (java.util.Map)admin.describeClientQuotas(clientQuotaFilter).entities().get();
                        Assertions.assertEquals((int)2, (int)$anonfun$testClientQuotas$5_results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                        Object var25_16 = null;
                        some = None$.MODULE$;
                    }
                    catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                        some = new Some((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                    }
                    Object var24_14 = null;
                    Some tryUntilNoAssertionError_computeUntilTrue_result = some;
                    if (((Option)tryUntilNoAssertionError_computeUntilTrue_result).isEmpty()) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + l3) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
                }
                Tuple2 tuple22 = tuple2;
                Object var14_13 = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                Option tryUntilNoAssertionError_error = (Option)tuple23._1();
                boolean bl = tuple23._2$mcZ$sp();
                if (!bl) {
                    throw (Throwable)var11_19.get();
                }
                tuple23 = null;
                var11_19 = null;
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, x$2) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString())}));
        int n = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(n, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, broker) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(20).append(nodes.externalListenerName().value()).append("://advertised-host-").append(broker.id()).append(":").append(broker.id() + 100).toString())}));
        int n = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(n, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    private void doOnStartedKafkaCluster(int numControllerNodes, int numBrokerNodes, Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>> brokerPropertyOverrides, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(numControllerNodes).setNumBrokerNodes(numBrokerNodes).build();
        nodes.brokerNodes().values().forEach(broker -> broker.propertyOverrides().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerPropertyOverrides.apply((Object)nodes, broker)).asJava()));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private int doOnStartedKafkaCluster$default$1() {
        return 1;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        scala.collection.immutable.Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_10;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            scala.collection.immutable.Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), l));
        }
        Tuple2 tuple22 = tuple2;
        Object var10_7 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Seq runningBrokerServers = (scala.collection.immutable.Seq)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(0).append(new StringBuilder(58).append("After ").append(waitTime.toMillis()).append(" ms at least ").append(count).append(" broker(s) should be in RUNNING state, ").toString()).append(new StringBuilder(24).append("but only ").append(var5_10.size()).append(" broker(s) are.").toString()).toString());
        return var5_10;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_11;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), l));
        }
        Tuple2 tuple22 = tuple2;
        Object var11_8 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(0).append(new StringBuilder(44).append("After ").append(waitTime.toMillis()).append(" ms Broker is only aware of ").append(var6_11.nodes().size()).append(" brokers, ").toString()).append(new StringBuilder(18).append("but ").append(expectedBrokerCount).append(" are expected.").toString()).toString());
        return var6_11;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Integer>> assignments = new HashMap<Integer, java.util.List<Integer>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
                assignments.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)));
                assignments.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)));
                assignments.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)));
                admin.createTopics(Collections.singletonList(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
                Assertions.assertEquals(Collections.emptyMap(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)"The reassignment never completed.");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
                scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> seq = (scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>>)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
                scala.collection.immutable.Seq expectedMapping = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Seq[]{(scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 0})), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))}));
                long l3 = 15000L;
                long l4 = 100L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    boolean bl;
                    java.util.Map $anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap;
                    if (($anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap = (java.util.Map)admin.describeTopics(Collections.singleton("foo")).allTopicNames().get()).containsKey("foo")) {
                        seq = this.translatePartitionInfoToSeq(((TopicDescription)$anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap.get("foo")).partitions());
                        bl = expectedMapping.equals(seq);
                    } else {
                        bl = false;
                    }
                    Object var20_13 = null;
                    if (bl) break;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                        Assertions.fail((String)new StringBuilder(57).append("Timed out waiting for replica assignments for topic foo. ").append(new StringBuilder(15).append("Wanted: ").append(expectedMapping).append(". Got: ").append(seq).toString()).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
                }
                this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true})))}))));
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().map((Function1 & Serializable)partition -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toSeq())).toSeq();
    }

    private void waitForTopicListing(Admin admin, scala.collection.immutable.Seq<String> expectedPresent, scala.collection.immutable.Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        expectedPresent.foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$9)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            ((Iterable)admin.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$10)));
            if (topicsNotFound.isEmpty() && set.isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala(topicsNotFound).asScala()).append(" and NOT find topic(s): ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private scala.collection.immutable.Seq<ApiError> incrementalAlter(Admin admin, scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ConfigResource resource = (ConfigResource)x0$1._1();
            scala.collection.immutable.Seq ops = (scala.collection.immutable.Seq)x0$1._2();
            Collection collection = configs.put(resource, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ops).asJava());
            return collection;
        });
        java.util.Map values = admin.incrementalAlterConfigs(configs).values();
        return (scala.collection.immutable.Seq)changes.map((Function1 & Serializable)x0$2 -> {
            ApiError apiError;
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    apiError = ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    apiError = ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    apiError = ApiError.fromThrowable((Throwable)throwable);
                }
            } else {
                throw new MatchError(null);
            }
            ApiError apiError2 = apiError;
            return apiError2;
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var11_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_10 = null;
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE})), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "6"), AlterConfigOp.OpType.SET)})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"log.roll.ms", (Object)"1234567"), new Tuple2((Object)"max.connections.per.ip", (Object)"6")})))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE, new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist.")})), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET)}))), new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET)}))), new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET)})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"segment.jitter.ms", (Object)"345")})))}))), false);
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE})), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "7"), AlterConfigOp.OpType.SET)})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"max.connections.per.ip", (Object)"7")})))}))), false);
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Logger[]{this.log(), this.log2()})).foreach((Function1 & Serializable)x$11 -> {
                    x$11.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE, new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource")})), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)broker2, (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET)}))), new Tuple2((Object)broker3, (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND)})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.log().getName(), (Object)"TRACE"), new Tuple2((Object)this.log2().getName(), (Object)"TRACE")})))}))), false);
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE, new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource")})), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)broker2, (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE)}))), new Tuple2((Object)broker3, (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT)})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.log().getName(), ((java.util.Map)initialLog4j.get((Object)broker2).get()).get(this.log().getName())), new Tuple2((Object)this.log2().getName(), ((java.util.Map)initialLog4j.get((Object)broker2).get()).get(this.log2().getName()))})))}))), false);
            }
        }
    }

    public scala.collection.immutable.Seq<ApiError> legacyAlter(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>> resources) {
        HashMap configs = new HashMap();
        resources.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ConfigResource resource = (ConfigResource)x0$1._1();
            scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)x0$1._2();
            Config config = configs.put(resource, new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries).asJava()));
            return config;
        });
        java.util.Map values = admin.alterConfigs(configs).values();
        return ((IterableOnceOps)resources.map((Function1 & Serializable)x0$2 -> {
            ApiError apiError;
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    apiError = ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    apiError = ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    apiError = ApiError.fromThrowable((Throwable)throwable);
                }
            } else {
                throw new MatchError(null);
            }
            ApiError apiError2 = apiError;
            return apiError2;
        })).toSeq();
    }

    @Test
    public void testLegacyAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ConfigResource defaultBroker = new ConfigResource(ConfigResource.Type.BROKER, "");
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE})), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("log.roll.ms", "1234567"), new ConfigEntry("max.connections.per.ip", "6")})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"log.roll.ms", (Object)"1234567"), new Tuple2((Object)"max.connections.per.ip", (Object)"6")})))}))), true);
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE})), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("log.roll.ms", "1234567")})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"log.roll.ms", (Object)"1234567")})))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiError[]{ApiError.NONE, new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist.")})), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("segment.jitter.ms", "345")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("not.a.real.topic.config", "789")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("segment.jitter.ms", "678")})))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"segment.jitter.ms", (Object)"345")})))}))), false);
            }
        }
    }

    @Test
    public void testShouldApplyCreateTopicsPolicyToCreatePartitions() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).setConfigProp("confluent.apply.create.topic.policy.to.create.partitions", "true").setConfigProp(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), KRaftClusterTestCreateTopicPolicy.class.getCanonicalName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.Map createResults = admin.createTopics(Arrays.asList(new NewTopic("foo", 1, (short)3), new NewTopic("bar", 2, (short)3), new NewTopic("baz", 4, (short)3))).values();
                ((KafkaFuture)createResults.get("foo")).get();
                ((KafkaFuture)createResults.get("bar")).get();
                Assertions.assertEquals(PolicyViolationException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)createResults.get("baz")).get()).getCause().getClass());
                java.util.Map increaseResults = admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)NewPartitions.increaseTo((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)NewPartitions.increaseTo((int)4))}))).asJava()).values();
                Assertions.assertEquals(PolicyViolationException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)increaseResults.get("foo")).get()).getCause().getClass());
                ((KafkaFuture)increaseResults.get("bar")).get();
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$1) {
        BrokerState brokerState = cluster$1.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$1) {
        return cluster$1.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$2) {
        return cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$3) {
        return cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final java.util.Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (java.util.Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (java.util.Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$testClientQuotas$3(ClientQuotaFilter filter$1, Admin admin$1) {
        return KRaftClusterTest.describeOrFail$1(filter$1, admin$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return results.getOrDefault(entity$1, Collections.emptyMap()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final java.util.Map alterThenDescribe$1(ClientQuotaEntity entity, scala.collection.immutable.Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_13;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)quotas).asJava())}))).asJava()).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = 15000L;
        long l2 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            java.util.Map map;
            java.util.Map map2 = map = KRaftClusterTest.describeOrFail$1(filter, admin$1);
            map = null;
            java.util.Map computeUntilTrue_result = map2;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple22 = tuple2;
        Object var10_10 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        java.util.Map describeResult = (java.util.Map)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        Assertions.assertTrue((boolean)bl, (String)"Broker never saw new client quotas");
        return var7_13;
    }

    public static final /* synthetic */ void $anonfun$testClientQuotas$5(Admin admin$1, ObjectRef filter$2, ClientQuotaEntity entity$2, ClientQuotaEntity entity2$1) {
        java.util.Map results = (java.util.Map)admin$1.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity$2)).get("producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity2$1)).get("producer_byte_rate")), (double)1.0E-6);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id())).socketServer().boundPort(cluster.nodes().externalListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)new StringBuilder(16).append("advertised-host-").append(broker.id()).toString(), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final scala.collection.immutable.Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$6) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$6.brokers().values()).asScala().toSeq().filter((Function1 & Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$waitForRunningBrokers$2(KafkaClusterTestKit cluster$6) {
        return KRaftClusterTest.getRunningBrokerServers$1(cluster$6);
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$2) {
        return ((java.util.Map)admin$2.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$2, ObjectRef currentMapping$1, scala.collection.immutable.Seq expectedMapping$1) {
        java.util.Map topicInfoMap = (java.util.Map)admin$2.describeTopics(Collections.singleton("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((scala.collection.immutable.Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(scala.collection.immutable.Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return new StringBuilder(57).append("Timed out waiting for replica assignments for topic foo. ").append(new StringBuilder(15).append("Wanted: ").append(expectedMapping$1).append(". Got: ").append((scala.collection.immutable.Seq)currentMapping$1.elem).toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$6) {
        if (x$6 != null) {
            boolean isHosted = x$6._1$mcZ$sp();
            int partitionId = x$6._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$7, Tuple2 x$7) {
        if (x$7 != null) {
            int brokerId = x$7._1$mcI$sp();
            List partitionsIsHosted = (List)x$7._2();
            BrokerServer broker = cluster$7.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((IterableOps)partitionsIsHosted.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$6 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$6);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$3, HashSet topicsNotFound$1, ObjectRef extraTopics$1, scala.collection.immutable.Seq expectedAbsent$1) {
        ((Iterable)admin$3.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin$3.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$10)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)topicsNotFound$1).asScala()).append(" and NOT find topic(s): ").append((scala.collection.mutable.Set)extraTopics$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$4, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$1, boolean exhaustive$1) {
        try {
            java.util.Map values = admin$4.describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).values();
            results$1.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq pairs = (scala.collection.immutable.Seq)x0$1._2();
                Config config = (Config)((KafkaFuture)values.get(resource)).get();
                TreeMap actual = new TreeMap();
                TreeMap expected = new TreeMap();
                config.entries().forEach(x0$2 -> {
                    actual.put(x0$2.name(), x0$2.value());
                    if (!exhaustive$1) {
                        expected.put(x0$2.name(), x0$2.value());
                        return;
                    }
                });
                pairs.foreach((Function1 & Serializable)x0$3 -> {
                    if (x0$3 == null) {
                        throw new MatchError(null);
                    }
                    String k = (String)x0$3._1();
                    String v = (String)x0$3._2();
                    String string = expected.put(k, v);
                    return string;
                });
                Assertions.assertEquals(expected, actual);
                Option option = results$1.put((Object)resource, actual);
                return option;
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn(new StringBuilder(27).append("Unable to describeConfigs(").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).append(")").toString(), t);
            throw t;
        }
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(scala.collection.immutable.Seq x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

