/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.Server$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\n\u0014\u0001aA\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\to\u0001\u0011\t\u0011)A\u0005K!A\u0001\b\u0001BA\u0002\u0013\u0005\u0011\b\u0003\u0005>\u0001\t\u0005\r\u0011\"\u0001?\u0011!!\u0005A!A!B\u0013Q\u0004\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\t\u0011=\u0003!\u0011!Q\u0001\n\u001dC\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\to\u0002\u0011\t\u0011)A\u0005%\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005u\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0015\u0005]\u0001A!A!\u0002\u0013\tY\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA/\u0001\u0011\u0005\u00111\f\u0002\u001a\u0017J\u000bg\r^)v_J,X.S7qY\u0016lWM\u001c;bi&|gN\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\nS\"A\n\n\u0005\t\u001a\"\u0001F)v_J,X.S7qY\u0016lWM\u001c;bi&|g.A\u0006sC\u001a$X*\u00198bO\u0016\u0014X#A\u0013\u0011\u0007\u0019J3&D\u0001(\u0015\tAS#\u0001\u0003sC\u001a$\u0018B\u0001\u0016(\u0005AY\u0015MZ6b%\u00064G/T1oC\u001e,'\u000f\u0005\u0002-k5\tQF\u0003\u0002/_\u000511m\\7n_:T!\u0001\u0006\u0019\u000b\u0005Y\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!AN\u0017\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!\u0003A\u0019wN\u001c;s_2dWM]*feZ,'/F\u0001;!\t\u00013(\u0003\u0002='\t\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\u0015G>tGO]8mY\u0016\u00148+\u001a:wKJ|F%Z9\u0015\u0005}\u0012\u0005C\u0001\u000eA\u0013\t\t5D\u0001\u0003V]&$\bbB\"\u0005\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0014!E2p]R\u0014x\u000e\u001c7feN+'O^3sA\u0005YQ.\u001a;bI\u0006$\u0018\rR5s+\u00059\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\tIwNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%\u0001\u0002$jY\u0016\fA\"\\3uC\u0012\fG/\u0019#je\u0002\nAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-F\u0001S!\r\u0019\u0006LW\u0007\u0002)*\u0011QKV\u0001\u000bG>t7-\u001e:sK:$(BA,L\u0003\u0011)H/\u001b7\n\u0005e#&!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!1\f\u00180e\u001b\u00051\u0016BA/W\u0005\ri\u0015\r\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C.\u000bA\u0001\\1oO&\u00111\r\u0019\u0002\b\u0013:$XmZ3s!\t)GO\u0004\u0002gc:\u0011q\r\u001d\b\u0003Q>t!!\u001b8\u000f\u0005)lW\"A6\u000b\u00051<\u0012A\u0002\u001fs_>$h(C\u00015\u0013\t\u00114'\u0003\u0002\u0017c%\u0011\u0001\u0006M\u0005\u0003eN\f!BU1gi\u000e{gNZ5h\u0015\tA\u0003'\u0003\u0002vm\nY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\t\u00118/A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003%\u0019G.^:uKJLE-F\u0001{!\tYxP\u0004\u0002}{B\u0011!nG\u0005\u0003}n\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@\u001c\u0003)\u0019G.^:uKJLE\rI\u0001\u0004Y><WCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t+\u0005)Q\u000f^5mg&!\u0011QCA\b\u0005\u001daunZ4j]\u001e\fA\u0001\\8hA\u00051A(\u001b8jiz\"b\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0003O\tI\u0003\u0005\u0002!\u0001!)1E\u0004a\u0001K!)\u0001H\u0004a\u0001u!)QI\u0004a\u0001\u000f\")\u0001K\u0004a\u0001%\")\u0001P\u0004a\u0001u\"9\u0011q\u0001\bA\u0002\u0005-\u0011\u0001D2sK\u0006$XM\u0011:pW\u0016\u0014H\u0003CA\u0018\u0003k\ty$a\u0014\u0011\u0007\u0001\n\t$C\u0002\u00024M\u00111bS1gW\u0006\u0014%o\\6fe\"9\u0011qG\bA\u0002\u0005e\u0012AB2p]\u001aLw\rE\u0002!\u0003wI1!!\u0010\u0014\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\u0005\u0005s\u00021\u0001\u0002D\u0005!A/[7f!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#\u0002BA\t\u0003\u0013R!A\f\u0019\n\t\u00055\u0013q\t\u0002\u0005)&lW\rC\u0004\u0002R=\u0001\r!a\u0015\u0002\u000fM$\u0018M\u001d;vaB\u0019!$!\u0016\n\u0007\u0005]3DA\u0004C_>dW-\u00198\u0002\u0011MDW\u000f\u001e3po:$\u0012aP\u0001\u0012e\u0016\u001cH/\u0019:u\u0007>tGO]8mY\u0016\u0014\b")
public class KRaftQuorumImplementation
implements QuorumImplementation {
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private ControllerServer controllerServer;
    private final File metadataDir;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final String clusterId;
    private final Logging log;

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public ControllerServer controllerServer() {
        return this.controllerServer;
    }

    public void controllerServer_$eq(ControllerServer x$1) {
        this.controllerServer = x$1;
    }

    public File metadataDir() {
        return this.metadataDir;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Logging log() {
        return this.log;
    }

    @Override
    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup) {
        BrokerServer broker = new BrokerServer(config, new MetaProperties(this.clusterId(), config.nodeId()), this.raftManager(), (Option)None$.MODULE$, time, Server$.MODULE$.initializeMetrics(config, time, this.clusterId()), (Option)new Some((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Broker%02d_"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.nodeId())}))), (Seq)Nil$.MODULE$, this.controllerQuorumVotersFuture(), (Option)None$.MODULE$);
        if (startup) {
            broker.startup();
        }
        return broker;
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this.log(), Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.controllerServer().shutdown(), this.log(), Level.WARN);
    }

    public void restartController() {
        int prevPort = ((RaftConfig.InetAddressSpec)this.controllerQuorumVotersFuture().get().get((Object)BoxesRunTime.boxToInteger((int)1000))).address.getPort();
        this.log().info((Function0 & Serializable)() -> "Restarting the KRaft-based controller");
        this.controllerServer().shutdown();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.controllerServer().config().originals());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(prevPort).toString());
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append("1000@localhost:").append(prevPort).toString());
        this.log().info((Function0 & Serializable)() -> new StringBuilder(58).append("Setting KRaft-based controller port to ").append(prevPort).append(" as part of restart").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        ControllerServer newControllerServer = new ControllerServer(this.controllerServer().metaProperties(), config, this.raftManager(), this.controllerServer().clusterBalanceManager(), Time.SYSTEM, new Metrics(), this.controllerServer().threadNamePrefix(), this.controllerQuorumVotersFuture(), KafkaRaftServer$.MODULE$.configSchema(), (Option)None$.MODULE$);
        this.controllerServer_$eq(newControllerServer);
        newControllerServer.startup();
    }

    public KRaftQuorumImplementation(KafkaRaftManager<ApiMessageAndVersion> raftManager, ControllerServer controllerServer, File metadataDir, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, String clusterId, Logging log) {
        this.raftManager = raftManager;
        this.controllerServer = controllerServer;
        this.metadataDir = metadataDir;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.clusterId = clusterId;
        this.log = log;
    }
}

