/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkIsrManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004.\u0001\u0001\u0006I!\t\u0005\u0006]\u0001!\te\f\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006\u001d\u0002!\t!\u0013\u0005\u0006'\u0002!\t!\u0013\u0005\u0006+\u0002!IA\u0016\u0005\u0006O\u0002!\t!\u0013\u0005\u0006S\u0002!\t!\u0013\u0005\u0006W\u0002!\t!\u0013\u0005\u0006[\u0002!\t!\u0013\u0005\u0006_\u0002!\t!\u0013\u0005\u0006c\u0002!\t!\u0013\u0005\u0006g\u0002!\t!\u0013\u0005\u0006k\u0002!\tA\u001e\u0002\u0010\u0017\u000647.Y*feZ,'\u000fV3ti*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002%%\u00111D\u0005\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001f!\tI\u0002!\u0001\u0004fq&$X\rZ\u000b\u0002CA\u0011!eK\u0007\u0002G)\u0011A%J\u0001\u0007CR|W.[2\u000b\u0005\u0019:\u0013AC2p]\u000e,(O]3oi*\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051\u001a#!D!u_6L7MQ8pY\u0016\fg.A\u0004fq&$X\r\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$\u0001B+oSRDQa\u000e\u0003A\u0002a\n\u0001\u0002^3ti&sgm\u001c\t\u0003s\tk\u0011A\u000f\u0006\u0003wq\n1!\u00199j\u0015\tid(A\u0004kkBLG/\u001a:\u000b\u0005}\u0002\u0015!\u00026v]&$(\"A!\u0002\u0007=\u0014x-\u0003\u0002Du\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0005\u000bB\u0011\u0011HR\u0005\u0003\u000fj\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001\u0019)\u0005\u0015Y\u0005CA\u001dM\u0013\ti%HA\u0005BMR,'/R1dQ\u0006aA/Z:u'\",H\u000fZ8x]\"\u0012a\u0001\u0015\t\u0003sEK!A\u0015\u001e\u0003\tQ+7\u000f^\u0001(i\u0016\u001cH\u000fV<p\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\\\"bY2,\u00050\u001b;Uo&\u001cW\r\u000b\u0002\b!\u0006YQ.\u001a;sS\u000e4\u0016\r\\;f)\t9&\f\u0005\u000221&\u0011\u0011L\r\u0002\u0005\u0019>tw\rC\u0003\\\u0011\u0001\u0007A,\u0001\u0003oC6,\u0007CA/e\u001d\tq&\r\u0005\u0002`e5\t\u0001M\u0003\u0002b-\u00051AH]8pizJ!a\u0019\u001a\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GJ\n\u0001\u0006^3ti\u0006c'/Z1esJ+w-[:uKJ,G-\u00113wKJ$\u0018n]3e\u0019&\u001cH/\u001a8feND#!\u0003)\u0002SQ,7\u000f^\"sK\u0006$Xm\u001d)s_B,'OW6D_:4\u0017nZ,iK:\u001c\u0016m\u001d7ESN\f'\r\\3eQ\tQ\u0001+\u0001\u0015uKN$8I]3bi\u0016\u001c\bK]8qKJT6\u000e\u00167t\u0007>tg-[4XQ\u0016tG)[:bE2,G\r\u000b\u0002\f!\u0006QC/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w+\u001b;i)J,XMV1mk\u0016\u001c\bF\u0001\u0007Q\u0003I\"Xm\u001d;De\u0016\fG/Z:Qe>\u0004XM\u001d.l)2\u001c8i\u001c8gS\u001e<\u0016\u000e\u001e5GC2\u001cX-\u00118e\u0019&\u001cHOV1mk\u0016\u001c\bFA\u0007Q\u0003A!Xm\u001d;[W&\u001b(/T1oC\u001e,'\u000f\u000b\u0002\u000f!\u0006\u0019B/Z:u\u00032$XM]%te6\u000bg.Y4fe\"\u0012q\u0002U\u0001\rGJ,\u0017\r^3TKJ4XM\u001d\u000b\u0006oj|\u00181\u0001\t\u00033aL!!\u001f\n\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\u0006wB\u0001\r\u0001`\u0001\u0007]>$W-\u00133\u0011\u0005Ej\u0018B\u0001@3\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u0003\u0001\u0002\u0019\u0001/\u0002\u0011!|7\u000f\u001e(b[\u0016Da!!\u0002\u0011\u0001\u0004a\u0018\u0001\u00029peR\u0004")
public class KafkaServerTest
extends QuorumTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
        Exit.setExitProcedure((x$1, x$2) -> {
            this.exited().set(true);
            throw new Exception();
        });
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    @Test
    public void testShutdown() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), Time.SYSTEM, (Option)None$.MODULE$, false);
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        KafkaServer$.MODULE$.initiateShutdown().join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)1L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)1L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    @Test
    public void testTwoConsecutiveShutdownCallExitTwice() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), Time.SYSTEM, (Option)None$.MODULE$, false);
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        Thread th1 = KafkaServer$.MODULE$.initiateShutdown();
        Thread th2 = KafkaServer$.MODULE$.initiateShutdown();
        th1.join();
        th2.join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)2L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)2L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    private long metricValue(String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTest.$anonfun$metricValue$1(name, x$3)))).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(22).append("Could not find metric ").append(name).toString());
        })).value());
    }

    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, SecurityProtocol.PLAINTEXT)));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})), true);
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManager() {
        void createServer_time;
        void createServer_config;
        Time time;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time3 = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        if (!(server.replicaManager().alterIsrManager() instanceof ZkIsrManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterIsrManager() {
        void createServer_time;
        void createServer_config;
        Time time;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time3 = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        if (!(server.replicaManager().alterIsrManager() instanceof DefaultAlterIsrManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(int nodeId, String hostName, int port) {
        void createServer_time;
        Time time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, Tuple2 x$3) {
        String string = ((MetricName)x$3._1()).getName();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "HTTPS" : someValue$1;
        }
        return string;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "true" : someValue$1;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "false";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

