/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000514A\u0001E\t\u0001-!)1\u0004\u0001C\u00019!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0014\u0001A\u0003%\u0001\u0005C\u0004(\u0001\t\u0007I\u0011A\u0010\t\r!\u0002\u0001\u0015!\u0003!\u0011\u001dI\u0003\u00011A\u0005\u0002)BqA\u000f\u0001A\u0002\u0013\u00051\b\u0003\u0004B\u0001\u0001\u0006Ka\u000b\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0011\u001d9\u0005\u00011A\u0005\u0002!CaA\u0013\u0001!B\u0013!\u0005\"B&\u0001\t\u0003b\u0005\"B0\u0001\t\u0003\u0002\u0007\"B3\u0001\t\u0003\u0001\u0007\"\u00026\u0001\t\u0003\u0001'A\u0005'fC\u0012,'/\u00127fGRLwN\u001c+fgRT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003EI!AG\t\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\nEJ|7.\u001a:JIF*\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0004\u0013:$\u0018A\u00032s_.,'/\u001332A\u0005I!M]8lKJLEMM\u0001\u000bEJ|7.\u001a:JIJ\u0002\u0013aB:feZ,'o]\u000b\u0002WA\u0019A\u0006N\u001c\u000f\u00055\u0012dB\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0016\u0003\u0019a$o\\8u}%\t1%\u0003\u00024E\u00059\u0001/Y2lC\u001e,\u0017BA\u001b7\u0005\r\u0019V-\u001d\u0006\u0003g\t\u0002\"\u0001\u0007\u001d\n\u0005e\n\"aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011Ah\u0010\t\u0003CuJ!A\u0010\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u001e\t\t\u00111\u0001,\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005a2\u000f^1mK\u000e{g\u000e\u001e:pY2,'/\u00129pG\"$U\r^3di\u0016$W#\u0001#\u0011\u0005\u0005*\u0015B\u0001$#\u0005\u001d\u0011un\u001c7fC:\f\u0001e\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eDG)\u001a;fGR,Gm\u0018\u0013fcR\u0011A(\u0013\u0005\b\u0001*\t\t\u00111\u0001E\u0003u\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012\u0004\u0013!B:fiV\u0003HC\u0001\u001fN\u0011\u0015qE\u00021\u0001P\u0003!!Xm\u001d;J]\u001a|\u0007C\u0001)Z\u001b\u0005\t&B\u0001*T\u0003\r\t\u0007/\u001b\u0006\u0003)V\u000bqA[;qSR,'O\u0003\u0002W/\u0006)!.\u001e8ji*\t\u0001,A\u0002pe\u001eL!AW)\u0003\u0011Q+7\u000f^%oM>D#\u0001\u0004/\u0011\u0005Ak\u0016B\u00010R\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\tA\b\u000b\u0002\u000eEB\u0011\u0001kY\u0005\u0003IF\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f\u001e'fC\u0012,'/\u00127fGRLwN\\!oI\u0016\u0003xn\u00195)\u000599\u0007C\u0001)i\u0013\tI\u0017K\u0001\u0003UKN$\u0018A\u000b;fgRdU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5Ti\u0006dWmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0015\u0003\u001f\u001d\u0004")
public class LeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private scala.collection.immutable.Seq<KafkaServer> servers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private boolean staleControllerEpochDetected = false;

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public scala.collection.immutable.Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        KafkaServer kafkaServer;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer2;
        Time time;
        KafkaServer kafkaServer3;
        void createServer_time2;
        void createServer_config2;
        KafkaServer kafkaServer4;
        Time time2;
        super.setUp(testInfo);
        Properties configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Properties configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        configProps1.put("unclean.leader.election.enable", "true");
        configProps2.put("unclean.leader.election.enable", "true");
        Time time3 = time2 = Time.SYSTEM;
        time2 = null;
        Time time4 = time3;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(configProps1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        KafkaServer kafkaServer5 = kafkaServer4 = createServer_this.createServer((KafkaConfig)createServer_config2, (Time)createServer_time2, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        Object var9_8 = null;
        kafkaServer4 = null;
        KafkaServer kafkaServer6 = kafkaServer3 = kafkaServer5;
        Object var6_7 = null;
        kafkaConfig = null;
        time4 = null;
        kafkaServer3 = null;
        KafkaServer server1 = kafkaServer6;
        Time time5 = time = Time.SYSTEM;
        time = null;
        Time time6 = time5;
        KafkaConfig kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(configProps2);
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix2 = None$.MODULE$;
        KafkaServer kafkaServer7 = kafkaServer2 = createServer_this2.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix2, 1, true);
        Object var15_16 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer8 = kafkaServer = kafkaServer7;
        Object var12_15 = null;
        kafkaConfig2 = null;
        time6 = null;
        kafkaServer = null;
        KafkaServer server2 = kafkaServer8;
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.servers().$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})))));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionAndEpoch() {
        void var7_12;
        None$ none$;
        Tuple2 tuple2;
        String topic = "new-topic";
        int partitionId = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(topicPartition).get());
        Assertions.assertTrue((leader1 == 0 ? 1 : 0) != 0, (String)"Leader should be broker 0");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        ((KafkaServer)this.servers().head()).shutdown();
        long l = 15000L;
        long l2 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$1(this, topicPartition)).exists((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 == 1)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple22 = tuple2;
        Object var15_9 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Option leader2 = (Option)tuple23._1();
        int leaderEpoch2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)(leaderEpoch1 + 2), (int)leaderEpoch2, (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Second epoch value should be %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 2))})));
        ((KafkaServer)this.servers().head()).startup();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$4(this, topic, partitionId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l3) {
                Assertions.fail((String)"Inconsistent metadata after second broker startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        ((KafkaServer)this.servers().last()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        KafkaZkClient x$1 = this.zkClient();
        long l5 = 30000L;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$6 = none$2;
        int leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, topic, partitionId, l5, (Option<Object>)var7_12, (Option<Object>)x$6);
        int leaderEpoch3 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)0, (int)leader3, (String)"Leader must return to 0");
        Assertions.assertEquals((int)(leaderEpoch2 + 2), (int)leaderEpoch3, (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Second epoch value should be %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 2))})));
    }

    @Test
    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("leader Epoch: ").append(leaderEpoch1).toString());
        this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Leader is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leader1)})));
        Assertions.assertTrue((leader1 == 0 || leader1 == 1 ? 1 : 0) != 0, (String)"Leader could be broker 0 or broker 1");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        int controllerId = 2;
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((IterableOnceOps)this.servers().map((Function1 & Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaBroker)s, SecurityProtocol.PLAINTEXT), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable)x$4 -> x$4.node(listenerName));
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokers((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
        controllerChannelManager.startup();
        try {
            int staleControllerEpoch = 0;
            LeaderAndIsrBatch batch = new LeaderAndIsrBatch(this.brokerId2()).setControllerId(controllerId).setControllerEpoch(staleControllerEpoch).setBrokerEpoch(((KafkaServer)this.servers().apply(this.brokerId2())).kafkaController().brokerEpoch()).addPartitionState(new TopicPartition(topic, partitionId), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic).setPartitionIndex(partitionId).setControllerEpoch(2).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setIsNew(false)).addLiveLeaders(nodes.toSet()).addTopicId(topic, Uuid.randomUuid());
            BooleanRef staleControllerEpochDetected = BooleanRef.create((boolean)false);
            controllerChannelManager.sendControlMetadataBatch(this.brokerId2(), (ControlMetadataBatch)batch, (Function2 & Serializable)(x$5, result) -> {
                LeaderElectionTest.$anonfun$testLeaderElectionWithStaleControllerEpoch$7(staleControllerEpochDetected, x$5, result);
                return BoxedUnit.UNIT;
            });
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!staleControllerEpochDetected.elem) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller epoch should be stale");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            Assertions.assertTrue((boolean)staleControllerEpochDetected.elem, (String)"Stale controller epoch not detected by the broker");
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    public static final /* synthetic */ Option $anonfun$testLeaderElectionAndEpoch$1(LeaderElectionTest $this, TopicPartition topicPartition$1) {
        return $this.zkClient().getLeaderForPartition(topicPartition$1);
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$5(UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.isr().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$4(LeaderElectionTest $this, String topic$1, int partitionId$1) {
        return ((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo(topic$1, partitionId$1).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$5(x$3)));
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionAndEpoch$6() {
        return "Inconsistent metadata after second broker startup";
    }

    public static final /* synthetic */ void $anonfun$testLeaderElectionWithStaleControllerEpoch$7(BooleanRef staleControllerEpochDetected$1, ControlMetadataBatch x$5, ControlMetadataBatchResult result) {
        Errors error;
        Errors errors = error = (Errors)result.responses().foldLeft((Object)Errors.NONE, (Function2 & Serializable)(x$6, response) -> response.error());
        Errors errors2 = Errors.STALE_CONTROLLER_EPOCH;
        staleControllerEpochDetected$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionWithStaleControllerEpoch$9(BooleanRef staleControllerEpochDetected$1) {
        return staleControllerEpochDetected$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionWithStaleControllerEpoch$10() {
        return "Controller epoch should be stale";
    }

    public LeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }

    public static final /* synthetic */ Object $anonfun$testLeaderElectionAndEpoch$2$adapted(Option x$1) {
        return BoxesRunTime.boxToBoolean((boolean)x$1.exists((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 == 1));
    }
}

