/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr$;
import kafka.common.TenantHelpers;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class MetadataCacheTest$ {
    public static final MetadataCacheTest$ MODULE$ = new MetadataCacheTest$();

    public Stream<MetadataCache> zkCacheProvider() {
        boolean bl = false;
        int zkMetadataCache_brokerId = 1;
        return Stream.of(new ZkMetadataCache(zkMetadataCache_brokerId, bl));
    }

    public Stream<MetadataCache> cacheProvider() {
        MetadataCache[] metadataCacheArray = new MetadataCache[2];
        boolean bl = false;
        int zkMetadataCache_brokerId = 1;
        metadataCacheArray[0] = new ZkMetadataCache(zkMetadataCache_brokerId, bl);
        int kRaftMetadataCache_brokerId = 1;
        metadataCacheArray[1] = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        return Stream.of(metadataCacheArray);
    }

    public Stream<MetadataCache> multiTenantCacheProvider() {
        MetadataCache[] metadataCacheArray = new MetadataCache[2];
        boolean zkMetadataCache_isMultiTenant = true;
        int zkMetadataCache_brokerId = 1;
        metadataCacheArray[0] = new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_isMultiTenant);
        int kRaftMetadataCache_brokerId = 1;
        metadataCacheArray[1] = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        return Stream.of(metadataCacheArray);
    }

    public void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        if (cache instanceof ZkMetadataCache) {
            ((ZkMetadataCache)cache).updateMetadata(0, request);
            return;
        }
        if (cache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)cache;
            MetadataImage image = kRaftMetadataCache.currentImage();
            MetadataImage partialImage = new MetadataImage(new OffsetAndEpoch(100L, 10), image.features(), ClusterImage.EMPTY, image.topics(), image.configs(), image.clientQuotas(), image.producerIds(), image.acls(), image.clusterLinks(), image.brokerReplicaExclusions(), (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
            MetadataDelta delta = new MetadataDelta(partialImage, TenantHelpers.NAME_TO_TENANT_CALLBACK, new MetadataEncryptorFactory(Collections.emptyMap()));
            CollectionConverters$.MODULE$.IteratorHasAsScala(request.liveBrokers().iterator()).asScala().foreach((Function1 & Serializable)brokerInfo -> {
                delta.replay(100L, 10, (ApiMessage)MetadataCacheTest$.toRecord$1(brokerInfo, image));
                return BoxedUnit.UNIT;
            });
            request.topicStates().forEach(topic -> MetadataCacheTest$.toRecords$1(topic).foreach((Function1 & Serializable)x$2 -> {
                delta.replay(100L, 10, x$2);
                return BoxedUnit.UNIT;
            }));
            kRaftMetadataCache.setImage(delta.apply());
            return;
        }
        throw new RuntimeException("Unsupported cache type");
    }

    private static final RegisterBrokerRecord toRecord$1(UpdateMetadataRequestData.UpdateMetadataBroker broker, MetadataImage image$1) {
        long l;
        Uuid uuid;
        boolean bl;
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        broker.endpoints().forEach(e -> endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(e.listener()).setHost(e.host()).setPort(e.port()).setSecurityProtocol(e.securityProtocol())));
        Option prevBroker = Option$.MODULE$.apply((Object)image$1.cluster().broker(broker.id()));
        if (None$.MODULE$.equals(prevBroker)) {
            bl = false;
            uuid = Uuid.ZERO_UUID;
            l = 0L;
        } else if (prevBroker instanceof Some) {
            BrokerRegistration b = (BrokerRegistration)((Some)prevBroker).value();
            bl = b.fenced();
            uuid = b.incarnationId();
            l = b.epoch();
        } else {
            throw new MatchError((Object)prevBroker);
        }
        return new RegisterBrokerRecord().setBrokerId(broker.id()).setBrokerEpoch(l).setIncarnationId(uuid).setEndPoints(endpoints).setRack(broker.rack()).setFenced(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq toRecords$1(UpdateMetadataRequestData.UpdateMetadataTopicState topic) {
        void var1_1;
        ArrayBuffer results = new ArrayBuffer();
        HashSet deletedTopicIds = new HashSet();
        results.$plus$eq((Object)new TopicRecord().setName(topic.topicName()).setTopicId(topic.topicId()));
        topic.partitionStates().forEach(partition -> {
            if (partition.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                if (deletedTopicIds.add(topic.topicId())) {
                    results.$plus$eq((Object)new RemoveTopicRecord().setTopicId(topic.topicId()));
                    return;
                }
            } else {
                results.$plus$eq((Object)new PartitionRecord().setPartitionId(partition.partitionIndex()).setTopicId(topic.topicId()).setReplicas(partition.replicas()).setIsr(partition.isr()).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(partition.leader()).setLeaderEpoch(partition.leaderEpoch()).setPartitionEpoch(partition.zkVersion()));
            }
        });
        return var1_1;
    }

    private MetadataCacheTest$() {
    }
}

