/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.Processor$;
import kafka.server.ProcessorQueueSizePercentiles$;
import kafka.server.QueueSizePercentiles;
import kafka.server.RequestQueueSizePercentiles$;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00054Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!I\u0001\u0005\u0001a\u0001\u0002\u0004%I!\t\u0005\n_\u0001\u0001\r\u00111A\u0005\nAB\u0011B\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0012\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0013A\u0004\"\u0003 \u0001\u0001\u0004\u0005\r\u0011\"\u0003@\u0011%\t\u0005\u00011A\u0001B\u0003&\u0011\bC\u0003C\u0001\u0011\u00051\tC\u0003P\u0001\u0011\u00051\tC\u0003U\u0001\u0011\u00051\tC\u0003Z\u0001\u0011\u00051\tC\u0003\\\u0001\u0011\u00051\tC\u0003^\u0001\u0011\u00051\tC\u0003`\u0001\u0011\u00051I\u0001\rRk\u0016,XmU5{KB+'oY3oi&dWm\u001d+fgRT!!\u0005\n\u0002\rM,'O^3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0011\u0003\u0011!\u0018.\\3\u0016\u0003\t\u0002\"aI\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u001dB\u0013AB2p[6|gN\u0003\u0002\u0014S)\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0013\tqCE\u0001\u0005N_\u000e\\G+[7f\u0003!!\u0018.\\3`I\u0015\fHCA\u00195!\t9\"'\u0003\u000241\t!QK\\5u\u0011\u001d)4!!AA\u0002\t\n1\u0001\u001f\u00132\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012!\u000f\t\u0003uqj\u0011a\u000f\u0006\u0003o\u0019J!!P\u001e\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\t\t\u0004\tC\u00046\r\u0005\u0005\t\u0019A\u001d\u0002\u00115,GO]5dg\u0002\nABY3g_J,W*\u001a;i_\u0012$\u0012!\r\u0015\u0003\u0011\u0015\u0003\"AR'\u000e\u0003\u001dS!\u0001S%\u0002\u0007\u0005\u0004\u0018N\u0003\u0002K\u0017\u00069!.\u001e9ji\u0016\u0014(B\u0001',\u0003\u0015QWO\\5u\u0013\tquI\u0001\u0006CK\u001a|'/Z#bG\"\f1\"\u00194uKJlU\r\u001e5pI\"\u0012\u0011\"\u0015\t\u0003\rJK!aU$\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0007;fgR\fV/Z;f'&TX\rU3sG\u0016tG/\u001b7fg\"\u0012!B\u0016\t\u0003\r^K!\u0001W$\u0003\tQ+7\u000f^\u0001 i\u0016\u001cH/U;fk\u0016\u001c\u0016N_3QKJ\u001cWM\u001c;jY\u0016\u001cX\u000b\u001d+p\u001b\u0006D\bFA\u0006W\u0003\u0001\"Xm\u001d;Rk\u0016,XmU5{KB+'oY3oi&dWm\u001d,bY&$\u0017\u000e^=)\u000511\u0016a\b;fgR\fV/Z;f'&TX-T3ue&\u001c7OS7y\u000bb\u0004xN\u001d;fI\"\u0012QBV\u0001\u001ei\u0016\u001cH\u000f\u0015:pG\u0016\u001c8o\u001c:Rk\u0016,XmU5{K6+GO]5dg\"\u0012aB\u0016")
public class QueueSizePercentilesTest {
    private MockTime time;
    private Metrics metrics;

    private MockTime time() {
        return this.time;
    }

    private void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    @BeforeEach
    public void beforeMethod() {
        this.time_$eq(new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig().timeWindow(1L, TimeUnit.SECONDS), Collections.emptyList(), (Time)this.time()));
    }

    @AfterEach
    public void afterMethod() {
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQueueSizePercentiles() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        Percentiles percentiles;
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = 500;
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        Object var3_6 = null;
        metrics = null;
        string = null;
        map = null;
        percentiles = null;
        Percentiles queueSizePercentiles = percentiles2;
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)queueSizePercentiles, null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record((double)(i % 100)));
        Assertions.assertEquals((double)90.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p90", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
        Assertions.assertEquals((double)95.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p95", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
        Assertions.assertEquals((double)98.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p98", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
        Assertions.assertEquals((double)99.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p99", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQueueSizePercentilesUpToMax() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        Percentiles percentiles;
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = 500;
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        Object var3_6 = null;
        metrics = null;
        string = null;
        map = null;
        percentiles = null;
        Percentiles queueSizePercentiles = percentiles2;
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)queueSizePercentiles, null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record((double)(i % 500)));
        Assertions.assertEquals((double)450.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p90", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
        Assertions.assertEquals((double)475.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p95", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
        Assertions.assertEquals((double)490.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p98", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
        Assertions.assertEquals((double)495.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p99", (Map)QueueSizePercentiles.dataPlaneQueueSize$default$3$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$)), (double)1.0);
    }

    @Test
    public void testQueueSizePercentilesValidity() {
        Assertions.assertTrue((boolean)QueueSizePercentiles.valid$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (String)"p90"), (String)"Expected `p90` to be a valid percentile");
        Assertions.assertTrue((boolean)QueueSizePercentiles.valid$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (String)"p95"), (String)"Expected `p95` to be a valid percentile");
        Assertions.assertTrue((boolean)QueueSizePercentiles.valid$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (String)"p98"), (String)"Expected `p98` to be a valid percentile");
        Assertions.assertTrue((boolean)QueueSizePercentiles.valid$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (String)"p99"), (String)"Expected `p99` to be a valid percentile");
        Assertions.assertFalse((boolean)QueueSizePercentiles.valid$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (String)"p91"), (String)"Expected `p91` to be an invalid percentile");
        Assertions.assertFalse((boolean)QueueSizePercentiles.valid$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$, (String)"90"), (String)"Expected `90` to be an invalid percentile");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQueueSizeMetricsJmxExported() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        Percentiles percentiles;
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = 500;
        Metrics createPercentiles_metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        Object var2_5 = null;
        Object var3_4 = null;
        string = null;
        map = null;
        percentiles = null;
        Percentiles queueSizePercentiles = percentiles2;
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)CollectionConverters$.MODULE$.ListHasAsScala(queueSizePercentiles.stats()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)QueueSizePercentilesTest.$anonfun$testQueueSizeMetricsJmxExported$1(x$3))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessorQueueSizeMetrics() {
        void add_stat;
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        Percentiles percentiles;
        Sensor queueSizeSensor = this.metrics().sensor("ProcessorQueueSize");
        scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)"some-listener")}));
        scala.collection.immutable.Map missingListener = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)"missing-listener")}));
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)"some-listener")}));
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = 20;
        Metrics metrics = this.metrics();
        ProcessorQueueSizePercentiles$ createPercentiles_this = ProcessorQueueSizePercentiles$.MODULE$;
        Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        Object var4_8 = null;
        metrics = null;
        string = null;
        map = null;
        percentiles = null;
        Percentiles percentiles3 = percentiles2;
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)add_stat, null);
        percentiles3 = null;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record((double)(i % 20)));
        Assertions.assertEquals((double)19.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)ProcessorQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p99", (Map)tags), (double)1.0);
        Assertions.assertEquals((double)0.0, (double)QueueSizePercentiles.dataPlaneQueueSize$((QueueSizePercentiles)ProcessorQueueSizePercentiles$.MODULE$, (Metrics)this.metrics(), (String)"p99", (Map)missingListener), (double)0.0);
    }

    public static final /* synthetic */ boolean $anonfun$testQueueSizeMetricsJmxExported$1(CompoundStat.NamedMeasurable x$3) {
        return x$3.name().tags().containsKey("io-confluent-jmx-ignore");
    }
}

