/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.log.MergedLog$;
import kafka.server.AbstractLogReadResult;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.PartitionFetchMetadata;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierReplicaComponents;
import kafka.server.TierReplicaComponents$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001B\u0016-\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004H\u0001\u0001\u0006IA\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019\u0001\u0006\u0001)A\u0005\u0015\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB0\u0001A\u0003%1\u000bC\u0004a\u0001\t\u0007I\u0011A1\t\r\u001d\u0004\u0001\u0015!\u0003c\u0011\u001dA\u0007A1A\u0005\u0002%DaA\u001c\u0001!\u0002\u0013Q\u0007bB8\u0001\u0005\u0004%\t!\u001b\u0005\u0007a\u0002\u0001\u000b\u0011\u00026\t\u000fE\u0004!\u0019!C\u0001e\"1a\u000f\u0001Q\u0001\nMDqa\u001e\u0001C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B=\t\u0013\u0005E\u0001A1A\u0005\u0002\u0005M\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0006\t\u0013\u0005u\u0001A1A\u0005\u0002\u0005M\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0006\t\u0013\u0005\u0005\u0002A1A\u0005\u0002\u0005\r\u0002\u0002CA\u001a\u0001\u0001\u0006I!!\n\t\u0017\u0005U\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0007\u0005\f\u0003+\u0002\u0001\u0019!a\u0001\n\u0003\t9\u0006C\u0006\u0002d\u0001\u0001\r\u0011!Q!\n\u0005e\u0002bCA3\u0001\u0001\u0007\t\u0019!C\u0001\u0003OB1\"a\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002r!Y\u0011Q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA5\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!!%\u0001\t\u0003\tI\bC\u0004\u0002\u0016\u0002!\t!!\u001f\t\u000f\u0005e\u0005\u0001\"\u0001\u0002z!9\u0011Q\u0014\u0001\u0005\u0002\u0005e\u0004bBAQ\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003K\u0003A\u0011AA=\u0011\u001d\tI\u000b\u0001C\u0001\u0003WC\u0011\"!2\u0001#\u0003%\t!a2\t\u0013\u0005u\u0007!%A\u0005\u0002\u0005}\u0007bBAr\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\t9\u0010\u0001C\u0005\u0003s\u0014\u0001DU3qY&\u001c\u0017-T1oC\u001e,'/U;pi\u0006\u001cH+Z:u\u0015\tic&\u0001\u0004tKJ4XM\u001d\u0006\u0002_\u0005)1.\u00194lC\u000e\u00011C\u0001\u00013!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u000f\t\u0003w\u0001i\u0011\u0001L\u0001\bG>tg-[4t+\u0005q\u0004cA C\t6\t\u0001I\u0003\u0002Bi\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\r\u0003%aA*fcB\u00111(R\u0005\u0003\r2\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006A1m\u001c8gS\u001e\u001c\b%\u0001\u0003uS6,W#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055s\u0013!B;uS2\u001c\u0018BA(M\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002'B\u0011A+X\u0007\u0002+*\u0011\u0011K\u0016\u0006\u0003/b\u000baaY8n[>t'BA\u0018Z\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\n\u0005y+&aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u00051!/Z2pe\u0012,\u0012A\u0019\t\u0003G\u0016l\u0011\u0001\u001a\u0006\u0003AZK!A\u001a3\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\u0002\u000fI,7m\u001c:eA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0017'F\u0001k!\tYG.D\u0001W\u0013\tigK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]F\u0002\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]J\u0002\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u0002gB\u00111\u000e^\u0005\u0003kZ\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%\u0001\u0005u_BL7-\u00133t+\u0005I\b#\u0002>\u0000\u0003\u0007\u0019X\"A>\u000b\u0005ql\u0018\u0001B;uS2T\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u00141!T1q!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005{\u0006!A.\u00198h\u0013\u0011\ti!a\u0002\u0003\rM#(/\u001b8h\u0003%!x\u000e]5d\u0013\u0012\u001c\b%A\tu_BL7-\u00133QCJ$\u0018\u000e^5p]F*\"!!\u0006\u0011\u0007-\f9\"C\u0002\u0002\u001aY\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002%Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0007I\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0014\u0014A\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oe\u0001\n\u0011BZ3uG\"LeNZ8\u0016\u0005\u0005\u0015\u0002\u0003B C\u0003O\u0001raMA\u0015\u0003+\ti#C\u0002\u0002,Q\u0012a\u0001V;qY\u0016\u0014\u0004cA\u001e\u00020%\u0019\u0011\u0011\u0007\u0017\u00035\u0019+H\u000e\u001c)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\u0002\u0015\u0019,Go\u00195J]\u001a|\u0007%\u0001\u0007rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002:A!\u00111HA(\u001d\u0011\ti$a\u0013\u000f\t\u0005}\u0012\u0011\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013BA\u0017/\u0013\r\ti\u0005L\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0005\u0003#\n\u0019FA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0004\u0003\u001bb\u0013\u0001E9v_R\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\tI&a\u0018\u0011\u0007M\nY&C\u0002\u0002^Q\u0012A!\u00168ji\"I\u0011\u0011M\r\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0004q\u0012\n\u0014!D9v_R\fW*\u00198bO\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005%\u0004cA\u001e\u0002l%\u0019\u0011Q\u000e\u0017\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\tI&a\u001d\t\u0013\u0005\u0005D$!AA\u0002\u0005%\u0014a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002UMDw.\u001e7e\u000bb\u001cG.\u001e3f'V\u00147/Z9vK:$H\u000b\u001b:piRdW\r\u001a)beRLG/[8ogR\u0011\u0011\u0011\f\u0015\u0004=\u0005u\u0004\u0003BA@\u0003\u001bk!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0004CBL'\u0002BAD\u0003\u0013\u000bqA[;qSR,'OC\u0002\u0002\fn\u000bQA[;oSRLA!a$\u0002\u0002\n!A+Z:u\u0003e\u001a\bn\\;mI\u001e+GOT8NKN\u001c\u0018mZ3t\u0013\u001a\fVo\u001c;bg\u0016C8-Z3eK\u0012|enU;cg\u0016\fX/\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0010\u0002~\u0005\u00113\u000f[8vY\u0012<U\r\u001e\"pi\"lUm]:bO\u0016\u001c\u0018JZ)v_R\f7/\u00117m_^D3\u0001IA?\u0003\u0011\u001a\bn\\;mI&s7\r\\;eK&s7+\u001f8d)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c\bfA\u0011\u0002~\u0005q3\u000f[8vY\u0012Len\u00197vI\u0016$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d$pe\u000e{gn];nKJ4U\r^2iQ\r\u0011\u0013QP\u00010i\u0016\u001cHoQ8na2,G/Z%o\t\u0016d\u0017-_3e\r\u0016$8\r[,ji\"\u0014V\r\u001d7jG\u0006$\u0006N]8ui2Lgn\u001a\u0015\u0004G\u0005u\u0014a\n;fgR\u001cu.\u001c9mKR,\u0017J\u001c#fY\u0006LX\r\u001a$fi\u000eD7i\u001c8tk6,'OR3uG\"D3\u0001JA?\u0003)\u0019X\r^+q\u001b>\u001c7n\u001d\u000b\t\u00033\ni+!/\u0002<\"9\u0011\u0011E\u0013A\u0002\u0005=\u0006\u0003B C\u0003c\u0003raMA\u0015\u0003+\t\u0019\fE\u0002<\u0003kK1!a.-\u0005Y\u0001\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\f\u0007b\u00021&!\u0003\u0005\rA\u0019\u0005\n\u0003{+\u0003\u0013!a\u0001\u0003\u007f\u000b!CY8uQJ+\u0007\u000f\\5dCNLenU=oGB\u00191'!1\n\u0007\u0005\rGGA\u0004C_>dW-\u00198\u0002)M,G/\u00169N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIMK\u0002c\u0003\u0017\\#!!4\u0011\t\u0005=\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002V\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/$\u0014AC1o]>$\u0018\r^5p]&!\u00111\\Ai\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0015g\u0016$X\u000b]'pG.\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005(\u0006BA`\u0003\u0017\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004Q\u0005\u001d\b\u0003BA@\u0003SLA!a;\u0002\u0002\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\n[>\u001c7.U;pi\u0006$\"!!=\u0011\u0007m\n\u00190C\u0002\u0002v2\u0012ABU3qY&\u001c\u0017-U;pi\u0006\f\u0001C]3bI\u001a\u0013x.\u001c'pG\u0006dGj\\4\u0015%\u0005m(Q\u0001B\b\u0005'\u0011iB!\t\u0003&\t%\"Q\u0006\t\u0005\u007f\t\u000bi\u0010E\u00044\u0003S\t)\"a@\u0011\u0007m\u0012\t!C\u0002\u0003\u00041\u0012Q\u0002T8h%\u0016\fGMU3tk2$\bb\u0002B\u0004U\u0001\u0007!\u0011B\u0001\ne\u0016\u0004H.[2b\u0013\u0012\u00042a\rB\u0006\u0013\r\u0011i\u0001\u000e\u0002\u0004\u0013:$\bb\u0002B\tU\u0001\u0007\u0011qX\u0001\u0014M\u0016$8\r[(oYf4%o\\7MK\u0006$WM\u001d\u0005\b\u0005+Q\u0003\u0019\u0001B\f\u000391W\r^2i\u0013N|G.\u0019;j_:\u00042a\u000fB\r\u0013\r\u0011Y\u0002\f\u0002\u000f\r\u0016$8\r[%t_2\fG/[8o\u0011\u001d\u0011yB\u000ba\u0001\u0005\u0013\tQBZ3uG\"l\u0015\r\u001f\"zi\u0016\u001c\bb\u0002B\u0012U\u0001\u0007\u0011qX\u0001\u0012Q\u0006\u0014H-T1y\u0005f$Xm\u001d'j[&$\bb\u0002B\u0014U\u0001\u0007\u0011qV\u0001\u0012e\u0016\fG\rU1si&$\u0018n\u001c8J]\u001a|\u0007b\u0002B\u0016U\u0001\u0007\u0011\u0011_\u0001\u0006cV|G/\u0019\u0005\b\u0005_Q\u0003\u0019\u0001B\u0019\u00039\u0019G.[3oi6+G/\u00193bi\u0006\u0004Ra\rB\u001a\u0005oI1A!\u000e5\u0005\u0019y\u0005\u000f^5p]B!!\u0011\bB \u001b\t\u0011YDC\u0002\u0003>Y\u000bqA]3qY&\u001c\u0017-\u0003\u0003\u0003B\tm\"AD\"mS\u0016tG/T3uC\u0012\fG/\u0019")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
        Properties fromProps_overrides = new Properties();
        return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
    });
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final java.util.Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final Seq<Tuple2<TopicIdPartition, FullPartitionFetchMetadata>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public java.util.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public Seq<Tuple2<TopicIdPartition, FullPartitionFetchMetadata>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala().size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$6))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$7))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((long)0L, (long)this.replicaManager().throttledFollowerReplicasRate().count());
        Assertions.assertEquals((long)2L, (long)this.replicaManager().throttledLeaderReplicasRate().count());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$8))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$9))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicIdPartition, FullPartitionFetchMetadata>> x$1 = this.fetchInfo();
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, true);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq<Tuple2<TopicIdPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$10))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$11))).get())._2()).info().records().batches()).asScala().size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void shouldIncludeThrottledReplicasForConsumerFetch() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        scala.collection.immutable.Map fetch = this.readFromLocalLog(-1, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)fetch.apply((Object)this.topicIdPartition1())).info().records().batches()).asScala().size(), (String)"Replication throttled partitions should return data for consumer fetch");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)fetch.apply((Object)this.topicIdPartition2())).info().records().batches()).asScala().size(), (String)"Replication throttled partitions should return data for consumer fetch");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)this.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)this.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    @Test
    public void testCompleteInDelayedFetchConsumerFetch() {
        Assertions.assertTrue((boolean)this.setupDelayedFetch$2(false).tryComplete(), (String)"Consumer fetch replica should complete if reading from current segment");
        Assertions.assertTrue((boolean)this.setupDelayedFetch$2(true).tryComplete(), (String)"Consumer fetch replica should complete if reading from older segment");
    }

    /*
     * WARNING - void declaration
     */
    public void setUpMocks(Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        TierReplicaComponents tierReplicaComponents;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        None$ none$7;
        None$ none$8;
        None$ none$9;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        ZkMetadataCache zkMetadataCache;
        void withRecords_records;
        void withRecords_timestampType;
        KafkaScheduler scheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenReturn((Object)new LogOffsetMetadata(20L, MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{record};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var30_7 = null;
        simpleRecordArray = null;
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), AdditionalMatchers.geq((int)1), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), false, (Option)None$.MODULE$));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)0), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        boolean bl = false;
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(leaderBrokerId, bl);
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$10 = none$9 = None$.MODULE$;
        none$9 = null;
        None$ x$122 = none$10;
        None$ none$11 = none$8 = None$.MODULE$;
        none$8 = null;
        None$ x$13 = none$11;
        None$ none$12 = none$7 = None$.MODULE$;
        none$7 = null;
        None$ x$14 = none$12;
        None$ none$13 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$15 = none$13;
        None$ none$14 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$16 = none$14;
        None$ none$15 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$17 = none$15;
        TierReplicaComponents tierReplicaComponents2 = tierReplicaComponents = TierReplicaComponents$.MODULE$.EMPTY();
        tierReplicaComponents = null;
        TierReplicaComponents x$18 = tierReplicaComponents2;
        None$ none$16 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$19 = none$16;
        None$ none$17 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$20 = none$17;
        None$ none$18 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$21 = none$18;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$10, x$11, (Option)x$122, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, x$18, (Option)x$19, (Option)x$20, (Option)x$21));
        fetchInfo.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$12 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$13 -> {
            x$13.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota() {
        void var1_1;
        ReplicaQuota quota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return var1_1;
    }

    private Seq<Tuple2<TopicIdPartition, LogReadResult>> readFromLocalLog(int replicaId, boolean fetchOnlyFromLeader, FetchIsolation fetchIsolation, int fetchMaxBytes, boolean hardMaxBytesLimit, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> readPartitionInfo, ReplicaQuota quota, Option<ClientMetadata> clientMetadata) {
        return (Seq)this.replicaManager().readFromLocalLog(replicaId, fetchOnlyFromLeader, fetchIsolation, fetchMaxBytes, hardMaxBytesLimit, readPartitionInfo, quota, clientMetadata).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicIdPartition, AbstractLogReadResult>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicIdPartition topicIdPartition = (TopicIdPartition)x1._1();
                    AbstractLogReadResult result = (AbstractLogReadResult)x1._2();
                    if (result instanceof LogReadResult) {
                        LogReadResult logReadResult = (LogReadResult)result;
                        object = new Tuple2((Object)topicIdPartition, (Object)logReadResult);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicIdPartition, AbstractLogReadResult> x1) {
                boolean bl = x1 != null && (AbstractLogReadResult)x1._2() instanceof LogReadResult;
                return bl;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$10) {
        Object object = x$10._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$11) {
        Object object = x$11._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        TopicPartition tp = new TopicPartition("t1", 0);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tp);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0));
        Mockito.when((Object)partition.getReplica(1)).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(this.topicId(), 50L, 0L, 1, Optional.empty(), Optional.empty());
        TopicIdPartition tidp = new TopicIdPartition(this.topicId(), tp);
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, true, (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tidp), (Object)fetchInfo)})), (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tidp), (Object)new LogOffsetMetadata(50L, 0L, 250))})));
        return new DelayedFetch(null, fetchMetadata, replicaManager, brokerTopicStats){

            public boolean forceComplete() {
                return true;
            }
            {
                None$ x$5 = None$.MODULE$;
                None$ x$8 = None$.MODULE$;
                super(600L, fetchMetadata$1, replicaManager$1, null, (Option)x$8, (Option)x$5, brokerTopicStats$1, null);
            }
        };
    }

    private final DelayedFetch setupDelayedFetch$2(boolean isFetchFromOlderSegment) {
        TopicIdPartition tidp = new TopicIdPartition(this.topicId(), 0, "t1");
        LogOffsetMetadata endOffsetMetadata = isFetchFromOlderSegment ? new LogOffsetMetadata(100L, 0L, 500) : new LogOffsetMetadata(150L, 50L, 500);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tidp.topicPartition());
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(this.topicId(), 50L, 0L, 1, Optional.empty(), Optional.empty());
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, false, -1, true, (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tidp), (Object)fetchInfo)})), (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tidp), (Object)new LogOffsetMetadata(50L, 0L, 250))})));
        return new DelayedFetch(null, fetchMetadata, replicaManager, brokerTopicStats){

            public boolean forceComplete() {
                return true;
            }
            {
                None$ x$5 = None$.MODULE$;
                None$ x$8 = None$.MODULE$;
                super(600L, fetchMetadata$2, replicaManager$2, null, (Option)x$8, (Option)x$5, brokerTopicStats$2, null);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, AbstractLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$12) {
        if (x$12 != null) {
            TopicIdPartition p = (TopicIdPartition)x$12._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), LeaderRecoveryState.RECOVERED, Predef$.MODULE$.Set().empty(), (Option)None$.MODULE$);
            return;
        }
        throw new MatchError(null);
    }
}

